<?php
/**
 * 报表实现类  婚纱销售客资跟进统计表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Tcdj_sales_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1582165770';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $data = input();
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $brandclass_id = $det['brandclass_id'];
        if(empty($brandclass_id)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d 00:00:00', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start = date('Y-m-d 00:00:00', strtotime($start));
        $end = date('Y-m-d 23:59:59', strtotime($end));
        $date = getDates($start, $end);

        $where['is_status'] = 1;
        $where['shop_code'] = $det['shop_code'];
        if($data['consultation_type_id']){
            $where['consultation_type_id'] = intval($data['consultation_type_id']);
        }
        
        // 店下所有的组及组下的人
        $staff = db('c_staff_group')->alias('g')
            ->join('c_staff_group_relation r','g.id=r.group_id','left')
            ->where('g.shop_code',$det['shop_code'])
            ->field('g.group_name,staff_id,staff_name')
            ->select();
        $staffs='';
        foreach ($staff as $key => $value) {
            $staffs .= $value['staff_id'].',';
        }
        $staffs = trim($staffs, ',');
        $where['sales_staff_id'] = array('in',$staffs);
        // 分配客资量
        $info = db('c_customerinfo')
            ->where($where)->where('is_fp','1')->where('fp_day','between',[$start,$end])
            ->group('days,sales_staff_id')
            ->order('days')
            ->field('DATE_FORMAT(fp_day, "%Y-%m-%d") days,count(*) AS num,sales_staff_id,sales_staff,shop_code,shop_name')
            ->select();
        
        $return = [];
        foreach ($date as $key => $value) {
            foreach ($info as $k => $v) {
                if ($value==$v['days']) {
                    $return[$value]['fp_'.$v['sales_staff_id']] = $v['num'];
                }else{
                    $return[$value] = [];
                }
            }
        }
        unset($info);
        // 有效客资量
        $info = db('c_customerinfo')
            ->where($where)->where('is_valid','1')->where('yx_day','between',[$start,$end])
            ->group('days,sales_staff_id')
            ->order('days')
            ->field('DATE_FORMAT(yx_day, "%Y-%m-%d") days,count(*) AS num,sales_staff_id,sales_staff,shop_code,shop_name')
            ->select();
        foreach ($date as $key => $value) {
            foreach ($info as $k => $v) {
                if ($value==$v['days']) {
                    $return[$value]['yx_'.$v['sales_staff_id']] = $v['num'];
                }
            }
        }
        unset($info);
        // 成交客资量
        $info = db('c_customerinfo')
            ->where($where)->where('is_success','1')->where('order_day','between',[$start,$end])
            ->group('days,sales_staff_id')
            ->order('days')
            ->field('DATE_FORMAT(order_day, "%Y-%m-%d") days,count(*) AS num,sales_staff_id,sales_staff,shop_code,shop_name')
            ->select();
        foreach ($date as $key => $value) {
            $return[$value]['day'] = $value;
            foreach ($info as $k => $v) {
                if ($value==$v['days']) {
                    $return[$value]['cj_'.$v['sales_staff_id']] = $v['num'];
                }
            }
        }
        unset($info);
        // var_dump($return);die;
        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        // var_dump($returnData);die;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');

        $groups = db('c_staff_group')->where('shop_code',$info['shop_code'])->select();
        // 店下所有的组及组下的人
        $staffs = db('c_staff_group')->alias('g')
            ->join('c_staff_group_relation r','g.id=r.group_id','left')
            ->where('g.shop_code',$info['shop_code'])
            ->field('g.id,g.group_name,staff_id,staff_name')
            ->select();
        $all = [];
        foreach ($groups as $key => $value) {
            $all[$key]['gid'] = $value['id'];
            $all[$key]['gname'] = $value['group_name'];
            $all[$key]['clospan'] = 0;
            $all[$key]['staffs'] = [];
            foreach ($staffs as $k => $v) {
                // 同一个组的
                if ($value['id'] == $v['id']) {
                    $temp['sid'] = $v['staff_id'];
                    $temp['sname'] = $v['staff_name'];
                    array_push($all[$key]['staffs'], $temp);
                }
            }
            // $temp['sid'] = 'all_'.$value['id'];
            // $temp['sname'] = '本店合计';
            array_push($all[$key]['staffs'], $temp);
            $all[$key]['clospan'] += count($all[$key]['staffs'])*3;
        }
        // var_dump($all);die;
        $this->assign('all', json_encode($all));

        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);

        $this->assign('title', $shop[0]['brandclass'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}