<?php
/**
 * 大屏控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> $
 */
namespace app\crm\controller;
use think\Controller;
// use app\index\controller\Base;
use think\Queue;
use think\Request;

class Tcdj extends Controller{
    // 付款分类 门市
    protected $payclass_ms = '0';
    // 今天
    protected  $today = [
        'start'=>'', 'end'  =>'',
    ];
    // 昨天
    protected  $yestoday = [
        'start'=>'', 'end'  =>'',
    ];
    // 本月一号和当天
    protected  $thisMonth = [
        'start'=>'', 'end'  =>'',
    ];
    // 本月每一天
    protected  $thisMonthAllDay = [];
    
    public function _initialize(){
        // 今天
        $this->today['start']=  date('Y-m-d 00:00:00');
        $this->today['end']  =  date('Y-m-d 23:59:59');
        // 昨天
        $this->yestoday['start']= date('Y-m-d 00:00:00',strtotime('-1 day'));
        $this->yestoday['end']  = date('Y-m-d 23:59:59',strtotime('-1 day'));
        // 本月
        $this->thisMonth['start']= date('Y-m-01 00:00:00');
        $this->thisMonth['end']  = date('Y-m-d 23:59:59');
        // 本月每一天
        $date = getdateArea('this_month');
        $timezone = getDateFromRange($date[0], $date[1]);
        $this->thisMonthAllDay = $timezone;
    }

    // 大屏页面  2018-03-11
    public function index(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $no_bids = config('no_bigScreen_bid');
        $no_bids = explode(',', $no_bids);
        
        $brandList = controller('crm/Tcdj', 'lib')->getBrandInfo();
        foreach ($brandList as $key => $value) {
            if (in_array($value['id'], $no_bids)) {
                continue;
            }else{
                $baseBrand[$key]['brandclass_id'] = $value['id'];
                $baseBrand[$key]['brandclass']    = $value['brandclass'];
                if ($value['nickname']) {
                    $baseBrand[$key]['nickname']  = $value['nickname'];
                }else{
                    $baseBrand[$key]['nickname']  = $value['brandclass'];
                }
            }
        }
        // var_dump($baseBrand);die;
        $this->assign('baseBrand', $baseBrand);

        // 集团名称
        $gInfo = controller('crm/Tcdj', 'lib')->getGName();
        $this->assign('title',$gInfo['group_company_name']);
        // 判断集团logo
        $logo = file_exists('bigscreennew/img/'.md5($gInfo['group_company_name']).'.png');
        $logo_btm = file_exists('bigscreennew/img/'.md5($gInfo['group_company_name']).'-btm.png');
        if ($logo && $logo_btm) {
            $md5 = md5($gInfo['group_company_name']);
            $this->assign('md5',$md5);
        }
        return $this->fetch();
    }

    // 移动端大屏
    public function mobile(){
        $bg_controller = config('bg_controller');
        $get = input('get.');
        
        if ($get['sign']=='app') {
            $sid = $get['staff_id'];
            session('staff_id', $sid);
            $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
            if ($auth === false) {
                $this->redirect('/crm/Customer/index');
            }
        }

        if ($bg_controller) {
            $this->redirect('/crm/'.$bg_controller.'/mobile');
            exit;
        }else{
            $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
            if ($auth === false) {
                controller('crm/Index','controller')->index();
                exit;
            }
            $no_bids = config('no_bigScreen_bid');
            $no_bids = explode(',', $no_bids);
            
            $brandList = controller('crm/Tcdj', 'lib')->getBrandInfo();
            foreach ($brandList as $key => $value) {
                if (in_array($value['id'], $no_bids)) {
                    continue;
                }else{
                    $baseBrand[$key]['brandclass_id'] = $value['id'];
                    $baseBrand[$key]['brandclass']    = $value['brandclass'];
                    if ($value['nickname']) {
                        $baseBrand[$key]['nickname']  = $value['nickname'];
                    }else{
                        $baseBrand[$key]['nickname']  = $value['brandclass'];
                    }
                }
            }
            $this->assign('baseBrand', $baseBrand);

            $gInfo = controller('crm/Tcdj', 'lib')->getGName();
            $this->assign('title',$gInfo['group_company_name']);
        }
        
        return $this->fetch();
    }
    // 页面基础数据
    public function baseData(){
        // 权限
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        //本月
        $mData['start'] = $this->thisMonth['start'];
        $mData['end']   = $this->thisMonth['end'];
        //今天
        $tData['start']= $this->today['start'];
        $tData['end']  = $this->today['end'];

        // 如果有事业部id，则查询事业部数据，
        $post = input('post.');
        $brandclass_id = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : null;

        if ($brandclass_id) {
            //有事业部查当前事业部所有shop_code
            $tData['brandclass_id'] = $brandclass_id;
            $mData['brandclass_id'] = $brandclass_id;
            $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
            $tData['add_shop_code'] = $shopCodes;
            $mData['add_shop_code'] = $shopCodes;
        }else{
            //没有事业部查集团所有shop_code
            $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode(0);
            $tData['add_shop_code'] = $shopCodes;
            $mData['add_shop_code'] = $shopCodes;
        }
        // var_dump($shopCodes);die;
        // 本月集团总客资 
        $all = cache('bigScreen_allCus');
        if (!$all) {
            $all = controller('crm/Tcdj','lib')->getCustomerNum($mData);
            cache('bigScreen_allCus', $all);
        }
        // die;
        //推广费用（渠道花费）
        $costMoneyT = controller('crm/Tcdj', 'lib')->costMoney($tData);
        $costMoneyM = controller('crm/Tcdj', 'lib')->costMoney($mData);
        $cost       = round($costMoneyT).' / '.round($costMoneyM);

        // //其它费用
        // $anotherT = controller('crm/Tcdj', 'lib')->anotherCost($tData);
        // $anotherM = controller('crm/Tcdj', 'lib')->anotherCost($mData);
        // $another  = round($anotherT).' / '.round($anotherM);
        // //花费合计
        // $total_cost = round($costMoneyT+$anotherT).' / '.round($costMoneyM+$anotherM);

        //总获取（毛客资）
        $allCusT = controller('crm/Tcdj', 'lib')->getCustomerNum($tData);
        $allCusM = controller('crm/Tcdj', 'lib')->getCustomerNum($mData);
        $allCus  = $allCusT.' / '.$allCusM;
        // 有效客资
        $validCustomerT = controller('crm/Tcdj', 'lib')->getInvCustomerNum($tData);
        $validCustomerM = controller('crm/Tcdj', 'lib')->getInvCustomerNum($mData);
        $validCustomer  = $validCustomerT.' / '.$validCustomerM;
        // 获取成本
        $validObtail = round($costMoneyT/$validCustomerT).' / '.round($costMoneyM/$validCustomerM);
        // var_dump($validObtail);
        // exit;
        // 网络营收
        $tData['brandclass_id'] = $brandclass_id;
        $mData['brandclass_id'] = $brandclass_id;
        $moneyT = controller('crm/Tcdj', 'lib')->incomeMoney($tData);
        $moneyM = controller('crm/Tcdj', 'lib')->incomeMoney($mData);
        $money = $moneyT.' / '.$moneyM;
        //下面的按网销查
        if ($brandclass_id) {
            $tData['brandclass_id'] = $brandclass_id;
            $mData['brandclass_id'] = $brandclass_id;
            $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id,'wx');
            $tData['shop_code'] = $shopCodes;
            $mData['shop_code'] = $shopCodes;
        }else{
            $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode(0,'wx');
            $tData['shop_code'] = $shopCodes;
            $mData['shop_code'] = $shopCodes;
        }
        // 本月总新单 集团所有的订单数量 （婚纱类型，crm订单）
        if ($brandclass_id == 8) {
            $returnData['total_order'] = db('c_customerinfo')
                ->where('shop_code','in',$shopCodes)
                ->where('c_from',1)
                ->where('is_status',1)
                ->where('is_success',1)
                ->where('order_day', 'between time', [$mData['start'], $mData['end']])
                ->count('id');
        }else{
            $returnData['total_order'] = db('c_customerinfo')
                ->where('shop_code','in',$shopCodes)
                ->where('c_from',1)
                ->where('is_status',1)
                ->where('consultation_type_id',HS_TYPE)
                ->where('is_success',1)
                ->where('order_day', 'between time', [$mData['start'], $mData['end']])
                ->count('id');
        }

        // 网络进客
        $intoCustomerT = controller('crm/Tcdj', 'lib')->getIntoCustomerNum($tData);
        $intoCustomerM = controller('crm/Tcdj', 'lib')->getIntoCustomerNum($mData);
        $intoCustomer = $intoCustomerT.'/'.$intoCustomerM;
        // 网络新单
        $tData['type'] = 'shop';
        $orderCustomerT = controller('crm/Tcdj', 'lib')->getOrderNumberNum($tData);
        $mData['type'] = 'shop';
        $orderCustomerM = controller('crm/Tcdj', 'lib')->getOrderNumberNum($mData);
        // exit;
        $orderCustomer = $orderCustomerT.'/'.$orderCustomerM;
        // 毛客资转化率
        $allCusRate = number_format(($orderCustomerT/$allCusT)*100,2).'%'.' / '.number_format(($orderCustomerM/$allCusM)*100,2).'%';
        //订单数量 / 毛客资
        $dayChangeRate = ($orderCustomerT / $allCusT)*100;
        $dayChangeRate = number_format($dayChangeRate, 2).'%';
        // 月转化率
        $monthChangeRate = ($orderCustomerM / $allCusM)*100;
        $monthChangeRate = number_format($monthChangeRate, 2).'%';
        // 成交率
        $succRate = number_format($orderCustomerT/$validCustomerT*100,2).'%'.' / '.number_format($orderCustomerM/$validCustomerM*100,2).'%';

        $returnData['cost']            = $cost;
        // $returnData['another']         = $another;
        // $returnData['total_cost']      = $total_cost;
        $returnData['allCus']          = $allCus;
        $returnData['validCustomer']   = $validCustomer;
        $returnData['validObtail']     = $validObtail;
        $returnData['intoCustomer']    = $intoCustomer;
        $returnData['orderCustomer']   = $orderCustomer;
        $returnData['money']           = $money;
        $returnData['succRate']        = $succRate;
        $returnData['allCusRate']      = $allCusRate;
        $returnData['dayChangeRate']   = $dayChangeRate;
        $returnData['monthChangeRate'] = $monthChangeRate;
        return json($returnData);
    }
    // 集团右侧数据  1 排行榜改成数据（婚纱数据）
    public function jtRankDataHs(){
        // 权限
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        //没有事业部查集团所有shop_code
        $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode(1);

        $baseShop = [];
        $hs_shop = '';
        if ($shopCodes['hs']) {
            foreach ($shopCodes['hs'] as $key => $value) {
                $baseShop[$value['shop_code']]['shop_code']= $value['shop_code'];
                $baseShop[$value['shop_code']]['shop_name']= $value['shop_name'];
                $baseShop[$value['shop_code']]['dayNum']   = 0;
                $baseShop[$value['shop_code']]['monthNum'] = 0;
                $hs_shop .= $value['shop_code'].',';
            }
            $hs_shop = trim($hs_shop, ',');
        }

        //本月
        $mData['start'] = date('Ymd',strtotime($this->thisMonth['start']));
        $mData['end']   = date('Ymd',strtotime($this->thisMonth['end']));
        //今天
        $tData['start']= date('Ymd',strtotime($this->today['start']));
        $tData['end']  = date('Ymd',strtotime($this->today['end']));
        // 营收金额
        // 婚纱当日营收
        $hsDayMoney = db('c_paymentcontent', 'sx_erp_hs')
//            ->where('payclass', 'in', $this->payclass_ms)
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        //婚纱当月营收
        $hsMonthMoney = db('c_paymentcontent', 'sx_erp_hs')
//            ->where('payclass', 'in', $this->payclass_ms)
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');

        // 订单量
        $hsDayOrder = db('c_customerorder', 'sx_erp_hs')
            ->where('targetdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->count('id');
        $hsMonthOrder = db('c_customerorder', 'sx_erp_hs')
            ->where('targetdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->count('id');
        // 一销收款
        //婚纱当日一销
        $hsDayYX = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass', 0)
            ->where('suoshu','in',['前期款','前期补款','一销退款'])
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        //婚纱当月一销
        $hsMonthYX = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass', 0)
            ->where('suoshu','in',['前期款','前期补款','一销退款'])
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        // 一销均额
        $hsDayYXavg = sprintf('%.2f',$hsDayYX/$hsDayOrder);
        $hsMonthYXavg = sprintf('%.2f',$hsMonthYX/$hsMonthOrder);
        // 选片量
        $hsDayXP = db('c_customersp', 'sx_erp_hs')
            ->where('selectday', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
            ->count('id');
        $hsMonthXP = db('c_customersp', 'sx_erp_hs')
            ->where('selectday', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
            ->count('id');
        // 二销收款
        //婚纱当日二销
        $hsDayEX = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass',0)
            ->where('suoshu','in',['后期款','后期补款','二销退款'])
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        //婚纱当月二销
        $hsMonthEX = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass', 0)
            ->where('suoshu','in',['后期款','后期补款','二销退款'])
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        // 二销均额
        $hsDayEXavg = sprintf('%.2f',$hsDayEX/$hsDayOrder);
        $hsMontEXhavg = sprintf('%.2f',$hsMonthEX/$hsMonthOrder);
        // 礼服收款
        //礼服收款 当日
        $hsDayLF = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass',1)
//            ->where('fundname','like','%礼服%')
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        //礼服收款  当月
        $hsMonthLF = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass',1)
//            ->where('fundname','like','%礼服%')
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        // 商品收款
        //商品收款 当日
        $hsDaySP = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass', 4)
//            ->where('fundname','in',['胸贴','鲜花'])
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        //商品收款  当月
        $hsMonthSP = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass',4)
//            ->where('fundname','in',['胸贴','鲜花'])
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->sum('payment_money');
        // 总拍照量
        $hsDayPhoto = db('c_customerphoto', 'sx_erp_hs')
            ->where('photodate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->where('phototype', '拍照') // '拍摄类型', 拍照
            ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
            ->count('id');
        $hsMonthPhoto = db('c_customerphoto', 'sx_erp_hs')
            ->where('photodate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $hs_shop)
            ->where('phototype', '拍照') // '拍摄类型', 拍照
            ->count('id');
        return array(
          'hsys' => round($hsDayMoney).'/'.round($hsMonthMoney),
          'hsdd' => $hsDayOrder.'/'.$hsMonthOrder,
          'hsyx' => round($hsDayYX).'/'.round($hsMonthYX),
          'hsyj' => round($hsDayYX/$hsDayOrder).'/'.round($hsMonthYX/$hsMonthOrder),
          'hsxp' => $hsDayXP.'/'.$hsMonthXP,
          'hsex' => round($hsDayEX).'/'.round($hsMonthEX),
          'hsej' => round($hsDayEX/$hsDayOrder).'/'.round($hsMonthEX/$hsMonthOrder),
          'hslf' => $hsDayLF.'/'.$hsMonthLF,
          'hssp' => $hsDaySP.'/'.$hsMonthSP,
          'hspz' =>$hsDayPhoto.'/'.$hsMonthPhoto,
        );
    }
    // 集团右侧数据  2 排行榜改成数据（优优数据）
    public function jtRankDataEt(){
        // 权限
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }

        //没有事业部查集团所有shop_code
        $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode(2);

        $baseShop = [];
        $et_shop = '';
        if ($shopCodes['et']) {
            foreach ($shopCodes['et'] as $key => $value) {
                $baseShop[$value['shop_code']]['shop_code']= $value['shop_code'];
                $baseShop[$value['shop_code']]['shop_name']= $value['shop_name'];
                $baseShop[$value['shop_code']]['dayNum']   = 0;
                $baseShop[$value['shop_code']]['monthNum'] = 0;
                $et_shop .= $value['shop_code'].',';
            }
            $et_shop = trim($et_shop, ',');
        }
        //本月
        $mData['start'] = date('Ymd',strtotime($this->thisMonth['start']));
        $mData['end']   = date('Ymd',strtotime($this->thisMonth['end']));
        //今天
        $tData['start']= date('Ymd',strtotime($this->today['start']));
        $tData['end']  = date('Ymd',strtotime($this->today['end']));
        // 营收金额
        // 儿童当日营收
        $etDayMoney = db('c_paymentcontent', 'sx_erp_et')
//            ->where('payclass', 'in', $this->payclass_ms)
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        //儿童当月营收
        $etMonthMoney = db('c_paymentcontent', 'sx_erp_et')
//            ->where('payclass', 'in', $this->payclass_ms)
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        // 订单量
        $etDayOrder = db('c_customerorder', 'sx_erp_et')
            ->where('targetdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->count('id');
        $etMonthOrder = db('c_customerorder', 'sx_erp_et')
            ->where('targetdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->count('id');
        // 一销收款
        //婚纱当日一销
        $etDayYX = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass',0)
            ->where('suoshu','in',['前期款','前期补款','一销退款'])
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        //婚纱当月一销
        $etMonthYX = db('c_paymentcontent', 'sx_erp_hs')
            ->where('payclass',0)
            ->where('suoshu','in',['前期款','前期补款','一销退款'])
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        // 一销均额
        $etDayYXavg = round($etDayYX/$etDayOrder);
        $etMonthYXavg = round($etMonthYX/$etMonthOrder);
        // 选片量
        $etDayXP = db('c_customersp', 'sx_erp_et')
            ->where('selectday', 'between',[$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
            ->count('id');
        $etMonthXP = db('c_customersp', 'sx_erp_et')
            ->where('selectday', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
            ->count('id');
        // 二销收款
        //婚纱当日二销
        $etDayEX = db('c_paymentcontent', 'sx_erp_et')
            ->where('payclass',0)
            ->where('suoshu','in',['后期款','后期补款','二销退款'])
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        //婚纱当月二销
        $etMonthEX = db('c_paymentcontent', 'sx_erp_et')
            ->where('payclass', 0)
            ->where('suoshu','in',['后期款','后期补款','二销退款'])
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        // 二销均额
        $etDayEXavg = round($etDayEX/$etDayOrder);
        $etMontEXhavg = round($etMonthEX/$etMonthOrder);
        // 礼服收款
        //礼服收款 当日
        $etDayLF = db('c_paymentcontent', 'sx_erp_et')
            ->where('payclass', 1)
//            ->where('fundname','like','%礼服%')
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        //礼服收款  当月
        $etMonthLF = db('c_paymentcontent', 'sx_erp_et')
            ->where('payclass',1)
//            ->where('fundname','like','%礼服%')
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        // 商品收款
        //商品收款 当日
        $etDaySP = db('c_paymentcontent', 'sx_erp_et')
            ->where('payclass',4)
//            ->where('fundname','in',['胸贴','鲜花'])
            ->where('paymentdate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        //商品收款  当月
        $etMonthSP = db('c_paymentcontent', 'sx_erp_et')
            ->where('payclass',4)
//            ->where('fundname','in',['胸贴','鲜花'])
            ->where('paymentdate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->sum('payment_money');
        // 总拍照量
        $etDayPhoto = db('c_customerphoto', 'sx_erp_et')
            ->where('photodate', 'between', [$tData['start'], $tData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->where('phototype', '拍照') // '拍摄类型', 拍照
            ->count('id');
        $etMonthPhoto = db('c_customerphoto', 'sx_erp_et')
            ->where('photodate', 'between', [$mData['start'], $mData['end']])
            ->where('shop_code', 'in', $et_shop)
            ->where('phototype', '拍照') // '拍摄类型', 拍照
            ->count('id');
        return array(
            'etys' => round($etDayMoney).'/'.round($etMonthMoney),
            'etdd' => $etDayOrder.'/'.$etMonthOrder,
            'etyx' => round($etDayYX).'/'.round($etMonthYX),
            'etyj' => round($etDayYX/$etDayOrder).'/'.round($etMonthYX/$etMonthOrder),
            'etxp' => $etDayXP.'/'.$etMonthXP,
            'etex' => round($etDayEX).'/'.round($etMonthEX),
            'etej' => round($etDayEX/$etDayOrder).'/'.round($etMonthEX/$etMonthOrder),
            'etlf' => $etDayLF.'/'.$etMonthLF,
            'etsp' => $etDaySP.'/'.$etMonthSP,
            'etpz' =>$etDayPhoto.'/'.$etMonthPhoto,
        );
    }
    // 集团右侧数据  3 婚纱营收走势图
    public function hsYsPic(){
        // 权限
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $shop_code = controller('crm/Tcdj', 'lib')->getShopCode(1);
        $data['shop_code'] = array_column($shop_code['hs'],'shop_code');

        // 起始时间
        $date = getdateArea('this_month');
        $data['start'] = date('Ymd', strtotime($date[0]));
        $data['end']   = date('Ymd', strtotime($date[1]));

        $timezone = $this->thisMonthAllDay;
        $today = date('Ymd');
        $number = [];
        foreach ($timezone as $key => $value) {
            $data['start'] = date('Ymd', strtotime($value));
            $data['end']   = date('Ymd', strtotime($value));
            $customerNum = controller('crm/Tcdj', 'lib')->getHSFact($data);

            $number[$key] = $customerNum;
            if ($value == $today) {
                break;
            }
        }

        $zone = [];
        foreach ($timezone as $key => $value) {
            $zone[$key] = date('d', strtotime($value));
        }
        $arr = [
            0=>[
                'name'=>'营收',
                'data' =>$number,
            ],
        ];
        $returnData['timezone'] = $zone;
        $returnData['name'] = array('营收');
        $returnData['data'] = $arr;
        return json($returnData);
    }
    // 集团右侧数据  4 优优营收走势图
    public function etYsPic(){
        // 权限
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }
        $shop_code= controller('crm/Tcdj', 'lib')->getShopCode(2);
        $data['shop_code'] = array_column($shop_code['et'],'shop_code');
        // 起始时间
        $date = getdateArea('this_month');
        $data['start'] = date('Ymd', strtotime($date[0]));
        $data['end']   = date('Ymd', strtotime($date[1]));
        // $timezone = getDateFromRange($date[0], $date[1]);
        $timezone = $this->thisMonthAllDay;
        $today = date('Ymd');
        $number = [];
        foreach ($timezone as $key => $value) {
            $data['start'] = date('Ymd', strtotime($value));
            $data['end']   = date('Ymd', strtotime($value));
            $customerNum = controller('crm/Tcdj', 'lib')->getETFact($data);

            $number[$key] = $customerNum;
            if ($value == $today) {
                break;
            }
        }

        $zone = [];
        foreach ($timezone as $key => $value) {
            $zone[$key] = date('d', strtotime($value));
        }
        $arr = [
            0=>[
                'name'=>'营收',
                'data' =>$number,
            ],
        ];
        $returnData['timezone'] = $zone;
        $returnData['name'] = array('营收');
        $returnData['data'] = $arr;
        return json($returnData);
    }

    // 四个排行榜
    public function rankData(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            controller('crm/Index','controller')->index();
            exit;
        }

        //本月
        $month_start = date('Ymd',strtotime($this->thisMonth['start']));
        $month_end   = date('Ymd',strtotime($this->thisMonth['end']));
        //今天
        $today_start= date('Ymd', strtotime($this->today['start']));
        $today_end  = date('Ymd', strtotime($this->today['end']));
        $post = input('post.');

        $brandclass_id = $post['brandclass_id'] ? (int)$post['brandclass_id'] : null;
        if ($brandclass_id) {
            //有事业部查当前事业部所有shop_code
            $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            //没有事业部查集团所有shop_code
            $shopCodes = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        $hsshop_not_in = [
          'TCDJ12',
          'TCDJ13',
          'TCDJ14',
          'TCDJ15',
          'TCDJ16',
          'TCDJ17',
        ];
        foreach($shopCodes['hs'] as $k=>$v){
            if(in_array($v['shop_code'],$hsshop_not_in)){
                unset($shopCodes['hs'][$k]);
            }
        }
        $etshop_not_in = [
            'TCYY01',
            'TCyy02',
        ];
        foreach($shopCodes['et'] as $k=>$v){
            if(in_array($v['shop_code'],$etshop_not_in)){
                unset($shopCodes['et'][$k]);
            }
        }
        $baseShop = [];
        if ($shopCodes['hs']) {
            $hs_shop = '';
            foreach ($shopCodes['hs'] as $key => $value) {
                $baseShop[$value['shop_code']]['shop_code']= $value['shop_code'];
                $baseShop[$value['shop_code']]['shop_name']= $value['shop_name'];
                $baseShop[$value['shop_code']]['dayNum']   = 0;
                $baseShop[$value['shop_code']]['monthNum'] = 0;
                $hs_shop .= $value['shop_code'].',';
            }
            $hs_shop = trim($hs_shop, ',');
        }
        if ($shopCodes['et']) {
            $et_shop = '';
            foreach ($shopCodes['et'] as $key => $value) {
                $baseShop[$value['shop_code']]['shop_code']= $value['shop_code'];
                $baseShop[$value['shop_code']]['shop_name']= $value['shop_name'];
                $baseShop[$value['shop_code']]['dayNum']   = 0;
                $baseShop[$value['shop_code']]['monthNum'] = 0;
                $et_shop .= $value['shop_code'].',';
            }
            $et_shop = trim($et_shop, ',');
        }
        /* -----------------------------------------------------  各店营收排名(一销)  ----------------------------------------------------- */
        $hsDayMoney=$hsMonthMoney=$etDayMoney=$etMonthMoney=[];
        if ($hs_shop) {
            // 当日营收
            $hsDayMoney = db('c_paymentcontent', 'sx_erp_hs')
                ->where('payclass', 'in', $this->payclass_ms)
                ->where('paymentdate', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $hs_shop)
                ->group('shop_code')->field('SUM(payment_money) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
            $hsMonthMoney = db('c_paymentcontent', 'sx_erp_hs')
                ->where('payclass', 'in', $this->payclass_ms)
                ->where('paymentdate', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $hs_shop)
                ->group('shop_code')->field('0 AS dayNum, SUM(payment_money) AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
        }
        if ($et_shop) {
            // 当日营收
            $etDayMoney = db('c_paymentcontent', 'sx_erp_et')
                ->where('payclass', 'in', $this->payclass_ms)
                ->where('paymentdate', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $et_shop)
                ->group('shop_code')->field('SUM(payment_money) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
            $etMonthMoney = db('c_paymentcontent', 'sx_erp_et')
                ->where('payclass', 'in', $this->payclass_ms)
                ->where('paymentdate', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $et_shop)
                ->group('shop_code')->field('0 AS dayNum, SUM(payment_money) AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
        }
        $merge = array_merge($hsDayMoney, $hsMonthMoney, $etDayMoney, $etMonthMoney, $baseShop);
        // 循环合并后的数组
        $temp = [];
        foreach ($merge as $key => $value) {
            $temp[$value['shop_code']]['shop_code'] = $value['shop_code'];
            $temp[$value['shop_code']]['shop_name'] = $value['shop_name'];
            $temp[$value['shop_code']]['dayNum']   += $value['dayNum'];
            $temp[$value['shop_code']]['monthNum'] += $value['monthNum'];
        }
        $temp = array_values($temp);

        $sort_order = 'SORT_DESC';
        $shopMoney = array_slice(my_sort($temp, 'monthNum', $sort_order), 0,10);
        unset($merge, $hsDayMoney, $hsMonthMoney, $etDayMoney, $etMonthMoney, $temp);
        // var_dump($shopMoney);die;
        /* -----------------------------------------------------  各店订单量排名  ----------------------------------------------------- */
        $hsDayOrder=$hsMonthOrder=$etDayOrder=$etMonthOrder=[];
        if ($hs_shop) {
            $hsDayOrder = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $hs_shop)
                ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
            $hsMonthOrder = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $hs_shop)
                ->group('shop_code')->field('0 AS dayNum, COUNT(id) AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
        }
        if ($et_shop) {
            $etDayOrder = db('c_customerorder', 'sx_erp_et')
                ->where('targetdate', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $et_shop)
                ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
            $etMonthOrder = db('c_customerorder', 'sx_erp_et')
                ->where('targetdate', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $et_shop)
                ->group('shop_code')->field('0 AS dayNum, COUNT(id) AS monthNum, shop_code, shop_name')
                ->order('monthNum', 'desc')
                ->select();
        }
        $merge = array_merge($hsDayOrder, $hsMonthOrder, $etDayOrder, $etMonthOrder, $baseShop);
        // 循环合并后的数组
        $temp = [];
        foreach ($merge as $key => $value) {
            $temp[$value['shop_code']]['shop_code'] = $value['shop_code'];
            $temp[$value['shop_code']]['shop_name'] = $value['shop_name'];
            $temp[$value['shop_code']]['dayNum']   += $value['dayNum'];
            $temp[$value['shop_code']]['monthNum'] += $value['monthNum'];
        }
        $temp = array_values($temp);

        $sort_order = 'SORT_DESC';
        $shopOrder = array_slice(my_sort($temp, 'monthNum', $sort_order), 0,10);
        unset($merge, $hsDayOrder, $hsMonthOrder, $etDayOrder, $etMonthOrder, $temp);
        /* -----------------------------------------------------  各店拍摄量排名  ----------------------------------------------------- */
        $hsDayPhoto=$hsMonthPhoto=$etDayPhoto=$etMonthPhoto=[];
        if ($hs_shop) {
            $hsDayPhoto = db('c_customerphoto', 'sx_erp_hs')
                ->where('photodate', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $hs_shop)
                ->where('phototype', '拍照') // '拍摄类型', 拍照 
                ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('dayNum', 'desc')
                ->select();
            $hsMonthPhoto = db('c_customerphoto', 'sx_erp_hs')
                ->where('photodate', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $hs_shop)
                ->where('phototype', '拍照') // '拍摄类型', 拍照 
                ->group('shop_code')->field('0 AS dayNum, COUNT(id) AS monthNum, shop_code, shop_name')
                ->select();
        }
        if ($et_shop) {
            $etDayPhoto = db('c_customerphoto', 'sx_erp_et')
                ->where('photodate', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $et_shop)
                ->where('phototype', '拍照') // '拍摄类型', 拍照 
                ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('dayNum', 'desc')
                ->select();
            $etMonthPhoto = db('c_customerphoto', 'sx_erp_et')
                ->where('photodate', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $et_shop)
                ->where('phototype', '拍照') // '拍摄类型', 拍照 
                ->group('shop_code')->field('0 AS dayNum, COUNT(id) AS monthNum, shop_code, shop_name')
                ->order('dayNum', 'desc')
                ->select();
        }
        $merge = array_merge($hsDayPhoto, $hsMonthPhoto, $etDayPhoto, $etMonthPhoto, $baseShop);
        // 循环合并后的数组
        $temp = [];
        foreach ($merge as $key => $value) {
            $temp[$value['shop_code']]['shop_code'] = $value['shop_code'];
            $temp[$value['shop_code']]['shop_name'] = $value['shop_name'];
            $temp[$value['shop_code']]['dayNum']   += $value['dayNum'];
            $temp[$value['shop_code']]['monthNum'] += $value['monthNum'];
        }
        $temp = array_values($temp);
        $sort_order = 'SORT_DESC';
        $shopPhoto = array_slice(my_sort($temp, 'dayNum', $sort_order), 0,10);
        unset($merge, $hsDayPhoto, $hsMonthPhoto, $etDayPhoto, $etMonthPhoto, $temp);
        /* -----------------------------------------------------  各店选片量排名  ----------------------------------------------------- */
        $hsDaySp=$hsMonthSp=$etDaySp=$etMonthSp=[];
        if ($hs_shop) {
            $hsDaySp = db('c_customersp', 'sx_erp_hs')
                ->where('selectday', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $hs_shop)
                ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('dayNum', 'desc')
                ->select();
            $hsMonthSp = db('c_customersp', 'sx_erp_hs')
                ->where('selectday', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $hs_shop)
                ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('shop_code')->field('0 AS dayNum, COUNT(id) AS monthNum, shop_code, shop_name')
                ->select();
        }
        if ($et_shop) {
            $etDaySp = db('c_customersp', 'sx_erp_et')
                ->where('selectday', 'between', [$today_start, $today_end])
                ->where('shop_code', 'in', $et_shop)
                ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('shop_code')->field('COUNT(id) AS dayNum, 0 AS monthNum, shop_code, shop_name')
                ->order('dayNum', 'desc')
                ->select();
            $etMonthSp = db('c_customersp', 'sx_erp_et')
                ->where('selectday', 'between', [$month_start, $month_end])
                ->where('shop_code', 'in', $et_shop)
                ->where('sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('shop_code')->field('0 AS dayNum, COUNT(id) AS monthNum, shop_code, shop_name')
                ->order('dayNum', 'desc')
                ->select();
        }
        $merge = array_merge($hsDaySp, $hsMonthSp, $etDaySp, $etMonthSp, $baseShop);
        // 循环合并后的数组
        $temp = [];
        foreach ($merge as $key => $value) {
            $temp[$value['shop_code']]['shop_code'] = $value['shop_code'];
            $temp[$value['shop_code']]['shop_name'] = $value['shop_name'];
            $temp[$value['shop_code']]['dayNum']   += $value['dayNum'];
            $temp[$value['shop_code']]['monthNum'] += $value['monthNum'];
        }
        $temp = array_values($temp);
        $sort_order = 'SORT_DESC';
        $shopSp = array_slice(my_sort($temp, 'dayNum', $sort_order), 0,10);
        unset($merge, $hsDaySp, $hsMonthSp, $etDaySp, $etMonthSp, $temp);
        /* -----------------------------------------------------  打完收工  ----------------------------------------------------- */
        $returnData = [
            'shopMoney'=> $shopMoney,
            'shopOrder'=> $shopOrder,
            'shopPhoto'=> $shopPhoto,
            'shopSp'   => $shopSp,
        ];
        unset($baseShop, $shopMoney,$shopOrder,$shopPhoto,$shopSp);
        return json($returnData);
    }

    // 转化漏斗 （日） 图
    public function dayChangeRate(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            // controller('crm/Index','controller')->index();
            exit;
        }

        $post = input('post.');

        $data['start'] = date('Y-m-d 00:00:00', time());
        $data['end']   = date('Y-m-d 23:59:59', time());
        $data['brandclass_id'] = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : 0;

        $returnData = $this->getChangeLdData($data);

        return json($returnData);
    }

    // 转化漏斗 （月） 图
    public function monthChangeRate(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            // controller('crm/Index','controller')->index();
            exit;
        }

        $post = input('post.');

        $date = getdateArea('this_month');
        $data['start'] = date('Y-m-d 00:00:00',strtotime($date[0]));
        $data['end'] = date('Y-m-d 23:59:59',strtotime($date[1]));
        $data['brandclass_id'] = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : 0;

        $returnData = $this->getChangeLdData($data);

        return json($returnData);
    }

    // 转化漏斗数据 
    public function getChangeLdData($data){
        $brandclass_id = $data['brandclass_id'];
        if ($brandclass_id) {
            $data['brandclass_id'] = $brandclass_id;
            // $add_shop_code = $this->shop_codes;
            // $data['add_shop_code'] = $add_shop_code[$brandclass_id];
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            // $data['add_shop_code'] = implode(',', $this->shop_codes);
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        
        // 毛客资
        $customerNum = controller('crm/Tcdj', 'lib')->getCustomerNum($data);
        $returnData[0]['name'] = '毛客资量';
        $returnData[0]['data'] = $customerNum;
        // 有效客资
        $invCustomer = controller('crm/Tcdj', 'lib')->getInvCustomerNum($data);
        // exit;
        $returnData[1]['name'] = '有效客资';
        $returnData[1]['data'] = $invCustomer;
        // // 获取手机
        // $telCustomer = controller('crm/Statistics', 'lib')->getTelCustomerNum($data);
        // $returnData[2]['name'] = '获取手机';
        // $returnData[2]['data'] = $telCustomer;

        if ($brandclass_id) {
            $data['brandclass_id'] = $brandclass_id;
            // $add_shop_code = $this->all_shop_codes;
            // $data['add_shop_code'] = $add_shop_code[$brandclass_id];
            $data['shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            // $data['add_shop_code'] = implode(',', $this->all_shop_codes);
            $data['shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        // 进店/邀约 量
        $intoCustomer= controller('crm/Tcdj', 'lib')->getIntoCustomerNum($data);

        $returnData[2]['name'] = '进店';
        $returnData[2]['data'] = $intoCustomer;
        // 新单 量
        $data['type'] = 'shop';
        $orderNumber = controller('crm/Tcdj', 'lib')->getOrderNumberNum($data);
        $returnData[3]['name'] = '订单';
        $returnData[3]['data'] = $orderNumber;
        return $returnData;
    }

    // 本月毛客资量走势 图
    public function monthCustomerNumber(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            // controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $brandclass_id = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : 0;
        if ($brandclass_id) {
            $data['brandclass_id'] = $brandclass_id;
            // $add_shop_code = $this->all_shop_codes;
            // $data['add_shop_code'] = $add_shop_code[$brandclass_id];
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            // $data['add_shop_code'] = implode(',', $this->all_shop_codes);
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        // 起始时间
        // $date = getdateArea('this_month');
        // $timezone = getDateFromRange($date[0], $date[1]);
        $timezone = $this->thisMonthAllDay;
        $number = [];
        $today = date('Y-m-d');
        foreach ($timezone as $key => $value) {
            $data['start'] = date('Y-m-d 00:00:00', strtotime($value));
            $data['end']   = date('Y-m-d 23:59:59', strtotime($value));
            $customerNum = controller('crm/Tcdj', 'lib')->getCustomerNum($data);
            $number[$key] = $customerNum;
            if ($value == $today) {
                break;
            }
        }
        $zone = [];
        foreach ($timezone as $key => $value) {
            $zone[$key] = date('d', strtotime($value));
        }
        $arr = [
            0=>[
                'name'=>'毛客资量',
                'data' =>$number,
            ],
        ];

        $returnData['timezone'] = $zone;
        $returnData['name'] = array('毛客资量');
        $returnData['data'] = $arr;
        return json($returnData);
    }

    // 本月网销邀约 （进店） 量走势 图
    public function monthIntoNumber(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            // controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $brandclass_id = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : 0;
        if ($brandclass_id) {
            $data['brandclass_id'] = $brandclass_id;
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        // 起始时间
        $date = getdateArea('this_month');

        $data['start'] = date('Y-m-d 00:00:00', strtotime($date[0]));
        $data['end']   = date('Y-m-d 23:59:59', strtotime($date[1]));

        // $timezone = getDateFromRange($date[0], $date[1]);
        $timezone = $this->thisMonthAllDay;
        $today = date('Y-m-d');
        $number = [];
        foreach ($timezone as $key => $value) {
            $data['start'] = date('Y-m-d 00:00:00', strtotime($value));
            $data['end']   = date('Y-m-d 23:59:59', strtotime($value));
            $customerNum = controller('crm/Tcdj', 'lib')->getIntoCustomerNum($data);
            $number[$key] = $customerNum;
            if ($value == $today) {
                break;
            }
        }
        $zone = [];
        foreach ($timezone as $key => $value) {
            $zone[$key] = date('d', strtotime($value));
        }
        $arr = [
            0=>[
                'name'=>'邀约量',
                'data' =>$number,
            ],
        ];

        $returnData['timezone'] = $zone;
        $returnData['name'] = array('邀约量');
        $returnData['data'] = $arr;
        return json($returnData);
    }
    
    // 本月网络新单量走势 图
    public function monthNewOrderNumber(){
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            // controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $brandclass_id = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : 0;
        if ($brandclass_id) {
            $data['brandclass_id'] = $brandclass_id;
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            $data['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        // 起始时间
        // $date = getdateArea('this_month');
        // $timezone = getDateFromRange($date[0], $date[1]);
        $timezone = $this->thisMonthAllDay;
        $today = date('Y-m-d');
        $number = [];
        foreach ($timezone as $key => $value) {
            $data['start'] = date('Y-m-d 00:00:00', strtotime($value));
            $data['end']   = date('Y-m-d 23:59:59', strtotime($value));
            $data['type']  = 'shop';
            $customerNum = controller('crm/Tcdj', 'lib')->getOrderNumberNum($data);
            $number[$key] = $customerNum;
            if ($value == $today) {
                break;
            }
        }
        $zone = [];
        foreach ($timezone as $key => $value) {
            $zone[$key] = date('d', strtotime($value));
        }
        $arr = [
            0=>[
                'name'=>'新单量',
                'data' =>$number,
            ],
        ];

        $returnData['timezone'] = $zone;
        $returnData['name'] = array('新单量');
        $returnData['data'] = $arr;
        return json($returnData);
    }

    // 本月转化率 （ 新单 / 有效获取 ） 走势 图
    public function monthOrderRateNumber(){
        // echo '开始 ==> '.microtime(true).'<br />';
        $auth = controller('crm/Tcdj', 'lib')->checkBigScreenAuth();
        if ($auth === false) {
            // controller('crm/Index','controller')->index();
            exit;
        }
        $post = input('post.');
        $brandclass_id = (int)$post['brandclass_id'] ? (int)$post['brandclass_id'] : 0;
        if ($brandclass_id) {
            // 新单条件
            $dataInto['brandclass_id'] = $brandclass_id;
            $dataInto['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
            // 有效条件
            $dataInv['brandclass_id'] = $brandclass_id;
            $dataInv['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode($brandclass_id);
        }else{
            // 新单条件
            $dataInto['shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
            // 有效条件
            $dataInv['add_shop_code'] = controller('crm/Tcdj', 'lib')->getShopCode(0);
        }
        // 起始时间
        // $date = getdateArea('this_month');
        // $timezone = getDateFromRange($date[0], $date[1]);
        $timezone = $this->thisMonthAllDay;
        $zone   = [];
        $number = [];
        $allInto= 0;
        $allInv = 0;
        $today = date('Y-m-d');
        // echo '开始循环 ==> '.microtime(true).'<br />';
        $into = [];
        foreach ($timezone as $key => $value) {
            $start = date('Y-m-d 00:00:00', strtotime($value));
            $end   = date('Y-m-d 23:59:59', strtotime($value));
            $dataInto['start']= $start;
            $dataInto['end']  = $end;
            $dataInv['start'] = $start;
            $dataInv['end']   = $end;
            // 邀约
            // echo '循环'.$key.'邀约 ==> '.microtime(true).'<br />';
            $intoNum = controller('crm/Tcdj', 'lib')->getOrderNumberNum($dataInto);
            // echo $intoNum.'<br />';
            $into[$key] = $intoNum;
            $allInto += $intoNum;
            // 有效
            // echo '循环'.$key.'有效 ==> '.microtime(true).'<br />';
            $invNum = controller('crm/Tcdj', 'lib')->getInvCustomerNum($dataInv);
            // echo $invNum.'<br />';
            $allInv += $invNum;
            $rate = $intoNum / $invNum;
            $number[$key] = number_format($rate*100, 2);
            $number[$key] = $number[$key]>100 ? 100 : $number[$key];
            if ($value == $today) {
                break;
            }
        }
        // exit;
        // echo '结束循环 ==> '.microtime(true).'<br />';

//        $allRate = number_format(($allInto / $allInv)*100, 2);
        $allNumber = [];
        // echo '循环时间 ==> '.microtime(true).'<br />';
        foreach ($timezone as $key => $value) {
//            $allNumber[$key] = $allRate;
            $allNumber[$key] = number_format(($into[$key] / $allInv)*100, 2);
            $allNumber[$key] = $allNumber[$key]>100 ? 100 : $allNumber[$key];
            $zone[$key] = date('d', strtotime($value));
        }
        // echo '循环结束 ==> '.microtime(true).'<br />';
        $arr = [
            0=>[
                'name'=>'日转化率',
                'data' =>$number,
            ],
            1=>[
                'name'=>'月转化率',
                'data' =>$allNumber,
            ],
        ];
        $returnData['timezone'] = $zone;
        $returnData['name'] = array('转化率');
        $returnData['data'] = $arr;
        // echo '最后赋值 ==> '.microtime(true).'<br />';
        return json($returnData);
    }

}