<?php
/**
 * 大屏专用lib
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> 2017-10-27 $
 */
namespace app\crm\lib;
use think\Controller;

class Lzl extends Controller{
    // 获取集团信息
    public function getGName($param){
        $gInfo = cache('company_'.$param['group_company_name']);
        if (empty($gInfo)) {
            $url = '5a6978bb82027';
            $data=[];
            $res = sx_call($url, $data);
            if ($res['code'] == 200) {
                $gInfo = $res['data'][0];
                cache('company_'.$gInfo['group_company_name']);
            }
            unset($res);
        }
        return $gInfo;
    }

    /**
     * 查看目标
     * 
     * @param  goal_name      目标名称（订单营收、礼服营收、订单量、看样量、摄影量）
     * @param  month          月份
     * @param  allShopCodes   店(shop_code 多个以  ,  分隔)
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getTarget($params){
        // 查询当月目标
        $where['method']    = 'shop';
        $where['status']    = '1';
        $where['month']     = date('Y-m',strtotime($params['month']));
        $where['goal_name'] = trim($params['goal_name']);
        if($params['select'] == 'eq'){
            $shop_code = implode(',',$params['allShopCodes']);
            $target = db('s_goal')->where($where)->where('shop_code', $shop_code)->sum('goal_value');
        }else{
            $target = db('s_goal')->where($where)->where('shop_code', 'in', $params['allShopCodes'])->sum('goal_value');
        }
        return $target;
    }
    public function getTargetGroup($params){
        // 查询当月目标
        $where['method']    = 'shop';
        $where['status']    = '1';
        $where['month']     = date('Y-m',strtotime($params['month']));
        $where['goal_name'] = trim($params['goal_name']);
        $target = db('s_goal')->where($where)->where('shop_code', 'in', $params['allShopCodes'])->group('shop_code')->column('sum(goal_value)','shop_code');
        return $target;
    }
    /**
     * 统计营收业绩
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  payclass       付款分类（0： 门市，1：礼服，2：化妆,3 VIP卡充值 4 商品收款）',
     * @param  shop_code      
     * @param  paymentdate    付款日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getYsYj($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        if ((int)$params['search_type']==1) {

            $return = db('c_paymentcontent', 'sx_erp_hs')->where('payclass', 'in', $params['payclass'])->where('paymentdate', 'between', [$start, $end])->where('shop_code', 'in', $params['shop_code'])->group('shop_code')->column('sum(payment_money)','shop_code');
            // echo db('c_paymentcontent', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {

            $return = db('c_paymentcontent', 'sx_erp_et')->where('payclass', 'in', $params['payclass'])->where('paymentdate', 'between', [$start, $end])->where('shop_code', 'in', $params['shop_code'])->group('shop_code')->column('sum(payment_money)','shop_code');
            // echo db('c_paymentcontent', 'sx_erp_et')->getLastSql();
            // exit;
        }else{
            $return = [];
        }
        return $return;
    }
    /*
     * new 根据款项获取业绩
     * */
    public function getFact($param){
        $start= date('Ymd',strtotime($param['start']));
        $end  = date('Ymd',strtotime($param['end']));
        $where['shop_code'] = ['in',$param['shop_code']];
        if($param['fundname']){
            $where['fundname'] = ['in',$param['fundname']];
        }
        if($param['payclass']){
            $where['payclass'] = ['in',$param['payclass']];
        }
        if($param['suoshu']){
            $where['payclass'] = 0;
            $where['suoshu'] = ['in',$param['suoshu']];
        }
        if($param['shop_type'] == 1){
            $return = db('c_paymentcontent', 'sx_erp_hs')->where($where)->where('paymentdate', 'between', [$start, $end])->sum('payment_money');
        }elseif($param['shop_type'] == 2){
            $return = db('c_paymentcontent', 'sx_erp_et')->where($where)->where('paymentdate', 'between', [$start, $end])->sum('payment_money');
        }else{
            $return_hs = db('c_paymentcontent', 'sx_erp_hs')->where($where)->where('paymentdate', 'between', [$start, $end])->sum('payment_money');
            if($param['shop_name']=='武威'){
                // echo db('c_paymentcontent', 'sx_erp_hs')->getLastSql();die;
            };
            $return_et = db('c_paymentcontent', 'sx_erp_et')->where($where)->where('paymentdate', 'between', [$start, $end])->sum('payment_money');
            $return = $return_hs+$return_et;
        }
        return $return;
    }
    /**
     * 统计礼服业绩  不算基地收款
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  payclass       付款分类（0： 门市，1：礼服，2：化妆,3 VIP卡充值 4 商品收款）',
     * @param  shop_code      
     * @param  paymentdate    付款日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getLfYj($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        if ((int)$params['search_type']==1) {
            // 找到所有后期款中，带 ‘基地’ 的
            $jidi_hs = db('s_collectmoneyset', 'sx_erp_hs')->where('collectitem_belongs','后期款')->where('collectitem_name', 'like', '%基地%')->field('collectitem_name')->select();
            $fundname = '';
            foreach ($jidi_hs as $key => $value) {
                $fundname .= $value['collectitem_name'].',';
            }
            $fundname = trim($fundname, ',');
            $return = db('c_paymentcontent', 'sx_erp_hs')
                ->where('payclass', 'in', $params['payclass'])->where('fundname', 'not in', $fundname)
                ->where('paymentdate', 'between', [$start, $end])->where('shop_code', 'in', $params['shop_code'])
                ->group('shop_code')->column('sum(payment_money)','shop_code');
            // echo db('c_paymentcontent', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            $jidi_et = db('s_collectmoneyset', 'sx_erp_et')->where('collectitem_belongs','后期款')->where('collectitem_name', 'like', '%基地%')->field('collectitem_name')->select();
            $fundname = '';
            foreach ($jidi_et as $key => $value) {
                $fundname .= $value['collectitem_name'].',';
            }
            $fundname = trim($fundname, ',');

            $return = db('c_paymentcontent', 'sx_erp_et')
                ->where('payclass', 'in', $params['payclass'])->where('fundname', 'not in', $fundname)
                ->where('paymentdate', 'between', [$start, $end])->where('shop_code', 'in', $params['shop_code'])
                ->group('shop_code')->column('sum(payment_money)','shop_code');

        }else{
            $return = [];
        }
        return $return;
    }

    /**
     * 统计三销业绩
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  payclass       付款分类（0： 门市，1：礼服，2：化妆,3 VIP卡充值 4 商品收款）',
     * @param  shop_code      
     * @param  paymentdate    付款日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSxYj($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        if ((int)$params['search_type']==1) {
            $return = db('c_paymentcontent', 'sx_erp_hs')
                ->where('payclass', 'in', $params['payclass'])->where('fundname', '基地三销款')
                ->where('paymentdate', 'between', [$start, $end])->where('shop_code', 'in', $params['shop_code'])
                ->group('shop_code')->column('sum(payment_money)','shop_code');
            // echo db('c_paymentcontent', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            $return = db('c_paymentcontent', 'sx_erp_et')
                ->where('payclass', 'in', $params['payclass'])->where('fundname', '基地三销款')
                ->where('paymentdate', 'between', [$start, $end])->where('shop_code', 'in', $params['shop_code'])
                ->group('shop_code')->column('sum(payment_money)','shop_code');
        }else{
            $return = [];
        }
        return $return;
    }
    /**
     * 统计订单量
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  shop_code      
     * @param  start          订单日期
     * @param  end            订单日期
     * @param  con_type       1:婚纱/2:写真/3:儿童
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getDdNum($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        $consumption_type = $this->getConType($params['con_type']);
        if ((int)$params['search_type']==1) {
            if ($consumption_type) {
                $return = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$start, $end])
                ->where('consumption_type', 'in', $consumption_type)
                ->where('shop_code', 'in', $params['shop_code'])
                ->where('bargain_money','>', '0')
                ->group('shop_code')->column('count(orderId)','shop_code');
            }else{
                $return = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$start, $end])
                ->where('shop_code', 'in', $params['shop_code'])
                ->where('bargain_money','>', '0')
                ->group('shop_code')->column('count(orderId)','shop_code');
            }
            // echo db('c_customerorder', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            // 儿童不区分消费类型
            $return = db('c_customerorder', 'sx_erp_et')
                ->where('targetdate', 'between', [$start, $end])
                ->where('shop_code', 'in', $params['shop_code'])
                ->where('bargain_money','>', '0')
                ->group('shop_code')->column('count(orderId)','shop_code');
        }else{
            $return = [];
        }
        return $return;
    }
    public function getXZDdNum($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        if ((int)$params['search_type']==1) {
            if ($params['con_type'] == 1) {
                $return = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$start, $end])
                ->where('consumption_type', '婚纱照')
                ->where('bargain_money','>', '0')
                ->where('shop_code', 'in', $params['shop_code'])
                ->count('id');
            }else{
                $return = db('c_customerorder', 'sx_erp_hs')
                ->where('targetdate', 'between', [$start, $end])
                ->where('consumption_type','<>', '婚纱照')
                 ->where('bargain_money','>', '0')
                ->where('shop_code', 'in', $params['shop_code'])
                ->count('id');
            }
            // echo db('c_customerorder', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            // 儿童不区分消费类型
            $return = db('c_customerorder', 'sx_erp_et')
                ->where('targetdate', 'between', [$start, $end])
                ->where('bargain_money','>', '0')
                ->where('shop_code', 'in', $params['shop_code'])
                ->count('id');
        }else{
            $return = 0;
        }
        return $return;
    }
    // 区分类型 1:婚纱/2:写真/3:儿童
    public function getConType($con_type){
        $consumption_type = '';
        $con_type = (int)$con_type;
        if ($con_type==1) {
            $consumption_type = '婚纱照,全家福';
        }else if ($con_type==2) {
            $consumption_type = '全家福,艺术照,情侣照,闺蜜照,形象照,纪念照,儿童照,亲子照,孕妇照';
        }else if ($con_type==3) {
            $consumption_type = '儿童照,亲子照,孕妇照';
        }
        return $consumption_type;
    }
    /**
     * 统计看样量
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  shop_code      
     * @param  start          开始日期
     * @param  end            开始日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getKyNum($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        $consumption_type = $this->getConType($params['con_type']);
        if ((int)$params['search_type']==1) {
            if ($consumption_type) {
                $return = db('c_customersp', 'sx_erp_hs')->alias('s')
                ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('s.shop_code')->column('count(DISTINCT s.orderId)','s.shop_code');
            }else{
                $return = db('c_customersp', 'sx_erp_hs')->alias('s')
                 ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('s.shop_code')->column('count(DISTINCT s.orderId)','s.shop_code');
            }
            // echo db('c_customersp', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            // 儿童不区分消费类型
            $return = db('c_customersp', 'sx_erp_et')->alias('s')
                 ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->group('s.shop_code')->column('count(DISTINCT s.orderId)','s.shop_code');
        }else{
            $return = [];
        }
        return $return;
    }
    public function getXZKyNum($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        if ((int)$params['search_type']==1) {
            if ($params['con_type'] == 1) {
                $return = db('c_customersp', 'sx_erp_hs')->alias('s')
                ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                ->where('o.consumption_type', '婚纱照')
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->count('DISTINCT s.orderId');
            }else{
                $return = db('c_customersp', 'sx_erp_hs')->alias('s')
                 ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->count('DISTINCT s.orderId');
            }
            // echo db('c_customersp', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            // 儿童不区分消费类型
            $return = db('c_customersp', 'sx_erp_et')->alias('s')
                 ->join('c_customerorder o', 's.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('s.selectday', 'between', [$start, $end])
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->where('s.sptstate', 1)// '选片状态  0未选完，1已选，2未选',
                ->count('DISTINCT s.orderId');
        }else{
            $return = 0;
        }
        return $return;
    }
    /**
     * 统计一销金额总和
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  shop_code      
     * @param  start          开始日期
     * @param  end            开始日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getYxMoney($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        $consumption_type = $this->getConType($params['con_type']);
        if ((int)$params['search_type']==1) {
            if ($consumption_type) {
                $return = db('c_customerorder', 'sx_erp_hs')->alias('o')
                // ->join('c_customerphoto p', 'o.orderId=p.orderId', 'left')
                // ->where('p.photostate', 2)
                ->where('o.consumption_type', 'in', $consumption_type)
                ->where('o.targetdate', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('o.shop_code', 'in', $params['shop_code'])
                ->group('o.shop_code')->column('sum(o.bargain_money)','o.shop_code');
            }else{
                $return = db('c_customerorder', 'sx_erp_hs')->alias('o')
                // ->join('c_customerphoto p', 'o.orderId=p.orderId', 'left')
                // ->where('p.photostate', 2)
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('o.targetdate', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('o.shop_code', 'in', $params['shop_code'])
                ->group('o.shop_code')->column('sum(o.bargain_money)','o.shop_code');
            }
            // echo db('c_customerorder', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            $return = db('c_customerorder', 'sx_erp_et')->alias('o')
                // ->join('c_customerphoto p', 'o.orderId=p.orderId', 'left')
                // ->where('p.photostate', 2)
                ->where('o.targetdate', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('o.shop_code', 'in', $params['shop_code'])
                ->group('o.shop_code')->column('sum(o.bargain_money)','o.shop_code');
        }else{
            $return = [];
        }
        return $return;
    }
    /**
     * 统计二销金额总和
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  shop_code      
     * @param  start          开始日期
     * @param  end            开始日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getExMoney($params){
        $start= date('Ymd',strtotime($params['start']));
        $end  = date('Ymd',strtotime($params['end']));
        $consumption_type = $this->getConType($params['con_type']);
        if ((int)$params['search_type']==1) {
            if ($consumption_type) {
                $return = db('c_customerorder', 'sx_erp_hs')->alias('o')
                 ->join('c_customersp p', 'o.orderId=p.orderId', 'left')
                 ->where('p.sptstate', 1)
                ->where('o.consumption_type', 'in', $consumption_type)
                ->where('p.selectday', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->group('o.shop_code')->column('sum(o.supplementary_money)','o.shop_code');
            }else{
                $return = db('c_customerorder', 'sx_erp_hs')->alias('o')
                 ->join('c_customersp p', 'o.orderId=p.orderId', 'left')
                 ->where('p.sptstate', 1)
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('p.selectday', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->group('o.shop_code')->column('sum(o.supplementary_money)','o.shop_code');
            }
            // echo db('c_customerorder', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            $return = db('c_customerorder', 'sx_erp_et')->alias('o')
                 ->join('c_customersp p', 'o.orderId=p.orderId', 'left')
                 ->where('p.sptstate', 1)
                ->where('p.selectday', 'between', [$start, $end])
                ->where('o.blankoutannal', '0')
                ->where('s.shop_code', 'in', $params['shop_code'])
                ->group('o.shop_code')->column('sum(o.supplementary_money)','o.shop_code');
        }else{
            $return = [];
        }
        return $return;
    }
    /**
     * 统计摄影量
     * 
     * @param  search_type    查询类型 1：婚纱； 2：儿童
     * @param  shop_code      
     * @param  start          开始日期
     * @param  end            开始日期
     * 
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getSyNum($params){
        $consumption_type = $this->getConType($params['con_type']);
        if ((int)$params['search_type']==1) {
            $start= date('Y-m-d H:i:s',strtotime($params['start']));
            $end  = date('Y-m-d H:i:s',strtotime($params['end']));
            if ($consumption_type) {
                $return = db('c_customerphoto', 'sx_erp_hs')->alias('p')
                ->join('c_customerorder o', 'p.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('p.photodate', 'between', [$start, $end])
                ->where('p.shop_code', 'in', $params['shop_code'])
                ->where('p.phototype', '拍照') // '拍摄类型', 拍照、各种长途、各种补拍、重拍、还有各种地区的
                // ->where('p.photostate', 2) // '拍摄状态0全为1未完2全完',
                ->group('p.shop_code')->column('count(DISTINCT p.orderId)','p.shop_code');
            }else{
                $return = db('c_customerphoto', 'sx_erp_hs')->alias('p')
                 ->join('c_customerorder o', 'p.orderId=o.orderId', 'left')
                // ->where('o.consumption_type', 'in', $consumption_type)
                ->where('p.photodate', 'between', [$start, $end])
                ->where('p.shop_code', 'in', $params['shop_code'])
                ->where('p.phototype', '拍照') // '拍摄类型', 拍照、各种长途、各种补拍、重拍、还有各种地区的
                // ->where('p.photostate', 2) // '拍摄状态0全为1未完2全完',
                ->group('p.shop_code')->column('count(DISTINCT p.orderId)','p.shop_code');
            }
            // echo db('c_customerphoto', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            $start= date('Ymd',strtotime($params['start']));
            $end  = date('Ymd',strtotime($params['end']));
            // 儿童不区分消费类型
            $return = db('c_customerphoto', 'sx_erp_et')->alias('p')
                 ->join('c_customerorder o', 'p.orderId=o.orderId', 'left')
                ->where('p.photodate', 'between', [$start, $end])
                ->where('p.shop_code', 'in', $params['shop_code'])
                ->where('p.phototype', '拍照') // '拍摄类型', 拍照、各种长途、各种补拍、重拍、还有各种地区的
                // ->where('p.photostate', 2) // '拍摄状态0全为1未完2全完',
                ->group('p.shop_code')->column('count(DISTINCT p.orderId)','p.shop_code');
            // echo db('c_customerphoto', 'sx_erp_et')->getLastSql();
            // exit;
        }else{
            $return = [];
        }
        return $return;
    }
    public function getXZSyNum($params){
        $start= date('Y-m-d H:i:s',strtotime($params['start']));
        $end  = date('Y-m-d H:i:s',strtotime($params['end']));
        if ((int)$params['search_type']==1) {
            if ($params['con_type']==1) {
                $return = db('c_customerphoto', 'sx_erp_hs')->alias('p')
                ->join('c_customerorder o', 'p.orderId=o.orderId', 'left')
                ->where('o.consumption_type', '婚纱照')
                ->where('p.photodate', 'between', [$start, $end])
                ->where('p.shop_code', 'in', $params['shop_code'])
                ->where('p.phototype', '拍照') // '拍摄类型', 拍照、各种长途、各种补拍、重拍、还有各种地区的
                // ->where('p.photostate', 2) // '拍摄状态0全为1未完2全完',
                ->count('DISTINCT p.orderId');
            }else{
                $return = db('c_customerphoto', 'sx_erp_hs')->alias('p')
                 ->join('c_customerorder o', 'p.orderId=o.orderId', 'left')
                 ->where('o.consumption_type', '<>', '婚纱照')
                ->where('p.photodate', 'between', [$start, $end])
                ->where('p.shop_code', 'in', $params['shop_code'])
                ->where('p.phototype', '拍照') // '拍摄类型', 拍照、各种长途、各种补拍、重拍、还有各种地区的
                // ->where('p.photostate', 2) // '拍摄状态0全为1未完2全完',
                    ->count('DISTINCT p.orderId');
            }
            // echo db('c_customerphoto', 'sx_erp_hs')->getLastSql();
            // exit;
        }else if ((int)$params['search_type']==2) {
            $start= date('Ymd',strtotime($params['start']));
            $end  = date('Ymd',strtotime($params['end']));
            // 儿童不区分消费类型
            $return = db('c_customerphoto', 'sx_erp_et')->alias('p')
                 ->join('c_customerorder o', 'p.orderId=o.orderId', 'left')
                ->where('p.photodate', 'between', [$start, $end])
                ->where('p.shop_code', 'in', $params['shop_code'])
                ->where('p.phototype', '拍照') // '拍摄类型', 拍照、各种长途、各种补拍、重拍、还有各种地区的
                // ->where('p.photostate', 2) // '拍摄状态0全为1未完2全完',
                ->count('DISTINCT p.orderId');
            // echo db('c_customerphoto', 'sx_erp_et')->getLastSql();
            // exit;
        }else{
            $return = 0;
        }
        return $return;
    }
}