<?php
/**
 * 大屏专用lib
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> 2017-10-27 $
 */
namespace app\crm\lib;
use think\Controller;

class Rome extends Controller{
    // 大屏专用  判断  该员工是否有权限查看大屏数据
    public function checkBigScreenAuth(){
        // 获取配置文件中的信息，根据,分割成数组，如果staff_id不存在，则跳转到登录或首页
        $staff_id = session('staff_id');
        $str_id = config('bigScreen_id');
        $bigScreen_id = explode(',', $str_id);
        $is_in = in_array($staff_id, $bigScreen_id);
        if ($is_in === false) {
            // controller('crm/Index','controller')->index();
            // exit;
            return false;
        }else{
            return true;
        }
    }

    // 获取网销店下的所有部门
    public function getWxDepartment(){
        $deparment_info = cache('wx_deparment');
        if (!$deparment_info) {
            $shop_info = $this->getShopByType('wx');
            $shop_code = $shop_info['shop_code'];
            $deparment_info = $this->getdeparments($shop_code);
            cache('wx_deparment',$deparment_info);
        }
        
        return $deparment_info;
    }
    // 获取不同类型的店面信息（电商，网销，实体）
    public function getShopByType($param){
        $url = '5a005e0038270';
        switch ($param) {
            case 'ds':
                $data['is_marketing'] = 1;
                break;
            case 'st':
                $data['is_marketing'] = 2;
                break;
            case 'wx':
                $data['is_marketing'] = 3;
                break;
            case 'qd':
                $data['is_marketing'] = 4;
                break;
        }
        $data['brandclass_id']=1;
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $return = $res['data'][0];
        }
        return $return;
    }

    // 根据事业部获取  店 （电商，网销，渠道）
    public function getShops($brandclass_id){
        $url = '5a37a1503264d';
        $data['brandclass_id']= $brandclass_id;
        $res = sx_call($url, $data);
        if ($res['code'] == 200) {
            $shopList = $res['data'];
        }else{
            $shopList = '';
        }
        return $shopList;
    }

    // 获取所有部门信息
    public function getdeparments($shop_code = ''){
        $url = '5a0aef152b750';
        $data['shop_code'] = $shop_code;
        $res = sx_call($url, $data);
        $return = $res['data'];
        return $return;
    }

    // 根据部门id获取所有  小组  信息
    public function getGroups($deparment_id){
        $where = [
            'department_id' => $deparment_id,
        ];
        $groups = db('c_staff_group')->where($where)->select();
        return $groups;
    }

    // 根据shop_code 获取该店加权系数
    public function getShopWeight($shop_code){
        $weight = cache('shopWeight_'.$shop_code);
        if (!$weight) {
            $url = '5a005e0038270';
            $data['shop_code'] = $shop_code;
            $info = sx_call($url, $data);
            if ($info['code'] == 200) {
                $weight = $info['data'][0]['weight'];
                if ($weight == 0) {
                    $weight = 1;
                }
                cache('shopWeight_'.$shop_code, $weight);
            }else{
                $weight = '1';
            }
        }
        return $weight;
    }

    // 获取毛客资  量
    public function getCustomerNum($data){
        // 毛客资定义：电商录入的新客资，不包括网销，渠道录入的客资
        $where['c_from']        = 1;
        $where['is_status']     = 1;
        $where['customer_type'] = 1;
        
        $num = db('c_customerinfo')
            ->where($where)
            ->where('dj_department_id', 'in', $data['ids'])
            ->where('dj_day', 'between time', [$data['start'], $data['end']])
            ->count();

        return $num;
    }

    // 获取有效客资 量
    public function getInvCustomerNum($data){
        // 有效客资定义：毛客资中，标记有效的，
        $where['c_from']        = 1;
        $where['is_valid']      = 1;
        $where['is_status']     = 1;
        $where['customer_type'] = 1;

        $num = db('c_customerinfo')
            ->where($where)
            ->where('dj_department_id', 'in', $data['ids'])
            ->where('yx_day', 'between time', [$data['start'], $data['end']])
            ->count();

        // echo db()->getLastSql();
        // exit;
        return $num;
    }

    // 进店/邀约 量
    public function getIntoCustomerNum($data){
        // 进店/邀约定义：电商、网销录入的新客资  且实际进店，标记为进店进客 
        $where['c_from']        = 1;
        $where['is_status']     = 1;
        $where['is_intostore']  = 2;
        $where['customer_type'] = 1;

        $num = db('c_customerinfo')
            ->where($where)
            ->where('sales_department_id', 'in', $data['ids'])
            ->where('syjd_day', 'between time', [$data['start'], $data['end']])
            ->count();

        // exit;
        return $num;
    }

    // 新单 量
    public function getOrderNumberNum($data){
        // 新单 定义：电商、网销录入的新客资  且已经有效的订单
        $where['c_from']        = 1;
        $where['is_status']     = 1;
        $where['is_success']    = 1;
        $where['customer_type'] = 1;

        $num = db('c_customerinfo')
            ->where($where)
            ->where('sales_department_id', 'in', $data['ids'])
            ->where('order_day', 'between time', [$data['start'], $data['end']])
            ->count();

        // echo db()->getLastSql();
        // exit;
        return $num;
    }

    //其它费用统计
    public function anotherCost($param){
        $start = $param['start'] ? $param['start'] : date('Y-m-d 00:00:00');
        $end   = $param['end'] ? $param['end'] : date('Y-m-d 23:59:59');
        $sql = ' 1=1 ';
        if($param['brandclass_id']){
            $sql .= " and brandclass_id=".intval($param['brandclass_id']);
        }
        // if($param['add_shop_code']){
        //     $add_shop_code = explode(',',$param['add_shop_code']);
        // }
        $info = db('s_another_cost_detail')
            ->where($sql)
            // ->where('shop_code','in',$add_shop_code)
            ->where('cost_date','between time',[$start,$end])
            ->sum('cost_avg');
        return$info;
    }

    // 花费 
    public function costMoney($data){
        // var_dump($data);
        // exit;
        // 新单 定义：电商的花费  s_channel_cost 表
        $allCost = db('s_channel_cost')
            ->where('department_id', 'in', $data['ids'])
            ->where('shop_code', 'in', $data['shop_code'])
            ->where('cost_date', 'between time', [$data['start'], $data['end']])
            ->sum('cost');

        return $allCost;
    }

    // 成交金额
    public function dealMoney($data){
        // 新单 定义：电商、网销录入的新客资转化为订单，消费类型为婚纱，的有效订单 的 一销套系金额  只能查 customer_order表
        // 根据customerinfo 表查 电商、网销 录入的新客资，消费类型为婚纱，已经有效的订单，order_day 为条件时间，根据customer_id，join customer_order表，sum('order_amount')

        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        $where['c.customer_type'] = 1;
        $where['c.consultation_type_id'] = HS_TYPE;
        // $where['c.is_success'] = 1;

        $deal = db('c_customer_order')->alias('o')
            ->join('c_customerinfo c ','c.id = o.customer_id')
            ->where($where)
            ->where('o.order_valid', 2)
            ->where('c.add_shop_code', 'in', $data['add_shop_code'])
            ->where('o.create_time', 'between time', [$data['start'], $data['end']])
            ->sum('o.order_amount');

        // echo db()->getLastSql();
        // exit;
        return $deal;
    }

    // 营收 / 实收
    public function incomeMoney($data){
        // 新单 定义：实际收入，不限 电商还是网销、消费类型、订单状态是否有效 
        $income = db('c_order_detail')->alias('d')
            ->join('c_customer_order o', 'd.order_sn=o.order_sn', 'LEFT')
            ->join('c_customerinfo c', 'c.id=o.customer_id', 'LEFT')
            ->where('c.sales_department_id', 'in', $data['ids'])
            ->where('d.pay_time', 'between time', [$data['start'], $data['end']])
            ->sum('d.order_fact');
        return $income;
    }

}