<?php
/**
 * 报表实现类 锦绣大唐 定制 网销转化数据
 * *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: yuan 2020-06-24 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Jxdt_wx_change_data extends Report {

    private $level= 1;
    private $type = 1;
    private $code = 'code1593321111';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $data = input();
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        // $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        // $shop_code = $det['shop_code'];
        $shop_code = session('shop_code');
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        // 渠道
        if($data['channel_id']){
            $channels = explode(',',$data['channel_id']);
        }else{
            // 来源渠道
            $channels = controller('crm/Customer', 'lib')->getChannel($shop_code);
            $channels = array_column($channels,'channel_name');
        }

        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;
        $where['c.add_shop_code'] = $shop_code;
        // 所有追踪人
        $allStaffs = db('c_customerinfo')
            ->where('dj_day','between',[$start,$end])
            ->where('shop_code',$shop_code)
            ->where('sales_staff_id','>',0)
            ->group('sales_staff')
            ->field('sales_staff,sales_staff_id')->select();
        $sql0 = db()->getLastSql();
        $staffs = array_column($allStaffs,'sales_staff');

        $sql = '';
        $sql .= 'sum(c.dj_day between "'.$start.'" and "'.$end.'") as mkz,';
        $sql .= 'sum(c.dj_day between "'.$start.'" and "'.$end.'" and c.wechat_status=2) as jiaWx,';//已加微信
        $sql .= 'sum(c.syjd_day between "'.$start.'" and "'.$end.'" and c.is_intostore in (\'2\',\'3\',\'5\')) as jd,';
        $sql .= 'sum(c.order_start_time between "'.$start.'" and "'.$end.'" and c.is_success=1) as `order`';        
        // 基础数据
        $info = db('c_customerinfo')->alias('c')
            // ->join('c_customer_from f','c.id=f.cid','left')
            ->where($where)->where($whereT)
            ->where('customer_channel','in',$channels)
            ->where('c.sales_staff','in',$staffs)
            ->group('c.sales_staff')
            ->column($sql, 'c.sales_staff');
        $sql1 = db()->getLastSql();

        $returnData = [];
        $arr = [];
        foreach($staffs as $k=>$v){
            $returnData[$k]['staff_name'] = $v;

            // 转化数据
            $returnData[$k]['mkz'] = $info[$v]['mkz'];
            $returnData[$k]['jiaWx'] = $info[$v]['jiaWx'];
            $returnData[$k]['jiaWxRate'] = $info[$v]['jiaWx'] ? sprintf('%.2f',$info[$v]['jiaWx']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['jd'] = $info[$v]['jd'];
            $returnData[$k]['mkzJdRate'] = $info[$v]['jd'] ? sprintf('%.2f',$info[$v]['jd']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['order'] = $info[$v]['order'];
            $returnData[$k]['mkzOrderRate'] = $info[$v]['order'] ? sprintf('%.2f',$info[$v]['order']/$info[$v]['mkz']*100).'%' : '0%';
        }
        // 加微率排名
        array_multisort(array_column($returnData,"jiaWxRate"),SORT_DESC,$returnData);
        $jw = 1;
        foreach ($returnData as $key => $value) {
            // 排名
            $returnData[$key]['jwl_pm'] = $jw;
            $jw++;
        }
        // 进店率排名
        array_multisort(array_column($returnData,"mkzJdRate"),SORT_DESC,$returnData);
        $jd = 1;
        foreach ($returnData as $key => $value) {
            // 排名
            $returnData[$key]['jdl_pm'] = $jd;
            $jd++;
        }
        // 转化率排名
        array_multisort(array_column($returnData,"mkzOrderRate"),SORT_DESC,$returnData);
        $zh = 1;
        foreach ($returnData as $key => $value) {
            // 排名
            $returnData[$key]['zhl_pm'] = $zh;
            $zh++;
        }
        foreach ($returnData as $key => $value) {
            //总计
            $arr['staff_name'] = '总计';

            $arr['mkz'] += $returnData[$k]['mkz'];
            $arr['jiaWx'] += $returnData[$k]['jiaWx'];
            $arr['jiaWxRate'] = '0%';
            $arr['jd'] += $returnData[$k]['jd'];
            $arr['mkzJdRate'] = '0%';
            $arr['order'] += $returnData[$k]['order'];
            $arr['mkzOrderRate'] = '0%';
        }
        // 总计
        $arr['jiaWxRate'] = $arr['jiaWx'] ? sprintf('%.2f',$arr['jiaWx']/$arr['mkz']*100).'%' : '0%';
        $arr['mkzJdRate'] = $arr['jd'] ? sprintf('%.2f',$arr['jd']/$arr['mkz']*100).'%' : '0%';
        $arr['mkzOrderRate'] = $arr['order'] ? sprintf('%.2f',$arr['order']/$arr['mkz']*100).'%' : '0%';

        $returnData[] = $arr;

        $return['sql0'] = $sql0;
        $return['sql1'] = $sql1;

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($channels);
        $return['data'] = $returnData;
        
        return json($return);
    }
    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        // $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        //来源渠道
        $channel = getChannelJson(session('shop_code'));
        $this->assign("channel", json_encode($channel));
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>session('brandclass_id')]);
        $this->assign("consumptionType", $consumptionType);

        $info = db('s_report_form')->where('code', $code)->field('report_class_name,report_name')->find();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', session('shop_name').'-'.$info['report_name']);

        $this->assign('did', $info['id']);
        $this->assign('today',date('Y-m-d'));
        $this->assign('yestoday',date('Y-m-d',time()));

        return $this->fetch($display);
    }
}