<?php
/**
 * 报表实现类 桔子---网销邀约客服数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong/wangzhenya 2018-05-29 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Jz_wx_group extends Report {

    private $level=1;
    private $type=3;
    private $code='code1540294677';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $title = ['小组', '客资量', '有效量','无效量', '待定量', '网转客资量',  '入店量', '非周末入店量','周末入店量', '成交量', '有效率', '毛客资入店率', '有效客资入店率', '毛客资成交率','有效客资成交率', '入店成交率',  '非周末入店占比','毛客资成本','营业额','成交均价','ROI'];
        $data = input();

//        $shopCode = session('shop_code');
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        if($data['group_name']){
            $group_name = explode(',',$data['group_name']);
            //获取店下的小组
            $groupList = db('c_staff_group')->where('shop_code', $shop_code)->where('group_name','in',$group_name)->select();
        }else{
            $groupList = db('c_staff_group')->where('shop_code', $shop_code)->select();
        }
        if (empty($groupList)) {
            $return = ['code' => 100, 'msg' => '暂无小组，请先去设置小组', 'count' => 0, 'data' => ''];
            return json($return);
        }
        $returnData = [];
        for ($i = 0; $i < count($title); $i++) {
            $returnData[0][$i] = $title[$i];
        }
        // 时间区域
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59',strtotime($data['end']));
        $time = getDates($start,$end);
        $weekend = [];
        foreach($time as $k=>$v){
            if((date('w',strtotime($v))==6) || (date('w',strtotime($v)) == 0)){
                $weekend[] = $v;
            }
        }
        $where['c.is_status'] = 1;
        $where['c.c_from'] = 1;

        if($data['consultation_type_id']){
            $consultation_type_id = intval($data['consultation_type_id']);
            $whereT['c.consultation_type_id'] = $consultation_type_id;
        }

        if ($data['customer_channel']) {
            $data['customer_channel'] = explode(',',$data['customer_channel']);
//            $where['c.customer_channel'] = $data['customer_channel'];
//            $whereCost['channel_name'] = $data['customer_channel'];
        }


        if ($data['province_id']) {
            $where['c.province_id'] = $data['province_id'];
            $whereCost['province_id'] = $data['province_id'];
        }
        if ($data['city_id']) {
            $where['c.city_id'] = $data['city_id'];
            $whereCost['city_id'] = $data['city_id'];
        }
        //获取当前店面的归属店
        $shopinfo = controller('crm/Customer','lib')->get_shop(['belong_shop_code'=>$shop_code]);
        $shopCodes = array_column($shopinfo,'shop_code');
        $shopCode = array_unique($shopCodes);
        foreach($shopCode as $k=>$v){
            if($shop_code == $v){
                unset($shopCode[$k]);
            }
        }
        //花费
        if(!empty($data['customer_channel'])){
            $cost = db('s_channel_cost')->where('shop_code','in',$shopCode)->where($whereCost)->where('channel_name','in',$data['customer_channel'])->where('cost_date','between',[$start,$end])->sum('cost');
        }else{
            $cost = db('s_channel_cost')->where('shop_code','in',$shopCode)->where($whereCost)->where('cost_date','between',[$start,$end])->sum('cost');
        }
        $time = $data['time']  ? $data['time'] : 'dj_day';
        if(empty($group_name)){
            if(!empty($data['customer_channel'])){
                //毛客资
                $mkz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //有效量
                $valid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.is_valid', '1')
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //无效
                $unvalid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '3')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //待定
                $dd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //进店
                $jd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.is_intostore', 'in', [2,3,5])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //非周末入店量
                /*$noWeekendJd =db('c_customerinfo')->alias('c')->join('c_customer_from r','c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code','in',$shop_code)
                    ->where('c.is_intostore', 'in',[2,3])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num','r.sales_group_id');*/
                //周末入店量
                $weekendJd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'in', $weekend)
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //成交量（实际婚纱有效定单数）
                $succ = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.is_success', 1)
                    ->where('c.order_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //实收金额累计(按订单时间计算)
                $fact = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')->join('c_order_detail d', 'd.order_sn=c.order_number')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('d.pay_type', 1)
                    ->where('d.pay_time', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('sum(d.order_fact) as sum', 'r.sales_group_id');
                //网转客资量  网销自己提报的
                $where['c.customer_type'] = 2;
                $wz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('c.yx_day', 'between time', [$start, $end])
                    ->group('r.dj_group_id')
                    ->column('count(c.id) as num', 'r.dj_group_id');
            }else {
                //毛客资
                $mkz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //有效量
                $valid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.is_valid', '1')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //无效
                $unvalid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '3')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //待定
                $dd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //进店
                $jd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //非周末入店量
                /*$noWeekendJd =db('c_customerinfo')->alias('c')->join('c_customer_from r','c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code','in',$shop_code)
                    ->where('c.is_intostore', 'in',[2,3])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num','r.sales_group_id');*/
                //周末入店量
                $weekendJd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'in', $weekend)
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //成交量（实际婚纱有效定单数）
                $succ = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.is_success', 1)
                    ->where('c.order_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //实收金额累计(按订单时间计算)
                $fact = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')->join('c_order_detail d', 'd.order_sn=c.order_number')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('d.pay_type', 1)
                    ->where('d.pay_time', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('sum(d.order_fact) as sum', 'r.sales_group_id');
                //网转客资量  网销自己提报的
                $where['c.customer_type'] = 2;
                $wz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.yx_day', 'between time', [$start, $end])
                    ->group('r.dj_group_id')
                    ->column('count(c.id) as num', 'r.dj_group_id');
            }
        }else{
            if(!empty($data['customer_channel'])){
                //毛客资
                $mkz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //有效量
                $valid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.is_valid', '1')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //无效
                $unvalid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '3')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //待定
                $dd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //进店
                $jd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //非周末入店量
                /*$noWeekendJd =db('c_customerinfo')->alias('c')->join('c_customer_from r','c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code','in',$shop_code)
                    ->where('c.is_intostore', 'in',[2,3])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num','r.sales_group_id');*/
                //周末入店量
                $weekendJd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'in', $weekend)
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //成交量（实际婚纱有效定单数）
                $succ = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.is_success', 1)
                    ->where('c.order_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //实收金额累计(按订单时间计算)
                $fact = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')->join('c_order_detail d', 'd.order_sn=c.order_number')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('d.pay_type', 1)
                    ->where('d.pay_time', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('sum(d.order_fact) as sum', 'r.sales_group_id');
                //网转客资量  网销自己提报的
                $where['c.customer_type'] = 2;
                $wz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('c.customer_channel', 'in', $data['customer_channel'])
                    ->where('r.dj_group_name', 'in', $group_name)
                    ->where('c.yx_day', 'between time', [$start, $end])
                    ->group('r.dj_group_id')
                    ->column('count(c.id) as num', 'r.dj_group_id');
            }else {
                //毛客资
                $mkz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //有效量
                $valid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.is_valid', '1')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //无效
                $unvalid = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '3')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //待定
                $dd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.'.$time, 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //进店
                $jd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //非周末入店量
                /*$noWeekendJd =db('c_customerinfo')->alias('c')->join('c_customer_from r','c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code','in',$shop_code)
                    ->where('c.is_intostore', 'in',[2,3,5])
                    ->where('c.syjd_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num','r.sales_group_id');*/
                //周末入店量
                $weekendJd = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.is_intostore', 'in', [2, 3,5])
                    ->where('c.syjd_day', 'in', $weekend)
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');

                //成交量（实际婚纱有效定单数）
                $succ = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where($whereT)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('c.is_success', 1)
                    ->where('c.order_day', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('count(c.id) as num', 'r.sales_group_id');
                //实收金额累计(按订单时间计算)
                $fact = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')->join('c_order_detail d', 'd.order_sn=c.order_number')
                    ->where($where)
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.sales_group_name', 'in', $group_name)
                    ->where('d.pay_type', 1)
                    ->where('d.pay_time', 'between time', [$start, $end])
                    ->group('r.sales_group_id')
                    ->column('sum(d.order_fact) as sum', 'r.sales_group_id');
                //网转客资量  网销自己提报的
                $where['c.customer_type'] = 2;
                $wz = db('c_customerinfo')->alias('c')->join('c_customer_from r', 'c.id=r.cid')
                    ->where($where)
                    ->where('c.is_valid', '2')
                    ->where('c.shop_code', 'in', $shop_code)
                    ->where('r.dj_group_name', 'in', $group_name)
                    ->where('c.yx_day', 'between time', [$start, $end])
                    ->group('r.dj_group_id')
                    ->column('count(c.id) as num', 'r.dj_group_id');
            }
        }


        $returnData = [];
        $arr = [];
        $px = [];
        $arr['name'] = '总计';
        foreach($groupList as $k=>$v){
            $px['name'] = $v['group_name'];
            $px['mkz'] = $mkz[$v['id']] ? $mkz[$v['id']] : '';
            $px['valid'] = $valid[$v['id']] ? $valid[$v['id']] : '';
            $px['unvalid'] = $unvalid[$v['id']] ? $unvalid[$v['id']] : '';
            $px['dd'] = $dd[$v['id']] ? $dd[$v['id']] : '';
            $px['wz'] = $wz[$v['id']] ? $wz[$v['id']] : '';
            $px['jd'] = $jd[$v['id']] ? $jd[$v['id']] : '';
            $px['weekendJd'] = $weekendJd[$v['id']] ? $weekendJd[$v['id']] : '';
            $px['noWeekendJd'] = $jd[$v['id']] ? $jd[$v['id']]-$weekendJd[$v['id']] : '';
            $px['succ'] = $succ[$v['id']] ? $succ[$v['id']] : '';
            $px['validRate'] = $valid[$v['id']] ? sprintf('%.2f',$valid[$v['id']]/$mkz[$v['id']]*100).'%' : '';
            $px['mkzJdRate'] = $jd[$v['id']] ? sprintf('%.2f',$jd[$v['id']]/$mkz[$v['id']]*100).'%' : '';
            $px['validJdRate'] = $jd[$v['id']] ? sprintf('%.2f',$jd[$v['id']]/$valid[$v['id']]*100).'%' : '';
            $px['mkzSuccRate'] = $succ[$v['id']] ? sprintf('%.2f',$succ[$v['id']]/$mkz[$v['id']]*100).'%' : '';
            $px['validSuccRate'] = $succ[$v['id']] ? sprintf('%.2f',$succ[$v['id']]/$valid[$v['id']]*100).'%' : '';
            $px['jdSuccRate'] = $succ[$v['id']] ? sprintf('%.2f',$succ[$v['id']]/$jd[$v['id']]*100).'%' : '';
            $px['noWeekendJdRate'] = $jd[$v['id']] ? sprintf('%.2f',$jd[$v['id']]/$px['noWeekendJd']*100).'%' : '';
            $px['mkzCost'] = $cost ? sprintf('%.2f',$cost/$mkz[$v['id']]) : '';
            $px['fact'] = $fact[$v['id']] ? sprintf('%.2f',$fact[$v['id']]) : '';
            $px['avg'] = $fact[$v['id']] ? sprintf('%.2f',$fact[$v['id']]/$succ[$v['id']]) : '';
            $px['roi'] = $cost ? sprintf('%.2f',$cost/$fact[$v['id']]).':1' : '';
            array_push($returnData,$px);
            $arr['mkz'] += $px['mkz'];
            $arr['valid'] += $px['valid'];
            $arr['unvalid'] += $px['unvalid'];
            $arr['dd'] += $px['dd'];
            $arr['wz'] += $px['wz'];
            $arr['jd'] += $px['jd'];
            $arr['weekendJd'] += $px['weekendJd'];
            $arr['noWeekendJd'] += $px['noWeekendJd'];
            $arr['succ'] += $px['succ'];
            $arr['validRate'] = '';
            $arr['mkzJdRate'] = '';
            $arr['validJdRate'] = '';
            $arr['mkzSuccRate'] = '';
            $arr['validSuccRate'] = '';
            $arr['jdSuccRate'] = '';
            $arr['noWeekendJdRate'] = '';
            $arr['mkzCost'] = '';
            $arr['fact'] += floatval($px['fact']);
            $arr['avg'] = '';
            $arr['roi'] = '';
            $i++;
        }
        $arr['validRate'] = sprintf('%.2f',$arr['valid']/$arr['mkz'] * 100).'%';//有效率
        $arr['mkzJdRate'] = sprintf('%.2f',$arr['jd']/$arr['mkz'] * 100).'%';//毛客资进店率
        $arr['validJdRate'] = sprintf('%.2f',$arr['jd']/$arr['valid'] * 100).'%';//有效客资进店率
        $arr['mkzSuccRate'] = sprintf('%.2f',$arr['succ']/$arr['mkz'] * 100).'%';//毛客资成交率
        $arr['validSuccRate'] = sprintf('%.2f',$arr['succ']/$arr['valid'] * 100).'%';//有效客资成交率
        $arr['jdSuccRate'] = sprintf('%.2f',$arr['succ']/$arr['jd'] * 100).'%';//有效客资成交率
        $arr['noWeekendJdRate'] = sprintf('%.2f',$arr['jd']/$arr['noWeekendJd'] * 100).'%';//非周末进店率
        $arr['mkzCost'] = $cost ? sprintf('%.2f',$cost/$arr['mkz']) : '';//毛客资成本
        $arr['avg'] = $arr['fact'] ? sprintf('%.2f',$arr['fact']/$arr['succ']) : '';//成交均价
        $arr['roi'] =  $cost ? sprintf('%.2f',$cost/$arr['fact']).':1' : '';//成交均价
        array_push($returnData,$arr);

        // 导出
        if ($data['need'] == 1) {
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            $return['code'] = 0;
            $return['msg'] = '';
            $return['count'] = count($returnData);
            $return['data'] = $returnData;
            return json($return);
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('shopList', $shop);
        //消费类型
        $consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
         //来源渠道
        //获取当前店面的归属店
       /* $shopinfo = controller('crm/Customer','lib')->get_shop(['belong_shop_code'=>$info['shop_code']]);
        $shopCodes = array_column($shopinfo,'shop_code');
        $shopCode = array_unique($shopCodes);
        foreach($shopCode as $k=>$v){
            if($info['shop_code'] != $v){
                $shopCode = $v;
            }
        }*/
         $channels = getChannelJson($info['shop_code']);
         $this->assign('channel', json_encode($channels));
        //获取店下的小组
        $groupList = db('c_staff_group')->where('shop_code', $info['shop_code'])->select();
        $group = [];
        foreach($groupList as $k=>$v){
            $group[$k]['title'] = $v['group_name'];
            $group[$k]['value'] = $v['id'];
            $group[$k]['data'] = [];
        }
        $this->assign('group', json_encode($group));
//        //查询事业部下的电商店
//        $shop = controller('crm/Customer','lib')->shop(['belong_shop_code'=>session('shop_code'),'is_marketing'=>1]);
//        array_push($shop,['shop_code'=>session('shop_code'),'shop_name'=>session('shop_name')]);


        // 客资标记
        $signs = db('STracksign')->where('shop_code',$info['shop_code'])->where('is_delete',1)->select();
        $this->assign('signs', $signs);
        // crm省    列表
        /*$data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $this->assign('province', $province);*/
        //获取方式
        $accessModel = controller("Customer", "lib")->accessModel(array('shop_code' => $info['shop_code']));
        $this->assign("accessModel", $accessModel);

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}