<?php
/**
 * 报表实现类 集团目标管理模块
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-11-01 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Ls_company_goal_data extends Report {

    private $level=1;
    private $type=3;
    private $code='code1542264250';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        // 时间区域
        if (!$data['start']) {
            $return = ['code' => 200, 'msg' => '请选择开始时间', 'count' => 0, 'data' => '',];
            return json($return);
        }
        $month = date('Y-m', strtotime($data['start']));

        $start = date('Y-m-01', strtotime($data['start']));
        $day = date('t',strtotime($month));//当月天数
        if($month == date('Y-m')){ //今天几号
            $thisDay = date('d');
        }else{
            $thisDay = $day;
        }

        $end = date("Y-m-$day 23:59:59", strtotime($month));

        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.brandclass_id,f.report_class_name')->find();
        $brandclass_id = $det['brandclass_id'];
        if(empty($brandclass_id)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $goal = db('s_shop_goal')->where('month',$month)->where('brandclass_id',$brandclass_id)->select();
        if(empty($goal)){
            return array('code'=>101,'msg'=>'本月未设定店面目标，请先去设置');
        }
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['brandclass_id'] = $brandclass_id;


        $shop = controller('crm/Customer','lib')->get_shop(['brandclass_id'=>$brandclass_id,'is_marketing'=>2]);
        //店面目标
        $goal = db('s_shop_goal')->where('brandclass_id',$brandclass_id)->where('month',$month)->column('fact,jd,order,cus,cost','shop_code');
        $sql = '';
        $sql .= "sum(dj_day between '$start' and '$end') as cus,";//毛客资
        $sql .= "sum(is_intostore in (2,3) and syjd_day between '$start' and '$end') as jd,";//进店
//        $sql .= "sum(is_success=1 and order_day between '$start' and '$end') as `order`";//订单
        $sql .= "sum(((order_type=1 and fact_money>=500)or(order_type=2 and fact_money>=100)) and order_start_time between '$start' and '$end') as `order`";//订单


        $info = db('c_customerinfo')
            ->where($where)
            ->group('shop_code')
            ->column($sql,'shop_code');
        //实收
        $whereTx['c.is_status'] = 1;
        $whereTx['c.c_from'] = 1;
        $whereTx['c.brandclass_id'] = $brandclass_id;
        $fact = db('c_customerinfo')->alias('c')->join('c_order_detail d','c.order_number=d.order_sn')
            ->where($whereTx)
            ->where('d.pay_time', 'between time', [$start, $end])
            ->group('c.shop_code')
            ->column('sum(d.order_fact) as fact','c.shop_code');
        //预算(花费)
        $cost = db('s_channel_cost')
            ->where('brandclass_id',$brandclass_id)
            ->where('cost_date','between',[$start,$end])
            ->group('belong_shop_code')
            ->column('sum(cost)','belong_shop_code');
        $returnData = [];
        $arr = [];
        foreach($shop as $k=>$v){
            $arr['shop_name'] = $v['shop_name'];
            $arr['goal_fact'] = $goal[$v['shop_code']]['fact'];
            $arr['goal_jd'] = $goal[$v['shop_code']]['jd'];
            $arr['goal_order'] = $goal[$v['shop_code']]['order'];
            $arr['goal_cus'] = $goal[$v['shop_code']]['cus'];
            $arr['goal_cost'] = $goal[$v['shop_code']]['cost'];
            //目标平均数
            $avgFact = $arr['goal_fact']/$day;
            $avgJd = $arr['goal_js']/$day;
            $avgOrder = $arr['goal_order']/$day;
            $avgCus = $arr['goal_cus']/$day;
            $avgCost = $arr['goal_cost']/$day;
            //截止应完成
            $arr['fact'] = $goal[$v['shop_code']]['fact'] ? round($avgFact*$thisDay) : '';
            $arr['jd'] = $goal[$v['shop_code']]['jd'] ? round($avgJd*$thisDay) : '';
            $arr['order'] = $goal[$v['shop_code']]['order'] ? round($avgOrder*$thisDay) : '';
            $arr['cus'] = $goal[$v['shop_code']]['cus'] ? round($avgCus*$thisDay) : '';
            $arr['cost'] = $goal[$v['shop_code']]['cost'] ? round($avgCost*$thisDay) : '';
            //截止实际完成
            $arr['to_fact'] = $fact[$v['shop_code']] ? $fact[$v['shop_code']] : '';
            $arr['to_jd'] = $info[$v['shop_code']]['jd'] ? $info[$v['shop_code']]['jd'] : '';
            $arr['to_order'] = $info[$v['shop_code']]['order'] ? $info[$v['shop_code']]['order'] : '';
            $arr['to_cus'] = $info[$v['shop_code']]['cus'] ? $info[$v['shop_code']]['cus'] : '';
            $arr['to_cost'] = $cost[$v['shop_code']] ? $cost[$v['shop_code']] : '';
            //接下来每日任务
            $arr['yu_fact'] = $fact[$v['shop_code']] ? $goal[$v['shop_code']]['fact']-$fact[$v['shop_code']] : '';
            $arr['yu_jd'] = $info[$v['shop_code']]['jd'] ? $goal[$v['shop_code']]['jd']-$info[$v['shop_code']]['jd'] : '';
            $arr['yu_order'] = $info[$v['shop_code']]['order'] ? $goal[$v['shop_code']]['order']-$info[$v['shop_code']]['order'] : '';
            $arr['yu_cus'] = $info[$v['shop_code']]['cus'] ? $goal[$v['shop_code']]['cus']-$info[$v['shop_code']]['cus'] : '';
            $arr['yu_cost'] = $cost[$v['shop_code']] ? $goal[$v['shop_code']]['cost']-$cost[$v['shop_code']] : '';
            $returnData[] = $arr;
        }
        // 导出
        if ($data['need'] == 1) {
            $title = ['店面', '实收','进店量', '订单量', '客资量', '预算','实收(应完成)','进店量(应完成)', '订单量(应完成)', '客资量(应完成)', '预算(应完成)','实收(实际完成)','进店量(实际完成)', '订单量(实际完成)', '客资量(实际完成)', '预算(实际完成)','实收(每日任务)','进店量(每日任务)', '订单量(每日任务)', '客资量(每日任务)', '预算(每日任务)'];
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['brandclass_id'=>$brandclass_id]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            $return['code'] = 0;
            $return['msg'] = '';
            $return['count'] = count($returnData);
            $return['data'] = $returnData;
            return json($return);
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.brandclass_id,f.report_class_name')->find();
        $this->assign('brandclass_id', $info['brandclass_id']);

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $title);
        //查询事业部下的电商店
//        $shop = controller('crm/Customer','lib')->shop(['belong_shop_code'=>session('shop_code'),'is_marketing'=>1]);
//        $this->assign('shop', $shop);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}