<?php
/**
 * Created by PhpStorm.
 * User: sx01
 * Date: 2018/6/4
 * Time: 10:07
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\Session;

class Qd_data extends Report
{

    private $level = 3;
    private $type = 4;
    private $code = 'code1528080733';

    public function getLevel()
    {
        return $this->level;
    }

    public function getType()
    {
        return $this->type;
    }

    public function getCode()
    {
        return $this->code;
    }

    public function data()
    {
        $param = input();
        $bid = session('brandclass_id');
        $start = $param['start'] ? date('Y-m-d', strtotime($param['start'])) : date('Y-m-d',strtotime('-1 days'));
        $end =  $param['end'] ? date('Y-m-d 23:59:59', strtotime($param['end'])) : date('Y-m-d 23:59:59',strtotime('-1 days'));
        $time = getMonths(['start'=>$start,'end'=>$end]);
        //店面
            //获取事业部下的渠道店面
//        $shop = controller('crm/Customer','lib')->get_shop(['brandclass_id'=>$bid,'is_marketing'=>4]);
//        if(count($shop)== 0){
//            return array('code'=>100,'msg'=>'未发现渠道店');
//        }
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$param['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $bid = $det['brandclass_id'];
        if(empty($bid)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $shop = controller('crm/Customer','lib')->get_shop(['brandclass_id'=>$bid]);
        $returnData = [];
        $shops = array_column($shop,'shop_code');
        $where = [];
        if($param['staff'] == 'sales'){
            $day = 'dj_day';
            $shop_code = 'shop_code';
        }else{
            $day = 'dj_day';
            $shop_code = 'add_shop_code';
            $where['customer_type'] = 2;
        }
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        if($det['brandclass_id'] !=8){
            $whereT['consultation_type_id'] = HS_TYPE;
        }
//        foreach($time as $key=>$val){
            // $table = db('d_customerinfo_'.$key);
            $table = db('c_customerinfo');
            //毛客资
            $allCustomer = $table->where('brandclass_id',$bid)->where($shop_code,'in',$shops)->where($day,'between',[$start,$end])->where($where)->group($shop_code)->column('count(*) as num',$shop_code);
            //婚纱有效客资
            $valid =  $table->where($whereT)->where('brandclass_id',$bid)->where('is_valid',1)->where($shop_code,'in',$shops)->where($where)->where('yx_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //总有效客资
            $allvalid =  $table->where('brandclass_id',$bid)->where('is_valid',1)->where($shop_code,'in',$shops)->where($where)->where('yx_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //无效客资
            $unvalid =  $table->where('brandclass_id',$bid)->where('is_valid',3)->where($shop_code,'in',$shops)->where($where)->where('yx_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //A客
            $a =  $table->where('brandclass_id',$bid)->where('sign_name','A客')->where($shop_code,'in',$shops)->where($where)->where('sign_time','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //B客
            $b =  $table->where('brandclass_id',$bid)->where('sign_name','B客')->where($shop_code,'in',$shops)->where($where)->where('sign_time','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //C客
            $c =  $table->where('brandclass_id',$bid)->where('sign_name','C客')->where($shop_code,'in',$shops)->where($where)->where('sign_time','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //婚纱预约进店
            $yy =  $table->where('consultation_type_id',HS_TYPE)->where('brandclass_id',$bid)->where($shop_code,'in',$shops)->where($where)->where('yjd_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //总预约进店
            $allyy =  $table->where('brandclass_id',$bid)->where($shop_code,'in',$shops)->where($where)->where('yjd_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //婚纱进店
            $jd =  $table->where('consultation_type_id',HS_TYPE)->where('brandclass_id',$bid)->where('is_intostore','in',[2,3])->where($shop_code,'in',$shops)->where($where)->where('syjd_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //总进店
            $alljd =  $table->where('brandclass_id',$bid)->where('is_intostore','in',[2,3])->where($shop_code,'in',$shops)->where($where)->where('syjd_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //婚纱成交
            $succ =  $table->where('consultation_type_id',HS_TYPE)->where('brandclass_id',$bid)->where('is_success',1)->where($shop_code,'in',$shops)->where($where)->where('order_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
            //总成交
            $allSucc =  $table->where('brandclass_id',$bid)->where('is_success',1)->where($shop_code,'in',$shops)->where($where)->where('order_day','between',[$start,$end])->group($shop_code)->column('count(*) as num',$shop_code);
//        }

        $tot = [];
        foreach($shop as $k=>$v){
            $arr = [];
            $arr['shop'] = $v['shop_name'];
            $arr['mkz'] = $allCustomer[$v['shop_code']];
            $arr['valid'] = $valid[$v['shop_code']];
            $arr['allvalid'] = $allvalid[$v['shop_code']];
            $arr['unvalid'] = $unvalid[$v['shop_code']];
            $arr['a'] = $a[$v['shop_code']];
            $arr['b'] = $b[$v['shop_code']];
            $arr['c'] = $c[$v['shop_code']];
            $arr['yy'] = $yy[$v['shop_code']];
            $arr['allyy'] = $allyy[$v['shop_code']];
            $arr['jd'] = $jd[$v['shop_code']];
            $arr['jdRate'] = $arr['yy']==0 ? '0%' : sprintf('%.2f',$arr['jd']/$arr['yy']*100).'%';//进店率  进店/邀约
            $arr['alljd'] = $alljd[$v['shop_code']];
            $arr['alljdRate'] = $arr['allyy']==0 ? '0%' : sprintf('%.2f',$arr['alljd']/$arr['allyy']*100).'%';//进店率  进店/邀约
            $arr['succ'] = $succ[$v['shop_code']];
            $arr['succRate']  = $arr['succ']==0 ? '0%' : sprintf('%.2f',$arr['succ']/$arr['jd']*100).'%';//成交率  成交/进店
            $arr['allSucc'] = $allSucc[$v['shop_code']];
            $arr['allSuccRate']  = $arr['allSucc']==0 ? '0%' : sprintf('%.2f',$arr['allSucc']/$arr['alljd']*100).'%';//成交率  成交/进店
            array_push($returnData,$arr);
            /*if(count($shop) > 1){
                //总计
                $tot['mkz'] += $arr['mkz'];
                $tot['valid'] += $arr['valid'];
                $tot['allvalid'] += $arr['allvalid'];
                $tot['unvalid'] += $arr['unvalid'];
                $tot['a'] += $arr['a'];
                $tot['b'] += $arr['b'];
                $tot['c'] += $arr['c'];
                $tot['yy'] += $arr['yy'];
                $tot['allyy'] += $arr['allyy'];
                $tot['jd'] += $arr['jd'];
                $tot['alljd'] += $arr['alljd'];
                $tot['succ'] += $arr['succ'];
                $tot['allSucc'] += $arr['allSucc'];
            }*/
        }
//        print_r($returnData);die;
//        if(count($shop)> 1){
            //总计
            /*$total = [];
            $total['shop'] = '总计';
            $total['mkz'] = $tot['mkz'];
            $total['valid'] = $tot['valid'];
            $total['allvalid'] = $tot['allvalid'];
            $total['unvalid'] = $tot['unvalid'];
            $total['a'] = $tot['a'];
            $total['b'] = $tot['b'];
            $total['c'] = $tot['c'];
            $total['yy'] = $tot['yy'];
            $total['allyy'] = $tot['allyy'];
            $total['jd'] = $tot['jd'];
            $total['jdRate']  = $total['yy']==0 ? '0%' : sprintf('%.2f',$total['jd']/$total['yy']*100).'%';//进店率  进店/邀约
            $total['alljd'] = $tot['alljd'];
            $total['alljdRate']  = $total['allyy']==0 ? '0%' : sprintf('%.2f',$total['alljd']/$total['allyy']*100).'%';//进店率  进店/邀约
            $total['succ'] += $tot['succ'];
            $total['succRate']  = $total['succ']==0 ? '0%' : sprintf('%.2f',$total['succ']/$total['jd']*100).'%';//成交率  成交/进店
            $total['allSucc'] = $tot['allSucc'];
            $total['allSuccRate']  = $total['allSucc']==0 ? '0%' : sprintf('%.2f',$total['allSucc']/$total['alljd']*100).'%';//成交率  成交/进店
            array_push($returnData,$total);*/
            // 导出
            if ($param['need'] == 1) {
                $title = ['店面','毛客资','婚纱有效','总有效','无效客资','A客','B客','C客','婚纱邀约','总邀约','婚纱进店','婚纱进店率','总进店','总进店率','婚纱成交','婚纱成交率','总成交','总成交率'];
                $code = $this->getCode();
                $ff = db('s_report_form')->where('code', $code)->value('report_name');
                $shopInfo = controller('crm/Customer','lib')->getBrands(['shop_code'=>$shop_code]);
                $file = $shopInfo[0]['shop_name'].'-'.$ff.'.xlsx';
                controller("crm/Customer", "lib")->export($title, $returnData, $file);
            } else {
                $return['code'] = 0;
                $return['msg'] = '';
                $return['count'] = count($returnData);
                $return['data'] = $returnData;
                return json($return);
            }
        }
//    }
    public function show()
    {
        $code = $this->getCode();

        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->getBrands(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign('title', $shop[0]['brandclass'].'-'.$title);
        $this->assign('yestoday',date('Y-m-d',strtotime('-1 day')));
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }
}