/**
 * Created by sff on 2018/1/3.
 */

$(function(){
    //设置尺寸
    function setRem ()// 绑定到窗口的这个事件中
    {
        var whdef = 100/1920;// 表示1920的设计图,使用100PX的默认值
        var wH = window.innerHeight;// 当前窗口的高度
        var wW = window.innerWidth<=1920?1920:window.innerWidth;// 当前窗口的宽度
        var rem = wW * whdef;// 以默认比例值乘以当前窗口宽度,得到该宽度下的相应FONT-SIZE值
        $('html').css('font-size', rem + "px");
    }
    setRem ();
    $(window).resize(function(){
        setRem ();
        window.location.reload();
    });
    // 右上角时间显示
    $("#Timer").text(new Date().toLocaleString());
    setInterval(function(){
        $("#Timer").text(new Date().toLocaleString());
    },1000);

    // 第一部分  顶部四块 月进度
    getTarget();

    // 第二部分  1  实时数据
    baseData();
    // 第二部分  2  两个排行榜
    rankData();
    // 第二部分  3  客资渠道分布
    channelCustomer();
    // 第二部分  4  时段数据
    timeCustomer();

    // 第三部分  1  本月毛客资量走势
    monthCustomerNumber();
    // 第三部分  2  本月网销邀约量走势
    monthIntoNumber();
    // 第三部分  3  本月网络新单量走势
    monthNewOrderNumber();
    // 第三部分  4  本月转化率 （ 新单 / 有效获取 ） 走势 图
    monthOrderRateNumber();
    // 第三部分  5  转化漏斗 （日） 图
    dayChangeRate();
    // 第三部分  6  转化漏斗 （月） 图
    monthChangeRate();

});

// 第一部分  顶部四块 月进度
function getTarget () {
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/getTarget',
        success: function(res){
            if (res) {
                // 罗马
                $("#lm_alread").html(res.lm_alread);
                $("#lm_target").html(res.lm_target);
                // 旅拍
                $("#lp_alread").html(res.lp_alread);
                $("#lp_target").html(res.lp_target);
                // 名匠
                $("#mj_alread").html(res.mj_alread);
                $("#mj_target").html(res.mj_target);
                // 依莎
                $("#ys_alread").html(res.ys_alread);
                $("#ys_target").html(res.ys_target);
                // 顶部进度条
                var pecent=0;
                var progressFn=function(){
                    for(var i=0;i<$(".li-wrap").length;i++){
                        pecent=($(".li-wrap").eq(i).find(".mounth-num").html()/$(".li-wrap").eq(i).find(".count-num").html()*100).toFixed(2);
                        $(".li-wrap").eq(i).find(".progress-value").html(pecent+'%');
                        $(".li-wrap").eq(i).find(".progress-bar").css('width',pecent>100?100+'%':pecent+'%');
                    }
                };
                progressFn();
            };
        },
        // error:function(){
        //     baseData(brandclass_id);
        // }
    })
}

// 第二部分  1  实时数据
function baseData () {
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/baseData',
        success: function(res){
            if (res) {
                $("#allCus").html(res.allCus);
                $("#cost").html(res.cost);
                $("#validCustomer").html(res.validCustomer);
                $("#validObtail").html(res.validObtail);

                $("#money").html(res.money);
                $("#intoCustomer").html(res.intoCustomer);
                $("#orderCustomer").html(res.orderCustomer);
                $("#succRate").html(res.succRate);
                
                $("#dayChangeRateData").html('日转化率：'+res.dayChangeRate);
                $("#monthChangeRateData").html('月转化率：'+res.monthChangeRate);
            };
        },
        // error:function(){
        //     baseData(brandclass_id);
        // }
    })
}
// 第二部分  2  两个排行榜
function rankData () {
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/rankData',
        success: function(res){
            if (res) {
                // 毛客资
                var customerNum = res.customerNum;
                var ret1 = '';
                var j1 = 0;
                for(var i = 0; i < customerNum.length; i++){
                    j1 = i+1;
                    ret1 += '<tr><td>'+(j1)+'</td><td>'+customerNum[i]['name']+'</td><td>'+customerNum[i]['dayNum']+'/<small>'+customerNum[i]['monthNum']+'</small></td><td></td></tr>'
                }
                $('#customerNum').html(ret1);

                // 新单
                var orderNum = res.orderNum;
                var ret2 = '';
                var j2 = 0;
                for(var i = 0; i < orderNum.length; i++){
                    j2 = i+1;
                    ret2 += '<tr><td>'+(j2)+'</td><td>'+orderNum[i]['name']+'</td><td>'+orderNum[i]['dayNum']+'/<small>'+orderNum[i]['monthNum']+'</small></td><td></td></tr>'
                }
                $('#orderNum').html(ret2);
            };
        }
    })
}
// 第二部分  3  客资渠道分布
function channelCustomer () {
    //中间右侧图表
    var kzChart = echarts.init(document.getElementById('kzChart'));
    kzChart.clear();

    kzChart.setOption({
        color: ['#fcdd7f'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'13%',
            y:'5%',
            x2:'5%',
            y2:"45%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            },
            textStyle: {
                fontSize: 12,
                color: '#fff'
            },
            axisLabel : {
                show:true,
                interval: 1,
                rotate:  45,
                margin: 8

            }
        },
        yAxis: {
            type: 'value',
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [
            {
                name:'毛客资量',
                type:'bar',
                barWidth: '40%',
                data:[]
            }
        ]
    })
    
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/channelCustomer',
        success: function(res){
            // console.log(res);
            kzChart.setOption({
                xAxis:{
                    data:res.names
                },
                series: [{
                    data:res.datas
                }]
            });
        }
    })
}
// 第二部分  4  时段数据
function timeCustomer () {
    var timeChart = echarts.init(document.getElementById('timeChart'));
    timeChart.clear();

    timeChart.setOption({
        color: ['#ffae95'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'15%',
            y:'5%',
            x2:'5%',
            y2:"38%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            data: ['0/12点','12/16点','16/20点','20/24点'],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            },
             axisLabel : {
                 show:true,
                 interval: 1
             }
        },
        yAxis: {
            type: 'value',
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [
            {
                name:'毛客资量',
                type:'bar',
                barWidth: '30%',
                data:[]
            }
        ]
    })

    $.ajax({
        type: 'POST',
        url : '/crm/Rome/timeCustomer',
        success: function(res){
            // console.log(res);
            timeChart.setOption({
                series: [{
                    data:res.datas
                }]
            });
        }
    })
}

// 第三部分  1  本月毛客资量走势 图
function monthCustomerNumber () {
    // 基于准备好的dom，初始化echarts实例
    var monthCustomerNumber = echarts.init(document.getElementById('chart1'));
    monthCustomerNumber.clear();

    monthCustomerNumber.setOption({
        color: ['#66e0ff'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'14%',
            y:'4%',
            x2:'5%',
            y2:"30%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
                type: 'value',
                min:0,
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
        },
        series: [
            {
                name:'毛客资量',
                type:'bar',
                data:[]
            }
        ]
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/monthCustomerNumber',
        success: function(res){
            arr.push({
                name:res.data[0].name,
                data:res.data[0].data,
                type: 'bar',
                // label: labelOption,
            })
            monthCustomerNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 第三部分  2  本月网销邀约 （进店） 量走势 图
function monthIntoNumber () {
    // 基于准备好的dom，初始化echarts实例
    var monthIntoNumber = echarts.init(document.getElementById('chart2'));
    monthIntoNumber.clear();

    monthIntoNumber.setOption({
        color: ['#fcdd7f'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'14%',
            y:'4%',
            x2:'5%',
            y2:"30%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            type: 'value',
            // max:800,
            // min:0,
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/monthIntoNumber',
        success: function(res){
            arr.push({
                name:res.data[0].name,
                data:res.data[0].data,
                type: 'bar',
                // label: labelOption,
            })
            monthIntoNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 第三部分  3  本月网络新单量走势 图
function monthNewOrderNumber () {
    // 基于准备好的dom，初始化echarts实例
    var monthNewOrderNumber = echarts.init(document.getElementById('chart3'));
    monthNewOrderNumber.clear();

    monthNewOrderNumber.setOption({
        color: ['#00ffd6'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'14%',
            y:'4%',
            x2:'5%',
            y2:"30%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            type: 'value',
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [],
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/monthNewOrderNumber',
        success: function(res){
            arr.push({
                name:res.data[0].name,
                data:res.data[0].data,
                type: 'bar',
                // label: labelOption,
            })
            monthNewOrderNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 第三部分  4  本月转化率 （ 新单 / 有效获取 ） 走势 图
function monthOrderRateNumber (){
    // 基于准备好的dom，初始化echarts实例
    var monthOrderRateNumber = echarts.init(document.getElementById('chart4'));
    monthOrderRateNumber.clear();

    monthOrderRateNumber.setOption({
        color: ['#ffae95'],
        tooltip: {
            trigger: 'axis'
        },
        grid: {
            x:'14%',
            y:'4%',
            x2:'5%',
            y2:"30%",
            borderWidth:1
        },
        xAxis:  {
            type: 'category',
            boundaryGap: false,
            data: [],
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            type: 'value',
            min: 0,
            max: 100,
            interval: 25,
            axisLabel: {
                formatter: '{value} %'
            },
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        series: [
            {
                type:'line',
                data:[]
            }
        ]
    });
    var arr=[];
    var labelOption = {
        normal: {
            show: true,
            position: 'top',
        }
    };
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/monthOrderRateNumber',
        success: function(res){
            for(var i=0;i<res.data.length;i++){
                arr.push({
                    name:res.data[i].name,
                    data:res.data[i].data,
                    type: 'line',
                    // label: labelOption,
                })
            }
            monthOrderRateNumber.setOption({
                xAxis: {
                    data: res.timezone
                },
                series: arr
            });
        }
    })
}
// 第三部分  5  转化漏斗 （日） 图
function dayChangeRate () {
    // 基于准备好的dom，初始化echarts实例
    var dayChangeRate = echarts.init(document.getElementById('topChar1'));
    dayChangeRate.clear();

    dayChangeRate.setOption({
        title: {
            // text: '转化漏斗（日）',
        },
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            }
        },
        color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
        legend: {
            data: ['毛客资量','有效客资','进店','订单'],
            itemWidth: 15,
            itemHeight: 10,
            itemGap: 5,
            textStyle: {
                fontSize: 12,
                color: '#fff'
            }
        },
        grid: {
            x:'10%',
            y:'20%',
            x2:'10%',
            y2:"15%",
            borderWidth:1
        },
        xAxis: {
            type: 'value',
            axisLabel: {
                formatter: '{value}'
            },
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            show:false,
            type: 'category'
        },
        series: [],
    });
    var arr=[];
    var seriesLabel = {
        normal: {
            show: true,
            position: 'right'
            //textBorderColor: '#333',
            //textBorderWidth: 2
        }
    };

    $.ajax({
        type: 'POST',
        url : '/crm/Rome/dayChangeRate',
        success: function(res){
            for(var i=0;i<res.length;i++){
                arr.push({
                    name: res[i].name,
                    data: [res[i].data],
                    type: 'bar',
                    label: seriesLabel,
                })
            }
            dayChangeRate.setOption({
                series: arr
            });
        }
    })
}
// 第三部分  6  转化漏斗 （月） 图
function monthChangeRate () {
    // 基于准备好的dom，初始化echarts实例
    var monthChangeRate = echarts.init(document.getElementById('topChar2'));
    monthChangeRate.clear();

    monthChangeRate.setOption({
        tooltip: {
            trigger: 'axis',
            axisPointer: {
                type: 'shadow'
            }
        },
        color:['#ffaf74','#65fbe3','#85e6ff','#fcdd7f'],  //手动设置每个图例的颜色
        legend: {
            data: ['毛客资量','有效客资','获取手机','进店','订单'],
            itemWidth: 15,
            itemHeight: 10,
            itemGap: 5,
            textStyle: {
                fontSize: 12,
                color: '#fff'
            }
        },
        grid: {
            x:'10%',
            y:'20%',
            x2:'10%',
            y2:"15%",
            borderWidth:1
        },
        xAxis: {
            type: 'value',
            axisLabel: {
                formatter: '{value}'
            },
            axisLine:{
                lineStyle:{
                    color:'#fff',
                    width:1
                }
            }
        },
        yAxis: {
            show:false,
            type: 'category'
        },
        series: [],
    });
    var arr=[];
    var seriesLabel = {
        normal: {
            show: true,
            position: 'right'
            //textBorderColor: '#333',
            //textBorderWidth: 2
        }
    };
    $.ajax({
        type: 'POST',
        url : '/crm/Rome/monthChangeRate',
        success: function(res){
            for(var i=0;i<res.length;i++){
                arr.push({
                    name: res[i].name,
                    data: [res[i].data],
                    type: 'bar',
                    label: seriesLabel,
                })
            }
            monthChangeRate.setOption({
                series: arr
            });
        }
    })
}
