/**
 * Created by sff on 2018/1/3.
 */
$(function(){
    //设置尺寸
    function setRem (){ // 绑定到窗口的这个事件中
        var whdef = 100/1920;// 表示1920的设计图,使用100PX的默认值
        var wH = window.innerHeight;// 当前窗口的高度
        var wW = window.innerWidth<=1920?1920:window.innerWidth;// 当前窗口的宽度
        var rem = wW * whdef;// 以默认比例值乘以当前窗口宽度,得到该宽度下的相应FONT-SIZE值
        $('html').css('font-size', rem + "px");
    }
    setRem ();
    $(window).resize(function(){
        setRem ();
        window.location.reload();
    });
    // 右上角时间显示
    $("#Timer").text(new Date().toLocaleString());
    setInterval(function(){
        $("#Timer").text(new Date().toLocaleString());
    },1000);
    /* ---------------------------------------------  页面开始的时候加载的数据 start  --------------------------------------------- */
    // 第一部分
    staffBaseData();
    // 第二部分  1今日网销各组订单量
    todayWxGroupOrder();
    // 第二部分  2本月网销各组订单量
    monthWxGroupOrder();
    // 第二部分  3本月网销各组线索转化率
    monthWxGroupCusValid();
    // 第二部分  4本月网销各组订单实收
    monthWxOrderFact();
    // 第三部分  1网销月订单量排行榜
    monthWxStaffOrder();
    // 第三部分  2网销月线索订单率
    monthWxStaffValidRate();
    /* ---------------------------------------------  页面开始的时候加载的数据 end  --------------------------------------------- */
    setInterval(function(){
        // 第一部分
        staffBaseData();
        // 第二部分  1今日网销各组订单量
        todayWxGroupOrder();
        // 第二部分  2本月网销各组订单量
        monthWxGroupOrder();
        // 第二部分  3本月网销各组线索转化率
        monthWxGroupCusValid();
        // 第二部分  4本月网销各组订单实收
        monthWxOrderFact();
        // 第三部分  1网销月订单量排行榜
        monthWxStaffOrder();
        // 第三部分  2网销月线索订单率
        monthWxStaffValidRate();
    },60000);
    /* ---------------------------------------------  具体方法 starr --------------------------------------------- */
    // 第一部分
    function staffBaseData () {
        $.ajax({
            type: 'POST',
            url : '/crm/Lmfq/staffBaseData',
            success: function(res){
                if (res) {
                    // console.log(res);
                    $("#tmkz").html(res.tmkz+'个');
                    $("#mmkz").html(res.mmkz+'个');
                    $("#dzz").html(res.dzz+'个');
                    $("#onlinestaff").html(res.onlinestaff+'人');

                    $('#maxStaff').html(res.maxOrderStaff.sales_staff);
                    $('#maxOrder').html(res.maxOrderStaff.orderNum);
                    var src = '/upload/pic/'+res.maxOrderStaff.sales_staff_id+'.jpg';
                    $('#maxStaff_id').attr('src',src);
                };
            },
        })
    }
    // 第二部分  1今日网销各组订单量
    function todayWxGroupOrder () {
        var topChar1 = echarts.init(document.getElementById('topChar1'));
        topChar1.clear();

        topChar1.setOption({
            grid: {
                left: '3%',
                right: '3%',
                top: '8%',
                bottom: '5%',
                containLabel: true
            },
            color: ['#65fbe3'],
            tooltip: {
                formatter:'{b}\n{c}'
            },
            xAxis: {
                // data: ["网销1组","网销2组","网销3组","网销4组","网销5组"],
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                },
                axisLabel: {  
                    interval: 0, 
                    formatter:function(value) {  
                        var ret = "";//拼接加\n返回的类目项  
                        var maxLength = 4;//每项显示文字个数  
                        var valLength = value.length;//X轴类目项的文字个数  
                        var rowN = Math.ceil(valLength / maxLength); //类目项需要换行的行数  
                        if (rowN > 1){//如果类目项的文字大于3,  
                            for (var i = 0; i < rowN; i++) {
                                var temp = "";//每次截取的字符串  
                                var start= i * maxLength;//开始截取的位置  
                                var end  = start + maxLength;//结束截取的位置  
                                //这里也可以加一个是否是最后一行的判断，但是不加也没有影响，那就不加吧  
                                temp = value.substring(start, end) + "\n";
                                ret += temp; //凭借最终的字符串  
                            }
                            return ret;
                        } else {
                            return value;
                        }
                    }
                } 
            },
            yAxis: {
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                },
                min:0,
            },
            series: [{
                name: '',
                type: 'bar',
                barWidth : 50,
                // data: [46, 26, 33, 39, 32],
                data:[],
                itemStyle: {
                    normal: {
                        label: {
                            show: true,
                            position: 'top',
                        }
                    }
                },
            }]
        })
        var arr=[];
        $.ajax({
            type: 'POST',
            data: {},
            url : '/crm/Lmfq/todayWxGroupOrder',
            success: function(res){
                topChar1.setOption({
                    xAxis:[{
                        data:res.names
                    }],
                    series: [{
                        data:res.datas
                    }]
                });
            }
        })
    }
    // 第二部分  2本月网销各组订单量
    function monthWxGroupOrder () {
        var topChar2 = echarts.init(document.getElementById('topChar2'));
        topChar2.clear();

        topChar2.setOption({
            grid: {
                left: '3%',
                right: '3%',
                top: '8%',
                bottom: '5%',
                containLabel: true
            },
            color: ['#65fbe3'],
            tooltip: {
                formatter:'{b}\n{c}'
            },
            xAxis: {
                // data: ["网销1组","网销2组","网销3组","网销4组","网销5组"],
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                },
                axisLabel: {  
                    interval: 0, 
                    formatter:function(value) {  
                        var ret = "";//拼接加\n返回的类目项  
                        var maxLength = 4;//每项显示文字个数  
                        var valLength = value.length;//X轴类目项的文字个数  
                        var rowN = Math.ceil(valLength / maxLength); //类目项需要换行的行数  
                        if (rowN > 1){//如果类目项的文字大于3,  
                            for (var i = 0; i < rowN; i++) {
                                var temp = "";//每次截取的字符串  
                                var start= i * maxLength;//开始截取的位置  
                                var end  = start + maxLength;//结束截取的位置  
                                //这里也可以加一个是否是最后一行的判断，但是不加也没有影响，那就不加吧  
                                temp = value.substring(start, end) + "\n";
                                ret += temp; //凭借最终的字符串  
                            }
                            return ret;
                        } else {
                            return value;
                        }
                    }
                } 
            },
            yAxis: {
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1,
                    }
                },

            },
            series: [{
                name: '',
                type: 'bar',
                barWidth : 50,
                // data: [46, 26, 33, 39, 32],
                data:[],
                itemStyle: {
                    normal: {
                        label: {
                            show: true,
                            position: 'top',
                        }
                    }
                },
            }]
        })
        var arr=[];
        $.ajax({
            type: 'POST',
            data: {},
            url : '/crm/Lmfq/monthWxGroupOrder',
            success: function(res){
                topChar2.setOption({
                    xAxis:[{
                        data:res.names
                    }],
                    series: [{
                        data:res.datas
                    }]
                });
            }
        })
    }
    // 第二部分  3本月网销各组线索转化率
    function monthWxGroupCusValid () {
        $.ajax({
            type: 'POST',
            data: {},
            url : '/crm/Lmfq/monthWxGroupCusValidRate',
            success: function(res){
                var str = '';
                for (var i = 0; i < res.length; i++) {
                    str += '<tr><td>'+(i+1)+'</td><td>'+res[i]['group_name']+'</td><td>'+res[i]['cusRate']+'%</td></tr>';
                };
                $('#monthWxGroupCusValid').html(str);
            }
        });
    }
    // 第二部分  4本月网销各组订单实收
    function monthWxOrderFact () {
        $.ajax({
            type: 'POST',
            data: {},
            url : '/crm/Lmfq/monthWxOrderFact',
            success: function(res){
                var str = '';
                for (var i = 0; i < res.length; i++) {
                    str += '<tr><td>'+(i+1)+'</td><td>'+res[i]['group_name']+'</td><td>'+res[i]['totalRate']+'</td></tr>';
                };
                $('#monthWxOrderFact').html(str);
            }
        })
    }
    // 第三部分  1网销月订单量排行榜
    function monthWxStaffOrder () {
        var chart1 = echarts.init(document.getElementById('chart1'));
        chart1.clear();

        chart1.setOption({
            grid: {
                x:55,
                y:0,
                x2:15,
                y2:30,
                borderWidth:1
            },
            color: ['#66e0ff'],
            tooltip: {
                formatter:'{b}\n{c}'
            },
            xAxis: {
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
				,splitLine:{
				   show:false
				}
            },
            yAxis: {
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                },
                axisLabel: {  
                    interval: 0, 
                    // rotate: 20, 
                    formatter:function(value)  {  
                        var ret = "";//拼接加\n返回的类目项  
                        var maxLength = 4;//每项显示文字个数  
                        var valLength = value.length;//X轴类目项的文字个数  
                        var rowN = Math.ceil(valLength / maxLength); //类目项需要换行的行数  
                        if (rowN > 1){  //如果类目项的文字大于3,  
                            for (var i = 0; i < rowN; i++) {  
                                var temp = "";//每次截取的字符串  
                                var start = i * maxLength;//开始截取的位置  
                                var end = start + maxLength;//结束截取的位置  
                                //这里也可以加一个是否是最后一行的判断，但是不加也没有影响，那就不加吧  
                                temp = value.substring(start, end) + "\n";  
                                ret += temp; //凭借最终的字符串  
                            }  
                            return ret;
                        }else {
                            return value;
                        }
                    }
                }
            },
            series: [{
                name: '',
                type: 'bar',
                data: [],
                itemStyle: {
                    normal: {
                        label: {
                            show: true,
                            position: 'right',
                        }
                    }
                },
            }],
        })
        var arr=[];
        $.ajax({
            type: 'POST',
            data: {},
            url : '/crm/Lmfq/monthWxStaffOrder',
            success: function(res){
                chart1.setOption({
                    yAxis:[{
                        data:res.names
                    }],
                    series: [{
                        data:res.datas
                    }]
                });
            }
        })
    }
    // 第三部分  2网销月线索订单率
    function monthWxStaffValidRate () {
        var chart2 = echarts.init(document.getElementById('chart2'));
        chart2.clear();

        chart2.setOption({
            grid: {
                x:45,
                y:0,
                x2:30,
                y2:30,
                borderWidth:1
            },
            color: ['#66e0ff'],
            tooltip: {
                formatter:'{b}\n{c}%'
            },
            xAxis: {
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                }
				,splitLine:{
				   show:false
				}				
            },
            yAxis: {
                data: [],
                axisLine:{
                    lineStyle:{
                        color:'#fff',
                        width:1
                    }
                },
                axisLabel: {  
                    interval: 0, 
                    // rotate: 20, 
                    formatter:function(value)  {  
                        var ret = "";//拼接加\n返回的类目项  
                        var maxLength = 4;//每项显示文字个数  
                        var valLength = value.length;//X轴类目项的文字个数  
                        var rowN = Math.ceil(valLength / maxLength); //类目项需要换行的行数  
                        if (rowN > 1){  //如果类目项的文字大于3,  
                            for (var i = 0; i < rowN; i++) {  
                                var temp = "";//每次截取的字符串  
                                var start = i * maxLength;//开始截取的位置  
                                var end = start + maxLength;//结束截取的位置  
                                //这里也可以加一个是否是最后一行的判断，但是不加也没有影响，那就不加吧  
                                temp = value.substring(start, end) + "\n";  
                                ret += temp; //凭借最终的字符串  
                            }  
                            return ret;
                        }else {
                            return value;
                        }
                    }
                }
            },
            series: [{
                name: '',
                type: 'bar',
                data: [],
                itemStyle: {
                    normal: {
                        label: {
                            show: true,
                            position: 'right',
                        }
                    }
                },
            }],
        })
        var arr=[];
        $.ajax({
            type: 'POST',
            data: {},
            url : '/crm/Lmfq/monthWxStaffValidRate',
            success: function(res){
                chart2.setOption({
                    yAxis:[{
                        data:res.names
                    }],
                    series: [{
                        data:res.datas
                    }]
                });
            }
        })
    }
    /* ---------------------------------------------  具体方法 end --------------------------------------------- */
    
});