<?php

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
namespace app\crm\lib;
use think\Exception;

class ListenCron {

    // 每天凌晨 沉淀数据
    public function runcronhour(){
        // 每天凌晨1点之后开始
        if(date('H',time()) > '1' && date('H',time() < '2')){
            $area = 'this_month';
            $time_area = getdateArea($area);
            $allTime = getDateFromRange($time_area[0], $time_area[1]);

            $where = [
                'is_status' => 1,
                'c_from'    => 1,
            ];
            //店面类型(is_marketing)： 1：电商店； 3：网销店； 4：渠道店
            $sta_set = db('s_sta_setting')->order('id asc')->column('all_customer_consumptiontype,valid_customer_consumptiontype,into_customer_consumptiontype,order_customer_consumptiontype,is_marketing,shop_code,brandclass_id', 'shop_code');
            // var_dump($sta_set);
            // exit;
            foreach ($allTime as $key => $value) {
                $start = date('Y-m-d 00:00:00', strtotime($value));
                $end   = date('Y-m-d 23:59:59', strtotime($value));
                if ($value >= date('Y-m-d')) {
                    break;
                }
                foreach ($sta_set as $k => $v) {
                    // 电商店，做毛客资统计，有效客资统计
                    if ($v['is_marketing'] == 1) {
                        $allCustomer = db('c_customerinfo');
                        // 毛客资
                        // 毛客资消费类型设定，0：全部，即不限定消费类型； 其他，用‘,’分隔
                        if ($v['all_customer_consumptiontype']) {
                            $allCustomer->where('consultation_type_id', 'in', $v['all_customer_consumptiontype']);
                        }
                        $customerNum = $allCustomer->where($where)
                            ->where('customer_type', 1)
                            ->where('dj_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('add_shop_code', $v['shop_code'])
                            ->count();

                        // 有效客资量
                        $validCustomer = db('c_customerinfo');
                        if ($v['valid_customer_consumptiontype']) {
                            $allCustomer->where('consultation_type_id', 'in', $v['valid_customer_consumptiontype']);
                        }                    
                        $validNum = $validCustomer->where($where)
                            ->where('customer_type', 1)
                            ->where('is_valid', 1)
                            ->where('yx_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('add_shop_code', $v['shop_code'])
                            ->count();
                        $dp_where = [
                            'brandclass_id' => $v['brandclass_id'],
                            'shop_code'     => $v['shop_code'],
                            'date'          => $value,
                        ];
                        $res = db('s_data_dp')
                            ->where($dp_where)
                            ->count();

                        // 如果存在就update， 没有就insert
                        if ($res) {
                            $upData['customer'] = $customerNum;
                            $upData['valid']    = $validNum;
                            db('s_data_dp')->where($dp_where)->update($upData);
                        }else{
                            $inData = [
                                'date'          => $value,
                                'customer'      => $customerNum,
                                'valid'         => $validNum,
                                'shop_code'     => $v['shop_code'],
                                'brandclass_id' => $v['brandclass_id']
                            ];
                            db('s_data_dp')->insert($inData);
                        }
                    }
                    // 网销店，做 接收客资量， 进店统计， 订单统计
                    else if ($v['is_marketing'] == 3) {
                        // 接收客资量
                        $receiveNum = db('c_customerinfo')->where($where)
                            ->where('customer_type', 1)
                            ->where('dj_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->count();

                        // 进店
                        $intoCustomer = db('c_customerinfo');
                        if ($v['into_customer_consumptiontype']) {
                            $intoCustomer->where('consultation_type_id', 'in', $v['into_customer_consumptiontype']);
                        }
                        $intoNum = $intoCustomer->where($where)
                            ->where('customer_type', 1)
                            ->where('syjd_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->count();

                        // 订单
                        $orderCustomer = db('c_customerinfo');
                        if ($v['order_customer_consumptiontype']) {
                            $orderCustomer->where('consultation_type_id', 'in', $v['order_customer_consumptiontype']);
                        }
                        $orderNum = $intoCustomer->where($where)
                            ->where('customer_type', 1)
                            ->where('order_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->count();
                        // 营收
                        $moneyNum = db('c_customerinfo')->where($where)
                            ->where('order_start_time', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->sum('fact_money');
                        $dp_where = [
                            'brandclass_id' => $v['brandclass_id'],
                            'shop_code'     => $v['shop_code'],
                            'date'          => $value,
                        ];
                        $res = db('s_data_dp')
                            ->where($dp_where)
                            ->count();

                        // 如果存在就update， 没有就insert
                        if ($res) {
                            $upData['receive'] = $receiveNum;
                            $upData['into']    = $intoNum;
                            $upData['order']   = $orderNum;
                            $upData['money']   = $moneyNum;
                            db('s_data_dp')->where($dp_where)->update($upData);
                        }else{
                            $inData = [
                                'date'          => $value,
                                'receive'       => $receiveNum,
                                'into'          => $intoNum,
                                'order'         => $orderNum,
                                'money'         => $moneyNum,
                                'shop_code'     => $v['shop_code'],
                                'brandclass_id' => $v['brandclass_id']
                            ];
                            db('s_data_dp')->insert($inData);
                        }
                    }
                    // 深挖店，做 接收客资量， 进店统计， 订单统计
                    else if ($v['is_marketing'] == 4) {
                        // 接收客资量
                        $receiveNum = db('c_customerinfo')->where($where)
                            ->where('dj_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->count();
                        // 进店
                        $intoCustomer = db('c_customerinfo');
                        if ($v['into_customer_consumptiontype']) {
                            $intoCustomer->where('consultation_type_id', 'in', $v['into_customer_consumptiontype']);
                        }
                        $intoNum = $intoCustomer->where($where)
                            ->where('syjd_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->count();

                        // 订单
                        $orderCustomer = db('c_customerinfo');
                        if ($v['order_customer_consumptiontype']) {
                            $orderCustomer->where('consultation_type_id', 'in', $v['order_customer_consumptiontype']);
                        }
                        $orderNum = $intoCustomer->where($where)
                            ->where('order_day', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->count();
                        // 营收
                        $moneyNum = db('c_customerinfo')->where($where)
                            ->where('order_start_time', 'between time', [$start, $end])
                            ->where('brandclass_id', $v['brandclass_id'])
                            ->where('shop_code', $v['shop_code'])
                            ->sum('fact_money');
                        $dp_where = [
                            'brandclass_id' => $v['brandclass_id'],
                            'shop_code'     => $v['shop_code'],
                            'date'          => $value,
                        ];
                        $res = db('s_data_dp')
                            ->where($dp_where)
                            ->count();

                        // 如果存在就update， 没有就insert
                        if ($res) {
                            $upData['receive'] = $receiveNum;
                            $upData['into']    = $intoNum;
                            $upData['order']   = $orderNum;
                            $upData['money']   = $moneyNum;
                            db('s_data_dp')->where($dp_where)->update($upData);
                        }else{
                            $inData = [
                                'date'          => $value,
                                'receive'       => $receiveNum,
                                'into'          => $intoNum,
                                'order'         => $orderNum,
                                'money'         => $moneyNum,
                                'shop_code'     => $v['shop_code'],
                                'brandclass_id' => $v['brandclass_id']
                            ];
                            db('s_data_dp')->insert($inData);
                        }
                    }
                }
            }
        }
    }

    function log($str){
        if(config('app_debug')){
            echo date('Y-m-d H:i:s').$str."\r\n";
        }
    }
}