<?php
/**
 * 报表实现类 网销部集团报表(电商向网销汇报)
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-11 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Ds_to_wx_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1528703915';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        $param = input();
        $time = $param['day'] ? $param['day'] : date('Y-m-d');
        $start = date('Y-m-d',strtotime($time));
        $end = date('Y-m-d 23:59:59',strtotime($time));

        $startM = date('Y-m-01 00:00:00',strtotime($time));
        // $endM = date('Y-m-31 23:59:59',strtotime($time));
        $endM = date('Y-m-d 23:59:59',strtotime($time));
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$param['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $shopCode = $det['shop_code'];
        if(empty($shopCode)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
//        $shopCode = session('shop_code');
        $where['shop_code'] = $shopCode;
        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['customer_type'] = 1;
        $where['consultation_type_id'] = HS_TYPE;

        $returnData = [];

        $returnData[0][0] = '网销业绩汇报';
        $returnData[0][1] = $start;
        $returnData[0][2] = '说明';

        //进店量
        $param['kpi_id'] = 'actualIntoCustomerNumber';
        $jd = getShopGoal($param);
        $returnData[1][0] = '进店';
        $jdDay = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore', 'in', '2,3')
                ->where('syjd_day', 'between time', [$start, $end])
                ->count();
        $jdMonth = db('c_customerinfo')
                ->where($where)
                ->where('is_intostore', 'in', '2,3')
                ->where('syjd_day', 'between time', [$startM, $endM])
                ->count();
        $returnData[1][1] = $jdDay.'／'.$jdMonth;

        $returnData[1][2] = '当日进店／当月进店';


        //新单量
        $returnData[2][0] = '新单';
        $orderDay= db('c_customerinfo')
                    ->where($where)
                    ->where('order_day', 'between time', [$start, $end])
                    ->count();;
        $orderMonth= db('c_customerinfo')
                    ->where($where)
                    ->where('order_day', 'between time', [$startM, $endM])
                    ->count();
        $returnData[2][1] = $orderDay.'／'.$orderMonth;
        $returnData[2][2] = '当日新单／当月新单';

        //成交率 新单/进店
        $returnData[3][0] = '成交率(新单／进店)';
        $returnData[3][1] = sprintf('%.2f',$orderDay/$jdDay*100).'%／'.sprintf('%.2f',$orderMonth/$jdMonth*100).'%';
        $returnData[3][2] = '当日成交率／当月成交率';

        //进店成本
        $shops = controller('crm/Customer','lib')->get_shop(['is_marketing'=>1,'belong_shop_code'=>$shopCode]);
        $shopCodes = array_column($shops,'shop_code');
        $cost = db('s_channel_cost')
            ->where('shop_code', 'in', $shopCodes)
            ->where('cost_date', 'between time', [$startM, $endM])
            ->sum('cost');
        $returnData[3][0] = '进店成本';
        $returnData[3][1] = sprintf('%.2f',$cost/$jdMonth);
        $returnData[3][2] = '当月电商花费／当月进店';

        $returnData[4][0] = '新单成本';
        $returnData[4][1] = sprintf('%.2f',$cost/$orderMonth);
        $returnData[4][2] = '当月电商花费／当月新单';

        $returnData[5][0] = '进店目标';
        $jdGoal = db('SKpiStaffgoal')->where(array('shop_code' => $shopCode,'year'=>intval(date('Y',strtotime($start))), 'month' => intval(date('m',strtotime($start)))))->where('kpi_id', 'actualIntoCustomerNumber')->where('department_id>0 and flag="staff" and staff_id=0 and position_code=""')->sum('kpi_value');
        $returnData[5][1] = $jdGoal.'／'.sprintf('%.2f',$jdMonth/$jdGoal*100).'%';
        $returnData[5][2] = '本月进店目标／完成比';

        $returnData[6][0] = '新单目标';
        $orderGoal = db('SKpiStaffgoal')->where(array('shop_code' => $shopCode,'year'=>intval(date('Y',strtotime($start))), 'month' => intval(date('m',strtotime($start)))))->where('kpi_id', 'orderNumber')->where('department_id>0 and flag="staff" and staff_id=0 and position_code=""')->sum('kpi_value');
        $returnData[6][1] = $orderGoal.'／'.sprintf('%.2f',$orderMonth/$orderGoal*100).'%';;
        $returnData[6][2] = '本月进店目标／完成比';
        $return['code'] = 200;
        $return['msg'] = '';
        $return['count'] = 3;
        $return['data'] = $returnData;
        // 导出
        if ($param['need'] == 1) {
            $title = $returnData[0];
            unset($returnData[0]);
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shopCode]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            if ($return['data']) {
                return json($return);
            } else {
                $return = ['code' => 100, 'msg' => '暂无数据', 'count' => 0, 'data' => '',];
                return json($return);
            }
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');

        $shopInfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shopInfo[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}