<?php
/**
 * 报表实现类 女王高定婚纱----渠道数据统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: yuanweibo 2021-11-19 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
class Nwgd_channel_data extends Report{
    private $level=1;
    private $type=1;
    private $code='code1536997100';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $data = input();
        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }

        // 来源渠道
        $channel = controller('crm/Customer', 'lib')->getChannel($shop_code);
        $chl = $chl_er = $chl_er_id = [];
        foreach ($channel as $key => $value) {
            $chl[$value['id']] = $value['channel_name'];
            $chl_er[$value['channel_name']] = $value['channel_info_name'];
            $chl_er_id[$value['channel_name']] = $value['channel_info_id'];
        }

        if($data['channel_id']){
            $channels = explode(',',$data['channel_id']);
            foreach ($channels as $key => $value) {
                $channels[$key] = $chl[$value];
            }
        }else{
            $channels = array_column($channel,'channel_name');
        }

        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['add_shop_code'] = $shop_code;
        $whereCost['shop_code'] = $shop_code;
        // if((int)$data['consultation_type_id']){
        //     $whereT['consultation_type_id'] = (int)$data['consultation_type_id'];
        // }

        $sql = '';
        $sql .= 'sum(dj_day between "'.$start.'" and "'.$end.'") as mkz,';
        // if((int)$data['consultation_type_id']){
        //     $sql .= 'sum(consultation_type_id = '.(int)$data['consultation_type_id'].' and dj_day between "'.$start.'" and "'.$end.'" and is_valid in (\'1\',\'5\',\'4\',\'2\')) as valid,';
        //     $sql .= 'sum(consultation_type_id = '.(int)$data['consultation_type_id'].' and yjd_day between "'.$start.'" and "'.$end.'") as yy,';
        //     $sql .= 'sum(consultation_type_id = '.(int)$data['consultation_type_id'].' and syjd_day between "'.$start.'" and "'.$end.'" and is_intostore in (\'2\',\'3\',\'5\')) as jd,';
        //     $sql .= 'sum(consultation_type_id = '.(int)$data['consultation_type_id'].' and order_day between "'.$start.'" and "'.$end.'" and is_success=1) as `order`,';
        //     $sql .= 'sum(consultation_type_id = '.(int)$data['consultation_type_id'].' and dj_day between "'.$start.'" and "'.$end.'" and is_valid=2) as dd,';
        //     $sql .= 'sum(consultation_type_id = '.(int)$data['consultation_type_id'].' and dj_day between "'.$start.'" and "'.$end.'" and is_valid=3) as unValid';
        // }else{
            $sql .= 'sum(dj_day between "'.$start.'" and "'.$end.'" and is_valid in (\'1\',\'5\',\'4\',\'2\')) as valid,';
            $sql .= 'sum(yjd_day between "'.$start.'" and "'.$end.'") as yy,';
            $sql .= 'sum(syjd_day between "'.$start.'" and "'.$end.'" and is_intostore in (\'2\',\'3\',\'5\')) as jd,';
            $sql .= 'sum(syjd_day between "'.$start.'" and "'.$end.'" and is_intostore in (\'4\',\'5\')) as runOff,';
            $sql .= 'sum(order_day between "'.$start.'" and "'.$end.'" and is_success=1) as `order`, ';
            $sql .= 'sum(yjd_day between "'.$start.'" and "'.$end.'" and is_success in(\'1\',\'3\')) as yyjd,';
            $sql .= 'sum(syjd_day between "'.$start.'" and "'.$end.'" and is_success in(\'1\',\'3\') and is_intostore in (\'2\',\'3\',\'5\')) as djdd,';
            $sql .= 'sum(syjd_day between "'.$start.'" and "'.$end.'" and is_success = 2) as jdUncertain,';
            $sql .= 'sum(dj_day between "'.$start.'" and "'.$end.'" and is_valid=2) as dd,';
            $sql .= 'sum(dj_day between "'.$start.'" and "'.$end.'" and is_valid=3) as unValid,';
            $sql .= 'sum(dj_day between "'.$start.'" and "'.$end.'" and is_valid=4) as bhValid,';
            $sql .= 'sum(order_start_time between "'.$start.'" and "'.$end.'" and is_success=3) as dj,';
            $sql .= 'sum(order_start_time between "'.$start.'" and "'.$end.'" and is_success in(\'1\',\'3\') and is_intostore in(\'2\',\'3\',\'5\')) as mddj,';
            $sql .= 'sum(yjd_day between "'.$start.'" and "'.$end.'" and is_valid = 4) as mkzBh,';
            $sql .= 'sum(dj_day between "'.$start.'" and "'.$end.'" and customer_intention=\'空\') as notHave'; //空 意向 的 客资
        // }
        
        if((int)$data['source']){
            $sql .=  'customer_cource_id ='.(int)$data['source'];
        }

        $info = db('c_customerinfo')
            ->where($where)
            ->where('customer_channel','in',$channels)
            ->group('customer_channel')
            ->column($sql, 'customer_channel');
        //花费
        $cost = db('s_channel_cost')
            ->where('cost_date', 'between time', [$start, $end])
            ->where($whereCost)
            ->where('channel_name','in',$channels)
            ->group('channel_name')
            ->column('sum(cost) as cost','channel_name');
        //实收
        $factMoney = db('c_customerinfo')->alias('c')->join('s_channel s', 's.id=c.customer_channel_id')
            ->where($where)
            ->where('c.customer_channel','in',$channels)
            ->where('order_day', 'between time', [$start, $end])
            ->group('c.customer_channel')
            ->column('sum(c.fact_money) as fact,s.channel_name,s.channel_class_name,s.channel_info_name,s.id', 'c.customer_channel');
        $return['sql_factMoney'] = db()->getlastsql();

        //营收
        $totalMoney = db('c_customerinfo')
            ->alias('c')
            ->join('s_channel s', 's.id=c.customer_channel_id')
            ->join('c_customer_order o','o.order_sn = c.order_number and o.customer_id = c.id','left')
            ->where($where)
            ->where('c.customer_channel','in',$channels)
            ->where('c.order_day', 'between time', [$start, $end])
            ->group('c.customer_channel')
            ->column('sum(o.order_amount) as total,sum(earnest_money) as earnest_money,s.channel_name,s.channel_class_name,s.channel_info_name,s.id','c.customer_channel');
        $return['sql_totalMoney'] = db()->getlastsql();

        //套系
        $tx = db('c_customerinfo')->alias('c')->join('s_channel s', 's.id=c.customer_channel_id')
            ->where($where)
            ->where('c.customer_channel','in',$channels)
            ->where('order_start_time', 'between time', [$start, $end])
            ->group('c.customer_channel')
            ->column('sum(c.totalpay_money) as totalpay,s.channel_name,s.channel_class_name,s.channel_info_name,s.id', 'c.customer_channel');
        $return['sql_tx'] = db()->getlastsql();


        //保留订单
        $baoliu = db('c_customerinfo')
            ->alias('c')
            ->join('s_channel s', 's.id=c.customer_channel_id')
            ->join('c_customer_order o','o.order_sn = c.order_number and o.customer_id = c.id','left')
            ->where($where)
            ->where('c.customer_channel','in',$channels)
            ->where('c.order_day', 'between time', [$start, $end])
            ->where('o.order_amount','<',1000)
            ->group('c.customer_channel')
            ->column('sum(o.order_amount) as totalBL,count(o.id) as bljd,s.channel_name,s.channel_class_name,s.channel_info_name,s.id','c.customer_channel');
        $return['sql_baoliu'] = db()->getlastsql();

        $returnData = [];
        $arr = [];
        foreach($channels as $k=>$v){
            $returnData[$k]['channel_info_name'] = $chl_er[$v];
            $returnData[$k]['channel_name'] = $chl_er[$v]."->".$v;
            $returnData[$k]['channel_info_id'] = $chl_er_id[$v]."0";
            $returnData[$k]['mkz'] = $info[$v]['mkz'];
            $returnData[$k]['valid'] = $info[$v]['valid'];
            $returnData[$k]['unValid'] = $info[$v]['unValid'];
            $returnData[$k]['bhValid'] = $info[$v]['bhValid'];
            $returnData[$k]['notHave'] = $info[$v]['notHave'];
            $returnData[$k]['runOff'] = $info[$v]['runOff'];
            $returnData[$k]['dj'] = $info[$v]['dj'];
            $returnData[$k]['dd'] = $info[$v]['dd'];
            $returnData[$k]['yy'] = $info[$v]['yy'];
            $returnData[$k]['jd'] = $info[$v]['jd'];
            $returnData[$k]['yyjd'] = $info[$v]['yyjd'];
            $returnData[$k]['djdd'] = $info[$v]['djdd'];
            $returnData[$k]['mkzBh'] = $info[$v]['mkzBh'];
            $returnData[$k]['jdUncertain'] = $info[$v]['jdUncertain'];
            $returnData[$k]['order'] = $info[$v]['order'];
            $returnData[$k]['mddj'] = $info[$v]['mddj'];
            $returnData[$k]['validRate'] = $info[$v]['valid'] ? sprintf('%.2f',$info[$v]['valid']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['unValidRate'] = $info[$v]['unValid'] ? sprintf('%.2f',$info[$v]['unValid']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['ddRate'] = $info[$v]['dd'] ? sprintf('%.2f',$info[$v]['dd']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['mkzJdRate'] = $info[$v]['jd'] ? sprintf('%.2f',$info[$v]['jd']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['validJdRate'] = $info[$v]['jd'] ? sprintf('%.2f',$info[$v]['jd']/$info[$v]['valid']*100).'%' : '0%';
            $returnData[$k]['jdOrderRate'] = $info[$v]['order'] ? sprintf('%.2f',$info[$v]['order']/$info[$v]['jd']*100).'%' : '0%';
            $returnData[$k]['mkzOrderRate'] = $info[$v]['order'] ? sprintf('%.2f',$info[$v]['order']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['validOrderRate'] = $info[$v]['order'] ? sprintf('%.2f',$info[$v]['order']/$info[$v]['valid']*100).'%' : '0%';
            $returnData[$k]['cost'] = sprintf('%.2f',$cost[$v]);
            $returnData[$k]['mkzCost'] = $cost[$v] ? sprintf('%.2f',$cost[$v]/$info[$v]['mkz']) : '';
            $returnData[$k]['validCost'] = $cost[$v] ? sprintf('%.2f',$cost[$v]/$info[$v]['valid']) : '';
            $returnData[$k]['DingdanCost'] = $cost[$v] ? sprintf('%.2f',$cost[$v]/$info[$v]['dj']) : '';
            $returnData[$k]['Dingdanlv'] = $info[$v]['valid'] ? sprintf('%.2f',$info[$v]['dj']/$info[$v]['valid']*100).'%' : '0%';
            $returnData[$k]['mkzDdl'] = $info[$v]['mkz'] ? sprintf('%.2f',$info[$v]['dj']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['runOfflv'] = $info[$v]['mkz'] ? sprintf('%.2f',$info[$v]['runOff']/$info[$v]['mkz']*100).'%' : '0%';


            $returnData[$k]['jdCost'] = $cost[$v] ? sprintf('%.2f',$cost[$v]/$info[$v]['jd']) : '';
            $returnData[$k]['orderCost'] = $cost[$v] ? sprintf('%.2f',$cost[$v]/$info[$v]['order']) : '';
            $returnData[$k]['orderAVG'] =  $info[$v]['order'] ? sprintf('%.2f',$totalMoney[$v]['total']/$info[$v]['order']) : '';
            $returnData[$k]['totalMoney'] =  sprintf('%.2f',$totalMoney[$v]['total']);
            $returnData[$k]['earnestMoney'] =  sprintf('%.2f',$totalMoney[$v]['earnest_money']);
            $returnData[$k]['factMoney'] =  sprintf('%.2f',$factMoney[$v]['fact']);
            $returnData[$k]['totalpayMoney'] =  sprintf('%.2f',$tx[$v]['totalpay']);
            $returnData[$k]['txjj'] =  $info[$v]['dj'] ? sprintf('%.2f',$tx[$v]['totalpay']/$info[$v]['dj']) : '';
            $returnData[$k]['ROI'] = $returnData[$k]['totalMoney'] ? sprintf('%.2f',$returnData[$k]['totalMoney']/$returnData[$k]['cost']) : '';

            $returnData[$k]['bljd'] = $info[$v]['bljd'];
            $returnData[$k]['totalBLMoney'] =  sprintf('%.2f',$totalMoney[$v]['totalBL']);
            $returnData[$k]['mkzBljLv'] = $info[$v]['mkz'] ? sprintf('%.2f',$info[$v]['bljd']/$info[$v]['mkz']*100).'%' : '0%';

            $returnData[$k]['jdl'] = $info[$v]['jd'] ? sprintf('%.2f',$info[$v]['yy']/$info[$v]['jd']*100).'%' : '0%';
            $returnData[$k]['mkjdl'] = $info[$v]['mkz'] ? sprintf('%.2f',$info[$v]['jd']/$info[$v]['mkz']*100).'%' : '0%';
            $returnData[$k]['jdddl'] = $info[$v]['jd'] ? sprintf('%.2f',$info[$v]['mddj']/$info[$v]['jd']*100).'%' : '0%';

            //二级渠道 总计 $chl_er[$v]
            $arr_er[$chl_er[$v]]['channel_name'] = '总计-'.$chl_er[$v];
            $arr_er[$chl_er[$v]]['channel_info_id'] = $chl_er_id[$v]."1";
            $arr_er[$chl_er[$v]]['mkz'] += $returnData[$k]['mkz'];
            $arr_er[$chl_er[$v]]['valid'] += $returnData[$k]['valid'];
            $arr_er[$chl_er[$v]]['unValid'] += $returnData[$k]['unValid'];
            $arr_er[$chl_er[$v]]['bhValid'] += $returnData[$k]['bhValid'];
            $arr_er[$chl_er[$v]]['notHave'] += $returnData[$k]['notHave'];
            $arr_er[$chl_er[$v]]['runOff'] += $returnData[$k]['runOff'];
            $arr_er[$chl_er[$v]]['dd'] += $returnData[$k]['dd'];
            $arr_er[$chl_er[$v]]['dj'] += $returnData[$k]['dj'];
            $arr_er[$chl_er[$v]]['yy'] += $returnData[$k]['yy'];
            $arr_er[$chl_er[$v]]['jd'] += $returnData[$k]['jd'];
            $arr_er[$chl_er[$v]]['yyjd'] += $returnData[$k]['yyjd'];
            $arr_er[$chl_er[$v]]['djdd'] += $returnData[$k]['djdd'];
            $arr_er[$chl_er[$v]]['mkzBh'] += $returnData[$k]['mkzBh'];
            $arr_er[$chl_er[$v]]['jdUncertain'] += $returnData[$k]['jdUncertain'];
            $arr_er[$chl_er[$v]]['order'] += $returnData[$k]['order'];
            $arr_er[$chl_er[$v]]['mddj'] += $returnData[$k]['mddj'];
            $arr_er[$chl_er[$v]]['validRate'] = '';
            $arr_er[$chl_er[$v]]['unValidRate'] = '';
            $arr_er[$chl_er[$v]]['ddRate'] = '';
            $arr_er[$chl_er[$v]]['mkzJdRate'] = '';
            $arr_er[$chl_er[$v]]['validJdRate'] = '';
            $arr_er[$chl_er[$v]]['jdOrderRate'] = '';
            $arr_er[$chl_er[$v]]['mkzOrderRate'] = '';
            $arr_er[$chl_er[$v]]['validOrderRate'] = '';
            $arr_er[$chl_er[$v]]['cost'] += $returnData[$k]['cost'];
            $arr_er[$chl_er[$v]]['mkzCost'] = '';
            $arr_er[$chl_er[$v]]['validCost'] = '';
            $arr_er[$chl_er[$v]]['DingdanCost'] = '';
            $arr_er[$chl_er[$v]]['Dingdanlv'] = '';
            $arr_er[$chl_er[$v]]['mkzDdl'] = '';
            $arr_er[$chl_er[$v]]['runOfflv'] = '';
            $arr_er[$chl_er[$v]]['jdCost'] = '';
            $arr_er[$chl_er[$v]]['orderCost'] = '';
            $arr_er[$chl_er[$v]]['orderAVG'] = '';
            $arr_er[$chl_er[$v]]['txjj'] = '';
            $arr_er[$chl_er[$v]]['totalMoney'] += floatval($returnData[$k]['totalMoney']);
            $arr_er[$chl_er[$v]]['earnestMoney'] += floatval($returnData[$k]['earnestMoney']);
            $arr_er[$chl_er[$v]]['factMoney'] += floatval($returnData[$k]['factMoney']);
            $arr_er[$chl_er[$v]]['totalpayMoney'] += floatval($returnData[$k]['totalpayMoney']);
            $arr_er[$chl_er[$v]]['ROI'] = '';
            $arr_er[$chl_er[$v]]['bljd'] += $returnData[$k]['bljd'];
            $arr_er[$chl_er[$v]]['totalBLMoney'] += floatval($returnData[$k]['totalBLMoney']);
            $arr_er[$chl_er[$v]]['mkzBljLv'] = '';
            $arr_er[$chl_er[$v]]['jdl'] = '';
            $arr_er[$chl_er[$v]]['mkjdl'] = '';
            $arr_er[$chl_er[$v]]['jdjdl'] = '';

            //总计
            $arr['channel_name'] = '总计';
            $arr['mkz'] += $returnData[$k]['mkz'];
            $arr['valid'] += $returnData[$k]['valid'];
            $arr['unValid'] += $returnData[$k]['unValid'];
            $arr['bhValid'] += $returnData[$k]['bhValid'];
            $arr['notHave'] += $returnData[$k]['notHave'];
            $arr['runOff'] += $returnData[$k]['runOff'];
            $arr['dd'] += $returnData[$k]['dd'];
            $arr['dj'] += $returnData[$k]['dj'];
            $arr['yy'] += $returnData[$k]['yy'];
            $arr['jd'] += $returnData[$k]['jd'];
            $arr['yyjd'] += $returnData[$k]['yyjd'];
            $arr['djdd'] += $returnData[$k]['djdd'];
            $arr['mkzBh'] += $returnData[$k]['mkzBh'];
            $arr['jdUncertain'] += $returnData[$k]['jdUncertain'];
            $arr['order'] += $returnData[$k]['order'];
            $arr['mddj'] += $returnData[$k]['mddj'];
            $arr['validRate'] = '';
            $arr['unValidRate'] = '';
            $arr['ddRate'] = '';
            $arr['mkzJdRate'] = '';
            $arr['validJdRate'] = '';
            $arr['jdOrderRate'] = '';
            $arr['mkzOrderRate'] = '';
            $arr['validOrderRate'] = '';
            $arr['cost'] += $returnData[$k]['cost'];
            $arr['mkzCost'] = '';
            $arr['validCost'] = '';
            $arr['DingdanCost'] = '';
            $arr['Dingdanlv'] = '';
            $arr['mkzDdl'] = '';
            $arr['runOfflv'] = '';
            $arr['jdCost'] = '';
            $arr['orderCost'] = '';
            $arr['orderAVG'] = '';
            $arr['txjj'] = '';
            $arr['totalMoney'] += floatval($returnData[$k]['totalMoney']);
            $arr['earnestMoney'] += floatval($returnData[$k]['earnestMoney']);
            $arr['factMoney'] += floatval($returnData[$k]['factMoney']);
            $arr['totalpayMoney'] += floatval($returnData[$k]['totalpayMoney']);
            $arr['ROI'] = '';

            $arr['bljd'] += $returnData[$k]['bljd'];
            $arr['totalBLMoney'] += floatval($returnData[$k]['totalBLMoney']);
            $arr['mkzBljLv'] = '';
            $arr['jdl'] = '';
            $arr['mkjdl'] = '';
            $arr['jdjdl'] = '';
        }

        foreach ($arr_er as $key => $value) {
            $arr_er[$key]['validRate'] = $value['valid'] ? sprintf('%.2f',$value['valid']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['unValidRate'] = $value['valid'] ? sprintf('%.2f',$value['unValid']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['ddRate'] = $value['valid'] ? sprintf('%.2f',$value['unValid']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['mkzJdRate'] = $value['valid'] ? sprintf('%.2f',$value['jd']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['validJdRate'] = $value['valid'] ? sprintf('%.2f',$value['jd']/$value['valid']*100).'%' : '0%';
            $arr_er[$key]['jdOrderRate'] = $value['valid'] ? sprintf('%.2f',$value['order']/$value['jd']*100).'%' : '0%';
            $arr_er[$key]['mkzOrderRate'] = $value['valid'] ? sprintf('%.2f',$value['order']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['validOrderRate'] = $value['valid'] ? sprintf('%.2f',$value['order']/$value['valid']*100).'%' : '0%';
            $arr_er[$key]['mkzCost'] = $value['cost'] ? sprintf('%.2f',$value['cost']/$value['mkz']) : '';
            $arr_er[$key]['validCost'] = $value['cost'] ? sprintf('%.2f',$value['cost']/$value['valid']) : '';
            $arr_er[$key]['DingdanCost'] = $value['cost'] ? sprintf('%.2f',$value['cost']/$value['dj']) : '';
            $arr_er[$key]['Dingdanlv'] = $value['valid'] ? sprintf('%.2f',$value['dj']/$value['valid']*100).'%' : '0%';
            $arr_er[$key]['mkzDdl'] = $value['mkz'] ? sprintf('%.2f',$value['dj']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['runOfflv'] = $value['mkz'] ? sprintf('%.2f',$value['runOff']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['jdCost'] = $value['cost'] ? sprintf('%.2f',$value['cost']/$value['jd']) : '';
            $arr_er[$key]['orderCost'] = $value['cost'] ? sprintf('%.2f',$value['cost']/$value['order']) : '';
            $arr_er[$key]['orderAVG'] = $value['totalMoney'] ? sprintf('%.2f',$value['totalMoney']/$value['order']) : '';
            $arr_er[$key]['txjj'] = $value['dj'] ? sprintf('%.2f',$value['totalpayMoney']/$value['dj']) : '';
            $arr_er[$key]['totalMoney'] = sprintf('%.2f',$value['totalMoney']);
            $arr_er[$key]['earnestMoney'] = sprintf('%.2f',$value['earnestMoney']);
            $arr_er[$key]['factMoney'] = sprintf('%.2f',$value['factMoney']);
            $arr_er[$key]['ROI'] = $value['totalMoney'] ? sprintf('%.2f',$value['totalMoney']/$value['cost']) : '';
            $arr_er[$key]['mkzBljLv'] = $value['mkz'] ? sprintf('%.2f',$value['bljd']/$value['mkz']*100).'%' : '0%';

            $arr_er[$key]['jdl'] = $value['jd'] ? sprintf('%.2f',$value['yy']/$value['jd']*100).'%' : '0%';
            $arr_er[$key]['mkjdl'] = $value['mkz'] ? sprintf('%.2f',$value['jd']/$value['mkz']*100).'%' : '0%';
            $arr_er[$key]['jdjdl'] = $value['jd'] ? sprintf('%.2f',$value['mddj']/$value['jd']*100).'%' : '0%';

            array_push($returnData, $arr_er[$key]);
        }
        $returnData = my_sort($returnData,'channel_info_id');

        $arr['validRate'] = $arr['valid'] ? sprintf('%.2f',$arr['valid']/$arr['mkz']*100).'%' : '0%';
        $arr['unValidRate'] = $arr['valid'] ? sprintf('%.2f',$arr['unValid']/$arr['mkz']*100).'%' : '0%';
        $arr['ddRate'] = $arr['valid'] ? sprintf('%.2f',$arr['unValid']/$arr['mkz']*100).'%' : '0%';
        $arr['mkzJdRate'] = $arr['valid'] ? sprintf('%.2f',$arr['jd']/$arr['mkz']*100).'%' : '0%';
        $arr['validJdRate'] = $arr['valid'] ? sprintf('%.2f',$arr['jd']/$arr['valid']*100).'%' : '0%';
        $arr['jdOrderRate'] = $arr['valid'] ? sprintf('%.2f',$arr['order']/$arr['jd']*100).'%' : '0%';
        $arr['mkzOrderRate'] = $arr['valid'] ? sprintf('%.2f',$arr['order']/$arr['mkz']*100).'%' : '0%';
        $arr['validOrderRate'] = $arr['valid'] ? sprintf('%.2f',$arr['order']/$arr['valid']*100).'%' : '0%';
        $arr['mkzCost'] = $arr['cost'] ? sprintf('%.2f',$arr['cost']/$arr['mkz']) : '';
        $arr['validCost'] = $arr['cost'] ? sprintf('%.2f',$arr['cost']/$arr['valid']) : '';
        $arr['DingdanCost'] = $arr['cost'] ? sprintf('%.2f',$arr['cost']/$arr['dj']) : '';
        $arr['Dingdanlv'] = $arr['valid'] ? sprintf('%.2f',$arr['dj']/$arr['valid']*100).'%' : '0%';
        $arr['mkzDdl'] = $arr['mkz'] ? sprintf('%.2f',$arr['dj']/$arr['mkz']*100).'%' : '0%';
        $arr['runOfflv'] = $arr['mkz'] ? sprintf('%.2f',$arr['runOff']/$arr['mkz']*100).'%' : '0%';
        $arr['jdCost'] = $arr['cost'] ? sprintf('%.2f',$arr['cost']/$arr['jd']) : '';
        $arr['orderCost'] = $arr['cost'] ? sprintf('%.2f',$arr['cost']/$arr['order']) : '';
        $arr['orderAVG'] = $arr['totalMoney'] ? sprintf('%.2f',$arr['totalMoney']/$arr['order']) : '';
        $arr['txjj'] = $arr['dj'] ? sprintf('%.2f',$arr['totalpayMoney']/$arr['dj']) : '';
        $arr['totalMoney'] = sprintf('%.2f',$arr['totalMoney']);
        $arr['earnestMoney'] = sprintf('%.2f',$arr['earnestMoney']);
        $arr['factMoney'] = sprintf('%.2f',$arr['factMoney']);
        $arr['ROI'] = $arr['totalMoney'] ? sprintf('%.2f',$arr['totalMoney']/$arr['cost']) : '';
        $arr['mkzBljLv'] = $arr['mkz'] ? sprintf('%.2f',$arr['bljd']/$arr['mkz']*100).'%' : '0%';

        $arr['jdl'] = $arr['jd'] ? sprintf('%.2f',$arr['yy']/$arr['jd']*100).'%' : '0%';
        $arr['mkjdl'] = $arr['mkz'] ? sprintf('%.2f',$arr['jd']/$arr['mkz']*100).'%' : '0%';
        $arr['jdjdl'] = $arr['jd'] ? sprintf('%.2f',$arr['mddj']/$arr['jd']*100).'%' : '0%';

        $returnData[] = $arr;
        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($channels);
        $return['data'] = $returnData;
        // 导出
        if ($data['need'] == 1) {
            $title = array('渠道名称','毛客数','有效数','有效率','无效数','订单数','订单金额','套系均价','投放金额','毛客成本','有效成本','订单成本','订单率','无效率','ROI','毛客订单率','无意向度','流失数','进店数','邀约订单','进店订单数','门店订单','约进店数','进店率','毛客进店率','进店订单率','进店成本','已收金额',  '进店未定数','流失率','保留订单','订金','保留金','毛客保留金支付率','待确认数');

            $returnDatas = [];
            foreach ($returnData as $key => $value) {
                $rerurnDatas[$key]['channel_name'] = $value['channel_name'];
                $rerurnDatas[$key]['mkz'] = $value['mkz'];
                $rerurnDatas[$key]['valid'] = $value['valid'];
                $rerurnDatas[$key]['validRate'] = $value['validRate'];
                $rerurnDatas[$key]['unValid'] = $value['unValid'];
                $rerurnDatas[$key]['dj'] = $value['dj'];
                $rerurnDatas[$key]['totalMoney'] = $value['totalMoney'];
                $rerurnDatas[$key]['txjj'] = $value['txjj'];
                $rerurnDatas[$key]['cost'] = $value['cost'];
                $rerurnDatas[$key]['mkzCost'] = $value['mkzCost'];
                $rerurnDatas[$key]['validCost'] = $value['validCost'];
                $rerurnDatas[$key]['DingdanCost'] = $value['DingdanCost'];
                $rerurnDatas[$key]['Dingdanlv'] = $value['Dingdanlv'];
                $rerurnDatas[$key]['unValidRate'] = $value['unValidRate'];
                $rerurnDatas[$key]['ROI'] = $value['ROI'];
                $rerurnDatas[$key]['mkzDdl'] = $value['mkzDdl'];
                $rerurnDatas[$key]['notHave'] = $value['notHave'];
                $rerurnDatas[$key]['runOff'] = $value['runOff'];
                $rerurnDatas[$key]['jd'] = $value['jd'];
                $rerurnDatas[$key]['yyjd'] = $value['yyjd'];
                $rerurnDatas[$key]['djdd'] = $value['djdd'];
                $rerurnDatas[$key]['mddj'] = $value['mddj'];
                $rerurnDatas[$key]['yy'] = $value['yy'];
                $rerurnDatas[$key]['jdl'] = $value['jdl'];
                $rerurnDatas[$key]['mkjdl'] = $value['mkjdl'];
                $rerurnDatas[$key]['jdddl'] = $value['jdddl'];
                $rerurnDatas[$key]['jdCost'] = $value['jdCost'];
                $rerurnDatas[$key]['factMoney'] = $value['factMoney'];
                $rerurnDatas[$key]['jdUncertain'] = $value['jdUncertain'];
                $rerurnDatas[$key]['runOfflv'] = $value['runOfflv'];
                $rerurnDatas[$key]['bljd'] = $value['bljd'];
                $rerurnDatas[$key]['earnestMoney'] = $value['earnestMoney'];
                $rerurnDatas[$key]['bljMoney'] = $value['bljMoney'];
                $rerurnDatas[$key]['mkzBljLv'] = $value['mkzBljLv'];
                $rerurnDatas[$key]['mkzBh'] = $value['mkzBh'];
            }

            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            controller("crm/Customer", "lib")->export($title, $rerurnDatas, $file);
        } else {
            return json($return);
        }
    }
    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        //来源渠道
        $channel = getChannelJson($info['shop_code']);
        $this->assign("channel", json_encode($channel));
        //消费类型
        /*$consumptionType = controller("Customer", "lib")->consumptionType(['brandclass_id'=>$info['brandclass_id']]);
        $this->assign("consumptionType", $consumptionType);
        // crm省    列表
        $data['type'] = 1;
        $data['shop_code'] = $info['shop_code'];
        $province = controller("Customer", "lib")->address($data);
        $data['type'] = 2;
        $data['shop_code'] = $info['shop_code'];
        $city =  controller("Customer", "lib")->address($data);*/

        //客户来源
        $source=controller("crm/Customer","lib")->source(array('shop_code'=>$info['shop_code']));
        $this->assign("source", $source);

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');

        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        $this->assign('today',date('Y-m-d'));
        $this->assign('yestoday',date('Y-m-d',time()-86400));
        return $this->fetch($display);
    }
}