<?php
/**
 * 报表实现类 消费能力统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2018-06-12 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Pdl_capacity_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1538994208';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();

        $start = date('Y-m-d', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));
        $det = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        // 来源渠道
        $channel = controller('crm/Customer', 'lib')->getChannel($shop_code);
        $channels = array_column($channel,'channel_name');
        // 消费能力
        $capacity = controller('crm/Customer','lib')->capacity();
        $capacitys = array_column($capacity,'id');

        $where['is_status'] = 1;
        $where['c_from'] = 1;
        $where['shop_code'] = $shop_code;


        $info = db('c_customerinfo')
            ->where($where)
            ->where('yx_day', 'between time', [$start, $end])
            ->order('customer_channel_id')
            ->field('customer_capacity_id,customer_capacity,customer_channel,id')
            ->select();
        $returnData = [];
        $all['channel'] = '总计';
        foreach($channel as $kk=>$vv){
            $temp['channel'] = $vv['channel_name'];
            $total = '';
                foreach($capacity as $kkk=>$vvv){
                    $temp[$vvv['capacity']]= '';
                    foreach($info as $k=>$v){
                        if($vv['channel_name'] == $v['customer_channel'] && $vvv['capacity'] == $v['customer_capacity']){
                        $temp[$vvv['capacity']]+= 1;
                            $total += 1;
                            $all[$vvv['capacity']] += 1;
                    }
                }
              }
            $temp['total'] = $total;
            array_push($returnData,$temp);
        }
        $last = [];
        $num = db('c_customerinfo')
            ->where($where)
            ->where('customer_channel','not in',$channels)
            ->where('yx_day', 'between time', [$start, $end])
            ->group('customer_capacity_id')
            ->column('count(id)','customer_capacity');
        $last['channel']= '<span style="color: #0000FF">其它</span>';
        $sum = 0;
        foreach($capacity as $kk=>$vv){
            $last[$vv['capacity']] = $num[$vv['capacity']] ? $num[$vv['capacity']] : '';
            $sum += $num[$vv['capacity']];
            $all[$vv['capacity']] += $num[$vv['capacity']];
        }
        $last['total'] = $sum;
        array_push($returnData,$last);
        $all['total'] = array_sum(array_column($returnData,'total'));
        array_push($returnData,$all);

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($returnData);
        $return['data'] = $returnData;
        // 导出
        if ($data['need'] == 1) {
            $title = ['渠道名称'];
            $cap = array_column($capacity,'capacity');
            $title = array_merge($title,$cap);
            $code = $this->getCode();
            $ff = db('s_report_form')->where('code', $code)->value('report_name');
            $shop = controller('crm/Customer','lib')->get_shop(['shop_code'=>$data['shop_code']]);
            $file = $shop[0]['shop_name'].'-'.$ff.'.xlsx';
            unset($returnData[0]);
            controller("crm/Customer", "lib")->export($title, $returnData, $file);
        } else {
            return json($return);
        }
    }

    public function show(){
        $code = $this->getCode();
        $did = strtolower(input('param.did'));
        $info = db('s_report_form')->alias('f')->join('s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        // 消费能力
        $capacity = controller('crm/Customer','lib')->capacity();
        $this->assign('capacity', $capacity);
        // 来源渠道
        $channel = controller('crm/Customer', 'lib')->getChannel($info['shop_code']);
        $this->assign('channel', $channel);
        $this->assign('shop', $shop);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}