<?php
/**
 * 指标计算类。负责计算各种指标
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-11-23s $
 */
namespace app\crm\lib;
class Target {
    protected  $funcs =[
        'newCustomerNum'=>
            [
                'id' =>'newCustomerNum',
                'name'=>'毛客资量',
                'method'=>'newCustomerNum'
            ],
        'validCustomerNumber'=>
            [
                'id'=>'validCustomerNumber',
                'name'=>'有效客资量',
                'method'=>'validCustomerNumber'
            ],
        'validCustomerNumberDJ'=>
            [
                'id'=>'validCustomerNumberDJ',
                'name'=>'有效客资(登记时间)',
                'method'=>'validCustomerNumberDJ'
            ],
        'inviteIntoCustomerNumber'=>
            [
                'id'=>'inviteIntoCustomerNumber',
                'name'=>'邀约进店客资量',
                'method'=>'inviteIntoCustomerNumber'
            ],
        'actualIntoCustomerNumber'=>
            [
                'id'=>'actualIntoCustomerNumber',
                'name'=>'实际进店客资量',
                'method'=>'actualIntoCustomerNumber'
            ],
        'orderNumber'=>
            [
                'id'=>'orderNumber',
                'name'=>'新单量',
                'method'=>'orderNumber'
            ],
        'orderNumberStart'=>
            [
                'id'=>'orderNumberStart',
                'name'=>'总订单',
                'method'=>'orderNumberStart'
            ],
        'telVisitNumber'=>
            [
                'id'=>'telVisitNumber',
                'name'=>'电访量',
                'method'=>'telVisitNumber'
            ],
        'orderValueRate'=>
            [
                'id'=>'orderValueRate',
                'name'=>'成交率',
                'method'=>'orderValueRate',
                'type'=>'1'
            ],
        'intoValueRate'=>
            [
                'id'=>'intoValueRate',
                'name'=>'进店转化率',
                'method'=>'intoValueRate',
                'type'=>'1'
            ],
        'valueCustomerRate'=>
            [
                'id'=>'valueCustomerRate',
                'name'=>'客资有效率',
                'method'=>'valueCustomerRate',
                'type'=>'1'
            ],
        'valueCustomerIntoRate'=>
            [
                'id'=>'valueCustomerIntoRate',
                'name'=>'客资进店率',
                'method'=>'valueCustomerIntoRate',
                'type'=>'1'
            ],
        'valueCustomerconvertRate'=>
            [
                'id'=>'valueCustomerconvertRate',
                'name'=>'客资转换率',
                'method'=>'valueCustomerconvertRate',
                'type'=>'1'
            ],
        'dealAmount'=>
            [
                'id'=>'dealAmount',
                'name'=>'营收',
                'method'=>'dealAmount'
            ],
        'unvalidOrder'=>
            [
                'id'=>'unvalidOrder',
                'name'=>'无效新单',
                'method'=>'unvalidOrder'
            ],
        'ACustomerRate'=>
            [
                'id'=>'ACustomerRate',
                'name'=>'A客转化率',
                'method'=>'ACustomerRate'
            ],
        'ObtainCost'=>
            [
                'id'=>'ObtainCost',
                'name'=>'毛客资获取成本',
                'method'=>'ObtainCost'
            ],
        'NewOrderCost'=>
            [
                'id'=>'NewOrderCost',
                'name'=>'新单成本',
                'method'=>'NewOrderCost'
            ],
        'ValidCustomerCost'=>
            [
                'id'=>'ValidCustomerCost',
                'name'=>'有效客资成本',
                'method'=>'ValidCustomerCost'
            ],
        'aCustomerNum'=>
            [
                'id'=>'aCustomerNum',
                'name'=>'A客量',
                'method'=>'aCustomerNum'
            ],
        'bCustomerNum'=>
            [
                'id'=>'bCustomerNum',
                'name'=>'B客量',
                'method'=>'bCustomerNum'
            ],
        'cCustomerNum'=>
            [
                'id'=>'cCustomerNum',
                'name'=>'C客量',
                'method'=>'cCustomerNum'
            ],
        'oneFact'=>
            [
                'id'=>'oneFact',
                'name'=>'一销实收',
                'method'=>'oneFact'
            ],
        'totalFact'=>
            [
                'id'=>'totalFact',
                'name'=>'总实收',
                'method'=>'totalFact'
            ],
        'oneAVG'=>
            [
                'id'=>'oneAVG',
                'name'=>'一销均价',
                'method'=>'oneAVG'
            ],
        'zouDan'=>
        [
            'id' => 'zouDan',
            'name' => '走单',
            'method'=>'zouDan'
        ],
        'orderOnline'=>
        [
            'id' => 'orderOnline',
            'name' => '网付订单',
            'method'=>'orderOnline'
        ],
        'mkzToJDRate'=>
        [
            'id' => 'mkzToJDRate',
            'name' => '毛客资进店率',
            'method'=>'mkzToJDRate'
        ],
        'mkzToOrderRate'=>
        [
            'id' => 'mkzToOrderRate',
            'name' => '毛客资订单率',
            'method'=>'mkzToOrderRate'
        ],
        // 郑州babypastel定制
        'mtCus'=>[ // 分配给网销的美团客资的数量
            'id'=>'mtCus',
            'name'=>'美团',
            'method'=>'getMtCus',
            'customize'=>'babypastel',
        ],
        'pxCus'=>[ // 分配给网销的朋友圈渠道和小红书渠道的客资汇总
            'id'=>'pxCus',
            'name'=>'朋友圈+小红书',
            'method'=>'getPxCus',
            'customize'=>'babypastel',
        ],
        'dyCus'=>[ // 分配给网销的抖音渠道客资数量
            'id'=>'dyCus',
            'name'=>'抖音',
            'method'=>'getDyCus',
            'customize'=>'babypastel',
        ],
    ];
    public function get_target_name_by_id($id){
        $value = $this->getValueByKey($this->funcs,$id);
        return $value['name'];
    }
    public function get_target_method_by_id($id){
        $value = $this->getValueByKey($this->funcs,$id);
        return $value['method'];
    }
    function getValueByKey($arr, $key) {
        foreach($arr as $k => $v) {
            if ($k == $key) {
                return $v;
            }
        }
        return '';
    }

    /**
     * 计算  毛客资量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function newCustomerNum_old($params) {
        $res = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('dj_customer');
        return $res;
    }
    public function newCustomerNum($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();

            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->count();
            }
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));

            if ($start == $end) {
                $end = date("Y-m-d 23:59:59",strtotime('+1 day',strtotime($end)));
            }
            $staff_id = (int)$params['staff_id'];
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('dj_day', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('add_shop_code', session('shop_code'))
                ->where($sql, $arr)
                ->count('id');
        }
        return $res;
    }
    /**
     * 计算  有效客资量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function validCustomerNumber_old($params) {
        $res = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        return $res;
    }
    public function validCustomerNumber($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = $res = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->count();
            }
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));

            if ($start == $end) {
                $end = date("Y-m-d 23:59:59",strtotime('+1 day',strtotime($end)));
            }
            $staff_id = (int)$params['staff_id'];
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('yx_day', 'between time', [$start, $end])
                ->where('is_valid',1)
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }
        return $res;
    }
    /**
     * 计算  有效客资量 按登记时间算，标记有效的
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function validCustomerNumberDJ($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = $res = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->count();
            }
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));

            if ($start == $end) {
                $end = date("Y-m-d 23:59:59",strtotime('+1 day',strtotime($end)));
            }
            $staff_id = (int)$params['staff_id'];
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('dj_day', 'between time', [$start, $end])
                ->where('is_valid',1)
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }
        return $res;
    }
    /**
     * 计算  邀约进店客资量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function inviteIntoCustomerNumber_old($params) {
        $res = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('yjd');
        return $res;
    }
    public function inviteIntoCustomerNumber($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            $res = db('crm_c_customerinfo')
                ->where('yjd_day', 'between time',[$params['start_day'], $params['end_day']])
                ->where('is_status', 1)
                ->where('c_from', 1)
                // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                ->where('shop_code|add_shop_code', $params['shop_code'])
                ->count();
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('yjd_day', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }
        return $res;
    }
    /**
     * 计算  实际进店客资量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function actualIntoCustomerNumber_olde($params) {
        $res = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('syjd_jk');
        return $res;
    }
    public function actualIntoCustomerNumber($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = db('crm_c_customerinfo')
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2, 3])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2, 3])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2, 3])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }

        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('syjd_day', 'between time', [$start, $end])
                ->where('is_intostore','between',['2', '3'])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }

        return $res;
    }
    /**
     * 计算  电访量
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function telVisitNumber_old($params) {
        $res = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('tel_visit');
        return $res;
    }
    public function telVisitNumber($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }

        $res = db('crm_c_salestrackinginfo')
            ->where('tel_starttime', 'between time', [$start, $end])
            ->where('gtType', 1)
            ->where('sales_staff_id', $staff_id)
            // ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        return $res;
    }
    /**
     * 计算  进店转化率  进店/预约
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return float
     * @author Eric
     */
    public function valueCustomerIntoRate_old($params) {
        // 进店进客数
        $res_jk = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('syjd_jk');
        // 标记有效
        $res_yx = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        $res = $res_jk/$res_yx;
        return floatval($res);
    }
    public function valueCustomerIntoRate($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            $res_jd = db('crm_c_customerinfo')
                ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                ->where('is_intostore','in',[2,3])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                ->where('shop_code|add_shop_code', $params['shop_code'])
                ->count('id');
            $res_yx = db('crm_c_customerinfo')
                ->where('yjd_day', 'between time', [$params['start_day'], $params['end_day']])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                ->where('shop_code|add_shop_code', $params['shop_code'])
                ->count('id');
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res_jd = db('crm_c_customerinfo')
                ->where('syjd_day', 'between time', [$start, $end])
                ->where('is_intostore',2)
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
            $res_yx = db('crm_c_customerinfo')
                ->where('yjd_day', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }


        $res = floatval($res_jd/$res_yx);
        return $res;
    }
    /**
     * 计算  客资转换率
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id  订单/毛客资量
     * @return float
     * @author Eric
     */
    public function valueCustomerconvertRate_old($params) {
        $mk = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            ->where('staff_id', $params['staff_id'])
            ->sum('dj_customer');

        $yx = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');

        $res = $yx/$mk;
        return $res;
    }
    public function valueCustomerconvertRate($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
        $staff_id = (int)$params['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
        // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        // $arr['sk_staff_id']    = $staff_id;

        $res_yx = db('crm_c_customerinfo')
            ->where('order_day', 'between time', [$start, $end])
            ->where('is_success',1)
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res_mk = db('crm_c_customerinfo')
            ->where('dj_day', 'between time', [$start, $end])
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');

        $res = floatval($res_yx/$res_mk);
        return $res;
    }
    /**
     * 计算  成交金额   实收款
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id，staff_type(录入dj_staff_id，筛客sk_staff_id，接收sales_staff_id)
     * @return str
     * @author Eric
     */
    public function dealAmount_old($params) {
        $cids = db('crm_c_customerinfo')
            ->where('order_day','between',[$params['start_day'], $params['end_day']])
            ->where($params['staff_type'], $params['staff_id'])
            ->column('id');

        $res = db('crm_c_customer_order')
            ->where('create_time','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('customer_id', 'in', $cids)
            ->sum('order_fact');
        return $res;
    }
    public function dealAmount($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = db('crm_c_customerinfo')->alias('c')->join('crm_c_order_detail d','d.order_sn=c.order_number')
                    ->where('d.pay_time', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('c.is_status', 1)
                    ->where('c.c_from', 1)
                    ->where('c.shop_code|c.add_shop_code', $params['shop_code'])
                    ->sum('d.order_fact');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res =  db('crm_c_customerinfo')->alias('c')->join('crm_c_order_detail d','d.order_sn=c.order_number')
                    ->where('d.pay_time', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('c.is_status', 1)
                    ->where('c.c_from', 1)
                    ->where('c.dj_department_id|c.sales_department_id', $params['department_id'])
                    ->where('c.shop_code|c.add_shop_code', $params['shop_code'])
                    ->sum('d.order_fact');
            }else{
                $res = db('crm_c_customerinfo')->alias('c')->join('crm_c_order_detail d','d.order_sn=c.order_number')
                    ->where('d.pay_time', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('c.is_status', 1)
                    ->where('c.c_from', 1)
                    ->where('c.shop_code|c.add_shop_code', $params['shop_code'])
                    ->where('c.dj_staff_id|c.sales_staff_id','in', $staff_id)
                    // ->where('c.dj_staff_id|c.sales_staff_id|c.sk_staff_id','in', $staff_id)
                    ->sum('d.order_fact');
            }
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('order_start_time', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->sum('fact_money');
        }


        return $res;
    }
    /**
     * 计算  成交量  有效新单 is_success=1
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function orderNumber_old($params) {
        $res = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('orders');

        return $res;
    }
    public function orderNumber($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = db('crm_c_customerinfo')
                    ->where('order_day', 'between time', [$start, $end])
                    ->where('is_status', 1)
                    ->where('is_success', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('order_day', 'between time', [$start, $end])
                    ->where('is_status', 1)
                    ->where('is_success', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('order_day', 'between time', [$start, $end])
                    ->where('is_status', 1)
                    ->where('is_success', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->count();
            }

        }else{

            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('order_day', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('is_success', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }

        return $res;
    }
    /**
     * 计算  总订单  订单开始时间算
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function orderNumberStart($params) {
        $start = date('Y-m-d', strtotime($params['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = db('crm_c_customerinfo')
                    ->where('order_start_time', 'between time', [$start, $end])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('order_start_time', 'between time', [$start, $end])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('order_start_time', 'between time', [$start, $end])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->count();
            }
        }else{
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('order_start_time', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }
        return $res;
    }
    /**
     * 计算  订单转化率:order_rate DT/YT  YT：标记有效；DT：有效成单数
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return float
     * @author Eric
     */
    public function orderValueRate_old($params) {
        $dt = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_order');

        $yt = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');

        $res = $dt/$yt;
        return $res;
    }
    public function orderValueRate($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $dt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('order_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_success',1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yd = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid', 1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $dt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('order_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_success',1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yd = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid', 1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }else{
                $dt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('order_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_success',1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yd = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid', 1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }

        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $dt = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('order_day', 'between time', [$start, $end])
                ->where('is_success',1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');

            $yd = db('crm_c_customerinfo')
                ->where('yx_day', 'between time', [$start, $end])
                ->where('is_valid', 1)
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }
        $res = floatval($dt/$yd);
        return $res;
    }
    //成交率  订单/进店
    public function succRate($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $dt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('order_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_success',1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yd =  db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2,3])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $dt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('order_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_success',1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yd =  db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2,3])
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }else{
                $dt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('order_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_success',1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yd =  db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2,3])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }

        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $dt = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('order_day', 'between time', [$start, $end])
                ->where('is_success',1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');

            $yd = db('crm_c_customerinfo')
                ->where('syjd_day', 'between time', [$start, $end])
                ->where('is_intostore','in',[2,3])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }


        $res = floatval($dt/$yd);
        return $res;
    }
    /**
     * 计算  进店转化率:in_rate  实际进店数，进客(st)/YT  YT：标记有效；
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function intoValueRate_old($params) {
        $st = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('syjd_jk');

        $yt = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');

        $res = $st/$yt;
        return $res;
    }
    public function intoValueRate($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $st = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2,3])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yt = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('is_valid', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $st = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2,3])
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yt = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('is_valid', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }else{
                $st = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('syjd_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_intostore','in',[2,3])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $yt = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('is_valid', 1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }

        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $st = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('syjd_day', 'between time', [$start, $end])
                ->where('is_intostore',2)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');

            $yt = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('yx_day', 'between time', [$start, $end])
                ->where('is_valid',1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }


        $res = floatval($st/$yt);
        return $res;
    }
    /**
     * 计算  客资有效率  customer_rate YT/LT  LT：录入；YT：标记有效；
     * @param  array  start_day(Y-m-d)，end_day(Y-m-d)，shop_code，staff_id
     * @return str
     * @author Eric
     */
    public function valueCustomerRate_old($params) {

        $yt = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('valid_customer');
        $lt = db('crm_c_day_number')
            ->where('addtime','between',[$params['start_day'], $params['end_day']])
            // ->where('shop_code', $params['shop_code'])
            ->where('staff_id', $params['staff_id'])
            ->sum('dj_customer');
        $res = $yt/$lt;
        return $res;
    }
    public function valueCustomerRate($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);

            if(check_right('menu1512637269')) {//查看所有客资权限
                $yt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');

                $lt = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $yt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
                $lt = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }else{
                $yt = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('yx_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');

                $lt = db('crm_c_customerinfo')
                    ->where('dj_day', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }
        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $yt = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('yx_day', 'between time', [$start, $end])
                ->where('is_valid',1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');

            $lt = db('crm_c_customerinfo')
                ->where('dj_day', 'between time', [$start, $end])
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }


        $res = floatval($yt/$lt);
        return $res;
    }
    /**
     * 无效新单 is_success=2=3
     * @param  array
     * @return str
     * @author Eric
     */
    public function unvalidOrder($params) {
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $res = db('crm_c_customerinfo')
                    ->where('order_start_time', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('is_success','<>', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $res = db('crm_c_customerinfo')
                    ->where('order_start_time', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('is_success','<>', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }else{
                $res = db('crm_c_customerinfo')
                    ->where('order_start_time', 'between time', [$params['start_day'], $params['end_day']])
                    ->where('is_status', 1)
                    ->where('is_success','<>', 1)
                    ->where('c_from', 1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count();
            }

        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $res = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('order_start_time', 'between time', [$start, $end])
                ->where('is_success', '<>', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }


        return $res;
    }
    /*
     * A客转化率  A客/有效
     */
    public function ACustomerRate($params){
        if(is_string($params['staff_id']) && strpos($params['staff_id'],',')){
            $staff_id = explode(',',$params['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $aCus = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('sign_time', 'between time',  [$params['start_day'], $params['end_day']])
                    ->where('sign_name', 'like', 'A%')
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');

                $value = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time',  [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $aCus = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('sign_time', 'between time',  [$params['start_day'], $params['end_day']])
                    ->where('sign_name', 'like', 'A%')
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
                $value = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time',  [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_department_id|sales_department_id', $params['department_id'])
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }else{
                $aCus = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('sign_time', 'between time',  [$params['start_day'], $params['end_day']])
                    ->where('sign_name', 'like', 'A%')
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');

                $value = db('crm_c_customerinfo')
                    ->where('yx_day', 'between time',  [$params['start_day'], $params['end_day']])
                    ->where('is_valid',1)
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->where('shop_code|add_shop_code', $params['shop_code'])
                    ->count('id');
            }

        }else{
            $start = date('Y-m-d', strtotime($params['start_day']));
            $end   = date('Y-m-d 23:59:59', strtotime($params['end_day']));
            $staff_id = (int)$params['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;

            $aCus = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('sign_time', 'between time', [$start, $end])
                ->where('sign_name', 'like', 'A%')
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');

            $value = db('crm_c_customerinfo')
                ->where('yx_day', 'between time', [$start, $end])
                ->where('is_valid',1)
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }


        $res = floatval($aCus/$value);
        return $res;
    }
    /*
     * 花费
     * */
    function cost($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d', strtotime($param['end_day']));
        $channel_id = $param['channel_id'] ? $param['channel_id'] : 0;
        $province_id = $param['province_id'] ? $param['province_id'] : 0;
        $city_id = $param['city_id'] ? $param['city_id'] : 0;
        $arr = array();
        if($channel_id){
            $arr['channel_id'] = $channel_id;
        }
        if($province_id){
            $arr['province_id'] = $province_id;
        }
        if($city_id){
            $arr['city_id'] = $city_id;
        }
        $res = db('crm_s_channel_cost')->where('shop_code',$param['shop_code'])->where('cost_date','between',[$start,$end])->where($arr)->sum('cost');
        return $res;
    }
    /*
     * 毛客资获取成本
     * */
    function ObtainCost($params){
        $newCustomerNum = $this->newCustomerNum($params);
        $cost = $this->cost($params);
        $ret = sprintf('%.2f',$cost/$newCustomerNum);
        return $ret;
    }
    /*
     * 有效客资获取成本
     * */
    function ValidCustomerCost($params){
        $validCustomerNum = $this->validCustomerNumber($params);
        $cost = $this->cost($params);
        $ret = sprintf('%.2f',$cost/$validCustomerNum);
        return $ret;
    }
    /*
     * 新单成本
     * */
    function NewOrderCost($params){
        $validOrder = $this->orderNumber($params);
        $cost = $this->cost($params);
        $ret = sprintf('%.2f',$cost/$validOrder);
        return $ret;
    }
    function aCustomerNum($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            $staff_id = explode(',',$param['staff_id']);
            if(check_right('menu1512637269')) {//查看所有客资权限
                $a = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('sign_time', 'between time', [$start, $end])
                    ->where('sign_name', 'like','A')
                    ->where('shop_code|add_shop_code',  $param['shop_code'])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $a = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('sign_time', 'between time', [$start, $end])
                    ->where('sign_name', 'like','A')
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('shop_code|add_shop_code', $param['shop_code'])
                    ->count();
            }else{
                $a = db('crm_c_customerinfo')
                    ->where('is_status', 1)
                    ->where('c_from', 1)
                    ->where('sign_time', 'between time', [$start, $end])
                    ->where('sign_name', 'like','A')
                    ->where('shop_code|add_shop_code',  $param['shop_code'])
                    ->where('dj_staff_id|sales_staff_id','in', $staff_id)
                    // ->where('dj_staff_id|sales_staff_id|sk_staff_id','in', $staff_id)
                    ->count('id');
            }
            $sql = "dj_staff_id in :dj_staff_id or sales_staff_id in :sales_staff_id";
            // $sql = "dj_staff_id in :dj_staff_id or sales_staff_id in :sales_staff_id or sk_staff_id in :sk_staff_id";
            $arr['dj_staff_id']    = $param['staff_id'];
            $arr['sales_staff_id'] = $param['staff_id'];
            // $arr['sk_staff_id']    = $param['staff_id'];

        }else{

            $staff_id = (int)$param['staff_id'];
            if ($start == $end) {
                $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
            }
            $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
            // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
            $arr['dj_staff_id']    = $staff_id;
            $arr['sales_staff_id'] = $staff_id;
            // $arr['sk_staff_id']    = $staff_id;
            $a = db('crm_c_customerinfo')
                ->where('is_status', 1)
                ->where('c_from', 1)
                ->where('sign_time', 'between time', [$start, $end])
                ->where('sign_name', 'B客')
                ->where($sql, $arr)
                ->where('shop_code|add_shop_code', session('shop_code'))
                ->count('id');
        }
        return $a;
    }
    function bCustomerNum($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        $staff_id = (int)$param['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
        // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        // $arr['sk_staff_id']    = $staff_id;
        $b = db('crm_c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('sign_time', 'between time', [$start, $end])
            ->where('sign_name', 'C客')
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        return $b;
    }
    function cCustomerNum($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        $staff_id = (int)$param['staff_id'];
        if ($start == $end) {
            $end = date("Y-m-d",strtotime('+1 day',strtotime($end)));
        }
        $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id";
        // $sql = "dj_staff_id = :dj_staff_id or sales_staff_id = :sales_staff_id or sk_staff_id = :sk_staff_id";
        $arr['dj_staff_id']    = $staff_id;
        $arr['sales_staff_id'] = $staff_id;
        // $arr['sk_staff_id']    = $staff_id;
        $c = db('crm_c_customerinfo')
            ->where('is_status', 1)
            ->where('c_from', 1)
            ->where('sign_time', 'between time', [$start, $end])
            ->where('sign_name', 'A客')
            ->where($sql, $arr)
            ->where('shop_code|add_shop_code', session('shop_code'))
            ->count('id');
        return $c;
    }
    /*
     * 一销实收
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * */
    function oneFact($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $fact = db('crm_c_customerinfo')->alias('c')
                    ->join('crm_c_customer_order o','c.id=o.customer_id','left')
                    ->join('crm_c_order_detail d','o.order_sn=d.order_sn','left')
                    ->where('d.pay_type',1)
                    ->where('c.add_shop_code|c.shop_code',$param['shop_code'])
                    ->where('d.pay_time','between',[$start,$end])
                    ->sum('d.order_fact');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $fact = db('crm_c_customerinfo')->alias('c')
                    ->join('crm_c_customer_order o','c.id=o.customer_id','left')
                    ->join('crm_c_order_detail d','o.order_sn=d.order_sn','left')
                    ->where('d.pay_type',1)
                    ->where('c.dj_department_id|c.sales_department_id', $param['department_id'])
                    ->where('c.add_shop_code|c.shop_code',$param['shop_code'])
                    ->where('d.pay_time','between',[$start,$end])
                    ->sum('d.order_fact');
            }else{
                $fact = db('crm_c_customerinfo')->alias('c')
                    ->join('crm_c_customer_order o','c.id=o.customer_id','left')
                    ->join('crm_c_order_detail d','o.order_sn=d.order_sn','left')
                    ->where('c.dj_staff_id|c.sales_staff_id','in',$param['staff_id'])
                    ->where('d.pay_type',1)
                    ->where('c.add_shop_code|c.shop_code',$param['shop_code'])
                    ->where('d.pay_time','between',[$start,$end])
                    ->sum('d.order_fact');
            }
        }else{
            $fact = db('crm_c_customerinfo')->alias('c')
                ->join('crm_c_customer_order o','c.id=o.customer_id')
                ->join('crm_c_order_detail d','o.order_sn=d.order_sn')
                ->where('c.dj_staff_id|c.sales_staff_id','in',$param['staff_id'])
                ->where('d.pay_type',1)
                ->where('c.add_shop_code|c.shop_code',$param['shop_code'])
                ->where('d.pay_time','between',[$start,$end])
                ->sum('d.order_fact');
        }

        return sprintf('%.2f',$fact);
    }
    /*
     * 一销均价  套系/订单量
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * @notice:订单量成单就算,故和有效订单数量会不一样
     * */
    function oneAVG($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $total = db('crm_c_customerinfo')
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_start_time','between',[$start,$end])
                    ->sum('totalpay_money');
                $order = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_number','not null')
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_start_time','between',[$start,$end])
                    ->count();
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $total = db('crm_c_customerinfo')
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('order_start_time','between',[$start,$end])
                    ->sum('totalpay_money');
                $order = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('order_number','not null')
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_start_time','between',[$start,$end])
                    ->count();
            }else{
                $total = db('crm_c_customerinfo')
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_start_time','between',[$start,$end])
                    ->sum('totalpay_money');
                $order = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_number','not null')
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_start_time','between',[$start,$end])
                    ->count();
            }
        }else{
            $total = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('order_start_time','between',[$start,$end])
                ->sum('totalpay_money');
            $order = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('order_number','not null')
                ->where('is_status',1)
                ->where('is_success',1)
                ->where('c_from',1)
                ->where('order_start_time','between',[$start,$end])
                ->count();
        }
        return sprintf('%.2f',$total/$order);
    }
    /*
     * 总实收
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * */
    function totalFact($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $fact = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_start_time','between',[$start,$end])
                    ->sum('fact_money');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $fact = db('crm_c_customerinfo')
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_start_time','between',[$start,$end])
                    ->sum('fact_money');
            }else{
                $fact = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('order_start_time','between',[$start,$end])
                    ->sum('fact_money');
            }

        }else{
            $fact = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('order_start_time','between',[$start,$end])
                ->sum('fact_money');
        }
        return sprintf('%.2f',$fact);
    }
    /*
     * 走单（进店未成交）
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * */
    public function zouDan($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $zd = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',2)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('is_intostore','in',[2, 3])
                    ->where('syjd_day','between',[$start,$end])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $zd = db('crm_c_customerinfo')
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',2)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('is_intostore','in',[2, 3])
                    ->where('syjd_day','between',[$start,$end])
                    ->count('id');
            }else{
                $zd = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('is_success',2)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('is_intostore','in',[2, 3])
                    ->where('syjd_day','between',[$start,$end])
                    ->count('id');
            }

        }else{
            $zd = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('is_success',2)
                ->where('is_status',1)
                ->where('c_from',1)
                ->where('is_intostore','in',[2, 3])
                ->where('syjd_day','between',[$start,$end])
                ->count('id');
        }
        return $zd;
    }
    /*
     * 网付量
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * */
    public function orderOnline($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $zd = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',1)
                    ->where('order_type',1)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_day','between',[$start,$end])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $zd = db('crm_c_customerinfo')
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',1)
                    ->where('order_type',1)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_day','between',[$start,$end])
                    ->count('id');
            }else{
                $zd = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('is_success',1)
                    ->where('order_type',1)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_day','between',[$start,$end])
                    ->count('id');
            }

        }else{
            $zd = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('is_success',1)
                ->where('is_status',1)
                ->where('c_from',1)
                ->where('order_type',1)
                ->where('order_day','between',[$start,$end])
                ->count('id');
        }
        return $zd;
    }
    /*
     * 毛客资进店率
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * */
    public function mkzToJDRate($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $mkz = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_day','between',[$start,$end])
                    ->count('id');
                $jd = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_intostore','in',[2, 3])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('syjd_day','between',[$start,$end])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $mkz = db('crm_c_customerinfo')
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_day','between',[$start,$end])
                    ->count('id');
                $jd = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_intostore','in',[2, 3])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('syjd_day','between',[$start,$end])
                    ->count('id');
            }else{
                $mkz = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_day','between',[$start,$end])
                    ->count('id');
                $jd = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_intostore','in',[2, 3])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('syjd_day','between',[$start,$end])
                    ->count('id');
            }

        }else{
            $mkz = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('is_status',1)
                ->where('c_from',1)
                ->where('dj_day','between',[$start,$end])
                ->count('id');
            $jd = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('is_intostore','in',[2, 3])
                ->where('is_status',1)
                ->where('c_from',1)
                ->where('syjd_day','between',[$start,$end])
                ->count('id');
        }
        return sprintf('%.2f',$jd/$mkz);
    }
    /*
     * 毛客资订单率
     * @param:start_day,end_day,staff_id,shop_code
     * @return fact
     * */
    public function mkzToOrderRate($param){
        $start = date('Y-m-d', strtotime($param['start_day']));
        $end   = date('Y-m-d 23:59:59', strtotime($param['end_day']));
        if(is_string($param['staff_id']) && strpos($param['staff_id'],',')){
            if(check_right('menu1512637269')) {//查看所有客资权限
                $mkz = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_day','between',[$start,$end])
                    ->count('id');
                $order = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',1)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_day','between',[$start,$end])
                    ->count('id');
            }elseif(check_right('menu1531471639')) {//查看部门客资权限
                $mkz = db('crm_c_customerinfo')
                    ->where('dj_department_id|sales_department_id', $param['department_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_day','between',[$start,$end])
                    ->count('id');
                $order = db('crm_c_customerinfo')
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',1)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_day','between',[$start,$end])
                    ->count('id');
            }else{
                $mkz = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('dj_day','between',[$start,$end])
                    ->count('id');
                $order = db('crm_c_customerinfo')
                    ->where('dj_staff_id|sales_staff_id','in',$param['staff_id'])
                    ->where('add_shop_code|shop_code',$param['shop_code'])
                    ->where('is_success',1)
                    ->where('is_status',1)
                    ->where('c_from',1)
                    ->where('order_day','between',[$start,$end])
                    ->count('id');
            }

        }else{
            $mkz = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('is_status',1)
                ->where('c_from',1)
                ->where('dj_day','between',[$start,$end])
                ->count('id');
            $order = db('crm_c_customerinfo')
                ->where('dj_staff_id|sales_staff_id',$param['staff_id'])
                ->where('add_shop_code|shop_code',$param['shop_code'])
                ->where('is_success',1)
                ->where('is_status',1)
                ->where('c_from',1)
                ->where('order_day','between',[$start,$end])
                ->count('id');
        }
        return sprintf('%.2f',$order/$mkz);
    }
    
    public function getAllTarget() {
        return $this->funcs;
    }

}


