<?php
/**
 * CRM 基本模块
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-17 $
 */
namespace app\crm\controller;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Response;
use think\Session;
use think\Controller;
use app\common\lib\redisQueue;
use app\common\lib\erpInterface;
use app\common\lib\mcInterface;
class Client extends Base{

    /*
     * 客户管理列表  
     *
     * @param  start_time   开始时间
     * @param  end_time     结束时间
     * @param  more_like    搜索内容（id，妈妈姓名，手机号，微信号）
     * @param  tab          当前Tab
     *
     * @author wangyining<wangyining@suxuantech.cn>
     */
    public function clientMainList(){
        // 查询 数据
        if(Request::instance()->isAjax()) {
            $data = input();

            if (!$data['start_time']) {
                $data['start_time']=date('Y-m-01');
            }
            if ($data['end_time']) {
                $end_time = $data['end_time'];
                $data['end_time'] = date("Y-m-d 23:59:59",strtotime("$end_time +1days") );
            }else{
                $end_time = date("Y-m-d 23:59:59", strtotime("+1 days") );
                $data['end_time'] = $end_time;
            }
            if (!$data['tab']) {
                $data['tab'] = 1;
            }


            $detail = controller("crm/Client","lib")->clientListDataAll($data);

            echo json_encode($detail);


        }
        // 显示页面
        else{
            // 菜单及权限
            $menu=getAuth($type='auth');
            $this->assign('menu',$menu);
            $menuCode= array_column($menu,'menu_code');

            // 要控制的所有右键菜单
            $allRightMenu = [
                'menu1589781108',//右键-客户详情
                // 'menu1589781109',//右键-客资列表
            ];

            $rightMenuList = array_intersect($allRightMenu,$menuCode);
            $this->assign('right_menu_list', $rightMenuList);
            // 客资列表的tab
            $allRab = [
                'menu1589781104',//选项卡-所有客户
                'menu1589781105',//选项卡-潜在客户 （有订单，且全部为 免费订单的客户）
                'menu1589781106',//选项卡-一次消费客户 （有订单，且只有一次收费订单的客户）
                'menu1589781107',//选项卡-多次消费客户 （有订单，有多次次收费订单的客户）
            ];
            $allRab = array_intersect($allRab,$menuCode);
            if (in_array('menu1589781104',$allRab)) {
                $this->assign('this_tab','menu1589781104');
            }else if (in_array('menu1589781105',$allRab)) {
                $this->assign('this_tab','menu1589781105');
            }else if (in_array('menu1589781106',$allRab)) {
                $this->assign('this_tab','menu1589781106');
            }else if (in_array('menu1589781107',$allRab)) {
                $this->assign('this_tab','menu1589781107');
            }
            $start=date('Y-m-01');
            $end=date('Y-m-d');
            $this->assign('start',$start);
            $this->assign('end',$end);

            //客户地址
            $data['type']=1;
            $address=controller("Customer","lib")->address($data);
            $this->assign("address",$address);

            $colModel = [];
            $this->assign('colModel',json_encode($colModel));
            $colNames = [];
            $this->assign('colNames',json_encode($colNames));
            return view('client_child');
        }
    }


    /*
     * 获取各个tab数量
     * @param  start_time   开始时间
     * @param  end_time     结束时间
     * @param  more_like    搜索内容（id，妈妈姓名，手机号，微信号）
     * @author wangyining<wangyining@suxuantech.cn>
     */
    public function clientMainCount(){
        $data = input();

        if (!$data['start_time']) {
            $data['start_time']=date('Y-m-01');
        }
        if ($data['end_time']) {
            $end_time = $data['end_time'];
            $data['end_time'] = date("Y-m-d 23:59:59",strtotime("$end_time +1days") );
        }else{
            $end_time = date("Y-m-d 23:59:59", strtotime("+1 days") );
            $data['end_time'] = $end_time;
        }
        if (!$data['tab']) {
            $data['tab'] = 1;
        }

        return controller('Client','lib')->clientMainCount($data);
    }

    /*
     * 客户详情 基本信息
     *
     * @param  id  客户表主键ID
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getClientInfo(){
        $param = input();
        $mid = (int)$param['id'];
        if (!$mid) {
            $return = array('error'=>'1','msg'=>'没有获取到客户ID');
            return json($return);
            exit;
        }
        $auth = check_right('menu1589781108');
        if (!$auth) {
            $return = array('error'=>'1','msg'=>'您没有查看客户详情的权限');
            return json($return);
            exit;
        }
        $client = db('crm_c_customer_main')->alias('m')
            ->join('crm_c_customerinfo cus','m.wphone=cus.customer_tel AND cus.is_status=1','left')
            ->join('crm_c_client_introduct intr','m.id=intr.mid','left')
            ->join('c_customerinfo ec','m.wphone=ec.wphone','left')
            ->join('c_customerorder eo','ec.customerid=eo.customerid','left')
            ->field('m.id,m.c_unique,m.wname,m.wphone,m.wwechat,m.email,m.province,m.city,m.county,m.address,m.create_time,m.update_time,COUNT(cus.id) AS cus_num,COUNT(intr.id) AS intr_num,COUNT(eo.id) AS order_num')
            ->group('m.wphone')
            ->where('m.id',$mid)->find();
        $this->assign('client',$client);

        $trackInfos = controller("crm/Customer","lib")->getCustomerTrackInfos(0,$client['c_unique']);
        $this->assign('trackInfoss',$trackInfos);
        return $this->fetch();
    }
    
    /*
     * 客户详情 客资列表
     *
     * @param  id  客户表主键ID
     *
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getClientCustomerinfo(){
        $param = input();
        $mid = (int)$param['id'];
        if (!$mid) {
            $return = array('error'=>'1','msg'=>'没有获取到客户ID');
            return json($return);
            exit;
        }
        $client = db('crm_c_customer_main')->where('id',$mid)->find();
        $showerp = db_config('list_search_is_in_erp');
        if($showerp == 1){
            $where = ['is_status'=>1];
        }else{
            $where = ['is_status'=>1,'c_from'=>1];
        }
        $cusList= db('crm_c_customerinfo')
                ->where('customer_tel',$client['wphone'])
                ->where($where)
                ->select();
        foreach ($cusList as $key => $value) {
            $cusList[$key]['baby_birthday'] = date('Y-m-d',strtotime($value['baby_birthday']));
        }
        return array('code'=>200,'data'=>$cusList);
    }

    /*
     * 客户详情 关系列表
     * @param  id  客户表主键ID
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getClientRelationinfo(){
        $param = input();
        $mid = (int)$param['id'];
        if (!$mid) {
            $return = array('error'=>'1','msg'=>'没有获取到客户ID');
            return json($return);
            exit;
        }
        // 亲
        $qList = db('crm_c_client_introduct')->alias('intr')
            ->join('crm_c_customer_main m','intr.introduct_mid=m.id','left')
            ->join('c_customerinfo c','c.customerid=m.wphone','left')
            ->join('c_customerorder o','c.customerid=o.customerid','left')
            ->where('intr.mid',$mid)->where('intr.type',1)
            ->field('m.c_unique,m.wname,m.wphone,COUNT(o.id) AS oNum')
            ->select();
        foreach ($qList as $key => $value) {
            if (!$value['c_unique']) {
                unset($qList[$key]);
            }
        }
        // 友
        $yList = db('crm_c_client_introduct')->alias('intr')
            ->join('crm_c_customer_main m','intr.introduct_mid=m.id','left')
            ->join('c_customerinfo c','c.customerid=m.wphone','left')
            ->join('c_customerorder o','c.customerid=o.customerid','left')
            ->where('intr.mid',$mid)->where('intr.type',2)
            ->field('m.c_unique,m.wname,m.wphone,COUNT(o.id) AS oNum')
            ->select();
        foreach ($yList as $key => $value) {
            if (!$value['c_unique']) {
                unset($yList[$key]);
            }
        }
        // 介绍我的
        $jList = db('crm_c_client_introduct')->alias('intr')
            ->join('crm_c_customer_main m','intr.mid=m.id','left')
            ->join('c_customerinfo c','c.customerid=m.wphone','left')
            ->join('c_customerorder o','c.customerid=o.customerid','left')
            ->where('intr.introduct_mid',$mid)
            ->field('m.c_unique,m.wname,m.wphone,COUNT(o.id) AS oNum')
            ->select();
        // echo db()->getLastSql();die;
        foreach ($jList as $key => $value) {
            if (!$value['c_unique']) {
                unset($jList[$key]);
            }
        }
        $return['qList'] = $qList;
        $return['yList'] = $yList;
        $return['jList'] = $jList;
        return json(array('code' => 200, 'msg'=>'', 'data'=>$return));
    }

    /*
     * 客户详情 客户轨迹
     * @param  id  客户表主键ID
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getClientLocus(){
        $param = input();
        $mid = (int)$param['id'];
        if (!$mid) {
            $return = array('code'=>'100','msg'=>'没有获取到客户ID');
            return json($return);
            exit;
        }
        // c_customer_track
        $wphone = db('crm_c_customer_main')->where('id',$mid)->value('wphone');
        if (!$wphone) {
            $return = array('code'=>'101','msg'=>'没有获取到客户手机');
            return json($return);
            exit;
        }
        // $field = 'o.orderId,o.targetdate,o.consumption_type,o.package_name,o.total_money,o.payment_money,o.allfinishfate,t.*';
        $track = db('c_customer_track')->alias('t')
            // ->join('c_customerorder o','t.customerid=o.customerid','left')
            ->where('t.wphone',$wphone)
            // ->field($field)
            // ->order('o.targetdate desc,t.orderId,t.operating_time desc')
            ->order('t.operating_time desc')
            ->select();
        // $return = [];
        // foreach ($track as $key => $value) {
        //     // var_dump($value);
        //     $return[$value['orderId']]['orderId']         = $value['orderId'];
        //     $return[$value['orderId']]['targetdate']      = $value['targetdate'];
        //     $return[$value['orderId']]['consumption_type']= $value['consumption_type'];
        //     $return[$value['orderId']]['package_name']    = $value['package_name'];
        //     $return[$value['orderId']]['total_money']     = $value['total_money'];
        //     $return[$value['orderId']]['payment_money']   = $value['payment_money'];
        //     $return[$value['orderId']]['allfinishfate']   = $value['allfinishfate'];

        //     $temp['currentfc']        = $value['currentfc'];
        //     $temp['operating_name']   = $value['operating_name'];
        //     $temp['operating_time']   = $value['operating_time'];
        //     $temp['operating_content']= $value['operating_content'];
        //     $temp['remark_details']   = $value['remark_details'];
        //     $temp['operating_type']   = $value['operating_type'];
        //     $temp['type_subordinate'] = $value['type_subordinate'];
        //     $return[$value['orderId']]['track'][] = $temp;
        //     $temp = [];
        // }
        // $i = 0;
        // $data = [];
        // foreach ($return as $key => $value) {
        //     $data[$i] = $value;
        //     $i++;
        // }
        return array('code' => 200, 'data'=>$track);   
    }

    //导出客户信息
    public function export(){
        $params = input();
        $params['export'] = 1;

        if (!$params['start_time']) {
            $params['start_time'] = date('Y-m-01');
        }
        if ($params['end_time']) {
            $end_time = $params['end_time'];
            $params['end_time'] = date("Y-m-d 23:59:59",strtotime("$end_time +1days") );
        }else{
            $end_time = date("Y-m-d 23:59:59", strtotime("+1 days") );
            $params['end_time'] = $end_time;
        }
        if (!$params['tab']) {
            $params['tab'] = 1;
        }

        $data = controller('client','lib')->clientListDataAll($params);

        //print_r($data);die;
        $list = [];
        foreach($data['new_rows'] as $k => $v){
            $arr = [
                'c_unique' => $v['c_unique'],
                'wname'    => $v['wname'],
                'wphone'   => $v['wphone'],
                'babyname' => $v['babyname'],
                'babybirthday' => $v['babybirthday'],
                'babysex' => $v['babysex'],
                'wwechat' => $v['wwechat'],
                'email'   => $v['email'],
                'order_num' => $v['order_num'],
                'sumshu'  => $v['sumshu'],
                'intr_num'=> $v['intr_num'],
                'city'    => $v['city'],
                'county'  => $v['county'],
                'address' => $v['address'],
            ];
            $list[] = $arr;
        }
        $title = ['客户编号','客户姓名','手机号','宝宝姓名','宝宝生日','宝宝性别','微信','邮箱','订单数','订单总金额','转介绍数','城市','地区','详细地址'];

        controller('client','lib')->export($title,$list,'客户信息.xlsx');

    }

    /*
     * 客户中心首页统计
     */
    public function home(){
        // cache('update_lock',null);
        //本月
        $start_time = date('Y-m-01 00:00:00');
        $end_time =  date('Y-m-d 23:59:59');
        $stime = date('Ym01');
        $etime = date('Ymd');
        //总客户数
        // $all = db('crm_c_customer_main')->count('id');

        //本月新增客户数
        // $the_month =  db('crm_c_customer_main')->where('create_time','BETWEEN',[$start_time,$end_time])->count('id');

        //会员数  c_vipcardinfo 取总数
        // $all_vip = db('crm_c_customer_main')
        //     ->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone','left')
        //     ->where('erp_c.customerid is not null')
        //     ->count('c.id');
        // $all_vip = db('c_vipcardinfo')->count('cardid');

        //本月新增会员数
        // $the_month_vip = db('crm_c_customer_main')
        //     ->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone','left')
        //     ->join('c_vipcardinfo erp_vip','erp_c.vipnum = erp_vip.cardid','left')
        //     ->where('erp_c.vipnum is not null')
        //     ->where('erp_vip.givetime','BETWEEN',[date('Ymd',strtotime($start_time)),date('Ymd',strtotime($end_time))])
        //     ->count('c.id');
        // $the_month_vip = db('c_vipcardinfo')
        //             ->where('create_time','BETWEEN',[$stime,$etime])
        //             ->count('cardid');



        //本月实收
        // $month_pay = db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->join('c_paymentcontent pay','erp_order.orderId = pay.orderId')
        //     ->where('paymentdate','BETWEEN',[date('Ymd',strtotime($start_time)),date('Ymd',strtotime($end_time))])
        //     ->sum('pay.payment_money');

        // $month_pay = db('c_paymentcontent')
        //         ->where('paymentdate',[$stime,$etime])
        //         ->where('isshishou','实收')
        //         ->sum('payment_money');

        //总会员卡余额
        // $vip_money = db('crm_c_customer_main')
        //     ->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone','left')
        //     ->join('c_vipcardinfo erp_vip','erp_c.vipnum = erp_vip.cardid','left')
        //     ->group('erp_c.vipnum')
        //     ->sum('erp_vip.cardmoney');

        // $vip_money = db('c_vipcardinfo')->sum('cardmoney');

        //本月新增充值
        // $month_cz = db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->join('c_paymentcontent pay','erp_order.orderId = pay.orderId')
        //     ->where('paymentdate','BETWEEN',[date('Ymd',strtotime($start_time)),date('Ymd',strtotime($end_time))])
        //     ->where('pay.payclass',3)
        //     ->where('pay.payment_money','>',0)
        //     ->sum('pay.payment_money');
        // $month_cz = db('c_paymentcontent')
        //             ->where('paymentdate','BETWEEN',[$stime,$etime])
        //             ->where('payclass',3)
        //             // ->where('payment_money','>',0)
        //             ->sum('payment_money');


        //本月卡销
        // $month_kx = db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->join('c_paymentcontent pay','erp_order.orderId = pay.orderId')
        //     ->where('paymentdate','BETWEEN',[date('Ymd',strtotime($start_time)),date('Ymd',strtotime($end_time))])
        //     ->where('pay.paytype','VIP卡')
        //     ->where('pay.payment_money','>',0)
        //     ->sum('pay.payment_money');

        // $month_kx = db('c_paymentcontent')
        //             ->where('paymentdate','BETWEEN',[$stime,$etime])
        //             ->where('pay.paytype','VIP卡')
        //             ->where('payment_money','>',0)
        //             ->sum('payment_money');

        //总订单数
        // $order =  db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->count('c.id');
        // $order = db('c_customerorder')
        //         ->where('blankoutannal','<>',1)
        //         ->count('c.id');

        //本月新增订单
        // $month_order = db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->where('targetdate','BETWEEN',[date('Ymd',strtotime($start_time)),date('Ymd',strtotime($end_time))])
        //     ->count('c.id');
        // $month_order = db('c_customerorder')
        //         ->where('blankoutannal','<>',1)
        //         ->where('targetdate','BETWEEN',[$stime,$etime])
        //         ->count('c.id');
        //待拍套系(订单关联服次表，一个服次一个套系，关联拍照信息最新一条，拍照信息大于今天或者为空，并且拍照状态<>2全拍完)
        $now = date('Ymd');
        // $not_photo = db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->join('c_customerorder_servicefc fc','fc.orderId = erp_order.orderId')
        //     ->join('c_consumptioncontent xm','fc.orderId = xm.orderId and fc.currentfc = xm.servicenumber')
        //     ->join('(SELECT MAX(id) AS id, orderId,currentfc,photodate,photostate FROM c_customerphoto GROUP BY id) as photo','photo.orderId = fc.orderId and photo.currentfc = fc.currentfc')
        //     ->where('targetdate','BETWEEN',[date('Ymd',strtotime($start_time)),date('Ymd',strtotime($end_time))])
        //     ->where('(photo.photodate is null or photo.photodate <= "'.$now.'") and photostate <> 2')
        //     ->field('count(c.id) as num,sum(xm.yejiprice) as money')
        //     ->find();
        // $not_photo = db('c_customerorder erp_order')
        //              ->join('c_customerorder_servicefc fc','fc.orderId = erp_order.orderId')
        //             ->join('c_consumptioncontent xm','fc.orderId = xm.orderId and fc.currentfc = xm.servicenumber')
        //             ->join('(SELECT MAX(id) AS id, orderId,currentfc FROM c_customerphoto GROUP BY orderId,currentfc) as photo','photo.orderId = fc.orderId and photo.currentfc = fc.currentfc')
        //             ->join('c_customerphoto p','p.id = photo.id','left')
        //             ->where('p.photostate <> 2')
        //             ->field('count(c.id) as num,sum(xm.yejiprice) as money')
        //             ->find();
        //消费类型
        // $consumptiontype = db('s_consumptiontype')->where('FIND_IN_SET("'.session('shop_code').'",shop_code)')->column('consumption_name');
        // $groupOrder =  db('crm_c_customer_main')->alias('c')
        //     ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
        //     ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
        //     ->group('erp_order.consumption_type')
        //     ->column('count(c.id)','consumption_type');
        // $consumption_type_arr = [];
        // foreach($consumptiontype as $k => $v){
        //     $consumption_type_arr[$k]['name']  = $v;
        //     $consumption_type_arr[$k]['value'] = $groupOrder[$v] ? $groupOrder[$v] : 0;
        // }

        //今年每月订单数
        $year_start = date('Y-01-01');
        $year_end = date('Y-12-31');
        $monthOrder =  db('crm_c_customer_main')->alias('c')
            ->join('c_customerinfo erp_c','c.wphone = erp_c.wphone')
            ->join('c_customerorder erp_order','erp_c.customerid = erp_order.customerid')
            ->where('targetdate','BETWEEN',[date('Ymd',strtotime($year_start)),date('Ymd',strtotime($year_end))])
            ->group('MONTH(erp_order.targetdate)')
            ->field('MONTH(erp_order.targetdate) as month,count(c.id) as num')
            ->select();
        $month = [1,2,3,4,5,6,7,8,9,10,11,12];
        $month_arr = [];
        foreach($monthOrder as $k => $v){
            $month_arr[$v['month']] = $v['num'];
        }

        $month_order_arr = [];
        foreach($month as $kk => $vv){
            $month_order_arr[$vv] = $month_arr[$vv] ? $month_arr[$vv] : 0;
        }

        $this->assign([
            'all'       => '-',
            'the_month' => '-',
            'all_vip'   => '-',
            'the_month_vip' => '-',
            'month_pay' => '-',//本月实收
            'vip_money' => '-',//总会员卡余额
            'month_cz' => '-',//本月新增充值
            'month_kx' => '-',//本月卡消
            'order' => '-',//总订单数
            'month_order' => '-',//本月新增订单
            'not_photo' => '-',//待拍套系数
            'not_photo_money' => '-',//待拍套系总额
            'consumptiontype' => json_encode($consumptiontype),
            'consumption_type_arr' => json_encode($consumption_type_arr),
            'month_order_arr' => json_encode($month_order_arr),
        ]);
        return $this->fetch();
    }
    public function getConsumptionData(){
        // $consumptiontype = db('s_consumptiontype')->where('FIND_IN_SET("'.session('shop_code').'",shop_code)')->column('consumption_name');
        $groupOrder =  db('c_customerorder erp_order')
            ->group('erp_order.consumption_type')
            ->column('count(orderId)','consumption_type');
        $consumption_type_arr = [];
        foreach ($groupOrder as $key => $value) {
            $consumptiontype[] = $key;
            $consumption_type_arr[] = [
                'name'=>$key,
                'value' => $value ? $value : 0,
            ];
            
        }
        return json(
            [
                'code'=>200,
                'data'=>
                [
                    'consumptiontype'=>$consumptiontype,
                    'consumption_type_arr'=>$consumption_type_arr
                ]
            ]
        );
    }
    public function getYearOrders(){
        $year_start = date('Y0101');
        $year_end = date('Y1231');
        $monthOrder =  db('c_customerorder erp_order')
            ->where('targetdate','BETWEEN',[$year_start,$year_end])
            ->group('MONTH(erp_order.targetdate)')
            ->field('MONTH(erp_order.targetdate) as month,count(orderId) as num')
            ->select();
        $month = [1,2,3,4,5,6,7,8,9,10,11,12];
        $month_arr = [];
        foreach($monthOrder as $k => $v){
            $month_arr[$v['month']] = $v['num'];
        }

        $month_order_arr = [];
        foreach($month as $kk => $vv){
            $month_order_arr[] = $month_arr[$vv] ? $month_arr[$vv] : 0;
        }
        return json(
            [
                'code'=>200,
                'data'=>
                [
                    'month_order_arr'=>$month_order_arr,
                    // 'consumption_type_arr'=>$consumption_type_arr
                ]
            ]
        );
    }
    public function getData(){
        $start_time = date('Y-m-01 00:00:00');
        $end_time =  date('Y-m-d 23:59:59');
        $stime = date('Ym01');
        $etime = date('Ymd');
        $data = explode(',', input('data'));
        $returnData = [];
        if(in_array('all_customer', $data)){
            //总客户数
            $returnData['all_customer'] = db('crm_c_customer_main')->count('id');
            $returnData['all_customer'] = $returnData['all_customer']?$returnData['all_customer']:0;
            $sql['总客户数'] = db()->getLastSql();
        }

        if(in_array('the_month', $data)){
            //本月新增客户数
            $returnData['the_month'] =  db('crm_c_customer_main')
                    ->where('create_time','BETWEEN',[$start_time,$end_time])
                    ->count('id');
            $returnData['the_month'] = $returnData['the_month']?$returnData['the_month']:0;
            $sql['本月新增客户数'] = db()->getLastSql();
        }

        if(in_array('all_vip', $data)){
            //会员数  c_vipcardinfo 取总数
            $returnData['all_vip'] = db('c_vipcardinfo')->count('cardid');
            $returnData['all_vip'] = $returnData['all_vip']?$returnData['all_vip']:0;
            $sql['总会员数'] = db()->getLastSql();
        }
            
        if(in_array('the_month_vip', $data)){
            //本月新增会员数
            $returnData['the_month_vip'] = db('c_vipcardinfo')
                    ->where('givetime','BETWEEN',[$stime,$etime])
                    ->count('cardid');
            $returnData['the_month_vip'] = $returnData['the_month_vip']?$returnData['the_month_vip']:0;
            $sql['本月新增会员数'] = db()->getLastSql();
        }
            
        if(in_array('month_pay', $data)){
            //本月实收
            $returnData['month_pay'] = db('c_paymentcontent')
                    ->where('paymentdate','BETWEEN',[$stime,$etime])
                    ->where('isshishou','实收')
                    ->sum('payment_money');
            $returnData['month_pay'] = $returnData['month_pay']?$returnData['month_pay']:0.00;
            $sql['本月实收'] = db()->getLastSql();
        }
        if(in_array('vip_money', $data)){
            //总会员卡余额
            $returnData['vip_money'] = db('c_vipcardinfo')->sum('cardmoney');
            $returnData['vip_money'] = $returnData['vip_money']?$returnData['vip_money']:0.00;
            $sql['总会员卡余额'] = db()->getLastSql();
        }
        if(in_array('month_cz', $data)){
            //本月新增充值
            $returnData['month_cz'] = db('c_paymentcontent')
                            ->where('paymentdate','BETWEEN',[$stime,$etime])
                            ->where('payclass',3)
                            // ->where('payment_money','>',0)
                            ->sum('payment_money');
            $returnData['month_cz'] = $returnData['month_cz']?$returnData['month_cz']:0.00;
            $sql['本月新增充值'] = db()->getLastSql();
        }
        if(in_array('month_kx', $data)){
            //本月卡销
            $returnData['month_kx'] = db('c_paymentcontent')
                            ->where('paymentdate','BETWEEN',[$stime,$etime])
                            ->where('paytype','VIP卡')
                            ->where('payment_money','>',0)
                            ->sum('payment_money');
            $returnData['month_kx'] = $returnData['month_kx']?$returnData['month_kx']:0.00;
            $sql['本月卡销'] = db()->getLastSql();
        }
        if(in_array('order', $data)){
            //总订单数
            $returnData['order'] = db('c_customerorder')
                        ->where('blankoutannal','<>',1)
                        ->count('id');
            $returnData['order'] = $returnData['order']?$returnData['order']:0;
            $sql['总订单数'] = db()->getLastSql();
        }

        if(in_array('month_order', $data)){
            //本月新增订单
            $returnData['month_order'] = db('c_customerorder')
                        ->where('blankoutannal','<>',1)
                        ->where('targetdate','BETWEEN',[$stime,$etime])
                        ->count('id');
            $returnData['month_order'] = $returnData['month_order']?$returnData['month_order']:0;
            $sql['本月新增订单'] = db()->getLastSql();
        }
        if(in_array('not_photo', $data)){
            //待拍套系(订单关联服次表，一个服次一个套系，关联拍照信息最新一条，拍照状态<>2 )
            $not_photo = db('c_customerorder erp_order')
                     ->join('c_customerorder_servicefc fc','fc.orderId = erp_order.orderId')
                    ->join('c_consumptioncontent xm','fc.orderId = xm.orderId and fc.currentfc = xm.servicenumber')
                    ->join('(SELECT MAX(id) AS id, orderId,currentfc FROM c_customerphoto GROUP BY orderId,currentfc) as photo','photo.orderId = fc.orderId and photo.currentfc = fc.currentfc')
                    ->join('c_customerphoto p','p.id = photo.id','left')
                    ->where('p.photostate <> 2')
                    ->field('count(fc.id) as num,sum(xm.yejiprice) as money')
                    ->find();
            $returnData['not_photo_num'] = $not_photo['num']?$not_photo['num']:0;
            $returnData['not_photo_money'] = $not_photo['money']?$not_photo['money']:0.00;
            $sql['待拍套系及总额'] = db()->getLastSql();
        }
        return json(['code'=>200,'data'=>$returnData,'sql'=>$sql]);
    }
}