<?php
/**
 * 报表实现类 成都 网销成交明细表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining 2020-06-28 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;
use app\common\lib\mcInterface;
class Cd_wx_order_info extends Report {

    private $level=1;
    private $type=1;
    private $code='code1593322620';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();

        $start = date('Y-m-d 00:00:00', strtotime($data['start']));
        $end = date('Y-m-d 23:59:59', strtotime($data['end']));

        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'请选择店面');
        }

        $whereStr = 'is_status = 1 and c_from = 1 and c.shop_code = "'.$shop_code.'" and (pay.paymentdate between "'.date('Ymd',strtotime($start)).'" and "'.date('Ymd',strtotime($end)).'") and erp_order.orderId is not null and erp_order.crm_order_type=1 and pay.suoshu in ("前期款","前期补款")';

        if($data['staff_id']){
            $staffIds = [$data['staff_id']];
        }else{
            if($data['group_id']){
                $mcParams['group_id'] =  $data['group_id'];
            }

            if($data['department_id']){
                $mcParams['department_id'] =  $data['department_id'];
            }

            if($data['shop_code']){
                $mcParams['shop_code'] =  $shop_code;
            }

            $mcParams['work_type'] = RECEIVE_WORK_TYPE;
            $staff = getShopStaffs($mcParams);
            $staffIds = array_column($staff,'id');
        }

        if(count($staffIds) > 0){
            $whereStr .= ' and c.sales_staff_id in ('.implode(',',$staffIds).')';
        }else{
            $whereStr .= ' and c.sales_staff_id in ("")';
        }

        $sql = 'select
        c.sales_staff,c.sales_group_name,c.customer_channel,c.customer_name,c.customer_tel,erp_order.orderId,c.consultation_type,erp_order.targetdate,erp_order.storeconsuitant1,erp_order.storeconsuitant2,erp_order.package_name,erp_order.total_money,erp_order.nopayment_money,erp_order.shop_order_name,pay.paymentdate,pay.payment_money,pay.paytype,pay.shop_name as soukuan_shop_name,pay.suoshu,pay.currentfc,pay.remarks,IF(erp_order.shop_order_name <> pay.shop_name,pay.payment_money,0) as ds_money
        from crm_c_customerinfo c
        join c_customerorder erp_order on c.id = erp_order.crm_customer_id
        join c_customerphoto photo on photo.orderId = erp_order.orderId and photo.currentfc = 1
        join c_paymentcontent pay on pay.orderId = photo.orderId and pay.currentfc = 1
        where '.$whereStr.
        ' order by pay.paymentdate,sales_staff';

        $list = db()->query($sql);

        $sum = [];
        foreach($list as $k => $v){
            $list[$k]['pay_day'] = date('Y-m-d',strtotime($v['paymentdate']));
            $sum['total_money'] += $v['total_money'];
            $sum['payment_money'] += $v['payment_money'];
            $sum['ds_money'] += $v['ds_money'];
        }

        $sum['pay_day'] = '合计：';
        $sum['customer_channel'] = '';
        $sum['total_money'] = $sum['total_money'] ? $sum['total_money'] : '0.00';
        $sum['payment_money'] = $sum['payment_money'] ? $sum['payment_money'] : '0.00';
        $sum['ds_money'] = $sum['ds_money'] ? $sum['ds_money'] : '0.00';

        array_push($list,$sum);

        $return['code'] = 0;
        $return['msg'] = '';
        $return['count'] = count($list);
        $return['data'] = $list;
        $return['sql1'] = $sql;

        return json($return);

    }

    public function show(){
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $brandclass_id = session('brandclass_id');
        $brandclass = session('brandclass');
        $shop_code = session('shop_code');
        $department_id = session('department_id');
        $group_id = session('group_id');

        //店
        $mcInterface = new mcInterface();
        $shop = $mcInterface->getWorkShop(['staff_id'=>session('staff_id'),'brandclass_id'=>session('brandclass_id')]);
        $this->assign("shop", $shop);
        $this->assign("shop_code", $info['shop_code']?$info['shop_code']:$shop_code);

        //部门
        $department = $mcInterface->getDepartments(['shop_code'=>$shop_code]);
        $this->assign("department", $department);

        //组
        $group = $mcInterface->getGroupInfoByDid(['department_id'=>$department_id]);
        $this->assign("group", $group);

        //组下人
        $staff = getShopStaffs(['shop_code'=>$shop_code,'group_id'=>$group_id,'work_type'=>RECEIVE_WORK_TYPE]);
        $this->assign("staff", $staff);

        //表格隐藏列
        $this->assign('hiddenColumns',explode('|',cookie('report_cd_wx_orderinfo_columns_hidden')));


        $code = $this->getCode();
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $this->assign('title', $title);

        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}