<?php
/**
 * 报表实现类 客资订单统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Customer_order extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568082674';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));


        $method = $data['method'];
        $where['c_from'] = 1;
        $where['is_status'] = 1;

        if($method == 'sales'){
            $where['c.shop_code'] = $shop_code;
            if($data['staff_id']){
                $where['sales_staff_id'] = intval($data['staff_id']);
                $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>intval($data['staff_id'])]);
            }else{
                //店下人员
                $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
                $staffIds = array_column($staff,'id');
                $where['sales_staff_id'] = ['in',$staffIds];
            }
            $group = 'c.sales_staff_id';
            $oGroup= 'o.storeconsuitant2';
        }else{
            $where['c.add_shop_code'] = $shop_code;
            if($data['staff_id']){
                $where['dj_staff_id'] = intval($data['staff_id']);
                $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>intval($data['staff_id'])]);
            }else{
                //店下人员
                $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$shop_code]);
                $staffIds = array_column($staff,'id');
                $where['dj_staff_id'] = ['in',$staffIds];
            }
            $group = 'c.dj_staff_id';
            $oGroup= 'c.dj_staff_id';
        }

        // $staffs = array_column($staff,'id,staffname','id');
        // $shopinfo = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);

        $sql = "sum(dj_day between '".$start."' and '".$end."') as mkz,";//总录入
        $sql .= "sum(is_valid=1 and dj_day between '".$start."' and '".$end."') as valid,";//有效
        $sql .= "sum(is_valid=3 and dj_day between '".$start."' and '".$end."') as wx,";//无效
        $sql .= "sum(is_valid in ('2,','4','5') and dj_day between '".$start."' and '".$end."') as dd";//待定

        $info= db('crm_c_customerinfo')->alias('c')
            ->where($where)
            ->group($group)
            ->column($sql,$group);

        $order = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')
            ->where('o.targetdate','between',[$start_erp,$end_erp])
            ->group($oGroup)
            ->column('count(o.id)',$oGroup);
        $yixiao = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.suoshu','in',['前期款','前期补款'])
            ->group($oGroup)
            ->column('sum(p.payment_money)',$oGroup);
        $erxiao = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.suoshu','in',['后期款','后期补款'])
            ->group($oGroup)
            ->column('sum(p.payment_money)',$oGroup);

        $return = [];
        $total['name'] = '总计';
        foreach($staff as $k=>$v){
            $arr = [];
            $arr['name'] = $v['staffname'];
            $arr['mkz'] = $info[$v['id']]['mkz'] ? $info[$v['id']]['mkz'] : 0;
            $arr['valid'] = $info[$v['id']]['valid'] ? $info[$v['id']]['valid'] : 0;
            $arr['wx'] = $info[$v['id']]['wx'] ? $info[$v['id']]['wx'] : 0;
            $arr['dd'] = $info[$v['id']]['dd'] ? $info[$v['id']]['dd'] : 0;
            $arr['order'] = $order[$v['id']] ? $order[$v['id']] : 0;
            $arr['yixiao'] = $yixiao[$v['id']] ? $yixiao[$v['id']] : 0;
            $arr['erxiao'] = $erxiao[$v['id']] ? $erxiao[$v['id']] : 0;
            array_push($return,$arr);

            $total['mkz'] += $info[$v['id']]['mkz'];
            $total['valid'] += $info[$v['id']]['valid'];
            $total['wx'] += $info[$v['id']]['wx'];
            $total['dd'] += $info[$v['id']]['dd'];
            $total['order'] += $order[$v['id']];
            $total['yixiao'] += $yixiao[$v['id']];
            $total['erxiao'] += $erxiao[$v['id']];
        }
        $total['yixiao'] = sprintf('%.2f', $total['yixiao']);
        $total['erxiao'] = sprintf('%.2f', $total['erxiao']);
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$info['shop_code']]);
        $this->assign('shop_code', $info['shop_code']);
        $this->assign('staff', $staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}