<?php
/**
 * 会员接口入口
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wzy<wangzhenya@suxuantech.cn> 2018-1-3 $
 */
namespace app\index\api;

use think\Exception;
class Vip{
    /*
        * 聚焦提报接口
        *  customer_name
        *  customer_tel
        *  consulation_shop_code 意向店面编码
        *  consulation_shop
        *  open_id
        *  hd_name  活动名称
        * return  错误码   核销代码
        * */
    public function addCustomer($param){
        $staff_id = trim($param['staff_id']);
        if(empty($staff_id)){
            return array('error'=>1,'code'=>101,'msg'=>'未获取到提报人id');
        }

        $data = [];
        $data['customer_name'] = trim($param['customer_name']);
        if(empty($data['customer_name'])){
            return array('error'=>1,'code'=>103,'msg'=>'客户姓名不能为空');
        }
        $data['customer_tel'] = trim($param['customer_tel']);
        if(empty($data['customer_tel'])){
            return array('error'=>1,'code'=>103,'msg'=>'客户手机不能为空');
        }

        $data['consulation_shop_code'] = $param['consulation_shop_code'] ? trim($param['consulation_shop_code']) : '';
        $data['consulation_shop'] = $param['consulation_shop'] ? trim($param['consulation_shop']) : '';
        $data['customer_cource_id'] = $param['customer_cource_id'] ? intval($param['customer_cource_id']): 0;
        $data['customer_cource'] = $param['customer_cource'] ? trim($param['customer_cource']): '';
        $data['customer_type'] = 1;
        $data['dj_staff_id'] = $staff_id ? $staff_id : '';
        if(!$data['dj_staff_id']){
            return array('error'=>1,'code'=>101,'msg'=>'未获取到提报人id');
        }
        if($staff_id == -1){
            $data['dj_staff'] = $param['staff_name'] ? $param['staff_name'] : '';
            if(!$param['staff_name']){
                return array('error'=>1,'code'=>98,'msg'=>'未获取到第三方名称');
            }
            $data['sales_staff_id'] = $param['default_staff_id'];
            $data['dj_staff'] = $param['staff_name'] ? $param['staff_name'] : '';
            $staffinfo =  getStaffInfoById($data['sales_staff_id']);
            $data['add_shop_code'] = $staffinfo['shop_code'] ? $staffinfo['shop_code'] : '';
            $data['add_shop_name'] = $staffinfo['shop_name'] ? $staffinfo['shop_name'] : '';
            $data['shop_code'] = $param['shop_code'] ? $param['shop_code'] : ($staffinfo['belong_shop_code'] ? $staffinfo['belong_shop_code'] : $staffinfo['shop_code']);
            $data['shop_name'] =  $param['shop_name'] ? $param['shop_name'] : ($staffinfo['belong_shop_name'] ? $staffinfo['belong_shop_name'] : $staffinfo['shop_name']);
            $data['brandclass_id'] = $staffinfo['brandclass_id'];
            $data['brandclass'] = $staffinfo['brandclass'];
        }else{
            $staffinfo =  getStaffInfoById($staff_id);
            $channel_id = db('crm_s_channel')->where('channel_name','微信')->where('shop_code',$staffinfo['shop_code'])->value('id');
            if($channel_id){
                $data['customer_channel_id'] = $channel_id;
                $data['customer_channel'] = '微信';
            }
            $data['dj_staff'] = $param['staff_name'] ? $param['staff_name'] : $staffinfo['staffname'];
            $data['dj_staff_number'] = $staffinfo['staffnumber'];
            $data['dj_department_id'] = $staffinfo['department_id'];


            $workTypes = RECEIVE_WORK_TYPE;
            if ($staffinfo['work_type']) {
                $type = explode(',', $staffinfo['work_type']);
                array_push($type, $staffinfo['main_work_type']);
            }else{
                $type = $staffinfo['main_work_type'];
            }
            if (is_array($type)) {
                $is_in = in_array($workTypes, $type);
            }else{
                if ($workTypes == $type) {
                    $is_in = true;
                }else{
                    $is_in = false;
                }
            }
            if($is_in){
                $data['sales_staff_id'] = $staffinfo['staff_id'] ? $staffinfo['staff_id'] : $staffinfo['id'];
            }else{
                $data['sales_staff_id'] = $param['default_staff_id'];
            }

            $data['add_shop_code'] = $staffinfo['shop_code'] ? $staffinfo['shop_code'] : '';
            $data['add_shop_name'] = $staffinfo['shop_name'] ? $staffinfo['shop_name'] : '';
            $data['shop_code'] = $param['shop_code'] ? $param['shop_code'] : ($staffinfo['belong_shop_code'] ? $staffinfo['belong_shop_code'] : $staffinfo['shop_code']);
            $data['shop_name'] =  $param['shop_name'] ? $param['shop_name'] : ($staffinfo['belong_shop_name'] ? $staffinfo['belong_shop_name'] : $staffinfo['shop_name']);
            $data['brandclass_id'] = $staffinfo['brandclass_id'];
            $data['brandclass'] = $staffinfo['brandclass'];
        }
        $data['baby_birthday'] = trim($param['baby_birthday']);//宝宝生日
        $data['channel_plan_number'] = trim($param['hd_name']);//活动名称
        $data['introducer_name'] = trim($param['introducer_name']);//推荐人
        $data['introducer_tel'] = trim($param['introducer_tel']);//推荐人
        $return  = controller('crm/Customer','lib')->addCustomer_child($data);

        if($return['code'] == 200){
            //生成核销码
            $code = date('is').generate_code(4);
            db()->startTrans();
            try{
                db('crm_c_customer_from')->where('cid',intval($return['cutomer_id']))->update(['code'=>$code,'hd_name'=>$param['hd_name']]);
                db()->commit();
                return array('hx_code'=>$code,'message'=>getAppHost().'/crm/index/jdEwmShow/code/'.$code);
            }catch (\Exception $e){
                db()->rollback();
                return array('error'=>1,'code'=>105,'msg'=>'核销码插入失败','data'=>$e->getMessage(),'crm_data'=>json_encode($return));
            }
        }else{
            return array('error'=>1,'code'=>102,'msg'=>$return['msg'],'data'=>$return);
        }
    }

    /**
     * 会员根据事业部查询客资
     * 
     * @param  brandclass_id    事业部id
     * @param  search_time      查询时间
     * @param  start            开始时间
     * @param  end              结束时间
     *
     * @return array
     * @author lilong<lilong@suxuantech.cn>
     */
    public function getCustomerList($param){

        if (!(int)$param['brandclass_id']) {
            return array('error'=>1,'code'=>100,'msg'=>'事业部id错误'.$param['brandclass']);
        }

        $where['brandclass_id'] = (int)$param['brandclass_id'];
        $where['is_status'] = 1;
        $where['c_from'] = 1;

        $search_time = $param['search_time'] ? trim($param['search_time']) : 'dj_day';
        $start = $param['start'] ? date('Y-m-d 00:00:00',strtotime($param['start'])) : date('Y-m-01 00:00:00');
        $end   = $param['end'] ? date('Y-m-d 23:59:59',strtotime($param['end'])) : date('Y-m-d 23:59:59',strtotime("$start +1 month -1 day"));
        
        $field = 'id,customer_channel,consultation_type,is_valid,is_intostore,is_success,customer_name,customer_sex,customer_tel,customer_wechat,customer_weibo,customer_qq,consulation_shop,customer_type,dj_day,is_fp,dj_staff,sales_staff,last_trackday,brandclass,shop_name,add_shop_name';

        $customerList = db('crm_c_customerinfo')
            ->where($where)
            ->where($search_time,'between',[$start,$end])
            ->field($field)
            ->select();
        return $customerList;
    }
}