<?php
/**
 * 大屏控制器  天使印象定制
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: lilong<lilong@suxuantech.cn> $
 */
namespace app\crm\controller;
use think\Controller;
// use app\index\controller\Base;
use think\Queue;
use think\Request;

class Tsyx extends Controller{

	// 今天
	protected  $today = [
		'start'=>'', 'end'  =>'',
	];
	// 本月一号和当天
	protected  $thisMonth = [
		'start'=>'', 'end'  =>'',
	];
	// 本月每一天
	protected  $thisMonthAllDay = [];
	// 本月每一天
	protected  $shop_code_wangxiao = "[]";
	//网销店 shop_code
	protected  $shop_code_wx = 'TSYX13';
	//爱婴中心 shop_code 
	protected  $shop_code_ay = 'TSYX12';
	//市场部 shop_code 
	protected  $shop_code_sc = 'TSYX14';

	protected  $department_id_wx = 1;
	// 初始化
	public function _initialize(){
		// 今天
		$this->today['start']=  date('Y-m-d 00:00:00');
		$this->today['end']  =  date('Y-m-d 23:59:59');
		// 昨天
		$this->yestoday['start']= date('Y-m-d 00:00:00',strtotime('-1 day'));
		$this->yestoday['end']  = date('Y-m-d 23:59:59',strtotime('-1 day'));
		// 本月
		$this->thisMonth['start']= date('Y-m-01 00:00:00');
		$this->thisMonth['end']  = date('Y-m-d 23:59:59');
		// 上一个月
		$this->thisMonths['start']= date('Y-m-01 00:00:00', strtotime("-1 month"));
		$this->thisMonths['end']  = date('Y-m-d 23:59:59', strtotime("-1 month"));
		// 年
		$this->thisYear['start']= date('Y-01-01 00:00:00');
		$this->thisYear['end']  = date('Y-12-t 23:59:59');
		// 本月每一天
		$date = getdateArea('this_month');
		$timezone = getDateFromRange($date[0], $date[1]);
		$this->thisMonthAllDay = $timezone;
	}
	// PC大屏首页
	public function index(){
		// 验证权限
		$auth = controller('crm/Bigscreen', 'lib')->checkBigScreenAuth();
		if ($auth === false) {
			controller('crm/Index','controller')->index();
			exit;
		}

        //是否展示oa大屏
        $is_oa = config('db_oa') ? 1 : 2;

		// 页面上的时间
		$thisMonth = $this->thisMonth;
		$start= date( 'Y-m-d',strtotime($thisMonth['start']) );
		$end  = date( 'Y-m-d',strtotime($thisMonth['end']) );
		$this->assign('start',$start);
		$this->assign('end',$end);
		$this->assign('today',date('Y-m-d'));

		$this->assign('is_oa',$is_oa);
		return $this->fetch();
	}
	//------------------------ 第一部分 日销售大盘 开始 ------------------------//
		//------------------------ 最左侧三块开始 ------------------------//
		// 月营收与满意度
		public function getMonthYingshou(){
			$input = input('post.');
			$thisMonth = $this->thisMonth;
			$start= $input['start'] ?: date( 'Y-m-d',strtotime($thisMonth['start']) );
			$end  = $input['end'] ?: date( 'Y-m-d',strtotime($thisMonth['end']) );
			$param['start']= $start;
			$param['end']  = $end;
			$monthYingshou = controller('crm/Tsyx','lib')->getYingshou($param);
			$temp = [];
			foreach ($monthYingshou as $key => $value) {
				$temp[$value['targetdate']] += $value['total_money'];
			}
			
			$dayYingshou = [];
			// 循环本月每一天
			$thisMonthAllDay = $this->thisMonthAllDay;
			foreach ($thisMonthAllDay as $key => $value) {
				$dayYingshou[$key] = $temp[date('Ymd',strtotime($value))] ? $temp[date('Ymd',strtotime($value))]/10000 : 0;
				$zone[$key] = date('d', strtotime($value));
			}
			$manyidu = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
			$returnData['timezone'] = $zone;
			$returnData['name'] = ['月营收','满意度'];
			$returnData['data'] = ['ys'=>$dayYingshou,'myd'=>$manyidu];
			return json($returnData);
		}
		// 订单来源分析
		// 网销：所有网销中心的网付订单（对应已成交） 
		// 爱婴：所有爱婴中心的网付订单（对应已成交） 
		// 体验：所有有市场部的网付订单（对应已成交） 
		// 转介绍：所有订单渠道名称包含“转介绍”字样的订单。 
		// 续订：收款日期范围内收的“后期单次续订”和“后期成长续订”的订单。 
		// 回客：所有订单渠道名称包含“回客”字样的订单。
		public function analyseOrderFrom(){
			$arr = ["网销","爱婴","体验","转介绍","续订","回客"];
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];

			$order = controller('crm/Tsyx','lib')->getWangfuDingdan($param);
			$zong = count($order);
			$wx = $ay = $ty = $zjs = $xd = $hk = 0;
			foreach ($order as $key => $value) {
				if ($value['shop_code'] == $this->shop_code_wx) {
					$wx += 1;
				}
				if ($value['shop_code'] == $this->shop_code_ay) {
					$ay += 1;
				}
				if ($value['shop_code'] == $this->shop_code_sc) {
					$ty += 1;
				}
				if ($value['channel_info_name'] == "转介绍") {
					$zjs += 1;
				}
				if ($value['fundname'] == "后期单次续订" || $value['fundname'] == "后期成长续订") {
					$xd += 1;
				}
				// if ($value['channel_info_name'] == "回客") {
				if ( strstr($value['channel_info_name'], '回') ) {
					$hk += 1;
				}
			}

			$wx_bl = (sprintf("%.4f",$wx/$zong)*100)."%";
			$ay_bl = (sprintf("%.4f",$ay/$zong)*100)."%";
			$ty_bl = (sprintf("%.4f",$ty/$zong)*100)."%";
			$zjs_bl = (sprintf("%.4f",$zjs/$zong)*100)."%";
			$xd_bl = (sprintf("%.4f",$xd/$zong)*100)."%";
			$hk_bl = (sprintf("%.4f",$hk/$zong)*100)."%";

			$returnData['data']['data'] = [['value'=>$wx, 'name'=>$arr[0]."：".$wx_bl],['value'=>$ay, 'name'=>$arr[1]."：".$ay_bl],['value'=>$ty, 'name'=>$arr[2]."：".$ty_bl],['value'=>$zjs, 'name'=>$arr[3]."：".$zjs_bl],['value'=>$xd, 'name'=>$arr[4]."：".$xd_bl],['value'=>$hk, 'name'=>$arr[5]."：".$hk_bl]];
			$returnData['data']['name'] = [$arr[0]."：".$wx_bl,$arr[1]."：".$ay_bl,$arr[2]."：".$ty_bl,$arr[3]."：".$zjs_bl,$arr[4]."：".$xd_bl,$arr[5]."：".$hk_bl];
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 价格区间分析
		public function analysePriceArea(){
			$jiage = [
				['0','1000','1000以下'],
				['1000','2000','1K-2K'],
				['2000','4000','2K-4K'],
				['4000','7000','4K-7K'],
				['7000','10000','7K-1W'],
				['10000','20000','1W-2W'],
				// ['20000','100000','2W-10W']
			];
			// $jiage = [['0','10000','1w以下'],['10000','20000','1W-2W'],['20000','40000','2W-4W'],['40000','60000','4W-6W'],['60000','80000','6W-8W'],['80000','100000','8W-10W']];

			// bargain_money
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];

			$jg = controller('crm/Tsyx','lib')->getJiaGe($param);
			$zong = count($jg);
			foreach ($jiage as $key => $value) {
				foreach ($jg as $k => $v) {
					if ($v >= $value[0] && $v < $value[1]) {
						$jiage[$key][3] += 1;
					}
				}
			}

			foreach ($jiage as $key => $value) {
				$returnData['name'][] = $value[2];
				$returnData['data'][$key]['value'] = $value[3] ?: 0;
				$returnData['data'][$key]['name'] = $value[2]."：".(sprintf("%.4f",$value[3]/$zong)*100)."%";

				$returnData['datas'][] = ['value'=>$returnData['data'][$key]['value'], 'name'=>$returnData['data'][$key]['name']];
			}

			$returnData['code'] = 200;
			return json($returnData);
		}
		//------------------------ 最左侧三块结束 ------------------------//
		//------------------------ 最顶上那部分开始 ------------------------//
		// 当日实收
		public function todayShishou(){
			$time['start'] = date('0000');
			$time['end'] = date('Hi');

			$today= $this->today;
			$param['start'] = $today['start'];
			$param['end']  = $today['end'];
			$param['time']  = $time;
			// 当日实收
			$shishou = controller('crm/Tsyx','lib')->getShishou($param);
			// 昨天
			$param_z['start'] = $this->yestoday['start'];
			$param_z['end'] = $this->yestoday['end'];
			$param_z['time']  = $time;
			$shishou_z = controller('crm/Tsyx','lib')->getShishou($param_z);
			// 取两天的差值
			$cha = $shishou - $shishou_z;
			// 如果差大于0，说明今天比昨天做，环比上升
			if ($cha>0) {
				$returnData['data']['hbs'] = "/bg/tsyx/img/aw_up.png";
			}else{
				$returnData['data']['hbs'] = "/bg/tsyx/img/aw_down.png";
			}
			// 取差的绝对值 除 昨天
			$returnData['data']['hb'] = (sprintf("%.4f",abs($cha) / $shishou_z)*100)."%($shishou_z)";

			//预约排控
			$paikongz = controller('crm/Tsyx','lib')->getYuyuePaikongZong($param);

			$paikongy = controller('crm/Tsyx','lib')->getYuyuePaikongYi($param);

			//排控率
			$returnData['data']['pkl'] = (sprintf("%.4f",$paikongy/$paikongz)*100)."%";

			$returnData['data']['paikongz'] = $paikongz;
			$returnData['data']['paikongy'] = $paikongy;
			$returnData['data']['paikongw'] = $paikongz - $paikongy;
			$returnData['data']['shishou'] = number_format($shishou, 2);
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 当月实收
		public function monthShishou(){
			$param['start'] = $this->thisMonth['start'];
			$param['end']  = $this->thisMonth['end'];

			// 当月实收
			$shishou = controller('crm/Tsyx','lib')->getShishou($param);
			// 上一个月
			$param_z['start'] = $this->thisMonths['start'];
			$param_z['end'] = $this->thisMonths['end'];
			$shishou_z = controller('crm/Tsyx','lib')->getShishou($param_z);
			// 取两天的差值
			$cha = $shishou - $shishou_z;
			// 如果差大于0，说明今天比昨天做，环比上升
			if ($cha>0) {
				$returnData['data']['hbs'] = "/bg/tsyx/img/aw_up.png";
			}else{
				$returnData['data']['hbs'] = "/bg/tsyx/img/aw_down.png";
			}
			// 取差的绝对值 除 昨天
			$returnData['data']['hb'] = (sprintf("%.4f",abs($cha) / $shishou_z)*100)."%($shishou_z)";

			//选片排控
			$paikongz = controller('crm/Tsyx','lib')->getXuanpianPaikongZong($param);

			$paikongy = controller('crm/Tsyx','lib')->getXuanpianPaikongYi($param);

			//排控率
			$returnData['data']['pkl'] = (sprintf("%.4f",$paikongy/$paikongz)*100)."%";

			$returnData['data']['paikongz'] = $paikongz;
			$returnData['data']['paikongy'] = $paikongy;
			$returnData['data']['paikongw'] = $paikongz - $paikongy;
			$returnData['data']['shishou'] = number_format($shishou, 2);
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 当前达成率
		public function dayReachRate(){
			//目标
			$param_m['goal_name'] = "总实收";
			$param_m['month'] = date("Y-m");
			$mubiao = controller('crm/Tsyx','lib')->getMubiao($param_m);
			// var_dump($mubiao);die;
			$param['start'] = $this->thisMonth['start'];
			$param['end']  = $this->thisMonth['end'];
			//达成
			$dacheng = controller('crm/Tsyx','lib')->getDingdanliang($param);
			// var_dump($dacheng);die;
			$returnData['data']['dcl'] = (sprintf("%.4f",$dacheng/$mubiao)*100)."%";
			$returnData['data']['dc'] = sprintf("%.2f",$dacheng/10000);
			$returnData['data']['wdc'] = $mubiao-$dacheng > 0 ? sprintf("%.2f",($mubiao - $dacheng)/10000) : 0;
			if ($mubiao) {
				$mubiao = $mubiao/10000;
			}
			$returnData['data']['mubiao'] = $mubiao.'W';
			// var_dump($mubiao);die;
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 年度达成率
		public function yearReachRate(){
			//目标
			$param_m['goal_name'] = "总实收";
			$param_m['year'] = date("Y");
			$mubiao = controller('crm/Tsyx','lib')->getMubiao($param_m);

			$param['start'] = $this->thisYear['start'];
			$param['end']  = $this->thisYear['end'];
			$dacheng = controller('crm/Tsyx','lib')->getDingdanliang($param);

			$returnData['data']['dcl'] = (sprintf("%.4f",$dacheng/$mubiao)*100)."%";

			$returnData['data']['dc'] = sprintf("%.2f",$dacheng/10000);
			$returnData['data']['wdc'] = $mubiao - $dacheng > 0 ? sprintf("%.2f",($mubiao - $dacheng)/10000) : 0;
			if ($mubiao) {
				$mubiao = $mubiao/10000;
			}
			$returnData['data']['mubiao'] = $mubiao.'W';
			// var_dump($mubiao);die;
			$returnData['code'] = 200;
			return json($returnData);
		}
		//------------------------ 最顶上那部分结束 ------------------------//
		//------------------------ 中间四块开始 ------------------------//
		// 实时订单 （每隔5秒刷新一下）
		public function realTimeOrder(){
			$data = controller('crm/Tsyx','lib')->getShishiDingdan($param);
			$returnData['data'] = $data;
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 门市业绩Top5
		public function menshiYeji(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];

			$month = date("Y-m");
			//业绩
			$yeji = controller('crm/Tsyx','lib')->getYeji($param);
			foreach ($yeji as $key => $value) {
				$yeji[$key]['mubiao'] = controller('crm/Tsyx','lib')->getMubiao(['month'=>$month,'shop_name'=>$value['shop_name']]);
				$yeji[$key]['gxd'] = (sprintf("%.4f",$value['pay']/$yeji[$key]['mubiao'])*100)."%";
			}

			$returnData['data'] = $yeji;
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 月营收与成本
		public function monthYingshouCost(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];

			$monthYingshou = controller('crm/Tsyx','lib')->getYingshou($param);
			$temp = [];
			foreach ($monthYingshou as $key => $value) {
				$temp[$value['targetdate']] += $value['total_money'];
			}
			
			$dayYingshou = [];
			// 循环本月每一天
			$thisMonthAllDay = $this->thisMonthAllDay;
			foreach ($thisMonthAllDay as $key => $value) {
				$dayYingshou[$key] = $temp[date('Ymd',strtotime($value))] ? $temp[date('Ymd',strtotime($value))]/10000 : 0;
				$zone[$key] = date('d', strtotime($value));
			}
			$manyidu = [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0];
			$returnData['timezone'] = $zone;
			$returnData['name'] = ['月营收','成本'];
			$returnData['data'] = ['ys'=>$dayYingshou,'cb'=>$manyidu];
			return json($returnData);
		}
		// 实收业绩与达成率
		public function shishouYejiRate(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];
			// $param['shop_code']  = $this->shop_code_wx;

			// 调mc接口查事业部下所有的店
			$mc = new \app\common\lib\mcInterface();
			$shop = $mc->getBrandShops("天使印象事业部");
			unset($mc);
			$shop_arr =  [];
			foreach ($shop as $key => $value) {
				$shop_arr[$value['shop_code']]['name'] = $value['shop_name'] == "莉帝希雅" ? "旅拍" : $value['shop_name'];
			}
			   //莉帝希雅 换成 旅拍
			//目标
			$param_m['goal_name'] = "一销实收";
			$param_m['month'] = date("Y-m");
			$mubiao = controller('crm/Tsyx','lib')->getMubiaoList($param_m);

			foreach ($mubiao as $key => $value) {
				$shop_arr[$value['shop_code']]['mb'] = $value['goal_value'];
			}

			//成交客资量
			$cjkezi = controller('crm/Tsyx','lib')->getChengjiaoKeZiLiang($param);
			foreach ($cjkezi as $key => $value) {
				//当前业绩
				$shop_arr[$value['shop_code']]['yj'] += $value['yixiaoshishou'];
			}
			if (count($shop_arr) > 0) {
				foreach ($shop_arr as $key => $value) {
					if ($value['name']) {
						$returnData['data']['name'][] = $value['name'];
						$returnData['data']['yj'][] = $value['yj'] ? $value['yj']/10000 : 0;
						$returnData['data']['dcl'][] = $value['mb'] ? sprintf("%.4f",$value['yj']/$value['mb'])*100 : 0;
					}else{
						unset($shop_arr[$key]);
					}
				}
			}else{
				$returnData['data']['name'][] = '';
				$returnData['data']['yj'][] = '';
				$returnData['data']['dcl'][] = '';
			}

			$returnData['data']['mb'] = $mubiao;
			$returnData['code'] = 200;
			return json($returnData);
		}
		//------------------------ 中间四块结束 ------------------------//
	//------------------------ 第一部分 日销售大盘 结束 ------------------------//

	//------------------------ 第二部分 运转数据大盘 开始 ------------------------//

		public function getYunzhuanData(){
			$params = input('');
			$shop_name = $params["shop_name"];
	        $day = $params["day"];
	        if($shop_name == '爱婴中心'){
	            $data[0]['target'] = '医院拍摄';
	            $data[1]['target'] = 'DCC邀约量';
	            $data[2]['target'] = '上门率';
	            $data[3]['target'] = '拍摄率';
	            $data[4]['target'] = '成交率';
	            $data[5]['target'] = '均值';
	            $data[6]['target'] = '业绩';
	        }elseif($shop_name == '门店中心'){
	            $data[0]['target'] = '选片率';
	            $data[1]['target'] = '成交率';
	            $data[2]['target'] = '套系续订律';
	            $data[3]['target'] = '体验转单率';
	            $data[4]['target'] = '均值';
	            // $data[5]['target'] = '服务建议率';
	            $data[5]['target'] = '业绩';
	        }elseif($shop_name == '研发中心'){
	            $data[0]['target'] = '拍摄完成率';
	            $data[1]['target'] = '后期建议率';
	            $data[2]['target'] = '拍摄建议率';
	            $data[3]['target'] = '引导建议率';
	            $data[4]['target'] = '服务建议率';
	            $data[5]['target'] = '化妆建议率';
	            $data[6]['target'] = '拍摄服务建议率';
	            $data[7]['target'] = '摄影部样片';
	            $data[8]['target'] = '微电影样片';
	            $data[9]['target'] = '月获奖人次';
	            $data[10]['target'] = '获取天数';
	            $data[11]['target'] = '产品内返率';
	            $data[12]['target'] = '产品外返率';
	        }elseif($shop_name == '客服中心'){
	            $data[0]['target'] = '开放量';
	            $data[1]['target'] = '预约量';
	            $data[2]['target'] = '到店量';
	            $data[3]['target'] = '到店率';
	            $data[4]['target'] = '日运转率';
	            $data[5]['target'] = '当天';
	            $data[6]['target'] = '7天';
	            $data[7]['target'] = '15天';
	            $data[8]['target'] = '30天';
	            $data[9]['target'] = '60天';
	        }elseif($shop_name == '网销中心'){
	            $data[0]['target'] = '客资';
	            $data[1]['target'] = '客资单价';
	            $data[2]['target'] = '有效率';
	            $data[3]['target'] = '成交率';
	            $data[4]['target'] = 'ROI';
	            $data[5]['target'] = '业绩';
	        }elseif($shop_name == '微电影'){
	            $data[0]['target'] = '拍摄量';
	            $data[1]['target'] = '选片量';
	            $data[2]['target'] = '出单率';
	            $data[3]['target'] = '均值';
	            $data[4]['target'] = '业绩';
	        }elseif($shop_name == '服务督察组'){
	            $data[0]['target'] = '拨打量';
	            $data[1]['target'] = '有效率';
	            $data[2]['target'] = '服务满意度';
	            $data[3]['target'] = '差评解决率';
	            $data[4]['target'] = '服务建议率';
	        }elseif($shop_name == '人事部'){
	            $data[0]['target'] = '总编制';
	            $data[1]['target'] = '储备编制';
	            $data[2]['target'] = '人效';
	            $data[3]['target'] = '重要岗位招聘进度';
	            $data[4]['target'] = '普通岗位招聘进度';
	            $data[5]['target'] = '面试量';
	            $data[6]['target'] = '通过量';
	            $data[7]['target'] = '试岗量';
	            $data[8]['target'] = '7日试岗流失率';
	            $data[9]['target'] = '15日试岗流失率';
	            $data[10]['target'] = '自离率';
	            $data[11]['target'] = '门店试岗流失率';
	            $data[12]['target'] = '本月增减人数';
	            $data[13]['target'] = '离职率最高部门';
	        }elseif($shop_name == '莉帝希雅'){
	            $data[0]['target'] = '拍摄量';
	            $data[1]['target'] = '门店订单量';
	            $data[2]['target'] = '剩余拍摄量';
	            $data[3]['target'] = '均值';
	            $data[4]['target'] = '网销客资';
	            $data[5]['target'] = '网销业绩';
	            $data[6]['target'] = '部门业绩';
	        }elseif($shop_name == '市场部'){
	            $data[0]['target'] = '客资数据';
	            $data[1]['target'] = '体验到店率';
	            $data[2]['target'] = '均值';
	            $data[3]['target'] = '投放费用';
	            $data[4]['target'] = '业绩';
	        }elseif($shop_name == '回客组'){
	            $data[0]['target'] = '总客资量';
	            $data[1]['target'] = '有效率';
	            $data[2]['target'] = '成交单量';
	            $data[3]['target'] = '均值';
	            $data[4]['target'] = '业绩';
	        }
	        $start = date('Y-m-d 00:00:00',strtotime($day));
	        $end = date('Y-m-d 23:59:59',strtotime($day));
	        $j = date("t",$day);	//当前月的总天数
	        $bggData = db('crm_s_bggoalset')->where('shop_name',$shop_name)->where('day',['between',[$start,$end]])->select();
	        foreach ($data as $key => $value) {
	            foreach ($bggData as $k2 => $v2) {
	                if($value['target'] == $v2['target']){
	                	//今日值
	                    if($v2['biaozhun'] && $v2['jinri']){
	                    	/*
	                    	if($v2['biaozhun']/$j > $v2['jinri']){
	                    		$v2['jinri_class'] = 'weidabiao';
	                    	}else{
	                    		$v2['jinri_class'] = 'dabiao';
	                    	}
	                    	*/
	                    }

						//达成率  这个达标的是绿色背景，达成率90%～100%的是黄色，低于90%是红色
	                    if($v2['biaozhun'] && $v2['dachenglv']){	
	                    	if(trim($v2['dachenglv'],'%') >= 100){
	                    		$v2['jinri_class'] = 'dabiao';
	                    		$v2['dachenglv_class'] = 'dabiao';
	                    	}else if (trim($v2['dachenglv'],'%')>=90 && trim($v2['dachenglv'],'%')<100) {
	                    		$v2['jinri_class'] = 'yujing';
	                    		$v2['dachenglv_class'] = 'yujing';
	                    	}else if (trim($v2['dachenglv'],'%')<90) {
	                    		$v2['jinri_class'] = 'weidabiao';
	                    		$v2['dachenglv_class'] = 'weidabiao';
	                    	}
	                    }
	                    // $arr = (int)$arr;
	                    if(is_numeric($v2['biaozhun'])){
	                    	$arr = $v2['biaozhun'];
	                    }else{
	                    	// preg_match('/\d+/',$v2['biaozhun'],$arr);
	                    	$arr = (int)$arr;
	                    }
	                    if($v2['biaozhun'] && !$v2['dachenglv'] && $v2['jinri']){
	                    	// $v2['dachenglv'] = sprintf('%.2f',$v2['jinri']/($v2['biaozhun']/$j));
	                    	$v2['dachenglv'] = sprintf('%.2f',(trim($v2['jinri'],'%')/$arr)*100);
	                    	if(trim($v2['dachenglv'],'%') >= 100){
	                    		$v2['jinri_class'] = 'dabiao';
	                    		$v2['dachenglv_class'] = 'dabiao';
	                    	}else if (trim($v2['dachenglv'],'%')>=90 && trim($v2['dachenglv'],'%')<100) {
	                    		$v2['jinri_class'] = 'yujing';
	                    		$v2['dachenglv_class'] = 'yujing';
	                    	}else if (trim($v2['dachenglv'],'%')<90) {
	                    		$v2['jinri_class'] = 'weidabiao';
	                    		$v2['dachenglv_class'] = 'weidabiao';
	                    	}
	                    	// $v2['dachenglv'] < 100 ? $v2['dachenglv_class'] = 'weidabiao' : $v2['dachenglv_class'] = 'dabiao';
	                    }

	                    //月汇总
	                    // if($v2['yuehui'] > $v2['biaozhun']){
	                    // 	$v2['yuehui_class'] = 'dabiao';
	                    // }else{
	                    // 	$v2['yuehui_class'] = 'weidabiao';
	                    // }
	                    //月达成率
	                    if($v2['biaozhun'] && $v2['yuedachenglv']){	
	                    	if(trim($v2['yuedachenglv_class'],'%') >= 100){
	                    		$v2['yuehui_class'] = 'dabiao';
	                    		$v2['yuedachenglv_class'] = 'dabiao';
	                    	}else if (trim($v2['yuedachenglv_class'],'%')>=90 && trim($v2['yuedachenglv_class'],'%')<100) {
	                    		$v2['yuehui_class'] = 'yujing';
	                    		$v2['yuedachenglv_class'] = 'yujing';
	                    	}else if (trim($v2['yuedachenglv_class'],'%')<90) {
	                    		$v2['yuehui_class'] = 'weidabiao';
	                    		$v2['yuedachenglv_class'] = 'weidabiao';
	                    	}
	                    }
	                    if($v2['biaozhun'] && !$v2['yuedachenglv'] && $v2['yuehui']){
	                    	// $v2['yuedachenglv'] = sprintf('%.2f',$v2['yuehui']/($v2['biaozhun']/$j));
	                    	$v2['yuedachenglv'] = sprintf('%.2f',(trim($v2['yuehui'],'%')/($arr*$j))*100);
	                    	if(trim($v2['yuedachenglv_class'],'%') >= 100){
	                    		$v2['yuehui_class'] = 'dabiao';
	                    		$v2['yuedachenglv_class'] = 'dabiao';
	                    	}else if (trim($v2['yuedachenglv_class'],'%')>=90 && trim($v2['yuedachenglv_class'],'%')<100) {
	                    		$v2['yuehui_class'] = 'yujing';
	                    		$v2['yuedachenglv_class'] = 'yujing';
	                    	}else if (trim($v2['yuedachenglv_class'],'%')<90) {
	                    		$v2['yuehui_class'] = 'weidabiao';
	                    		$v2['yuedachenglv_class'] = 'weidabiao';
	                    	}
	                    	// $v2['yuedachenglv'] < 100 ? $v2['yuedachenglv_class'] = 'weidabiao' : $v2['yuedachenglv_class'] = 'dabiao';
	                    }

	                    //环比
	                    if($v2['huanbi'] < 100){
	                    	$v2['huanbi_class'] = 'weidabiao';
	                    }else{
	                    	$v2['huanbi_class'] = 'dabiao';
	                    }

	                    //满足率
	                    if($v2['manzulv'] < 100){
	                    	$v2['manzulv_class'] = 'weidabiao';
	                    }else{
	                    	$v2['manzulv_class'] = 'dabiao';
	                    }
	                    $data[$key] = $v2;

	                }
	            }
	        }

	        if($shop_name == '研发中心'){
	        	$data[0]['target_child'] = $data[7]['target'];
	        	$data[0]['biaozhun_child'] = $data[7]['jinri']?$data[7]['jinri']:'';
	        	$data[1]['target_child'] = $data[8]['target'];
	        	$data[1]['biaozhun_child'] = $data[8]['jinri']?$data[8]['jinri']:'';
	        	$data[2]['target_child'] = $data[9]['target'];
	        	$data[2]['biaozhun_child'] = $data[9]['jinri']?$data[9]['jinri']:'';
	        	$data[3]['target_child'] = '';
	        	$data[3]['biaozhun_child'] = '';
	        	$data[4]['target_child'] = $data[10]['target'];
	        	$data[4]['biaozhun_child'] = $data[10]['jinri']?$data[10]['jinri']:'';
	        	$data[5]['target_child'] = $data[11]['target'];
	        	$data[5]['biaozhun_child'] = $data[11]['jinri']?$data[11]['jinri']:'';
	        	$data[6]['target_child'] = $data[12]['target'];
	        	$data[6]['biaozhun_child'] = $data[12]['jinri']?$data[12]['jinri']:'';

	        	unset($data[7]);
	        	unset($data[8]);
	        	unset($data[9]);
	        	unset($data[10]);
	        	unset($data[11]);
	        	unset($data[12]);
	        }

	        if($shop_name == '客服中心'){
	        	$data[0]['target_child'] = $data[5]['target'];
	        	$data[0]['manzulv_child'] = $data[5]['jinri']?$data[5]['jinri']:'';
	        	$data[1]['target_child'] = $data[6]['target'];
	        	$data[1]['manzulv_child'] = $data[6]['jinri']?$data[6]['jinri']:'';
	        	$data[2]['target_child'] = $data[7]['target'];
	        	$data[2]['manzulv_child'] = $data[7]['jinri']?$data[7]['jinri']:'';
	        	$data[3]['target_child'] = $data[8]['target'];
	        	$data[3]['manzulv_child'] = $data[8]['jinri']?$data[8]['jinri']:'';
	        	$data[4]['target_child'] = $data[9]['target'];
	        	$data[4]['manzulv_child'] = $data[9]['jinri']?$data[9]['jinri']:'';
				
				unset($data[5]);
				unset($data[6]);
				unset($data[7]);
				unset($data[8]);
				unset($data[9]);
	        }

	        if($shop_name == '人事部'){
	        	$data[0]['target_child'] = $data[8]['target'];
	        	$data[0]['manzulv_child'] = $data[8]['yuehui']?$data[8]['yuehui']:'';
	        	$data[1]['target_child'] = $data[9]['target'];
	        	$data[1]['manzulv_child'] = $data[9]['yuehui']?$data[9]['yuehui']:'';
	        	$data[2]['target_child'] = $data[10]['target'];
	        	$data[2]['manzulv_child'] = $data[10]['yuehui']?$data[10]['yuehui']:'';
	        	$data[3]['target_child'] = $data[11]['target'];
	        	$data[3]['manzulv_child'] = $data[11]['yuehui']?$data[11]['yuehui']:'';
	        	$data[4]['target_child'] = $data[12]['target'];
	        	$data[4]['manzulv_child'] = $data[12]['yuehui']?$data[12]['yuehui']:'';
	        	$data[5]['target_child'] = $data[13]['target'];
	        	$data[5]['manzulv_child'] = $data[13]['yuehui']?$data[13]['yuehui']:'';
	        	$data[6]['target_child'] = '';
	        	$data[6]['manzulv_child'] = '';
	        	$data[7]['target_child'] = '';
	        	$data[7]['manzulv_child'] = '';

	        	unset($data[8]);
	        	unset($data[9]);
	        	unset($data[10]);
	        	unset($data[11]);
	        	unset($data[12]);
	        	unset($data[13]);
	        }

	        $return['data']=$data;
	        $return['code']=0;
	        return $return;
		}

	//------------------------ 第二部分 运转数据大盘 结束 ------------------------//

	//------------------------ 第三部分 网销数据大盘 开始 ------------------------//
		//------------------------ 上 4个 开始 ------------------------//
		// 实时数据
		public function getRealtimeData(){
			$thisMonth = $this->thisMonth;
			$start = date('Ymd',strtotime($thisMonth['start']));
			$end = date('Ymd',strtotime($thisMonth['end']));
			$param['start'] = $thisMonth['start'];
			$param['end']  = $thisMonth['end'];
			$param['shop_code']  = $this->shop_code_wx;
			$param_o['start'] = $start;
			$param_o['end']  = $end;
			$param_o['shop_code']  = $this->shop_code_wx;
			$param_o['crm_order_type'] = 1;
			//新客资量
			$maokezi = controller('crm/Tsyx','lib')->getMaoKeZiLiang($param);
			//新客资量-月
			$returnData['data']['kzl_y'] = count($maokezi);
			$returnData['data']['kzl_r'] = 0;
			$returnData['data']['yxkz_y'] = 0;
			$returnData['data']['yxkz_r'] = 0;
			$returnData['data']['cjkz_y'] = 0;
			$returnData['data']['cjkz_r'] = 0;
			$returnData['data']['yj_y'] = 0;
			$returnData['data']['yj_r'] = 0;
			$returnData['data']['xz_r'] = 0;
			foreach ($maokezi as $key => $value) {
				//新客资量-日
				if ($value['dj_day'] >= $this->today['start'] && $value['dj_day'] <= $this->today['end'] ) {
					$returnData['data']['kzl_r'] += 1;
				}
				//有效客资量
				if ($value['is_valid']==1 || $value['is_valid']==5) {
					$returnData['data']['yxkz_y'] += 1;
					if ($value['dj_day'] >= $this->today['start'] && $value['dj_day'] <= $this->today['end'] ) {
						$returnData['data']['yxkz_r'] += 1;
					}
				}
			}
			//成交客资量
			$cjkezi = controller('crm/Tsyx','lib')->getChengjiaoKeZiLiang($param_o);
			// var_dump($start);die;
			foreach ($cjkezi as $key => $value) {
				//成交客资量
				if (strlen($value['orderId']) > 0) {
					$returnData['data']['cjkz_y'] += 1;
					if ($value['targetdate'] >= $this->today['start'] && $value['targetdate'] <= $this->today['end'] ) {
						$returnData['data']['cjkz_r'] += 1;
					}
				}
			}
			// 实收业绩
			$paramPay['end']   = $thisMonth['end'];
			$paramPay['start'] = $thisMonth['start'];
			$paramPay['shop_code'] = $this->shop_code_wx;
			$paramPay['suoshu'] = ['in',['前期款','前期补款']];
			$paramPay['crm_order_type'] = 1;
			// 月
			$returnData['data']['yj_y'] = controller('crm/Tsyx','lib')->getShishou($paramPay);
			// 日
			$paramPay['end']   = $this->today['start'];
			$paramPay['start'] = $this->today['end'];
			$returnData['data']['yj_r'] = controller('crm/Tsyx','lib')->getShishou($paramPay);

			//销售在线人
			$pram['work_type'] = 21;
			$pram['department_id'] = $this->department_id_wx;
			$pram['shop_code'] = $param['shop_code'];
			$pram['start'] = $start;
			$pram['end']  = $end;
			$returnData['data']['xz_y'] = controller('crm/Tsyx','lib')->getXiaoshouZaixianren($pram);

			$staffs = cache('staffs_type_list_21_'.$param['shop_code'].$pram['department_id']);
			if(empty($staffs)){
			   // $staffs = controller('Customer','lib')->get_staff_lists($pram);
			   $staffs = getShopStaffs($pram);
			   cache('staffs_type_list_21_'.$param['shop_code'].$pram['department_id'],$staffs);
			   }
			   foreach ($staffs as $key => $value) {
				// 查看员工是否在线
				$status = controller('Customer','lib')->getStaffOnlineStatus($value['id']);
				if ($status) {
					$returnData['data']['xz_r'] += 1;
				}
			}

			$returnData['code'] = 200;
			return json($returnData);
		}
		// 各组日转化率
		public function getGroupDayConversion($param=''){
			$today= $this->today;
			$param['start'] = $param['start'] ?: $today['start'];
			$param['end']  = $param['end'] ?: $today['end'];
			$param['shop_code']  = $this->shop_code_wx;

			// 调mc接口获取部门下的小组
			$mc = new \app\common\lib\mcInterface();
			$groups = $mc->getGroupInfo(array('shop_code' => $this->shop_code_wx));
			unset($mc);
			$group_arr = $group_arr1 = [];
			foreach ($groups as $key => $value) {
				$group_arr[$value['id']]['name'] = $value['group_name'];
			}

			//成交客资量
			$cjkezi = controller('crm/Tsyx','lib')->getChengjiaoKeZiLiang($param);
			foreach ($cjkezi as $key => $value) {
				if (strlen($value['orderId']) > 0) {
					$group_arr[$value['sales_group_id']]['order'] += 1;
				}
			}
			//客资量
			$maokezi = controller('crm/Tsyx','lib')->getMaoKeZiLiang($param);
			foreach ($maokezi as $key => $value) {
				$group_arr[$value['sales_group_id']]['mkz'] += 1;
			}
			foreach ($group_arr as $key => $value) {
				if (!$value['name']) {
					unset($group_arr[$key]);
				}else{
					$group_arr[$key]['zhl'] = $value['order'] ? (sprintf("%.4f",$value['order']/$value['mkz'])*100) : 0;
				}
			}
			$group_arrs = my_sort($group_arr,'zhl','SORT_ASC');
			
			if (count($group_arrs) > 0) {
				foreach ($group_arrs as $key => $value) {
					$returnData['data']['name'][] = $value['name'];
					$returnData['data']['data'][] = $value['zhl'];
				}
			}else{
				$returnData['data']['name'][] = '';
				$returnData['data']['data'][] = '';
			}
			$returnData['arr'] = $group_arr;
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 各组月转化率
		public function getGroupMonthConversion(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];

			return $this->getGroupDayConversion($param);
		}
		// 网销业绩日排名
		public function getPerformanceDayRanking($param=''){
			$today= $this->today;
			$param['start'] = $param['start'] ?: $today['start'];
			$param['end']  = $param['end'] ?: $today['end'];
			$param['shop_code']  = $this->shop_code_wx;

			$cjkezi = controller('crm/Tsyx','lib')->getChengjiaoKeZiLiang($param);
			$staff = $staff_name = $staff_names = [];
			foreach ($cjkezi as $key => $value) {
				//姓名
				$staff[$value['sales_staff']]['name'] = $value['sales_staff'];
				$staff_name[] = $value['sales_staff'];
				//当前业绩
				$staff[$value['sales_staff']]['yj'] += $value['yixiaoshishou'];

				//订单量
				if (strlen($value['orderId']) > 0) {
					$staff[$value['sales_staff']]['order'] += 1;
				}
			}
			//客资量
			$maokezi = controller('crm/Tsyx','lib')->getMaoKeZiLiang($param);
			foreach ($maokezi as $key => $value) {
				//姓名
				$staff[$value['sales_staff']]['name'] = $value['sales_staff'];
				$staff_name[] = $value['sales_staff'];

				$staff[$value['sales_staff']]['mkz'] += 1;
			}
			foreach ($staff as $key => $value) {
				$staff[$key]['zhl'] = $value['order'] ? (sprintf("%.4f",$value['order']/$value['mkz'])*100)."%" : "0%";
			}
			if(count($staff) < 8){
			
				$num = 8 - count($staff);
				$mc = new \app\common\lib\mcInterface();
				$departmentStaffs = $mc->getStaffInfo(array('shop_code' => $this->shop_code_wx));
				// $returnData['arr'] = $departmentStaffs;
				foreach ($departmentStaffs as $key => $value) {
					if (!in_array($value['staffname'], $staff_name)) {
						$staff_names[] = $value['staffname'];
					}
				}
				for ($i=0; $i < $num; $i++) { 
					$staff[]['name'] = $staff_names[$i];
				}
			}
			$staff = my_sort($staff,'yj','SORT_DESC');
			$j = 0;
			foreach ($staff as $key => $value) {
				$staffs[$j]['name'] = $value['name'];
				$staffs[$j]['yj'] = $value['yj'] ? "￥".$value['yj'] : '￥0';
				$staffs[$j]['order'] = $value['order'] ? : '0';
				$staffs[$j]['zhl'] = $value['zhl'] ? : "0%";
				$j++;
			}
			$returnData['data'] = $staffs;
			$returnData['code'] = 200;
			return json($returnData);
		}
		// 网销业绩月排名
		public function getPerformanceMonthRanking(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];

			return $this->getPerformanceDayRanking($param);
		}
		//------------------------  上 4个结束 ------------------------//
		//------------------------  下 2个开始 ------------------------//
		// 各组实收业绩/转化率/达成率
		public function getGroupRanking(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];
			$param['shop_code']  = $this->shop_code_wx;

			// 调mc接口获取部门下的小组
			$mc = new \app\common\lib\mcInterface();
			$groups = $mc->getGroupInfo(array('shop_code' => $this->shop_code_wx));
			unset($mc);
			$group_arr = $group_arr1 = [];
			foreach ($groups as $key => $value) {
				$group_arr[$value['id']]['name'] = $value['group_name'];
			}

			//成交客资量
			$cjkezi = controller('crm/Tsyx','lib')->getChengjiaoKeZiLiang($param);
			foreach ($cjkezi as $key => $value) {
				//当前业绩
				$group_arr[$value['sales_group_id']]['yj'] += $value['yixiaoshishou'];

				if (strlen($value['orderId']) > 0) {
					$group_arr[$value['sales_group_id']]['order'] += 1;
				}
			}
			//客资量
			$maokezi = controller('crm/Tsyx','lib')->getMaoKeZiLiang($param);
			foreach ($maokezi as $key => $value) {
				$group_arr[$value['sales_group_id']]['mkz'] += 1;
			}
			foreach ($group_arr as $key => $value) {
				if (!$value['name']) {
					unset($group_arr[$key]);
				}else{
					$group_arr[$key]['zhl'] = $value['order'] ? (sprintf("%.4f",$value['order']/$value['mkz'])*100) : 0;
				}
			}
			if (count($group_arr) > 0) {
				foreach ($group_arr as $key => $value) {

					$returnData['data']['name'][] = $value['name'];
					$returnData['data']['yj'][] = $value['yj'] ?: 0;
					$returnData['data']['zhl'][] = $value['zhl'];
				}
			}else{
				$returnData['data']['name'][] = '';
				$returnData['data']['yj'][] = '';
				$returnData['data']['zhl'][] = '';
			}

			$returnData['code'] = 200;
			return json($returnData);
		}
		// 当月客资渠道分布
		public function getMonthChannelDistribution(){
			$input = input('post.');
			$param['start'] = $input['start'] ?: $this->thisMonth['start'];
			$param['end']  = $input['end'] ?: $this->thisMonth['end'];
			$param['shop_code']  = $this->shop_code_wx;

			//来源渠道
			$channels = [];
			$channel = controller('crm/Tsyx','lib')->getTwoChannel($param);
			foreach ($channel as $key => $value) {
				$channels[$value]['name'] = $value;
			}
			$maokezi = controller('crm/Tsyx','lib')->getMaoKeZiLiang($param);
			$data = [];
			foreach ($maokezi as $key => $value) {
				$channels[$value['channel_info_name']]['name'] = $value['channel_info_name'];
				//毛客资
				$channels[$value['channel_info_name']]['mkz'] += 1;
				//有效客资
				if ($value['is_valid']==1) {
					$channels[$value['channel_info_name']]['yxkz'] += 1;
				}
			}

			foreach ($channels as $key => $value) {
				$returnData['data']['name'][] = $value['name'];
				$returnData['data']['mkz'][] = $value['mkz'] ?: 0;
				$returnData['data']['yxkz'][] = $value['yxkz'] ?: 0;
			}

			$returnData['channel'] = $channels;
			$returnData['code'] = 200;
			return json($returnData);
		}
		//------------------------  下 2个结束 ------------------------//
	//------------------------ 第三部分 网销数据大盘 结束 ------------------------//


    //------------------------ 第四部分 办公数据大盘 开始 ------------------------//
        //获取学历分布
        public function getOaEducationBackground(){

            $res = controller('Tsyx','lib')->getOaEducationBackground();

            $zong = $res['zong'];
            $xlData = $res['data'];

            $xl = [];
            $xl[0]['name'] = '初中及以下';
            $xl[0]['value'] = 0;
            foreach($xlData as $k => $v){

                if($k == '小学'||$k == '初中'){
                    $xl[0]['value'] = $xl[0]['value'] + $v;
                }else{

                    if($k && $k != ''){
                        $xl[] = [
                            'name' => $k.":".(sprintf("%.4f",$v/$zong)*100)."%",
                            'value'=> $v
                        ];
                    }
                }
            }

            $xl[0]['name'] .= ':'.(sprintf("%.4f",$xl[0]['value']/$zong)*100)."%";

            $wz = $zong - array_sum($xlData);
            $xl[] = [
                'name'  => '未知:'.(sprintf("%.4f",$wz/$zong)*100)."%",
                'value' => $wz
            ];

            return json(['code'=>200,'data'=>$xl]);

        }

        //获取性别分布
        public function getOaSex(){

            $res = controller('Tsyx','lib')->getOaSex();

            $zong = $res['zong'];
            $data = $res['data'];

            $list = [];
            foreach($data as $k => $v){

                $name = $k ? $k : '未知';

                $list[] = [
                    'name' => $name.":".(sprintf("%.4f",$v/$zong)*100)."%",
                    'value'=> $v
                ];
            }

            //print_r($list);die;

            return json(['code'=>200,'data'=>$list]);

        }

        //获取司龄分布
        public function getOaSiLing(){

            $res = controller('Tsyx','lib')->getOaSiLing();

            $zong = $res['zong'];//在职总数
            $data = $res['data'];//转正数据
            $syq = $res['syq'];//试用期

            $list = [];
            foreach($data as $k => $v){
                switch($v['name']){
                    case 0:
                        $name = '未知';
                        break;
                    case 1:
                        $name = '转正1年内';
                        break;
                    case 2:
                        $name = '转正1~3年';
                        break;
                    case 3:
                        $name = '转正3年以上';
                        break;
                }

                $list[] = [
                    'name' => $name.":".(sprintf("%.4f",$v['num']/$zong)*100)."%",
                    'value'=> $v['num']
                ];
            }


            $list[] = [
                'name'=>'试用'.":".(sprintf("%.4f",$syq/$zong)*100)."%",
                'value'=>$syq];

            return json(['code'=>200,'data'=>$list]);

        }

        //获取年龄分布
        public function getOaAge(){
            $res = controller('Tsyx','lib')->getOaAge();

            $zong = $res['zong'];
            $data = $res['data'];

            $list = [];
            foreach($data as $k => $v){
                switch($v['name']){
                    case 1:
                        $name = '未知';
                        break;
                    case 2:
                        $name = '25以下';
                        break;
                    case 3:
                        $name = '25~30';
                        break;
                    case 4:
                        $name = '30~35';
                        break;
                    case 5:
                        $name = '35以上';
                        break;
                }

                $list[] = [
                    'name' => $name.":".(sprintf("%.4f",$v['num']/$zong)*100)."%",
                    'value'=> $v['num']
                ];
            }

            //print_r($list);die;

            return json(['code'=>200,'data'=>$list]);

        }


        //获取管理结构分布
        public function getOaManagementStructure(){

            $res = controller('Tsyx','lib')->getOaManagementStructure();

            $zong = $res['zong'];
            $data = $res['data'];

            $list = [];
            foreach($data as $k => $v){

                $name = $k ? $k : '未知';

                $list[] = [
                    'name' => $name.":".(sprintf("%.4f",$v/$zong)*100)."%",
                    'value'=> $v
                ];
            }

            //print_r($xl);die;

            return json(['code'=>200,'data'=>$list]);

        }

        //获取店面岗位编制人数 实际人数
        public function getOaPosition(){
            $sql = " (leave_date='' or leave_date is null or leave_date > '".date('Y-m-d')."') and working_status = 1 ";

            //编制人数
            $bz_data = db('oa_dept_department','db_oa')
                ->where('shop_name is not null and shop_name <> "0"')
                ->group('shop_name')
                ->column('sum(bianzhi_num)','shop_name');

            //实际人数
            $staff_data = db('oa_dept_staffinfo','db_oa')
                ->where('shop_name is not null and shop_name <> "0"')
                ->where($sql)
                ->group('shop_name')
                ->column('count(id)','shop_name');

            $shopList = db('oa_dept_shop','db_oa')->field('shop_code,shop_name')->select();
            $shop = array_column($shopList,'shop_name');
            $bz = [];
            $staff = [];
            foreach($shop as $v){
                $bz[] =  $bz_data[$v] ? $bz_data[$v] : 0;
                $staff[] =  $staff_data[$v] ? $staff_data[$v] : 0;
            }

            return json(['code'=>200,'data'=>['title'=>$shop,'bz'=>$bz,'staff'=>$staff]]);

        }

        public function timeToString($second){
            $day = floor($second/(3600*24));
            $second = $second%(3600*24);//除去整天之后剩余的时间
            $hour = floor($second/3600);
            $second = $second%3600;//除去整小时之后剩余的时间
            $minute = floor($second/60);
            $second = $second%60;//除去整分钟之后剩余的时间
            //返回字符串
            $str = '';
            if($day)  $str .= $day.'天';
            if($hour)  $str .= $hour.'小时';
            if($minute)  $str .= $minute.'分';
            //if($second)  $str .= $second.'秒';

            return $str;
        }

        //考勤
        public function getClockLog(){

            $start_date = input('start') ? input('start') : date('Y-m-d');
            $end_date = input('end') ? input('end') : date('Y-m-d');

            $clock = db('oa_clock_log_res','db_oa')->where('day','between',[$start_date,$end_date])->select();

            $shidao = 0;
            $xiujia = 0;
            $chuchai = 0;
            $waiqin = 0;
            $queqin = 0;

            $time = 0;//总时长
            $num = 0;//有工作时长的人数量

            foreach($clock as $k => $v){

                $timeArr = [];

                $log = json_decode($v['res'],true);

                $in_out = 1;//正常打卡，2外勤
                foreach($log as $key => $val){
                    if($val['in_out'] == 2){
                        $in_out = 2;
                    }
                    if($val['h_i_s'] && $val['h_i_s'] !=0){
                        $timeArr[] = $val['h_i_s'];
                    }
                }

                if($v['status'] == 8){
                    //出差
                    $chuchai++;
                    $queqin++;
                }elseif($v['status'] ==6 || strstr($v['status'],6)){
                    //休假
                    $xiujia++;
                    $queqin++;
                }elseif($in_out == 2){
                    $waiqin++;
                    $queqin++;
                }elseif($in_out == 1 && $v['updatedate'] && $v['updatedate'] !='0000-00-00 00:00:00'){
                    $shidao++;
                }elseif(empty($v['updatedate']) || $v['updatedate'] =='0000-00-00 00:00:00'){
                    $queqin++;
                }

                //单人工作时长
                if(count($timeArr)>1){
                    $first = reset($timeArr);
                    $last = end($timeArr);
                    $diff = strtotime($last) - strtotime($first);
                    $time = $time + $diff;
                    $num++;
                }

            }

            $avg = $this->timeToString($time/$num);

            $data = [
                'shidao' => $shidao>0 ? $shidao : 0,
                'xiujia' => $xiujia>0 ? $xiujia : 0,
                'chuchai'=> $chuchai>0 ? $chuchai : 0,
                'waiqin' => $waiqin>0 ? $waiqin : 0,
                'queqin' => $queqin>0 ? $queqin : 0,
                'avg' => $avg,
            ];
            //print_r($data);die;
            return json(['code'=>200, 'data'=>$data]);
        }

        //员工动态
        public function getStaffDynamic(){
            $start_date = input('start') ? date('Y-m-d 00:00:00',strtotime(input('start'))) : date('Y-m-d 00:00:00');
            $end_date = input('end') ? date('Y-m-d 23:59:59',strtotime(input('end'))) : date('Y-m-d 23:59:59');
            //$end_date = date('Y-m-d',strtotime('+1 day '.$end_date));

            //面试
            $ms = db('oa_person_save_recruit','db_oa')
                ->where('times','between',[$start_date,$end_date])
                ->group('u_id')
                ->count();

            //入职
            $rz = db('oa_dept_staffinfo','db_oa')
                ->where('entry_date','between',[$start_date,$end_date])
                ->count();

            //自离
            $zl = db('oa_dept_staffinfo','db_oa')
                ->where('leave_date','between',[$start_date,$end_date])
                ->where('leave_type','自离')
                ->count();

            //劝退
            $qt = db('oa_dept_staffinfo','db_oa')
                ->where('leave_date','between',[$start_date,$end_date])
                ->where('leave_type','劝退')
                ->count();

            //调岗
            $dg = db('oa_dept_archives','db_oa')
                ->where('type',3)
                ->where('add_time','between',[$start_date,$end_date])
                ->group('staffid')
                ->count();


            $data = [
                'ms' => $ms>0 ? $ms : 0,
                'rz' => $rz>0 ? $rz : 0,
                'zl' => $zl>0 ? $zl : 0,
                'qt' => $qt>0 ? $qt : 0,
                'dg' => $dg>0 ? $dg : 0,
                ];
            $data['all'] = array_sum($data);

            return json(['code'=>200, 'data'=>$data]);
        }


        //工作提醒
        public function getWorkTip(){
            //下个月时间日期
            $now = date('Y-m-d');
            $lastMonth = date('Y-m-d',strtotime('+ 1 month'));
            //在职sql
            $sql = " leave_date='' or leave_date is null or leave_date > '".date('Y-m-d')."'";

            //试用到期(试用期时间在下个月月底前，未转正的)
            $syq = db('oa_dept_contract','db_oa')
                ->alias('c')
                ->join('oa_dept_staffinfo s','c.staffid = s.id','left')
                ->where('s.is_formal',2)
                ->where('probation_end_date','between',[$now,$lastMonth])
                ->where($sql)
                ->group('staffid')
                ->count();

            //合同续签(未续签的，到期时间在下个月月底前所有)
            $having = 'end_date <= "'.date('Y-m-d',strtotime($lastMonth)).'"';
            $ht = db('oa_dept_contract','db_oa')
                ->alias('c')
                ->join('oa_dept_staffinfo s','c.staffid = s.id','left')
                ->field('s.id as staff_id,s.staffname,s.turestaffname,s.staffnumber,s.shop_name,s.department_name,s.main_position_name,c.id,c.staffid,c.start_date,MAX(c.end_date) as end_date,c.signed_date,c.time_limit,c.status,c.probation,c.delay,c.add_time,c.add_staff_name,c.fund_date,c.`fund_total`,c.probation_end_date,c.entry_date')
                ->where($sql)
                ->HAVING($having)
                ->group('s.id')
                ->count();

            //生日提醒(下个月月底前到本月1号)
            $start = date('m01');
            $end = date('m31',strtotime('+1 month'));
            $birthday = db('oa_dept_staffinfo','db_oa')
                ->where($sql)
                ->where("DATE_FORMAT(b.birthday, '%m%d') between '".$start."' and '".$end."'")
                ->alias('a')
                ->join('oa_dept_staff_detail b','a.id = b.staffid','left')
                ->field('a.id,a.staffname as staffname,a.staffnumber,a.brandclass,a.shop_name,a.department_name,a.main_position_name,a.grade_type,a.turestaffname,a.telephone,a.entry_date,a.is_formal,a.working_status,a.leave_date,a.perfect_degree,a.sex,b.id as detail_id,b.birthday,b.IDcard')
                ->count();

            return json(['code'=>200,'data'=>['syq'=>$syq>0 ? $syq : 0,'ht'=>$ht>0 ? $ht : 0,'birthday'=>$birthday>0?$birthday:0]]);

        }

    //------------------------ 第四部分 办公数据大盘 结束 ------------------------//
}