<?php
/**
 * 催拍
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangyining<wangyining@suxuantech.cn> 2020-12-24 $
 */
namespace app\crm\controller;
use app\crm\lib\Target;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Response;
use think\Session;
use PHPExcel_IOFactory;
use PHPExcel;
use Excel5;
use think\Controller;
use app\common\lib\redisQueue;
use app\common\lib\erpInterface;
use app\common\lib\mcInterface;
class Urgephoto extends Base{

    public function urgePhoto(){

        if(request()->instance()->isAjax()){
            $params = input();
            return controller('Urgephoto','lib')->getCustomerData($params);
        }

        //可操作店
        $mc = new \app\common\lib\mcInterface();
        $shops = $mc->getWorkShop(['staff_id'=>session('staff_id')]);
        $shop_codes = implode(',',array_column($shops,'shop_code'));
        $shop_names = implode(',',array_column($shops,'shop_name'));

        //来源渠道
        $channels = controller('customer','lib')->getChannel(session('shop_code'));

        //消费类型
        $consumption_types = controller('customer','lib')->consumptionType(['shop_code'=>session('shop_code')]);

        //推广人（客资提报）
        $tuiguang = $mc->getStaffsByShopWorkType(['shop_code'=>$shop_codes,'work_type'=>23]);

        //邀约人（排相）
        $yaoyue = $mc->getStaffsByShopWorkType(['shop_code'=>$shop_codes,'work_type'=>34]);

        //催拍人（催拍）
        $cuipai = $mc->getStaffsByShopWorkType(['shop_code'=>$shop_codes,'work_type'=>40]);

        //追踪标记
        $mark = db('crm_s_markset')->where('shop_code',session('shop_code'))->select();

        //呼叫前缀
        $prefix = controller('crm/Customer','lib')->getCallPrefix();

        //分配邀约人
        $fenpeiyaoyuestaff = controller('Urgephoto','lib')->getFenpeiyaoyuestaff();

        //排控人
        $paikongstaff = controller('Urgephoto','lib')->getPaikongstaff();

        $this->assign([
            'shops'       => $shops,
            'shop_codes' => $shop_codes,
            'shop_names' => $shop_names,
            'tuiguang'   => $tuiguang,
            'yaoyue'     => $yaoyue,
            'cuipai'     => $cuipai,
            'channels'   => $channels,
            'consumption_types' => $consumption_types,
            'mark'       => $mark,
            'prefix'     => $prefix,
            'fenpeiyaoyuestaff'     => $fenpeiyaoyuestaff,
            'paikongstaff'     => $paikongstaff,
        ]);
        return $this->fetch();

    }

    /*
     *
     */
    public function getSearchDate(){
        $btn = input('btn');
        return controller('Urgephoto','lib')->getSearchDate($btn);
    }

    /*
     * 根据订单号获取拍照信息
     */
    public function getPhotoByWPhone(){
        $wphone = input('wphone');

        $data = db('c_customerphoto')
            ->alias('photo')
            ->join('c_customerinfo c','photo.customerid = c.customerid','left')
            ->join('c_customerorder order','photo.orderId = order.orderId','left')
            ->where(['c.wphone'=>$wphone])
            ->field('photo.*,c.wname,c.wphone,c.mname,c.mphone,order.package_name,order.targetdate,order.total_money,order.payment_money,order.nopayment_money')
            ->order('photo.create_time')
            ->select();
        return ['code'=>0,'data'=>$data,'count'=>count($data)];
    }

    /*
     * 根据订单号获取产品
     */
    public function getCpByOrderId(){
        $orderId = input('orderId');
        $fc = input('fc');

        $data = db('c_consumptioncontent')
            ->where(['orderId'=>$orderId,'servicenumber'=>$fc])
            ->select();
        return ['code'=>0,'data'=>$data,'count'=>count($data)];
    }

    /*
     * 根据单号 服次 获取催拍记录
     */
    public function getTracking(){
        $wphone = input('wphone');

        if(!$wphone){
            return ['code'=>0,'data'=>[],'count'=>0];
        }

        $data = db('c_customerteltracking')
            ->where('telphone',$wphone)
            ->order('createtime desc')
            ->select();
        return ['code'=>0,'data'=>$data,'count'=>count($data)];
    }

    /*
    * 获取之前的拍照沟通信息
    */
    public function getPhotoInfo(){
        $photoid = input('photoid');
        $orderId = input('orderId');
        $info = db('c_customerphoto')
            ->where('id',$photoid)
            ->field('id,photonote,communication_state,communication_man,communication_date,yxphotodaystart,yxphotodayend,yxphotoweek,callphotomark')
            ->find();
        $info['yxphotodaystart'] = $info['yxphotodaystart'] ? date('Y-m-d',strtotime($info['yxphotodaystart'])):'';
        $info['yxphotodayend'] = $info['yxphotodayend'] ? date('Y-m-d',strtotime($info['yxphotodayend'])):'';
        $info['week'] = $info['yxphotoweek'] ? explode(',',$info['yxphotoweek']) : [];

        $order = db('c_customerorder')->where(['orderId'=>$orderId])->find();
        $info['nextphotodate'] = $order['nextphotodate'] ? date('Y-m-d',strtotime($order['nextphotodate'])) : '';
        return ['code'=>200,'data'=>$info?$info:[]];
    }

    /*
     * 催拍
     */
    public function dianfang(){
        $params = input('');

        if(!$params['orderId']){
            return ['code'=>201,'msg'=>'未获取到订单信息，请稍后重试'];
        }

        if(!$params['customerid']){
            return ['code'=>201,'msg'=>'未获取到客户信息，请稍后重试'];
        }

        if(!$params['photoid']){
            return ['code'=>201,'msg'=>'未获取到拍照信息，请稍后重试'];
        }

        if($params['week']){
            $weekNum = [];
            foreach($params['week'] as $k => $v){
                $weekNum[] = $k;
            }

            $params['week'] = implode(',',$weekNum);
        }

        $params['mark_name'] = db('crm_s_markset')->where('id',$params['mark_id'])->value('mark_name');
        return controller('Urgephoto','lib')->dianfang($params);

    }

    /*
     * 催拍 发送短信
     * phone
     */
    public function sendTexting(){
        $phone = input('phone');

        $smsId  = db_config('cuipai_sms_model_'.session('shop_code'));

        $param = [
            '_mobile' => $phone,
            '_template_id' => $smsId,
            '_shop_code'    => Session::get('shop_code'),

        ];
        $smsRes = sx_call('5d78e60eeb6a2',$param);
        if($smsRes['code'] == 200){
            return ['code'=>200,'msg'=>'短信发送成功！'];
        }else{
            return ['code'=>204,'msg'=>'短信发送失败'.$smsRes['msg']];
        }

    }

    /*
     * 分配催拍人
     */
    public function fpUrgeStaff(){
        $params = input();

        $params = [
            'choose_data' => input('choose_data/a'),
            'choose_staff' => input('choose_staff'),
        ];

        return controller('Urgephoto','lib')->fpUrgeStaff($params);
    }

    /*
     * 查询可分配催拍的人
     */
    public function getUrgeStaff(){
        $params = input();
        return controller('Urgephoto','lib')->getUrgeStaff($params);
    }

}