<?php
/**
 * CRM 基本模块
 * 默认接口方法，此方法内定议基础框架所需要的方法，用于验证模块合法性，模块版本，对接基础架构中需要的方法
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-17 $
 */
namespace app\crm\controller;
use app\crm\lib\Target;
use think\Cache;
use app\index\controller\Base;
use think\Exception;
use think\Log;
use think\Request;
use think\Response;
use think\Session;
use PHPExcel_IOFactory;
use PHPExcel;
use Excel5;
use think\Controller;
use app\common\lib\redisQueue;
use app\common\lib\erpInterface;
use app\common\lib\mcInterface;
class Customerrec extends Base{
    //查询自定义列
    public function getCustomColumn(){
        $column= cache('colColumn_'.session('staff_id').'_'.session('shop_type'));
        $names = cache('colNames_'.session('staff_id').'_'.session('shop_type'));
        $model = cache('colModel_'.session('staff_id').'_'.session('shop_type'));

        if(strlen($column)>0 && !$names && !$model){
            $info = array(
                'custom_name'=>json_encode($names),
                'custom_model'=>json_encode($model),
            );
        }else{
            $info = db('crm_s_custom_column')->where('staff_id',session('staff_id'))->where('shop_type',session('shop_type'))->find();
            if(!empty($info)){
                cache('colColumn_'.session('staff_id').'_'.session('shop_type'),$info['custom_column']);
                cache('colNames_'.session('staff_id').'_'.session('shop_type'),$info['custom_name']);
                cache('colModel_'.session('staff_id').'_'.session('shop_type'),$info['custom_model']);
                $info = array(
                    'custom_name'=>($info['custom_name']),
                    'custom_model'=>($info['custom_model']),
                );
            }
        }
        return $info;
    }
    // 获取客资录入 必选项
    public function getLrMust(){
        // 录入必选项配置
        $lrMust = db_config('lr_must_'.session('brandclass_id'));
        $lrMust = trim($lrMust,',');
        $lrMust = explode(',',$lrMust);
        //成都网销中心录入客资 ‘获取方式’ 为必填项
        if(session('shop_code') == 'TSYX13' && !in_array('access_model',$lrMust)){
            $lrMust[] = 'access_model';
        }
        return $lrMust;
    }
    // 获取客资录入 隐藏项
    public function getLrHidden(){
        $hidden = db_config('lr_hidden_'.session('brandclass_id'));
        $hidden = trim($hidden,',');
        $lrHidden = explode(',',$hidden);
        return $lrHidden;
    }
    //客资列表、查询
    public function customerList(){
        if(Request::instance()->isAjax()){
            
            $data = input();
            // var_dump($data);
            // exit;
            // 客资状态
            $is_valid = $data['is_valid'] ? $data['is_valid'] : '1,2,3,4,5';
            cookie('valid', $is_valid);
            
            // var_dump($arr);
            // exit;
            // 客资爆破 
            // if($data['tab'] == 100){
            //     $detail=controller("Customer","lib")->customerListData_bp($data);
            // }
            // else{
            //     // if ($data['']) {
            //     //     # code...
            //     // }
            //     $detail=controller("Customer","lib")->customerListData($data);
            // }
            if (!$data['tab']) {
                $auth=getAuth($type='auth');
                $menuCode= array_column($auth,'menu_code');
                $allRab = [//客资列表的tab
                    'menu1512698495',//全部     1
                    'menu1524450329',//今日需追踪    17
                    'menu1512698635',//未分配   3
                    'menu1512698552',//未追踪   2
                    'menu1564454831',//孕妈追踪 21
                    'menu1564454848',//出生追踪 22
                    'menu1564454860',//满月追踪 23
                    'menu1564454873',//百天追踪 24
                    'menu1564454884',//半岁追踪 25
                    'menu1564454900',//周岁追踪 26
                    'menu1512698717',//已订单   5
                    'menu1513395549',//不再追踪 7
                ];
                $allRab = array_intersect($allRab,$menuCode);
                if (in_array('menu1512698495',$allRab)) {
                    $data['tab'] = '1';
                }else if (in_array('menu1524450329',$allRab)) {
                    $data['tab'] = '17';
                }else if (in_array('menu1512698635',$allRab)) {
                    $data['tab'] = '3';
                }else if (in_array('menu1512698552',$allRab)) {
                    $data['tab'] = '2';
                }else if (in_array('menu1564454831',$allRab)) {
                    $data['tab'] = '21';
                }else if (in_array('menu1564454848',$allRab)) {
                    $data['tab'] = '22';
                }else if (in_array('menu1564454860',$allRab)) {
                    $data['tab'] = '23';
                }else if (in_array('menu1564454873',$allRab)) {
                    $data['tab'] = '24';
                }else if (in_array('menu1564454884',$allRab)) {
                    $data['tab'] = '25';
                }else if (in_array('menu1564454900',$allRab)) {
                    $data['tab'] = '26';
                }else if (in_array('menu1512698717',$allRab)) {
                    $data['tab'] = '5';
                }else if (in_array('menu1513395549',$allRab)) {
                    $data['tab'] = '7';
                }
            }

            if ($data['tab'] == 7) {
                $data['is_loss'] = 1;
            }
            // var_dump($data);die;
            $detail=controller("crm/Customer","lib")->customerListData($data);
            echo json_encode($detail);
        }else{
            //从客户管理中链接过来，查看某条客资信息
            $client_customer_id = input('client_customer_id');
            $this->assign('client_customer_id',$client_customer_id?$client_customer_id:0);

            $menu = include(APP_PATH.'menu.php');
            $menuCustomize = include(APP_PATH.'menu_customize.php');
            $auth = getAuthMenu($menu,'auth',$menuCustomize);
            //查看是否有客资列表的权限 2020-08-07
            if (!check_right('menu1512735953')) {
                $res = getAuthMenu($menu,'menu',$menuCustomize);
                $redirect_url = '';
                if (count($res['list']) > 0) {
                    foreach ($res['list'] as $key => $value) {
                        if ($value['status'] == 1) {
                            $redirect_url = $value['menu_url'];break;
                        }
                    }
                }
                if (strlen($redirect_url) > 0) {
                    $this->redirect($redirect_url);
                }else{
                    $this->redirect("/crm/Customer/prompt?msg=您的账户现在没有权限，请您联系管理员跟您分配对应的权限，重新登录进入系统使用。");
                }
            }            

            //查看一年内客资
            if(check_right('menu1546854888') && session('main_work_type') != 22){
                $this->assign('yearCus',1);
            }else{
                $this->assign('yearCus',0);
            }

            // $auth=getAuth($type='auth');
            $newAuth = controller('crm/Setting','lib')->arrayDuoZhuanEr($auth['list']);
            $menuCode= array_column($newAuth,'menu_code');
            
            // var_dump($menuCode);die;
            $allRightMenu = [//要控制的所有右键菜单
                'menu1512971662',//客资追踪
                'menu1519631971',//右键-客资标记
                'menu1519635403',//右键-筛客
                'menu1519632099',//右键-追踪标记
                'menu1519633870',//右键-预约进店
                'menu1519633923',//右键-转订单
                'menu1519633959',//右键-编辑订单
                'menu1520675106',//右键-撤销
                'menu1522653972',//右键-介绍人修改
                'menu1519633436',//右键-不再追踪
                // 'menu1517129299',//标有效
                'menu1546854995',//标有效
                'menu1517129331',//标无效
                'menu1517278817',//客资驳回
                'menu1517278844',//客资反驳回
                'menu1512971646',//发送短信
                'menu1512970623',//客资分配
                'menu1512970667',//修改客资
                'menu1512970570',//删除客资
                'menu1571906153',//预约上门
            ];
            // 查询是否为某组的管理员  20200613
            $mc = new \app\common\lib\mcInterface();
            $gParam['brandclass_id'] = session('brandclass_id') ? session('brandclass_id') : NULL;
            $gParam['shop_code'] = session('shop_code') ? session('shop_code') : NULL;
            if ($gParam['shop_code']) {
                $gParam['department_id'] = NULL;
            }else{
                $gParam['department_id'] = session('department_id') ? session('department_id') : NULL;
            }
            $gParam['staff_id'] = session('staff_id');
            $groupInfo = $mc->getGroupInfo($gParam);
            // var_dump($groupInfo);
            // die;
            if ($groupInfo) {
                $this->assign('group',1);
            }else{
                $this->assign('group',0);
            }
            $rightMenuList = array_intersect($allRightMenu,$menuCode);
            $this->assign('right_menu_list', $rightMenuList);
            $allRab = [//客资列表的tab
                'menu1512698495',//全部
                'menu1524450329',//今日需追踪
                'menu1512698635',//未分配
                'menu1512698552',//未追踪
                'menu1564454831',//孕妈追踪
                'menu1564454848',//出生追踪
                'menu1564454860',//满月追踪
                'menu1564454873',//百天追踪
                'menu1564454884',//半岁追踪
                'menu1564454900',//周岁追踪
                'menu1512698717',//已订单
                'menu1513395549',//不再追踪
            ];
            $allRab = array_intersect($allRab,$menuCode);
            if (in_array('menu1512698495',$allRab)) {
                $this->assign('this_tab','menu1512698495');
            }else if (in_array('menu1524450329',$allRab)) {
                $this->assign('this_tab','menu1524450329');
            }else if (in_array('menu1512698635',$allRab)) {
                $this->assign('this_tab','menu1512698635');
            }else if (in_array('menu1512698552',$allRab)) {
                $this->assign('this_tab','menu1512698552');
            }else if (in_array('menu1564454831',$allRab)) {
                $this->assign('this_tab','menu1564454831');
            }else if (in_array('menu1564454848',$allRab)) {
                $this->assign('this_tab','menu1564454848');
            }else if (in_array('menu1564454860',$allRab)) {
                $this->assign('this_tab','menu1564454860');
            }else if (in_array('menu1564454873',$allRab)) {
                $this->assign('this_tab','menu1564454873');
            }else if (in_array('menu1564454884',$allRab)) {
                $this->assign('this_tab','menu1564454884');
            }else if (in_array('menu1564454900',$allRab)) {
                $this->assign('this_tab','menu1564454900');
            }else if (in_array('menu1512698717',$allRab)) {
                $this->assign('this_tab','menu1512698717');
            }else if (in_array('menu1513395549',$allRab)) {
                $this->assign('this_tab','menu1513395549');
            }
            // 有效的复选框
            $is_valid = cookie('valid') ? cookie('valid') : '1,2,3,4,5';
            $is_valid = explode(',', $is_valid);
            $this->assign('valid', $is_valid);
            //登录人搜索下拉框 根据权限显示
            if(check_right('menu1512637269')){
                if(session('is_belong')==1){
                    $staff_list=controller("Customer","lib")->get_staff_lists();
                }elseif(session('is_belong')==2){
                    $staff_list=controller("Customer","lib")->get_staff_lists(array('brandclass'=>session
                    ('brandclass')));
                }elseif(session('is_belong')==3||session('is_belong')==4){
                    $staff_list=controller("Customer","lib")->get_staff_lists(array('shop_code'=>session('shop_code')));
                }
            }
            $this->assign("staff_list",$staff_list);
            //客资转移用 本店的员工 这个功能有问题
            $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>session('shop_code')]);
            $this->assign('staff',$staff);
            /**/
            //渠道名称
            $channel = getChannelJson(session('shop_code'));
            $this->assign("channel", json_encode($channel));
            //客户来源
            $source=controller("crm/Customer","lib")->source(array('shop_code'=>session('shop_code')));
            $this->assign("source",$source);
            //获取方式
            //$accessModel=controller("Customer","lib")->accessModel(array('shop_code'=>session('shop_code')));
            //$this->assign("accessModel",$accessModel);
            //客户意向
            $intention=controller("crm/Customer","lib")->intention(array('shop_code'=>session('shop_code')));
            $this->assign("intention",$intention);
            $this->assign("intention1",$intention);
            //消费类型
            $consumptionType=controller("crm/Customer","lib")->consumptionType();
            $this->assign("consumptionType",$consumptionType);
            //客资地域
            $region=controller("crm/Customer","lib")->region(array('shop_code'=>session('shop_code')));
            $this->assign("region",$region);
            //客户分区
            $area=controller("crm/Customer","lib")->areaSet(array('shop_code'=>session('shop_code')));
            $this->assign("area",$area);
            //追踪标记
            $mark=controller("crm/Customer","lib")->markSet(array('shop_code'=>session('shop_code')));
            $this->assign("mark",$mark);
            $this->assign("mark1",$mark);
            //客资标记
            $sign=controller('crm/Setting','lib')->gettrackingKmarkerList();
            $this->assign("sign",$sign);
            //意向店面
            $intentionShop=controller('crm/Customer','lib')->get_shop(array('brandclass'=>session('brandclass'),'is_marketing'=>2));
            $this->assign('intentionShop',$intentionShop);
            //消费能力
            $capacity=controller("Customer","lib")->capacity(array('shop_code'=>session('shop_code')));
            $this->assign("capacity",$capacity);
            //所有已成单客资
            //$customer_name=db('crm_c_customerinfo')->where(array('is_success'=>1))->select();
            //$this->assign("customers",$customer_name);
            //客户地址 （省级）
            $data['type']=1;
            $address=controller("crm/Customer","lib")->address($data);
            $this->assign("address",$address);
            //短信模板
            $mod = controller("crm/Setting","lib")->getModalToJSON();
            $this->assign("model",$mod['data']);
            //追踪阶段
            $seles = controller('crm/Customer','lib')->get_seles_step();
            $this->assign("seles",$seles);
            $this->assign("seless",$seles);
            //追踪失败原因
            $reason = controller('crm/Customer','lib')->get_reason();
            $this->assign("reason",$reason);
            //呼叫前缀
            $prefix = controller('crm/Customer','lib')->getCallPrefix();
            $this->assign("prefix",$prefix);
            //应用是否安装
            $this->assign('is_install',is_install('sx_erp'));
            $this->assign('title','客资');
            //品牌下的店面
            $shops = controller('crm/Customer','lib')->getShopInfo(['brandclass_id'=>session('brandclass_id')]);
            $this->assign('shops',$shops['data']);
            $menu=getAuth($type='auth');
            $this->assign('menu',$menu);

            $custom = $this->getCustomColumn();

            $check_list = db_config('shop_column_name_'.session('shop_code'));//店面自定义列
            $check_list = strlen($check_list)>0 ? explode(',',trim($check_list,',')) :  [];
            $column = db_config('shop_column_'.session('shop_code'));//店面自定义列
            $column = strlen($column)>0 ? explode(',',trim($column,',')) :  [];

            $this->assign('colModel',$custom['custom_model'] ? json_decode($custom['custom_model'],true) : json_encode($column));
            $this->assign('colNames',$custom['custom_name'] ? json_decode($custom['custom_name'],true) : json_encode($check_list));

            //列表页搜索项隐藏配置
            $search = db_config('list_search_hidden_'.session('brandclass_id'));
            if($search){
                $search = explode(',',$search);
            }
            $this->assign('search_list',$search);

            //客资无效原因
            $unValidReason = controller('crm/Customer','lib')->getUnValidReason();
            $this->assign('unValidReason',$unValidReason);
            //呼叫中心
            // $this->assign('callCenter',config('call_center'));
            //要在登录时放点session或cookie里
            // $this->assign('callCenter','shenou');//要在登录时放点session或cookie里

            // $this->assign('is_swap', $is_swap);
            //颜色
            // 2020-08-05 去掉列表页选中颜色 2020-08-05 列表页鼠标跟随颜色
            // $on_select_color = db_config('on_select_color');
            // $this->assign('on_select_color',$on_select_color ? $on_select_color : 'ffd7dc');
            // $hover_color = db_config('hover_color');
            // $this->assign('hover_color',$hover_color ? $hover_color : 'ffe1c9');
            $service_end = db_config('service_end');
            $this->assign('service_end',$service_end);
            $service_start = db_config('service_start');
            $this->assign('service_start',$service_start);
            $service_no = db_config('service_no');
            $this->assign('service_no',$service_no);
            // 2020-08-05 去掉隔行变色
            // $alt_row_color = db_config('alt_row_color');
            // $this->assign('alt_row_color',$alt_row_color);
            $success_color = db_config('success_color');
            $this->assign('success_color',$success_color);
            $into_color = db_config('into_color');
            $this->assign('into_color',$into_color);
            $loss_color = db_config('loss_color');
            $this->assign('loss_color',$loss_color);
            $erp_loss_color = db_config('erp_loss_color');
            $this->assign('erp_loss_color',$erp_loss_color);
            $int_no_suc_color = db_config('int_no_suc_color');
            $this->assign('int_no_suc_color',$int_no_suc_color);
            $yy_no_into_color = db_config('yy_no_into_color');
            $this->assign('yy_no_into_color',$yy_no_into_color);
            $bh_color = db_config('bh_color');
            $this->assign('bh_color',$bh_color);
            $bh_color_fan = db_config('bh_color_fan');
            $this->assign('bh_color_fan',$bh_color_fan);
            $unvalid_color = db_config('unvalid_color');
            $this->assign('unvalid_color',$unvalid_color);
            $urgent_color = db_config('urgent_color');
            $this->assign('urgent_color',$urgent_color);
            $color = salesSignColor();
            $this->assign('color',json_encode($color));
            $sign_color = signColor();
            $this->assign('sign_color',json_encode($sign_color));
            //电访必选项配置
            $dfMust = db_config('df_must_'.session('brandclass_id'));
            $dfMust = trim($dfMust,',');
            $dfMust = explode(',',$dfMust);
            $this->assign('dfMust',json_encode($dfMust));
            //客资重复审核配置
            $examine= db_config('cus_examine_'.session('shop_code'));
            $this->assign('examine',$examine);

            $b_is_sk = controller("crm/Customer", "lib")->is_sk(session('belong_shop_code'));
            // 客资提归属店或者当前店开启筛客
            if($b_is_sk == 1 || session('is_sk') == 1){
                $this->assign('isSk',true);
            }else{
                $this->assign('isSk',false);
            }
            //列表页时间
            $list_date = db_config('list_date');
            if($list_date == 'week'){
                $start = date('Y-m-d',strtotime('-1 week'));
                $end=date('Y-m-d');
            }elseif($list_date == 'day'){
                $start=date('Y-m-d');
                $end=date('Y-m-d');
            }else{
                $start=date('Y-m-01');
                $end=date('Y-m-d');
            }
            if(ini('search.fullmobile')){
                $this->assign('fullmobile',1);
            }
            $this->assign('start',$start);
            $this->assign('end',$end);
            // 新版新增客资页面 开始 20200928
                // 填写日期 默认今天
                if ( db_config('record_day_'.session('shop_code'))=='today' ) {
                    $this->assign('record_day', date('Y-m-d'));
                }else{
                    $this->assign('record_day', '');
                }
                // 录入必选项定制 录入时显示 20200106
                if (ini('lr_must.shop_code')==session('shop_code')) {
                    // 判断字段是否存在
                    $column = isColumnExist(array('table'=>'crm_c_customerinfo','column'=>ini('lr_must.field')));
                    if ($column) {
                        $select = explode(',', ini('lr_must.select'));
                        $this->assign("xaf_field1",ini('lr_must.field'));
                        $this->assign("xaf_fieldname1",ini('lr_must.fieldname'));
                        $this->assign("xaf_select1",$select);
                    }
                }
                // 录入客资必选项
                $this->assign('lrMust',$this->getLrMust());
                // 录入客资隐藏项
                $lrHidden = $this->getLrHidden();
                $this->assign('lrHidden',$lrHidden);
                // 先暂时这样 后面想想有没有其他的办法 
                $allLrSelect = [
                    'channel_info',// 来源渠道
                    'customer_channel',// 渠道名称
                    'access_model',// 获取方式
                    'consultation_type',// 消费类型
                    'customer_intention',// 客户意向
                    'customer_cource',// 客户来源
                    'tracksign',// 客资标记
                    'recommend_staff',// 推广人
                    'consulation_shop',// 意向店面
                    'is_valid',// 客资状态
                    'baby_address',// 出生医院
                    'hospital_photo_cameraman',// 医拍摄影师
                    'hospital_photo_assistant',// 医拍助理
                    'club_name',// 入住会所
                ];
                foreach ($allLrSelect as $key => $value) {
                    if ( in_array($value, $lrHidden) ) {
                        unset($allLrSelect[$key]);
                    }
                }
                $allLrSelect = implode(',', $allLrSelect);
                $this->assign('all_lr_select',$allLrSelect);
                // 标记有效 客资状态 是否隐藏 应该根据当前 员工的权限
                $validArr = [];
                if(check_right('menu1546854995')){
                    $temp['id']  = 1;
                    $temp['name']= '有效';
                    $temp['sele']= 0;
                    $validArr[] = $temp;
                }
                // 标记待定
                $temp['id']  = 2;
                $temp['name']= '待定';
                $temp['sele']= 0;
                $validArr[] = $temp;
                // 标记无效
                if(check_right('menu1517129331')){
                    $temp['id']  = 3;
                    $temp['name']= '无效';
                    $temp['sele']= 0;
                    $validArr[] = $temp;
                }
                $this->assign('validArr',$validArr);
                // 宝宝性别
                $baby_sex = config('baby_sex');
                if(empty($baby_sex)){
                    $baby_sex = [
                        ['sex'=>'男',],['sex'=>'女',],
                    ];
                }
                $this->assign('baby_sex',$baby_sex);
                //客户地址
                $addrParam['type']=1;
                $addrParam['shop_code']=session('shop_code');
                $address=controller("crm/Customer","lib")->address($addrParam);
                $this->assign("address",$address);
                // 客资录入类型  查看设定
                $customer_type = explode(',', db_config('customer_type_'.session('shop_code')));
                $only = '';
                foreach ($customer_type as $key => $value) {
                    if (!$value) { // 如果没有设定
                        $mc = new \app\common\lib\mcInterface();
                        $shopInfo = $mc->getShopInfo(array('shop_code' => session('shop_code')));
                        if ($shopInfo[0]['is_dig'] == 1) { // 如果是转介绍客资接入店
                            $only = '2';
                        }else{ // 只有新客资，没有转介绍
                            $only = '1'; 
                        }
                    }else{
                        $only .= $value.',';
                    }
                }
                $only = trim($only,',');
                if ($only == '1') {
                    $only = 'new';
                }else if ($only == '2') {
                    $only = 'zjs';
                }else{
                    $only = 'all';
                }
                $this->assign('only', $only);
                // 介绍人是否可输入
                $mobile_input = db_config('mobile_input_'.session('shop_code'));
                $this->assign("mobile_input",$mobile_input);
                // babypastel 录转介绍客资的时候 可以录入渠道
                $babypastel = customize('babypastel');
                // var_dump($babypastel);die;
                if ($babypastel) {
                    $this->assign('babypastel','1');
                }else{
                    $this->assign('babypastel','2');
                }
                // 输出页面
                $this->assign('add_new_child_customer_page',$this->fetch('add_new_child_customer'));
            // 新版新增客资页面 结束

            // 新版 电访 页面 开始 20201022
                //追踪必选项配置
                $dfMust = db_config('df_must_'.session('brandclass_id'));
                $dfMust = explode(',',$dfMust);
                $this->assign('dfMust',$dfMust);
                //追踪选项隐藏配置
                $dfHidden = db_config('df_hidden_'.session('brandclass_id'));
                $dfHidden = explode(',',$dfHidden);
                $this->assign('dfHidden',$dfHidden);
                // 输出页面
                $this->assign('dianfang_new',$this->fetch('dianfang_new'));
                // var_dump($this->fetch('dianfang_new'));die;
            // 新版新增客资页面 结束
            return view('customer_child');
        }
    }
    //获取客资详情
    public function getCustomerInfo(){
        $return['code'] = 200;
        $return['msg']  = '';
        $return['data'] = '';
        $id = (int)input('post.id');
        if (!$id) {
            $return['code'] = 100;
            $return['msg']  = '客资ID为空，无法获取客资信息';
            $return['data'] = input('post.id');
            return json($return);
        }
        // 客资基本资料
        $customerInfo = controller("crm/Customer","lib")->getCustomerInfo($id);
        $customerInfo['baby_birthday'] = $customerInfo['baby_birthday'] ? date('Y-m-d',strtotime($customerInfo['baby_birthday'])) : '';
        $customerInfo['ready_baby_day'] = $customerInfo['ready_baby_day'] ? date('Y-m-d',strtotime($customerInfo['ready_baby_day'])) : '';
        $customerInfo['mate_birthday'] = $customerInfo['mate_birthday'] ? date('Y-m-d',strtotime($customerInfo['mate_birthday'])) : '';
        $customerInfo['customer_birthday'] = $customerInfo['customer_birthday'] ? date('Y-m-d',strtotime($customerInfo['customer_birthday'])) : '';
        $customerInfo['marry_day'] = $customerInfo['marry_day'] ? date('Y-m-d',strtotime($customerInfo['marry_day'])) : '';
        if ($customerInfo) {
            $return['data'] = $customerInfo;
        }else{
            $return['msg']  = '获取客资信息失败';
            $return['data'] = db()->getLastSql();
        }
        return json($return);
    }
    // 获取各个下拉框的值
    public function getSelectDataList($param=[]){
        // 二级渠道 来源渠道 
        $erChannel = controller("crm/Customer","lib")->getErChannel(session('shop_code'));
        $return['erChannel'] = $erChannel;
        // 三级渠道 渠道名称
        $channel = controller("crm/Customer","lib")->getChannel(session('shop_code'));
        $return['channel'] = $channel;
        // 获取方式 
        $accessModel=controller("crm/Customer","lib")->accessModel(array('shop_code'=>session('shop_code')));
        $return['accessModel'] = $accessModel;
        // 消费类型   不从mc里取了，取erp的设定
        $consumptionType = controller("crm/Customer","lib")->consumptionType();
        $return['consumptionType'] = $consumptionType;
        // 客户意向 
        $intention=controller("crm/Customer","lib")->intention(array('shop_code'=>session('shop_code')));
        $return['intention'] = $intention;
        // 客户来源 
        $source = controller("crm/Customer","lib")->source(array('shop_code'=>session('shop_code')));
        $return['source'] = $source;
        // 客资标记 
        $tracksign=controller("crm/Setting","lib")->gettrackingKmarkerList();
        $return['tracksign'] = $tracksign;
        // 推广人 
        $tgParam['shop_code'] = session('shop_code');
        $tgParam['work_type'] = KZTB_WORK_TYPE;
        $tgParam['all'] = 2;
        $recommendStaff = getShopStaffs($tgParam);
        $return['recommendStaff'] = $recommendStaff;
        // 意向店面 
        $intentionShops = controller('crm/Customer','lib')->get_shop(array('brandclass'=>session('brandclass'),'is_marketing'=>2));
        $return['intentionShops'] = $intentionShops;
        // 出生医院 
        $hospital = controller('crm/Customer','lib')->getHospital();
        $return['hospital'] = $hospital;
        // 入住会所 ，
        $clubData = db("crm_s_club")->where("brandclass_id",session("brandclass_id"))->select();
        $return['clubData'] = $clubData;
        // 医拍摄影师 
        $ypParam['shop_code'] = session('shop_code');
        $ypParam['work_type'] = PZ_WORK_TYPE;
        $photo_cameraman = getShopStaffs($ypParam);
        $return['photo_cameraman'] = $photo_cameraman;
        // 医拍摄影助理 
        $zlParam['shop_code'] = session('shop_code');
        $zlParam['work_type'] = SYZL_WORK_TYPE;
        $photo_assistant = getShopStaffs($zlParam);
        $return['photo_assistant'] = $photo_assistant;
        // 宝宝性别
        $baby_sex = config('baby_sex');
        if(empty($baby_sex)){
            $baby_sex = [
                ['sex'=>'男',],['sex'=>'女',],
            ];
        }
        $return['baby_sex'] = $baby_sex;
        // 客资状态 有效无效等
        $validArr = [];
        if(check_right('menu1546854995')){
            $temp['id']  = 1;
            $temp['name']= '有效';
            $temp['sele']= 0;
            $validArr[] = $temp;
        }
        // 标记待定
        $temp['id']  = 2;
        $temp['name']= '待定';
        $temp['sele']= 0;
        $validArr[] = $temp;
        // 标记无效
        if(check_right('menu1517129331')){
            $temp['id']  = 3;
            $temp['name']= '无效';
            $temp['sele']= 0;
            $validArr[] = $temp;
        }
        $return['validArr'] = $validArr;
        // 追踪标记
        $mark=controller("crm/Customer","lib")->markSet(array('shop_code'=>session('shop_code')));
        $return['mark'] = $mark;
        // 追踪阶段
        $selesStep = controller('crm/Customer','lib')->get_seles_step();
        $return['selesStep'] = $selesStep;
        // 客资标签
        $cat = cache('label_'.session('brandclass_id'));
        if(empty($cat)){
            $cat = db('crm_s_label_cat')->where('brandclass_id',session('brandclass_id'))->where('status',2)->select();
            foreach($cat as $k=>$v){
                $cat[$k]['cat_name'] = $v['cat_name'];
                $cat[$k]['label'] = db('crm_s_label')->where('brandclass_id',session('brandclass_id'))->where('label_cat_id',$v['id'])->where('is_delete',2)->select();
                if(empty($cat[$k]['label'])){
                    unset($cat[$k]);
                }
            }
            cache('label_'.session('brandclass_id'),$cat);
        }
        $return['cat'] = $cat;
        // 驳回原因
        $reject = db('crm_s_reject_reason')->where('shop_code',session('shop_code'))->select();
        $return['reject'] = $reject;
        // 不再追踪原因
        $noTrackReason = db('crm_s_file_reason')->where('shop_code',session('shop_code'))->select();
        $return['noTrackReason'] = $noTrackReason;
        //省
        $province = controller('crm/Customer','lib')->address(['type'=>1,'shop_code'=>session('shop_code')]);
        $return['province'] = $province;

        return json(['code'=>200,'msg'=>'','data'=>$return]);
    }
    //根据所选省查询以下市、根据市查询以下县
    public function searchCity(){
        $data = input('post.');
        $res = controller('crm/Customer','lib')->address($data);
        return $res;
    }

    // 追踪记录 html
    public function traceRecordHtml(){
        $param = input();
        if ((int)$param['id']) {
            $repeat_way = db_config('customer_repeat_method');
            $repeat_way = $repeat_way?$repeat_way:config('repeat_way');
            //$repeat_way = config('repeat_way');
            // 追踪记录
            $trackInfos = controller("crm/Customer","lib")->getCustomerTrackInfos((int)$param['id']);
            $str = '';
            if ($trackInfos) {
                foreach ($trackInfos as $k => $v) {
                    $str .= '<div class="z_con" style="backgroud-color:#ddd;border: 1px solid #01b88a;">';
                    if ($repeat_way == 'xaf') {
                        $str .= '<div class="z_cc" style="order:1px solid red;">';
                    }else{
                        $str .= '<div class="z_cc" style="height:145px;order:1px solid red;">';
                    }
                    $str .= '<div class="z_left">';
                    // 宝宝姓名div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">宝宝姓名：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    $str .= '<input type="text" class="cus-input" value="'.$v['baby_name'].'" readonly />';
                    $str .= '</div>';
                    $str .= '</div>';
                    // 宝宝性别 div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">宝宝性别：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    $str .= '<input type="text" class="cus-input" value="'.$v['baby_sex'].'" readonly />';
                    $str .= '</div>';
                    $str .= '</div>';
                    // 宝宝生日 div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">宝宝生日：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    if ($v['baby_birthday']) {
                        $str .= '<input type="text" class="cus-input" value="'.date("Y-m-d",$v['baby_birthday']).'" readonly />';
                    }else{
                        $str .= '<input type="text" class="cus-input" value="" readonly />';
                    }
                    $str .= '</div>';
                    $str .= '</div>';
                    // 预产期 div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">预产期：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    if ($v['ready_baby_day']) {
                        $str .= '<input type="text" class="cus-input" value="'.date("Y-m-d",$v['ready_baby_day']).'" readonly />';
                    }else{
                        $str .= '<input type="text" class="cus-input" value="" readonly />';
                    }
                    $str .= '</div>';
                    $str .= '</div>';
                    // 客资渠道： div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">客资渠道：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    $str .= '<input type="text" class="cus-input" value="'.$v['customer_channel'].'" readonly />';
                    $str .= '</div>';
                    $str .= '</div>';
                    // 妈妈姓名 div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">妈妈姓名：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    $str .= '<input type="text" class="cus-input" value="'.$v['customer_name'].'" readonly />';
                    $str .= '</div>';
                    $str .= '</div>';
                    // 妈妈手机 div
                    $str .= '<div class="layui-inline zzd">';
                    $str .= '<label class="layui-form-label z_name">妈妈手机：</label>';
                    $str .= '<div class="layui-input-block z_in">';
                    $str .= '<input type="text" class="cus-input" value="'.$v['customer_tel'].'" readonly />';
                    $str .= '</div>';
                    $str .= '</div>';
                    if ($repeat_way == 'xaf') {
                        // 获取次数 div
                        $str .= '<div class="layui-inline zzd">';
                        $str .= '<label class="layui-form-label z_name">获取次数：</label>';
                        $str .= '<div class="layui-input-block z_in">';
                        $str .= '<input type="text" class="cus-input" value="'.$v['baby_time'].'" readonly />';
                        $str .= '</div>';
                        $str .= '</div>';
                    }else{
                        // 客资标记 div
                        $str .= '<div class="layui-inline zzd">';
                        $str .= '<label class="layui-form-label z_name">客资标记：</label>';
                        $str .= '<div class="layui-input-block z_in">';
                        $str .= '<input type="text" class="cus-input" value="'.$v['sign_name'].'" readonly />';
                        $str .= '</div>';
                        $str .= '</div>';
                    }
                    $str .= '</div>';
                    // 追踪记录
                    $str .= '<div class="z_right zzd"  style="overflow:auto;margin-left: -45px;">';
                    $str .= '<ul class="layui-timeline">';
                    if ($v['track']) {
                        foreach ($v['track'] as $key => $val) {
                            $str .= '<li class="layui-timeline-item">';
                            $str .= '<div class="layui-timeline-date">&nbsp;</div>';
                            $str .= '<i class="layui-icon layui-timeline-axis"></i>';
                            $str .= '<div class="layui-timeline-content">';
                            $str .= '<div>时间：'.$val['sales_day'].'</div>';
                            $str .= '<div>沟通人员：'.$val['sales_staff'].'</div>';
                            $str .= '<div><div class="layer-photos-demo">备注信息：'.$val['sales_remark'].'</div></div>';
                            if ($val['audio_path']) {
                                $str .= '<audio id="web-sound" controls="controls" src="http://'.$val['audio_path'].'">NO<audio>';
                            }
                            $str .= '</div>';
                            $str .= '</li>';
                        }
                    }
                    $str .= '</ul>';
                    $str .= '</div>';
                    $str .= '</div>';
                    $str .= '</div>';
                }
            }
            $return['code'] = 200;
            $return['msg']  = '';
            $return['data'] = $str;
        }else{
            $return['code'] = 100;
            $return['msg']  = '没有客资ID，获取客资信息失败';
            $return['data'] = $param;
        }
        return json($return);
    }
}