<?php
/**
 * 报表实现类 关键词统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Customer_keywords extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568097500';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));
        $where['c_from'] = 1;
        $where['is_status'] = 1;
        if($data['dj_staff_id']){
            $where['dj_staff_id'] = intval($data['dj_staff_id']);
        }
        //店下活动
        $keywords = db('crm_c_customerinfo')->where('add_shop_code|shop_code',$shop_code)->where($where)->where('dj_day','between',[$start,$end])->where('customer_key is not null and customer_key<>""')->group('customer_key')->column('customer_key');

        $sql = "sum(dj_day between '".$start."' and '".$end."') as mkz,";//总录入
        $sql .= "sum(is_valid=1 and dj_day between '".$start."' and '".$end."') as valid,";//有效
        $sql .= "sum(is_valid=3 and dj_day between '".$start."' and '".$end."') as wx,";//无效
        $sql .= "sum(is_valid in ('2,','4','5') and dj_day between '".$start."' and '".$end."') as dd";//待定
        $info= db('crm_c_customerinfo')
            ->where($where)
            ->where('add_shop_code',$shop_code)
            ->group('customer_key')
            ->column($sql,'customer_key');
        $order = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')
            ->where('c.add_shop_code',$shop_code)
            ->where($where)
            ->where('o.targetdate','between',[$start_erp,$end_erp])
            ->group('c.customer_key')
            ->column('count(o.id)','c.customer_key');
        $yixiao = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('c.add_shop_code',$shop_code)
            ->where($where)
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.suoshu','in',['前期款','前期补款'])
            ->group('c.customer_key')
            ->column('sum(p.payment_money)','c.customer_key');
        $erxiao = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')->join('c_paymentcontent p','o.orderId=p.orderId','LEFT')
            ->where('c.add_shop_code',$shop_code)
            ->where($where)
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->where('p.suoshu','in',['后期款','后期补款'])
            ->group('c.customer_key')
            ->column('sum(p.payment_money)','c.customer_key');

        $return = [];
        $total['name'] = '总计';
        foreach($keywords as $k=>$v){
            $arr = [];
            $arr['name'] = $v;
            $arr['mkz'] = $info[$v]['mkz'] ? $info[$v]['mkz'] : 0;
            $arr['valid'] = $info[$v]['valid'] ? $info[$v]['valid'] : 0;
            $arr['wx'] = $info[$v]['wx'] ? $info[$v]['wx'] : 0;
            $arr['dd'] = $info[$v]['dd'] ? $info[$v]['dd'] : 0;
            $arr['order'] = $order[$v] ? $order[$v] : 0;
            $arr['yixiao'] = $yixiao[$v] ? $yixiao[$v] : 0;
            $arr['erxiao'] = $erxiao[$v] ? $erxiao[$v] : 0;
            array_push($return,$arr);

            $total['mkz'] += $info[$v]['mkz'];
            $total['valid'] += $info[$v]['valid'];
            $total['wx'] += $info[$v]['wx'];
            $total['dd'] += $info[$v]['dd'];
            $total['order'] += $order[$v];
            $total['yixiao'] += $yixiao[$v];
            $total['erxiao'] += $erxiao[$v];
        }
        $total['yixiao'] = sprintf('%.2f', $total['yixiao']);
        $total['erxiao'] = sprintf('%.2f', $total['erxiao']);
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();
        
        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $staff = controller('crm/Customer','lib')->getShopAllStaff(['shop_code'=>$info['shop_code']]);
        $this->assign('staff', $staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}