<?php
/**
 * 报表实现类 账户充值报表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author:  yuanweibo 2021-05-18
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Qqbaby_account_recharge extends Report {

    private $level=1;
    private $type=3;
    private $code='code1620893220';

    public function getLevel(){
        return $this->level;
    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data(){
        set_time_limit(0);
        $recTime = microtime(true).'<br />';

        $data = input();

        $info = db('crm_s_report_form')->where('code', $data['code'])->field('code,report_name,report_class_name')->find();
        if (!$info || empty($data['code'])) {
            $this->error('没有此报表。');
        }
        $shop_code = $data['shop_code'] ? $data['shop_code'] : session('shop_code');

        $start = $data['start'] ? $data['start'] : date('Y-m-d',strtotime());
        $end = $data['end'] ? $data['end'] : date('Y-m-d',strtotime());

        $start_t = str_replace("-", "", $start);
        $end_t = str_replace("-", "", $end);

        $d1 = strtotime($start);
        $d2 = strtotime($end);
        $Days = round(($d2-$d1)/3600/24);
        if ($Days > 31) {
            $return['code'] = 100;
            $return['msg'] = '日期范围请选择一个月31天内。';
            return json($return);
        }



        $limit = $reason['limit'] ? $reason['limit'] : 10;
        $page = $reason['page'] ? $reason['page'] : 1;
        $result['code'] = 0;
        $result['msg'] = '';
        $date = explode(' - ',$reason['search_time']);
        $where = [];
        $ros = [];
        $costs = [];
        $yue= [];
        $benyue= [];

        if($reason['channel_id']) $where['channel_name'] = ['in',$reason['channel_id']];
        // if($reason['staffname']) $where['add_staff_name'] = ['in',$reason['staffname']];//['in',implode(',',$reason['staffname'])];

        if($reason['city_id']) $where['city_id'] = $reason['city_id'];

        //花费
        $cost = db('crm_s_channel_cost')
            ->where('shop_code',$shop_code)->where($where)->where('cost_date','between',[$start,$end])
            ->field('cost,city_name,channel_name,cost_date')
            ->select();
        foreach ($cost as $key => $value) {
            $costs[$value['city_name'].$value['channel_name'].$value['cost_date']] = $value['cost'];
        }

        //充值
        $res = db('crm_s_channel_recharge')
            ->where('shop_code',$shop_code)->where($where)->where('time','between',[$start,$end])
            ->order('channel_name asc,time asc')
            // ->page($page,$limit)
            ->select();
        $result['sql'] = db()->getlastsql();

        foreach ($res as $key => $value) {
            $ros[$key]['city_name'] = $value['city_name'];
            $ros[$key]['channel_info_name'] = $value['channel_info_name'];
            $ros[$key]['channel_name'] = $value['channel_name'];
            $ros[$key]['add_staff_name'] = $value['add_staff_name'];
            $ros[$key]['time'] = $value['time'];
            $ros[$key]['money'] = $value['money'];
            $ros[$key]['money_fd'] = $value['money_fd'];
            $ros[$key]['add_staff_time'] = substr($value['add_staff_time'], 0,11);

            $ros[$key]['cost'] = $costs[$value['city_name'].$value['channel_name'].$value['time']];

            $benyue[$value['city_name'].$value['channel_name']]['money_by'] += $value['money']+$value['money_fd'];
            $benyue[$value['city_name'].$value['channel_name']]['money_by_cz'] += $value['money'];
            $benyue[$value['city_name'].$value['channel_name']]['money_by_fd'] += $value['money_fd'];

            $ros[$key]['jz_money_ye'] = $value['money'] + $value['money_fd'] - $costs[$value['city_name'].$value['channel_name'].$value['time']]+$yue[$value['city_name'].$value['channel_name']];
            $yue[$value['city_name'].$value['channel_name']] += $value['money'] + $value['money_fd'] - $costs[$value['city_name'].$value['channel_name'].$value['time']];
        }

        foreach ($res as $key => $value) {
            $ros[$key]['money_by'] = $benyue[$value['city_name'].$value['channel_name']]['money_by'];
            $ros[$key]['money_by_cz'] = $benyue[$value['city_name'].$value['channel_name']]['money_by_cz'];
            $ros[$key]['money_by_fd'] = $benyue[$value['city_name'].$value['channel_name']]['money_by_fd'];
        }

        $count = db('crm_s_channel_recharge')->where('shop_code',session('shop_code'))->where($where)->where('time','between',[$start,$end])->count();

        $result['data'] = $ros;
        $result['count'] = $count;
        
        return ($result);
    }
    public function show(){
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->where('code', $menu_code)->field('code,report_name,report_class_name')->find();
        if (!$info) {
            $this->error('没有此报表。');
        }

        $shop_code = session('shop_code');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
        // 来源渠道
        $channel = getChannelJson($shop_code);
        $this->assign("channel", json_encode($channel));
        // crm省 列表
        $data['type']=1;
        $data['shop_code']= $shop_code;
        $province=controller("crm/Customer","lib")->address($data);
        $this->assign("province",$province);
        // 只有一个省 查这个省下的城市
        if (count($province)==1) {
            $data['type'] = 2;
            $data['pid']  = $province[0]['id'];
            $staCity = controller("crm/Customer", "lib")->address($data);
            $this->assign("staCity",$staCity);
        }


        $mc = new \app\common\lib\mcInterface();

        $staffParam['department_id'] = $departmentId;
        $staffParam['get_main'] = 1;
        // 登记人
        $djStaffList = $mc->getStaffByDepartment($staffParam);
        $this->assign("djStaffList",$djStaffList);

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';

        $this->assign('title', $shop[0]['shop_name'].'-'.$info['report_name']);
        $this->assign('code', $info['code']);
        // 默认本月
        $this->assign('start', date('Y-m-01'));
        $this->assign('end', date('Y-m-d'));
        return $this->fetch($display);
    }

}