<?php
/**
 * 报表实现类 客资订单统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Wl_channel_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568859075';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        //可操作店
        if($data['shop_code']){
            $shop_code = $data['shop_code'];
        }elseif($det['shop_code']){
            $shop_code = $det['shop_code'];
        }else{
            $shop_code = session('shop_code');
        }
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));

        //渠道
        $channel = controller('crm/Customer','lib')->getChannel($shop_code);
        $channel_datas = array_column($channel, 'channel_info_name');
        asort($channel_datas);
        $channelData = [];
        foreach($channel_datas as $key=>$value){
            $channelData[] = $channel[$key];
        }
        $channel_name = array_column($channel,'channel_name');
        $sql = "sum(dj_day between '".$start."' and '".$end."') as mkz,";//总录入
        $sql .= "sum(is_valid=1 and dj_day between '".$start."' and '".$end."') as valid,";//有效
        $sql .= "sum(is_valid=3 and dj_day between '".$start."' and '".$end."') as wx,";//无效
        $sql .= "sum(is_valid in ('2,','4','5') and dj_day between '".$start."' and '".$end."') as dd";//待定
        $cost = db('crm_s_channel_cost')
            ->where('shop_code',$shop_code)
            ->where('cost_date','in',[$start,$end])
            ->group('channel_name')
            ->column('sum(cost)','channel_name');
        $info= db('crm_c_customerinfo')
            ->where('add_shop_code',$shop_code)
            ->where('customer_channel', 'in',$channel_name)
            ->group('customer_channel')
            ->column($sql,'customer_channel');
        $order = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')
            ->where('c.add_shop_code',$shop_code)
            ->where('c.customer_channel', 'in',$channel_name)
            ->where('o.targetdate','between',[$start_erp,$end_erp])
            ->group('c.customer_channel')
            ->column('count(o.id)','c.customer_channel');
        $yx_amount = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')
            ->where('c.add_shop_code',$shop_code)
            ->where('c.customer_channel', 'in',$channel_name)
            ->where('o.targetdate','between',[$start_erp,$end_erp])
            ->group('c.customer_channel')
            ->column('sum(o.bargain_money)','c.customer_channel');
        $ex_amount = db('crm_c_customerinfo')->alias('c')->join('c_customerorder o','c.customer_number=o.crm_customer_number','LEFT')
            ->where('c.add_shop_code',$shop_code)
            ->where('c.customer_channel', 'in',$channel_name)
            ->where('o.targetdate','between',[$start_erp,$end_erp])
            ->group('c.customer_channel')
            ->column('sum(o.supplementary_money)','c.customer_channel');
        $return = [];
        $total['channel'] = '总计';
        foreach($channelData as $k=>$v){
            $arr = [];
            $arr['channel_info_name'] = $v['channel_info_name'];
            $arr['channel'] = $v['channel_name'];
            $arr['cost'] = $cost['channel_name'];
            $arr['mkz'] = $info[$v['channel_name']]['mkz'] ? $info[$v['channel_name']]['mkz'] : 0;
            $arr['valid'] = $info[$v['channel_name']]['valid'] ? $info[$v['channel_name']]['valid'] : 0;
            $arr['wx'] = $info[$v['channel_name']]['wx'] ? $info[$v['channel_name']]['wx'] : 0;
            $arr['dd'] = $info[$v['channel_name']]['dd'] ? $info[$v['channel_name']]['dd'] : 0;
            $arr['order'] = $order[$v['channel_name']] ? $order[$v['channel_name']] : 0;
            $arr['yixiao'] = $yx_amount[$v['channel_name']] ? $yx_amount[$v['channel_name']] : 0;
            $arr['erxiao'] = $ex_amount[$v['channel_name']] ? $ex_amount[$v['channel_name']] : 0;
            //有效率
            $arr['validRate'] = sprintf('%.2f',($arr['valid']+$arr['dd'])/$arr['mkz']*100).'%';
            //成交率
            $arr['orderRate'] = sprintf('%.2f',$arr['order']/($arr['mkz']+$arr['wx'])*100).'%';
            array_push($return,$arr);

            $total['mkz'] += $info[$v['channel_name']]['mkz'];
            $total['valid'] += $info[$v['channel_name']]['valid'];
            $total['wx'] += $info[$v['channel_name']]['wx'];
            $total['dd'] += $info[$v['channel_name']]['dd'];
            $total['order'] += $order[$v['channel_name']];
            $total['yixiao'] += $yx_amount[$v['channel_name']];
            $total['erxiao'] += $ex_amount[$v['channel_name']];
        }
        $total['yixiao'] = sprintf('%.2f', $total['yixiao']);
        $total['erxiao'] = sprintf('%.2f', $total['erxiao']);
        //有效率
        $total['validRate'] = sprintf('%.2f',($total['valid']+$total['dd'])/$total['mkz']*100).'%';
        //成交率
        $total['orderRate'] = sprintf('%.2f',$total['order']/($total['mkz']+$total['wx'])*100).'%';
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);

        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}