<?php
/**
 * 报表实现类 小阿福客资统计
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_customer_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568187511';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();

        $info = db('crm_s_report_form')->where('code', $data['code'])->field('code,report_name,report_class_name')->find();
        if (!$info || empty($data['code'])) {
            $this->error('没有此报表。');
        }
        $shop_code = $data['shop_code'] ? $data['shop_code'] : session('shop_code');
        $w_shop_code = $data['w_shop_code'] ?: $shop_code;

        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));


        $method = $data['method'];
        $where['c_from'] = 1;
        $where['is_status'] = 1;
        $where['is_loss'] = 2;

        if($method == 'sales'){
            $shop_where['c.shop_code'] = ['in',$w_shop_code];

            //店下人员
            $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
            $staffIds = array_column($staff,'id');
            if($data['staff_id']){
                $where['sales_staff_id'] = ['in',$data['staff_id']];//intval($data['staff_id']);//
            }else{
                $where['sales_staff_id'] = ['in',$staffIds];
            }

            // if($data['staff_id']){
            //     $where['sales_staff_id'] = ['in',$data['staff_id']];//intval($data['staff_id']);//
            //     $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>$data['staff_id']]);
            // }else{
            //     //店下人员
            //     $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
            //     $staffIds = array_column($staff,'id');
            //     $where['sales_staff_id'] = ['in',$staffIds];
            // }
            $group = 'sales_staff_id';
        }else{
            $shop_where['c.add_shop_code'] = $shop_code;
            if($data['staff_id']){
                $where['dj_staff_id'] = ['in',$data['staff_id']];//intval($data['staff_id']);//
                $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>$data['staff_id']]);
            }else{
                //店下人员
                $staff = controller('crm/Customer','lib')->get_staff_lists(['shop_code'=>$shop_code]);
                $staffIds = array_column($staff,'id');
                $where['dj_staff_id'] = ['in',$staffIds];
            }
            $group = 'dj_staff_id';
        }
        if(count($data['staff_id']) > 0){
            foreach ($staff as $key => $value) {
                if (!in_array($value['id'], $data['staff_id'])) {
                    unset($staff[$key]);
                }
            }
        }
        $returnData['staff'] = $staff;

        // 第一部分 客资
        $sql = '';
        $sql .= "sum(c.sign_name='".YILEI."' and baby_birthday between '".$start."' and '".$end."') as `all_yilei`,";//一类
        $sql .= "sum(c.sign_name='".ERLEI."' and baby_birthday between '".$start."' and '".$end."') as `all_erlei`,";//二类
        $sql .= "sum(c.sign_name='".SANLEI."' and baby_birthday between '".$start."' and '".$end."') as `all_sanlei`,";//三类
        $sql .= "sum(c.is_valid=3 and c.baby_birthday between '".$start."' and '".$end."') as `all_wuxiao`,";//无效
        $sql .= "sum(c.sign_name='".MINGDAN."' and baby_birthday between '".$start."' and '".$end."') as `all_mingdan`,";//出生名单
        $sql .= "sum(c.sign_name='".YUCHANAQI."' and ready_baby_day between '".$start."' and '".$end."') as `all_yuchanqi`";//预产期
        $cus_info = db('crm_c_customerinfo')->alias('c')
            ->where($where)->where($shop_where)
            ->group($group)
            ->column($sql,$group);
        $returnData['sql_cus_info'] = db()->getlastsql();
        // 第二部分 一类
        // 拍摄量=上门成功量（根据上上门时间统计）；成交量=本次上门中收款大于899；业绩=本次上门产生的实际收款，根据上门时间统计
        unset($shop_where);
        $shop_where['l.pc_shop_code'] = ['in',$w_shop_code];
        $where['is_delete'] = 2;
        $yi_sm = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',YILEI)->where('`l`.`status`', 'in','2,3')
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(l.id) AS photo',$group);
        $returnData[YILEI.'拍摄量'] = db()->getlastsql();
        $yi_order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',YILEI)->where('o.payment_money','>=','899')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(o.id) AS `order`',$group);
        $returnData[YILEI.'成交量'] = db()->getlastsql();
        $yi_fact = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',YILEI)->where('o.payment_money','>','0')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('SUM(p.payment_money) AS paymoney',$group);
        $returnData[YILEI.'业绩'] = db()->getlastsql();
        // 第三部分 二类
        $er_sm = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',ERLEI)->where('`l`.`status`', 'in','2,3')
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(l.id) AS photo',$group);
        $er_order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',ERLEI)->where('o.payment_money','>=','899')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(o.id) AS `order`',$group);
        $er_fact = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',ERLEI)->where('o.payment_money','>','0')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('SUM(p.payment_money) AS paymoney',$group);
        // 第四部分 三类
        $san_sm = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',SANLEI)->where('`l`.`status`', 'in','2,3')
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(l.id) AS photo',$group);
        $san_order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',SANLEI)->where('o.payment_money','>=','899')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(o.id) AS `order`',$group);
        $san_fact = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',SANLEI)->where('o.payment_money','>','0')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('SUM(p.payment_money) AS paymoney',$group);
        // 第五部分 出生名单
        $md_sm = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',MINGDAN)->where('`l`.`status`', 'in','2,3')
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(l.id) AS photo',$group);
        $md_order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',MINGDAN)->where('o.payment_money','>=','899')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(o.id) AS `order`',$group);
        $md_fact = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',MINGDAN)->where('o.payment_money','>','0')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('SUM(p.payment_money) AS paymoney',$group);
        // 第六部分 预产期
        $ycq_sm = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',YUCHANAQI)->where('`l`.`status`', 'in','2,3')
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(l.id) AS photo',$group);
        $ycq_order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',YUCHANAQI)->where('o.payment_money','>=','899')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(o.id) AS `order`',$group);
        $ycq_fact = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','拍摄')->where($shop_where)
            ->where('c.sign_name',YUCHANAQI)->where('o.payment_money','>','0')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('SUM(p.payment_money) AS paymoney',$group);
        // 第六部分 理发
        $lf_sm = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->where($where)->where('l.sm_type','理发')->where($shop_where)
            ->where('c.sign_name',YUCHANAQI)->where('`l`.`status`', 'in','2,3')
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(l.id) AS photo',$group);
        $lf_order = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','理发')->where($shop_where)
            ->where('c.sign_name',YUCHANAQI)->where('o.payment_money','>=','899')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('COUNT(o.id) AS `order`',$group);
        $lf_fact = db('crm_c_customerinfo')->alias('c')
            ->join('crm_l_pc_log l','c.id=l.cid', 'left')
            ->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->join('c_paymentcontent p','p.orderId=o.orderId','LEFT')
            ->join('c_paymenttype t','p.paytype=t.typename','LEFT')
            ->where($where)->where('l.sm_type','理发')->where($shop_where)
            ->where('c.sign_name',YUCHANAQI)->where('o.payment_money','>','0')
            // ->where('p.suoshu','in','前期款,前期补款')
            ->where('t.typecode','实收')->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('SUM(p.payment_money) AS paymoney',$group);
        //取消量
        $cancel = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where($where)->where($shop_where)
            ->where('l.pc_time','between',[$start,$end])
            ->where('`l`.`status`',4)
            ->group($group)
            ->column('count(l.id)',$group);
        $returnData['取消量'] = db()->getlastsql();
        //入户量
         $ruhu = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where($where)->where($shop_where)
            ->where('l.pc_time','between',[$start,$end])
            ->where('`l`.`status`','in',[2,3])
             ->group($group)
            ->column('count(l.id)',$group);
        $returnData['入户量'] = db()->getlastsql();
        //预约量
         $yy = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')
            ->where($where)->where($shop_where)
            ->where('l.pc_time','between',[$start,$end])
            ->group($group)
            ->column('count(l.id)',$group);
        $returnData['预约量'] = db()->getlastsql();

        $return = [];
        $total['staff_name'] = '总计';
        foreach($staff as $k=>$v){
            $arr = [];
            // 员工账号
            $arr['staff_id'] = $v['id'];
            $arr['staff_name'] = $v['staffname'];
            // 客资
            $arr['cus_yi'] = $cus_info[$v['id']]['all_yilei'] ? $cus_info[$v['id']]['all_yilei'] : '0';
            $arr['cus_er'] = $cus_info[$v['id']]['all_erlei'] ? $cus_info[$v['id']]['all_erlei'] : '0';
            $arr['cus_san'] = $cus_info[$v['id']]['all_sanlei'] ? $cus_info[$v['id']]['all_sanlei'] : '0';
            $arr['cus_wx'] = $cus_info[$v['id']]['all_wuxiao'] ? $cus_info[$v['id']]['all_wuxiao'] : '0';
            $arr['cus_name'] = $cus_info[$v['id']]['all_mingdan'] ? $cus_info[$v['id']]['all_mingdan'] : '0';
            $arr['cus_ready'] = $cus_info[$v['id']]['all_yuchanqi'] ? $cus_info[$v['id']]['all_yuchanqi'] : '0';
            // 一类
            $arr['yi_ps'] = $yi_sm[$v['id']] ? $yi_sm[$v['id']] : '0';
            $arr['yi_cj'] = $yi_order[$v['id']] ? $yi_order[$v['id']] : '0';
            $arr['yi_amount'] = $yi_fact[$v['id']] ? $yi_fact[$v['id']] : '0';
            // 二类
            $arr['er_ps'] = $er_sm[$v['id']] ? $er_sm[$v['id']] : '0';
            $arr['er_cj'] = $er_order[$v['id']] ? $er_order[$v['id']] : '0';
            $arr['er_amount'] = $er_fact[$v['id']] ? $er_fact[$v['id']] : '0';
            // 二类
            $arr['san_ps'] = $san_sm[$v['id']] ? $san_sm[$v['id']] : '0';
            $arr['san_cj'] = $san_order[$v['id']] ? $san_order[$v['id']] : '0';
            $arr['san_amount'] = $san_fact[$v['id']] ? $san_fact[$v['id']] : '0';
            // 出生名单
            $arr['birthday_ps'] = $md_sm[$v['id']] ? $md_sm[$v['id']] : '0';
            $arr['birthday_cj'] = $md_order[$v['id']] ? $md_order[$v['id']] : '0';
            $arr['birthday_amount'] = $md_fact[$v['id']] ? $md_fact[$v['id']] : '0';
            // 预产期
            $arr['ready_ps'] = $ycq_sm[$v['id']] ? $ycq_sm[$v['id']] : '0';
            $arr['ready_cj'] = $ycq_order[$v['id']] ? $ycq_order[$v['id']] : '0';
            $arr['ready_amount'] = $ycq_fact[$v['id']] ? $ycq_fact[$v['id']] : '0';
            // 理发
            $arr['lifa_ps'] = $lf_sm[$v['id']] ? $lf_sm[$v['id']] : '0';
            $arr['lifa_cj'] = $lf_order[$v['id']] ? $lf_order[$v['id']] : '0';
            $arr['lifa_amount'] = $lf_fact[$v['id']] ? $lf_fact[$v['id']] : '0';
            // 取消量
            $arr['cancel'] = $cancel[$v['id']] ? $cancel[$v['id']] : '0';
            // 入户量
            $arr['rh'] = $ruhu[$v['id']] ? $ruhu[$v['id']] : '0';
            // 预约量
            $arr['pc'] = $yy[$v['id']] ? $yy[$v['id']] : '0';

            // 有效客资入户(一二三类，拍摄量相加)
            $arr['valid'] = $arr['yi_ps']+$arr['er_ps']+$arr['san_ps'];
            // 个人入户率 =入户量/预约量
            $arr['rate'] = (sprintf('%.2f',$arr['rh']/$arr['pc'])*100).'%';
            // 名单入户(出生名单、预产期，拍摄量相加)
            $arr['name'] = $arr['birthday_ps']+$arr['ready_ps'];
            // 业绩 (一二三类、出生名单、预产期、业绩之和)
            $arr['amount'] = $arr['yi_amount']+$arr['er_amount']+$arr['san_amount']+$arr['birthday_amount']+$arr['ready_amount'];

            array_push($return,$arr);

            $total['valid'] += $arr['valid'];
            $total['name'] += $arr['name'];
            $total['amount'] += $arr['amount'];
            $total['cus_yi'] += $arr['cus_yi'];
            $total['cus_er'] += $arr['cus_er'];
            $total['cus_san'] += $arr['cus_san'];
            $total['cus_wx'] += $arr['cus_wx'];
            $total['cus_name'] += $arr['cus_name'];
            $total['cus_ready'] += $arr['cus_ready'];

            $total['yi_ps'] += $arr['yi_ps'];
            $total['yi_cj'] += $arr['yi_cj'];
            $total['yi_amount'] += $arr['yi_amount'];

            $total['er_ps'] += $arr['er_ps'];
            $total['er_cj'] += $arr['er_cj'];
            $total['er_amount'] += $arr['er_amount'];

            $total['san_ps'] += $arr['san_ps'];
            $total['san_cj'] += $arr['san_cj'];
            $total['san_amount'] += $arr['san_amount'];

            $total['birthday_ps'] += $arr['birthday_ps'];
            $total['birthday_cj'] += $arr['birthday_cj'];
            $total['birthday_amount'] += $arr['birthday_amount'];

            $total['ready_ps'] += $arr['ready_ps'];
            $total['ready_cj'] += $arr['ready_cj'];
            $total['ready_amount'] += $arr['ready_amount'];

            $total['lifa_ps'] += $arr['lifa_ps'];
            $total['lifa_cj'] += $arr['lifa_cj'];
            $total['lifa_amount'] += $arr['lifa_amount'];

            $total['cancel'] += $arr['cancel'];
            $total['rh'] += $arr['rh'];
            $total['pc'] += $arr['pc'];
        }
        // $total['rate'] = sprintf('%.2f',array_sum(array_column($info,'ruhu'))/array_sum(array_column($info,'all'))*100).'%';
        $total['rate'] = (sprintf('%.2f',$total['rh']/$total['pc'])*100).'%';
        array_push($return,$total);

        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        $returnData['shop'] = controller('crm/Customer','lib')->get_shop(['shop_code'=>$shop_code]);
        return json($returnData);
    }

    public function show(){
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->where('code', $menu_code)->field('code,report_name,report_class_name')->find();
        if (!$info) {
            $this->error('没有此报表。');
        }

        $shop_code = session('shop_code');

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';

        $where_shop_code = $shop_code.",xaf002,xaf021,xaf022,xaf023";//追踪店面 选取范围 "爱婴总部","爱婴一部","爱婴二部","爱婴三部"
        $w_shop_code= controller('crm/Customer','lib')->get_shop(['shop_code'=>$where_shop_code]);
        $this->assign('w_shop_code', $w_shop_code);
        $this->assign('shop_code', $shop_code);
        // $staff = controller('crm/Customer','lib')->getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
        $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>21]);
        $this->assign('staff', $staff);
        
        $this->assign('title', session('shop_name').'-'.$info['report_name']);
        $this->assign('code', $info['code']);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}