<?php
/**
 * 报表实现类 小阿福爱婴部日报表
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: wangzhenya 2019-09-10 $
 */
namespace app\crm\lib\report;
use app\crm\lib\Report;
use think\Controller;
use think\image\Exception;

class Xaf_customer_day_data extends Report {

    private $level=1;
    private $type=1;
    private $code='code1568287511';

    public function getLevel(){
        return $this->level;

    }
    public function getType(){
        return $this->type;
    }
    public function getCode(){
        return $this->code;
    }
    public function data()
    {
        set_time_limit(0);
        $data = input();
        $det = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$data['did'])->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name,f.report_name')->find();
        $shop_code = $det['shop_code'];
        if(empty($shop_code)){
            return array('code'=>100,'msg'=>'报表配置有误');
        }
        $start = $data['start'] ? date('Y-m-d', strtotime($data['start'])) : date('Y-m-d 00:00:00');
        $end =  $data['end'] ? date('Y-m-d 23:59:59', strtotime($data['end'])) : date('Y-m-d 23:59:59');
        $start_erp = date('Ymd', strtotime($data['start']));
        $end_erp = date('Ymd', strtotime($data['end']));

        $where['c_from'] = 1;
        $where['is_status'] = 1;

        $where['l.shop_code'] = $shop_code;
        if($data['staff_id']){
            $where['l.tutor_id'] = intval($data['staff_id']);
            $staff = controller('crm/Customer','lib')->get_staff_list(['id'=>intval($data['staff_id'])]);
        }else{
            //店下人员
            $staff = getStaffsByWorkType(['shop_code'=>$shop_code,'work_type'=>25]);
            $staffIds = array_column($staff,'id');
            $where['l.tutor_id'] = ['in',$staffIds];
        }
        $group = 'l.tutor_id';

        $sql = '';
        $sql .= "sum(sm_type='拍摄' and pc_time between '".$start."' and '".$end."') as `photo`,";//拍照
        $sql .= "sum(sm_type='拍摄' and status=2 and  pc_time between '".$start."' and '".$end."') as photo_succ,";//拍照成交
        $sql .= "sum(sm_type='理发' and pc_time between '".$start."' and '".$end."') as lifa,";//理发
        $sql .= "sum(sm_type='理发' and status=2 and pc_time between '".$start."' and '".$end."') as `lifa_succ`";//理发成交
        $info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')
            ->where($where)
            ->group($group)
            ->column($sql,$group);
        $sql1 = db()->getLastSql();
        //三宝
        $sanbao_sql = '';
        $sanbao_sql .= "sum(sm_type='理发' and pc_time between '".$start."' and '".$end."') as sanbao_lifa,";//理发
        $sanbao_sql .= "sum(sm_type='纪念品' and status=2 and pc_time between '".$start."' and '".$end."') as `sanbao_jinianpin`,";//纪念品
        $sanbao_sql .= "sum(is_chaoju=1 and pc_time between '".$start."' and '".$end."') as `sanbao_youfei`";//油费
        $sanbao_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->where($where)
            ->where('o.consumption_type','三宝')
            ->group($group)
            ->column($sanbao_sql,$group);
        $sql2 = db()->getLastSql();
        //三宝收款
        $sanbao_xianjin_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','现金')
            ->where('o.consumption_type','三宝')
            ->group($group)
            ->column('sum(p.payment_money)',$group);
        $sql3 = db()->getLastSql();
        $sanbao_shuaka_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','刷卡')
            ->where('o.consumption_type','三宝')
            ->group($group)
            ->column('sum(p.payment_money)',$group);
        $sql4 = db()->getLastSql();
        $sanbao_kaxiao_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','VIP卡')
            ->where('o.consumption_type','三宝')
            ->group($group)
            ->column('sum(p.payment_money)',$group);
        $sql5 = db()->getLastSql();
        //三宝之外
        //摄影师
        $not_sanbao_camera = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->where($where)
            ->where('l.pc_time','between',[$start,$end])
            ->where('o.consumption_type','<>','三宝')
            ->group($group)
            ->column('cameraman_name',$group);
        $sql6 = db()->getLastSql();
        //摄影业绩
        $not_sanbao_fact = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')
            ->where($where)
            ->where('o.consumption_type','<>','三宝')
            ->where('o.targetdate','between',[$start_erp,$end_erp])
            ->group($group)
            ->column('sum(o.bargain_money)',$group);
        $sql7 = db()->getLastSql();
        //三宝之外收款
        $not_sanbao_xianjin_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','现金')
            ->where('o.consumption_type','<>','三宝')
            ->group($group)
            ->column('sum(p.payment_money)',$group);
        $sql8 = db()->getLastSql();
        $not_sanbao_shuaka_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','刷卡')
            ->where('o.consumption_type','<>','三宝')
            ->group($group)
            ->column('sum(p.payment_money)',$group);
        $sql9 = db()->getLastSql();
        $not_sanbao_kaxiao_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','VIP卡')
            ->where('o.consumption_type','<>','三宝')
            ->group($group)
            ->column('sum(p.payment_money)',$group);
        $sql10 = db()->getLastSql();
        //当日充值
        $not_sanbao_fact_info = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_viprecharge_arrears v','o.orderId=v.orderId','left')
            ->where($where)
            ->where('o.consumption_type','<>','三宝')
            ->where('v.paymentdate','between',[$start_erp,$end_erp])
            ->group($group)
            ->column('sum(v.payment_money)',$group);
        $sql11 = db()->getLastSql();
        //派单总数
        $paidan = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','LEFT')
            ->where($where)
            ->group($group)
            ->column('count(l.id)',$group);
        $sql12 = db()->getLastSql();
        //收款合计
        $xianjin_fact = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','现金')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->group($group)
            ->column('p.payment_money',$group);
        $sql13 = db()->getLastSql();
        $shuaka_fact = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','刷卡')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->group($group)
            ->column('p.payment_money',$group);
        $sql14 = db()->getLastSql();
        $kaxiao_fact = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_paymentcontent p','p.orderId=o.orderId','left')
            ->where($where)
            ->where('paytype','VIP卡')
            ->where('p.paymentdate','between',[$start_erp,$end_erp])
            ->group($group)
            ->column('p.payment_money',$group);
        $sql15 = db()->getLastSql();
        //卡余
         $kayu = db('crm_c_customerinfo')->alias('c')->join('crm_l_pc_log l','c.id=l.cid','left')->join('c_customerorder o','l.id=o.crm_visit_id','LEFT')->join('c_vipcardinfo v','o.orderId=v.orderId','left')
            ->where($where)
            ->where('l.pc_time','between',[$start,$end])
             ->group($group)
            ->column('sum(v.cardmoney)',$group);
        $sql16 = db()->getLastSql();

        $return = [];
        $total['staff_name'] = '总计';
        foreach($staff as $k=>$v){
            $arr = [];
            $arr['staff_name'] = $v['staffname'];
            $arr['photo'] = $info[$v['id']]['photo'] ? $info[$v['id']]['photo'] : '';
            $arr['photo_succ'] = $info[$v['id']]['photo_succ'] ? $info[$v['id']]['photo_succ'] : '';
            $arr['lifa'] = $info[$v['id']]['lifa'] ? $info[$v['id']]['lifa'] : '';
            $arr['lifa_succ'] = $info[$v['lifa_succ']] ? $info[$v['lifa_succ']] : '';
            $arr['shouhou'] = $info[$v['shouhou']] ? $info[$v['shouhou']] : '';

            $arr['sanbao_lifa'] = $sanbao_info[$v['id']]['lifa'] ? $sanbao_info[$v['id']]['lifa'] : '';
            $arr['sanbao_jinianpin'] = $sanbao_info[$v['id']]['jinianpin'] ? $sanbao_info[$v['id']]['jinianpin'] : '';
            $arr['sanbao_youfei'] = $sanbao_info[$v['id']]['youfei'] ? $sanbao_info[$v['id']]['youfei'] : '';

            $arr['sanbao_xianjin'] = $sanbao_xianjin_fact_info[$v['id']] ? $sanbao_xianjin_fact_info[$v['id']] : '';
            $arr['sanbao_shuaka'] = $sanbao_shuaka_fact_info[$v['id']] ? $sanbao_shuaka_fact_info[$v['id']] : '';
            $arr['sanbao_kaxiao'] = $sanbao_kaxiao_fact_info[$v['id']] ? $sanbao_kaxiao_fact_info[$v['id']] : '';

            $arr['sanbao_laoka'] =  '';
            $arr['sign'] =  '';
            $arr['huizhi'] =  '';

            $arr['cameraman'] = $not_sanbao_camera[$v['id']] ? $not_sanbao_camera[$v['id']] : '';
            $arr['photo_amount'] = $not_sanbao_fact[$v['id']] ? $not_sanbao_fact[$v['id']] : '';

            $arr['not_sanbao_xianjin'] = $not_sanbao_shuaka_fact_info[$v['id']] ? $not_sanbao_shuaka_fact_info[$v['id']]: '';
            $arr['not_sanbao_shuaka'] = $not_sanbao_shuaka_fact_info[$v['id']] ? $not_sanbao_shuaka_fact_info[$v['id']] : '';
            $arr['not_sanbao_kaxiao'] = $not_sanbao_kaxiao_fact_info[$v['id']] ? $not_sanbao_kaxiao_fact_info[$v['id']] : '';

            $arr['paidan'] = $paidan[$v['id']] ? $paidan[$v['id']] : '';

            $arr['xianjin'] = $xianjin_fact[$v['id']] ? $xianjin_fact[$v['id']] : '';
            $arr['shuaka'] = $shuaka_fact[$v['id']] ? $shuaka_fact[$v['id']] : '';
            $arr['kaxiao'] = $kaxiao_fact[$v['id']] ? $kaxiao_fact[$v['id']] : '';


            $arr['laoka'] = '';
            $arr['kayu'] = $kayu[$v['id']] ? $kayu[$v['id']] : '';
            array_push($return,$arr);

            $total['photo'] += $info[$v['id']]['photo'];
            $total['photo_succ'] += $info[$v['id']]['photo_succ'];
            $total['lifa'] += $info[$v['id']]['lifa'];
            $total['lifa_succ'] += $info[$v['id']]['lifa_succ'];
            $total['shouhou'] = '';
            $total['sanbao_lifa'] += $sanbao_info[$v['id']]['sanbao_lifa'];
            $total['sanbao_jinianpin'] += $sanbao_info[$v['id']]['sanbao_jinianpin'];
            $total['sanbao_youfei'] += $sanbao_info[$v['id']]['sanbao_youfei'];
            $total['sanbao_xianjin'] += $sanbao_xianjin_fact_info[$v['id']];
            $total['sanbao_shuaka'] += $sanbao_shuaka_fact_info[$v['id']];
            $total['sanbao_kaxiao'] += $sanbao_kaxiao_fact_info[$v['id']];
            $total['sanbao_laoka'] = '';

            $total['sign'] = '';
            $total['huizhi'] = '';
            $total['cameraman'] = $not_sanbao_camera[$v['id']];

            $total['photo_amount'] += $not_sanbao_fact[$v['id']];
            $total['not_sanbao_xianjin'] += $not_sanbao_xianjin_fact_info[$v['id']];
            $total['not_sanbao_shuaka'] += $not_sanbao_shuaka_fact_info[$v['id']];
            $total['not_sanbao_kaxiao'] += $not_sanbao_kaxiao_fact_info[$v['id']];

            $total['paidan'] += $paidan[$v['id']];

            $total['xianjin'] += $xianjin_fact[$v['id']];
            $total['shuaka'] += $shuaka_fact[$v['id']];
            $total['kaxiao'] += $kaxiao_fact[$v['id']];

            $total['laoka'] = '';
            $total['kayu'] += $kayu[$v['id']];
        }
        array_push($return,$total);

        $returnData['sql1'] = $sql1;
        $returnData['sql2'] = $sql2;
        $returnData['sql3'] = $sql3;
        $returnData['sql4'] = $sql4;
        $returnData['sql5'] = $sql5;
        $returnData['sql6'] = $sql6;
        $returnData['sql7'] = $sql7;
        $returnData['sql8'] = $sql8;
        $returnData['sql9'] = $sql9;
        $returnData['sql10']= $sql10;
        $returnData['sql11']= $sql11;
        $returnData['sql12']= $sql12;
        $returnData['sql13']= $sql13;
        $returnData['sql14']= $sql14;
        $returnData['sql15']= $sql15;
        $returnData['sql16']= $sql16;
        $returnData['code'] = 0;
        $returnData['msg'] = '';
        $returnData['count'] = count($return);
        $returnData['data'] = $return;
        return json($returnData);
    }

    public function show(){
        $code = $this->getCode();
        /*
        $did = strtolower(input('param.did'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id')->where('d.id',$did)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();*/
        $menu_code = strtolower(input('param.menu_code'));
        $info = db('crm_s_report_form')->alias('f')->join('crm_s_report_detail d','d.form_id=f.id','left')->where('f.code',$menu_code)->field('d.id,d.shop_code,d.brandclass_id,f.report_class_name')->find();

        $display = APP_PATH.'crm'.DS.'view'.DS.'report'.DS.strtolower($info['report_class_name']).'.html';
        $title = db('crm_s_report_form')->where('code', $code)->value('report_name');
        $shop= controller('crm/Customer','lib')->get_shop(['shop_code'=>$info['shop_code']]);
        $staff = getStaffsByWorkType(['shop_code'=>$info['shop_code'],'work_type'=>25]);
        $this->assign('shop_code', $info['shop_code']);
        $this->assign('staff', $staff);
        $this->assign('title', $shop[0]['shop_name'].'-'.$title);
        $this->assign('did', $info['id']);
        return $this->fetch($display);
    }

}