/*
Navicat MySQL Data Transfer

Source Server         : wamp
Source Server Version : 50719
Source Host           : localhost:3306
Source Database       : 01bz_sx_crm_logs

Target Server Type    : MYSQL
Target Server Version : 50719
File Encoding         : 65001

Date: 2019-02-13 17:28:42
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for action_log
-- ----------------------------
DROP TABLE IF EXISTS `action_log`;
CREATE TABLE `action_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `module` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模块名称',
  `controller` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '是哪个控制器的',
  `action` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '进行的操作名称-',
  `old_data` text COLLATE utf8_unicode_ci,
  `data` text COLLATE utf8_unicode_ci COMMENT '操作的数据项',
  `customer_id` int(11) DEFAULT NULL COMMENT '操作所关联的客户编号',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作的员工姓名',
  `staff_id` int(11) DEFAULT NULL COMMENT '操作的员工主键',
  `ip` varchar(64) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作客户的IP，如果是接口，则需要调用端转证customer_ip',
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `create_time` datetime DEFAULT NULL COMMENT '添加时间',
  `delete_time` datetime DEFAULT NULL COMMENT '删除时间',
  PRIMARY KEY (`id`),
  KEY `controller` (`controller`) USING BTREE,
  KEY `customer_id` (`customer_id`) USING BTREE,
  KEY `action` (`action`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='记录系统内所有操作日志信息';

-- ----------------------------
-- Records of action_log
-- ----------------------------

-- ----------------------------
-- Table structure for api_logs
-- ----------------------------
DROP TABLE IF EXISTS `api_logs`;
CREATE TABLE `api_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hash` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `api_url` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `result_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` longtext COLLATE utf8_unicode_ci,
  `api_start_time` decimal(16,5) DEFAULT NULL,
  `api_end_time` decimal(16,5) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of api_logs
-- ----------------------------

-- ----------------------------
-- Table structure for request_logs
-- ----------------------------
DROP TABLE IF EXISTS `request_logs`;
CREATE TABLE `request_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `request_data` longtext COLLATE utf8_unicode_ci,
  `request_url` text COLLATE utf8_unicode_ci,
  `response_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `response_data` longtext COLLATE utf8_unicode_ci,
  `request_start_time` decimal(16,5) DEFAULT NULL,
  `request_end_time` decimal(16,5) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `response_code` (`response_code`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of request_logs
-- ----------------------------
