-- --------------------------------------------------------
-- 主机:                           127.0.0.1
-- 服务器版本:                        5.7.9 - MySQL Community Server (GPL)
-- 服务器操作系统:                      Win64
-- HeidiSQL 版本:                  9.4.0.5125
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


-- 导出  表 sx_crm.api_app 结构
DROP TABLE IF EXISTS `api_app`;
CREATE TABLE IF NOT EXISTS `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext COLLATE utf8_unicode_ci NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='appId和appSecret表';

-- 正在导出表  sx_crm.api_app 的数据：~4 rows (大约)
DELETE FROM `api_app`;
/*!40000 ALTER TABLE `api_app` DISABLE KEYS */;
INSERT INTO `api_app` (`id`, `app_id`, `app_secret`, `app_name`, `app_status`, `app_type`, `app_info`) VALUES
	(2, '40021838', 'byXNdRswuGquIevGyqYWVxStdjlUXOfo', 'test', 1, 1, 'test'),
	(3, '94201193', 'DCGJduSGIceYUFNtWloBzzXhShXERsqH', '管理中心APP', 1, 1, ''),
	(4, '44793168', 'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv', '客资系统', 1, 1, '客资CRM系统'),
	(5, '93816470', 'bVZhrmmaDldMexiWarSftRjVeJkcWvbX', 'erp系统接口', 1, 1, 'erp系统接口');
/*!40000 ALTER TABLE `api_app` ENABLE KEYS */;

-- 导出  表 sx_crm.api_fields 结构
DROP TABLE IF EXISTS `api_fields`;
CREATE TABLE IF NOT EXISTS `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=226 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用于保存各个API的字段规则';

-- 正在导出表  sx_crm.api_fields 的数据：~145 rows (大约)
DELETE FROM `api_fields`;
/*!40000 ALTER TABLE `api_fields` DISABLE KEYS */;
INSERT INTO `api_fields` (`id`, `fieldName`, `hash`, `dataType`, `default`, `isMust`, `range`, `info`, `type`, `showName`) VALUES
	(1, 'aaa', '', 8, '123123', 1, 'fsdf', 'sf', 0, 'aaa'),
	(2, 'sdf', '', 1, 'asdf', 1, '', '', 0, 'sdf'),
	(3, '123', '', 1, '`12', 1, '`12', '', 0, '123'),
	(10, 'ergerger', '59ea0cd052201', 1, '324234', 0, '2342342', '34234', 1, 'ergerger'),
	(11, 'username', '59eb02fb401b1', 2, '', 1, 'test', '我是说明\n', 0, 'username'),
	(12, 'password', '59eb02fb401b1', 2, '', 1, '', '密码', 0, 'password'),
	(13, 'username', '59eb2c9d9b723', 2, '', 1, '', '用于登录的用户名，可以是手机号，或staff表内的登录名。', 0, 'username'),
	(14, 'password', '59eb2c9d9b723', 2, '', 1, '', '登录密码', 0, 'password'),
	(16, 'code', '59eb2c9d9b723', 1, '200', 1, '', '返回200表示成功。其他为失败', 1, 'code'),
	(17, 'staffid', '59eb382d6af16', 1, '', 1, '', '', 0, 'staffid'),
	(18, 'username', '59ec9360b6861', 2, '', 1, '', '用户名', 0, 'username'),
	(19, 'password', '59ec9360b6861', 2, '', 1, '', 'password', 0, 'password'),
	(20, 'username', '59f15d141e7e2', 2, '', 1, '', '', 0, 'username'),
	(21, 'oldpwd', '59f15d141e7e2', 2, '', 1, '', '', 0, 'oldpwd'),
	(22, 'newpwd', '59f15d141e7e2', 2, '', 1, '', '新密码', 0, 'newpwd'),
	(23, 'staffname', '59f2e9fb5f863', 2, '', 1, '', '员工名', 0, 'staffname'),
	(24, 'password', '59f2e9fb5f863', 2, '', 1, '', '密码', 0, 'password'),
	(26, 'staff_id', '59f424811d52f', 1, '', 1, '', '员工id', 0, 'staff_id'),
	(28, 'staffname', '59f44a14c3cae', 2, '', 1, '', '员工名', 0, 'staffname'),
	(29, 'oldPassword', '59f44a14c3cae', 2, '', 1, '', '旧密码', 0, 'oldPassword'),
	(30, 'newPassword', '59f44a14c3cae', 2, '', 1, '', '新密码', 0, 'newPassword'),
	(31, 'abc', '59f83a849c87d', 7, '', 1, '123', '456', 0, 'abc'),
	(44, 'user_name', '59f96a8def678', 2, '', 1, '', '', 0, 'user_name'),
	(45, 'password', '59f96a8def678', 2, '', 1, '', '', 0, 'password'),
	(53, 'create_time', '5a4cb959b1c8b', 2, '', 0, '', '订单创建时间', 0, 'create_time'),
	(54, 'order_sn', '5a4cb959b1c8b', 2, '', 1, '', '订单号', 0, 'order_sn'),
	(55, 'm_tel', '5a4cb959b1c8b', 2, '', 0, '', '男手机号', 0, 'm_tel'),
	(56, 'w_tel', '5a4cb959b1c8b', 2, '', 0, '', '女手机号', 0, 'w_tel'),
	(57, 'order_fact', '5a4cb959b1c8b', 2, '', 0, '', '一销实收', 0, 'order_fact'),
	(58, 'order_amount', '5a4cb959b1c8b', 2, '', 0, '', '一销总额', 0, 'order_amount'),
	(59, 'two_pin_fact', '5a4cb959b1c8b', 2, '', 0, '', '二销实收', 0, 'two_pin_fact'),
	(60, 'two_pin_amount', '5a4cb959b1c8b', 2, '', 0, '', '二销总额', 0, 'two_pin_amount'),
	(61, 'brandclass_id', '5a4cb959b1c8b', 1, '', 1, '', '事业部id', 0, 'brandclass_id'),
	(62, 'shop_code', '5a4cb959b1c8b', 2, '', 0, '', '实体店shop_code', 0, 'shop_code'),
	(63, 'customer_id', '5a4cbaf782dc0', 1, '', 1, '', '客资id', 0, 'customer_id'),
	(64, 'order_sn', '5a4cbaf782dc0', 2, '', 1, '', '订单编号', 0, 'order_sn'),
	(65, 'code', '5a4d9063d2ca8', 1, '', 1, '1:进店进客；2：进店非进客；3：未进店；4：流失', '1:进店进客；2：进店非进客；3：未进店；4：流失', 0, 'code'),
	(66, 'create_time', '5a4d9063d2ca8', 2, '', 1, '进店时间/标记时间', '进店时间/标记时间', 0, 'create_time'),
	(67, 'lose_reason', '5a4d9063d2ca8', 2, '', 0, '流失原因', '流失原因', 0, 'lose_reason'),
	(70, 'm_tel', '5a4d9063d2ca8', 1, '', 0, '男士手机号', '男士手机号', 0, 'm_tel'),
	(71, 'w_tel', '5a4d9063d2ca8', 1, '', 1, '女士手机号', '女士手机号', 0, 'w_tel'),
	(72, 'brandclass_id', '5a4d9063d2ca8', 1, '', 1, '事业部id', '事业部id', 0, 'brandclass_id'),
	(73, 'shop_code', '5a4d9063d2ca8', 1, '', 1, 'shop_code', 'shop_code', 0, 'shop_code'),
	(96, 'diff', '5a4cb959b1c8b', 1, '1', 1, '', '用于区分是开单(1)，添加消费产品(2)还是收款(3)', 0, 'diff'),
	(98, 'customer_number', '5a4d9063d2ca8', 1, '', 1, 'crm系统客户编号     ERP系统中的 From_index', 'crm系统客户编号     ERP系统中的 From_index', 0, 'customer_number'),
	(100, 'brandclass_id', '5a4cab8e0e678', 1, '', 1, '事业部id', '事业部id', 0, 'brandclass_id'),
	(101, 'shop_code', '5a4cab8e0e678', 2, '', 1, 'shop_code', 'shop_code', 0, 'shop_code'),
	(102, 'staff_id', '5a4cab8e0e678', 1, '', 1, '操作人id', '操作人id', 0, 'staff_id'),
	(103, 'customer_number', '5a4cab8e0e678', 2, '', 0, 'crm系统客户编号   erp的  From_index', 'crm系统客户编号', 0, 'customer_number'),
	(104, 'customer_name', '5a4cab8e0e678', 2, '', 1, '客户姓名', '客户姓名', 0, 'customer_name'),
	(105, 'customer_tel', '5a4cab8e0e678', 2, '', 1, '客户手机', '客户手机', 0, 'customer_tel'),
	(106, 'customer_wechat', '5a4cab8e0e678', 2, '', 0, '客户微信', '客户微信', 0, 'customer_wechat'),
	(107, 'customer_qq', '5a4cab8e0e678', 2, '', 0, '客户QQ', '客户QQ', 0, 'customer_qq'),
	(108, 'customer_sex', '5a4cab8e0e678', 2, '', 0, '客户性别 （男，女）', '客户性别 （男，女）', 0, 'customer_sex'),
	(109, 'customer_birthday', '5a4cab8e0e678', 2, '', 0, '客户生日', '客户生日', 0, 'customer_birthday'),
	(110, 'consultation_type_id', '5a4cab8e0e678', 1, '', 0, '消费类型id', '消费类型id', 0, 'consultation_type_id'),
	(111, 'consultation_type', '5a4cab8e0e678', 2, '', 0, '消费类型', '消费类型', 0, 'consultation_type'),
	(112, 'customer_area_id', '5a4cab8e0e678', 1, '', 0, '客户分区id', '客户分区id', 0, 'customer_area_id'),
	(113, 'customer_area', '5a4cab8e0e678', 2, '', 0, '客户分区', '客户分区', 0, 'customer_area'),
	(114, 'customer_cource_id', '5a4cab8e0e678', 1, '', 0, '客户来源id', '客户来源id', 0, 'customer_cource_id'),
	(115, 'customer_cource', '5a4cab8e0e678', 2, '', 0, '客户来源', '客户来源', 0, 'customer_cource'),
	(116, 'customer_intention_id', '5a4cab8e0e678', 1, '', 0, '客户意向id', '客户意向id', 0, 'customer_intention_id'),
	(117, 'customer_intention', '5a4cab8e0e678', 2, '', 0, '客户意向', '客户意向', 0, 'customer_intention'),
	(118, 'customer_orderaddress', '5a4cab8e0e678', 2, '', 0, '接单点', '接单点', 0, 'customer_orderaddress'),
	(119, 'customer_address', '5a4cab8e0e678', 2, '', 0, '客户地址', '客户地址', 0, 'customer_address'),
	(120, 'yp_day', '5a4cab8e0e678', 2, '', 0, '预拍日期', '预拍日期', 0, 'yp_day'),
	(121, 'marry_day', '5a4cab8e0e678', 2, '', 0, '结婚日期', '结婚日期', 0, 'marry_day'),
	(122, 'mate_name', '5a4cab8e0e678', 2, '', 0, '配偶姓名', '配偶姓名', 0, 'mate_name'),
	(123, 'mate_tel', '5a4cab8e0e678', 2, '', 0, '配偶手机', '配偶手机', 0, 'mate_tel'),
	(124, 'mate_wechat', '5a4cab8e0e678', 2, '', 0, '配偶微信', '配偶微信', 0, 'mate_wechat'),
	(125, 'mate_qq', '5a4cab8e0e678', 2, '', 0, '配偶QQ', '配偶QQ', 0, 'mate_qq'),
	(126, 'mate_sex', '5a4cab8e0e678', 2, '', 0, '配偶性别', '配偶性别', 0, 'mate_sex'),
	(127, 'mate_birthday', '5a4cab8e0e678', 2, '', 0, '配偶生日', '配偶生日', 0, 'mate_birthday'),
	(128, 'ready_baby_day', '5a4cab8e0e678', 2, '', 0, '预产期', '预产期', 0, 'ready_baby_day'),
	(129, 'baby_birthday', '5a4cab8e0e678', 2, '', 0, '宝宝生日', '宝宝生日', 0, 'baby_birthday'),
	(130, 'baby_address', '5a4cab8e0e678', 2, '', 0, '宝宝出生地', '宝宝出生地', 0, 'baby_address'),
	(131, 'customer_remark', '5a4cab8e0e678', 2, '', 0, '客户备注', '客户备注', 0, 'customer_remark'),
	(132, 'staff_id', '5a4d9063d2ca8', 1, '', 1, '操作人id', '操作人id', 0, 'staff_id'),
	(133, 'brandclass_id', '5a56b32c2b6fa', 1, '', 1, '事业部id', '事业部id', 0, 'brandclass_id'),
	(134, 'shop_code', '5a56b32c2b6fa', 2, '', 1, '操作员工所属 shop_code', '操作员工所属 shop_code', 0, 'shop_code'),
	(135, 'staff_id', '5a56b32c2b6fa', 1, '', 1, '当前操作者  staff_id', '当前操作者  staff_id', 0, 'staff_id'),
	(136, 'order_sn', '5a56b32c2b6fa', 2, '', 1, 'erp系统中的订单编号', 'erp系统中的订单编号', 0, 'order_sn'),
	(137, 'create_time', '5a56b32c2b6fa', 2, '', 0, '订单创建时间  2018-01-11 14:20:30', '订单创建时间  2018-01-11 14:20:30', 0, 'create_time'),
	(138, 'consultation_type', '5a56b32c2b6fa', 2, '', 0, '消费类型', '消费类型', 0, 'consultation_type'),
	(139, 'consultation_type_id', '5a56b32c2b6fa', 1, '', 0, '消费类型 id', '消费类型 id', 0, 'consultation_type_id'),
	(140, 'customer_cource', '5a56b32c2b6fa', 2, '', 0, '客户来源', '客户来源', 0, 'customer_cource'),
	(141, 'customer_cource_id', '5a56b32c2b6fa', 1, '', 0, '客户 来源 id', '客户 来源 id', 0, 'customer_cource_id'),
	(142, 'customer_area', '5a56b32c2b6fa', 2, '', 0, '客户分区', '客户分区', 0, 'customer_area'),
	(143, 'customer_area_id', '5a56b32c2b6fa', 1, '', 0, '客户分区 id', '客户分区 id', 0, 'customer_area_id'),
	(144, 'marry_day', '5a56b32c2b6fa', 2, '', 0, '结婚日期  2018-01-11 14:20:30', '结婚日期  2018-01-11 14:20:30', 0, 'marry_day'),
	(145, 'baby_birthday', '5a56b32c2b6fa', 2, '', 0, '宝宝生日  2018-01-11 14:20:30', '宝宝生日  2018-01-11 14:20:30', 0, 'baby_birthday'),
	(146, 'wname', '5a56b32c2b6fa', 2, '', 1, '女士姓名', '女士姓名', 0, 'wname'),
	(147, 'wphone', '5a56b32c2b6fa', 2, '', 1, '女士手机号', '女士手机号', 0, 'wphone'),
	(148, 'wwechat', '5a56b32c2b6fa', 2, '', 0, '女士微信', '女士微信', 0, 'wwechat'),
	(149, 'mname', '5a56b32c2b6fa', 2, '', 0, '男士姓名', '男士姓名', 0, 'mname'),
	(150, 'mphone', '5a56b32c2b6fa', 2, '', 0, '男士手机', '男士手机', 0, 'mphone'),
	(151, 'mwechat', '5a56b32c2b6fa', 2, '', 0, '男士微信', '男士微信', 0, 'mwechat'),
	(152, 'customer_number', '5a4cb959b1c8b', 2, '', 1, '客资编号，即：erp中，From_index', '客资编号，即：erp中，From_index', 0, 'customer_number'),
	(153, 'consultation_type', '5a4cb959b1c8b', 2, '', 1, '消费类型', '消费类型', 0, 'consultation_type'),
	(154, 'brandclass_id', '5a9d032325040', 1, '', 1, '事业部id', '事业部id', 0, 'brandclass_id'),
	(155, 'shop_code', '5a9d032325040', 2, '', 1, 'shop_code', 'shop_code', 0, 'shop_code'),
	(156, 'shop_name', '5a9d032325040', 2, '', 1, 'shop_name', 'shop_name', 0, 'shop_name'),
	(157, 'create_time', '5a9d032325040', 2, '', 0, '创建时间 (y-m-d H:i:s)', '创建时间 (y-m-d H:i:s)', 0, 'create_time'),
	(158, 'staff_name', '5a9d032325040', 2, '', 0, '操作人', '操作人', 0, 'staff_name'),
	(159, 'consultation_type', '5a9d032325040', 2, '', 1, '消费类型', '消费类型', 0, 'consultation_type'),
	(160, 'customer_cource', '5a9d032325040', 2, '', 0, '客户来源', '客户来源', 0, 'customer_cource'),
	(162, 'customer_area', '5a9d032325040', 2, '', 0, '客户分区', '客户分区', 0, 'customer_area'),
	(164, 'marry_day', '5a9d032325040', 2, '', 0, '结婚日期', '结婚日期', 0, 'marry_day'),
	(165, 'baby_birthday', '5a9d032325040', 2, '', 0, '宝宝生日', '宝宝生日', 0, 'baby_birthday'),
	(166, 'wname', '5a9d032325040', 2, '', 1, '女士姓名', '女士姓名', 0, 'wname'),
	(167, 'wphone', '5a9d032325040', 1, '', 1, '女士手机', '女士手机', 0, 'wphone'),
	(168, 'wwechat', '5a9d032325040', 2, '', 0, '女士微信', '女士微信', 0, 'wwechat'),
	(169, 'mname', '5a9d032325040', 2, '', 0, '男士姓名', '男士姓名', 0, 'mname'),
	(170, 'mphone', '5a9d032325040', 1, '', 0, '男士手机', '男士手机', 0, 'mphone'),
	(171, 'mwechat', '5a9d032325040', 2, '', 0, '男士微信', '男士微信', 0, 'mwechat'),
	(172, 'brandclass_id', '5a9d038620298', 1, '', 1, '事业部id', '事业部id', 0, 'brandclass_id'),
	(173, 'shop_code', '5a9d038620298', 2, '', 1, 'shop_code', 'shop_code', 0, 'shop_code'),
	(174, 'shop_name', '5a9d038620298', 2, '', 1, 'shop_name', 'shop_name', 0, 'shop_name'),
	(176, 'customer_number', '5a9d038620298', 2, '', 1, '客资编号', '客资编号', 0, 'customer_number'),
	(177, 'order_sn', '5a9d038620298', 2, '', 1, '订单编号', '订单编号', 0, 'order_sn'),
	(178, 'order_amount', '5a9d038620298', 2, '', 1, '一销套系金额', '一销套系金额', 0, 'order_amount'),
	(179, 'two_pin_amount', '5a9d038620298', 2, '', 0, '二销套系金额', '二销套系金额', 0, 'two_pin_amount'),
	(180, 'customer_orderaddress', '5a9d038620298', 2, '', 0, '接单点', '接单点', 0, 'customer_orderaddress'),
	(181, 'order_note', '5a9d038620298', 2, '', 0, '订单备注', '订单备注', 0, 'order_note'),
	(182, 'consultation_type', '5a9d038620298', 2, '', 1, '消费类型', '消费类型', 0, 'consultation_type'),
	(183, 'brandclass_id', '5a9d03d28c863', 1, '', 1, '事业部id', '事业部id', 0, 'brandclass_id'),
	(184, 'shop_code', '5a9d03d28c863', 2, '', 1, 'shop_code', 'shop_code', 0, 'shop_code'),
	(185, 'shop_name', '5a9d03d28c863', 2, '', 1, 'shop_name', 'shop_name', 0, 'shop_name'),
	(187, 'customer_number', '5a9d03d28c863', 2, '', 1, '客资编号', '客资编号', 0, 'customer_number'),
	(188, 'order_sn', '5a9d03d28c863', 2, '', 1, '订单编号', '订单编号', 0, 'order_sn'),
	(189, 'order_fact', '5a9d03d28c863', 2, '', 1, '一销实收金额', '一销实收金额', 0, 'order_fact'),
	(190, 'two_pin_fact', '5a9d03d28c863', 2, '', 0, '二销实收金额', '二销实收金额', 0, 'two_pin_fact'),
	(191, 'target_time', '5a9d038620298', 2, '', 0, '订单获取时间 (y-m-d H:i:s)', '订单获取时间 (y-m-d H:i:s)', 0, 'target_time'),
	(192, 'update_time', '5a9d03d28c863', 2, '', 0, '订单收款时间 (y-m-d H:i:s)', '订单收款时间 (y-m-d H:i:s)', 0, 'update_time'),
	(194, 'target_time', '5a9d032325040', 2, '', 0, '客资获取时间', '客资获取时间', 0, 'target_time'),
	(195, 'create_time', '5a9d038620298', 2, '', 0, '订单录入时间', '订单录入时间', 0, 'create_time'),
	(196, 'order_sn', '5abf60677c448', 2, '', 1, 'erp订单单号', 'erp订单单号', 0, 'order_sn'),
	(197, 'staff_id', '5abf60677c448', 1, '', 1, '当前操作人id ', '当前操作人id', 0, 'staff_id'),
	(198, 'staff_name', '5abf60677c448', 2, '', 1, '当前操作人姓名', '当前操作人姓名', 0, 'staff_name'),
	(220, 'brandclass_id', '5acd6abcb09be', 1, '', 0, '事业部id', '事业部id', 0, 'brandclass_id'),
	(221, 'shop_code', '5acd6abcb09be', 2, '', 0, '', '', 0, 'shop_code'),
	(222, 'department_id', '5acd6abcb09be', 1, '', 0, '部门id ', '部门id', 0, 'department_id'),
	(223, 'staff_id', '5acd6abcb09be', 1, '', 0, '登记人id', '登记人id', 0, 'staff_id'),
	(224, 'start', '5acd6abcb09be', 2, '', 0, '客资登记开始时间', '客资登记开始时间，格式是：2018-04-01 15:30:15,下面参数亦如此', 0, 'start'),
	(225, 'end', '5acd6abcb09be', 2, '', 0, '客资登记结束时间', '客资登记结束时间', 0, 'end');
/*!40000 ALTER TABLE `api_fields` ENABLE KEYS */;

-- 导出  表 sx_crm.api_list 结构
DROP TABLE IF EXISTS `api_list`;
CREATE TABLE IF NOT EXISTS `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` text COLLATE utf8_unicode_ci NOT NULL COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COLLATE utf8_unicode_ci COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用于维护接口信息';

-- 正在导出表  sx_crm.api_list 的数据：~15 rows (大约)
DELETE FROM `api_list`;
/*!40000 ALTER TABLE `api_list` DISABLE KEYS */;
INSERT INTO `api_list` (`id`, `apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`) VALUES
	(1, '验证客资是否存在', 'Customer/checkCustomer', 5, '5a4cab8e0e678', 0, 0, 1, 1, '验证客资是否存在', 0, ''),
	(2, 'ERP开单，添加消费产品，付款接口', 'Customer/receivables', 5, '5a4cb959b1c8b', 1, 0, 1, 1, 'ERP开单，添加消费产品，付款接口', 0, ''),
	(3, '验证订单', 'Customer/checkOrder', 5, '5a4cbaf782dc0', 0, 0, 1, 1, '验证订单是否存在', 0, ''),
	(4, '修改客资状态', 'Customer/changeCustomerStatus', 5, '5a4d9063d2ca8', 0, 0, 1, 1, '修改客资状态：进店进客，进店非进客，未进店，流失', 0, ''),
	(7, '登录接口erp', 'Staff/login', 2, '59f2e9fb5f863', 0, 0, 1, 1, '登录接口', 1, NULL),
	(9, '退出登录', 'Staff/logOut', 2, '59f424811d52f', 0, 0, 1, 1, '退出登录', 1, NULL),
	(10, '修改密码', 'Staff/updatePassword', 2, '59f44a14c3cae', 0, 0, 1, 1, '修改密码', 1, NULL),
	(12, 'test', 'test/te33f', 3, '59f8322eb4d03', 1, 1, 1, 1, 'fdff', 0, NULL),
	(13, '登录', 'erp/Auth/login', 4, '59f96a8def678', 1, 0, 1, 1, '', 0, NULL),
	(18, '创建新订单', 'Customer/createOrder', 5, '5a56b32c2b6fa', 0, 0, 1, 1, '没有进店登记，直接创建新订单', 0, NULL),
	(19, 'erp转库专用接口1，创建客资', 'Customer/addCustomer', 5, '5a9d032325040', 0, 0, 1, 1, 'erp转库专用接口1，创建客资', 1, NULL),
	(20, 'erp转库专用接口2，创建订单，并且添加消费产品', 'Customer/addCustomerOrder', 5, '5a9d038620298', 0, 0, 1, 1, 'erp转库专用接口2，创建订单，并且添加消费产品', 1, NULL),
	(21, 'erp转库专用接口3，更新订单收款信息', 'Customer/updateCustomerOrder', 5, '5a9d03d28c863', 0, 0, 1, 1, 'erp转库专用接口3，更新订单收款信息', 1, NULL),
	(22, '删除订单', 'Customer/delOrder', 5, '5abf60677c448', 0, 0, 1, 1, '删除订单接口', 1, NULL),
	(26, '获取员工的A客和毛客资数', 'Customer/getStaffAllCustomer', 5, '5acd6abcb09be', 0, 0, 1, 1, '获取员工的A客和毛客资数', 0, NULL);
/*!40000 ALTER TABLE `api_list` ENABLE KEYS */;

-- 导出  表 sx_crm.app_version 结构
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE IF NOT EXISTS `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  `up_sql2` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- 正在导出表  sx_crm.app_version 的数据：~55 rows (大约)
DELETE FROM `app_version`;
/*!40000 ALTER TABLE `app_version` DISABLE KEYS */;
INSERT INTO `app_version` (`id`, `version`, `up_time`, `up_sql`, `up_sql2`) VALUES
	(4, '1.0.1', '2017-12-06 22:01:44', NULL, NULL),
	(5, '1.0.2', '2017-12-06 22:03:51', ' ALTER TABLE `app_version`  ADD COLUMN `up_sql2` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ', NULL),
	(8, '1.0.3', '2017-12-07 15:03:54', NULL, NULL),
	(9, '1.0.4', '2017-12-07 15:45:52', NULL, NULL),
	(10, '1.0.5', '2017-12-07 20:02:11', ' ALTER TABLE `c_customerinfo`  ADD COLUMN `is_status` int  NULL  DEFAULT 1 ', NULL),
	(11, '1.0.6', '2017-12-08 13:22:41', NULL, NULL),
	(12, '1.0.7', '2017-12-12 19:15:49', NULL, NULL),
	(13, '1.0.8', '2017-12-14 14:00:01', ' ALTER TABLE `c_customerinfo`  ADD COLUMN `sign_id` int  NULL , ADD COLUMN `sign_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ', NULL),
	(14, '1.0.43', '2018-01-09 10:48:30', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,menu_icon,status,sort)  SELECT \'呼叫前缀设定\',\'6\',\'menu1514183289\',\'/crm/Setting/callPrefix\',\'\',\'1\',\'30\' union  SELECT \'首页岗位显示\',\'6\',\'menu1514430518\',\'/crm/Setting/homeShowSet\',\'\',\'1\',\'46\' ', NULL),
	(15, '1.0.44', '2018-01-09 14:32:20', ' ALTER TABLE `c_erp_save`  ADD COLUMN `type` int(4)  NOT NULL  DEFAULT 1 , ADD COLUMN `cid` int(11)  NULL , ADD COLUMN `oid` int(11)  NULL ', NULL),
	(16, '1.0.45', '2018-01-10 20:13:30', 'CREATE TABLE `c_ds_report`(`id` int  NOT NULL  AUTO_INCREMENT ,`date` datetime  NULL ,`channel_id` int(11)  NULL ,`channel` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`region_id` int(11)  NULL ,`region` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`cost` decimal(12,4)  NULL ,`return_cost` decimal(12,4)  NULL ,`new_customer` int(11)  NULL ,`valid_customer` int(11)  NULL ,`acquisition_rate` decimal(7,4)  NULL ,`invitation` int(11)  NULL ,`into` int(11)  NULL ,`in_rate` decimal(7,4)  NULL ,`order_num` int(11)  NULL ,`deal_rate` decimal(7,4)  NULL ,`change_rate` decimal(7,4)  NULL ,`orer_amount` decimal(12,4)  NULL ,`earning` decimal(12,4)  NULL ,`average_price` decimal(12,4)  NULL ,`obtain_cost` decimal(12,4)  NULL ,`vaild_cost` decimal(12,4)  NULL ,`deal_cost` decimal(12,4)  NULL ,`roi` decimal(12,4)  NULL ,`create_time` datetime  NULL ,PRIMARY KEY (`id`), INDEX `PRIMARY KEY` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB ', NULL),
	(17, '1.0.46', '2018-01-11 14:17:30', 'CREATE TABLE `c_order_detail`(`id` int  NOT NULL  AUTO_INCREMENT ,`order_sn` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`pay_time` datetime  NULL ,`order_valid` tinyint(2)  NULL ,`order_type` tinyint(2)  NOT NULL  DEFAULT 2 ,`order_fact` decimal(10,4)  NULL ,`two_pin_fact` decimal(10,4)  NULL ,`create_time` datetime  NULL ,PRIMARY KEY (`id`), INDEX `PRIMARY KEY` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB ', NULL),
	(18, '1.0.49', '2018-01-12 14:53:52', ' ALTER TABLE `c_ds_report`  ADD COLUMN `shop_code` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `brandclass_id` int(11)  NULL \r\nCREATE TABLE `c_customer_tel`(`id` int  NOT NULL  AUTO_INCREMENT ,`customer_tel` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`tel_belong` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`tel_operator` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,`tel_area_code` varchar(50)  NULL  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`), INDEX `PRIMARY KEY` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `c_customer_cost`  ADD COLUMN `return_avg` decimal(10,4)  NULL , ADD COLUMN `channel_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `region_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ', NULL),
	(19, '1.0.50', '2018-01-16 10:34:28', ' ALTER TABLE `c_customerinfo`  ADD COLUMN `sign_time` datetime  NULL ', NULL),
	(20, '1.0.51', '2018-01-17 11:14:27', ' ALTER TABLE `c_customerinfo`  ADD COLUMN `loss_day` datetime  NULL ', NULL),
	(21, '1.0.52', '2018-01-18 16:31:20', ' ALTER TABLE `c_fp_pool`  ADD COLUMN `pool_type` tinyint  NOT NULL  DEFAULT 1 ', NULL),
	(22, '1.1.0', '2018-01-19 10:09:18', NULL, NULL),
	(23, '1.1.2', '2018-01-22 18:07:41', 'CREATE TABLE `c_customer_contact`(`id` int  NOT NULL  AUTO_INCREMENT ,`c_id` int(11)  NULL ,`contact` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n ALTER TABLE `c_excel_import`  ADD COLUMN `import_fail` int  NULL ', NULL),
	(24, '1.1.3', '2018-01-22 23:47:44', ' ALTER TABLE `c_customer_contact`  ADD COLUMN `brandclass` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ', NULL),
	(25, '1.1.5', '2018-01-27 16:46:56', 'CREATE TABLE `s_channel`(`id` int  NOT NULL  AUTO_INCREMENT ,`channel_class_id` int(11)  NOT NULL ,`channel_class_name` varchar(50)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`channel_info_id` int(11)  NOT NULL ,`channel_info_name` varchar(50)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`channel_name` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`brandclass_id` int(11)  NULL ,`brandclass_name` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`setkey` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`), INDEX `key1` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'来源渠道设定\',\'6\',\'menu1516949559\',\'/crm/Setting/channel\',\'1\',\'50\' ', NULL),
	(26, '1.1.6', '2018-01-28 12:05:46', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'失败再分配\',\'61\',\'menu1517042801\',\'/crm/Customer/customerReAllot\',\'1\',\'0\' ', NULL),
	(27, '1.1.6', '2018-01-28 12:05:46', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'失败再分配\',\'61\',\'menu1517042801\',\'/crm/Customer/customerReAllot\',\'1\',\'0\' ', NULL),
	(28, '1.1.7', '2018-01-28 14:37:10', ' ALTER TABLE `c_customerinfo`  ADD COLUMN `op_signinfo_id` int(11)  NULL  DEFAULT 0 ', NULL),
	(29, '1.1.8', '2018-01-28 19:05:30', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'客资标记\',\'2\',\'menu1517129233\',\'\',\'0\',\'30\' union  SELECT \'标记有效\',\'105\',\'menu1517129299\',\'/crm/signValid\',\'1\',\'30\' union  SELECT \'标记无效\',\'105\',\'menu1517129331\',\'/crm/signUnvalid\',\'1\',\'30\' ', NULL),
	(30, '1.1.10', '2018-01-30 11:15:14', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'当日接收\',\'34\',\'menu1517217988\',\'\',\'1\',\'1\' union  SELECT \'三日内追踪\',\'34\',\'menu1517218007\',\'\',\'1\',\'1\' union  SELECT \'当日预进店\',\'34\',\'menu1517218044\',\'\',\'1\',\'1\' \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'客资驳回\',\'2\',\'menu1517278817\',\'/crm/customerValidUpdate\',\'1\',\'20\' union  SELECT \'客资反驳回\',\'2\',\'menu1517278844\',\'/crm/customerUnValidUpdate\',\'1\',\'20\' ', NULL),
	(31, '1.1.11', '2018-01-30 21:35:20', ' ALTER TABLE `c_customer_cost`  ADD COLUMN `province_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `province_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `city_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `city_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `s_channel_cost`  ADD COLUMN `province_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `province_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `city_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `city_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `s_channel_cost_return`  ADD COLUMN `province_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `province_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `city_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `city_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ', NULL),
	(32, '1.1.13', '2018-02-03 12:39:14', 'CREATE TABLE `s_shop_address`(`id` int  NOT NULL  DEFAULT 0 ,`pid` int(11)  NOT NULL  DEFAULT 0 ,`name` varchar(50)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`type` tinyint(1)  NOT NULL  DEFAULT 0 ,`shop_code` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'省市区设定\',\'6\',\'menu1517560908\',\'/crm/Setting/province\',\'1\',\'90\' ', NULL),
	(33, '1.1.14', '2018-02-04 17:36:54', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'渠道-各店转化率表\',\'5\',\'menu1517727451\',\'/crm/Statistics/swCustomerChange\',\'1\',\'9\' ', NULL),
	(34, '1.1.15', '2018-02-06 09:33:42', NULL, NULL),
	(35, '1.1.16', '2018-02-08 15:40:37', ' ALTER TABLE `s_kpi_staffgoal`  ADD COLUMN `order_sort` int(5)  NULL  DEFAULT 0 ', NULL),
	(36, '1.1.17', '2018-02-08 15:58:47', 'CREATE TABLE `s_custom_column`(`id` int  NOT NULL  AUTO_INCREMENT ,`custom_model` text  NULL  COLLATE \'utf8_unicode_ci\' ,`custom_name` text  NULL  COLLATE \'utf8_unicode_ci\' ,`custom_column` text  NULL  COLLATE \'utf8_unicode_ci\' ,`staff_id` int(11)  NOT NULL  DEFAULT 0 ,PRIMARY KEY (`id`), INDEX `key1` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB ', NULL),
	(37, '1.1.19', '2018-02-22 11:33:13', ' ALTER TABLE `s_kpi_staffgoal`  ADD COLUMN `flag` varchar(11)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `department_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `department_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `staff_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `staff_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `s_kpi_staffgoal`  ADD COLUMN `channel_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `channel_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `region_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `region_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `province_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `province_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `city_id` int(11)  NULL  DEFAULT 0 , ADD COLUMN `city_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ', NULL),
	(38, '1.1.23', '2018-02-28 18:08:57', 'CREATE TABLE `s_customer_tab`(`id` int(11)  NOT NULL  DEFAULT 0 ,`name` varchar(11)  NULL  COLLATE \'utf8_unicode_ci\' ,`sql` text  NULL  COLLATE \'utf8_unicode_ci\' ,`order_sort` int(4)  NULL  DEFAULT 0 ,`is_use` tinyint(3)  NOT NULL  DEFAULT 1 ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'选项卡-有效客资\',\'34\',\'menu1519611713\',\'\',\'1\',\'13\' union  SELECT \'选项卡-无效客资\',\'34\',\'menu1519611738\',\'\',\'1\',\'14\' union  SELECT \'选项卡-待定客资\',\'34\',\'menu1519611762\',\'\',\'1\',\'15\' union  SELECT \'选项卡-驳回客资\',\'34\',\'menu1519611781\',\'\',\'1\',\'16\' union  SELECT \'右键-客资标记\',\'2\',\'menu1519631971\',\'/crm/Customer/customerSign\',\'0\',\'20\' union  SELECT \'右键-追踪标记\',\'2\',\'menu1519632099\',\'/crm/Customer/customerSign\',\'0\',\'21\' union  SELECT \'右键-不再追踪\',\'2\',\'menu1519633436\',\'/crm/Customer/notTraking\',\'0\',\'30\' union  SELECT \'右键-预约进店\',\'2\',\'menu1519633870\',\'/crm/Customer/customerYJD\',\'0\',\'25\' union  SELECT \'右键-转订单\',\'2\',\'menu1519633923\',\'/crm/Customer/zhuanOrder\',\'0\',\'26\' union  SELECT \'右键-编辑订单\',\'2\',\'menu1519633959\',\'/crm/Customer/editOrder\',\'0\',\'27\' union  SELECT \'右键-筛客\',\'2\',\'menu1519635403\',\'/crm/Customer/skCustomer\',\'0\',\'20\' ', NULL),
	(39, '1.1.24', '2018-03-02 16:48:38', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'渠道漏斗统计\',\'5\',\'menu1519826594\',\'/crm/Statistics/ds_channelLd\',\'1\',\'2\' union  SELECT \'地域漏斗统计\',\'5\',\'menu1519826642\',\'/crm/Statistics/ds_regionLd\',\'1\',\'2\' ', NULL),
	(40, '1.1.25', '2018-03-09 09:24:05', ' ALTER TABLE `c_customer_order`  ADD COLUMN `target_time` datetime  NULL ', NULL),
	(41, '1.1.26', '2018-03-09 15:11:14', ' ALTER TABLE `c_order_detail`  ADD COLUMN `pay_type` int(2)  NOT NULL ', NULL),
	(42, '1.1.28', '2018-03-12 09:38:16', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'右键-撤销\',\'2\',\'menu1520675106\',\'/crm/Customer/customerRevoke\',\'0\',\'28\' \r\n ALTER TABLE `c_customerinfo`  ADD COLUMN `is_act` int(2)  NULL  DEFAULT 1 \r\nCREATE TABLE `s_swapset`(`id` int(11)  NOT NULL  AUTO_INCREMENT ,`swap_number` char(14)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`swap_name` varchar(100)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`swap_staff_ids` varchar(200)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`swap_staff_names` text  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`customer_start` date  NULL ,`customer_end` date  NULL ,`start_date` date  NULL ,`end_date` date  NULL ,`brandclass_id` int(11)  NULL  DEFAULT 0 ,`brandclass` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(2)  NULL  DEFAULT 1 ,`is_del` tinyint(2)  NULL  DEFAULT 1 ,`create_time` datetime  NULL ,`update_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `c_swap_customer`(`id` int(11)  NOT NULL  AUTO_INCREMENT ,`swap_number` char(14)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`customer_number` varchar(50)  NULL  DEFAULT 0  COLLATE \'utf8_unicode_ci\' ,`c_is_valid` tinyint(2)  NULL  DEFAULT 0 ,`is_valid` tinyint(2)  NULL  DEFAULT 0 ,`c_is_intostore` tinyint(2)  NULL  DEFAULT 0 ,`is_intostore` tinyint(2)  NULL  DEFAULT 0 ,`c_is_success` tinyint(2)  NULL  DEFAULT 0 ,`is_success` tinyint(2)  NULL  DEFAULT 0 ,`sales_staff_id` int(11)  NULL  DEFAULT 0 ,`sales_staff_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`sales_staff_number` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`brandclass_id` int(11)  NULL  DEFAULT 0 ,`brandclass` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(100)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB ', NULL),
	(43, '1.1.29', '2018-03-12 11:30:09', ' ALTER TABLE `c_customer_order`  ADD COLUMN `brandclass_id` int(11)  NOT NULL , ADD COLUMN `brandclass` varchar(50)  NOT NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `c_swap_customer`  ADD COLUMN `c_yjd_day` datetime  NOT NULL , ADD COLUMN `yjd_day` datetime  NOT NULL ', NULL),
	(44, '1.1.30', '2018-03-14 19:40:00', NULL, NULL),
	(45, '1.1.31', '2018-03-15 11:41:08', NULL, NULL),
	(46, '1.1.32', '2018-03-15 20:06:47', NULL, NULL),
	(47, '1.1.44', '2018-03-23 11:57:38', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'返点规则设定\',\'6\',\'menu1521280345\',\'/crm/Setting/shop_return_setting\',\'1\',\'100\' \r\nCREATE TABLE `s_shop_return_rule`(`id` int  NOT NULL  AUTO_INCREMENT ,`return_rule` tinyint(1)  NULL  DEFAULT 1 ,`return_value` int(10)  NULL  DEFAULT 0 ,`channel_id` int(11)  NULL  DEFAULT 0 ,`channel_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`brandclass_id` int(11)  NULL  DEFAULT 0 ,`brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`), INDEX `key1` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,menu_icon,status,sort)  SELECT \'查询服务\',\'0\',\'menu1521267312\',\'/crm/Customer/moreSearch\',\'fa-search\',\'1\',\'3\' \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'电商统计日报--常态报表1\',\'5\',\'menu1521352296\',\'/crm/Statistics/ds_sta_day\',\'0\',\'10\' union  SELECT \'电商统月报--常态报表2\',\'5\',\'menu1521352325\',\'/crm/Statistics/ds_sta_month\',\'0\',\'11\' union  SELECT \'电商统计日报--常态报表3\',\'5\',\'menu1521352381\',\'/crm/Statistics/ds_to_wx_report\',\'0\',\'12\' union  SELECT \'电商日报明细\',\'5\',\'menu1521352428\',\'/crm/Statistics/daily_detail\',\'0\',\'13\' union  SELECT \'网销漏斗\',\'5\',\'menu1521352461\',\'/crm/Statistics/wx_ld\',\'0\',\'14\' union  SELECT \'渠道透视\',\'5\',\'menu1521352487\',\'/crm/Statistics/qd_ts\',\'0\',\'15\' union  SELECT \'地域渠道有效客资透视\',\'5\',\'menu1521352560\',\'/crm/Statistics/dy_ts\',\'6\',\'16\' union  SELECT \'网销无效分析\',\'5\',\'menu1521352579\',\'/crm/Statistics/wx_unvalid\',\'0\',\'17\' union  SELECT \'渠道漏斗月走势统计\',\'5\',\'menu1521352601\',\'/crm/Statistics/channel_ld_month\',\'0\',\'18\' union  SELECT \'关键词分析\',\'5\',\'menu1521352632\',\'/crm/Statistics/keywords\',\'0\',\'19\' union  SELECT \'网销小组数据统计\',\'5\',\'menu1521352658\',\'/crm/Statistics/wx_group\',\'0\',\'20\' union  SELECT \'网销小组邀约(进店)统计\',\'5\',\'menu1521352682\',\'/crm/Statistics/wx_group_jd\',\'0\',\'21\' union  SELECT \'网销小组新单统计\',\'5\',\'menu1521352703\',\'/crm/Statistics/wx_group_new_order\',\'0\',\'22\' union  SELECT \'网销地域统计\',\'5\',\'menu1521352729\',\'/crm/Statistics/wx_region\',\'0\',\'23\' union  SELECT \'电商目标达成统计\',\'5\',\'menu1521352748\',\'/crm/Statistics/ds_goal\',\'0\',\'24\' union  SELECT \'电商渠道达成进店跟踪\',\'5\',\'menu1521352772\',\'/crm/Statistics/ds_shop_goal\',\'0\',\'25\' \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'批量客资查询\',\'134\',\'menu1521439092\',\'/crm/Customer/moreSearch\',\'1\',\'0\' union  SELECT \'门市订单查询\',\'134\',\'menu1521352773\',\'/crm/Customer/searchorders\',\'1\',\'2\' \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'客资爆破\',\'6\',\'menu1521091523\',\'/crm/Setting/customerSwap\',\'1\',\'101\' union  SELECT \'爆破设定\',\'171\',\'menu1521093152\',\'/crm/Setting/customerSwapSet\',\'1\',\'102\' union  SELECT \'添加客资\',\'171\',\'menu1521093203\',\'/crm/Setting/addCustomerSwap\',\'1\',\'103\' \r\n ALTER TABLE `c_customerinfo`  ADD COLUMN `yjd_action_day` datetime  NULL \r\n ALTER TABLE `c_swap_customer`  ADD COLUMN `c_yjd_action_day` datetime  NULL , ADD COLUMN `yjd_action_day` datetime  NULL \r\nCREATE TABLE `s_reject_reason`(`id` int  NOT NULL  AUTO_INCREMENT ,`reason` varchar(255)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`brandclass_id` int(11)  NULL  DEFAULT 0 ,`brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`)) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB ', NULL),
	(48, '1.1.45', '2018-03-23 15:07:38', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'驳回原因设定\',\'6\',\'menu1521784361\',\'/crm/Setting/RejectReason\',\'1\',\'21\' ', NULL),
	(49, '1.1.46', '2018-03-23 18:01:51', ' ALTER TABLE `c_customerinfo`  ADD COLUMN `reject_reason` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `reject_remark` text  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `loss_remark` text  NULL  COLLATE \'utf8_unicode_ci\' ', NULL),
	(51, '1.1.47', '2018-03-26 19:00:13', ' ALTER TABLE `s_tracksign`  ADD COLUMN `is_delete` tinyint(1)  NULL  DEFAULT 1 ', NULL),
	(52, '1.1.48', '2018-03-27 10:50:04', NULL, NULL),
	(53, '1.1.53', '2018-03-28 20:08:13', ' INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'ERP设置\',\'6\',\'menu1522207375\',\'/crm/Setting/erpSet\',\'1\',\'101\' \r\nCREATE TABLE `s_order_source`(`id` int(11)  NOT NULL  AUTO_INCREMENT ,`source` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_code` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`brandclass_id` int(11)  NOT NULL  DEFAULT 0 ,`brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`is_delete` tinyint(1)  NOT NULL  DEFAULT 1 ,PRIMARY KEY (`id`), INDEX `key1` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'订单来源设定\',\'6\',\'menu1522225258\',\'/crm/Setting/orderSource\',\'1\',\'102\' \r\n INSERT INTO `s_menu`  (menu_name,fid,menu_code,menu_url,status,sort)  SELECT \'各店24小时PK表\',\'5\',\'menu1522237395\',\'/crm/Statistics/ds_pk\',\'0\',\'26\' ', NULL),
	(54, '1.1.54', '2018-03-30 19:43:09', NULL, NULL),
	(55, '1.1.55', '2018-03-31 18:25:22', NULL, NULL),
	(56, '1.1.56', '2018-04-01 18:12:55', NULL, NULL),
	(57, '1.1.57', '2018-04-02 19:18:32', ' INSERT INTO `s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'右键-介绍人修改\',\'2\',\'menu1522653972\',\'/crm/Customer/editIntroducer\',\'0\',\'29\' ', NULL),
	(58, '1.1.58', '2018-04-03 19:42:44', ' INSERT INTO `s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'电商--本店各渠道数据明细\',\'5\',\'menu1522752932\',\'/crm/Statistics/dayStatistics\',\'0\',\'28\' union  SELECT \'各事业部数据统计\',\'5\',\'menu1522752970\',\'/crm/Statistics/week_and_month_statistics\',\'0\',\'29\' ', NULL),
	(67, '1.1.63', '2018-04-13 11:06:40', ' INSERT INTO `api_list`  (`apiName`,`apiUrl`,`app_id`,`hash`,`accessToken`,`needLogin`,`status`,`method`,`info`)  SELECT \'获取员工的A客和毛客资数\',\'Customer/getStaffAllCustomer\',\'5\',\'5acd6abcb09be\',\'0\',\'0\',\'1\',\'1\',\'获取员工的A客和毛客资数\' \r\n INSERT INTO `api_fields`  (`fieldName`,`hash`,`dataType`,`isMust`,`range`,`info`,`type`,`showName`)  SELECT \'brandclass_id\',\'5acd6abcb09be\',\'1\',\'0\',\'事业部id\',\'事业部id\',\'0\',\'brandclass_id\' union  SELECT \'shop_code\',\'5acd6abcb09be\',\'2\',\'0\',\'\',\'\',\'0\',\'shop_code\' union  SELECT \'department_id\',\'5acd6abcb09be\',\'1\',\'0\',\'部门id \',\'部门id\',\'0\',\'department_id\' union  SELECT \'staff_id\',\'5acd6abcb09be\',\'1\',\'0\',\'登记人id\',\'登记人id\',\'0\',\'staff_id\' union  SELECT \'start\',\'5acd6abcb09be\',\'2\',\'0\',\'客资登记开始时间\',\'客资登记开始时间，格式是：2018-04-01 15:30:15,下面参数亦如此\',\'0\',\'start\' union  SELECT \'end\',\'5acd6abcb09be\',\'2\',\'0\',\'客资登记结束时间\',\'客资登记结束时间\',\'0\',\'end\' \r\nCREATE TABLE `s_customer_interface`(`id` int(11)  NOT NULL  AUTO_INCREMENT ,`token` varchar(100)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`url` varchar(255)  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`field_config` text  NOT NULL  COLLATE \'utf8_unicode_ci\' ,`create_time` datetime  NULL ,`update_time` datetime  NULL ,`create_staff_id` int(11)  NULL  DEFAULT 0 ,`create_staff_name` varchar(100)  NULL  DEFAULT 0  COLLATE \'utf8_unicode_ci\' ,`status` tinyint(1)  NOT NULL  DEFAULT 1 ,`is_delete` tinyint(1)  NOT NULL  DEFAULT 2 ,`shop_code` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`shop_name` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,PRIMARY KEY (`id`), INDEX `key1` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\nCREATE TABLE `s_customer_interface_detail`(`id` int(11)  NOT NULL  AUTO_INCREMENT ,`pid` int(11)  NULL  DEFAULT 0 ,`data` text  NULL  COLLATE \'utf8_unicode_ci\' ,`result_code` int(3)  NULL  DEFAULT 0 ,`error_reason` text  NULL  COLLATE \'utf8_unicode_ci\' ,`ip` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ,`staff_id` int(11)  NULL  DEFAULT 0 ,`create_time` datetime  NULL ,`update_staff_id` int(11)  NULL  DEFAULT 0 ,`update_time` datetime  NULL ,PRIMARY KEY (`id`), INDEX `key1` (`id`) ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB \r\n INSERT INTO `s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'第三方录入接口配置\',\'6\',\'menu1523588039\',\'/crm/Setting/customerInterface\',\'1\',\'103\' ', NULL),
	(68, '1.1.64', '2018-04-13 20:46:16', ' ALTER TABLE `s_channel`  ADD COLUMN `order_sort` int(3)  NULL  DEFAULT 0 ', NULL),
	(69, '1.1.65', '2018-04-15 16:33:10', ' INSERT INTO `s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`status`,`sort`)  SELECT \'本店报表设置\',\'5\',\'menu1523775076\',\'\',\'1\',\'1\' ', NULL);
/*!40000 ALTER TABLE `app_version` ENABLE KEYS */;

-- 导出  表 sx_crm.c_allocation_rule 结构
DROP TABLE IF EXISTS `c_allocation_rule`;
CREATE TABLE IF NOT EXISTS `c_allocation_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `isopen` int(11) DEFAULT NULL COMMENT '0关闭，1启用',
  `allocationtype` int(11) DEFAULT NULL COMMENT '0平均，1条件',
  `condition` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `count_day` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_name` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_name` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coderkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_allocation_rule 的数据：~0 rows (大约)
DELETE FROM `c_allocation_rule`;
/*!40000 ALTER TABLE `c_allocation_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_allocation_rule` ENABLE KEYS */;

-- 导出  表 sx_crm.c_allocation_work 结构
DROP TABLE IF EXISTS `c_allocation_work`;
CREATE TABLE IF NOT EXISTS `c_allocation_work` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alloc_type` tinyint(4) DEFAULT NULL COMMENT '平均、自动、手动',
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_day` datetime DEFAULT NULL,
  `fp_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fp_staff_id` int(11) DEFAULT NULL,
  `fp_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `jr_day` datetime DEFAULT NULL,
  `sales_staff2` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_staff_id` int(11) DEFAULT NULL,
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_ok` tinyint(4) DEFAULT NULL,
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `op_signday` datetime DEFAULT NULL,
  `is_success` tinyint(4) DEFAULT NULL,
  `Is_valid` tinyint(4) DEFAULT NULL,
  `is_loss` tinyint(4) DEFAULT NULL,
  `c_star_day` datetime DEFAULT NULL,
  `c_end_day` datetime DEFAULT NULL,
  `totalpay_money` decimal(10,0) DEFAULT NULL,
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_remark` mediumtext COLLATE utf8_unicode_ci,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_allocation_work 的数据：~0 rows (大约)
DELETE FROM `c_allocation_work`;
/*!40000 ALTER TABLE `c_allocation_work` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_allocation_work` ENABLE KEYS */;

-- 导出  表 sx_crm.c_brandclass 结构
DROP TABLE IF EXISTS `c_brandclass`;
CREATE TABLE IF NOT EXISTS `c_brandclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `GroupCompanyName` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_brandclass 的数据：~0 rows (大约)
DELETE FROM `c_brandclass`;
/*!40000 ALTER TABLE `c_brandclass` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_brandclass` ENABLE KEYS */;

-- 导出  表 sx_crm.c_call_registration 结构
DROP TABLE IF EXISTS `c_call_registration`;
CREATE TABLE IF NOT EXISTS `c_call_registration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_id` int(11) DEFAULT NULL,
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_region` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资地域',
  `customer_area` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区',
  `customer_cource` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源',
  `op_signinfo` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记',
  `access_model` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `customer_channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道',
  `customer_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_remark` text COLLATE utf8_unicode_ci,
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dj_staff_id` int(11) DEFAULT NULL,
  `dj_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_orderaddress` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `introducer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '邀约人姓名',
  `tel_alltime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通话总时长',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `audio_path` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='来电记录表';

-- 正在导出表  sx_crm.c_call_registration 的数据：~0 rows (大约)
DELETE FROM `c_call_registration`;
/*!40000 ALTER TABLE `c_call_registration` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_call_registration` ENABLE KEYS */;

-- 导出  表 sx_crm.c_customerinfo 结构
DROP TABLE IF EXISTS `c_customerinfo`;
CREATE TABLE IF NOT EXISTS `c_customerinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `eid` int(11) DEFAULT NULL COMMENT '导入时的id',
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `customer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户性别',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户手机',
  `customer_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微信',
  `customer_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户微博',
  `customer_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT NULL COMMENT '省id',
  `province` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在省',
  `city_id` int(11) DEFAULT NULL,
  `city` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所在市',
  `county_id` int(11) DEFAULT NULL,
  `county` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '县（区）',
  `customer_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地址',
  `mate_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶姓名',
  `mate_sex` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶性别',
  `mate_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶电话',
  `mate_wechat` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微信',
  `mate_weibo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶微博',
  `mate_qq` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mate_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶地址',
  `consultation_type_id` int(11) DEFAULT NULL,
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `customer_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户类型，1新单、2转介绍',
  `consulation_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面编码',
  `consulation_shop` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '意向店面',
  `customer_channel_id` int(11) DEFAULT NULL,
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户渠道',
  `customer_cource_id` int(11) DEFAULT NULL,
  `customer_cource` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户来源',
  `customer_intention_id` int(11) DEFAULT NULL,
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_orderaddress_id` int(11) DEFAULT NULL,
  `customer_orderaddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `access_model_id` int(11) DEFAULT NULL,
  `access_model` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `customer_area_id` int(11) DEFAULT NULL,
  `customer_area` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户分区',
  `customer_region_id` int(11) DEFAULT NULL,
  `customer_region` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户地域',
  `is_intostore` tinyint(4) DEFAULT '1' COMMENT '是否进店，1未进店； 2进店进客；3进店非进客',
  `is_success` tinyint(4) DEFAULT '2' COMMENT '是否成交，1 已成交，2 未成交，3已定金',
  `is_valid` tinyint(4) DEFAULT '2' COMMENT '是否有效，1 有效，2待定，3无效，录入时默认为2',
  `yx_day` datetime DEFAULT NULL COMMENT '标记有效日期',
  `is_urgent` tinyint(4) DEFAULT NULL COMMENT '是否加急，1加急，2否',
  `is_loss` tinyint(4) DEFAULT '2' COMMENT '是否流失，1是，2否',
  `is_dive` tinyint(4) DEFAULT '2' COMMENT '是否潜水，1是，2否',
  `is_sel` tinyint(4) DEFAULT '0' COMMENT '筛客状态，1已筛客，0是未筛客，默认0',
  `is_next` tinyint(1) DEFAULT '2' COMMENT '是否再约：1：是；2：否',
  `next_time` datetime DEFAULT NULL COMMENT '再约时间',
  `is_send_next_msg` tinyint(1) DEFAULT '2' COMMENT '再约提醒信息是否已发送:1:是；2：否',
  `is_send_birthday_msg` tinyint(1) DEFAULT '2' COMMENT '生日提醒信息是否已发送:1:是；2：否',
  `is_send_wedd_msg` tinyint(1) DEFAULT '2' COMMENT '结婚纪念日提醒信息是否已发送:1:是；2：否',
  `op_signinfo` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资标记',
  `op_signday` datetime DEFAULT NULL COMMENT '标记日期',
  `customer_capacity_id` int(11) DEFAULT NULL,
  `customer_capacity` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费能力',
  `photo_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拍照地',
  `customer_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户生日',
  `customer_idtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户证件类型',
  `customer_idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户证件号',
  `mate_birthday` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶生日',
  `mate_idtype` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶证件类型',
  `mate_idnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '配偶证件号码',
  `introducer_type` int(4) DEFAULT '0' COMMENT '提报类型（1：新客；2：现客；3：老客）',
  `introducer_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人姓名',
  `introducer_ordernum` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人单号',
  `introducer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人编号',
  `introducer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '介绍人手机',
  `wedding_date` datetime DEFAULT NULL COMMENT '结婚日期',
  `dj_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工',
  `dj_staff_id` int(11) DEFAULT NULL COMMENT '登记员工id',
  `dj_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '登记员工编号',
  `dj_day` datetime DEFAULT NULL COMMENT '登记日期',
  `fp_staff_id` int(11) DEFAULT NULL COMMENT '分配人员id',
  `fp_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员',
  `fp_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分配人员编号',
  `fp_day` datetime DEFAULT NULL COMMENT '分配日期',
  `is_fp` tinyint(4) DEFAULT '2' COMMENT '是否分配，1已分配，2未分配，3待接收,4分配失败',
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员',
  `sales_staff_id` int(11) DEFAULT NULL COMMENT '销售人员id',
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售人员编号',
  `jr_day` datetime DEFAULT NULL COMMENT '接入日期',
  `yjd_day` datetime DEFAULT NULL COMMENT '预约进店日期',
  `syjd_day` datetime DEFAULT NULL COMMENT '实际进店日期',
  `yp_day` datetime DEFAULT NULL COMMENT '预拍日期',
  `order_day` datetime DEFAULT NULL COMMENT '成交订单日期',
  `totalpay_money` decimal(10,0) DEFAULT NULL COMMENT '消费金额',
  `order_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单单号',
  `seles_step` int(11) DEFAULT NULL COMMENT '追踪阶段id',
  `step_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪阶段名称',
  `c_star_day` datetime DEFAULT NULL COMMENT '客资追踪开始日期',
  `c_end_day` datetime DEFAULT NULL COMMENT '客资追踪结束日期',
  `last_trackday` datetime DEFAULT NULL COMMENT '最后一次追踪日期',
  `creator_day` datetime DEFAULT NULL COMMENT '创建日期',
  `seles_error_id` int(11) DEFAULT NULL COMMENT '追踪失败原因id',
  `seles_error_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪失败原因',
  `customer_remark` text COLLATE utf8_unicode_ci COMMENT '客户备注',
  `sel_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '筛客人',
  `sel_staff_id` int(11) DEFAULT NULL,
  `sel_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `photo_day` datetime DEFAULT NULL COMMENT '实际拍照日期',
  `sel_day` datetime DEFAULT NULL COMMENT '筛客日期',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属品牌（事业部）',
  `is_status` int(11) DEFAULT '1',
  `sign_id` int(11) DEFAULT NULL,
  `sign_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `tel_visit_num` int(11) DEFAULT '0',
  `loss_cause` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  `add_shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_sk` tinyint(2) DEFAULT '2',
  `sk_staff_id` int(11) DEFAULT NULL,
  `sk_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sk_time` datetime DEFAULT NULL,
  `tel_staff_id` int(11) DEFAULT NULL,
  `tel_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_time` datetime DEFAULT NULL,
  `is_already_sk` tinyint(2) DEFAULT '2',
  `is_first_tel` tinyint(2) DEFAULT NULL,
  `channel_plan_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_key` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `intostore_note` text COLLATE utf8_unicode_ci,
  `ready_baby_day` datetime DEFAULT NULL,
  `baby_birthday` datetime DEFAULT NULL,
  `baby_address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `marry_day` datetime DEFAULT NULL,
  `fp_time_out` int(10) DEFAULT NULL,
  `img_record` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `track_record` text COLLATE utf8_unicode_ci,
  `budget` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fact_money` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_belong` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_operator` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_area_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `reception_id` int(11) DEFAULT NULL,
  `reception_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_first_wechat` tinyint(2) DEFAULT NULL,
  `wechat_staff_id` int(11) DEFAULT NULL,
  `wechat_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wechat_time` datetime DEFAULT NULL,
  `is_first_qq` tinyint(2) DEFAULT NULL,
  `qq_staff_id` int(11) DEFAULT NULL,
  `qq_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `qq_time` datetime DEFAULT NULL,
  `c_from` tinyint(2) NOT NULL DEFAULT '1',
  `order_start_time` datetime DEFAULT NULL,
  `order_type` tinyint(4) DEFAULT '1',
  `is_send_yjd_msg` tinyint(1) DEFAULT '2' COMMENT '是否已发预进店信息：1：是；2：否',
  `is_send_syjd_msg` tinyint(1) DEFAULT '2' COMMENT '是否已发进店信息：1：是；2：否',
  `sign_time` datetime DEFAULT NULL,
  `loss_day` datetime DEFAULT NULL,
  `op_signinfo_id` int(11) DEFAULT '0',
  `is_act` int(2) DEFAULT '1',
  `yjd_action_day` datetime DEFAULT NULL,
  `reject_reason` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reject_remark` text COLLATE utf8_unicode_ci,
  `loss_remark` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`) USING BTREE,
  KEY `all_staff` (`dj_staff_id`,`fp_staff_id`,`sales_staff_id`,`sk_staff_id`) USING BTREE,
  KEY `customer_contact` (`customer_tel`,`customer_wechat`,`customer_qq`,`mate_tel`) USING BTREE,
  KEY `shop_code` (`shop_code`,`add_shop_code`,`brandclass_id`) USING BTREE,
  KEY `status` (`is_intostore`,`is_success`,`is_valid`,`is_loss`,`is_sel`,`is_fp`,`is_status`,`c_from`,`order_type`) USING BTREE,
  KEY `all_time` (`dj_day`,`fp_day`,`jr_day`,`yjd_day`,`syjd_day`,`yp_day`,`order_day`,`c_star_day`,`c_end_day`,`creator_day`,`create_time`,`sk_time`,`order_start_time`,`sign_time`) USING BTREE,
  FULLTEXT KEY `full_text` (`customer_name`,`customer_tel`,`order_number`,`customer_wechat`,`customer_qq`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资信息表';

-- 正在导出表  sx_crm.c_customerinfo 的数据：~0 rows (大约)
DELETE FROM `c_customerinfo`;
/*!40000 ALTER TABLE `c_customerinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_customerinfo` ENABLE KEYS */;

-- 导出  表 sx_crm.c_customer_contact 结构
DROP TABLE IF EXISTS `c_customer_contact`;
CREATE TABLE IF NOT EXISTS `c_customer_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `c_id` int(11) DEFAULT NULL,
  `contact` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='联系方式表，排重';

-- 正在导出表  sx_crm.c_customer_contact 的数据：~0 rows (大约)
DELETE FROM `c_customer_contact`;
/*!40000 ALTER TABLE `c_customer_contact` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_customer_contact` ENABLE KEYS */;

-- 导出  表 sx_crm.c_customer_cost 结构
DROP TABLE IF EXISTS `c_customer_cost`;
CREATE TABLE IF NOT EXISTS `c_customer_cost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost_time` date DEFAULT NULL,
  `cost_avg` decimal(10,4) DEFAULT '0.0000',
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT '0',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `return_avg` decimal(10,4) DEFAULT NULL,
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道、成本、返点 花费分摊表';

-- 正在导出表  sx_crm.c_customer_cost 的数据：~0 rows (大约)
DELETE FROM `c_customer_cost`;
/*!40000 ALTER TABLE `c_customer_cost` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_customer_cost` ENABLE KEYS */;

-- 导出  表 sx_crm.c_customer_cost_copy 结构
DROP TABLE IF EXISTS `c_customer_cost_copy`;
CREATE TABLE IF NOT EXISTS `c_customer_cost_copy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost_time` date DEFAULT NULL,
  `cost_avg` decimal(10,4) DEFAULT '0.0000',
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT '0',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `return_avg` decimal(10,4) DEFAULT NULL,
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道、成本、返点 花费分摊表';

-- 正在导出表  sx_crm.c_customer_cost_copy 的数据：~0 rows (大约)
DELETE FROM `c_customer_cost_copy`;
/*!40000 ALTER TABLE `c_customer_cost_copy` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_customer_cost_copy` ENABLE KEYS */;

-- 导出  表 sx_crm.c_customer_order 结构
DROP TABLE IF EXISTS `c_customer_order`;
CREATE TABLE IF NOT EXISTS `c_customer_order` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_channel_id` int(10) DEFAULT NULL,
  `customer_channel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户渠道',
  `order_status` tinyint(1) DEFAULT '1' COMMENT '状态（1:已成交；2：未成交）默认1；',
  `order_valid` int(2) DEFAULT '1' COMMENT '有效订单（1：无效；2：有效）默认1',
  `order_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `earnest_money` decimal(10,2) DEFAULT NULL COMMENT '定金',
  `order_fact` decimal(10,2) DEFAULT NULL COMMENT '实际收款(订单金额达到标准，订单成为有效订单时启用)',
  `order_amount` decimal(10,2) DEFAULT NULL COMMENT '订单总额',
  `consultation_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `customer_orderaddress` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_type` tinyint(1) DEFAULT '1',
  `order_source` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `two_pin_fact` decimal(9,0) DEFAULT NULL,
  `two_pin_amount` decimal(9,0) DEFAULT NULL,
  `order_note` text COLLATE utf8_unicode_ci,
  `target_time` datetime DEFAULT NULL,
  `brandclass_id` int(11) NOT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户订单表';

-- 正在导出表  sx_crm.c_customer_order 的数据：~0 rows (大约)
DELETE FROM `c_customer_order`;
/*!40000 ALTER TABLE `c_customer_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_customer_order` ENABLE KEYS */;

-- 导出  表 sx_crm.c_customer_tel 结构
DROP TABLE IF EXISTS `c_customer_tel`;
CREATE TABLE IF NOT EXISTS `c_customer_tel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_belong` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_operator` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tel_area_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='手机归属地表';

-- 正在导出表  sx_crm.c_customer_tel 的数据：~64 rows (大约)
DELETE FROM `c_customer_tel`;
/*!40000 ALTER TABLE `c_customer_tel` DISABLE KEYS */;
INSERT INTO `c_customer_tel` (`id`, `customer_tel`, `tel_belong`, `tel_operator`, `tel_area_code`) VALUES
	(1, '13143256789', '广东 东莞', '联通', '0769'),
	(2, '18801299999', '北京', '移动', '010'),
	(3, '18801299997', '北京', '移动', '010'),
	(4, '18801299996', '北京', '移动', '010'),
	(5, '18801298888', '北京', '移动', '010'),
	(6, '18801299888', '北京', '移动', '010'),
	(7, '18801299898', '北京', '移动', '010'),
	(8, '18801299885', '北京', '移动', '010'),
	(9, '18801299896', '北京', '移动', '010'),
	(10, '18801299994', '北京', '移动', '010'),
	(11, '18801299990', '北京', '移动', '010'),
	(12, '18801299992', '北京', '移动', '010'),
	(13, '18899081234', '新疆 乌鲁木齐', '移动', '0991'),
	(14, '18801299989', '北京', '移动', '010'),
	(15, '18801299988', '北京', '移动', '010'),
	(16, '18801298887', '北京', '移动', '010'),
	(17, '18801299870', '北京', '移动', '010'),
	(18, '18801299886', '北京', '移动', '010'),
	(19, '18801298765', '北京', '移动', '010'),
	(20, '18801299877', '北京', '移动', '010'),
	(21, '18801298777', '北京', '移动', '010'),
	(22, '18801222222', '北京', '移动', '010'),
	(23, '18801222223', '北京', '移动', '010'),
	(24, '18801222224', '北京', '移动', '010'),
	(25, '18001111111', '北京', '电信', '010'),
	(26, '17725555555', '河北 保定', '电信', '0312'),
	(27, '18944444444', '江苏 南通', '电信', '0513'),
	(28, '18801299880', '北京', '移动', '010'),
	(29, '18801289999', '北京', '移动', '010'),
	(30, '18801009999', '北京', '移动', '010'),
	(31, '18801299876', '北京', '移动', '010'),
	(32, '18802213123', '天津', '移动', '022'),
	(33, '18801299666', '北京', '移动', '010'),
	(34, '18889128391', '海南 海口', '移动', '0898'),
	(35, '18800009999', '北京', '移动', '010'),
	(36, '18800000090', '北京', '移动', '010'),
	(37, '18801299993', '北京', '移动', '010'),
	(38, '13515303738', '山东 菏泽', '移动', '0530'),
	(39, '18232179413', '河北 石家庄', '移动', '0311'),
	(40, '18800000091', '北京', '移动', '010'),
	(41, '18800000085', '北京', '移动', '010'),
	(42, '15311440759', '北京', '电信', '010'),
	(43, '13703105407', '河北 邯郸', '移动', '0310'),
	(44, '15311440769', '北京', '电信', '010'),
	(45, '15311440768', '北京', '电信', '010'),
	(46, '13569874555', '河南 新乡', '移动', '0373'),
	(47, '13456554645', '浙江 绍兴', '移动', '0575'),
	(48, '13433332222', '广东 汕头', '移动', '0754'),
	(49, '13654998670', '辽宁 沈阳', '移动', '024'),
	(50, '13654998622', '辽宁 沈阳', '移动', '024'),
	(51, '13654998623', '辽宁 沈阳', '移动', '024'),
	(52, '13552586828', '北京', '移动', '010'),
	(53, '18040015000', '辽宁 沈阳', '电信', '024'),
	(54, '18137165861', '河南 郑州', '电信', '0371'),
	(55, '13578894943', '吉林 长春', '移动', '0431'),
	(56, '13552584883', '北京', '移动', '010'),
	(57, '13588384302', '浙江 杭州', '移动', '0571'),
	(58, '13594830284', '重庆', '移动', '023'),
	(59, '18111105111', '四川 成都', '电信', '028'),
	(60, '13233434555', '山西 阳泉', '联通', '0353'),
	(61, '13222344567', '江苏 盐城', '联通', '0515'),
	(62, '18000156678', '江苏 宿迁', '电信', '0527'),
	(63, '18500805407', '北京', '联通', '010'),
	(64, '18562412541', '山东 济宁', '联通', '0537');
/*!40000 ALTER TABLE `c_customer_tel` ENABLE KEYS */;

-- 导出  表 sx_crm.c_day_number 结构
DROP TABLE IF EXISTS `c_day_number`;
CREATE TABLE IF NOT EXISTS `c_day_number` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `dj_customer` int(11) unsigned DEFAULT '0' COMMENT '提报客资数',
  `dj_mobile` int(11) unsigned DEFAULT '0' COMMENT '提报手机号数',
  `sel_customer` int(11) DEFAULT '0' COMMENT '筛客人的筛客数量',
  `fp_customer` int(11) unsigned DEFAULT '0' COMMENT '分配客资数',
  `fp_no_mobile` int(11) unsigned DEFAULT '0' COMMENT '分配无手机号数',
  `add_mobile` int(11) unsigned DEFAULT '0' COMMENT '新增手机号数',
  `valid_customer` int(11) unsigned DEFAULT '0' COMMENT '有效客资数',
  `no_valid_customer` int(11) unsigned DEFAULT '0' COMMENT '无效客资数',
  `yjd` int(11) unsigned DEFAULT '0' COMMENT '预约进店数',
  `syjd_jk` int(11) unsigned DEFAULT '0' COMMENT '实际进店数，进客',
  `syjd_no_jk` int(11) unsigned DEFAULT '0' COMMENT '实际进店数，非进客',
  `orders` int(11) unsigned DEFAULT '0' COMMENT '成单数',
  `valid_order` int(11) unsigned DEFAULT '0' COMMENT '有效成单数',
  `tel_visit` int(11) DEFAULT '0' COMMENT '电访量',
  `a_customer` int(11) unsigned DEFAULT '0' COMMENT 'A客数',
  `addtime` date DEFAULT NULL COMMENT '数据插入时间',
  `staff_id` int(11) DEFAULT NULL COMMENT '操作人id',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名字',
  `staff_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编码',
  `group_id` int(11) DEFAULT NULL COMMENT '组id',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `dj_xw` int(11) DEFAULT NULL,
  `dj_qq` int(11) DEFAULT NULL,
  `today_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='日统计表';

-- 正在导出表  sx_crm.c_day_number 的数据：~0 rows (大约)
DELETE FROM `c_day_number`;
/*!40000 ALTER TABLE `c_day_number` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_day_number` ENABLE KEYS */;

-- 导出  表 sx_crm.c_ds_report 结构
DROP TABLE IF EXISTS `c_ds_report`;
CREATE TABLE IF NOT EXISTS `c_ds_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `channel` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `region` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `cost` decimal(12,4) DEFAULT NULL,
  `return_cost` decimal(12,4) DEFAULT NULL,
  `new_customer` int(11) DEFAULT NULL,
  `valid_customer` int(11) DEFAULT NULL,
  `acquisition_rate` decimal(7,4) DEFAULT NULL,
  `invitation` int(11) DEFAULT NULL,
  `into` int(11) DEFAULT NULL,
  `in_rate` decimal(7,4) DEFAULT NULL,
  `order_num` int(11) DEFAULT NULL,
  `deal_rate` decimal(7,4) DEFAULT NULL,
  `change_rate` decimal(7,4) DEFAULT NULL,
  `orer_amount` decimal(12,4) DEFAULT NULL,
  `earning` decimal(12,4) DEFAULT NULL,
  `average_price` decimal(12,4) DEFAULT NULL,
  `obtain_cost` decimal(12,4) DEFAULT NULL,
  `vaild_cost` decimal(12,4) DEFAULT NULL,
  `deal_cost` decimal(12,4) DEFAULT NULL,
  `roi` decimal(12,4) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='电商渠道花费月报表';

-- 正在导出表  sx_crm.c_ds_report 的数据：~0 rows (大约)
DELETE FROM `c_ds_report`;
/*!40000 ALTER TABLE `c_ds_report` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_ds_report` ENABLE KEYS */;

-- 导出  表 sx_crm.c_erp_save 结构
DROP TABLE IF EXISTS `c_erp_save`;
CREATE TABLE IF NOT EXISTS `c_erp_save` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `data` text COLLATE utf8_unicode_ci,
  `create_time` datetime DEFAULT NULL,
  `error_count` int(4) NOT NULL DEFAULT '1',
  `call_time` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `type` int(4) NOT NULL DEFAULT '1',
  `cid` int(11) DEFAULT NULL,
  `oid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='erp接口调用失败，缓存表';

-- 正在导出表  sx_crm.c_erp_save 的数据：~0 rows (大约)
DELETE FROM `c_erp_save`;
/*!40000 ALTER TABLE `c_erp_save` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_erp_save` ENABLE KEYS */;

-- 导出  表 sx_crm.c_excel_import 结构
DROP TABLE IF EXISTS `c_excel_import`;
CREATE TABLE IF NOT EXISTS `c_excel_import` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上传文件名',
  `file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fail_file_url` varchar(300) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '错误文件地址',
  `staff_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编号',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工姓名',
  `addtime` datetime DEFAULT NULL COMMENT '导入时间',
  `status` tinyint(2) DEFAULT '0' COMMENT '导入状态，0未导入，1已导入，2正在导入，默认为0',
  `all_number` int(11) DEFAULT '0' COMMENT '数据总条数',
  `import_number` int(11) DEFAULT '0' COMMENT '成功导入条数',
  `fail_number` int(11) DEFAULT '0' COMMENT '导入失败数据条数',
  `is_sk` tinyint(1) DEFAULT '2',
  `sk_staff_id` int(11) DEFAULT NULL,
  `sk_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `import_fail` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='导入记录表';

-- 正在导出表  sx_crm.c_excel_import 的数据：~0 rows (大约)
DELETE FROM `c_excel_import`;
/*!40000 ALTER TABLE `c_excel_import` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_excel_import` ENABLE KEYS */;

-- 导出  表 sx_crm.c_fp_pool 结构
DROP TABLE IF EXISTS `c_fp_pool`;
CREATE TABLE IF NOT EXISTS `c_fp_pool` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) DEFAULT NULL,
  `msg` text COLLATE utf8_unicode_ci,
  `fp_time_out` int(10) DEFAULT NULL,
  `count` int(10) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `pool_type` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分配失败缓存表';

-- 正在导出表  sx_crm.c_fp_pool 的数据：~0 rows (大约)
DELETE FROM `c_fp_pool`;
/*!40000 ALTER TABLE `c_fp_pool` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_fp_pool` ENABLE KEYS */;

-- 导出  表 sx_crm.c_history_data 结构
DROP TABLE IF EXISTS `c_history_data`;
CREATE TABLE IF NOT EXISTS `c_history_data` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `message` text COLLATE utf8_unicode_ci COMMENT '数据统计队列里的值',
  `type` int(2) DEFAULT NULL COMMENT '类型（1：单条数据处理；2：多条数据处理）',
  `success_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '成功的customer_id',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='数据统计队列表';

-- 正在导出表  sx_crm.c_history_data 的数据：~0 rows (大约)
DELETE FROM `c_history_data`;
/*!40000 ALTER TABLE `c_history_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_history_data` ENABLE KEYS */;

-- 导出  表 sx_crm.c_hour_number 结构
DROP TABLE IF EXISTS `c_hour_number`;
CREATE TABLE IF NOT EXISTS `c_hour_number` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `dj_customer` int(11) unsigned DEFAULT '0' COMMENT '提报客资数',
  `dj_mobile` int(11) unsigned DEFAULT '0' COMMENT '提报手机号数',
  `sel_customer` int(11) DEFAULT '0' COMMENT '筛客人的筛客数量',
  `fp_customer` int(11) unsigned DEFAULT '0' COMMENT '分配客资数',
  `fp_no_mobile` int(11) unsigned DEFAULT '0' COMMENT '分配无手机号数',
  `add_mobile` int(11) unsigned DEFAULT '0' COMMENT '新增手机号数',
  `valid_customer` int(11) unsigned DEFAULT '0' COMMENT '有效客资数',
  `no_valid_customer` int(11) unsigned DEFAULT '0' COMMENT '无效客资数',
  `yjd` int(11) unsigned DEFAULT '0' COMMENT '预约进店数',
  `syjd_jk` int(11) unsigned DEFAULT '0' COMMENT '实际进店数，进客',
  `syjd_no_jk` int(11) unsigned DEFAULT '0' COMMENT '实际进店数，非进客',
  `orders` int(11) unsigned DEFAULT '0' COMMENT '成单数',
  `valid_order` int(11) unsigned DEFAULT '0' COMMENT '有效成单数',
  `tel_visit` int(11) DEFAULT '0' COMMENT '电访量',
  `a_customer` int(11) unsigned DEFAULT '0' COMMENT 'A客数',
  `addtime` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '数据插入时间,精确到时',
  `staff_id` int(11) DEFAULT NULL COMMENT '员工id',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工名字',
  `staff_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '员工编码',
  `group_id` int(11) DEFAULT NULL COMMENT '组id',
  `department_id` int(11) DEFAULT '0' COMMENT '部门id',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面识别码',
  `dj_xw` int(11) DEFAULT NULL,
  `dj_qq` int(11) DEFAULT NULL,
  `today_order` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='时统计表';

-- 正在导出表  sx_crm.c_hour_number 的数据：~0 rows (大约)
DELETE FROM `c_hour_number`;
/*!40000 ALTER TABLE `c_hour_number` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_hour_number` ENABLE KEYS */;

-- 导出  表 sx_crm.c_message 结构
DROP TABLE IF EXISTS `c_message`;
CREATE TABLE IF NOT EXISTS `c_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `send_type` int(4) DEFAULT '1' COMMENT '发送的消息类型:1:短消息(弹窗)；2：通知',
  `send_id` int(11) DEFAULT NULL COMMENT '发送者id（-1：为系统发送）',
  `send_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送者名称（系统：system）',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `send_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消息标题',
  `send_msg` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送的消息内容',
  `operation_type` int(4) DEFAULT NULL COMMENT '操作类型（1：可操作；2：不可操作）',
  `operation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作方法（二维数组的json）',
  `time_out` char(13) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '过期时间的时间戳',
  `customer_id` int(11) DEFAULT NULL COMMENT '客资id',
  `receive_id` int(11) DEFAULT NULL COMMENT '接收者id',
  `receive_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接收者姓名',
  `receive_status` int(4) DEFAULT '0' COMMENT '接收状态（0：未接收；1：已接收；2：已放弃）',
  `receive_time` datetime DEFAULT NULL COMMENT '接收/放弃 时间',
  `read_status` int(4) DEFAULT '0' COMMENT '阅读状态（0：未读；1：已读）',
  `read_time` datetime DEFAULT NULL COMMENT '阅读消息时间',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否删除：1：删除；0：未删除',
  PRIMARY KEY (`id`),
  KEY `id` (`id`,`send_id`,`receive_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消息通知表';

-- 正在导出表  sx_crm.c_message 的数据：~0 rows (大约)
DELETE FROM `c_message`;
/*!40000 ALTER TABLE `c_message` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_message` ENABLE KEYS */;

-- 导出  表 sx_crm.c_order_detail 结构
DROP TABLE IF EXISTS `c_order_detail`;
CREATE TABLE IF NOT EXISTS `c_order_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_sn` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `pay_time` date DEFAULT NULL,
  `order_valid` tinyint(2) DEFAULT '1',
  `order_type` tinyint(2) DEFAULT '2',
  `order_fact` decimal(10,4) DEFAULT '0.0000',
  `two_pin_fact` decimal(10,4) DEFAULT '0.0000',
  `create_time` datetime DEFAULT NULL,
  `pay_type` int(2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_order_detail 的数据：~0 rows (大约)
DELETE FROM `c_order_detail`;
/*!40000 ALTER TABLE `c_order_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_order_detail` ENABLE KEYS */;

-- 导出  表 sx_crm.c_reminditemset 结构
DROP TABLE IF EXISTS `c_reminditemset`;
CREATE TABLE IF NOT EXISTS `c_reminditemset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remind_type` varchar(500) DEFAULT NULL,
  `isopen` int(11) DEFAULT NULL,
  `Advancehour` int(11) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.c_reminditemset 的数据：~0 rows (大约)
DELETE FROM `c_reminditemset`;
/*!40000 ALTER TABLE `c_reminditemset` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_reminditemset` ENABLE KEYS */;

-- 导出  表 sx_crm.c_salestrackinginfo 结构
DROP TABLE IF EXISTS `c_salestrackinginfo`;
CREATE TABLE IF NOT EXISTS `c_salestrackinginfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gtType` tinyint(4) DEFAULT NULL COMMENT '沟通方式(电话/微信/QQ/其他)',
  `customer_id` int(11) DEFAULT NULL COMMENT '客户id',
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户编号',
  `sales_day` datetime DEFAULT NULL COMMENT '追踪日期',
  `sales_staff` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售追踪人员',
  `sales_staff_id` int(11) DEFAULT NULL COMMENT '销售追踪人ID',
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '销售追踪编号',
  `customer_intention` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户意向',
  `customer_tel` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '拨打号码',
  `tel_starttime` datetime DEFAULT NULL COMMENT '拨打开始时间',
  `tel_endtime` datetime DEFAULT NULL COMMENT '拨打结束时间',
  `tel_alltime` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通话总时长',
  `sales_remark` text COLLATE utf8_unicode_ci COMMENT '追踪备注',
  `tel_type` tinyint(4) DEFAULT NULL COMMENT '呼叫方式(主叫、被叫)',
  `seles_step` int(11) DEFAULT NULL COMMENT '沟通进度',
  `step_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪阶段',
  `consultation_type` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `tel_static` tinyint(4) DEFAULT NULL COMMENT '是否接通(关键、未接通、已接通)',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `audio_path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='营销追踪记录表C_salestrackinginfo';

-- 正在导出表  sx_crm.c_salestrackinginfo 的数据：~0 rows (大约)
DELETE FROM `c_salestrackinginfo`;
/*!40000 ALTER TABLE `c_salestrackinginfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_salestrackinginfo` ENABLE KEYS */;

-- 导出  表 sx_crm.c_send_message_log 结构
DROP TABLE IF EXISTS `c_send_message_log`;
CREATE TABLE IF NOT EXISTS `c_send_message_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `send_id` int(11) DEFAULT NULL COMMENT '发送者id',
  `send_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送者名称',
  `send_content` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送的消息内容',
  `model_id` int(11) DEFAULT NULL COMMENT '模板id',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `receive_id` int(11) DEFAULT NULL COMMENT '接受者id',
  `receive_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接收者姓名',
  `receive_phone` varchar(15) COLLATE utf8_unicode_ci NOT NULL COMMENT '接收人手机号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信发送日志表';

-- 正在导出表  sx_crm.c_send_message_log 的数据：~0 rows (大约)
DELETE FROM `c_send_message_log`;
/*!40000 ALTER TABLE `c_send_message_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_send_message_log` ENABLE KEYS */;

-- 导出  表 sx_crm.c_shopset 结构
DROP TABLE IF EXISTS `c_shopset`;
CREATE TABLE IF NOT EXISTS `c_shopset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `sn` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `numberorder` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `shopaddress` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `receiv_shop_code` varchar(3000) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_op1` int(11) DEFAULT NULL,
  `is_op2` int(11) DEFAULT NULL,
  `is_op3` int(11) DEFAULT NULL,
  `is_op4` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.c_shopset 的数据：~0 rows (大约)
DELETE FROM `c_shopset`;
/*!40000 ALTER TABLE `c_shopset` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_shopset` ENABLE KEYS */;

-- 导出  表 sx_crm.c_staff_ability 结构
DROP TABLE IF EXISTS `c_staff_ability`;
CREATE TABLE IF NOT EXISTS `c_staff_ability` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `positioninfo_name` varchar(100) DEFAULT NULL,
  `abilityItem` varchar(1000) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.c_staff_ability 的数据：~0 rows (大约)
DELETE FROM `c_staff_ability`;
/*!40000 ALTER TABLE `c_staff_ability` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_staff_ability` ENABLE KEYS */;

-- 导出  表 sx_crm.c_staff_group 结构
DROP TABLE IF EXISTS `c_staff_group`;
CREATE TABLE IF NOT EXISTS `c_staff_group` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `group_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '组名',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属部门',
  `create_staff_id` int(11) DEFAULT NULL COMMENT '创建人id',
  `create_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  `create_time` datetime DEFAULT NULL,
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_staff_group 的数据：~0 rows (大约)
DELETE FROM `c_staff_group`;
/*!40000 ALTER TABLE `c_staff_group` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_staff_group` ENABLE KEYS */;

-- 导出  表 sx_crm.c_staff_group_relation 结构
DROP TABLE IF EXISTS `c_staff_group_relation`;
CREATE TABLE IF NOT EXISTS `c_staff_group_relation` (
  `group_id` int(11) unsigned NOT NULL DEFAULT '0',
  `staff_id` int(11) unsigned DEFAULT '0' COMMENT '人员',
  `is_admin` tinyint(1) DEFAULT '0' COMMENT '是否管理员：1：是；0：不是'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='小组关系表';

-- 正在导出表  sx_crm.c_staff_group_relation 的数据：~0 rows (大约)
DELETE FROM `c_staff_group_relation`;
/*!40000 ALTER TABLE `c_staff_group_relation` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_staff_group_relation` ENABLE KEYS */;

-- 导出  表 sx_crm.c_swap_customer 结构
DROP TABLE IF EXISTS `c_swap_customer`;
CREATE TABLE IF NOT EXISTS `c_swap_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `swap_number` char(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `customer_number` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0',
  `c_is_valid` tinyint(2) DEFAULT '0',
  `is_valid` tinyint(2) DEFAULT '0',
  `c_is_intostore` tinyint(2) DEFAULT '0',
  `is_intostore` tinyint(2) DEFAULT '0',
  `c_is_success` tinyint(2) DEFAULT '0',
  `is_success` tinyint(2) DEFAULT '0',
  `sales_staff_id` int(11) DEFAULT '0',
  `sales_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sales_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `create_time` datetime DEFAULT NULL,
  `c_yjd_day` datetime NOT NULL,
  `yjd_day` datetime NOT NULL,
  `c_yjd_action_day` datetime DEFAULT NULL,
  `yjd_action_day` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_swap_customer 的数据：~0 rows (大约)
DELETE FROM `c_swap_customer`;
/*!40000 ALTER TABLE `c_swap_customer` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_swap_customer` ENABLE KEYS */;

-- 导出  表 sx_crm.c_sysconfig 结构
DROP TABLE IF EXISTS `c_sysconfig`;
CREATE TABLE IF NOT EXISTS `c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.c_sysconfig 的数据：~0 rows (大约)
DELETE FROM `c_sysconfig`;
/*!40000 ALTER TABLE `c_sysconfig` DISABLE KEYS */;
/*!40000 ALTER TABLE `c_sysconfig` ENABLE KEYS */;

-- 导出  表 sx_crm.s_acceptoraddress 结构
DROP TABLE IF EXISTS `s_acceptoraddress`;
CREATE TABLE IF NOT EXISTS `s_acceptoraddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acceptoraddress_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接单点设定',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='接单点设定';

-- 正在导出表  sx_crm.s_acceptoraddress 的数据：~0 rows (大约)
DELETE FROM `s_acceptoraddress`;
/*!40000 ALTER TABLE `s_acceptoraddress` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_acceptoraddress` ENABLE KEYS */;

-- 导出  表 sx_crm.s_accessmodel 结构
DROP TABLE IF EXISTS `s_accessmodel`;
CREATE TABLE IF NOT EXISTS `s_accessmodel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `accessmodel` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '获取方式',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='获取方式设定';

-- 正在导出表  sx_crm.s_accessmodel 的数据：~0 rows (大约)
DELETE FROM `s_accessmodel`;
/*!40000 ALTER TABLE `s_accessmodel` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_accessmodel` ENABLE KEYS */;

-- 导出  表 sx_crm.s_allocation_rule 结构
DROP TABLE IF EXISTS `s_allocation_rule`;
CREATE TABLE IF NOT EXISTS `s_allocation_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `isopen` int(11) DEFAULT '1' COMMENT '0关闭，1启用',
  `allocationtype` int(11) DEFAULT '0' COMMENT '0平均，1条件',
  `allocationtype_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '条件分配值',
  `active_time` varchar(50) COLLATE utf8_unicode_ci DEFAULT 'this_week' COMMENT '分配有效时间',
  `customer_condition` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道来源字段',
  `customer_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源值',
  `group_id` int(11) DEFAULT NULL COMMENT '小组ID',
  `group_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_id` int(11) DEFAULT NULL COMMENT '主岗位id',
  `position_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主岗位名',
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `order_sort` smallint(5) unsigned DEFAULT '1' COMMENT '排序规则',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='分配设定表';

-- 正在导出表  sx_crm.s_allocation_rule 的数据：~0 rows (大约)
DELETE FROM `s_allocation_rule`;
/*!40000 ALTER TABLE `s_allocation_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_allocation_rule` ENABLE KEYS */;

-- 导出  表 sx_crm.s_areaset 结构
DROP TABLE IF EXISTS `s_areaset`;
CREATE TABLE IF NOT EXISTS `s_areaset` (
  `id` int(11) NOT NULL,
  `arer_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '分区名称',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='客户分区设定';

-- 正在导出表  sx_crm.s_areaset 的数据：~0 rows (大约)
DELETE FROM `s_areaset`;
/*!40000 ALTER TABLE `s_areaset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_areaset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_brandclass 结构
DROP TABLE IF EXISTS `s_brandclass`;
CREATE TABLE IF NOT EXISTS `s_brandclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(50) DEFAULT NULL,
  `GroupCompanyName` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_brandclass 的数据：~0 rows (大约)
DELETE FROM `s_brandclass`;
/*!40000 ALTER TABLE `s_brandclass` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_brandclass` ENABLE KEYS */;

-- 导出  表 sx_crm.s_call_prefix 结构
DROP TABLE IF EXISTS `s_call_prefix`;
CREATE TABLE IF NOT EXISTS `s_call_prefix` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_call_prefix 的数据：~0 rows (大约)
DELETE FROM `s_call_prefix`;
/*!40000 ALTER TABLE `s_call_prefix` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_call_prefix` ENABLE KEYS */;

-- 导出  表 sx_crm.s_channel 结构
DROP TABLE IF EXISTS `s_channel`;
CREATE TABLE IF NOT EXISTS `s_channel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel_class_id` int(11) NOT NULL,
  `channel_class_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channel_info_id` int(11) NOT NULL,
  `channel_info_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `channel_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `brandclass_id` int(11) DEFAULT NULL,
  `brandclass_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `order_sort` int(3) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `key1` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_channel 的数据：~0 rows (大约)
DELETE FROM `s_channel`;
/*!40000 ALTER TABLE `s_channel` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_channel` ENABLE KEYS */;

-- 导出  表 sx_crm.s_channelclass 结构
DROP TABLE IF EXISTS `s_channelclass`;
CREATE TABLE IF NOT EXISTS `s_channelclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channelcolumn` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道类型描述',
  `channelclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_channelclass 的数据：~0 rows (大约)
DELETE FROM `s_channelclass`;
/*!40000 ALTER TABLE `s_channelclass` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_channelclass` ENABLE KEYS */;

-- 导出  表 sx_crm.s_channelinfo 结构
DROP TABLE IF EXISTS `s_channelinfo`;
CREATE TABLE IF NOT EXISTS `s_channelinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channelclass` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道类别名称',
  `channel_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道名称',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='渠道名称设定';

-- 正在导出表  sx_crm.s_channelinfo 的数据：~0 rows (大约)
DELETE FROM `s_channelinfo`;
/*!40000 ALTER TABLE `s_channelinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_channelinfo` ENABLE KEYS */;

-- 导出  表 sx_crm.s_channel_cost 结构
DROP TABLE IF EXISTS `s_channel_cost`;
CREATE TABLE IF NOT EXISTS `s_channel_cost` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `chan_id` int(255) DEFAULT NULL COMMENT '渠道类型id ',
  `channelclass` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道类型名',
  `channel_id` int(11) DEFAULT NULL,
  `channel_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '渠道名',
  `area_id` int(11) DEFAULT NULL COMMENT '地域id',
  `area_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地域名',
  `region_id` int(11) DEFAULT NULL COMMENT '地区id',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地区名',
  `cost` decimal(10,4) DEFAULT NULL,
  `year` varchar(5) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '年份',
  `month` tinyint(2) DEFAULT NULL COMMENT '月份',
  `cost_avg` decimal(10,4) DEFAULT NULL COMMENT '花费平均值',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_end_day` tinyint(1) NOT NULL DEFAULT '2',
  `staff_id` int(11) DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `cost_date` date DEFAULT NULL COMMENT '花费设定时间',
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='渠道花费表';

-- 正在导出表  sx_crm.s_channel_cost 的数据：~0 rows (大约)
DELETE FROM `s_channel_cost`;
/*!40000 ALTER TABLE `s_channel_cost` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_channel_cost` ENABLE KEYS */;

-- 导出  表 sx_crm.s_channel_cost_return 结构
DROP TABLE IF EXISTS `s_channel_cost_return`;
CREATE TABLE IF NOT EXISTS `s_channel_cost_return` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chan_id` int(11) DEFAULT NULL,
  `channelclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT NULL,
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `area_id` int(11) DEFAULT NULL,
  `area_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_month` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `return_cost` decimal(10,4) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL COMMENT '修改时间',
  `brandclass_id` int(11) NOT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `sj_pay` decimal(10,4) DEFAULT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `staff_id` int(11) DEFAULT NULL,
  `channel_class_id` int(11) DEFAULT NULL,
  `channel_class_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_info_id` int(11) DEFAULT NULL,
  `channel_info_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_channel_cost_return 的数据：~0 rows (大约)
DELETE FROM `s_channel_cost_return`;
/*!40000 ALTER TABLE `s_channel_cost_return` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_channel_cost_return` ENABLE KEYS */;

-- 导出  表 sx_crm.s_consumptiontype 结构
DROP TABLE IF EXISTS `s_consumptiontype`;
CREATE TABLE IF NOT EXISTS `s_consumptiontype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `consumption_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='消费类型设定';

-- 正在导出表  sx_crm.s_consumptiontype 的数据：~0 rows (大约)
DELETE FROM `s_consumptiontype`;
/*!40000 ALTER TABLE `s_consumptiontype` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_consumptiontype` ENABLE KEYS */;

-- 导出  表 sx_crm.s_consumption_capacity 结构
DROP TABLE IF EXISTS `s_consumption_capacity`;
CREATE TABLE IF NOT EXISTS `s_consumption_capacity` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `capacity` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费能力',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='消费能力设定';

-- 正在导出表  sx_crm.s_consumption_capacity 的数据：~0 rows (大约)
DELETE FROM `s_consumption_capacity`;
/*!40000 ALTER TABLE `s_consumption_capacity` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_consumption_capacity` ENABLE KEYS */;

-- 导出  表 sx_crm.s_cussource 结构
DROP TABLE IF EXISTS `s_cussource`;
CREATE TABLE IF NOT EXISTS `s_cussource` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cssame` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '来源名称',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `设定店面识别码` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客户来源设定';

-- 正在导出表  sx_crm.s_cussource 的数据：~0 rows (大约)
DELETE FROM `s_cussource`;
/*!40000 ALTER TABLE `s_cussource` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_cussource` ENABLE KEYS */;

-- 导出  表 sx_crm.s_customer_interface 结构
DROP TABLE IF EXISTS `s_customer_interface`;
CREATE TABLE IF NOT EXISTS `s_customer_interface` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `field_config` text COLLATE utf8_unicode_ci NOT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT '0',
  `create_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `is_delete` tinyint(1) NOT NULL DEFAULT '2',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_customer_interface 的数据：~0 rows (大约)
DELETE FROM `s_customer_interface`;
/*!40000 ALTER TABLE `s_customer_interface` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_customer_interface` ENABLE KEYS */;

-- 导出  表 sx_crm.s_customer_interface_detail 结构
DROP TABLE IF EXISTS `s_customer_interface_detail`;
CREATE TABLE IF NOT EXISTS `s_customer_interface_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT '0',
  `data` text COLLATE utf8_unicode_ci,
  `result_code` int(3) DEFAULT '0',
  `error_reason` text COLLATE utf8_unicode_ci,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `create_time` datetime DEFAULT NULL,
  `update_staff_id` int(11) DEFAULT '0',
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_customer_interface_detail 的数据：~0 rows (大约)
DELETE FROM `s_customer_interface_detail`;
/*!40000 ALTER TABLE `s_customer_interface_detail` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_customer_interface_detail` ENABLE KEYS */;

-- 导出  表 sx_crm.s_customer_tab 结构
DROP TABLE IF EXISTS `s_customer_tab`;
CREATE TABLE IF NOT EXISTS `s_customer_tab` (
  `id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sql` text COLLATE utf8_unicode_ci,
  `order_sort` int(4) DEFAULT '0',
  `is_use` tinyint(3) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_customer_tab 的数据：~0 rows (大约)
DELETE FROM `s_customer_tab`;
/*!40000 ALTER TABLE `s_customer_tab` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_customer_tab` ENABLE KEYS */;

-- 导出  表 sx_crm.s_custom_column 结构
DROP TABLE IF EXISTS `s_custom_column`;
CREATE TABLE IF NOT EXISTS `s_custom_column` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `custom_model` text COLLATE utf8_unicode_ci,
  `custom_name` text COLLATE utf8_unicode_ci,
  `custom_column` text COLLATE utf8_unicode_ci,
  `staff_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `key1` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_custom_column 的数据：~0 rows (大约)
DELETE FROM `s_custom_column`;
/*!40000 ALTER TABLE `s_custom_column` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_custom_column` ENABLE KEYS */;

-- 导出  表 sx_crm.s_departmentinfo 结构
DROP TABLE IF EXISTS `s_departmentinfo`;
CREATE TABLE IF NOT EXISTS `s_departmentinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '部门名称',
  `gradeType` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `channel_list` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '管理渠道',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='部门设定';

-- 正在导出表  sx_crm.s_departmentinfo 的数据：~0 rows (大约)
DELETE FROM `s_departmentinfo`;
/*!40000 ALTER TABLE `s_departmentinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_departmentinfo` ENABLE KEYS */;

-- 导出  表 sx_crm.s_file_reason 结构
DROP TABLE IF EXISTS `s_file_reason`;
CREATE TABLE IF NOT EXISTS `s_file_reason` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '追踪失败原因',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_file_reason 的数据：~0 rows (大约)
DELETE FROM `s_file_reason`;
/*!40000 ALTER TABLE `s_file_reason` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_file_reason` ENABLE KEYS */;

-- 导出  表 sx_crm.s_functioninfo 结构
DROP TABLE IF EXISTS `s_functioninfo`;
CREATE TABLE IF NOT EXISTS `s_functioninfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_fid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_functioninfo 的数据：~0 rows (大约)
DELETE FROM `s_functioninfo`;
/*!40000 ALTER TABLE `s_functioninfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_functioninfo` ENABLE KEYS */;

-- 导出  表 sx_crm.s_functionset 结构
DROP TABLE IF EXISTS `s_functionset`;
CREATE TABLE IF NOT EXISTS `s_functionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `A` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Aid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `B` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Bid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `C` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Cid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `D` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Did` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `E` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `Eid` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `coderkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_functionset 的数据：~0 rows (大约)
DELETE FROM `s_functionset`;
/*!40000 ALTER TABLE `s_functionset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_functionset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_function_staff 结构
DROP TABLE IF EXISTS `s_function_staff`;
CREATE TABLE IF NOT EXISTS `s_function_staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `system_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `function_fid` int(11) DEFAULT NULL,
  `staffnumber` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_function_staff 的数据：~0 rows (大约)
DELETE FROM `s_function_staff`;
/*!40000 ALTER TABLE `s_function_staff` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_function_staff` ENABLE KEYS */;

-- 导出  表 sx_crm.s_groupcompany 结构
DROP TABLE IF EXISTS `s_groupcompany`;
CREATE TABLE IF NOT EXISTS `s_groupcompany` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `GroupCompanyName` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_groupcompany 的数据：~0 rows (大约)
DELETE FROM `s_groupcompany`;
/*!40000 ALTER TABLE `s_groupcompany` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_groupcompany` ENABLE KEYS */;

-- 导出  表 sx_crm.s_home_show 结构
DROP TABLE IF EXISTS `s_home_show`;
CREATE TABLE IF NOT EXISTS `s_home_show` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_id` int(11) NOT NULL,
  `position_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8_unicode_ci,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `PRIMARY KEY` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_home_show 的数据：~0 rows (大约)
DELETE FROM `s_home_show`;
/*!40000 ALTER TABLE `s_home_show` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_home_show` ENABLE KEYS */;

-- 导出  表 sx_crm.s_kpi_staffgoal 结构
DROP TABLE IF EXISTS `s_kpi_staffgoal`;
CREATE TABLE IF NOT EXISTS `s_kpi_staffgoal` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_id` int(11) DEFAULT NULL,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位',
  `year` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL,
  `month` tinyint(2) DEFAULT NULL,
  `kpi_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标id',
  `kpi_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '目标名',
  `kpi_value` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '值',
  `kpi_unit` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '单位',
  `create_time` datetime DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定的店面识别码',
  `order_sort` int(5) DEFAULT '0',
  `flag` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT '0',
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT '0',
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `region_id` int(11) DEFAULT '0',
  `region_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `province_id` int(11) DEFAULT '0',
  `province_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `city_id` int(11) DEFAULT '0',
  `city_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='目标设定表';

-- 正在导出表  sx_crm.s_kpi_staffgoal 的数据：~0 rows (大约)
DELETE FROM `s_kpi_staffgoal`;
/*!40000 ALTER TABLE `s_kpi_staffgoal` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_kpi_staffgoal` ENABLE KEYS */;

-- 导出  表 sx_crm.s_losssignitem 结构
DROP TABLE IF EXISTS `s_losssignitem`;
CREATE TABLE IF NOT EXISTS `s_losssignitem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lossname` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_losssignitem 的数据：~0 rows (大约)
DELETE FROM `s_losssignitem`;
/*!40000 ALTER TABLE `s_losssignitem` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_losssignitem` ENABLE KEYS */;

-- 导出  表 sx_crm.s_markset 结构
DROP TABLE IF EXISTS `s_markset`;
CREATE TABLE IF NOT EXISTS `s_markset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mark_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标记名',
  `mark_color` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_markset 的数据：~0 rows (大约)
DELETE FROM `s_markset`;
/*!40000 ALTER TABLE `s_markset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_markset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_menu 结构
DROP TABLE IF EXISTS `s_menu`;
CREATE TABLE IF NOT EXISTS `s_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
  `fid` int(11) DEFAULT NULL,
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单url',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='功能菜单表';

-- 正在导出表  sx_crm.s_menu 的数据：~129 rows (大约)
DELETE FROM `s_menu`;
/*!40000 ALTER TABLE `s_menu` DISABLE KEYS */;
INSERT INTO `s_menu` (`id`, `menu_name`, `fid`, `menu_code`, `menu_url`, `menu_icon`, `status`, `sort`) VALUES
	(1, '我的工作', 0, 'menu1512736714', '/crm/Customer/index', 'fa-home', 1, 1),
	(2, '客户管理', 0, 'menu1512735953', '/crm/Customer/customerList', 'fa-user', 1, 2),
	(5, '统计分析', 0, 'menu1512736477', '/crm/setting/statistics_list', 'fa-bar-chart', 1, 4),
	(6, '系统设置', 0, 'menu1512650831', '#', 'fa-cog', 1, 4),
	(7, '渠道花费设定', 6, 'menu1512650793', '/crm/Setting/qdType', NULL, 1, 1),
	(10, '客资分配设定', 6, 'menu1512009199', '/crm/Setting/fpSet', NULL, 1, 2),
	(11, '小组设定', 6, 'menu1512028478', '/crm/Setting/groupSet', NULL, 1, 3),
	(12, '客资提醒设定', 6, 'menu1512028590', '/crm/Setting/remindSet', NULL, 1, 4),
	(13, '沟通流程设定', 6, 'menu1512028684', '/crm/Setting/workFlow', NULL, 1, 5),
	(14, '业务目标设定', 6, 'menu1512028704', '/crm/Setting/goalSet', NULL, 1, 6),
	(15, '五维图设定', 6, 'menu1512028736', '/crm/Setting/biao', NULL, 1, 7),
	(16, '追踪失败原因', 6, 'menu1512029560', '/crm/Setting/fileReason', '', 1, 8),
	(17, '短信模板设定', 6, 'menu1512029583', '/crm/Setting/modalSet', NULL, 1, 9),
	(18, '微信模板设定', 6, 'menu1512029604', '/crm/Setting/pushModal', '', 0, 10),
	(19, '电访备注设定', 6, 'menu1512029635', '/crm/Setting/telphoneRemark', '', 1, 11),
	(21, '功能菜单设定', 6, 'menu1512029909', '/crm/Setting/menuSet', NULL, 1, 13),
	(22, '权限设定', 6, 'menu1512029925', '/crm/Setting/permission', NULL, 1, 14),
	(26, '毛客资量统计', 5, 'menu1512897388', '/crm/Statistics/dj_customer', '', 0, 1),
	(32, '查看所有客资', 34, 'menu1512637269', 'allCustomer', '', 1, 1),
	(33, '新增客资', 61, 'menu1512970660', '/crm/Customer/addCustomer', '', 1, 1),
	(34, '客资查询', 2, 'menu1512970347', '', '', 0, 1),
	(35, '查看追踪人的客资', 34, 'menu1512650502', '', '', 1, 3),
	(36, '删除客资', 61, 'menu1512970570', '/crm/Customer/delCustomer', '', 1, 2),
	(37, '导入客资', 61, 'menu1512970672', '/crm/Customer/import', '', 1, 4),
	(38, '导出客资', 61, 'menu1512970678', '/crm/Customer/export', '', 1, 5),
	(39, '刷新列表', 61, 'menu1512970682', '', '', 1, 6),
	(40, '客资分配', 61, 'menu1512970623', '/crm/Customer/customerAllotOne', '', 1, 8),
	(41, '选项卡-所有客资', 34, 'menu1512698495', '', '', 1, 4),
	(42, '选项卡-待追踪', 34, 'menu1512698552', '', '', 1, 5),
	(43, '选项卡-待分配', 34, 'menu1512698635', '', '', 1, 6),
	(44, '选项卡-追踪中', 34, 'menu1512698693', '', '', 1, 7),
	(45, '选项卡-已订单', 34, 'menu1512698717', '', '', 1, 8),
	(46, '选项卡-进店未成交', 34, 'menu1512698836', '', '', 1, 9),
	(59, '电商--统计日报', 5, 'menu1512971049', '/crm/Statistics/dsDaily', '', 0, 3),
	(60, '追踪标记设定', 6, 'menu1512898027', '/crm/Setting/markSet', '', 1, 50),
	(61, '客资维护', 2, 'menu1512970388', '', '', 0, 2),
	(62, '修改客资', 61, 'menu1512970667', '/crm/Customer/customerInfo', '', 1, 3),
	(63, '客资追踪', 2, 'menu1512971674', '', '', 0, 3),
	(64, '客资电话追踪', 63, 'menu1512971662', '/crm/Customer/', '', 1, 1),
	(65, '客资标记', 63, 'menu1512971681', '', '', 0, 2),
	(66, '查看追踪记录', 63, 'menu1512971583', '/crm/Customer/trackLog', '', 1, 3),
	(67, '发送短信', 63, 'menu1512971646', '/crm/Customer/send_message', '', 1, 4),
	(68, '查看个人工作', 70, 'menu1512987407', '', '', 1, 1),
	(69, '查看小组成员工作', 70, 'menu1512987394', '', '', 1, 2),
	(70, '界面菜单', 1, 'menu1512993265', '', 'fa-home', 0, 0),
	(71, '查看手机号', 34, 'menu1512998373', '3', '', 1, 2),
	(72, '客资标记设定', 6, 'menu1513213883', '/crm/Setting/trackingKmarker', '', 1, 20),
	(73, '花费返点设定', 6, 'menu1513343947', '/crm/Setting/qdReturn', '', 1, 52),
	(74, '岗位授权', 22, 'menu1513394914', '/crm/Setting/authorise', '', 1, 1),
	(75, '选项卡-不再追踪', 34, 'menu1513395549', '', '', 1, 10),
	(76, '修改qq/微信/微博', 61, 'menu1513409629', '', '', 1, 9),
	(77, '修改客资渠道', 61, 'menu1513409657', '', '', 1, 10),
	(78, '修改获取方式', 61, 'menu1513409684', '', '', 1, 11),
	(79, '修改消费类型', 61, 'menu1513409704', '', '', 1, 12),
	(80, '修改客户来源', 61, 'menu1513409882', '', '', 1, 13),
	(81, '修改客户意向', 61, 'menu1513410030', '', '', 1, 14),
	(82, '修改客资分区', 61, 'menu1513410084', '', '', 1, 15),
	(83, '修改客资地域', 61, 'menu1513410164', '', '', 1, 16),
	(84, '选项卡-待筛客', 34, 'menu1513592505', '', '', 1, 11),
	(85, '获取成本设定', 6, 'menu1513855331', '/crm/Setting/obtainCost', '', 1, 60),
	(86, '选项卡-已筛客', 34, 'menu1513863618', '', '', 1, 12),
	(87, '呼叫前缀设定', 6, 'menu1514183289', '/crm/Setting/callPrefix', '', 1, 30),
	(88, '电商--统计月报', 5, 'menu1514351403', '/crm/Statistics/dsReport', '', 0, 3),
	(89, '深挖客资日报', 5, 'menu1514424405', '/crm/Statistics/swCustomerDaily', '', 0, 4),
	(90, '深挖日报', 5, 'menu1514425074', '/crm/Statistics/swDaily', '', 0, 5),
	(91, '深挖月报', 5, 'menu1514425150', '/crm/Statistics/swReport', '', 0, 6),
	(92, '深挖数据统计', 5, 'menu1514425221', '/crm/Statistics/swStatistics', '', 0, 7),
	(93, '客资简析设定', 6, 'menu1514430518', '/crm/Setting/homeShowSet', '', 1, 46),
	(97, '转客资', 61, 'menu1515837753', '', '', 1, 0),
	(98, '查看个人权限', 22, 'menu1515927010', '', '', 0, 0),
	(99, '电商渠道客资统计', 5, 'menu1515985582', '/crm/Statistics/dsCustomerStatistics', '', 0, 2),
	(103, '渠道子账户', 6, 'menu1516949559', '/crm/Setting/channel', '', 1, 50),
	(104, '失败再分配', 61, 'menu1517042801', '/crm/Customer/customerReAllot', NULL, 1, 0),
	(106, '客资标记', 2, 'menu1517129233', '', NULL, 0, 30),
	(107, '标记有效', 106, 'menu1517129299', '/crm/signValid', '', 1, 30),
	(108, '标记无效', 106, 'menu1517129331', '/crm/signUnvalid', '', 1, 30),
	(109, '当日接收', 34, 'menu1517217988', '', NULL, 1, 1),
	(110, '三日内追踪', 34, 'menu1517218007', '', NULL, 1, 1),
	(111, '当日预进店', 34, 'menu1517218044', '', NULL, 1, 1),
	(112, '客资驳回', 2, 'menu1517278817', '/crm/customerValidUpdate', '', 0, 20),
	(113, '客资反驳回', 2, 'menu1517278844', '/crm/customerUnValidUpdate', '', 0, 20),
	(115, '省市区设定', 6, 'menu1517560908', '/crm/Setting/province', NULL, 1, 90),
	(116, '渠道-各店转化率表', 5, 'menu1517727451', '/crm/Statistics/swCustomerChange', NULL, 0, 9),
	(117, '选项卡-有效客资', 34, 'menu1519611713', '', NULL, 1, 13),
	(118, '选项卡-无效客资', 34, 'menu1519611738', '', NULL, 1, 14),
	(119, '选项卡-待定客资', 34, 'menu1519611762', '', NULL, 1, 15),
	(120, '选项卡-驳回客资', 34, 'menu1519611781', '', NULL, 1, 16),
	(121, '右键-客资标记', 2, 'menu1519631971', '/crm/Customer/customerSign', NULL, 0, 20),
	(122, '右键-追踪标记', 2, 'menu1519632099', '/crm/Customer/customerSign', NULL, 0, 21),
	(123, '右键-不再追踪', 2, 'menu1519633436', '/crm/Customer/notTraking', NULL, 0, 30),
	(124, '右键-预约进店', 2, 'menu1519633870', '/crm/Customer/customerYJD', NULL, 0, 25),
	(125, '右键-转订单', 2, 'menu1519633923', '/crm/Customer/zhuanOrder', NULL, 0, 26),
	(126, '右键-编辑订单', 2, 'menu1519633959', '/crm/Customer/editOrder', NULL, 0, 27),
	(127, '右键-筛客', 2, 'menu1519635403', '/crm/Customer/skCustomer', NULL, 0, 20),
	(132, '渠道漏斗统计', 5, 'menu1519826594', '/crm/Statistics/ds_channelLd', NULL, 0, 2),
	(133, '地域漏斗统计', 5, 'menu1519826642', '/crm/Statistics/ds_regionLd', NULL, 0, 2),
	(135, '右键-撤销', 2, 'menu1520675106', '/crm/Customer/customerRevoke', NULL, 0, 28),
	(136, '返点规则设定', 6, 'menu1521280345', '/crm/Setting/shop_return_setting', NULL, 1, 100),
	(138, '查询服务', 0, 'menu1521267312', '/crm/Customer/moreSearch', 'fa-search', 1, 3),
	(139, '电商统计日报--常态报表1', 5, 'menu1521352296', '/crm/Statistics/ds_sta_day', NULL, 0, 10),
	(140, '电商统月报--常态报表2', 5, 'menu1521352325', '/crm/Statistics/ds_sta_month', NULL, 0, 11),
	(141, '电商统计日报--常态报表3', 5, 'menu1521352381', '/crm/Statistics/ds_to_wx_report', NULL, 0, 12),
	(142, '电商日报明细', 5, 'menu1521352428', '/crm/Statistics/daily_detail', NULL, 0, 13),
	(143, '网销漏斗', 5, 'menu1521352461', '/crm/Statistics/wx_ld', NULL, 0, 14),
	(144, '渠道透视', 5, 'menu1521352487', '/crm/Statistics/qd_ts', NULL, 0, 15),
	(145, '地域渠道有效客资透视', 5, 'menu1521352560', '/crm/Statistics/dy_ts', NULL, 6, 16),
	(146, '网销无效分析', 5, 'menu1521352579', '/crm/Statistics/wx_unvalid', NULL, 0, 17),
	(147, '渠道漏斗月走势统计', 5, 'menu1521352601', '/crm/Statistics/channel_ld_month', NULL, 0, 18),
	(148, '关键词分析', 5, 'menu1521352632', '/crm/Statistics/keywords', NULL, 0, 19),
	(149, '网销小组数据统计', 5, 'menu1521352658', '/crm/Statistics/wx_group', NULL, 0, 20),
	(150, '网销小组邀约(进店)统计', 5, 'menu1521352682', '/crm/Statistics/wx_group_jd', NULL, 0, 21),
	(151, '网销小组新单统计', 5, 'menu1521352703', '/crm/Statistics/wx_group_new_order', NULL, 0, 22),
	(152, '网销地域统计', 5, 'menu1521352729', '/crm/Statistics/wx_region', NULL, 0, 23),
	(153, '电商目标达成统计', 5, 'menu1521352748', '/crm/Statistics/ds_goal', NULL, 0, 24),
	(154, '电商渠道达成进店跟踪', 5, 'menu1521352772', '/crm/Statistics/ds_shop_goal', NULL, 0, 25),
	(170, '批量客资查询', 138, 'menu1521439092', '/crm/Customer/moreSearch', NULL, 1, 0),
	(171, '门市订单查询', 138, 'menu1521352773', '/crm/Customer/searchorders', NULL, 1, 2),
	(173, '客资爆破', 6, 'menu1521091523', '/crm/Setting/customerSwap', NULL, 1, 101),
	(174, '爆破设定', 173, 'menu1521093152', '/crm/Setting/customerSwapSet', NULL, 1, 102),
	(175, '添加客资', 173, 'menu1521093203', '/crm/Setting/addCustomerSwap', NULL, 1, 103),
	(176, '驳回原因设定', 6, 'menu1521784361', '/crm/Setting/RejectReason', NULL, 1, 21),
	(177, '系统配置', 6, 'menu1522207375', '/crm/Setting/erpSet', '', 1, 101),
	(178, '订单来源设定', 6, 'menu1522225258', '/crm/Setting/orderSource', NULL, 1, 102),
	(179, '各店24小时PK表', 5, 'menu1522237395', '/crm/Statistics/ds_pk', NULL, 0, 26),
	(180, '右键-介绍人修改', 2, 'menu1522653972', '/crm/Customer/editIntroducer', NULL, 0, 29),
	(181, '电商--本店各渠道数据明细', 5, 'menu1522752932', '/crm/Statistics/dayStatistics', NULL, 0, 28),
	(182, '各事业部数据统计', 5, 'menu1522752970', '/crm/Statistics/week_and_month_statistics', NULL, 0, 29),
	(186, '第三方录入接口配置', 6, 'menu1523588039', '/crm/Setting/customerInterface', NULL, 1, 103),
	(187, '本店报表设置', 5, 'menu1523775076', '', NULL, 1, 1);
/*!40000 ALTER TABLE `s_menu` ENABLE KEYS */;

-- 导出  表 sx_crm.s_message_templateinfo 结构
DROP TABLE IF EXISTS `s_message_templateinfo`;
CREATE TABLE IF NOT EXISTS `s_message_templateinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mtemplate_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板名称',
  `mtemplate_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板内容',
  `outsex` int(11) DEFAULT NULL,
  `customer_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户姓名',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否启用',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='短信模板设定';

-- 正在导出表  sx_crm.s_message_templateinfo 的数据：~0 rows (大约)
DELETE FROM `s_message_templateinfo`;
/*!40000 ALTER TABLE `s_message_templateinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_message_templateinfo` ENABLE KEYS */;

-- 导出  表 sx_crm.s_obtain_cost 结构
DROP TABLE IF EXISTS `s_obtain_cost`;
CREATE TABLE IF NOT EXISTS `s_obtain_cost` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `cost_type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '成本类型',
  `cost_value` decimal(10,4) DEFAULT NULL COMMENT '成本值',
  `cost_time` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间区间',
  `days` int(3) DEFAULT NULL COMMENT '设定天数',
  `cost_avg` decimal(10,4) DEFAULT NULL COMMENT '平均值',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_code` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_shop_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_obtain_cost 的数据：~0 rows (大约)
DELETE FROM `s_obtain_cost`;
/*!40000 ALTER TABLE `s_obtain_cost` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_obtain_cost` ENABLE KEYS */;

-- 导出  表 sx_crm.s_order_source 结构
DROP TABLE IF EXISTS `s_order_source`;
CREATE TABLE IF NOT EXISTS `s_order_source` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) NOT NULL DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_delete` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `key1` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_order_source 的数据：~0 rows (大约)
DELETE FROM `s_order_source`;
/*!40000 ALTER TABLE `s_order_source` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_order_source` ENABLE KEYS */;

-- 导出  表 sx_crm.s_photo_address 结构
DROP TABLE IF EXISTS `s_photo_address`;
CREATE TABLE IF NOT EXISTS `s_photo_address` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photoAddress` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_photo_address 的数据：~0 rows (大约)
DELETE FROM `s_photo_address`;
/*!40000 ALTER TABLE `s_photo_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_photo_address` ENABLE KEYS */;

-- 导出  表 sx_crm.s_positionset 结构
DROP TABLE IF EXISTS `s_positionset`;
CREATE TABLE IF NOT EXISTS `s_positionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `gradeType` tinyint(4) DEFAULT NULL COMMENT '1集团，2品牌，3店面，4部门',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_positionset 的数据：~0 rows (大约)
DELETE FROM `s_positionset`;
/*!40000 ALTER TABLE `s_positionset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_positionset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_position_menu 结构
DROP TABLE IF EXISTS `s_position_menu`;
CREATE TABLE IF NOT EXISTS `s_position_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `menu_code` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单url',
  `status` tinyint(2) DEFAULT NULL COMMENT '状态，1是显示，2不显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_position_menu 的数据：~0 rows (大约)
DELETE FROM `s_position_menu`;
/*!40000 ALTER TABLE `s_position_menu` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_position_menu` ENABLE KEYS */;

-- 导出  表 sx_crm.s_regionset 结构
DROP TABLE IF EXISTS `s_regionset`;
CREATE TABLE IF NOT EXISTS `s_regionset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `region_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '地域名称',
  `shop_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属店面名称',
  `shop_code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '所属的店面识别码',
  `setkey` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定店面识别码',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='客户地域设定';

-- 正在导出表  sx_crm.s_regionset 的数据：~0 rows (大约)
DELETE FROM `s_regionset`;
/*!40000 ALTER TABLE `s_regionset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_regionset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_reject_reason 结构
DROP TABLE IF EXISTS `s_reject_reason`;
CREATE TABLE IF NOT EXISTS `s_reject_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_reject_reason 的数据：~0 rows (大约)
DELETE FROM `s_reject_reason`;
/*!40000 ALTER TABLE `s_reject_reason` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_reject_reason` ENABLE KEYS */;

-- 导出  表 sx_crm.s_reminditemset 结构
DROP TABLE IF EXISTS `s_reminditemset`;
CREATE TABLE IF NOT EXISTS `s_reminditemset` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT 'id',
  `remind_type` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `isopen` int(11) DEFAULT NULL,
  `advancehour` int(11) DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='客资提醒设定表';

-- 正在导出表  sx_crm.s_reminditemset 的数据：~0 rows (大约)
DELETE FROM `s_reminditemset`;
/*!40000 ALTER TABLE `s_reminditemset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_reminditemset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_roleset 结构
DROP TABLE IF EXISTS `s_roleset`;
CREATE TABLE IF NOT EXISTS `s_roleset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rolename` varchar(50) DEFAULT NULL,
  `pid` int(11) DEFAULT NULL,
  `functionId` varchar(1000) DEFAULT NULL,
  `coderkey` varchar(20) DEFAULT NULL,
  `setkey` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_roleset 的数据：~0 rows (大约)
DELETE FROM `s_roleset`;
/*!40000 ALTER TABLE `s_roleset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_roleset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_sales_routines 结构
DROP TABLE IF EXISTS `s_sales_routines`;
CREATE TABLE IF NOT EXISTS `s_sales_routines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `step_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `step_content` varchar(3000) COLLATE utf8_unicode_ci DEFAULT NULL,
  `step_stage` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='沟通流程设定表';

-- 正在导出表  sx_crm.s_sales_routines 的数据：~0 rows (大约)
DELETE FROM `s_sales_routines`;
/*!40000 ALTER TABLE `s_sales_routines` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_sales_routines` ENABLE KEYS */;

-- 导出  表 sx_crm.s_session 结构
DROP TABLE IF EXISTS `s_session`;
CREATE TABLE IF NOT EXISTS `s_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌;3:离线'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';

-- 正在导出表  sx_crm.s_session 的数据：~0 rows (大约)
DELETE FROM `s_session`;
/*!40000 ALTER TABLE `s_session` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_session` ENABLE KEYS */;

-- 导出  表 sx_crm.s_shopset 结构
DROP TABLE IF EXISTS `s_shopset`;
CREATE TABLE IF NOT EXISTS `s_shopset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandclass` varchar(100) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `sn` varchar(100) DEFAULT NULL,
  `numberorder` varchar(100) DEFAULT NULL,
  `fp` tinyint(1) DEFAULT '1' COMMENT '分配规则：1：自动；2：手动',
  `shopaddress` varchar(500) DEFAULT NULL,
  `receiv_shop_code` varchar(3000) DEFAULT NULL,
  `is_op1` int(11) DEFAULT NULL,
  `is_op2` int(11) DEFAULT NULL,
  `is_op3` int(11) DEFAULT NULL,
  `is_op4` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_shopset 的数据：~0 rows (大约)
DELETE FROM `s_shopset`;
/*!40000 ALTER TABLE `s_shopset` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_shopset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_shop_address 结构
DROP TABLE IF EXISTS `s_shop_address`;
CREATE TABLE IF NOT EXISTS `s_shop_address` (
  `id` int(11) NOT NULL DEFAULT '0',
  `pid` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_shop_address 的数据：~0 rows (大约)
DELETE FROM `s_shop_address`;
/*!40000 ALTER TABLE `s_shop_address` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_shop_address` ENABLE KEYS */;

-- 导出  表 sx_crm.s_shop_return_rule 结构
DROP TABLE IF EXISTS `s_shop_return_rule`;
CREATE TABLE IF NOT EXISTS `s_shop_return_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `return_rule` tinyint(1) DEFAULT '1',
  `return_value` int(10) DEFAULT '0',
  `channel_id` int(11) DEFAULT '0',
  `channel_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `key1` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_shop_return_rule 的数据：~0 rows (大约)
DELETE FROM `s_shop_return_rule`;
/*!40000 ALTER TABLE `s_shop_return_rule` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_shop_return_rule` ENABLE KEYS */;

-- 导出  表 sx_crm.s_staffgroup 结构
DROP TABLE IF EXISTS `s_staffgroup`;
CREATE TABLE IF NOT EXISTS `s_staffgroup` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_name` varchar(100) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_staffgroup 的数据：~0 rows (大约)
DELETE FROM `s_staffgroup`;
/*!40000 ALTER TABLE `s_staffgroup` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_staffgroup` ENABLE KEYS */;

-- 导出  表 sx_crm.s_staffinfo 结构
DROP TABLE IF EXISTS `s_staffinfo`;
CREATE TABLE IF NOT EXISTS `s_staffinfo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staffnumber` varchar(100) DEFAULT NULL,
  `staffname` varchar(100) DEFAULT NULL,
  `Password` varchar(100) DEFAULT NULL,
  `Department_name` varchar(100) DEFAULT NULL,
  `Position_name` varchar(100) DEFAULT NULL,
  `zhiji_name` varchar(100) DEFAULT NULL,
  `TureStaffName` varchar(100) DEFAULT NULL,
  `shopname` varchar(100) DEFAULT NULL,
  `groupname` varchar(100) DEFAULT NULL,
  `group_admin` tinyint(1) DEFAULT '0',
  `sex` varchar(100) DEFAULT NULL,
  `EntryDate` varchar(100) DEFAULT NULL,
  `leaveDate` varchar(100) DEFAULT NULL,
  `Birthday` varchar(100) DEFAULT NULL,
  `IDcard` varchar(100) DEFAULT NULL,
  `Nation` varchar(100) DEFAULT NULL,
  `Place_origin` varchar(100) DEFAULT NULL,
  `Political` varchar(100) DEFAULT NULL,
  `Education` varchar(100) DEFAULT NULL,
  `Graduation_school` varchar(100) DEFAULT NULL,
  `Marital_status` varchar(100) DEFAULT NULL,
  `contractEndday` varchar(100) DEFAULT NULL,
  `Telephone` varchar(100) DEFAULT NULL,
  `QQ` varchar(100) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `weixin` varchar(100) DEFAULT NULL,
  `a_discount` varchar(100) DEFAULT NULL,
  `b_discount` varchar(100) DEFAULT NULL,
  `a_cost` varchar(100) DEFAULT NULL,
  `b_cost` varchar(100) DEFAULT NULL,
  `Liaison_person` varchar(100) DEFAULT NULL,
  `Liaison_tel` varchar(100) DEFAULT NULL,
  `salaryMoney` varchar(100) DEFAULT NULL,
  `social_security` varchar(100) DEFAULT NULL,
  `Bank_cardNumber` varchar(100) DEFAULT NULL,
  `addressinfo` varchar(300) DEFAULT NULL,
  `remarkinfo` text,
  `worktype` varchar(100) DEFAULT NULL,
  `workshop` varchar(3000) DEFAULT NULL,
  `rolename` varchar(100) DEFAULT NULL,
  `Popedom1` varchar(1000) DEFAULT NULL,
  `Popedom2` varchar(1000) DEFAULT NULL,
  `Popedom3` varchar(1000) DEFAULT NULL,
  `Popedom4` varchar(1000) DEFAULT NULL,
  `Popedom5` varchar(1000) DEFAULT NULL,
  `Popedom6` varchar(1000) DEFAULT NULL,
  `Popedom7` varchar(1000) DEFAULT NULL,
  `Popedom8` varchar(1000) DEFAULT NULL,
  `Popedom9` varchar(1000) DEFAULT NULL,
  `Popedom10` varchar(1000) DEFAULT NULL,
  `Popedom11` varchar(1000) DEFAULT NULL,
  `Popedom12` varchar(1000) DEFAULT NULL,
  `Popedom13` varchar(1000) DEFAULT NULL,
  `Popedom14` varchar(1000) DEFAULT NULL,
  `Popedom15` varchar(1000) DEFAULT NULL,
  `Popedom16` varchar(1000) DEFAULT NULL,
  `Popedom17` varchar(1000) DEFAULT NULL,
  `Popedom18` varchar(1000) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  `vice_work_type` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_staffinfo 的数据：~0 rows (大约)
DELETE FROM `s_staffinfo`;
/*!40000 ALTER TABLE `s_staffinfo` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_staffinfo` ENABLE KEYS */;

-- 导出  表 sx_crm.s_staff_ability 结构
DROP TABLE IF EXISTS `s_staff_ability`;
CREATE TABLE IF NOT EXISTS `s_staff_ability` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `abilityItem` varchar(1000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '能力',
  `max` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '能力指标最大值',
  `times` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '设定时间',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='五维图设定表';

-- 正在导出表  sx_crm.s_staff_ability 的数据：~0 rows (大约)
DELETE FROM `s_staff_ability`;
/*!40000 ALTER TABLE `s_staff_ability` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_staff_ability` ENABLE KEYS */;

-- 导出  表 sx_crm.s_swapset 结构
DROP TABLE IF EXISTS `s_swapset`;
CREATE TABLE IF NOT EXISTS `s_swapset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `swap_number` char(14) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `swap_name` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `swap_staff_ids` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `swap_staff_names` text COLLATE utf8_unicode_ci NOT NULL,
  `customer_start` date DEFAULT NULL,
  `customer_end` date DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT '0',
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(2) DEFAULT '1',
  `is_del` tinyint(2) DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_swapset 的数据：~0 rows (大约)
DELETE FROM `s_swapset`;
/*!40000 ALTER TABLE `s_swapset` DISABLE KEYS */;
INSERT INTO `s_swapset` (`id`, `swap_number`, `swap_name`, `swap_staff_ids`, `swap_staff_names`, `customer_start`, `customer_end`, `start_date`, `end_date`, `brandclass_id`, `brandclass`, `shop_code`, `shop_name`, `status`, `is_del`, `create_time`, `update_time`) VALUES
	(1, 'WLno1521877584', '三月中旬', '383,391', '武黎,如来', '2018-03-19', '2018-03-24', '2018-03-25', '2018-03-27', 2, '时尚经典全球旅拍事业部', 'KF001', '时尚旅拍客服中心', 1, 1, '2018-03-24 15:46:24', '2018-03-24 15:55:32');
/*!40000 ALTER TABLE `s_swapset` ENABLE KEYS */;

-- 导出  表 sx_crm.s_telremark 结构
DROP TABLE IF EXISTS `s_telremark`;
CREATE TABLE IF NOT EXISTS `s_telremark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `telremark` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_telremark 的数据：~0 rows (大约)
DELETE FROM `s_telremark`;
/*!40000 ALTER TABLE `s_telremark` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_telremark` ENABLE KEYS */;

-- 导出  表 sx_crm.s_tracksign 结构
DROP TABLE IF EXISTS `s_tracksign`;
CREATE TABLE IF NOT EXISTS `s_tracksign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tracksign` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_delete` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- 正在导出表  sx_crm.s_tracksign 的数据：~0 rows (大约)
DELETE FROM `s_tracksign`;
/*!40000 ALTER TABLE `s_tracksign` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_tracksign` ENABLE KEYS */;

-- 导出  表 sx_crm.s_wechattemplate 结构
DROP TABLE IF EXISTS `s_wechattemplate`;
CREATE TABLE IF NOT EXISTS `s_wechattemplate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `wtempalte_name` varchar(50) DEFAULT NULL,
  `wtempalte_content` varchar(3000) DEFAULT NULL,
  `shop_name` varchar(100) DEFAULT NULL,
  `shop_code` varchar(100) DEFAULT NULL,
  `setkey` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- 正在导出表  sx_crm.s_wechattemplate 的数据：~0 rows (大约)
DELETE FROM `s_wechattemplate`;
/*!40000 ALTER TABLE `s_wechattemplate` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_wechattemplate` ENABLE KEYS */;

-- 导出  表 sx_crm.s_wx_template_model 结构
DROP TABLE IF EXISTS `s_wx_template_model`;
CREATE TABLE IF NOT EXISTS `s_wx_template_model` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wx_template_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信模板名称',
  `wx_template_title` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板标题',
  `wx_template_content` text COLLATE utf8_unicode_ci COMMENT '微信模板内容',
  `status` tinyint(1) DEFAULT '1' COMMENT '是否启用',
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `setkey` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='微信模板设定';

-- 正在导出表  sx_crm.s_wx_template_model 的数据：~0 rows (大约)
DELETE FROM `s_wx_template_model`;
/*!40000 ALTER TABLE `s_wx_template_model` DISABLE KEYS */;
/*!40000 ALTER TABLE `s_wx_template_model` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
