/*
Navicat MySQL Data Transfer

Source Server         : test
Source Server Version : 50637
Source Host           : 192.168.0.11:3306
Source Database       : sx_kf

Target Server Type    : MYSQL
Target Server Version : 50637
File Encoding         : 65001

Date: 2019-01-02 15:48:28
*/

SET FOREIGN_KEY_CHECKS=0;
-- ----------------------------
-- Table structure for `api_app`
-- ----------------------------
DROP TABLE IF EXISTS `api_app`;
CREATE TABLE `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='appId和appSecret表';

-- ----------------------------
-- Records of api_app
-- ----------------------------
INSERT INTO api_app VALUES ('2', '40021838', 'byXNdRswuGquIevGyqYWVxStdjlUXOfo', 'test', '1', '1', 'test');
INSERT INTO api_app VALUES ('3', '94201193', 'DCGJduSGIceYUFNtWloBzzXhShXERsqH', '管理中心APP', '1', '1', '');
INSERT INTO api_app VALUES ('4', '44793168', 'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv', '客资系统', '1', '1', '客资CRM系统');
INSERT INTO api_app VALUES ('5', '93816470', 'bVZhrmmaDldMexiWarSftRjVeJkcWvbX', 'erp系统接口', '1', '1', 'erp系统接口');

-- ----------------------------
-- Table structure for `api_fields`
-- ----------------------------
DROP TABLE IF EXISTS `api_fields`;
CREATE TABLE `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='用于保存各个API的字段规则';

-- ----------------------------
-- Records of api_fields
-- ----------------------------
INSERT INTO api_fields VALUES ('2', 'order_number', '5c0e500141ac8', '2', '', '1', '', '订单编号', '0', 'order_number');
INSERT INTO api_fields VALUES ('3', 'customer_number', '5c0e500141ac8', '2', '', '0', '', '客资编号', '0', 'customer_number');
INSERT INTO api_fields VALUES ('4', 'm_name', '5c0e500141ac8', '2', '', '0', '', '男士姓名', '0', 'm_name');
INSERT INTO api_fields VALUES ('5', 'm_phone', '5c0e500141ac8', '2', '', '0', '', '男士手机号', '0', 'm_phone');
INSERT INTO api_fields VALUES ('6', 'w_name', '5c0e500141ac8', '2', '', '0', '', '女士姓名', '0', 'w_name');
INSERT INTO api_fields VALUES ('7', 'w_phone', '5c0e500141ac8', '2', '', '0', '', '女士手机号', '0', 'w_phone');
INSERT INTO api_fields VALUES ('9', 'level', '5c0e500141ac8', '1', '1', '1', '', '1一般客诉，2重大客诉', '0', 'level');
INSERT INTO api_fields VALUES ('10', 'describe', '5c0e500141ac8', '2', '', '1', '', '投诉描述', '0', 'describe');
INSERT INTO api_fields VALUES ('11', 'source_id', '5c0e500141ac8', '1', '', '1', '', '客诉来源', '0', 'source_id');
INSERT INTO api_fields VALUES ('12', 'source_name', '5c0e500141ac8', '2', '', '1', '', '客诉来源名称', '0', 'source_name');
INSERT INTO api_fields VALUES ('13', 'complain_id', '5c0e500141ac8', '2', '', '1', '', '客诉投诉类型id，多个用英文逗号隔开', '0', 'complain_id');
INSERT INTO api_fields VALUES ('14', 'complain_name', '5c0e500141ac8', '2', '', '1', '', '客诉投诉类型名称，多个用英文逗号隔开', '0', 'complain_name');
INSERT INTO api_fields VALUES ('15', 'brand_id', '5c0e500141ac8', '1', '', '1', '', '事业部id', '0', 'brand_id');
INSERT INTO api_fields VALUES ('16', 'brandclass', '5c0e500141ac8', '2', '', '1', '', '事业部名称', '0', 'brandclass');
INSERT INTO api_fields VALUES ('17', 'shop_code', '5c0e500141ac8', '2', '', '1', '', '店面识别码', '0', 'shop_code');
INSERT INTO api_fields VALUES ('18', 'shop_name', '5c0e500141ac8', '2', '', '1', '', '店面名称', '0', 'shop_name');
INSERT INTO api_fields VALUES ('19', 'create_staff_id', '5c0e500141ac8', '1', '', '1', '', '提交人id', '0', 'create_staff_id');
INSERT INTO api_fields VALUES ('20', 'create_staff_name', '5c0e500141ac8', '2', '', '1', '', '提交人姓名', '0', 'create_staff_name');
INSERT INTO api_fields VALUES ('21', 'create_staff_number', '5c0e500141ac8', '2', '', '1', '', '提交人员工编号', '0', 'create_staff_number');
INSERT INTO api_fields VALUES ('22', 'duty_position_code', '5c0e500141ac8', '2', '', '0', '', '责任人（被投诉人）岗位code，多个用英文逗号隔开', '0', 'duty_position_code');
INSERT INTO api_fields VALUES ('23', 'duty_position_name', '5c0e500141ac8', '2', '', '0', '', '责任人（被投诉人）岗位名称，多个用英文逗号隔开', '0', 'duty_position_name');
INSERT INTO api_fields VALUES ('24', 'duty_staff_id', '5c0e500141ac8', '2', '', '0', '', '责任人（被投诉人） id，多个用英文逗号隔开', '0', 'duty_staff_id');
INSERT INTO api_fields VALUES ('25', 'duty_staff_name', '5c0e500141ac8', '2', '', '0', '', '责任人（被投诉人） 名称，多个用英文逗号隔开', '0', 'duty_staff_name');
INSERT INTO api_fields VALUES ('26', 'duty_staff_number', '5c0e500141ac8', '2', '', '0', '', '责任人（被投诉人） 名称，多个用英文逗号隔开', '0', 'duty_staff_number');

-- ----------------------------
-- Table structure for `api_list`
-- ----------------------------
DROP TABLE IF EXISTS `api_list`;
CREATE TABLE `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` text CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text CHARACTER SET utf8 COLLATE utf8_unicode_ci COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COMMENT='用于维护接口信息';

-- ----------------------------
-- Records of api_list
-- ----------------------------
INSERT INTO api_list VALUES ('1', '新增客诉', 'Order/addWorkOrder', '5', '5c0e500141ac8', '0', '0', '1', '1', '', '0', null);
INSERT INTO api_list VALUES ('2', '获取客诉来源', 'Order/getSource', '5', '5c0e523f26930', '0', '0', '1', '1', '', '0', null);
INSERT INTO api_list VALUES ('3', '获取客诉投诉类型', 'Order/getComplainType', '5', '5c0e527356ea0', '0', '0', '1', '1', '', '0', null);

-- ----------------------------
-- Table structure for `app_version`
-- ----------------------------
DROP TABLE IF EXISTS `app_version`;
CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  `up_sql2` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

-- ----------------------------
-- Records of app_version
-- ----------------------------
INSERT INTO app_version VALUES ('175', '0.0.2', '2018-06-11 09:58:44', ' INSERT INTO `s_menu`  (`menu_name`,`fid`,`menu_code`,`menu_url`,`menu_icon`,`status`,`sort`)  SELECT \'无效原因统计\',\'5\',\'menu1526278946\',\'/kf/Statistics/invalid\',\'\',\'1\',\'1\' \r\n INSERT INTO `s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`menu_icon`,`status`,`sort`)  SELECT \'55\',\'无效原因统计\',\'5\',\'menu1526278946\',\'/kf/Statistics/invalid\',\'\',\'1\',\'1\' union  SELECT \'56\',\'回访无效设定\',\'6\',\'menu1527313960\',\'/kf/Setting/invalidSet\',\'\',\'1\',\'0\' union  SELECT \'57\',\'事业部客诉汇总\',\'5\',\'menu1528100739\',\'/kf/statistics/ksEveryMonth\',\'\',\'1\',\'8\' union  SELECT \'58\',\'客诉责任分类\',\'5\',\'menu1528176291\',\'/kf/Statistics/ksDutyClassify\',\'\',\'1\',\'7\' union  SELECT \'59\',\'事业部回访同期\',\'5\',\'menu1528366808\',\'/kf/Statistics/visitContrast\',\'\',\'1\',\'2\' union  SELECT \'60\',\'事业部-部门对比\',\'5\',\'menu1528428078\',\'/kf/Statistics/departmentBrand\',\'\',\'1\',\'4\' union  SELECT \'61\',\'事业部回访对比\',\'5\',\'menu1528289625\',\'/kf/Statistics/visitContrast2\',\'\',\'1\',\'3\' ', null);
INSERT INTO app_version VALUES ('176', '0.0.3', '2018-06-11 13:41:20', null, null);
INSERT INTO app_version VALUES ('177', '0.0.4', '2018-06-12 22:12:45', null, null);
INSERT INTO app_version VALUES ('178', '0.0.4', '2018-06-12 22:14:35', ' ALTER TABLE `k_drift_bottle`  ADD COLUMN `is_hidden` tinyint  NULL  DEFAULT 2 ', null);
INSERT INTO app_version VALUES ('179', '0.0.5', '2018-07-06 16:49:02', null, null);
INSERT INTO app_version VALUES ('180', '0.0.6', '2018-08-15 21:45:27', null, null);
INSERT INTO app_version VALUES ('181', '0.0.7', '2018-10-08 09:48:09', ' INSERT INTO `s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`menu_icon`,`status`,`sort`)  SELECT \'79\',\'订单查询\',\'5\',\'menu1533216429\',\'/kf/Workorder/searchOrder\',\'fa-search\',\'1\',\'8\' union  SELECT \'80\',\'个人回访数据对比\',\'5\',\'menu1536402619\',\'/kf/Statistics/staffVisit\',\'\',\'1\',\'7\' ', null);
INSERT INTO app_version VALUES ('182', '0.0.9', '2018-10-15 10:02:42', ' INSERT INTO `s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`menu_icon`,`status`,`sort`)  SELECT \'81\',\'员工回访量对比\',\'5\',\'menu1539054592\',\'/kf/Statistics/visitAmount\',\'\',\'1\',\'8\' \r\n INSERT INTO `s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`menu_icon`,`status`,`sort`)  SELECT \'82\',\'回访对象名称\',\'6\',\'menu1539222383\',\'/kf/Setting/visitObjectName\',\'\',\'1\',\'5\' union  SELECT \'83\',\'回访环节设定\',\'6\',\'menu1539229325\',\'/kf/Setting/setVisitLinkObject\',\'\',\'1\',\'6\' ', null);
INSERT INTO app_version VALUES ('183', '0.0.10', '2018-11-22 11:35:24', ' ALTER TABLE `k_work_order`  ADD COLUMN `create_brand_id` int(11)  NULL , ADD COLUMN `create_brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `manage_brand_id` int(11)  NULL , ADD COLUMN `manage_brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ', null);
INSERT INTO app_version VALUES ('184', '0.0.11', '2018-11-22 16:05:09', ' INSERT INTO `s_menu`  (`id`,`menu_name`,`fid`,`menu_code`,`menu_url`,`menu_icon`,`status`,`sort`)  SELECT \'84\',\'查看所有客诉\',\'3\',\'menu1542865371\',\'\',\'\',\'0\',\'0\' union  SELECT \'85\',\'回访环节回访\',\'47\',\'menu1542865425\',\'\',\'\',\'0\',\'0\' union  SELECT \'86\',\'回访环节订单\',\'79\',\'menu1542865463\',\'\',\'\',\'0\',\'0\' ', null);
INSERT INTO app_version VALUES ('185', '0.0.12', '2018-11-23 18:36:48', ' ALTER TABLE `s_manage_process`  ADD COLUMN `manage_brand_id` int(11)  NULL , ADD COLUMN `manage_brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `second_visit_brand_id` int(11)  NULL , ADD COLUMN `second_visit_brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' \r\n ALTER TABLE `k_work_order`  ADD COLUMN `second_visit_brand_id` int(11)  NULL , ADD COLUMN `second_visit_brandclass` varchar(100)  NULL  COLLATE \'utf8_unicode_ci\' ', null);
INSERT INTO app_version VALUES ('186', '0.0.13', '2018-12-03 19:20:20', null, null);

-- ----------------------------
-- Table structure for `c_message`
-- ----------------------------
DROP TABLE IF EXISTS `c_message`;
CREATE TABLE `c_message` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `send_type` int(4) DEFAULT '1' COMMENT '发送的消息类型:1:短消息(弹窗)；2：通知',
  `send_id` int(11) DEFAULT NULL COMMENT '发送者id（-1：为系统发送）',
  `send_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送者名称（系统：system）',
  `send_time` datetime DEFAULT NULL COMMENT '发送时间',
  `send_title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消息标题',
  `send_msg` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '发送的消息内容',
  `operation_type` int(4) DEFAULT NULL COMMENT '操作类型（1：可操作；2：不可操作）',
  `operation` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作方法（二维数组的json）',
  `time_out` char(13) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '过期时间的时间戳',
  `customer_id` int(11) DEFAULT NULL COMMENT '客资id',
  `receive_id` int(11) DEFAULT NULL COMMENT '接收者id',
  `receive_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '接收者姓名',
  `receive_status` int(4) DEFAULT '0' COMMENT '接收状态（0：未接收；1：已接收；2：已放弃）',
  `receive_time` datetime DEFAULT NULL COMMENT '接收/放弃 时间',
  `read_status` int(4) DEFAULT '0' COMMENT '阅读状态（0：未读；1：已读）',
  `read_time` datetime DEFAULT NULL COMMENT '阅读消息时间',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否删除：1：删除；0：未删除',
  PRIMARY KEY (`id`),
  KEY `id` (`id`,`send_id`,`receive_id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='消息通知表';

-- ----------------------------
-- Records of c_message
-- ----------------------------

-- ----------------------------
-- Table structure for `c_sysconfig`
-- ----------------------------
DROP TABLE IF EXISTS `c_sysconfig`;
CREATE TABLE `c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of c_sysconfig
-- ----------------------------

-- ----------------------------
-- Table structure for `k_drift_bottle`
-- ----------------------------
DROP TABLE IF EXISTS `k_drift_bottle`;
CREATE TABLE `k_drift_bottle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` text COLLATE utf8_unicode_ci COMMENT '内容',
  `img` text COLLATE utf8_unicode_ci,
  `status` tinyint(2) DEFAULT '1' COMMENT '当前状态，1未领取，2正在处理，3已处理,默认1',
  `create_staff_id` int(11) DEFAULT NULL COMMENT '创建人',
  `create_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人姓名',
  `create_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `duty_staff_id` int(11) DEFAULT NULL COMMENT '责任人id',
  `duty_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人姓名',
  `duty_position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任岗位code',
  `duty_position` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任岗位名称',
  `brand_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receive_staff_id` int(11) DEFAULT NULL COMMENT '领取人',
  `receive_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领取人',
  `receive_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receive_time` datetime DEFAULT NULL COMMENT '领取时间',
  `note` text COLLATE utf8_unicode_ci COMMENT '备注',
  `my_delete` datetime DEFAULT NULL COMMENT '在我的瓶子列表里删除',
  `is_hidden` tinyint(4) DEFAULT '2',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='漂流瓶';

-- ----------------------------
-- Records of k_drift_bottle
-- ----------------------------

-- ----------------------------
-- Table structure for `k_manage_log`
-- ----------------------------
DROP TABLE IF EXISTS `k_manage_log`;
CREATE TABLE `k_manage_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `work_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工单编号',
  `order_number` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资编号',
  `w_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `w_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `m_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `m_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manage_type` tinyint(2) DEFAULT NULL COMMENT '处理类型，0暂时保存跟进备注，1跟进记录，2二次满意度，3领取、转送、升级更换处理人，4驳回',
  `is_manage` tinyint(2) DEFAULT NULL COMMENT '是否解决，1解决，2未解决',
  `manage_staff_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '处理人',
  `manage_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manage_staff_id` int(11) DEFAULT NULL COMMENT '处理人',
  `manage_time` datetime DEFAULT NULL COMMENT '处理时间',
  `manage_num` int(11) DEFAULT NULL COMMENT '当前处理次数',
  `duty_staff` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人',
  `duty_position_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任岗位code',
  `duty_positon_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任岗位',
  `brand_id` int(11) DEFAULT NULL,
  `brandclass` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `note` text COLLATE utf8_unicode_ci COMMENT '此次受理备注',
  `audio_path` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通话录音文件路径',
  PRIMARY KEY (`id`,`manage_staff_name`)
) ENGINE=MyISAM AUTO_INCREMENT=168 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='处理记录';

-- ----------------------------
-- Records of k_manage_log
-- ----------------------------

-- ----------------------------
-- Table structure for `k_order`
-- ----------------------------
DROP TABLE IF EXISTS `k_order`;
CREATE TABLE `k_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资编号',
  `orderId` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单号',
  `order_status` tinyint(2) DEFAULT NULL,
  `order_type` tinyint(2) DEFAULT NULL COMMENT '订单状态，阶段',
  `this_id` int(11) DEFAULT NULL COMMENT '各个订单在erp表里主键自増字段，需配合order_link一起使用，根据order_link判断需调用的erp接口',
  `order_link` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `package_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '包套名称',
  `total_money` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '应付金额',
  `payment_money` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '已付金额',
  `nopayment_money` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '未付金额',
  `order_time` datetime DEFAULT NULL COMMENT '订单时间',
  `consumption_type` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '消费类型',
  `photo_time` datetime DEFAULT NULL COMMENT '拍照时间',
  `mname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士姓名',
  `mphone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `wname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访环节，order已开单，photo已拍照，sp已选片，qj已取件',
  `wphone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `is_valid` tinyint(2) DEFAULT '0' COMMENT '是否有效，1有效，2下次回访，3无效',
  `invalid_reason` text COLLATE utf8_unicode_ci COMMENT '无效原因，is_valid为2时此字段不能为空',
  `visit_staff_id` int(11) DEFAULT NULL COMMENT '回访人id',
  `visit_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访人名字',
  `visit_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访人编号',
  `visit_time` datetime DEFAULT NULL COMMENT '回访时间',
  `first_visit_time` datetime DEFAULT NULL COMMENT '第一次回访时间',
  `advice` text COLLATE utf8_unicode_ci COMMENT '建议',
  `lowstand` text COLLATE utf8_unicode_ci COMMENT '低期',
  `research` text COLLATE utf8_unicode_ci COMMENT '调研',
  `keywords` text COLLATE utf8_unicode_ci COMMENT '关键词',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='订单信息表';

-- ----------------------------
-- Records of k_order
-- ----------------------------

-- ----------------------------
-- Table structure for `k_score_list`
-- ----------------------------
DROP TABLE IF EXISTS `k_score_list`;
CREATE TABLE `k_score_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderId` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `this_id` int(11) DEFAULT NULL,
  `visit_order_id` int(11) DEFAULT NULL COMMENT '回访订单表里自增id',
  `order_link` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访环节',
  `visit_object` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访对象',
  `service_score` tinyint(2) DEFAULT NULL COMMENT '服务满意度',
  `professional_score` tinyint(2) DEFAULT NULL COMMENT '专业满意度',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位code',
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位名称',
  `visit_staff_id` int(11) DEFAULT NULL COMMENT '回访人',
  `visit_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访人编号',
  `visit_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访人名字',
  `visit_time` datetime DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL COMMENT '部门id',
  `department_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of k_score_list
-- ----------------------------

-- ----------------------------
-- Table structure for `k_staff_sign`
-- ----------------------------
DROP TABLE IF EXISTS `k_staff_sign`;
CREATE TABLE `k_staff_sign` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签字人对应工单的唯一码',
  `work_number` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工单号',
  `sign_id` int(11) DEFAULT NULL COMMENT '签字人id',
  `sign_number` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签字人编号',
  `sign_name` varchar(100) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签字人名',
  `is_signature` tinyint(2) DEFAULT '2' COMMENT '是否已签字，1已签字，2未签字，3自动同意',
  `signature_time` datetime DEFAULT NULL COMMENT '签字时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=sjis;

-- ----------------------------
-- Records of k_staff_sign
-- ----------------------------


-- ----------------------------
-- Table structure for `k_visit_list`
-- ----------------------------

DROP TABLE IF EXISTS `k_visit_list`;
CREATE TABLE `k_visit_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `visit_order_id` int(11) DEFAULT NULL COMMENT '回访订单表id',
  `orderId` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单编号',
  `customerid` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资编号',
  `order_link` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '订单阶段',
  `this_id` int(11) DEFAULT NULL,
  `is_visit` tinyint(2) DEFAULT NULL COMMENT '访出或访入，1访出，2访入',
  `duration` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '时长',
  `is_valid` tinyint(2) DEFAULT NULL COMMENT '是否有效通话，1有效，2下次回访，3无效',
  `is_get_valid` tinyint(2) DEFAULT NULL COMMENT '是否达到规则设定的通话率',
  `tel_recording` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '通话录音',
  `visit_staff_id` int(11) DEFAULT NULL COMMENT '回访人id',
  `visit_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访人姓名',
  `visit_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `visit_time` datetime DEFAULT NULL COMMENT '回访时间',
  `note` text COLLATE utf8_unicode_ci COMMENT '备注',
  `brand_id` int(11) DEFAULT NULL,
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='回访记录';

-- ----------------------------
-- Records of k_visit_list
-- ----------------------------



-- ----------------------------
-- Table structure for `k_visit_object`
-- ----------------------------
DROP TABLE IF EXISTS `k_visit_object`;
CREATE TABLE `k_visit_object` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '参考 回访对象名称',
  `new_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客户标准 回访对象名称',
  `code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访对象code',
  `content` text COLLATE utf8_unicode_ci COMMENT '工作性质描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of k_visit_object
-- ----------------------------
INSERT INTO k_visit_object VALUES ('1', '网销人员', '网销人员', 'storeconsuitant2', '网销');
INSERT INTO k_visit_object VALUES ('2', '礼服秘书', '礼服秘书', 'secretaireman', '礼服秘书');
INSERT INTO k_visit_object VALUES ('3', '着装师', '着装师', 'zhuozhuangshi', '着装师');
INSERT INTO k_visit_object VALUES ('4', '楼层调度', '楼层调度', 'foor', '楼层调度（楼长）');
INSERT INTO k_visit_object VALUES ('5', '化妆师', '化妆师', 'dresser', '化妆师');
INSERT INTO k_visit_object VALUES ('6', '化妆助理', '化妆助理', 'huazhuangzhuli', '化妆助理');
INSERT INTO k_visit_object VALUES ('7', '摄影师', '摄影师', 'cameraman', '摄影师');
INSERT INTO k_visit_object VALUES ('8', '摄影助理', '摄影助理', 'photoassistant', '摄影助理');
INSERT INTO k_visit_object VALUES ('9', '样前数码修调', '样前数码修调', 'xpstaff', '样前数码修调(样前美修-修片师)');
INSERT INTO k_visit_object VALUES ('10', '选片师', '选片师', 'selectman', '选片师');
INSERT INTO k_visit_object VALUES ('11', '校稿人员', '校稿人员', 'kanbanshi', '校稿人员');
INSERT INTO k_visit_object VALUES ('12', '门市销售', '门市销售', 'storeconsuitant1', '门市销售');
INSERT INTO k_visit_object VALUES ('13', '样后数码修调师(样后精修)', '样后数码修调师', 'jxstaff', '样后数码修调师(样后精修)');
INSERT INTO k_visit_object VALUES ('14', '排版', '排版', 'pbstaff', '排版');
INSERT INTO k_visit_object VALUES ('15', '调色师', '调色师', 'tiaosestaff', '调色师');
INSERT INTO k_visit_object VALUES ('16', '取件人员', '取件人员', 'qj_renname', '取件人员');
INSERT INTO k_visit_object VALUES ('17', '服务人员', '服务人员', 'storeconsuitant4', '服务人员');



-- ----------------------------
-- Table structure for `k_visit_option`
-- ----------------------------
DROP TABLE IF EXISTS `k_visit_option`;
CREATE TABLE `k_visit_option` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `option_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访项code',
  `option_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访项名称',
  `object_id` int(11) DEFAULT NULL COMMENT '回访对象表id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of k_visit_option
-- ----------------------------
INSERT INTO k_visit_option VALUES ('1', 'storeconsuitant2-service', '服务', '1');
INSERT INTO k_visit_option VALUES ('2', 'storeconsuitant2-professional', '专业', '1');
INSERT INTO k_visit_option VALUES ('3', 'secretaireman-service', '服务', '2');
INSERT INTO k_visit_option VALUES ('4', 'secretaireman-professional', '专业', '2');
INSERT INTO k_visit_option VALUES ('5', 'zhuozhuangshi-service', '服务', '3');
INSERT INTO k_visit_option VALUES ('6', 'zhuozhuangshi-professional', '专业', '3');
INSERT INTO k_visit_option VALUES ('7', 'foor-service', '服务', '4');
INSERT INTO k_visit_option VALUES ('8', 'foor-professional', '专业', '4');
INSERT INTO k_visit_option VALUES ('9', 'dresser-service', '服务', '5');
INSERT INTO k_visit_option VALUES ('10', 'dresser-professional', '专业', '5');
INSERT INTO k_visit_option VALUES ('11', 'huazhuangzhuli-service', '服务', '6');
INSERT INTO k_visit_option VALUES ('12', 'huazhuangzhuli-professional', '专业', '6');
INSERT INTO k_visit_option VALUES ('13', 'cameraman-service', '服务', '7');
INSERT INTO k_visit_option VALUES ('14', 'cameraman-professional', '专业', '7');
INSERT INTO k_visit_option VALUES ('15', 'photoassistant-service', '服务', '8');
INSERT INTO k_visit_option VALUES ('16', 'photoassistant-professional', '专业', '8');
INSERT INTO k_visit_option VALUES ('17', 'xpstaff-service', '服务', '9');
INSERT INTO k_visit_option VALUES ('18', 'xpstaff-professional', '专业', '9');
INSERT INTO k_visit_option VALUES ('19', 'selectman-service', '服务', '10');
INSERT INTO k_visit_option VALUES ('20', 'selectman-professional', '专业', '10');
INSERT INTO k_visit_option VALUES ('21', 'kanbanshi-service', '服务', '11');
INSERT INTO k_visit_option VALUES ('22', 'kanbanshi-professional', '专业', '11');
INSERT INTO k_visit_option VALUES ('23', 'storeconsuitant1-service', '服务', '12');
INSERT INTO k_visit_option VALUES ('24', 'storeconsuitant1-professional', '专业', '12');
INSERT INTO k_visit_option VALUES ('25', 'jxstaff-service', '服务', '13');
INSERT INTO k_visit_option VALUES ('26', 'jxstaff-professional', '专业', '13');
INSERT INTO k_visit_option VALUES ('27', 'pbstaff-service', '服务', '14');
INSERT INTO k_visit_option VALUES ('28', 'pbstaff-professional', '专业', '14');
INSERT INTO k_visit_option VALUES ('29', 'tiaosestaff-service', '服务', '15');
INSERT INTO k_visit_option VALUES ('30', 'tiaosestaff-professional', '专业', '15');
INSERT INTO k_visit_option VALUES ('31', 'qj_renname-service', '服务', '16');
INSERT INTO k_visit_option VALUES ('32', 'qj_renname-professional', '专业', '16');
INSERT INTO k_visit_option VALUES ('33', 'storeconsuitant4-service', '服务', '17');
INSERT INTO k_visit_option VALUES ('34', 'storeconsuitant4-professional', '专业', '17');



-- ----------------------------
-- Table structure for `k_visit_link_object`
-- ----------------------------
DROP TABLE IF EXISTS `k_visit_link_object`;
CREATE TABLE `k_visit_link_object` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '环节,order已订单，photo已拍照，sp已选片，jg已交稿，qj已取件',
  `option_id` int(11) DEFAULT NULL COMMENT '回访项表主键id',
  `option_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访项code',
  `object_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '回访对象code',
  `add_time` datetime DEFAULT NULL COMMENT '添加时间',
  `add_staff_id` int(11) DEFAULT NULL COMMENT '操作人id',
  `add_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '操作人名字',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of k_visit_link_object
-- ----------------------------
INSERT INTO k_visit_link_object VALUES ('1', 'order', '1', 'storeconsuitant2-service', 'storeconsuitant2', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('2', 'order', '2', 'storeconsuitant2-professional', 'storeconsuitant2', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('3', 'photo', '13', 'cameraman-service', 'cameraman', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('4', 'photo', '15', 'photoassistant-service', 'photoassistant', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('5', 'photo', '9', 'dresser-service', 'dresser', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('6', 'photo', '11', 'huazhuangzhuli-service', 'huazhuangzhuli', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('7', 'photo', '3', 'secretaireman-service', 'secretaireman', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('8', 'photo', '5', 'zhuozhuangshi-service', 'zhuozhuangshi', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('9', 'photo', '7', 'foor-service', 'foor', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('10', 'photo', '8', 'foor-professional', 'foor', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('11', 'sp', '10', 'dresser-professional', 'dresser', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('12', 'sp', '12', 'huazhuangzhuli-professional', 'huazhuangzhuli', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('13', 'sp', '14', 'cameraman-professional', 'cameraman', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('14', 'sp', '16', 'photoassistant-professional', 'photoassistant', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('15', 'sp', '4', 'secretaireman-professional', 'secretaireman', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('16', 'sp', '6', 'zhuozhuangshi-professional', 'zhuozhuangshi', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('17', 'sp', '17', 'xpstaff-service', 'xpstaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('18', 'sp', '18', 'xpstaff-professional', 'xpstaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('19', 'sp', '19', 'selectman-professional', 'selectman', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('20', 'sp', '20', 'selectman-service', 'selectman', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('21', 'jg', '21', 'kanbanshi-service', 'kanbanshi', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('22', 'jg', '22', 'kanbanshi-professional', 'kanbanshi', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('23', 'qj', '23', 'storeconsuitant1-service', 'storeconsuitant1', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('24', 'qj', '24', 'storeconsuitant1-professional', 'storeconsuitant1', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('25', 'qj', '25', 'jxstaff-service', 'jxstaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('26', 'qj', '26', 'jxstaff-professional', 'jxstaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('27', 'qj', '29', 'tiaosestaff-service', 'tiaosestaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('28', 'qj', '30', 'tiaosestaff-professional', 'tiaosestaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('29', 'qj', '27', 'pbstaff-service', 'pbstaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('30', 'qj', '28', 'pbstaff-professional', 'pbstaff', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('31', 'qj', '31', 'qj_renname-service', 'qj_renname', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('32', 'qj', '32', 'qj_renname-professional', 'qj_renname', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('33', 'qj', '33', 'storeconsuitant4-service', 'storeconsuitant4', '2018-10-15 09:32:44', '1', '安宁');
INSERT INTO k_visit_link_object VALUES ('34', 'qj', '34', 'storeconsuitant4-professional', 'storeconsuitant4', '2018-10-15 09:32:44', '1', '安宁');





-- ----------------------------
-- Table structure for `k_work_order`
-- ----------------------------
DROP TABLE IF EXISTS `k_work_order`;
CREATE TABLE `k_work_order` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `work_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工单编号',
  `order_number` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `customer_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客资编号',
  `w_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士姓名',
  `w_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '女士手机号',
  `m_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士姓名',
  `m_phone` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '男士手机号',
  `brand_id` int(11) DEFAULT NULL COMMENT '事业部id',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '事业部名称',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `duty_staff_name` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '负责人名字',
  `duty_staff_id` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人id,多个用英文逗号隔开',
  `duty_staff_number` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '责任人岗位编号，多个用英文逗号隔开',
  `duty_position_code` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '负责人岗位code,多个用英文逗号隔开',
  `duty_position_name` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '负责人岗位，多个用英文逗号隔开',
  `complain_id` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '投诉分类id',
  `complain_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '投诉类型',
  `source_id` int(11) DEFAULT NULL COMMENT '工单来源id',
  `source_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工单来源',
  `level` tinyint(2) DEFAULT NULL COMMENT '客诉等级(1一般客诉,2重大客诉)',
  `describe` text COLLATE utf8_unicode_ci COMMENT '客诉描述',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `create_staff_id` int(11) DEFAULT NULL COMMENT '创建人id',
  `create_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  `create_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `is_status` tinyint(2) DEFAULT '1' COMMENT '工单状态(1未领取，2已领取，3解决中，4已解决，5二次满意度，6二次满意度调查不满意)',
  `is_ks` tinyint(2) DEFAULT '2' COMMENT '是否已确认客诉。1客诉，2待审核，3审核通过，4通过不通过，5通知相关负责人处理中，6已处理，724小时未处理自动转入客诉',
  `manage_num` int(11) DEFAULT '0' COMMENT '受理次数',
  `manage_link` int(11) DEFAULT '1' COMMENT '处理步骤',
  `receice_staff_id` int(11) DEFAULT NULL COMMENT '领取人id',
  `receice_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '领取人名字',
  `receice_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `receice_time` datetime DEFAULT NULL COMMENT '领取时间',
  `manage_staff_id` int(11) DEFAULT NULL COMMENT '当前受理人id',
  `manage_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '当前受理人名字',
  `manage_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manage_time` datetime DEFAULT NULL COMMENT '处理时间',
  `second_visit_staff_id` int(11) DEFAULT NULL COMMENT '二次满意度调查人',
  `second_visit_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '二次满意度调查人名字',
  `second_visit_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `second_visit_time` datetime DEFAULT NULL COMMENT '二次满意度回访时间',
  `is_over` tinyint(2) DEFAULT '0' COMMENT '是否满意并可签字,1满意可进行签字，2不满意，默认0',
  `over_time` datetime DEFAULT NULL COMMENT '完成满意时间',
  `discontent_reason` text COLLATE utf8_unicode_ci COMMENT '不满原因',
  `signature_staff_id` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签字确认人，多个用英文逗号隔开',
  `signature_staff_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签字确认人名字',
  `signature_staff_number` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '签字确认人员工编号',
  `is_signature` tinyint(2) DEFAULT '2' COMMENT '是否签字完成，1已完成，2未完成，默认2',
  `signature_time` datetime DEFAULT NULL COMMENT '全部完成签字时间',
  `is_sms` tinyint(2) DEFAULT '2' COMMENT '是否已短信提醒签字人，1是，2否',
  `remediation_staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '整改方案提交人',
  `remediation_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '整改方案提交人编号',
  `remediation_action` text COLLATE utf8_unicode_ci COMMENT '整改方案',
  `remediation_time` datetime DEFAULT NULL COMMENT '整改方案提交时间',
  `ks_expend` tinyint(2) DEFAULT NULL COMMENT '客诉部门支出，1无成本支出，2异业赠品解决，3自有产品解决',
  `ks_expend_money` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '客诉部门支出金额',
  `brand_expend` tinyint(2) DEFAULT NULL COMMENT '事业部投诉支出',
  `brand_expend_money` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '事业部支出金额',
  `is_refute` tinyint(2) DEFAULT '2' COMMENT '是否驳回，1驳回，2正常状态',
  `refute_reason` text COLLATE utf8_unicode_ci COMMENT '驳回备注',
  `check_staff_id` int(11) DEFAULT NULL COMMENT '客诉审核人id',
  `check_staff_number` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `check_staff_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_brand_id` int(11) DEFAULT NULL,
  `create_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `manage_brand_id` int(11) DEFAULT NULL,
  `manage_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `second_visit_brand_id` int(11) DEFAULT NULL,
  `second_visit_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='工单列表';

-- ----------------------------
-- Records of k_work_order
-- ----------------------------

-- ----------------------------
-- Table structure for `s_complain_type`
-- ----------------------------
DROP TABLE IF EXISTS `s_complain_type`;
CREATE TABLE `s_complain_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complain_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '投诉类型',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `staff_id` int(11) DEFAULT NULL COMMENT '创建人',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='投诉类型';

-- ----------------------------
-- Records of s_complain_type
-- ----------------------------
INSERT INTO s_complain_type VALUES ('1', '流程类', '2018-07-05 15:34:28', '1', '安宁', '0');
INSERT INTO s_complain_type VALUES ('36', '化妆服务不好', '2018-07-05 15:32:57', '1', '安宁', '34');
INSERT INTO s_complain_type VALUES ('35', '化妆专业度不满', '2018-06-28 19:01:05', '1', '安宁', '34');
INSERT INTO s_complain_type VALUES ('34', '化妆类', '2018-06-28 19:00:47', '1', '安宁', '0');
INSERT INTO s_complain_type VALUES ('33', '流程不顺', '2018-06-28 19:00:40', '1', '安宁', '1');

-- ----------------------------
-- Table structure for `s_invalid_reason`
-- ----------------------------
DROP TABLE IF EXISTS `s_invalid_reason`;
CREATE TABLE `s_invalid_reason` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invalid_reason` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '无效原因',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_invalid_reason
-- ----------------------------
INSERT INTO s_invalid_reason VALUES ('1', '重拍', '2018-05-26 15:43:32', '1', '安宁');
INSERT INTO s_invalid_reason VALUES ('2', '改期', '2018-05-26 15:43:41', '1', '安宁');
INSERT INTO s_invalid_reason VALUES ('3', '错号', '2018-05-26 15:43:47', '1', '安宁');
INSERT INTO s_invalid_reason VALUES ('4', '空号', '2018-05-26 15:43:54', '1', '安宁');

-- ----------------------------
-- Table structure for `s_keywords`
-- ----------------------------
DROP TABLE IF EXISTS `s_keywords`;
CREATE TABLE `s_keywords` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `num` int(11) DEFAULT '0' COMMENT '关键词出现次数',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='关键词';

-- ----------------------------
-- Records of s_keywords
-- ----------------------------


-- ----------------------------
-- Table structure for `s_manage_process`
-- ----------------------------
DROP TABLE IF EXISTS `s_manage_process`;
CREATE TABLE `s_manage_process` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sort` int(11) DEFAULT NULL COMMENT '标题',
  `manage_num` int(11) DEFAULT '1' COMMENT '本环节处理次数',
  `manage_staff_id` int(11) DEFAULT NULL COMMENT '处理人id',
  `manage_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '处理人名字',
  `manage_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '处理人编号',
  `is_great` tinyint(2) DEFAULT NULL COMMENT '是否升为重大客诉，1是，2否',
  `is_second` tinyint(2) DEFAULT NULL COMMENT '是否需要二次调查，1是，2否',
  `second_visit_staff_id` int(11) DEFAULT NULL COMMENT '二次满意度调查人id',
  `second_visit_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第二次满意度调查人名字',
  `second_visit_staff_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '第二次满意度调查人编号',
  `create_time` datetime DEFAULT NULL,
  `create_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  `is_open` tinyint(2) DEFAULT NULL COMMENT '是否开启，1开启，2不开启',
  `manage_brand_id` int(11) DEFAULT NULL,
  `manage_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `second_visit_brand_id` int(11) DEFAULT NULL,
  `second_visit_brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='受理流程';

-- ----------------------------
-- Records of s_manage_process
-- ----------------------------

-- ----------------------------
-- Table structure for `s_menu`
-- ----------------------------
DROP TABLE IF EXISTS `s_menu`;
CREATE TABLE `s_menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单名称',
  `fid` int(11) DEFAULT NULL,
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单url',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '菜单图标',
  `status` tinyint(4) DEFAULT NULL COMMENT '状态',
  `sort` int(10) unsigned DEFAULT NULL COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='功能菜单表';

-- ----------------------------
-- Records of s_menu
-- ----------------------------
INSERT INTO s_menu VALUES ('1', '首            页', '0', 'menu1512736714', '/kf/Customer/index', 'fa-home', '1', '1');
INSERT INTO s_menu VALUES ('3', '客诉中心', '0', 'menu1523872158', '/kf/Workorder/workOrderList', 'fa-exclamation-triangle', '1', '3');
INSERT INTO s_menu VALUES ('5', '统计分析', '0', 'menu1512736477', '#', 'fa-bar-chart', '1', '5');
INSERT INTO s_menu VALUES ('6', '系统设置', '0', 'menu1512650831', '#', 'fa-cog', '1', '6');
INSERT INTO s_menu VALUES ('9', '客诉来源设定', '6', 'menu1523623209', '/kf/Setting/source', '', '1', '1');
INSERT INTO s_menu VALUES ('10', '投诉类型设定', '6', 'menu1512009199', '/kf/Setting/complaintype', '', '1', '2');
INSERT INTO s_menu VALUES ('11', '受理流程设定', '6', 'menu1512028590', '/kf/Setting/manageSet', '', '1', '4');
INSERT INTO s_menu VALUES ('13', '功能菜单设定', '6', 'menu1512029909', '/kf/Setting/menuSet', '', '1', '8');
INSERT INTO s_menu VALUES ('14', '权限设定', '6', 'menu1512029925', '/kf/Setting/permission', '', '1', '9');
INSERT INTO s_menu VALUES ('15', '岗位授权', '14', 'menu1513394914', '/crm/Setting/authorise', '', '1', '1');
INSERT INTO s_menu VALUES ('16', '客诉维护', '3', 'menu1512637269', 'allCustomer', '', '0', '1');
INSERT INTO s_menu VALUES ('17', '新增客诉', '16', 'menu1512970660', '/crm/Customer/addCustomer', '', '1', '1');
INSERT INTO s_menu VALUES ('18', '客诉查询', '3', 'menu1512970347', '', '', '0', '1');
INSERT INTO s_menu VALUES ('19', '删除客诉', '16', 'menu1512970570', '/crm/Customer/delCustomer', '', '1', '2');
INSERT INTO s_menu VALUES ('20', '导出客资', '16', 'menu1512970678', '/crm/Customer/export', '', '1', '5');
INSERT INTO s_menu VALUES ('21', '刷新列表', '16', 'menu1512970682', '', '', '1', '6');
INSERT INTO s_menu VALUES ('22', '选项卡-客诉池', '18', 'menu1512698495', '', '', '1', '4');
INSERT INTO s_menu VALUES ('23', '选项卡-今日领取客诉', '18', 'menu1512698552', '', '', '1', '5');
INSERT INTO s_menu VALUES ('24', '选项卡-待处理客诉', '18', 'menu1512698635', '', '', '1', '6');
INSERT INTO s_menu VALUES ('25', '选项卡-处理中客诉', '18', 'menu1512698693', '', '', '1', '7');
INSERT INTO s_menu VALUES ('26', '选项卡-已解决客诉', '18', 'menu1512698717', '', '', '1', '8');
INSERT INTO s_menu VALUES ('27', '选项卡-已驳回', '18', 'menu1512698836', '', '', '1', '9');
INSERT INTO s_menu VALUES ('28', '客诉跟进', '3', 'menu1512970667', '/crm/Customer/customerInfo', '', '0', '3');
INSERT INTO s_menu VALUES ('29', '右键-领取客诉', '28', 'menu1512971674', '', '', '0', '3');
INSERT INTO s_menu VALUES ('30', '右键-处理客诉', '28', 'menu1512971662', '/crm/Customer/addSalesTracking', '', '0', '14');
INSERT INTO s_menu VALUES ('31', '右键-转送客诉', '28', 'menu1512971583', '/crm/Customer/trackLog', '', '1', '3');
INSERT INTO s_menu VALUES ('32', '右键-跟进记录', '28', 'menu1512987407', '', '', '1', '1');
INSERT INTO s_menu VALUES ('34', '界面菜单', '1', 'menu1512993265', '', 'fa-home', '0', '0');
INSERT INTO s_menu VALUES ('35', '查看手机号', '3', 'menu1512998373', '3', '', '0', '2');
INSERT INTO s_menu VALUES ('36', '修改手机号', '16', 'menu1513409629', '', '', '1', '9');
INSERT INTO s_menu VALUES ('37', '修改客诉来源', '16', 'menu1513409657', '', '', '1', '10');
INSERT INTO s_menu VALUES ('38', '修改投诉类型', '16', 'menu1514183289', '/crm/Setting/callPrefix', '', '1', '30');
INSERT INTO s_menu VALUES ('39', '查看个人权限', '1', 'menu1515927010', '', '', '0', '0');
INSERT INTO s_menu VALUES ('40', '品控中心', '0', 'menu1524793078', '/kf/Training/trainList', 'fa-user', '1', '4');
INSERT INTO s_menu VALUES ('41', '培训', '40', 'menu1524793162', '/kf/Training/trainList', '', '1', '0');
INSERT INTO s_menu VALUES ('42', '知识库', '40', 'menu1524793232', '/kf/Knowledge/knowledgeList', '', '1', '0');
INSERT INTO s_menu VALUES ('43', '题库', '40', 'menu1524793309', '/kf/Question/questionList', '', '1', '0');
INSERT INTO s_menu VALUES ('44', '考试', '40', 'menu1524812569', '/kf/Test/testList', '', '1', '0');
INSERT INTO s_menu VALUES ('45', '质检单项列表', '40', 'menu1524892635', '/kf/Quality/singleList', '', '1', '0');
INSERT INTO s_menu VALUES ('46', '质检单', '40', 'menu1524904168', '/kf/Quality/qualityList', '', '1', '0');
INSERT INTO s_menu VALUES ('47', '回访中心', '0', 'menu1525397821', '/kf/Visit/orderList', 'fa-edit', '1', '2');
INSERT INTO s_menu VALUES ('48', '漂流瓶', '0', 'menu1525672010', '/kf/Bottle/bottleList', 'fa-envelope-o', '1', '7');
INSERT INTO s_menu VALUES ('49', '系统相关设定', '6', 'menu1525770091', '/kf/Setting/systemSet', '', '1', '3');
INSERT INTO s_menu VALUES ('50', '回访完成后可修改', '52', 'menu1526030326', '', '', '0', '0');
INSERT INTO s_menu VALUES ('51', '订单查询', '47', 'menu1526043350', '', '', '0', '1');
INSERT INTO s_menu VALUES ('52', '回访操作', '47', 'menu1526043372', '', '', '0', '2');
INSERT INTO s_menu VALUES ('53', '订单回访', '52', 'menu1526043434', '', '', '0', '1');
INSERT INTO s_menu VALUES ('54', '查看回访记录', '52', 'menu1526043452', '', '', '0', '3');
INSERT INTO s_menu VALUES ('55', '无效原因统计', '5', 'menu1526278946', '/kf/Statistics/invalid', '', '1', '1');
INSERT INTO s_menu VALUES ('56', '回访无效设定', '6', 'menu1527313960', '/kf/Setting/invalidSet', '', '1', '0');
INSERT INTO s_menu VALUES ('57', '事业部客诉汇总', '5', 'menu1528100739', '/kf/statistics/ksEveryMonth', '', '1', '5');
INSERT INTO s_menu VALUES ('58', '客诉责任分类', '5', 'menu1528176291', '/kf/Statistics/ksDutyClassify', '', '1', '6');
INSERT INTO s_menu VALUES ('59', '事业部回访同期', '5', 'menu1528366808', '/kf/Statistics/visitSameTime', '', '1', '2');
INSERT INTO s_menu VALUES ('60', '事业部-部门对比', '5', 'menu1528428078', '/kf/Statistics/departmentBrand', '', '1', '4');
INSERT INTO s_menu VALUES ('61', '事业部回访对比', '5', 'menu1528289625', '/kf/Statistics/visitContrast2', '', '1', '3');
INSERT INTO s_menu VALUES ('67', '质检单线形图', '40', 'menu1528699427', '/kf/Quality/line', 'fa-home', '1', '0');
INSERT INTO s_menu VALUES ('68', '选项卡-二次满意度', '18', 'menu1529393390', '', '', '1', '10');
INSERT INTO s_menu VALUES ('69', '选项卡-二次满意度完成', '18', 'menu1529393467', '', '', '1', '11');
INSERT INTO s_menu VALUES ('70', '选项卡-后续跟进', '18', 'menu1529393499', '', '', '1', '12');
INSERT INTO s_menu VALUES ('71', '选项卡-全部订单', '51', 'menu1529393630', '', '', '1', '1');
INSERT INTO s_menu VALUES ('72', '选项卡-今日回访', '51', 'menu1529393664', '', '', '1', '2');
INSERT INTO s_menu VALUES ('73', '选项卡-回访中', '51', 'menu1529393706', '', '', '1', '3');
INSERT INTO s_menu VALUES ('74', '选项卡-回访失败', '51', 'menu1529393743', '', '', '1', '4');
INSERT INTO s_menu VALUES ('75', '选项卡-我的客诉', '51', 'menu1529393777', '', '', '1', '5');
INSERT INTO s_menu VALUES ('76', '选项卡-待审核客诉', '51', 'menu1529393800', '', '', '1', '6');
INSERT INTO s_menu VALUES ('77', '选项卡-回访完成', '51', 'menu1530429938', '', '', '0', '3');
INSERT INTO s_menu VALUES ('78', '调研问题设定', '6', 'menu1530523869', '/kf/Setting/researchSet', '', '0', '0');
INSERT INTO s_menu VALUES ('79', '订单查询', '0', 'menu1533216429', '/kf/Workorder/searchOrder', 'fa-search', '1', '8');
INSERT INTO s_menu VALUES ('80', '回访对象结果统计', '5', 'menu1536402619', '/kf/Statistics/staffVisit', '', '1', '7');
INSERT INTO s_menu VALUES ('81', '员工回访量对比', '5', 'menu1539054592', '/kf/Statistics/visitAmount', '', '1', '8');
INSERT INTO s_menu VALUES ('82', '回访对象名称', '6', 'menu1539222383', '/kf/Setting/visitObjectName', '', '1', '5');
INSERT INTO s_menu VALUES ('83', '回访环节设定', '6', 'menu1539229325', '/kf/Setting/setVisitLinkObject', '', '1', '6');
INSERT INTO s_menu VALUES ('84', '查看所有客诉', '3', 'menu1542865371', '', '', '0', '0');
INSERT INTO s_menu VALUES ('85', '回访环节回访', '47', 'menu1542865425', '', '', '0', '0');
INSERT INTO s_menu VALUES ('86', '回访环节订单', '79', 'menu1542865463', '', '', '0', '0');

-- ----------------------------
-- Table structure for `s_position_menu`
-- ----------------------------
DROP TABLE IF EXISTS `s_position_menu`;
CREATE TABLE `s_position_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位唯一标识',
  `menu_code` varchar(2000) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单唯一标识',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '功能菜单url',
  `status` tinyint(2) DEFAULT NULL COMMENT '状态，1是显示，2不显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_position_menu
-- ----------------------------

-- ----------------------------
-- Table structure for `s_qualitys`
-- ----------------------------
DROP TABLE IF EXISTS `s_qualitys`;
CREATE TABLE `s_qualitys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '质检单名称',
  `type` tinyint(2) NOT NULL COMMENT '质检类型，1抽检（集团类），2自检（事业部内部自检），3神密顾客',
  `quality_list` text COLLATE utf8_unicode_ci NOT NULL COMMENT '质检项（json）',
  `start_time` datetime DEFAULT NULL COMMENT '质检开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '质检结束时间',
  `score` mediumint(4) NOT NULL DEFAULT '0',
  `create_staff_id` int(11) NOT NULL COMMENT '创建人ID',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='质检单';

-- ----------------------------
-- Records of s_qualitys
-- ----------------------------
INSERT INTO s_qualitys VALUES ('3', '测试宁', '1', '{\"17\":{\"id\":\"17\",\"top_score\":\"5\"},\"18\":{\"id\":\"18\",\"top_score\":\"4\"},\"19\":{\"id\":\"19\",\"top_score\":\"4\"}}', '2018-05-10 00:00:00', '2019-10-03 00:00:00', '13', '478', '2018-05-10 20:55:36');
INSERT INTO s_qualitys VALUES ('4', '测试质检', '1', '{\"15\":{\"id\":\"15\",\"top_score\":\"5\"},\"14\":{\"id\":\"14\",\"top_score\":\"5\"},\"13\":{\"id\":\"13\",\"top_score\":\"5\"}}', '2018-08-16 00:00:00', '2018-08-17 00:00:00', '15', '1', '2018-08-16 22:00:52');

-- ----------------------------
-- Table structure for `s_quality_detail`
-- ----------------------------
DROP TABLE IF EXISTS `s_quality_detail`;
CREATE TABLE `s_quality_detail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单编号',
  `from_select` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单项',
  `opsiton` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选项',
  `create_staff_id` int(11) DEFAULT NULL,
  `create_staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '创建人',
  `get_position` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '选择值',
  `get_score` int(11) DEFAULT NULL COMMENT '得分',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='质检详情';

-- ----------------------------
-- Records of s_quality_detail
-- ----------------------------

-- ----------------------------
-- Table structure for `s_quality_items`
-- ----------------------------
DROP TABLE IF EXISTS `s_quality_items`;
CREATE TABLE `s_quality_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quality_id` int(11) NOT NULL COMMENT '质检单名称',
  `quality_list_id` int(11) NOT NULL COMMENT '单项ID',
  `username` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `object_id` int(10) DEFAULT NULL,
  `score` tinyint(3) NOT NULL COMMENT '分数',
  `remarks` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='质检单单项检查结果';

-- ----------------------------
-- Records of s_quality_items
-- ----------------------------
INSERT INTO s_quality_items VALUES ('19', '3', '17', null, '17', '5', '{\"a\":\"\\u9001\\u8fbe11111\",\"old_score\":1,\"old_remarks\":\"\\u9001\\u8fbe\"}');
INSERT INTO s_quality_items VALUES ('20', '3', '18', null, '17', '2', '{\"a\":\"\\u963f\\u65af\\u8fbe1111111\",\"old_score\":4,\"old_remarks\":\"\\u963f\\u65af\\u8fbe\"}');
INSERT INTO s_quality_items VALUES ('21', '3', '19', null, '17', '2', '{\"a\":\"\\u554a\\u5b9e\\u6253\\u5b9e111111\",\"old_score\":4,\"old_remarks\":\"\\u554a\\u5b9e\\u6253\\u5b9e\"}');

-- ----------------------------
-- Table structure for `s_quality_list`
-- ----------------------------
DROP TABLE IF EXISTS `s_quality_list`;
CREATE TABLE `s_quality_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '单项名称',
  `options` text COLLATE utf8_unicode_ci NOT NULL COMMENT '单项选择及分数（Json）',
  `top_score` smallint(3) DEFAULT '0' COMMENT 'top_score',
  `create_staff_id` int(11) NOT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='质检 单项列表';

-- ----------------------------
-- Records of s_quality_list
-- ----------------------------
INSERT INTO s_quality_list VALUES ('13', '请对服务态度打分', '{\"options\":{\"1\":\"\\u975e\\u5e38\\u597d\",\"2\":\"\\u4e00\\u822c\",\"3\":\"\\u5f88\\u597d\"},\"score\":{\"1\":5,\"2\":4,\"3\":3}}', '5', '478', '2018-05-02 14:22:32');
INSERT INTO s_quality_list VALUES ('14', '请对工作效率进行评价', '{\"options\":{\"1\":\"\\u975e\\u5e38\\u597d\",\"2\":\"\\u4e00\\u822c\",\"3\":\"\\u5dee\\u4e0d\\u591a\",\"4\":\"\\u5dee\"},\"score\":{\"1\":5,\"2\":4,\"3\":3,\"4\":2}}', '5', '478', '2018-05-02 14:23:09');
INSERT INTO s_quality_list VALUES ('15', '请对专业水平打分', '{\"options\":{\"1\":\"\\u975e\\u5e38\\u597d\",\"2\":\"\\u5f88\\u597d\",\"3\":\"\\u4e00\\u822c\",\"4\":\"\\u5dee\\u4e0d\\u591a\"},\"score\":{\"1\":5,\"2\":4,\"3\":3,\"4\":2}}', '5', '478', '2018-05-02 14:23:36');
INSERT INTO s_quality_list VALUES ('16', '请对一用一表打发', '{\"options\":{\"1\":\"\\u975e\\u5e38\\u597d\",\"2\":\"\\u5f88\\u597d\",\"3\":\"\\u4e00\\u822c\"},\"score\":{\"1\":5,\"2\":4,\"3\":3}}', '5', '478', '2018-05-02 14:24:14');
INSERT INTO s_quality_list VALUES ('17', '请的撒大声地撒进行评价', '{\"options\":{\"1\":\"12345\",\"2\":\"123456\",\"3\":\"123\",\"4\":\"123\"},\"score\":{\"1\":5,\"2\":1,\"3\":1,\"4\":1}}', '5', '478', '2018-05-02 14:24:46');

-- ----------------------------
-- Table structure for `s_quality_object`
-- ----------------------------
DROP TABLE IF EXISTS `s_quality_object`;
CREATE TABLE `s_quality_object` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quality_id` int(11) NOT NULL COMMENT '质检单ID',
  `group_id` int(11) DEFAULT NULL COMMENT '集团ID',
  `brand_id` int(11) DEFAULT '0' COMMENT '事业部ID',
  `username` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mobile` int(50) DEFAULT NULL,
  `brandclass` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `orderid` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_code` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '质检对象',
  `shop_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `branch_id` int(11) DEFAULT '0' COMMENT '部门ID',
  `score` smallint(3) DEFAULT '-1' COMMENT '质检得分',
  `reply` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tip` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `question` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `result` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '质检结果',
  `staff_id` int(11) DEFAULT NULL COMMENT '质检人ID',
  `is_end` tinyint(2) DEFAULT '0' COMMENT '质检结束（0：未结束，1:已结束）',
  `object_type` tinyint(2) DEFAULT '1' COMMENT '质检对象类型，1店面，2部门',
  `department_id` int(11) DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='质检对象以及结果';

-- ----------------------------
-- Records of s_quality_object
-- ----------------------------

-- ----------------------------
-- Table structure for `s_quality_test`
-- ----------------------------
DROP TABLE IF EXISTS `s_quality_test`;
CREATE TABLE `s_quality_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_number` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单编号',
  `from_select` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '表单项',
  `test_type` tinyint(2) DEFAULT NULL COMMENT '质检类型，1抽检（集团类），2自检（事业部内部自检），3神密顾客',
  `title` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `check_object` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '检查对象',
  `result` tinyint(2) DEFAULT NULL COMMENT '检查结果',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='质检';

-- ----------------------------
-- Records of s_quality_test
-- ----------------------------

-- ----------------------------
-- Table structure for `s_remind_rule`
-- ----------------------------
DROP TABLE IF EXISTS `s_remind_rule`;
CREATE TABLE `s_remind_rule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule` int(11) DEFAULT NULL COMMENT '预警规则，百分比',
  `time_range` int(11) DEFAULT NULL COMMENT '时间范围（例7天）',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='预警提醒规则';

-- ----------------------------
-- Records of s_remind_rule
-- ----------------------------

-- ----------------------------
-- Table structure for `s_session`
-- ----------------------------
DROP TABLE IF EXISTS `s_session`;
CREATE TABLE `s_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌;3:离线'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';

-- ----------------------------
-- Records of s_session
-- ----------------------------


-- ----------------------------
-- Table structure for `s_source`
-- ----------------------------
DROP TABLE IF EXISTS `s_source`;
CREATE TABLE `s_source` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `source_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '工单来源名称,固定来源：1回访，2事业部，3会员',
  `is_must` tinyint(2) DEFAULT '2' COMMENT '是否为固定来源,1是，2否',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `statistics` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '统计业绩，1计算员工业绩，2计算事业部业绩',
  `is_great` tinyint(2) DEFAULT NULL COMMENT '此来源的客诉是否为重大客诉，1是，2否',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='工单来源';

-- ----------------------------
-- Records of s_source
-- ----------------------------
INSERT INTO s_source VALUES ('1', '回访', '1', '2018-05-26 14:06:08', '1', '安宁', null, null);
INSERT INTO s_source VALUES ('2', '事业部提报', '1', null, null, null, null, null);
INSERT INTO s_source VALUES ('3', '会员', '1', null, null, null, null, null);
INSERT INTO s_source VALUES ('4', '400', '1', null, null, null, null, null);
INSERT INTO s_source VALUES ('5', '工商', '1', null, null, null, null, null);
INSERT INTO s_source VALUES ('20', '其他', '2', '2018-06-19 12:34:27', '1', '安宁', '2', '2');

-- ----------------------------
-- Table structure for `s_sysconfig`
-- ----------------------------
DROP TABLE IF EXISTS `s_sysconfig`;
CREATE TABLE `s_sysconfig` (
  `skey` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `svalue` text COLLATE utf8_unicode_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- ----------------------------
-- Records of s_sysconfig
-- ----------------------------
INSERT INTO s_sysconfig VALUES ('kf', '{\"visit_tel\":\"0.5\",\"ks_signature\":\"1\",\"zj_object\":\"2\"}');

-- ----------------------------
-- Table structure for `t_knowledge`
-- ----------------------------
DROP TABLE IF EXISTS `t_knowledge`;
CREATE TABLE `t_knowledge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT '0' COMMENT '所属目录ID',
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '名称',
  `content` text COLLATE utf8_unicode_ci COMMENT '内容（可下载）',
  `disable` tinyint(2) DEFAULT '0' COMMENT '是否启用（0：不启用，1启用）',
  `is_delete` tinyint(2) DEFAULT '0' COMMENT '是否删除(0:未删除，1:已删除)',
  `create_staff_id` int(11) NOT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='知识库';

-- ----------------------------
-- Records of t_knowledge
-- ----------------------------
INSERT INTO t_knowledge VALUES ('7', '10', '摄影师必备技能', '                            <p id=\"best-content-966718280\" class=\"best-text mb-10\"><span style=\"text-align: left;\">要如何去定义好的摄影师呢？作为一个摄影师，你是否也曾梦想和摄影大师一样拍出好的照片？你是否勇于去尝试大作？以下简单的9个步骤给你一个起头，让你从这裡开始自我培养。或是你觉得你已经是一个很棒的摄影师，那么请用这9项作为最基本的标准来检测自己吧！</span></p><p class=\"best-text mb-10\"><span style=\"text-align: left;\"><img src=\"/upload/img/20180510/8a02bd6cd01da3d8f0797f896b9e4f74.jpg\" class=\"images\" layer-src=\"/upload/img/20180510/8a02bd6cd01da3d8f0797f896b9e4f74.jpg\" alt=\"undefined\"><br></span></p>', '0', '0', '478', '2018-05-10 19:25:10');

-- ----------------------------
-- Table structure for `t_knowledge_class`
-- ----------------------------
DROP TABLE IF EXISTS `t_knowledge_class`;
CREATE TABLE `t_knowledge_class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '目录名称',
  `p_id` int(10) DEFAULT '0' COMMENT '父ID',
  `child_number` int(10) DEFAULT '0' COMMENT '子目录数量',
  `create_staff_id` int(11) NOT NULL COMMENT '创建人ID',
  `is_delete` tinyint(1) DEFAULT '0' COMMENT '是否删除（0，未删除，1已删除）',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `level` tinyint(2) NOT NULL DEFAULT '1' COMMENT '目录级别',
  `power` text COLLATE utf8_unicode_ci COMMENT '目录权限（json）',
  PRIMARY KEY (`id`),
  KEY `p_id` (`p_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='知识库目录';

-- ----------------------------
-- Records of t_knowledge_class
-- ----------------------------
INSERT INTO t_knowledge_class VALUES ('10', '摄影', '0', '1', '478', '0', '2018-05-10 19:23:38', '1', null);
INSERT INTO t_knowledge_class VALUES ('11', '销售', '0', '0', '478', '0', '2018-05-10 19:23:49', '1', null);
INSERT INTO t_knowledge_class VALUES ('12', '后勤', '0', '0', '478', '0', '2018-05-10 19:24:05', '1', null);

-- ----------------------------
-- Table structure for `t_knowledge_pv_logs`
-- ----------------------------
DROP TABLE IF EXISTS `t_knowledge_pv_logs`;
CREATE TABLE `t_knowledge_pv_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL COMMENT '访问用户ID',
  `knowledge_id` int(11) NOT NULL COMMENT '知识库ID',
  `source` varchar(10) COLLATE utf8_unicode_ci DEFAULT 'pc' COMMENT '浏览来源（pc,app,wap,wechat)）',
  `create_time` datetime NOT NULL COMMENT '访问时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='知识库访问日志';

-- ----------------------------
-- Records of t_knowledge_pv_logs
-- ----------------------------
INSERT INTO t_knowledge_pv_logs VALUES ('1', '478', '7', 'wx', '2018-06-11 15:51:21');

-- ----------------------------
-- Table structure for `t_question`
-- ----------------------------
DROP TABLE IF EXISTS `t_question`;
CREATE TABLE `t_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `question_type` tinyint(2) DEFAULT '1' COMMENT '题型，1单选题，2多选题，3填空题，4简答题',
  `question` text COLLATE utf8_unicode_ci COMMENT '考题内容',
  `answer` text COLLATE utf8_unicode_ci COMMENT '选项和答案(json)',
  `score` int(11) DEFAULT '0' COMMENT '分值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='题库';

-- ----------------------------
-- Records of t_question
-- ----------------------------
INSERT INTO t_question VALUES ('32', '1', '1+1=？', '{\"content\":{\"A\":\"2\",\"B\":\"3\",\"C\":\"4\",\"D\":\"5\"},\"answer\":\"A\"}', '5');
INSERT INTO t_question VALUES ('33', '1', '3x5=?', '{\"content\":{\"A\":\"3\",\"B\":\"4\",\"C\":\"5\",\"D\":\"6\",\"E\":\"15\"},\"answer\":\"E\"}', '20');
INSERT INTO t_question VALUES ('34', '1', '一一得几', '{\"content\":{\"A\":\"1\",\"B\":\"2\",\"C\":\"3\",\"D\":\"4\"},\"answer\":\"A\"}', '10');
INSERT INTO t_question VALUES ('35', '1', '5-3=？', '{\"content\":{\"A\":\"2\",\"B\":\"3\",\"C\":\"4\",\"D\":\"5\"},\"answer\":\"A\"}', '10');
INSERT INTO t_question VALUES ('36', '2', '1+1=？', '{\"content\":{\"A\":\"1\",\"B\":\"\\u4e00\",\"C\":\"4\",\"D\":\"5\"},\"answer\":[\"A\",\"B\"]}', '3');
INSERT INTO t_question VALUES ('37', '4', '白日依山尽？', '[\"1\"]', '10');
INSERT INTO t_question VALUES ('38', '4', '一杯敬明天', '[\"\\u4e00\\u676f\\u656c\\u660e\\u5929\"]', '10');
INSERT INTO t_question VALUES ('39', '4', '鹅鹅鹅', '[\"\\u9e45\",\"\\u9e45\\u9e45\"]', '10');
INSERT INTO t_question VALUES ('40', '3', '白日(______)(______)', '[\"\\u4f9d\\u5c71\",\"\\u5c3d\"]', '10');
INSERT INTO t_question VALUES ('42', '4', '怎样拍照显腿长(______)', '[\"12\"]', '10');
INSERT INTO t_question VALUES ('43', '3', '干啥呢(______)', '[\"\\u5403\\u996d\"]', '10');
INSERT INTO t_question VALUES ('44', '1', '123', '{\"content\":{\"A\":\"123\",\"B\":\"1231\",\"C\":\"2312\"},\"answer\":\"A\"}', '12');
INSERT INTO t_question VALUES ('45', '3', '12312(______)', '[\"qwe\"]', '12');
INSERT INTO t_question VALUES ('46', '2', '1+1=？', '{\"content\":{\"A\":\"1\",\"B\":\"\\u4e00\",\"C\":\"4\",\"D\":\"5\"},\"answer\":[\"A\",\"B\"]}', '3');

-- ----------------------------
-- Table structure for `t_staff_question`
-- ----------------------------
DROP TABLE IF EXISTS `t_staff_question`;
CREATE TABLE `t_staff_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_question_id` int(11) DEFAULT NULL COMMENT '考题id',
  `staff_answer` text COLLATE utf8_unicode_ci COMMENT '答题内容',
  `score` int(11) DEFAULT NULL COMMENT '得分',
  `staff_id` int(11) DEFAULT NULL COMMENT '答题人',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='人员试题表';

-- ----------------------------
-- Records of t_staff_question
-- ----------------------------

-- ----------------------------
-- Table structure for `t_test`
-- ----------------------------
DROP TABLE IF EXISTS `t_test`;
CREATE TABLE `t_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '考试名称',
  `training_id` int(11) DEFAULT '0' COMMENT '培训ID',
  `start_time` datetime NOT NULL COMMENT '开始时间',
  `end_time` datetime NOT NULL COMMENT '结束时间',
  `address` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '考试地址',
  `type` tinyint(2) NOT NULL COMMENT '出题类型（1：固定题目，2：随机题目）',
  `apply_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '审题类型：1自动审题；2：手动审题',
  `supplement_num` tinyint(2) NOT NULL DEFAULT '0' COMMENT '补考次数',
  `export_rule` text COLLATE utf8_unicode_ci COMMENT '导出时5个档次分析',
  `amount_score` tinyint(2) NOT NULL DEFAULT '0' COMMENT '总分',
  `pass_score` tinyint(2) NOT NULL DEFAULT '0' COMMENT '及格分',
  `rule` text COLLATE utf8_unicode_ci COMMENT '随机题目规则',
  `create_staff_id` int(11) NOT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='考试表';

-- ----------------------------
-- Records of t_test
-- ----------------------------
INSERT INTO t_test VALUES ('10', '摄影技术', '4', '2018-05-10 00:00:00', '2018-09-28 00:00:00', '这里', '1', '1', '0', '{\"1\":{\"min\":\"\",\"max\":\"\"},\"2\":{\"min\":\"\",\"max\":\"\"},\"3\":{\"min\":\"\",\"max\":\"\"},\"4\":{\"min\":\"\",\"max\":\"\"},\"5\":{\"min\":\"\",\"max\":\"\"}}', '100', '60', '{\"1\":[{\"question_id\":\"32\",\"score\":\"5\"},{\"question_id\":\"33\",\"score\":\"20\"},{\"question_id\":\"34\",\"score\":\"10\"},{\"question_id\":\"35\",\"score\":\"10\"}],\"2\":[{\"question_id\":\"36\",\"score\":\"55\"}]}', '478', '2018-05-10 20:23:36');
INSERT INTO t_test VALUES ('11', '拍照', '5', '2018-05-10 00:00:00', '2018-10-05 00:00:00', '·1', '2', '1', '1', '{\"1\":{\"min\":\"\",\"max\":\"\"},\"2\":{\"min\":\"\",\"max\":\"\"},\"3\":{\"min\":\"\",\"max\":\"\"},\"4\":{\"min\":\"\",\"max\":\"\"},\"5\":{\"min\":\"\",\"max\":\"\"}}', '100', '40', '{\"1\":{\"num\":2,\"score\":20},\"2\":{\"num\":1,\"score\":20},\"3\":{\"num\":2,\"score\":10},\"4\":{\"num\":2,\"score\":10}}', '478', '2018-05-10 20:46:37');
INSERT INTO t_test VALUES ('12', '2018年第五次', '0', '2018-06-10 00:00:00', '2018-07-06 00:00:00', '考试地址考试地址', '1', '1', '2', '{\"1\":{\"min\":\"\",\"max\":\"\"},\"2\":{\"min\":\"\",\"max\":\"\"},\"3\":{\"min\":\"\",\"max\":\"\"},\"4\":{\"min\":\"\",\"max\":\"\"},\"5\":{\"min\":\"\",\"max\":\"\"}}', '100', '60', '{\"1\":[{\"question_id\":\"32\",\"score\":\"5\"},{\"question_id\":\"33\",\"score\":\"20\"},{\"question_id\":\"34\",\"score\":\"10\"}],\"2\":[{\"question_id\":\"36\",\"score\":\"25\"}],\"3\":[{\"question_id\":\"40\",\"score\":\"10\"}],\"4\":[{\"question_id\":\"38\",\"score\":\"10\"},{\"question_id\":\"39\",\"score\":\"10\"},{\"question_id\":\"37\",\"score\":\"10\"}]}', '478', '2018-06-11 14:10:27');

-- ----------------------------
-- Table structure for `t_test_answer`
-- ----------------------------
DROP TABLE IF EXISTS `t_test_answer`;
CREATE TABLE `t_test_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL COMMENT '考试ID',
  `test_question_id` int(11) NOT NULL COMMENT '考题ID',
  `answer` text COLLATE utf8_unicode_ci NOT NULL COMMENT '答案（json）',
  `sing_score` text COLLATE utf8_unicode_ci COMMENT '单题得分',
  `answer_staff_id` int(11) NOT NULL COMMENT '答卷人ID',
  `answer_staff_name` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '答题人姓名',
  `create_time` datetime NOT NULL COMMENT '提交答案时间',
  `apply_staff_id` int(11) DEFAULT '0' COMMENT '最后一次审题人ID（0代表自动审题）',
  `brandclass` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `department_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `position_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `amount_score` int(11) DEFAULT '-1',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `points` mediumint(9) DEFAULT '0',
  `apply_time` datetime DEFAULT NULL COMMENT '最后审题时间',
  `score` smallint(3) NOT NULL DEFAULT '-1' COMMENT '得分',
  `is_supplement` tinyint(2) DEFAULT '0' COMMENT '是否是补考（0：否，1：是）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='考试结果表';

-- ----------------------------
-- Records of t_test_answer
-- ----------------------------
INSERT INTO t_test_answer VALUES ('52', '10', '278', '{\"32\":\"B\",\"33\":\"C\",\"34\":\"B\",\"35\":\"A\",\"36\":[\"B\",\"D\"]}', '{\"32\":0,\"33\":0,\"34\":0,\"35\":\"20\",\"36\":0}', '478', '柴冬冬', '2018-05-10 20:32:41', '0', null, null, null, '-1', null, '0', '2018-05-10 20:32:41', '20', '0');
INSERT INTO t_test_answer VALUES ('53', '10', '278', '{\"32\":\"A\",\"33\":\"E\",\"35\":\"A\",\"36\":[\"A\",\"B\"]}', '{\"32\":\"20\",\"33\":\"20\",\"35\":\"20\",\"36\":\"20\"}', '478', '柴冬冬', '2018-05-10 20:33:11', '0', null, null, null, '-1', null, '0', '2018-05-10 20:33:11', '80', '1');
INSERT INTO t_test_answer VALUES ('54', '11', '279', '{\"33\":\"A\",\"35\":\"A\",\"36\":[\"C\"],\"40\":[\"sdfs\"],\"43\":[\"sdfsdf\"],\"37\":\"11\",\"38\":\"11\"}', null, '478', '柴冬冬', '2018-05-10 20:51:20', '0', null, null, null, '-1', null, '0', null, '-1', '0');
INSERT INTO t_test_answer VALUES ('57', '12', '280', '{\"32\":\"A\",\"33\":\"E\",\"34\":\"B\",\"36\":[\"B\"],\"40\":[\"drt\",\"dg\"],\"38\":\"dfg\",\"39\":\"dfgd\",\"37\":\"dfg\"}', '{\"32\":\"5\",\"33\":\"20\",\"34\":0,\"36\":0,\"40\":0,\"38\":0,\"39\":0,\"37\":0}', '478', '柴冬冬', '2018-06-11 16:05:27', '0', '时尚经典事业部', '电商部', '电商经理', '25', 'VVC010', '0', '2018-06-11 16:05:27', '25', '0');
INSERT INTO t_test_answer VALUES ('58', '12', '280', '{\"32\":\"A\",\"33\":\"E\",\"34\":\"B\",\"36\":[\"B\",\"C\"],\"40\":[\"\\u4f9d\\u5c71\",\"1\"],\"38\":\"\\u4e00\\u676f\\u656c\\u660e\\u5929\",\"39\":\"\\u9e45\\u9e45\\u9e45\",\"37\":\"12345\"}', '{\"32\":\"5\",\"33\":\"20\",\"34\":0,\"36\":0,\"40\":10,\"38\":\"10\",\"39\":0,\"37\":0}', '478', '柴冬冬', '2018-06-11 16:07:25', '0', '时尚经典事业部', '电商部', '电商经理', '95', 'VVC010', '50', '2018-06-11 16:07:25', '45', '1');

-- ----------------------------
-- Table structure for `t_test_question`
-- ----------------------------
DROP TABLE IF EXISTS `t_test_question`;
CREATE TABLE `t_test_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `question_list` text COLLATE utf8_unicode_ci NOT NULL COMMENT '考题ID和对应分数（json）',
  `apply_type` tinyint(2) DEFAULT '1' COMMENT '审核类型（1：自动审题，2：人工审题）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=281 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='考题列表';

-- ----------------------------
-- Records of t_test_question
-- ----------------------------
INSERT INTO t_test_question VALUES ('278', '10', '{\"1\":[{\"question_id\":\"32\",\"score\":\"20\"},{\"question_id\":\"33\",\"score\":\"20\"},{\"question_id\":\"34\",\"score\":\"20\"},{\"question_id\":\"35\",\"score\":\"20\"}],\"2\":[{\"question_id\":\"36\",\"score\":\"20\"}]}', '1');
INSERT INTO t_test_question VALUES ('279', '11', '{\"1\":[{\"question_id\":33,\"score\":20},{\"question_id\":35,\"score\":20}],\"2\":[{\"question_id\":36,\"score\":20}],\"3\":[{\"question_id\":40,\"score\":10},{\"question_id\":43,\"score\":10}],\"4\":[{\"question_id\":37,\"score\":10},{\"question_id\":38,\"score\":10}]}', '2');
INSERT INTO t_test_question VALUES ('280', '12', '{\"1\":[{\"question_id\":\"32\",\"score\":\"5\"},{\"question_id\":\"33\",\"score\":\"20\"},{\"question_id\":\"34\",\"score\":\"10\"}],\"2\":[{\"question_id\":\"36\",\"score\":\"25\"}],\"3\":[{\"question_id\":\"40\",\"score\":\"10\"}],\"4\":[{\"question_id\":\"38\",\"score\":\"10\"},{\"question_id\":\"39\",\"score\":\"10\"},{\"question_id\":\"37\",\"score\":\"10\"}]}', '1');

-- ----------------------------
-- Table structure for `t_training`
-- ----------------------------
DROP TABLE IF EXISTS `t_training`;
CREATE TABLE `t_training` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '培训项目',
  `content` text COLLATE utf8_unicode_ci NOT NULL COMMENT '培训内容',
  `img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '展示图',
  `speaker` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '主讲人',
  `start_time` datetime NOT NULL COMMENT '培训开始时间',
  `end_time` datetime NOT NULL COMMENT '培训结束时间',
  `address` varchar(100) COLLATE utf8_unicode_ci NOT NULL COMMENT '培训地点',
  `file` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `tidbit` text COLLATE utf8_unicode_ci COMMENT '培训花絮',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '培训状态（1：正常，2：暂停，3：作废）',
  `create_staff_id` int(10) NOT NULL COMMENT '创建人',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='培训表';

-- ----------------------------
-- Records of t_training
-- ----------------------------
INSERT INTO t_training VALUES ('4', '摄影技巧', '盛世嫡妃第三个电饭锅和<img src=\"/upload/img/20180510/16ea0f61b66ca70fd264824e0c4195fa.jpg\" class=\"images\" layer-src=\"/upload/img/20180510/16ea0f61b66ca70fd264824e0c4195fa.jpg\" alt=\"undefined\">', '\\upload/pic/180510201414bUxzZw.jpg', '王依宁', '2018-05-10 00:00:00', '2018-05-11 00:00:00', '地址', null, null, '1', '1', '2018-05-10 20:14:49');
INSERT INTO t_training VALUES ('5', '瞎培训', '123412312312', '\\upload/pic/180510204903fFuMSh.jpg', '我', '2018-05-09 00:00:00', '2018-07-26 00:00:00', '123', '[{\"name\":\"5AiWn2U10cw.jpg\",\"link_path\":\"\\/upload\\/training\\/file\\/e081262d33.jpg\",\"size\":\"952.09KB\"}]', '[{\"name\":\"5AiWn2U10cw.jpg\",\"link_path\":\"\\/upload\\/training\\/file\\/ea9df7f6a6.jpg\",\"size\":\"952.09KB\"}]', '1', '1', '2018-05-10 20:49:17');

-- ----------------------------
-- Table structure for `t_training_join`
-- ----------------------------
DROP TABLE IF EXISTS `t_training_join`;
CREATE TABLE `t_training_join` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `training_id` int(10) NOT NULL COMMENT '培训ID',
  `staff_id` int(11) NOT NULL COMMENT '报名人ID',
  `wx_open_id` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '微信openID',
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '报名人名称',
  `join_time` datetime DEFAULT NULL COMMENT '报名时间',
  `sign_time` datetime DEFAULT NULL COMMENT '签到时间',
  PRIMARY KEY (`id`),
  KEY `training_id` (`training_id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='参加培训人员列表';

-- ----------------------------
-- Records of t_training_join
-- ----------------------------
INSERT INTO t_training_join VALUES ('11', '5', '478', null, '柴冬冬', '2018-05-10 20:50:16', null);
INSERT INTO t_training_join VALUES ('10', '4', '1', null, '安宁', '2018-05-10 20:21:14', null);

-- ----------------------------
-- Table structure for `t_training_test`
-- ----------------------------
DROP TABLE IF EXISTS `t_training_test`;
CREATE TABLE `t_training_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `train_id` int(11) DEFAULT NULL COMMENT '培训id',
  `create_staff_id` int(11) DEFAULT NULL COMMENT '创建人id',
  `test_type` tinyint(2) DEFAULT NULL COMMENT '考试类型',
  `duration` datetime DEFAULT NULL COMMENT '考试时长',
  `start_time` datetime DEFAULT NULL COMMENT '考试开始时间',
  `end_time` datetime DEFAULT NULL COMMENT '考试结束时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='培训考试';

-- ----------------------------
-- Records of t_training_test
-- ----------------------------
