# ************************************************************
# Sequel Pro SQL dump
# Version 4541
#
# http://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 192.168.0.11 (MySQL 5.6.37)
# Database: order_new
# Generation Time: 2022-05-23 03:49:40 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table admin_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `admin_user`;

CREATE TABLE `admin_user` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL DEFAULT '' COMMENT '管理员用户名',
  `password` varchar(50) NOT NULL DEFAULT '' COMMENT '管理员密码',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态 1 启用 0 禁用',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `last_login_time` datetime DEFAULT NULL COMMENT '最后登录时间',
  `last_login_ip` varchar(20) DEFAULT NULL COMMENT '最后登录IP',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='管理员表';



# Dump of table app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `app_version`;

CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';



# Dump of table article
# ------------------------------------------------------------

DROP TABLE IF EXISTS `article`;

CREATE TABLE `article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `cid` smallint(5) unsigned NOT NULL COMMENT '分类ID',
  `title` varchar(255) NOT NULL DEFAULT '' COMMENT '标题',
  `introduction` varchar(255) DEFAULT '' COMMENT '简介',
  `content` longtext COMMENT '内容',
  `author` varchar(20) DEFAULT '' COMMENT '作者',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态 0 待审核  1 审核',
  `reading` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '阅读量',
  `thumb` varchar(255) DEFAULT '' COMMENT '缩略图',
  `photo` text COMMENT '图集',
  `is_top` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否置顶  0 不置顶  1 置顶',
  `is_recommend` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否推荐  0 不推荐  1 推荐',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `publish_time` datetime NOT NULL COMMENT '发布时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='文章表';



# Dump of table auth_group
# ------------------------------------------------------------

DROP TABLE IF EXISTS `auth_group`;

CREATE TABLE `auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` char(100) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `rules` varchar(255) DEFAULT NULL COMMENT '权限规则ID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限组表';

LOCK TABLES `auth_group` WRITE;
/*!40000 ALTER TABLE `auth_group` DISABLE KEYS */;

INSERT INTO `auth_group` (`id`, `title`, `status`, `rules`)
VALUES
	(1,'超级管理组',1,'1,2,3,73,74,5,6,7,8,9,10,11,12,39,40,41,42,43,14,13,20,21,22,23,24,15,25,26,27,28,29,30,16,17,44,45,46,47,48,18,49,50,51,52,53,19,31,32,33,34,35,36,37,54,55,58,59,60,61,62,56,63,64,65,66,67,57,68,69,70,71,72');

/*!40000 ALTER TABLE `auth_group` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table auth_group_access
# ------------------------------------------------------------

DROP TABLE IF EXISTS `auth_group_access`;

CREATE TABLE `auth_group_access` (
  `uid` mediumint(8) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`) USING BTREE,
  KEY `uid` (`uid`) USING BTREE,
  KEY `group_id` (`group_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限组规则表';

LOCK TABLES `auth_group_access` WRITE;
/*!40000 ALTER TABLE `auth_group_access` DISABLE KEYS */;

INSERT INTO `auth_group_access` (`uid`, `group_id`)
VALUES
	(1,1);

/*!40000 ALTER TABLE `auth_group_access` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table auth_rule
# ------------------------------------------------------------

DROP TABLE IF EXISTS `auth_rule`;

CREATE TABLE `auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL DEFAULT '' COMMENT '规则名称',
  `title` varchar(20) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `pid` smallint(5) unsigned NOT NULL COMMENT '父级ID',
  `icon` varchar(50) DEFAULT '' COMMENT '图标',
  `sort` tinyint(4) unsigned NOT NULL COMMENT '排序',
  `condition` char(100) DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='规则表';

LOCK TABLES `auth_rule` WRITE;
/*!40000 ALTER TABLE `auth_rule` DISABLE KEYS */;

INSERT INTO `auth_rule` (`id`, `name`, `title`, `type`, `status`, `pid`, `icon`, `sort`, `condition`)
VALUES
	(1,'admin/System/default','系统配置',1,1,0,'fa fa-gears',0,''),
	(2,'admin/System/siteConfig','站点配置',1,0,1,'',0,''),
	(3,'admin/System/updateSiteConfig','更新配置',1,0,1,'',0,''),
	(5,'admin/Menu/default','菜单管理',1,0,0,'fa fa-bars',0,''),
	(6,'admin/Menu/index','后台菜单',1,1,5,'',0,''),
	(7,'admin/Menu/add','添加菜单',1,0,6,'',0,''),
	(8,'admin/Menu/save','保存菜单',1,0,6,'',0,''),
	(9,'admin/Menu/edit','编辑菜单',1,0,6,'',0,''),
	(10,'admin/Menu/update','更新菜单',1,0,6,'',0,''),
	(11,'admin/Menu/delete','删除菜单',1,0,6,'',0,''),
	(12,'admin/Nav/index','导航管理',1,0,5,'',0,''),
	(13,'admin/Category/index','模块管理',1,1,14,'fa fa-sitemap',0,''),
	(14,'admin/Content/default','内容管理',1,0,0,'fa fa-file-text',0,''),
	(15,'admin/Article/index','文章管理',1,1,14,'',0,''),
	(16,'admin/User/default','用户管理',1,0,0,'fa fa-users',0,''),
	(17,'admin/User/index','普通用户',1,1,16,'',0,''),
	(18,'admin/AdminUser/index','管理员',1,1,16,'',0,''),
	(19,'admin/AuthGroup/index','权限组',1,1,16,'',0,''),
	(20,'admin/Category/add','添加栏目',1,0,13,'',0,''),
	(21,'admin/Category/save','保存栏目',1,0,13,'',0,''),
	(22,'admin/Category/edit','编辑栏目',1,0,13,'',0,''),
	(23,'admin/Category/update','更新栏目',1,0,13,'',0,''),
	(24,'admin/Category/delete','删除栏目',1,0,13,'',0,''),
	(25,'admin/Article/add','添加文章',1,0,15,'',0,''),
	(26,'admin/Article/save','保存文章',1,0,15,'',0,''),
	(27,'admin/Article/edit','编辑文章',1,0,15,'',0,''),
	(28,'admin/Article/update','更新文章',1,0,15,'',0,''),
	(29,'admin/Article/delete','删除文章',1,0,15,'',0,''),
	(30,'admin/Article/toggle','文章审核',1,0,15,'',0,''),
	(31,'admin/AuthGroup/add','添加权限组',1,0,19,'',0,''),
	(32,'admin/AuthGroup/save','保存权限组',1,0,19,'',0,''),
	(33,'admin/AuthGroup/edit','编辑权限组',1,0,19,'',0,''),
	(34,'admin/AuthGroup/update','更新权限组',1,0,19,'',0,''),
	(35,'admin/AuthGroup/delete','删除权限组',1,0,19,'',0,''),
	(36,'admin/AuthGroup/auth','授权',1,0,19,'',0,''),
	(37,'admin/AuthGroup/updateAuthGroupRule','更新权限组规则',1,0,19,'',0,''),
	(39,'admin/Nav/add','添加导航',1,0,12,'',0,''),
	(40,'admin/Nav/save','保存导航',1,0,12,'',0,''),
	(41,'admin/Nav/edit','编辑导航',1,0,12,'',0,''),
	(42,'admin/Nav/update','更新导航',1,0,12,'',0,''),
	(43,'admin/Nav/delete','删除导航',1,0,12,'',0,''),
	(44,'admin/User/add','添加用户',1,0,17,'',0,''),
	(45,'admin/User/save','保存用户',1,0,17,'',0,''),
	(46,'admin/User/edit','编辑用户',1,0,17,'',0,''),
	(47,'admin/User/update','更新用户',1,0,17,'',0,''),
	(48,'admin/User/delete','删除用户',1,0,17,'',0,''),
	(49,'admin/AdminUser/add','添加管理员',1,0,18,'',0,''),
	(50,'admin/AdminUser/save','保存管理员',1,0,18,'',0,''),
	(51,'admin/AdminUser/edit','编辑管理员',1,0,18,'',0,''),
	(52,'admin/AdminUser/update','更新管理员',1,0,18,'',0,''),
	(53,'admin/AdminUser/delete','删除管理员',1,0,18,'',0,''),
	(54,'admin/Slide/default','扩展管理',1,0,0,'fa fa-wrench',0,''),
	(55,'admin/SlideCategory/index','轮播分类',1,1,54,'',0,''),
	(56,'admin/Slide/index','轮播图管理',1,1,54,'',0,''),
	(57,'admin/Link/index','友情链接',1,1,54,'fa fa-link',0,''),
	(58,'admin/SlideCategory/add','添加分类',1,0,55,'',0,''),
	(59,'admin/SlideCategory/save','保存分类',1,0,55,'',0,''),
	(60,'admin/SlideCategory/edit','编辑分类',1,0,55,'',0,''),
	(61,'admin/SlideCategory/update','更新分类',1,0,55,'',0,''),
	(62,'admin/SlideCategory/delete','删除分类',1,0,55,'',0,''),
	(63,'admin/Slide/add','添加轮播',1,0,56,'',0,''),
	(64,'admin/Slide/save','保存轮播',1,0,56,'',0,''),
	(65,'admin/Slide/edit','编辑轮播',1,0,56,'',0,''),
	(66,'admin/Slide/update','更新轮播',1,0,56,'',0,''),
	(67,'admin/Slide/delete','删除轮播',1,0,56,'',0,''),
	(68,'admin/Link/add','添加链接',1,0,57,'',0,''),
	(69,'admin/Link/save','保存链接',1,0,57,'',0,''),
	(70,'admin/Link/edit','编辑链接',1,0,57,'',0,''),
	(71,'admin/Link/update','更新链接',1,0,57,'',0,''),
	(72,'admin/Link/delete','删除链接',1,0,57,'',0,''),
	(73,'admin/ChangePassword/index','修改密码',1,0,1,'',0,''),
	(74,'admin/ChangePassword/updatePassword','更新密码',1,0,1,'',0,''),
	(75,'admin/System/bindWeixin','绑定微信',1,0,0,'fa fa-cog',0,''),
	(76,'admin/Template/indexs','浏览内容管理',1,0,0,'fa fa-file-text',0,''),
	(82,'admin/Cate/cate','栏目管理',1,0,76,'',0,''),
	(81,'admin/Template/index','页面管理',1,0,76,'',0,''),
	(83,'admin/show/index','展示管理',1,1,76,'',0,''),
	(84,'admin/Templatesx/default','模板管理',1,1,0,'fa fa-tasks',12,''),
	(85,'admin/Pageinfo/default','页面管理',1,1,0,'fa fa-image',11,''),
	(87,'admin/Templatesx/index','模板列表',1,1,84,'fa fa-sitemap',0,''),
	(88,'admin/Templatesx/addTemplate','新增模板',1,1,87,'',0,''),
	(89,'admin/Templatesx/editTemplate','编辑模板',1,1,87,'',0,''),
	(90,'admin/Templatesx/delTemplate','删除模板',1,1,87,'',0,''),
	(91,'admin/Pageinfo/index','页面列表',1,1,85,'',0,''),
	(92,'admin/Pageinfo/addPage','新增页面',1,1,91,'',0,''),
	(93,'admin/Pageinfo/editPage','编辑页面',1,1,91,'',0,''),
	(94,'admin/Pageinfo/delPage','删除页面',1,1,91,'',0,''),
	(99,'admin/webcontent/index','网站内容管理',1,0,0,'',0,''),
	(95,'admin/Resource/index','资源管理',1,1,85,'',0,''),
	(96,'admin/Resource/add','新增资源',1,1,95,'',0,''),
	(97,'admin/Resource/del','删除资源',1,1,95,'',0,''),
	(98,'admin/Resource/edit','编辑资源',1,1,95,'',0,''),
	(100,'admin/system/acl','访问控制',1,1,1,'',0,''),
	(101,'admin/state/index','打包管理',1,1,1,'',0,'');

/*!40000 ALTER TABLE `auth_rule` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table c_sysconfig
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_sysconfig`;

CREATE TABLE `c_sysconfig` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci NOT NULL COMMENT '配置KEY，系统写死',
  `cvalue` text COLLATE utf8_unicode_ci COMMENT '配置内容，存JSON数据',
  PRIMARY KEY (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='相关的配置参数。';

LOCK TABLES `c_sysconfig` WRITE;
/*!40000 ALTER TABLE `c_sysconfig` DISABLE KEYS */;

INSERT INTO `c_sysconfig` (`ckey`, `cvalue`)
VALUES
	('acl','0');

/*!40000 ALTER TABLE `c_sysconfig` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table cate
# ------------------------------------------------------------

DROP TABLE IF EXISTS `cate`;

CREATE TABLE `cate` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL COMMENT '类别名称',
  `createtime` datetime DEFAULT NULL,
  `updatetime` datetime DEFAULT NULL,
  `sort` varchar(255) DEFAULT NULL COMMENT '排序',
  `class_name` varchar(255) DEFAULT NULL COMMENT '英文名字',
  `status` varchar(255) DEFAULT NULL,
  `brandid` int(10) DEFAULT '0' COMMENT '事业部',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table category
# ------------------------------------------------------------

DROP TABLE IF EXISTS `category`;

CREATE TABLE `category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(50) NOT NULL COMMENT '分类名称',
  `alias` varchar(50) DEFAULT '' COMMENT '导航别名',
  `content` longtext COMMENT '分类内容',
  `thumb` varchar(255) DEFAULT '' COMMENT '缩略图',
  `icon` varchar(20) DEFAULT '' COMMENT '分类图标',
  `list_template` varchar(50) DEFAULT '' COMMENT '分类列表模板',
  `detail_template` varchar(50) DEFAULT '' COMMENT '分类详情模板',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '分类类型  1  列表  2 单页',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '上级分类ID',
  `path` varchar(255) DEFAULT '' COMMENT '路径',
  `create_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='分类表';



# Dump of table customerinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `customerinfo`;

CREATE TABLE `customerinfo` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '进店客资表',
  `name` varchar(255) DEFAULT NULL COMMENT '客户姓名',
  `phone` varchar(255) DEFAULT NULL COMMENT '客户手机号',
  `create_time` datetime DEFAULT NULL COMMENT '进店时间',
  `session_id` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table link
# ------------------------------------------------------------

DROP TABLE IF EXISTS `link`;

CREATE TABLE `link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '' COMMENT '链接名称',
  `link` varchar(255) DEFAULT '' COMMENT '链接地址',
  `image` varchar(255) DEFAULT '' COMMENT '链接图片',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态 1 显示  2 隐藏',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='友情链接表';



# Dump of table login_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `login_log`;

CREATE TABLE `login_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `last_login_time` datetime DEFAULT NULL,
  `last_login_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `login_log` WRITE;
/*!40000 ALTER TABLE `login_log` DISABLE KEYS */;

INSERT INTO `login_log` (`id`, `staff_id`, `staff_name`, `create_time`, `last_login_time`, `last_login_ip`)
VALUES
	(1,3000,'测试001',NULL,'2022-05-23 09:08:10','192.168.2.1');

/*!40000 ALTER TABLE `login_log` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table nav
# ------------------------------------------------------------

DROP TABLE IF EXISTS `nav`;

CREATE TABLE `nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL COMMENT '父ID',
  `name` varchar(20) NOT NULL COMMENT '导航名称',
  `alias` varchar(20) DEFAULT '' COMMENT '导航别称',
  `link` varchar(255) DEFAULT '' COMMENT '导航链接',
  `icon` varchar(255) DEFAULT '' COMMENT '导航图标',
  `target` varchar(10) DEFAULT '' COMMENT '打开方式',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态  0 隐藏  1 显示',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='导航表';



# Dump of table position_group_access
# ------------------------------------------------------------

DROP TABLE IF EXISTS `position_group_access`;

CREATE TABLE `position_group_access` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '岗位code',
  `group_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '权限组id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table process
# ------------------------------------------------------------

DROP TABLE IF EXISTS `process`;

CREATE TABLE `process` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brandid` int(11) DEFAULT NULL,
  `sort` int(11) DEFAULT NULL,
  `template_code` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `status` tinyint(2) DEFAULT NULL,
  `staff_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '添加者',
  `cateid` int(11) DEFAULT NULL COMMENT '类别',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



# Dump of table process_img
# ------------------------------------------------------------

DROP TABLE IF EXISTS `process_img`;

CREATE TABLE `process_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `process_id` int(11) DEFAULT NULL COMMENT '预览流程id',
  `img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '图片地址',
  `img_type` tinyint(2) DEFAULT NULL COMMENT '图片类型，1标题图，2内容图',
  `site` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '单层（图标记）',
  `brandid` int(11) DEFAULT NULL COMMENT '事业部id',
  `create_time` datetime DEFAULT NULL,
  `site_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '双层图id',
  `son_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '第二层 属于的id',
  `status` tinyint(2) DEFAULT NULL COMMENT '是否使用（1是0否）',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_acl_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acl_list`;

CREATE TABLE `s_acl_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `memo` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `add_type` tinyint(1) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_user_id` int(11) DEFAULT NULL,
  `create_user_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_acl_token
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acl_token`;

CREATE TABLE `s_acl_token` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `memo` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `create_ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_user_id` int(11) DEFAULT NULL,
  `create_user_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_acl_token_logs
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_acl_token_logs`;

CREATE TABLE `s_acl_token_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `ip` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `result` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_img
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_img`;

CREATE TABLE `s_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) DEFAULT NULL COMMENT '预览流程id',
  `img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '图片地址',
  `img_type` tinyint(2) DEFAULT NULL COMMENT '图片类型，1标题图，2内容图',
  `site` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '单层（图标记）',
  `brandid` int(11) DEFAULT NULL COMMENT '事业部id',
  `create_time` datetime DEFAULT NULL,
  `site_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '双层图id',
  `son_id` varchar(20) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '第二层 属于的id',
  `cate_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_menu`;

CREATE TABLE `s_menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `menu_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `fid` int(11) DEFAULT '0',
  `menu_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_url` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `menu_icon` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `status` tinyint(1) DEFAULT '1',
  `sort` int(11) DEFAULT '0',
  `title_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '类别图',
  `cont_img` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '内容图',
  `video` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '视频',
  `brandid` int(10) DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '类型（1首页 2 一级分类3二级或多级分类4视频下边的分类5内外景 6 中国/世界）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_menu` WRITE;
/*!40000 ALTER TABLE `s_menu` DISABLE KEYS */;

INSERT INTO `s_menu` (`id`, `menu_name`, `fid`, `menu_code`, `menu_url`, `menu_icon`, `status`, `sort`, `title_img`, `cont_img`, `video`, `brandid`, `type`)
VALUES
	(1,'首页',0,'','','',1,0,'',NULL,NULL,1,'1'),
	(2,'当季新品',0,'','','',1,0,'',NULL,NULL,1,'2'),
	(3,'双影像视频',0,'','','',1,0,'',NULL,NULL,1,'3'),
	(4,'去哪儿拍',0,'','','',1,0,'',NULL,NULL,1,'3'),
	(5,'选择时尚经典',0,'','','',1,0,'',NULL,NULL,1,'2'),
	(6,'婚嫁服务',0,'','','',1,0,'',NULL,NULL,1,'2'),
	(7,'静态微电影',3,'','','',1,0,'',NULL,NULL,1,'4'),
	(8,'MV微电影',3,'','','',1,0,'',NULL,NULL,1,'4'),
	(9,'定制微电影',3,'','','',1,0,'',NULL,NULL,1,'4'),
	(10,'一日策划拍',3,'','','',1,0,'',NULL,NULL,1,'4'),
	(11,'创作拍摄花絮',3,'','','',1,0,'',NULL,NULL,1,'4'),
	(12,'影·享沈阳--内景基地',4,'','','',1,0,'',NULL,NULL,1,'5'),
	(13,'影·享沈阳--外景基地',4,'','','',1,0,'',NULL,NULL,1,'5'),
	(14,'影·享中国',4,'','','',1,0,'',NULL,NULL,1,'6'),
	(15,'影·享世界',4,'','','',1,0,NULL,NULL,NULL,1,'6'),
	(16,'客片大赏',12,'','','',1,0,'','','',1,'0'),
	(17,'样片展示',12,'','','',1,0,'','','',1,'0'),
	(18,'客样对比',12,'','','',1,0,'','','',1,'0'),
	(19,'预定套餐',12,'','','',1,0,'','','',1,'0'),
	(20,'名品礼服',12,'','','',1,0,'','','',1,'0'),
	(21,'客片大赏',13,'','','',1,0,'','','',1,'0'),
	(22,'样片展示',13,'','','',1,0,'','','',1,'0'),
	(23,'客样对比',13,'','','',1,0,'','','',1,'0'),
	(24,'预定套餐',13,'','','',1,0,'','','',1,'0'),
	(25,'名品礼服',13,'','','',1,0,'','','',1,'0'),
	(26,'客片大赏',14,'','','',1,0,'','','',1,'0'),
	(27,'样片展示',14,'','','',1,0,'','','',1,'0'),
	(28,'客样对比',14,'','','',1,0,'','','',1,'0'),
	(29,'预定套餐',14,'','','',1,0,'','','',1,'0'),
	(30,'基地介绍',14,'','','',1,0,'','','',1,'0'),
	(31,'作品赏析',15,'','','',1,0,'','','',1,'0'),
	(32,'预订套餐',15,'','','',1,0,'','','',1,'0'),
	(33,'享沈阳',19,'','','',1,0,'','','',1,'0'),
	(37,'享沈阳',24,'','','',1,0,'','','',1,'0'),
	(41,'三亚湾',26,'','','',1,0,'','','',1,'0'),
	(42,'小东海',26,'','','',1,0,'','','',1,'0'),
	(43,'凤凰岛',26,'','','',1,0,'','','',1,'0'),
	(44,'清水湾',26,'','','',1,0,'','','',1,'0'),
	(45,'亚龙湾',26,'','','',1,0,'','','',1,'0'),
	(46,'大小洞天',26,'','','',1,0,'','','',1,'0'),
	(47,'亚龙湾爱立方海岸',26,'','','',1,0,'','','',1,'0'),
	(48,'分界洲岛',26,'','','',1,0,'','','',1,'0'),
	(49,'内景',26,'','','',1,0,'','','',1,'0'),
	(50,'小东海',27,'','','',1,0,'','','',1,'0'),
	(51,'凤凰岛',27,'','','',1,0,'','','',1,'0'),
	(52,'清水湾',27,'','','',1,0,'','','',1,'0'),
	(53,'亚龙湾',27,'','','',1,0,'','','',1,'0'),
	(54,'大小洞天',27,'','','',1,0,'','','',1,'0'),
	(55,'分界洲岛',27,'','','',1,0,'','','',1,'0'),
	(56,'亚龙湾爱立方海岸',27,'','','',1,0,'','','',1,'0'),
	(57,'韩式内景',27,'','','',1,0,'','','',1,'0'),
	(58,'享中国',28,'','','',1,0,'','','',1,'0'),
	(62,'享世界',29,'','','',1,0,'','','',1,'0'),
	(66,'亨杭州',30,'','','',1,0,'','','',1,'0'),
	(67,'家庭纪念套餐',30,'','','',1,0,'','','',1,'0'),
	(68,'双成拍',30,'','','',1,0,'','','',1,'0'),
	(69,'精致旅拍',30,'','','',1,0,'','','',1,'0'),
	(70,'亨杭州',32,'','','',1,0,'','','',1,'0'),
	(71,'家庭纪念套餐',32,'','','',1,0,'','','',1,'0'),
	(72,'双成拍',32,'','','',1,0,'','','',1,'0'),
	(73,'精致旅拍',32,'','','',1,0,'','','',1,'0'),
	(74,'三亚湾',27,'','','',1,0,'','','',1,'0');

/*!40000 ALTER TABLE `s_menu` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_session
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_session`;

CREATE TABLE `s_session` (
  `staff_id` int(11) NOT NULL,
  `session_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `ip` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `login_type` varchar(20) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录类型',
  `login_method` varchar(30) COLLATE utf8_unicode_ci NOT NULL COMMENT '登录方式',
  `logout_time` datetime DEFAULT NULL COMMENT '退出登录时间',
  `expiry` datetime NOT NULL COMMENT 'session过期时间',
  `status` tinyint(4) DEFAULT '1' COMMENT '登录状态:1:正常，2：忙碌;3:离线'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='crm session表';

LOCK TABLES `s_session` WRITE;
/*!40000 ALTER TABLE `s_session` DISABLE KEYS */;

INSERT INTO `s_session` (`staff_id`, `session_id`, `ip`, `login_type`, `login_method`, `logout_time`, `expiry`, `status`)
VALUES
	(3000,'DLMJByfKgd','192.168.0.10','pc','user_name',NULL,'2022-05-21 11:42:50',1),
	(404,'XjAlYEVTMm','192.168.0.10','pc','user_name',NULL,'2022-05-17 10:49:19',1);

/*!40000 ALTER TABLE `s_session` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table s_test2
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_test2`;

CREATE TABLE `s_test2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `key1` (`field_1`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table s_test3
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_test3`;

CREATE TABLE `s_test3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field_1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `key1` (`field_1`,`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table slide
# ------------------------------------------------------------

DROP TABLE IF EXISTS `slide`;

CREATE TABLE `slide` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned NOT NULL COMMENT '分类ID',
  `name` varchar(50) NOT NULL COMMENT '轮播图名称',
  `description` varchar(255) DEFAULT '' COMMENT '说明',
  `link` varchar(255) DEFAULT '' COMMENT '链接',
  `target` varchar(10) DEFAULT '' COMMENT '打开方式',
  `image` varchar(255) DEFAULT '' COMMENT '轮播图片',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态  1 显示  0  隐藏',
  `sort` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='轮播图表';



# Dump of table slide_category
# ------------------------------------------------------------

DROP TABLE IF EXISTS `slide_category`;

CREATE TABLE `slide_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '轮播图分类',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='轮播图分类表';



# Dump of table sx_data_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sx_data_version`;

CREATE TABLE `sx_data_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `data_version` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `staff_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `download_url` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `all_file_num` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '需要打包的文件总数',
  `done_file_num` int(11) DEFAULT '0' COMMENT '已打包文件数量',
  PRIMARY KEY (`id`),
  UNIQUE KEY `download_url` (`download_url`),
  UNIQUE KEY `data_version` (`data_version`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='生成数据包列表';



# Dump of table sx_pageinfo
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sx_pageinfo`;

CREATE TABLE `sx_pageinfo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '页面ID',
  `title` varchar(200) COLLATE utf8_unicode_ci DEFAULT '1' COMMENT '资源名称',
  `title_en` varchar(200) COLLATE utf8_unicode_ci DEFAULT '1' COMMENT '标题英文',
  `tid` int(11) DEFAULT NULL COMMENT '模板id',
  `pid` int(11) DEFAULT '0' COMMENT '上级页面id（首页上级页面id为1）',
  `pname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上级页面名字',
  `rid` int(11) DEFAULT NULL COMMENT '上级资源id，即从哪个资源来的',
  `resource_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上级资源名称',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `shop_code` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `hierarchical` tinyint(1) DEFAULT '1' COMMENT '层级结构',
  `hierarchical_in` tinyint(1) DEFAULT '0' COMMENT '当前层级',
  `is_del` tinyint(4) DEFAULT '1' COMMENT '是否删除（1：未删除；2：已删除）',
  `is_show` tinyint(4) DEFAULT '1' COMMENT '是否显示（1：显示；2：不显示）',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sort` (`sort`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE,
  KEY `rid` (`rid`) USING BTREE,
  KEY `tid` (`tid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='页面表';

LOCK TABLES `sx_pageinfo` WRITE;
/*!40000 ALTER TABLE `sx_pageinfo` DISABLE KEYS */;

INSERT INTO `sx_pageinfo` (`id`, `title`, `title_en`, `tid`, `pid`, `pname`, `rid`, `resource_name`, `sort`, `shop_code`, `shop_name`, `brandclass_id`, `hierarchical`, `hierarchical_in`, `is_del`, `is_show`, `create_time`, `update_time`)
VALUES
	(1,'登录页','1',0,0,NULL,0,NULL,1,NULL,NULL,1,1,0,1,1,'2022-04-06 11:18:54','2022-04-20 17:01:48'),
	(2,'网站首页','1',0,0,NULL,0,NULL,2,NULL,NULL,1,1,0,1,1,'2022-04-06 11:41:50',NULL),
	(3,'热销套系','Hot-selling system',5,0,'',0,'',1,'','',1,2,0,1,1,'2022-04-06 11:41:50','2022-05-23 09:06:53'),
	(4,'全球旅拍1','GLOBAL TRAVEL PHOTOG',14,0,'',0,'',2,'','',1,2,0,1,1,'2022-04-06 11:41:50','2022-05-17 17:16:36'),
	(5,'艺术影像','1',2,0,'',0,'',2,'','',1,2,0,1,1,'2022-04-06 11:41:50','2022-05-17 17:48:07'),
	(6,'原创样片','Original sample',5,0,'',0,'',1,'','',1,2,0,1,1,'2022-04-06 11:41:50','2022-05-18 16:25:37'),
	(7,'客片大赏','GUEST FILM REWARD',3,0,'',0,'',3,'','',1,3,0,1,1,'2022-04-06 11:41:50','2022-04-24 16:47:41'),
	(8,'品牌介绍','1',1,0,'',0,'',4,'','',1,2,0,1,1,'2022-04-06 11:41:50',NULL),
	(9,'其他','qita',10,0,'',0,'',5,'','',1,1,0,2,1,'2022-04-06 11:41:50','2022-05-16 13:54:17'),
	(14,'幻境','Dreamland',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-21 15:38:05','2022-05-16 15:18:00'),
	(15,'青奢韩系','LIGHT LUXURY KOREAN',NULL,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,1,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16'),
	(16,'青奢韩系','LIGHT LUXURY KOREAN',7,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,1,1,1,'2022-04-22 15:24:27','2022-04-22 17:17:50'),
	(17,'青奢韩系','LIGHT LUXURY KOREAN',1,7,'',NULL,'',NULL,'','',NULL,3,1,1,1,'2022-04-22 14:17:18','2022-05-17 09:30:24'),
	(18,'青奢韩系','LIGHT LUXURY KOREAN',NULL,7,'',NULL,'',NULL,'','',NULL,3,1,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16'),
	(19,'青奢韩系','LIGHT LUXURY KOREAN',NULL,7,'',NULL,'',NULL,'','',NULL,3,1,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16'),
	(20,'青奢韩系','LIGHT LUXURY KOREAN',NULL,7,'',NULL,'',NULL,'','',NULL,3,1,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16'),
	(21,'青奢韩系','LIGHT LUXURY KOREAN',NULL,7,'',NULL,'',NULL,'','',NULL,3,1,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16'),
	(22,'青奢韩系','LIGHT LUXURY KOREAN',NULL,7,'',NULL,'',NULL,'','',NULL,3,1,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16'),
	(23,'轻奢韩系','Light luxury Korean',8,16,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,2,1,1,'2022-04-22 17:18:36','2022-04-22 17:33:36'),
	(24,'1','1',4,23,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,3,1,1,'2022-04-22 17:33:47','2022-04-24 15:05:21'),
	(26,'城市旅拍','URBAN TOUP SHOT',5,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-24 15:08:26','2022-05-16 16:20:44'),
	(30,'雅致唯美','LIGHT LUXURY KOREAN',1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-24 17:17:38','2022-05-17 17:12:25'),
	(31,'光影棚拍','LIGHT LUXURY KOREAN',8,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-24 17:34:47','2022-05-17 16:45:00'),
	(32,'仪式片场','URBAN TOUP SHOT',NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-24 17:50:13',NULL),
	(33,'独家基地','LIGHT LUXURY KOREAN',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-24 18:01:34',NULL),
	(34,'2','2342',NULL,8,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-25 10:31:03',NULL),
	(35,'全球1','GUEST FILM REWARD',NULL,4,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-26 13:43:21','2022-05-06 19:19:53'),
	(36,'素锦年华1','Plain brocade youth',7,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-26 13:47:36','2022-05-23 10:52:23'),
	(37,'123123','123123',7,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-26 13:57:19','2022-05-17 11:14:00'),
	(38,'轻奢韩系','Light luxury Korean',8,16,'',NULL,'',NULL,'','',NULL,3,2,1,1,'2022-04-22 17:18:36','2022-04-22 17:33:36'),
	(39,'光影棚拍','LIGHT LUXURY KOREAN',8,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-04-26 15:38:18','2022-05-16 10:55:38'),
	(40,'大片抢先看','你看我也看，大家一起看1',2,0,NULL,NULL,NULL,0,NULL,NULL,NULL,4,0,2,1,'2022-04-29 17:04:37','2022-05-11 10:39:13'),
	(41,'112','11',2,40,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-06 15:58:09','2022-05-06 20:02:52'),
	(42,'222','22',2,41,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-06 15:58:32','2022-05-06 20:03:12'),
	(43,'33','33',2,42,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,3,1,1,'2022-05-06 15:58:47','2022-05-06 16:00:16'),
	(44,'44','44',NULL,43,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,4,1,1,'2022-05-06 16:00:33',NULL),
	(45,'121','212',10,38,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,3,1,1,'2022-05-11 11:46:12',NULL),
	(46,'22','222',10,38,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,3,1,1,'2022-05-11 16:56:30',NULL),
	(47,'33','33',10,38,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,3,1,1,'2022-05-11 17:03:17',NULL),
	(48,'11','11',10,0,NULL,NULL,NULL,0,NULL,NULL,NULL,1,0,2,1,'2022-05-11 17:40:52','2022-05-11 17:43:31'),
	(49,'111','111',12,0,NULL,NULL,NULL,111,NULL,NULL,NULL,1,0,2,1,'2022-05-11 17:43:39','2022-05-12 11:00:03'),
	(50,'影像1','影像1',4,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-12 11:28:23',NULL),
	(51,'影像2','影像2',4,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-12 11:29:01',NULL),
	(52,'影像3','影像3',4,5,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-12 11:37:30',NULL),
	(53,'2','1',4,0,NULL,NULL,NULL,12,NULL,NULL,NULL,2,0,2,1,'2022-05-12 11:41:01','2022-05-12 11:41:12'),
	(54,'时尚印象','时尚印象',10,50,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-12 11:42:30','2022-05-12 11:45:07'),
	(55,'城市漫游记','城市漫游记',12,51,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-12 11:45:43','2022-05-12 11:45:59'),
	(56,'测试','test',4,0,NULL,NULL,NULL,0,NULL,NULL,NULL,2,0,2,1,'2022-05-13 10:21:02','2022-05-13 10:21:18'),
	(59,'2h5g-1','2h5g-1',12,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-13 10:57:27','2022-05-18 13:38:24'),
	(60,'2h5g-2','2h5g-2',15,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-13 10:57:37','2022-05-20 16:18:21'),
	(61,'2h5g-3','2h5g-3',10,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-13 10:57:47',NULL),
	(62,'2h5g-4','2h5g-4',10,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-13 10:57:58',NULL),
	(63,'2h5g-5','2h5g-5',10,36,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-13 10:58:08','2022-05-16 11:50:08'),
	(64,'最新活动','Latest activities',6,0,NULL,NULL,NULL,1,NULL,NULL,NULL,4,0,1,1,'2022-05-16 11:00:42','2022-05-20 11:12:46'),
	(65,'雄一级','one',4,0,NULL,NULL,NULL,1,NULL,NULL,NULL,4,0,2,1,'2022-05-16 11:02:10','2022-05-16 11:03:13'),
	(66,'11','11',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:04:36','2022-05-16 11:45:15'),
	(68,'21','21',4,66,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:05:29','2022-05-16 11:45:26'),
	(69,'雄三级分类','three',4,68,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,3,1,1,'2022-05-16 11:06:08',NULL),
	(70,'雄四级分类','four',12,69,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,4,1,1,'2022-05-16 11:06:27','2022-05-16 15:16:48'),
	(71,'22','22',4,66,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:09:10','2022-05-16 11:45:48'),
	(72,'尤世超','miss you',14,0,NULL,NULL,NULL,4,NULL,NULL,NULL,2,0,1,1,'2022-05-16 11:09:48','2022-05-18 16:25:50'),
	(73,'世超婚礼纪','Wedding rules',4,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-16 11:24:19','2022-05-16 11:24:41'),
	(74,'石立恒','DavidSlh',10,0,NULL,NULL,NULL,1,NULL,NULL,NULL,1,0,2,1,'2022-05-16 11:24:57','2022-05-16 11:29:45'),
	(75,'石立恒','love',6,0,NULL,NULL,NULL,2,NULL,NULL,NULL,4,0,2,1,'2022-05-16 11:30:08','2022-05-17 09:24:46'),
	(76,'邀请嘉宾','Invited guests',10,73,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-16 11:32:34','2022-05-16 11:49:02'),
	(78,'1231','123',4,0,NULL,NULL,NULL,9,NULL,NULL,NULL,2,0,2,1,'2022-05-16 11:34:49','2022-05-16 11:35:38'),
	(80,'123','123',10,79,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-16 11:35:14',NULL),
	(81,'12','12',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:36:49',NULL),
	(82,'13','13',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:37:01','2022-05-16 11:41:51'),
	(83,'14','14',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:37:10',NULL),
	(84,'15','15',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:37:19','2022-05-16 11:38:25'),
	(85,'16','16',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:37:33','2022-05-16 11:42:01'),
	(86,'17','17',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:37:51',NULL),
	(87,'18','18',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:38:39',NULL),
	(88,'19','19',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:38:50','2022-05-16 11:42:11'),
	(89,'120','120',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:39:00','2022-05-16 11:39:40'),
	(90,'121','121',4,64,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,1,1,1,'2022-05-16 11:39:53',NULL),
	(92,'23','23',4,66,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:45:41',NULL),
	(93,'24','24',4,66,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:45:55',NULL),
	(94,'25','25',4,66,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:46:05',NULL),
	(95,'26','26',4,66,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:46:13',NULL),
	(97,'游戏主题','Game theme',10,73,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-16 11:56:32',NULL),
	(100,'4','4',4,96,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:59:01',NULL),
	(101,'5','5',4,96,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 11:59:14',NULL),
	(102,'理想','one',2,72,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-16 12:02:29','2022-05-16 12:10:54'),
	(103,'6','6',4,96,NULL,NULL,NULL,NULL,NULL,NULL,NULL,4,2,1,1,'2022-05-16 12:02:52',NULL),
	(104,'现实','two',4,72,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-16 12:03:48',NULL),
	(107,'暴富','Get Rich Quick',11,102,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-16 12:12:31','2022-05-16 12:21:57'),
	(108,'暴瘦','Emaciated',10,102,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-16 12:13:40',NULL),
	(109,'中国新娘','Chinese bride',1,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-16 15:37:14','2022-05-16 15:37:40'),
	(110,'123','456',10,14,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-17 09:22:34',NULL),
	(111,'品牌MV','V',12,0,NULL,NULL,NULL,8,NULL,NULL,NULL,1,0,2,1,'2022-05-17 09:25:30','2022-05-17 09:32:18'),
	(112,'12','1221',1,17,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,2,1,1,'2022-05-17 09:30:43',NULL),
	(113,'2222','2222',10,0,NULL,NULL,NULL,9,NULL,NULL,NULL,1,0,2,1,'2022-05-17 09:44:55','2022-05-17 09:45:17'),
	(114,'骑士','qishi',10,31,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-17 10:09:23',NULL),
	(115,'1263','23',2,72,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-17 17:28:00',NULL),
	(116,'123','23123',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-17 18:54:04',NULL),
	(117,'435','231',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-17 18:54:20',NULL),
	(118,'78hgfg','45',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 09:55:49',NULL),
	(119,'er','dfas',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 09:56:17',NULL),
	(120,'ghfsdfg','dfgsa',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 09:56:31',NULL),
	(121,'er','wer',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 09:56:49',NULL),
	(122,'4523','23',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:28:35',NULL),
	(123,'452346','63456',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:28:51',NULL),
	(124,' 大','发啊',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:29:06',NULL),
	(125,'43523','4534',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:29:23',NULL),
	(126,'34123','452',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:29:35',NULL),
	(127,'大','打算',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:29:51',NULL),
	(128,'dfasf','dfasfd',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:37:54',NULL),
	(129,'fgs','34fg',1,3,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 10:38:11',NULL),
	(130,'微擎','微擎',10,104,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-18 16:25:07',NULL),
	(131,'2312','231',10,26,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-18 16:26:27',NULL),
	(132,'一级内容页','111',10,0,NULL,NULL,NULL,0,NULL,NULL,NULL,1,0,1,1,'2022-05-18 16:28:11','2022-05-19 02:54:22'),
	(133,'一级分类++二级','一级分类++二级',4,0,NULL,NULL,NULL,0,NULL,NULL,NULL,2,0,2,1,'2022-05-18 16:29:18','2022-05-19 02:53:48'),
	(134,'一级分类++二级','一级分类++二级',4,133,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,1,1,'2022-05-18 16:29:40',NULL),
	(135,'2312','23123',10,134,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-18 16:31:04',NULL),
	(137,'测试','test',4,0,NULL,NULL,NULL,111,NULL,NULL,NULL,2,1,2,1,'2022-05-18 16:54:33','2022-05-19 02:54:04'),
	(138,'123','123',10,137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,2,1,1,'2022-05-18 16:54:57',NULL),
	(139,'测试二','1223121',4,0,NULL,NULL,NULL,122,NULL,NULL,NULL,3,1,2,1,'2022-05-18 16:55:50','2022-05-19 02:53:58'),
	(140,'123','321',4,139,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,2,1,1,'2022-05-18 16:56:00',NULL),
	(141,'2131','123',10,140,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,3,1,1,'2022-05-18 16:56:12',NULL),
	(142,'','',10,36,NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,1,1,'2022-05-23 10:25:15',NULL),
	(143,'123','123',10,36,NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,1,1,'2022-05-23 10:25:15','2022-05-23 10:22:56'),
	(144,'','',10,36,NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,1,1,'2022-05-23 10:25:15',NULL),
	(145,'','',10,36,NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,1,1,'2022-05-23 11:04:06',NULL),
	(146,'','',10,36,NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,1,1,'2022-05-23 11:04:06',NULL),
	(147,'','',10,36,NULL,NULL,NULL,0,NULL,NULL,NULL,2,2,1,1,'2022-05-23 11:04:06',NULL),
	(148,'','',4,64,NULL,NULL,NULL,0,NULL,NULL,NULL,4,1,1,1,'2022-05-23 11:36:29',NULL),
	(149,'','',4,64,NULL,NULL,NULL,0,NULL,NULL,NULL,4,1,1,1,'2022-05-23 11:36:29',NULL),
	(150,'','',4,64,NULL,NULL,NULL,0,NULL,NULL,NULL,4,1,1,1,'2022-05-23 11:36:29',NULL);

/*!40000 ALTER TABLE `sx_pageinfo` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table sx_resource
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sx_resource`;

CREATE TABLE `sx_resource` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(11) DEFAULT NULL COMMENT '所属页面id（pageinfo主键id）',
  `file_type` tinyint(4) DEFAULT '1' COMMENT '上传文件类型（1：图片；2：视频）',
  `rname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '资源名称',
  `alias` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '资源别名',
  `content` text COLLATE utf8_unicode_ci COMMENT '说明文字',
  `icon` varchar(200) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '资源图标',
  `up1` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '具体资源（图片或者是视频）',
  `up2` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '具体资源二（视频封面）',
  `pid` int(11) unsigned DEFAULT '0' COMMENT '上级资源ID',
  `pname` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '上级资源名称',
  `sort` smallint(5) unsigned DEFAULT '0' COMMENT '排序',
  `skip` int(11) DEFAULT '2' COMMENT '是否跳转（1：是；2：否），默认2；',
  `shop_code` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `shop_name` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `brandclass_id` int(11) DEFAULT NULL,
  `is_del` tinyint(4) DEFAULT '1' COMMENT '是否删除（1：未删除；2：已删除）',
  `is_show` tinyint(4) DEFAULT '1' COMMENT '是否显示（1：显示；2：不显示）',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  `swipernum` int(11) DEFAULT NULL,
  `label` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标签',
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`) USING BTREE,
  KEY `pid` (`pid`) USING BTREE,
  KEY `sort` (`sort`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='资源表';

LOCK TABLES `sx_resource` WRITE;
/*!40000 ALTER TABLE `sx_resource` DISABLE KEYS */;

INSERT INTO `sx_resource` (`id`, `page_id`, `file_type`, `rname`, `alias`, `content`, `icon`, `up1`, `up2`, `pid`, `pname`, `sort`, `skip`, `shop_code`, `shop_name`, `brandclass_id`, `is_del`, `is_show`, `create_time`, `update_time`, `swipernum`, `label`)
VALUES
	(1,1,1,'11','11','111','','/uploads/1/20220516/5bddb09949b039b64a96ab20f3abcdc9.png','/uploads/1/20220516/a2354911722c5fbe20766fb9b9d2dc7d.png',0,NULL,1,2,NULL,NULL,1,1,1,'2022-04-06 11:42:35','2022-05-16 15:28:03',NULL,NULL),
	(2,2,1,'111','11','11','','','/uploads/2/20220523/fcd4629896cc8d538e2041c32e6726ee.jpg',0,NULL,2,2,NULL,NULL,1,1,1,'2022-04-06 11:43:13','2022-05-23 11:37:47',NULL,NULL),
	(4,14,1,'','','','','/uploads/2/20220516/b23269087ad3f3a44b6b27cec68dd37e.jpg','',0,'',5,2,'','',NULL,1,1,'2022-04-21 14:18:58','2022-05-16 15:01:33',NULL,NULL),
	(5,15,1,NULL,NULL,NULL,'','/uploads/2/20220422/c6e8363f91572ec08d48ee78e45d42fb.jpg',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16',NULL,NULL),
	(6,16,1,NULL,NULL,NULL,'','/uploads/2/20220422/3141604c576c7112a5162da3400b614e.png',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16',NULL,NULL),
	(7,17,1,'','','','','/uploads/2/20220422/c6e8363f91572ec08d48ee78e45d42fb.jpg','',0,'',1,2,'','',NULL,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16',NULL,NULL),
	(8,18,1,'','','','','/uploads/2/20220422/3141604c576c7112a5162da3400b614e.png','',0,'',4,2,'','',NULL,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16',NULL,NULL),
	(9,19,1,'','','','','/uploads/2/20220422/c6e8363f91572ec08d48ee78e45d42fb.jpg','',0,'',5,2,'','',NULL,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16',NULL,NULL),
	(10,20,1,'','','','','/uploads/2/20220422/3141604c576c7112a5162da3400b614e.png','',0,'',7,2,'','',NULL,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16',NULL,NULL),
	(11,21,1,'','','','','/uploads/2/20220422/c6e8363f91572ec08d48ee78e45d42fb.jpg','',0,'',6,2,'','',NULL,1,1,'2022-04-22 14:17:18','2022-04-22 15:35:16',NULL,NULL),
	(12,22,1,'','','','','/uploads/2/20220422/3141604c576c7112a5162da3400b614e.png','',0,'',8,2,'','',NULL,1,1,'2022-04-22 15:24:27','2022-04-22 15:35:16',NULL,NULL),
	(13,23,1,NULL,NULL,NULL,'','/uploads/2/20220422/ca257189317e60144828c27f2a6c340b.png',NULL,0,NULL,13,2,NULL,NULL,NULL,1,1,'2022-04-22 17:18:36','2022-04-22 17:22:54',NULL,NULL),
	(14,24,1,NULL,NULL,NULL,'','/uploads/2/20220422/6e2cdf762fcc3efb139a0f933cf9581f.jpg',NULL,0,NULL,14,2,NULL,NULL,NULL,1,1,'2022-04-22 17:33:47',NULL,NULL,NULL),
	(15,25,1,NULL,NULL,NULL,'','/uploads/2/20220424/8e9875e49ce0abc6705fd7ee3d307d94.jpg',NULL,0,NULL,15,2,NULL,NULL,NULL,1,1,'2022-04-24 15:05:10',NULL,NULL,NULL),
	(16,26,1,NULL,NULL,NULL,'','/uploads/2/20220516/2262f6ff58d2bad5f435c03ab6eea00a.jpg',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-04-24 15:08:26','2022-05-16 16:20:44',NULL,NULL),
	(17,30,1,NULL,NULL,NULL,'','/uploads/2/20220424/36ff67b1f9308ae35173609823c930cb.jpg',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-04-24 17:17:38','2022-05-17 17:12:25',NULL,'雅致唯美'),
	(18,31,1,NULL,NULL,NULL,'','/uploads/2/20220424/ce1b2df9bbddade3c698dfe298d5659b.png',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-04-24 17:34:47','2022-05-17 16:45:00',NULL,'光影棚拍'),
	(19,32,1,NULL,NULL,NULL,'','/uploads/2/20220424/a73c1cf96b6cc3120b397090e09a14d3.jpg',NULL,0,NULL,4,2,NULL,NULL,NULL,1,1,'2022-04-24 17:50:13',NULL,NULL,'仪式片场'),
	(20,33,1,NULL,NULL,NULL,'','/uploads/2/20220424/dd11cfa34405ee08dcc984ef72abad52.jpg',NULL,0,NULL,20,2,NULL,NULL,NULL,1,1,'2022-04-24 18:01:34',NULL,NULL,NULL),
	(21,34,1,NULL,NULL,NULL,'','/uploads/2/20220425/2059a724e77e51cfe273347a7ffb8ab9.jpg',NULL,0,NULL,21,2,NULL,NULL,NULL,1,1,'2022-04-25 10:31:03',NULL,NULL,NULL),
	(22,35,1,NULL,NULL,NULL,'','/uploads/2/20220426/01cdbda835475dec2b3a8571bf77294e.png',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-04-26 13:43:21','2022-05-06 19:19:53',NULL,NULL),
	(23,36,1,NULL,NULL,NULL,'','/uploads/2/20220516/eb6cc06f847f21cab6d4fce76f77dea0.jpg',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-04-26 13:47:36','2022-05-18 15:15:04',NULL,NULL),
	(24,37,1,NULL,NULL,NULL,'','/uploads/2/20220426/af4a65db010fab392e20c6c7e6562d32.jpg',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-04-26 13:57:19',NULL,NULL,'123123'),
	(25,38,1,'','','','','/uploads/2/20220426/e18062232f5e60baac5a6f4a2f498e20.jpg','',0,'',2,2,'','',NULL,1,1,'2022-04-26 13:47:36',NULL,NULL,''),
	(26,39,1,NULL,NULL,NULL,'','/uploads/2/20220426/c56b84d0b797c18179ebb1deb6b45b15.jpg',NULL,0,NULL,8,2,NULL,NULL,NULL,1,1,'2022-04-26 15:38:18','2022-05-16 10:55:38',NULL,NULL),
	(27,41,1,NULL,NULL,NULL,'','/uploads/2/20220506/0b9aa4b2cb71d38e729aa52aec9bf61f.png',NULL,0,NULL,27,2,NULL,NULL,NULL,1,1,'2022-05-06 15:58:09','2022-05-06 20:02:52',NULL,NULL),
	(28,42,1,NULL,NULL,NULL,'','/uploads/2/20220506/d5e4dbf69db795c4d5fcbe970791cb27.png',NULL,0,NULL,28,2,NULL,NULL,NULL,1,1,'2022-05-06 15:58:32','2022-05-06 20:03:12',NULL,NULL),
	(29,43,1,NULL,NULL,NULL,'','/uploads/2/20220506/dfa8dcddceeaab61a890ba0b5125234b.png',NULL,0,NULL,29,2,NULL,NULL,NULL,1,1,'2022-05-06 15:58:47',NULL,NULL,NULL),
	(30,44,1,NULL,NULL,NULL,'','/uploads/2/20220506/283aca0f427b6780050746142b8eb2d5.png',NULL,0,NULL,30,2,NULL,NULL,NULL,1,1,'2022-05-06 16:00:33',NULL,NULL,NULL),
	(31,45,1,NULL,NULL,NULL,'','/uploads/2/20220511/a36a2cdb4529e7392f08a9d7d71c8c0b.jpg',NULL,0,NULL,31,2,NULL,NULL,NULL,1,1,'2022-05-11 11:46:12',NULL,NULL,NULL),
	(32,46,1,NULL,NULL,NULL,'','/uploads/2/20220511/9e2b12be031ab067c64cf2ec9106de36.jpg',NULL,0,NULL,32,2,NULL,NULL,NULL,1,1,'2022-05-11 16:56:30',NULL,NULL,NULL),
	(33,47,1,NULL,NULL,NULL,'','/uploads/2/20220511/6b0e040b0a841c94f90aa7d8bf2315fe.png',NULL,0,NULL,33,2,NULL,NULL,NULL,1,1,'2022-05-11 17:03:17',NULL,NULL,NULL),
	(34,49,1,NULL,NULL,NULL,'',NULL,NULL,0,NULL,34,2,NULL,NULL,NULL,1,1,'2022-05-11 17:43:39',NULL,NULL,NULL),
	(35,50,1,NULL,NULL,NULL,'','/uploads/2/20220512/711b12ef014e25970cf10ecd5923cc71.jpg',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-05-12 11:28:23',NULL,NULL,NULL),
	(36,51,1,NULL,NULL,NULL,'','/uploads/2/20220512/6b381087f4c1cd22b467306a2c11a017.jpg',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-05-12 11:29:01',NULL,NULL,NULL),
	(37,52,1,NULL,NULL,NULL,'','/uploads/2/20220512/751b849f663a34e978ab5efc65c44728.jpg',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-05-12 11:37:30',NULL,NULL,NULL),
	(38,54,1,NULL,NULL,NULL,'','/uploads/2/20220512/6a76d98aba26cceff7bf222796e286a7.jpg',NULL,0,NULL,38,2,NULL,NULL,NULL,1,1,'2022-05-12 11:42:30',NULL,NULL,NULL),
	(39,55,1,NULL,NULL,NULL,'','/uploads/2/20220512/99e7bdf3e392b97e63d34a14ef84ba6d.jpg',NULL,0,NULL,39,2,NULL,NULL,NULL,1,1,'2022-05-12 11:45:43',NULL,NULL,NULL),
	(41,58,1,NULL,NULL,NULL,'','/uploads/2/20220513/25f47c19969f91f79e1662415121841a.jpg',NULL,0,NULL,41,2,NULL,NULL,NULL,1,1,'2022-05-13 10:55:04',NULL,NULL,NULL),
	(42,59,1,NULL,NULL,NULL,'','/uploads/2/20220513/ec67975d4146477ae8e2fb9705716d83.jpg',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-05-13 10:57:27',NULL,NULL,NULL),
	(43,60,1,NULL,NULL,NULL,'','/uploads/2/20220513/fed121ec579f99cbb959deb5cba66f2e.jpg',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-05-13 10:57:37',NULL,NULL,NULL),
	(44,61,1,NULL,NULL,NULL,'','/uploads/2/20220513/5b5cf59451cd8ba885a3249ceaefc502.jpg',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-05-13 10:57:47',NULL,NULL,NULL),
	(45,62,1,NULL,NULL,NULL,'','/uploads/2/20220513/49d83ebad1a5df269ed0684e6fe4ea44.png',NULL,0,NULL,4,2,NULL,NULL,NULL,1,1,'2022-05-13 10:57:58',NULL,NULL,NULL),
	(46,63,1,NULL,NULL,NULL,'','/uploads/2/20220513/53ea1d9272e672df05ed2a105f452c1d.png',NULL,0,NULL,5,2,NULL,NULL,NULL,1,1,'2022-05-13 10:58:08',NULL,NULL,NULL),
	(47,66,1,NULL,NULL,NULL,'','/uploads/2/20220516/b57f4d7a7acde44ecb2feeed3696aa91.jpg',NULL,0,NULL,4,2,NULL,NULL,NULL,1,1,'2022-05-16 11:04:36','2022-05-16 11:41:06',NULL,NULL),
	(49,68,1,NULL,NULL,NULL,'','/uploads/2/20220516/7056b98f3c830bc32f0816d27bba59db.jpg',NULL,0,NULL,49,2,NULL,NULL,NULL,1,1,'2022-05-16 11:05:29','2022-05-16 11:45:26',NULL,NULL),
	(50,69,1,NULL,NULL,NULL,'','/uploads/2/20220516/72523e84c0a713a1cced0f0ebe60010f.jpg',NULL,0,NULL,50,2,NULL,NULL,NULL,1,1,'2022-05-16 11:06:08',NULL,NULL,NULL),
	(51,70,1,NULL,NULL,NULL,'','/uploads/2/20220516/494a0e2b9a57bc5505eeedc383e5277d.jpg',NULL,0,NULL,51,2,NULL,NULL,NULL,1,1,'2022-05-16 11:06:27',NULL,NULL,NULL),
	(52,71,1,NULL,NULL,NULL,'','/uploads/2/20220516/2e8233b80a95aa642e72f41cc852d54d.jpg',NULL,0,NULL,52,2,NULL,NULL,NULL,1,1,'2022-05-16 11:09:10','2022-05-16 11:45:48',NULL,NULL),
	(53,73,1,NULL,NULL,NULL,'','/uploads/2/20220516/c9e7303c848d276b30c746bd3ac6694b.jpg',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-05-16 11:24:19',NULL,NULL,NULL),
	(54,76,1,NULL,NULL,NULL,'','/uploads/2/20220516/93fde231a9048e0b0a3ef43deeb009bc.jpg',NULL,0,NULL,54,2,NULL,NULL,NULL,1,1,'2022-05-16 11:32:34',NULL,NULL,NULL),
	(57,80,1,NULL,NULL,NULL,'','/uploads/2/20220516/6c93ae4066d4037072a0341c42300f94.jpg',NULL,0,NULL,57,2,NULL,NULL,NULL,1,1,'2022-05-16 11:35:14',NULL,NULL,NULL),
	(58,81,1,NULL,NULL,NULL,'','/uploads/2/20220516/12191fb2c52b6d69aa0c5601ba5f9596.jpg',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-05-16 11:36:49',NULL,NULL,NULL),
	(59,82,1,NULL,NULL,NULL,'','/uploads/2/20220516/af93202894eeddec99bbdb90720fec27.jpg',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-05-16 11:37:01','2022-05-16 11:41:51',NULL,NULL),
	(60,83,1,NULL,NULL,NULL,'','/uploads/2/20220516/f055363f28a2f4fe64de1c3f1927708e.jpg',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-05-16 11:37:10',NULL,NULL,NULL),
	(61,84,1,NULL,NULL,NULL,'','/uploads/2/20220516/c5d0ba7aa0cc7eaec19d9fbf468b4b61.jpg',NULL,0,NULL,6,2,NULL,NULL,NULL,1,1,'2022-05-16 11:37:19','2022-05-16 11:38:25',NULL,NULL),
	(62,85,1,NULL,NULL,NULL,'','/uploads/2/20220516/ab89c98f96acc4d230ff2017863c6b20.jpg',NULL,0,NULL,9,2,NULL,NULL,NULL,1,1,'2022-05-16 11:37:33','2022-05-16 11:42:01',NULL,NULL),
	(63,86,1,NULL,NULL,NULL,'','/uploads/2/20220516/ec109f4501d32b7aff99f0e2a765fd5a.jpg',NULL,0,NULL,5,2,NULL,NULL,NULL,1,1,'2022-05-16 11:37:51',NULL,NULL,NULL),
	(64,87,1,NULL,NULL,NULL,'','/uploads/2/20220516/752a597372f1b00f2a12c9e7e389009f.jpg',NULL,0,NULL,7,2,NULL,NULL,NULL,1,1,'2022-05-16 11:38:39',NULL,NULL,NULL),
	(65,88,1,NULL,NULL,NULL,'','/uploads/2/20220516/b20ada4c30d33e1368633cee8080e359.jpg',NULL,0,NULL,8,2,NULL,NULL,NULL,1,1,'2022-05-16 11:38:50','2022-05-16 11:42:11',NULL,NULL),
	(66,89,1,NULL,NULL,NULL,'','/uploads/2/20220516/81d1f146b8d72132bfe08364245b3e51.jpg',NULL,0,NULL,10,2,NULL,NULL,NULL,1,1,'2022-05-16 11:39:00','2022-05-16 11:39:40',NULL,NULL),
	(67,90,1,NULL,NULL,NULL,'','/uploads/2/20220516/85f3c996ea642d31555dc5e3fccba2fa.jpg',NULL,0,NULL,11,2,NULL,NULL,NULL,1,1,'2022-05-16 11:39:53',NULL,NULL,NULL),
	(69,92,1,NULL,NULL,NULL,'','/uploads/2/20220516/cc73f096424d317c847407cf689e4875.jpg',NULL,0,NULL,69,2,NULL,NULL,NULL,1,1,'2022-05-16 11:45:41',NULL,NULL,NULL),
	(70,93,1,NULL,NULL,NULL,'','/uploads/2/20220516/9814f20085ff448ecc31f6df6c2bfffd.jpg',NULL,0,NULL,70,2,NULL,NULL,NULL,1,1,'2022-05-16 11:45:55',NULL,NULL,NULL),
	(71,94,1,NULL,NULL,NULL,'','/uploads/2/20220516/161b6455a4d28d8e2a117e823c777bc9.jpg',NULL,0,NULL,71,2,NULL,NULL,NULL,1,1,'2022-05-16 11:46:05',NULL,NULL,NULL),
	(72,95,1,NULL,NULL,NULL,'','/uploads/2/20220516/1e3d0cb42dcc7e68adbf1ae6cf05050b.jpg',NULL,0,NULL,72,2,NULL,NULL,NULL,1,1,'2022-05-16 11:46:13',NULL,NULL,NULL),
	(74,97,1,NULL,NULL,NULL,'','/uploads/2/20220516/bd080b744d5a68e7055582d8f6890045.jpg',NULL,0,NULL,74,2,NULL,NULL,NULL,1,1,'2022-05-16 11:56:32',NULL,NULL,NULL),
	(77,100,1,NULL,NULL,NULL,'','/uploads/2/20220516/824c59017e6646247333cf47f40ac690.jpg',NULL,0,NULL,77,2,NULL,NULL,NULL,1,1,'2022-05-16 11:59:01',NULL,NULL,NULL),
	(78,101,1,NULL,NULL,NULL,'','/uploads/2/20220516/8ec62d514af1012b1abd197fc574c278.jpg',NULL,0,NULL,78,2,NULL,NULL,NULL,1,1,'2022-05-16 11:59:14',NULL,NULL,NULL),
	(79,102,1,NULL,NULL,NULL,'','/uploads/2/20220516/b775f1a63e428d385b0424dd4e60ffb6.jpg',NULL,0,NULL,2,2,NULL,NULL,NULL,1,1,'2022-05-16 12:02:29',NULL,NULL,NULL),
	(80,103,1,NULL,NULL,NULL,'','/uploads/2/20220516/b064369dc173ddb76b421af38ce7056c.jpg',NULL,0,NULL,80,2,NULL,NULL,NULL,1,1,'2022-05-16 12:02:52',NULL,NULL,NULL),
	(81,104,1,NULL,NULL,NULL,'','/uploads/2/20220516/bd69c2e0c82dba7da554e601cbd7a6aa.jpg',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-05-16 12:03:48',NULL,NULL,NULL),
	(84,107,1,NULL,NULL,NULL,'','/uploads/2/20220516/0528117477bc94d7f56e386b79763042.jpg',NULL,0,NULL,84,2,NULL,NULL,NULL,1,1,'2022-05-16 12:12:31',NULL,NULL,NULL),
	(85,108,1,NULL,NULL,NULL,'','/uploads/2/20220516/445a8a6a76631292752faed59830ca80.jpg',NULL,0,NULL,85,2,NULL,NULL,NULL,1,1,'2022-05-16 12:13:40',NULL,NULL,NULL),
	(86,109,1,NULL,NULL,NULL,'','/uploads/2/20220516/98a47a8d885671adaa6389f5c08bb4ab.jpg',NULL,0,NULL,5,2,NULL,NULL,NULL,1,1,'2022-05-16 15:37:14',NULL,NULL,'素锦年华'),
	(87,110,1,NULL,NULL,NULL,'','/uploads/2/20220517/3507213485456381c6feaef8aec2e750.jpg',NULL,0,NULL,87,2,NULL,NULL,NULL,1,1,'2022-05-17 09:22:34',NULL,NULL,NULL),
	(88,112,1,NULL,NULL,NULL,'','/uploads/2/20220517/3684130f89a0a08d7bbc155316a5acf7.jpg',NULL,0,NULL,88,2,NULL,NULL,NULL,1,1,'2022-05-17 09:30:43',NULL,NULL,NULL),
	(89,114,1,NULL,NULL,NULL,'','/uploads/2/20220517/fcb5613ac49959c32a770e213dbb00f0.jpg',NULL,0,NULL,89,2,NULL,NULL,NULL,1,1,'2022-05-17 10:09:24',NULL,NULL,NULL),
	(90,115,1,NULL,NULL,NULL,'','/uploads/2/20220517/fa17194a8e306189286c55772593af1f.jpg',NULL,0,NULL,3,2,NULL,NULL,NULL,1,1,'2022-05-17 17:28:00',NULL,NULL,NULL),
	(91,116,1,NULL,NULL,NULL,'','/uploads/2/20220517/7c91e273a88b92f0782c7c9b2603a0d4.png',NULL,0,NULL,1,2,NULL,NULL,NULL,1,1,'2022-05-17 18:54:04',NULL,NULL,NULL),
	(92,117,1,NULL,NULL,NULL,'','/uploads/2/20220517/7e3c15526a0013ef5736ee333ef9d9a6.jpg',NULL,0,NULL,4,2,NULL,NULL,NULL,1,1,'2022-05-17 18:54:20',NULL,NULL,NULL),
	(93,118,1,NULL,NULL,NULL,'','/uploads/2/20220518/f419b8674d65af8ea4a772499e77f6a6.jpg',NULL,0,NULL,6,2,NULL,NULL,NULL,1,1,'2022-05-18 09:55:49',NULL,NULL,'fgsdf'),
	(94,119,1,NULL,NULL,NULL,'','/uploads/2/20220518/6ae3928182e78a6fdfb1e66e0c8562d6.png',NULL,0,NULL,9,2,NULL,NULL,NULL,1,1,'2022-05-18 09:56:17',NULL,NULL,'dfa'),
	(95,120,1,NULL,NULL,NULL,'','/uploads/2/20220518/5eba0b84bdb36315a1488a06b5721431.jpg',NULL,0,NULL,10,2,NULL,NULL,NULL,1,1,'2022-05-18 09:56:31',NULL,NULL,'fgs'),
	(96,121,1,NULL,NULL,NULL,'','/uploads/2/20220518/97bf0406f77c82bbf1f0483ba0a61c57.jpg',NULL,0,NULL,7,2,NULL,NULL,NULL,1,1,'2022-05-18 09:56:49',NULL,NULL,'dfa'),
	(97,122,1,NULL,NULL,NULL,'','/uploads/2/20220518/533ee9639586c143d6c754fc79a87fbf.png',NULL,0,NULL,11,2,NULL,NULL,NULL,1,1,'2022-05-18 10:28:35',NULL,NULL,NULL),
	(98,123,1,NULL,NULL,NULL,'','/uploads/2/20220518/6cfa9ca99dd56178cf0e870dd9f8bdf3.png',NULL,0,NULL,12,2,NULL,NULL,NULL,1,1,'2022-05-18 10:28:51',NULL,NULL,NULL),
	(99,124,1,NULL,NULL,NULL,'','/uploads/2/20220518/e5a1a9cd2db9d0b3e21caa43926f9213.jpg',NULL,0,NULL,13,2,NULL,NULL,NULL,1,1,'2022-05-18 10:29:06',NULL,NULL,NULL),
	(100,125,1,NULL,NULL,NULL,'','/uploads/2/20220518/f15ac73dd6bb62aba87d774addb4c1f6.png',NULL,0,NULL,14,2,NULL,NULL,NULL,1,1,'2022-05-18 10:29:23',NULL,NULL,NULL),
	(101,126,1,NULL,NULL,NULL,'','/uploads/2/20220518/fb0ea02fe67d3cb3963651308501e6db.png',NULL,0,NULL,15,2,NULL,NULL,NULL,1,1,'2022-05-18 10:29:36',NULL,NULL,NULL),
	(102,127,1,NULL,NULL,NULL,'','/uploads/2/20220518/efe553627af2fe30234db363ae8ba0ba.jpg',NULL,0,NULL,16,2,NULL,NULL,NULL,1,1,'2022-05-18 10:29:51',NULL,NULL,NULL),
	(103,128,1,NULL,NULL,NULL,'','/uploads/2/20220518/cff629c6ff15ae3395a5694499cb02be.png',NULL,0,NULL,17,2,NULL,NULL,NULL,1,1,'2022-05-18 10:37:54',NULL,NULL,NULL),
	(104,129,1,NULL,NULL,NULL,'','/uploads/2/20220518/fee81d9dcb92e17d4f1bea949e94ae8f.png',NULL,0,NULL,18,2,NULL,NULL,NULL,1,1,'2022-05-18 10:38:11',NULL,NULL,NULL),
	(105,130,1,NULL,NULL,NULL,'','/uploads/2/20220518/41423826b0c4e5b61c2ab04d204ad723.jpg',NULL,0,NULL,105,2,NULL,NULL,NULL,1,1,'2022-05-18 16:25:07',NULL,NULL,NULL),
	(106,131,1,NULL,NULL,NULL,'','/uploads/2/20220518/e12cbd94064fd4a9a33d2146dca52a28.jpg',NULL,0,NULL,106,2,NULL,NULL,NULL,1,1,'2022-05-18 16:26:27',NULL,NULL,'12312'),
	(107,134,1,NULL,NULL,NULL,'','/uploads/2/20220518/7fdf6ef766fbf88e47e1619974b35916.jpg',NULL,0,NULL,107,2,NULL,NULL,NULL,1,1,'2022-05-18 16:29:40',NULL,NULL,NULL),
	(108,135,1,NULL,NULL,NULL,'','/uploads/2/20220518/87c8dfb6381147c5e5e7e52e10ece37e.png',NULL,0,NULL,108,2,NULL,NULL,NULL,1,1,'2022-05-18 16:31:04',NULL,NULL,NULL),
	(109,138,1,NULL,NULL,NULL,'','/uploads/2/20220518/9a30d48ae03c9698e5b35875f0f19987.jpg',NULL,0,NULL,109,2,NULL,NULL,NULL,1,1,'2022-05-18 16:54:57',NULL,NULL,NULL),
	(110,140,1,NULL,NULL,NULL,'','/uploads/2/20220518/3f311637ccebe6fe10c138c4db239c18.jpg',NULL,0,NULL,110,2,NULL,NULL,NULL,1,1,'2022-05-18 16:56:00',NULL,NULL,NULL),
	(111,141,1,NULL,NULL,NULL,'','/uploads/2/20220518/030e44f7d34776c37e7f52ca50b04693.jpg',NULL,0,NULL,111,2,NULL,NULL,NULL,1,1,'2022-05-18 16:56:12',NULL,NULL,NULL),
	(112,142,1,NULL,NULL,NULL,'','/uploads/2/20220523/2a09ce57eda90c890cd19c2236342a5f.jpg',NULL,0,NULL,112,2,NULL,NULL,NULL,1,1,'2022-05-23 10:25:15',NULL,NULL,''),
	(113,143,1,NULL,NULL,NULL,'','/uploads/2/20220523/3c8ad1b3f426f48c31c7af6355e7e014.jpg',NULL,0,NULL,113,2,NULL,NULL,NULL,1,1,'2022-05-23 10:25:15','2022-05-23 10:22:56',NULL,NULL),
	(114,144,1,NULL,NULL,NULL,'','/uploads/2/20220523/607e3e773a6aba1f007d91556d30b27b.jpg',NULL,0,NULL,114,2,NULL,NULL,NULL,1,1,'2022-05-23 10:25:15',NULL,NULL,''),
	(115,145,1,NULL,NULL,NULL,'','/uploads/2/20220523/beb3317dac966b2aff63b79f1136ac46.jpg',NULL,0,NULL,115,2,NULL,NULL,NULL,1,1,'2022-05-23 11:04:06',NULL,NULL,''),
	(116,146,1,NULL,NULL,NULL,'','/uploads/2/20220523/bdf6d093edece81fca1c89e6bdacd009.jpg',NULL,0,NULL,116,2,NULL,NULL,NULL,1,1,'2022-05-23 11:04:06',NULL,NULL,''),
	(117,147,1,NULL,NULL,NULL,'','/uploads/2/20220523/7b867c4d00bd6773204a45a0f6590f14.jpg',NULL,0,NULL,117,2,NULL,NULL,NULL,1,1,'2022-05-23 11:04:06',NULL,NULL,''),
	(118,148,1,NULL,NULL,NULL,'','/uploads/2/20220523/08c2af62fbc7dd78b577fba6ec305a66.jpg',NULL,0,NULL,118,2,NULL,NULL,NULL,1,1,'2022-05-23 11:36:29',NULL,NULL,''),
	(119,149,1,NULL,NULL,NULL,'','/uploads/2/20220523/ced8e620aee4dd62811a09f385c091a1.jpg',NULL,0,NULL,119,2,NULL,NULL,NULL,1,1,'2022-05-23 11:36:29',NULL,NULL,''),
	(120,150,1,NULL,NULL,NULL,'','/uploads/2/20220523/a9ec290d5bafaf1a2db5598c24e68b61.jpg',NULL,0,NULL,120,2,NULL,NULL,NULL,1,1,'2022-05-23 11:36:29',NULL,NULL,'');

/*!40000 ALTER TABLE `sx_resource` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table sx_resource_detail
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sx_resource_detail`;

CREATE TABLE `sx_resource_detail` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `rid` int(11) DEFAULT NULL COMMENT '资源id',
  `file_type` tinyint(4) DEFAULT NULL COMMENT '上传文件类型（1：图片；2：视频）',
  `label` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标签',
  `content` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '明细内容（存放地址）',
  `sort` int(11) DEFAULT NULL COMMENT '排序',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='资源明细表';

LOCK TABLES `sx_resource_detail` WRITE;
/*!40000 ALTER TABLE `sx_resource_detail` DISABLE KEYS */;

INSERT INTO `sx_resource_detail` (`id`, `rid`, `file_type`, `label`, `content`, `sort`, `create_time`, `update_time`)
VALUES
	(1,1,1,NULL,'/uploads/1/2/20220406/24aadb8735c2802b0b697ace772731b1.png',0,'2022-04-06 17:53:30',NULL),
	(2,1,1,NULL,'/uploads/1/2/20220406/440cb1d78e2a4c09cf77dc0ccc6f6857.png',0,'2022-04-06 17:53:30',NULL),
	(5,9,1,NULL,'/uploads/2/20220511/b4588e0dfbfb02908867471672a60ec3.jpg',1,'2022-05-11 17:33:57',NULL),
	(7,49,1,NULL,'/uploads/2/20220511/6887a3ea9e85996dceed178da3ce23fc.jpg',NULL,'2022-05-11 17:44:01',NULL),
	(8,49,1,NULL,'/uploads/2/20220511/07eb7117855f85fc87739da06f028756.jpg',NULL,'2022-05-11 17:44:01',NULL),
	(9,9,1,NULL,'/uploads/2/20220511/b7a061152145cafcc4c3ac363311243f.png',2,'2022-05-11 17:54:37',NULL),
	(10,9,1,NULL,'/uploads/2/20220511/6620b7ef1e8245832f3dbc44d59c61a9.jpg',3,'2022-05-11 17:54:37',NULL),
	(13,49,2,NULL,'/uploads/1/2/20220512/ae6cb82c4c90f850016c29147dd2cc57.mp4',NULL,'2022-05-12 10:19:58',NULL),
	(14,54,1,NULL,'/uploads/2/20220512/cb93658a2c894bd42dae4c50c7745ac0.png',NULL,'2022-05-12 11:43:30',NULL),
	(15,54,1,NULL,'/uploads/2/20220512/34293c6f01f48edb86c1b6c90de2a00c.jpg',NULL,'2022-05-12 11:43:30',NULL),
	(16,55,2,NULL,'/uploads/1/2/20220512/7ddd1b9fd52741c690ddc77648b17d5a.mp4',NULL,'2022-05-12 11:47:09',NULL),
	(20,58,1,NULL,'/uploads/2/20220513/3de93d482690d1f97ab24ed85ad93a9d.jpg',NULL,'2022-05-13 10:55:24',NULL),
	(21,58,1,NULL,'/uploads/2/20220513/b113bec6714deb3b582036142f70110c.jpg',NULL,'2022-05-13 10:55:24',NULL),
	(22,58,1,NULL,'/uploads/2/20220513/3ee47702bfa8276956885aa5673ab171.png',NULL,'2022-05-13 10:55:32',NULL),
	(23,58,1,NULL,'/uploads/2/20220513/9b1cdc5e90b4e1e6af85ace2fe7e203e.png',NULL,'2022-05-13 10:55:32',NULL),
	(24,58,1,NULL,'/uploads/2/20220513/0e1a8b107f068c0b49890d30f096d12c.jpg',NULL,'2022-05-13 10:55:32',NULL),
	(25,59,1,NULL,'/uploads/2/20220513/0b8dad20fb1fc96644089330fc3ce6a9.png',4,'2022-05-13 13:50:38',NULL),
	(26,59,1,NULL,'/uploads/2/20220513/2148107f96c2d5b33fb15d6ac7c5ee6e.png',5,'2022-05-13 13:50:38',NULL),
	(28,59,1,NULL,'/uploads/2/20220513/fd841698d4b7c77f30aa613ffbe900ce.jpg',3,'2022-05-13 18:26:39',NULL),
	(31,70,1,NULL,'/uploads/2/20220516/e9d3f37e8ffbbf363f70928d46f01412.jpg',3,'2022-05-16 11:06:38',NULL),
	(32,70,1,NULL,'/uploads/2/20220516/c233147c3b0ab2fec2a8600a447aa280.jpg',4,'2022-05-16 11:06:38',NULL),
	(33,70,1,NULL,'/uploads/2/20220516/38cf923b1442e7490662df1de042bc1e.jpg',1,'2022-05-16 11:06:39',NULL),
	(34,70,1,NULL,'/uploads/2/20220516/1d9cbafa0d9f89eac6d334de914969a6.jpg',2,'2022-05-16 11:06:39',NULL),
	(35,76,1,NULL,'/uploads/2/20220516/5010eef2bdd532c91dd2fa1f2e8dbb30.jpg',3,'2022-05-16 11:49:47',NULL),
	(36,76,1,NULL,'/uploads/2/20220516/a37c2664c8c400de64dc9cdce0a1ded5.jpg',2,'2022-05-16 11:49:59',NULL),
	(37,76,1,NULL,'/uploads/2/20220516/cad2c4255688ff34ee7e46eb7f902610.jpg',1,'2022-05-16 11:50:12',NULL),
	(38,70,1,NULL,'/uploads/2/20220516/0aa8e11f8dd63985d5e07ea91accc342.jpg',NULL,'2022-05-16 15:14:59',NULL),
	(39,59,1,NULL,'/uploads/2/20220516/a55797f821f06b198c0e2c7497573235.jpg',2,'2022-05-16 15:23:15',NULL),
	(40,59,1,NULL,'/uploads/2/20220516/56d50f5c6b25f4127caa26530b7098ba.jpg',1,'2022-05-16 15:23:21',NULL),
	(43,70,2,NULL,'/uploads/1/2/20220517/999c45a732cb40620df2ef8cc8cb4db2.mp4',NULL,'2022-05-17 10:28:07',NULL),
	(44,59,2,NULL,'/uploads/1/2/20220518/00bca58ba6975dfce2cebca297fd2244.mp4',NULL,'2022-05-18 13:38:58',NULL),
	(57,60,1,'123','/uploads/2/20220520/68c15d4970020943c5713113701e4cab.jpg',NULL,'2022-05-20 16:26:22',NULL);

/*!40000 ALTER TABLE `sx_resource_detail` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table sx_template
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sx_template`;

CREATE TABLE `sx_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板类型（list：分类页；show：内容页）',
  `template` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '模板名称，对应控制器',
  `template_show` varchar(200) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '模板显示名',
  `thumb` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板示例图片',
  `temp_ex` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板说明',
  `create_time` datetime DEFAULT NULL,
  `update_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `template` (`template`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='模板表';

LOCK TABLES `sx_template` WRITE;
/*!40000 ALTER TABLE `sx_template` DISABLE KEYS */;

INSERT INTO `sx_template` (`id`, `type`, `template`, `template_show`, `thumb`, `temp_ex`, `create_time`, `update_time`)
VALUES
	(1,'list_列表页暂时去掉一行一列','1h1l','一行一列，长方图形','/static/admin/img/temp1.png','建议尺寸1280x800像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(2,'list','1h3l','一行三列，长方图形','/static/admin/img/temp3.png','建议尺寸1920x1300像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(3,'list','1h4l','一行四列，长方图形','/static/admin/img/temp41.png','图片尺寸1920x1000像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(4,'list','2h2l','两行两列，长方图形','/static/admin/img/temp4.png','建议尺寸1920x1200像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(5,'list','2h3l','两行三列','/static/admin/img/temp6.png','建议尺寸1920x1200像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(6,'list','2h5g','两行五个','/static/admin/img/temp5.png','建议尺寸1920x1200 中间竖图1200x1920像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(7,'list','3h4l','三行四列','/static/admin/img/temp12.png','建议尺寸1920x1200像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(8,'list','4h4l','四行四列','/static/admin/img/temp16.png','建议尺寸1920x1200像素','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(10,'show','show1','图片内容页1','/static/admin/img/show1.png','','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(11,'show_暂时没有这页','show2','图片内容页2','/static/admin/img/show2.png','','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(12,'show_video','show3','视频内容页3','/static/admin/img/show3.png','视频大小10M以内','2022-05-06 11:15:07','2022-05-06 11:15:07'),
	(14,'list','1h3l2','一行三列（中间突出），长方图形','/static/admin/img/temp31.png','建议尺寸1920x1080像素',NULL,NULL),
	(15,'show','2h3l_show','两行三列','/static/admin/img/temp6.png','建议尺寸1920x1200像素','2022-05-06 11:15:07','2022-05-06 11:15:07');

/*!40000 ALTER TABLE `sx_template` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table system
# ------------------------------------------------------------

DROP TABLE IF EXISTS `system`;

CREATE TABLE `system` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '配置项名称',
  `value` text NOT NULL COMMENT '配置项值',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='系统配置表';

LOCK TABLES `system` WRITE;
/*!40000 ALTER TABLE `system` DISABLE KEYS */;

INSERT INTO `system` (`id`, `name`, `value`)
VALUES
	(1,'site_config','a:7:{s:10:\"site_title\";s:24:\"接单系统后台管理\";s:9:\"seo_title\";s:0:\"\";s:11:\"seo_keyword\";s:0:\"\";s:15:\"seo_description\";s:0:\"\";s:14:\"site_copyright\";s:0:\"\";s:8:\"site_icp\";s:0:\"\";s:11:\"site_tongji\";s:0:\"\";}');

/*!40000 ALTER TABLE `system` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table template_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `template_list`;

CREATE TABLE `template_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `template_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板编号',
  `template_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板名称',
  `template_type` tinyint(2) DEFAULT NULL COMMENT '模板类型（1当季新品，2微电影，3去哪拍，4选择时尚经典，5婚嫁服务）',
  `bg_img` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板图地址',
  `img_num` int(10) DEFAULT '0' COMMENT '模板图片的限制数量',
  `data` varchar(600) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模板图片信息',
  `type` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '模版类型（1 双层图，2电影，3子图，4父图，5固定位图，6单图，7固定的张数）',
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标题',
  `titlerule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '标题的尺寸',
  `contentrule` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '内容尺寸',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL COMMENT '用户名',
  `password` varchar(50) NOT NULL COMMENT '密码',
  `mobile` varchar(11) DEFAULT '' COMMENT '手机',
  `email` varchar(50) DEFAULT '' COMMENT '邮箱',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '用户状态  1 正常  2 禁止',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `last_login_time` datetime DEFAULT NULL COMMENT '最后登陆时间',
  `last_login_ip` varchar(50) DEFAULT '' COMMENT '最后登录IP',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户表';



# Dump of table verify_code
# ------------------------------------------------------------

DROP TABLE IF EXISTS `verify_code`;

CREATE TABLE `verify_code` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(11) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '手机号',
  `code` varchar(10) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '验证码',
  `task_id` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '发送时间',
  `send_time` datetime DEFAULT NULL COMMENT '结束时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='手机验证码表';




/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
