<?php
namespace app\index\api;

class Order {
    public function getShareLink($params){
        $where = '';
        if($params['fc']){
            $where = ' c.fc is null or c.fc = '.intval($params['fc']);
        }
        $customerNo = $params['order_sn'];
        if(!$customerNo){
            return ['code'=>100,'error'=>1,'msg'=>'无效的单号：order_sn','data'=>[]];
        }
        if(strpos($customerNo,',')){
            //多条
            $customerNo = explode(',', $customerNo);
            $orderList = db('c_customer c')
            ->join('c_share s','s.uid = c.id','left')
            ->field('c.id,s.share_code,c.download_time,c.user_name,c.fc')
            ->where('user_name','in', $customerNo)
            ->where($where)
            ->order(' id desc ')
            ->select();
            
        }else{
            //单条
            $shareInfo = db('c_customer c')
            ->join('c_share s','s.uid = c.id','left')
            ->field('c.id,s.share_code,c.download_time,c.user_name,c.fc')
            ->where('user_name',$customerNo)
            ->where($where)
            ->order(' fc desc ')
            ->select();
            if($params['fc']){
                //传服次了，返回一维数组，没传服次的，返回二维数组
                foreach ($shareInfo as $value) {
                    if($value['fc'] == $params['fc']){
                        $shareInfo = $value;
                        break;
                    }
                    if(!$value['fc']){
                        $shareInfo = $value;
                    }
                }
            }else{
                $orderList = $shareInfo;
            }
        }
        if(isset($orderList)){
            $data = [];
            foreach ($orderList as $shareInfo) {
                if($shareInfo['share_code']){
                    $share_link = config('customer_root').'/share/'.$shareInfo['share_code'];
                }else{
                    $share_link = '';
                }
                $data[] = [
                    'url'=>$share_link,
                    'download_time'=>$shareInfo['download_time'],
                    'order_sn'=>$shareInfo['user_name'],
                    'fc'=>$shareInfo['fc']
                    ];
            }
            return $data;
        }else{
            if($shareInfo['share_code']){
                $share_link = config('customer_root').'/share/'.$shareInfo['share_code'];
                return [
                        'url'=>$share_link,
                        'download_time'=>$shareInfo['download_time'],
                        'order_sn'=>$shareInfo['user_name'],
                        'fc'=>$shareInfo['fc']
                    ];
            }else{
                return [];
            }
        }
    }
    public function create($params){
        $ret = ['code'=>200,'msg'=>'','data'=>[]];
        $customerNo = $params['order_sn'];
        if(empty($customerNo)){
            $ret['code'] = 500;
            $ret['msg'] = '无效的用户名！';
            $ret['error'] = 1;
            //echo json_encode($returnData);
            return $ret;
        }
        $folder = $params['folder'];
        $fc = $params['fc'];
        $where = '';
        if($fc){
            $where = ' fc = '.intval($fc);
        }
        $folder = $folder?$folder:date('Ym');
        $has = db('c_customer')->where(array('user_name' => $customerNo))->where($where)->find();
        $rootPath = config('customer_user');
        if ($has) {
            $data['dir_path'] = $rootPath.DS.$folder.DS.$customerNo;
            $shareInfo = db('c_share')->where(['uid'=>$has['id']])->find();
            try{
                db()->startTrans();
                if($shareInfo){
                    $share_link = config('customer_root').'/share/'.$shareInfo['share_code'];
                }else{
                    //重新生成共享连接
                    while (1) {
                        # code...
                        $str = self::myRand(10);
                        $share_code = md5($rootPath).$str;
                        $share_code = substr(str_shuffle($share_code), 0, 10);
                        $cnt = db('c_share')->where(array('share_code' => $share_code))->count();
                        if($cnt === 0){
                            break;
                        }
                    }
                    $sdata = ['share_code'=>$share_code,'uid'=>$uid];
                    db('c_share')->insert($sdata);
                    $share_link = config('customer_root').'/share/'.$share_code;
                }

                db('c_customer')->where(array('user_name' => $customerNo))->update($data);
                $logData = [
                    'module'=>'index',
                    'controller'=>'order',
                    'action'=>'create',
                    'data'=>'用户名已存在：'.$customerNo.'；原路径：'.$has['dir_path'].'；新路径：'.$data['dir_path'].'；分享路径：'.$share_link,
                    'old_data'=>addslashes($_SERVER['HTTP_X_FORWARDED_FOR']),
                    'ip'=>get_client_ip(),
                    'create_time'=>date('Y-m-d H:i:s'),
                ];
                common_log($logData);
                db()->commit();
                $ret['url'] = $share_link;
                return ['url'=>$share_link];
            }catch(\Exception $e){
                db()->rollback();
                $err = $e->getMessage();
                $this->log('用户名已存在：'.$customerNo.'；原路径：'.$has['dir_path'].'；新路径：'.$data['dir_path'].'日志记录失败：'.$err);
                $ret['code'] = 500;
                $ret['msg'] = $err;
                $ret['error'] = 1;
                return $ret;
            }
        }
        while (1) {
            # code...
            $str = self::myRand(10);
            $share_code = md5($rootPath).$str;
            $share_code = substr(str_shuffle($share_code), 0, 10);
            $cnt = db('c_share')->where(array('share_code' => $share_code))->count();
            if($cnt === 0){
                break;
            }
        }
        
        // 分享链接
        $share_link = config('customer_root').'/share/'.$share_code;
        /*
        if (config('sqlAddress')) {
            // 调用sqlsrv接口
            $NasUrl = urlencode($share_link);
            $url = config('sqlAddress').'Cid='.$customerNo.'&NasUrl='.$NasUrl.'&NasPwd= ';
            $sqlsrv_request = httpRequest($url, "POST" ,[], ['Content-length: 0']);
            $sqlsrv_request = json_decode($sqlsrv_request, true);
        }
        */
        $data['user_name'] = $customerNo;
        $data['password'] = '';
        $data['status'] = 1;
        if($fc){
            $data['fc'] = $fc;
        }
        $data['nickname'] = $customerNo;
        $data['dir_path'] = $rootPath.DS.$folder.DS.$customerNo;
        try{
            db()->startTrans();
            db('c_customer')->insert($data);
            $uid = db('c_customer')->getLastInsID();
            $sdata['share_code'] = $share_code;
            $sdata['uid'] = $uid;
            db('c_share')->insert($sdata);
            $logData = [
                'module'=>'index',
                'controller'=>'order',
                'action'=>'create',
                'data'=>'创建用户：'.$customerNo.'；路径：'.$data['dir_path'].'；共享路径：'.$share_link,
                'old_data'=>addslashes($_SERVER['HTTP_X_FORWARDED_FOR']),
                'ip'=>get_client_ip(),
                'create_time'=>date('Y-m-d H:i:s'),
            ];
            common_log($logData);
            db()->commit();
            return ['url'=>$share_link];
        }catch(\Exception $e){
            db()->rollback();
            $err = $e->getMessage();
            //$this->log('创建用户失败：'.json_encode($data).'；错误原因：'.$err);
            //echo '500|'.iconv("UTF-8","GB2312//IGNORE",$data['dir_path']);
            $ret['error'] = 1;
            $ret['code'] = 500;
            $ret['msg'] = $err;
            return $ret;
        }
    }
    // 随机字符串
    static function myRand($len){
        $chars='ABCDEFGHJKLMNPQRSTUVWXY1234567890abcdefghjkmnpqrstuvwxyz';
        $string=time();
        for(;$len>=1;$len--){
            $position=rand()%strlen($chars);
            $position2=rand()%strlen($string);
            $string=substr_replace($string,substr($chars,$position,1),$position2,0);
        }
        return $string;
    }
}
