<?php
/**
 * 上传底片接口API
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2017-10-21 $
 */
namespace app\index\api;
use Qiniu\Auth;
use OSS\OssClient;
class Upload {

    public function getQiniuUptoken($params,$appId=0){
        $customerName = $params['user_name'];
        $name = $params['name'];
        $mobile = $params['mobile'];
        $storeType = (int)$params['store_type'];
        //$service = $params['service_tel'];
        $shopCode = $params['shop_code'];
        $fileName = urldecode($params['file_name']);
        if(!$customerName){
            return ['error'=>1,'code'=>1001,'msg'=>'缺失用户名。'];
        }
        $customerInfo = db('c_customer')->where('user_name',$customerName)->find();
        $password = $customerInfo?$customerInfo['password']:(config('password')?config('password'):getRandStr(6,0,2));
        $smsStatus = db_config('sms_status');
        $smsContent = '';
        if($smsStatus == 'on'){
            $params['password'] = $password;
            $smsContent = $this->getSmsContent($params);
        }
        $storeType = $storeType?$storeType:3;
        db()->startTrans();
        try{
            if(!$customerInfo){
                
                $customerData = [
                    'user_name'=>$customerName,
                    'password'=>$password,
                    'mobile'=>$mobile,
                    'nickname'=>$name,
                    'store_type'=>$storeType,
                    'status'=>1,
                    'create_time'=>date('Y-m-d H:i:s'),
                    'sms_content'=>$smsContent,
                ];
                if($storeType == 1 ){
                    $customerData['dir_path'] = config('customer_folder').DS.$customerName;
                }
                if($shopCode){
                    $customerData['shop_code'] = $shopCode;
                }
                db('c_customer')->insert($customerData);
                $customerId = db('c_customer')->getLastInsID();
                $oldData = '新增用户'.$customerName;
            }else{
                $storeType = $customerInfo['store_type']?$customerInfo['store_type']:3;
                $customerData = [
                    'mobile'=>$mobile,
                    'nickname'=>$name,                    
                   // 'sms_content'=>$smsContent,
                ];
                if($shopCode){
                    $customerData['shop_code'] = $shopCode;
                }
                db('c_customer')->where('id',$customerInfo['id'])->update($customerData);
                $customerId = $customerInfo['id'];
                $oldData = '更新老用户:('.$customerInfo['id'].')'.$name;
            }
            if($fileName){
                $customerFolder = [
                    'customer_id'=>$customerId,
                    'folder'=>$fileName,
                    ];
                if($storeType == 4){
                    //阿里云OSS时，直接更新file_has和file_key
                    $customerFolder['file_hash'] = $fileName;
                    $customerFolder['file_key'] = $fileName;
                    
                }
                db('c_customer_folder')->insert($customerFolder);
                $folderId = db('c_customer_folder')->getLastInsID();
                $oldData .= ';文件名：'.$fileName;
            }else{
                $folderId = 0;
                $oldData .= ';';
            }
            action_log($customerData,$oldData);
            db()->commit();
        }catch(\Exception $e){
            db()->rollback();
            return ['error'=>1,'code'=>1002,'msg'=>'客户信息生成失败：'.$e->getMessage()];
        }
        /*
        if(!$folderId){
            return ['error'=>1,'code'=>1003,'msg'=>'上传信息生成失败：'];
        }*/
        $token = '';
        if($storeType == 3){
            //如果是七牛的，要生成token
            $auth = new Auth(config('UPLOAD_QINIU_ACCESS_KEY'), config('UPLOAD_QINIU_SECRET_KEY'));
            $bucket = config('UPLOAD_QINIU_BUCKET_NAME');
            // 生成上传Token
            $token = $auth->uploadToken($bucket,null,86400);
            if(!$token){
                return ['error'=>1,'code'=>1004,'msg'=>'上传token信息获取失败。'];
            }
        }
        
        return ['token'=>$token,'upload_id'=>$folderId,'password'=>$password];
    }

    public function setQiniuUploadHash($params){
        $uploadId = (int)$params['upload_id'];
        $hash = urldecode($params['hash']);
        $key = urldecode($params['key']);
        if(!$hash){
            return ['error'=>1,'code'=>2002,'msg'=>'无效的文件hash。'];
        }

        if(!$uploadId){
            $customerName = $params['user_name'];
            $fileName = urldecode($params['file_name']);
            $customerInfo = db('c_customer')->where('user_name',$customerName)->find();
            if(!$customerInfo){
                return ['error'=>1,'code'=>2004,'msg'=>'无效的upload_id或user_name'];
            }
            $data = [
                'customer_id'=>$customerInfo['id'],
                'folder'=>$fileName,
                'file_hash'=>$hash,
                'file_key'=>$key,
            ];
            $res = db('c_customer_folder')->insert($data);
            action_log($data,'上传新文件');
        }else{
            $folderInfo = db('c_customer_folder')->find($uploadId);
            if(!$folderInfo){
                return ['error'=>1,'code'=>2001,'msg'=>'无效的上传文件ID。'];
            }
            $data = [
                'file_hash'=>$hash,
                'file_key'=>$key,
            ];
            $res = db('c_customer_folder')->where('id',$uploadId)->update($data);
            action_log($data,'更新uploadid文件的hash传：'.$uploadId);
        }
        if($res === false){
            return ['error'=>1,'code'=>2003,'msg'=>'更新文件hash失败。'];
        }
        return [];
    }
    public function sendCustomerSms($params){
        $this->sendCustomerWxmsg($customerInfo);
        $customerName = $params['user_name'];
        $smsContent = $params['sms_content'];
        $smsStatus = db_config('sms_status');
        if($smsStatus != 'on'){
            return ['error'=>1,'code'=>3002,'msg'=>'未开启短信发送开关。'];
        }

        if($mobile){
            $mobile = explode(',', $mobile);
        }
        $customerInfo = db('c_customer')->where('user_name',$customerName)->find();
        if(!$customerInfo){
            return ['error'=>1,'code'=>3001,'msg'=>'没有此客户底片信息。'];
        }
        $content = $smsContent?$smsContent:$customerInfo['sms_content'];
        $smskey = md5($customerInfo['mobile'].$content);
        if(cache('?'.$smskey) && config('SMS_LIMIT')){
            action_log($data,'发送短信失败('.$customerInfo['mobile'].'),此手机号组合短信今日已发送过。');
            return ['error'=>1,'code'=>3005,'msg'=>'此手机号组合短信今日已发送过。'];
        }
        $smsCount = (int)cache('photo_sms_count_'.$customerName);
        if($smsCount >= 10){
            action_log($data,'发送短信失败(用户：'.$customerName.'发送请求次数超时)');
            return ['error'=>1,'code'=>3005,'msg'=>'此客户本日发送请求次数已超限。'];
        }else{
            $smsCount++;
            cache('photo_sms_count_'.$customerName,$smsCount,86400);
        }
        if($content && $customerInfo['mobile']){
            $data = [
                'content'=>$content,
                'mobile'=>$customerInfo['mobile'],
                'shop_code'=>$customerInfo['shop_code'],
            ];
            if($params['sendtime']){
                $data['send_time'] = $params['sendtime'];
            }
            if(config('SMS_ACCOUNT')){
                $res = send_sms($data);
            }else{
                if(!$data['shop_code']){
                    return ['error'=>1,'code'=>3003,'msg'=>'无短信内容或没有手机号或没有店号'];
                }
                $res = sx_call('5a17b86088f1a',$data);
            }
            
            if($res['code'] == 200){
                if(intval(config('SMS_LIMIT')) > 0){
                    cache($smskey,1,(int)config('SMS_LIMIT'));
                }
                if($content != $customerInfo['sms_content']){
                    try{
                        $customerData = [
                            'sms_content'=>$content,
                        ];
                        db('c_customer')->where('id', $customerInfo['id'])->update($customerData);
                    }catch(\Exception $e){
                        $this->ajaxError('数据更新失败'.$e->getMessage());
                    }
                }
                
                action_log($data,'发送短信成功('.$customerInfo['mobile'].')：'.json_encode($res));
                return $res['data'];
            }else{
                action_log($data,'发送短信失败('.$customerInfo['mobile'].')：'.$res['msg']);
                return ['error'=>1,'code'=>3004,'msg'=>$res['code'].$res['msg']];
            }
        }
        return ['error'=>1,'code'=>3003,'msg'=>'无短信内容或没有手机号或没有店号'];
    }
    function getSmsContent($params){
        $content = config('SMS_TEMPLETE');
        $content = $content?$content:'尊敬{name}您好！您在{shop_name}的照片已经修调完毕，现将您的版权发送给您，请您登录云底片系统进行下载，如有问题请您拨打{tel}进行沟通（工作时间9：30-17：00）！帐号：{user_name}。密码：{password}温馨提示：请在7日内进行下载，7日后系统将自动删除！';
        $content = str_replace('{user_name}', $params['user_name'], $content);
        $content = str_replace('{name}', $params['name'], $content);
        $content = str_replace('{tel}', $params['service_tel'], $content);
        $content = str_replace('{password}', $params['password'], $content);
        $content = str_replace('{shop_name}', $params['shop_name'], $content);
        $content = str_replace('{mobile}', $params['mobile'], $content);
        return $content;
    }

    function sendCustomerWxmsg($params){
        $userName = $params['user_name'];
        $mobile = $params['mobile'];
        if(!$userName && !$mobile){
            return ['error'=>1,'code'=>100,'msg'=>'手机号或用户名至少传一个。'];
        }
        if(!$mobile){
            $params = db('c_customer')->where('user_name',$userName)->find();
        }
        if(!$params['mobile']){
            return ['error'=>1,'code'=>101,'msg'=>'当前客户没有手机号，无法发送微信消息'];
        }
        $limit = config('WXMSG_LIMIT')?(int)config('WXMSG_LIMIT'):20;//默认20次，一天。
        $key = 'wxmsg_limit_'.$params['mobile'];
        $sendNum = (int)cache($key);
        if( $sendNum > $limit){
            return ['error'=>1,'code'=>102,'msg'=>'当前客户手机号发送次数已超过：'.$limit.'次，请等待24小时再试'];
        }
        $sendNum++;
        $content = getWxmsgContent('OPENTM207793577',$params);
        if($content === false){
            return ['error'=>1,'code'=>103,'msg'=>'未能获取到微信模板内容'];
        }
        $post = [
            'mobile'=>$params['mobile'],
            'shop_code'=>$params['shop_code'],
            'content'=>json_encode($content),
        ];//brandclass_id
        $res = sx_call('5d00c53f80f8d',$post);
        if($res['code'] == 200){
            cache($key,$sendNum,86400);
            return $res;
        }
        return ['error'=>1,'code'=>$res['code'],'msg'=>$res['msg'],'data'=>$res['data']];
    }
    
    function sms($params){
        $res = sx_call('5a17b86088f1a',$params);
        if($res['code'] == 200){
            return $res['data'];
        }else{
            return ['error'=>1,'code'=>3004,'msg'=>$res['code'].$res['msg']];
        }
    }

    function getOrderAccount($params){
        $orderSn = $params['order_sn'];
        $customerInfo = db('c_customer')->field('id,user_name,password,mobile,nickname,shop_code,store_type,create_time')->where('user_name',$orderSn)->find();
        if(!$customerInfo)
        return ['error'=>1,'code'=>404,'msg'=>'没有此客户底片信息。'];
        return $customerInfo;
    }

}