# ************************************************************
# Sequel Pro SQL dump
# Version 4541
#
# http://www.sequelpro.com/
# https://github.com/sequelpro/sequelpro
#
# Host: 192.168.0.11 (MySQL 5.6.37-log)
# Database: sx_photo_manage
# Generation Time: 2018-05-02 03:43:16 +0000
# ************************************************************


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table api_app
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_app`;

CREATE TABLE `api_app` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `app_id` varchar(50) NOT NULL DEFAULT '' COMMENT '应用id',
  `app_secret` varchar(50) NOT NULL DEFAULT '' COMMENT '应用密码',
  `app_name` varchar(50) NOT NULL DEFAULT '' COMMENT '应用名称',
  `app_status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用状态：0表示禁用，1表示启用',
  `app_type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '应用类型',
  `app_info` tinytext NOT NULL COMMENT '应用说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_id` (`app_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='appId和appSecret表';

LOCK TABLES `api_app` WRITE;
/*!40000 ALTER TABLE `api_app` DISABLE KEYS */;

INSERT INTO `api_app` (`id`, `app_id`, `app_secret`, `app_name`, `app_status`, `app_type`, `app_info`)
VALUES
	(3,'94201193','oUWKYeqCEojOvbmsynvWTctJSAVeoMZv','素玄云底片管理系统',1,1,'');

/*!40000 ALTER TABLE `api_app` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_auth_group
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_auth_group`;

CREATE TABLE `api_auth_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL COMMENT '组名称',
  `description` varchar(50) NOT NULL COMMENT '组描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '组状态：为1正常，为0禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='权限组';

LOCK TABLES `api_auth_group` WRITE;
/*!40000 ALTER TABLE `api_auth_group` DISABLE KEYS */;

INSERT INTO `api_auth_group` (`id`, `name`, `description`, `status`)
VALUES
	(4,'底片传片组','供底片传片组进行上传底片使用。',1),
	(5,'用户管理','管理用户权限，添加后台帐号。',1);

/*!40000 ALTER TABLE `api_auth_group` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_auth_group_access
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_auth_group_access`;

CREATE TABLE `api_auth_group_access` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) unsigned NOT NULL,
  `groupId` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户和组的对应关系';

LOCK TABLES `api_auth_group_access` WRITE;
/*!40000 ALTER TABLE `api_auth_group_access` DISABLE KEYS */;

INSERT INTO `api_auth_group_access` (`id`, `uid`, `groupId`)
VALUES
	(2,2,'4,5'),
	(3,3,'4');

/*!40000 ALTER TABLE `api_auth_group_access` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_auth_rule
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_auth_rule`;

CREATE TABLE `api_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `url` char(80) NOT NULL DEFAULT '' COMMENT '规则唯一标识',
  `groupId` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限所属组的ID',
  `auth` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '权限数值',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态：为1正常，为0禁用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='权限细节';

LOCK TABLES `api_auth_rule` WRITE;
/*!40000 ALTER TABLE `api_auth_rule` DISABLE KEYS */;

INSERT INTO `api_auth_rule` (`id`, `url`, `groupId`, `auth`, `status`)
VALUES
	(1,'Index/index',3,0,1),
	(2,'Index/welcome',3,0,1),
	(4,'Customer/uploadFile',3,0,1),
	(5,'Customer/folderDel',3,0,1),
	(6,'Customer/folderAdd',3,0,1),
	(7,'Customer/folderList',3,0,1),
	(8,'Customer/del',3,0,1),
	(9,'Customer/open',3,0,1),
	(10,'Customer/close',3,0,1),
	(11,'Customer/add',3,0,1),
	(12,'Customer/Index',3,0,1),
	(16,'Index/index',4,0,1),
	(17,'Index/welcome',4,0,1),
	(19,'Customer/uploadFile',4,0,1),
	(20,'Customer/folderDel',4,0,1),
	(21,'Customer/folderAdd',4,0,1),
	(22,'Customer/folderList',4,0,1),
	(23,'Customer/del',4,0,1),
	(24,'Customer/open',4,0,1),
	(25,'Customer/close',4,0,1),
	(26,'Customer/add',4,0,1),
	(27,'Customer/Index',4,0,1),
	(31,'50',4,0,1),
	(47,'Index/index',5,0,1),
	(48,'Index/welcome',5,0,1),
	(49,'2',5,0,1),
	(50,'User/index',5,0,1),
	(51,'User/add',5,0,1),
	(52,'User/close',5,0,1),
	(53,'User/open',5,0,1),
	(54,'User/del',5,0,1),
	(55,'Permission/group',5,0,1),
	(56,'Permission/rule',5,0,1),
	(57,'Permission/member',5,0,1),
	(58,'50',5,0,1),
	(59,'Customer/uploadFile',5,0,1),
	(60,'Customer/folderDel',5,0,1),
	(61,'Customer/folderAdd',5,0,1),
	(62,'Customer/folderList',5,0,1),
	(63,'Customer/del',5,0,1),
	(64,'Customer/open',5,0,1),
	(65,'Customer/close',5,0,1),
	(66,'Customer/add',5,0,1),
	(67,'Customer/Index',5,0,1),
	(68,'Customer/refresh',4,0,1),
	(69,'Customer/addAll',4,0,1),
	(70,'Customer/search',4,0,1),
	(71,'Customer/setDir',4,0,1),
	(72,'Customer/addOne',4,0,1),
	(73,'Customer/shareList',4,0,1);

/*!40000 ALTER TABLE `api_auth_rule` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_fields
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_fields`;

CREATE TABLE `api_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fieldName` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名称',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT '对应接口的唯一标识',
  `dataType` tinyint(2) NOT NULL DEFAULT '0' COMMENT '数据类型，来源于DataType类库',
  `default` varchar(500) NOT NULL DEFAULT '' COMMENT '默认值',
  `isMust` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否必须 0为不必须，1为必须',
  `range` varchar(500) NOT NULL DEFAULT '' COMMENT '范围，Json字符串，根据数据类型有不一样的含义',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT '字段说明',
  `type` tinyint(2) NOT NULL DEFAULT '0' COMMENT '字段用处：0为request，1为response',
  `showName` varchar(50) NOT NULL DEFAULT '' COMMENT 'wiki显示用字段',
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用于保存各个API的字段规则';

LOCK TABLES `api_fields` WRITE;
/*!40000 ALTER TABLE `api_fields` DISABLE KEYS */;

INSERT INTO `api_fields` (`id`, `fieldName`, `hash`, `dataType`, `default`, `isMust`, `range`, `info`, `type`, `showName`)
VALUES
	(20,'user_name','5acf2ab9780fb',2,'',1,'','用户唯一编号，确保唯一即可，全系统唯一客户标识，相同的客户文件会在一起。',0,'user_name'),
	(21,'mobile','5acf2ab9780fb',2,'',0,'','手机号',0,'mobile'),
	(22,'name','5acf2ab9780fb',2,'',0,'','姓名',0,'name'),
	(23,'file_name','5acf2ab9780fb',2,'',0,'','要上传的文件名，可以直接写文件名，相同文件名是否可以上传取决于存储服务器，可以带目录，如：客户原片/原片.zip\n则下载时，需要点进客户原片目录里。如果不传，则显示上传后的文件hash值。',0,'file_name'),
	(24,'upload_id','5ad053021201b',1,'',0,'','上传文件ID，在获取上传token时，返回的id。',0,'upload_id'),
	(25,'hash','5ad053021201b',2,'',1,'','上传七牛云的文件hash值。',0,'hash'),
	(26,'key','5ad053021201b',2,'',0,'','key',0,'key'),
	(27,'user_name','5ad302e9b70a4',2,'',1,'','用户名，即创建用户时传入的用户唯一编号，如订单号等。',0,'user_name'),
	(28,'sms_content','5ad302e9b70a4',2,'',0,'','短信内容，如果不传，则根据系统短信模板组成短信内容。',0,'sms_content'),
	(29,'shop_code','5acf2ab9780fb',2,'',0,'','门店code，发送短信用，记录是哪个店的客片，以便调用相应店的短信接口',0,'shop_code'),
	(30,'shop_name','5acf2ab9780fb',2,'',0,'','店名称，生成短信的店名称。',0,'shop_name'),
	(31,'service_tel','5acf2ab9780fb',2,'',0,'','服务电话，用于生成短信内容使用。',0,'service_tel'),
	(32,'user_name','5ad053021201b',2,'',0,'','',0,'user_name'),
	(33,'file_name','5ad053021201b',2,'',0,'','',0,'file_name');

/*!40000 ALTER TABLE `api_fields` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_fields_info
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_fields_info`;

CREATE TABLE `api_fields_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '唯一主键',
  `field` varchar(50) NOT NULL DEFAULT '' COMMENT '字段名',
  `info` varchar(300) NOT NULL DEFAULT '' COMMENT '字段说明',
  PRIMARY KEY (`id`),
  UNIQUE KEY `field` (`field`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='字段说明对应关系';



# Dump of table api_list
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_list`;

CREATE TABLE `api_list` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `apiName` varchar(50) NOT NULL DEFAULT '' COMMENT 'api索引，保存了类和方法',
  `apiUrl` varchar(50) DEFAULT NULL,
  `app_id` int(11) NOT NULL DEFAULT '0' COMMENT '应用ID',
  `hash` varchar(50) NOT NULL DEFAULT '' COMMENT 'api唯一标识',
  `accessToken` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证AccessToken 1：需要，0：不需要',
  `needLogin` tinyint(2) NOT NULL DEFAULT '1' COMMENT '是否需要认证用户token  1：需要 0：不需要',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'API状态：0表示禁用，1表示启用',
  `method` tinyint(2) NOT NULL DEFAULT '2' COMMENT '请求方式0：不限1：Post，2：Get',
  `info` varchar(500) NOT NULL DEFAULT '' COMMENT 'api中文说明',
  `isTest` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否是测试模式：0:生产模式，1：测试模式',
  `returnStr` text COMMENT '返回数据示例',
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用于维护接口信息';

LOCK TABLES `api_list` WRITE;
/*!40000 ALTER TABLE `api_list` DISABLE KEYS */;

INSERT INTO `api_list` (`id`, `apiName`, `apiUrl`, `app_id`, `hash`, `accessToken`, `needLogin`, `status`, `method`, `info`, `isTest`, `returnStr`)
VALUES
	(6,'获取七牛云上传token','Upload/getQiniuUptoken',3,'5acf2ab9780fb',1,0,1,1,'获取七牛云上传token',0,NULL),
	(7,'更新七牛上传文件hash值','Upload/setQiniuUploadHash',3,'5ad053021201b',1,0,1,1,'',0,NULL),
	(8,'发送通知短信','Upload/sendCustomerSms',3,'5ad302e9b70a4',1,0,1,1,'给客户发送通知短信，需要开启短信功能，或单独传入短信内容进行发送。',0,NULL);

/*!40000 ALTER TABLE `api_list` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_menu
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_menu`;

CREATE TABLE `api_menu` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '菜单名',
  `fid` int(11) NOT NULL COMMENT '父级菜单ID',
  `url` varchar(50) NOT NULL DEFAULT '' COMMENT '链接',
  `auth` tinyint(2) NOT NULL DEFAULT '0' COMMENT '访客权限',
  `sort` int(11) NOT NULL DEFAULT '0' COMMENT '排序',
  `hide` tinyint(2) NOT NULL DEFAULT '0' COMMENT '是否显示',
  `icon` varchar(50) NOT NULL DEFAULT '' COMMENT '菜单图标',
  `level` tinyint(2) NOT NULL DEFAULT '0' COMMENT '菜单认证等级',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='目录信息';

LOCK TABLES `api_menu` WRITE;
/*!40000 ALTER TABLE `api_menu` DISABLE KEYS */;

INSERT INTO `api_menu` (`id`, `name`, `fid`, `url`, `auth`, `sort`, `hide`, `icon`, `level`)
VALUES
	(1,'欢迎页',0,'Index/welcome',0,0,0,'',0),
	(2,'系统配置',0,'',0,1,0,'',0),
	(3,'菜单维护',2,'Menu/index',0,0,0,'',0),
	(4,'用户管理',2,'User/index',0,1,0,'',0),
	(5,'权限管理',2,'Permission/index',0,2,0,'',0),
	(6,'操作日志',2,'Log/index',0,3,0,'',0),
	(7,'应用管理',0,'',0,2,0,'',0),
	(8,'应用列表',7,'App/index',0,0,0,'',0),
	(9,'接口列表',7,'ApiManage/index',0,1,0,'',0),
	(10,'字段注解',7,'FieldsInfoManage/index',0,2,1,'',0),
	(11,'首页',0,'Index/index',0,0,1,'',0),
	(12,'新增菜单',3,'Menu/add',0,0,1,'',0),
	(13,'编辑菜单',3,'Menu/edit',0,0,1,'',0),
	(14,'隐藏菜单',3,'Menu/close',0,0,1,'',0),
	(15,'显示菜单',3,'Menu/open',0,0,1,'',0),
	(16,'删除菜单',3,'Menu/del',0,0,1,'',0),
	(17,'新增用户',4,'User/add',0,0,1,'',0),
	(18,'账号封停',4,'User/close',0,0,1,'',0),
	(19,'账号解封',4,'User/open',0,0,1,'',0),
	(20,'账号删除',4,'User/del',0,0,1,'',0),
	(21,'编辑应用',8,'App/edit',0,0,1,'',0),
	(22,'新增应用',8,'App/add',0,0,1,'',0),
	(23,'启用应用',8,'App/open',0,0,1,'',0),
	(24,'禁用应用',8,'App/close',0,0,1,'',0),
	(25,'删除应用',8,'App/del',0,0,1,'',0),
	(26,'新增接口',9,'ApiManage/add',0,0,1,'',0),
	(27,'启用接口',9,'ApiManage/open',0,0,1,'',0),
	(28,'禁用接口',9,'ApiManage/close',0,0,1,'',0),
	(29,'编辑接口',9,'ApiManage/edit',0,0,1,'',0),
	(30,'删除接口',9,'ApiManage/del',0,0,1,'',0),
	(31,'返回字段编辑',9,'FieldsManage/response',0,0,1,'',0),
	(32,'请求字段编辑',9,'FieldsManage/request',0,0,1,'',0),
	(33,'新增字段',9,'FieldsManage/add',0,0,1,'',0),
	(34,'字段编辑',9,'FieldsManage/edit',0,0,1,'',0),
	(35,'批量上传返回字段',9,'FieldsManage/upload',0,0,1,'',0),
	(36,'Ajax查询Log列表',6,'Log/ajaxGetIndex',0,0,1,'',0),
	(37,'日志删除',6,'Log/del',0,0,1,'',0),
	(38,'日志详情查看',6,'Log/showDetail',0,0,1,'',0),
	(39,'添加权限组',5,'Permission/add',0,0,1,'',0),
	(40,'禁用权限组',5,'Permission/close',0,0,1,'',0),
	(41,'启用权限组',5,'Permission/open',0,0,1,'',0),
	(42,'编辑权限组',5,'Permission/edit',0,0,1,'',0),
	(43,'删除权限组',5,'Permission/del',0,0,1,'',0),
	(44,'用户入组',5,'Permission/group',0,0,1,'',0),
	(45,'组用户列表',5,'Permission/member',0,0,1,'',0),
	(46,'踢出成员',5,'Permission/delMember',0,0,1,'',0),
	(47,'权限组权限配置',5,'Permission/rule',0,0,1,'',0),
	(49,'字段删除',34,'FieldsManage/del',0,0,0,'',0),
	(50,'底片管理',0,'',0,3,0,'',0),
	(51,'用户列表',50,'Customer/Index',0,0,0,'',0),
	(52,'用户添加',50,'Customer/add',0,0,1,'',0),
	(53,'禁用',50,'Customer/close',0,0,1,'',0),
	(54,'启用',50,'Customer/open',0,0,1,'',0),
	(55,'删除',50,'Customer/del',0,0,1,'',0),
	(56,'目录管理',50,'Customer/folderList',0,0,1,'',0),
	(57,'添加目录',50,'Customer/folderAdd',0,0,1,'',0),
	(58,'删除目录',50,'Customer/folderDel',0,0,1,'',0),
	(59,'上传文件',50,'Customer/uploadFile',0,0,1,'',0),
	(60,'新增用户',50,'Customer/refresh',0,1,0,'',0),
	(61,'新增所有用户',50,'Customer/addAll',0,2,1,'',0),
	(62,'用户搜索',50,'Customer/search',0,3,1,'',0),
	(63,'指定用户根目录',50,'Customer/setDir',0,4,1,'',0),
	(64,'添加单个用户',50,'Customer/addOne',0,5,1,'',0),
	(65,'分享目录列表',50,'Customer/shareList',0,6,1,'',0),
	(66,'发布',0,'Customer/fabu',0,7,1,'',0),
	(67,'订阅',0,'Customer/dingyue',0,8,1,'',0),
	(68,'test',15,'fgg\\hvgv',0,0,0,'',0),
	(69,'jjjj',59,'kkkk',0,0,0,'',0),
	(70,'系统设定',2,'System/config',0,1,0,'',0);

/*!40000 ALTER TABLE `api_menu` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_user
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_user`;

CREATE TABLE `api_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL DEFAULT '' COMMENT '用户名',
  `nickname` varchar(64) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `password` char(32) NOT NULL DEFAULT '' COMMENT '用户密码',
  `regTime` int(10) NOT NULL DEFAULT '0' COMMENT '注册时间',
  `regIp` varchar(11) NOT NULL DEFAULT '' COMMENT '注册IP',
  `updateTime` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '账号状态 0封号 1正常',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员认证信息';

LOCK TABLES `api_user` WRITE;
/*!40000 ALTER TABLE `api_user` DISABLE KEYS */;

INSERT INTO `api_user` (`id`, `username`, `nickname`, `password`, `regTime`, `regIp`, `updateTime`, `status`)
VALUES
	(1,'root','root','912601e4ad1b308c9ae41877cf6ca754',1492004246,'3682992231',1509352530,1),
	(2,'admin','admin','0d351c5870625e6e692d97256f6c3f62',1509012438,'2130706433',1509019727,1),
	(3,'1234','1234','50ccc9d9832ab568882bb51b245310ff',1509960634,'2130706433',1509960674,1);

/*!40000 ALTER TABLE `api_user` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table api_user_action
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_user_action`;

CREATE TABLE `api_user_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `actionName` varchar(50) NOT NULL DEFAULT '' COMMENT '行为名称',
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '操作用户ID',
  `nickname` varchar(50) NOT NULL DEFAULT '' COMMENT '用户昵称',
  `addTime` int(11) NOT NULL DEFAULT '0' COMMENT '操作时间',
  `data` text COMMENT '用户提交的数据',
  `url` varchar(200) NOT NULL DEFAULT '' COMMENT '操作URL',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户操作日志';



# Dump of table api_user_data
# ------------------------------------------------------------

DROP TABLE IF EXISTS `api_user_data`;

CREATE TABLE `api_user_data` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `loginTimes` int(11) NOT NULL COMMENT '账号登录次数',
  `lastLoginIp` varchar(11) NOT NULL DEFAULT '' COMMENT '最后登录IP',
  `lastLoginTime` int(11) NOT NULL COMMENT '最后登录时间',
  `uid` varchar(11) NOT NULL DEFAULT '' COMMENT '用户ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='管理员数据表';



# Dump of table app_version
# ------------------------------------------------------------

DROP TABLE IF EXISTS `app_version`;

CREATE TABLE `app_version` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `up_time` datetime DEFAULT NULL,
  `up_sql` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='应用版本管理';

LOCK TABLES `app_version` WRITE;
/*!40000 ALTER TABLE `app_version` DISABLE KEYS */;

INSERT INTO `app_version` (`id`, `version`, `up_time`, `up_sql`)
VALUES
	(1,'0.0.1','2018-04-13 12:21:38',' ALTER TABLE `c_customer`  ADD COLUMN `mobile` varchar(50)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' , ADD COLUMN `store_type` tinyint  NOT NULL  DEFAULT 1 \r\n ALTER TABLE `c_customer_folder`  ADD COLUMN `file_hash` varchar(500)  NOT NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' '),
	(2,'0.0.2','2018-04-15 11:45:42','CREATE TABLE `s_config`(`ckey` varchar(50)  NULL  DEFAULT \'\'  COLLATE \'utf8_unicode_ci\' ,`cvalue` text  NOT NULL  COLLATE \'utf8_unicode_ci\' ) COLLATE=\'utf8_unicode_ci\'  ENGINE=InnoDB '),
	(3,'0.0.3','2018-04-25 10:58:07',' ALTER TABLE `c_customer_folder`  ADD COLUMN `down_sum` int  NOT NULL  DEFAULT 0 ');

/*!40000 ALTER TABLE `app_version` ENABLE KEYS */;
UNLOCK TABLES;


# Dump of table c_customer
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customer`;

CREATE TABLE `c_customer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_name` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `nickname` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dir_path` varchar(100) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '用户资料存放路径',
  `status` tinyint(4) DEFAULT '1',
  `mobile` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `shop_code` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `sms_content` text COLLATE utf8_unicode_ci,
  `store_type` tinyint(4) NOT NULL DEFAULT '1',
  `create_time` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;



# Dump of table c_customer_folder
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_customer_folder`;

CREATE TABLE `c_customer_folder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `folder` varchar(100) DEFAULT NULL,
  `file_hash` varchar(500) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `file_key` varchar(500) DEFAULT NULL,
  `down_sum` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table c_share
# ------------------------------------------------------------

DROP TABLE IF EXISTS `c_share`;

CREATE TABLE `c_share` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户ID（customer）里的id',
  `share_code` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '0' COMMENT '分享码',
  `share_dir` varchar(50) COLLATE utf8_unicode_ci DEFAULT '0' COMMENT '用户分享目录（相对用户根目录）',
  PRIMARY KEY (`id`),
  KEY `id` (`id`,`uid`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户分项目录表';



# Dump of table config_customer
# ------------------------------------------------------------

DROP TABLE IF EXISTS `config_customer`;

CREATE TABLE `config_customer` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `ur_path` varchar(50) COLLATE utf8_unicode_ci NOT NULL DEFAULT '' COMMENT '指定用户根目录',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='配置用户指定目录';



# Dump of table s_config
# ------------------------------------------------------------

DROP TABLE IF EXISTS `s_config`;

CREATE TABLE `s_config` (
  `ckey` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `cvalue` text COLLATE utf8_unicode_ci NOT NULL,
  KEY `ckey` (`ckey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

LOCK TABLES `s_config` WRITE;
/*!40000 ALTER TABLE `s_config` DISABLE KEYS */;

INSERT INTO `s_config` (`ckey`, `cvalue`)
VALUES
	('sms_status','on');

/*!40000 ALTER TABLE `s_config` ENABLE KEYS */;
UNLOCK TABLES;



/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
