<?php
// +----------------------------------------------------------------------
// | ThinkPHP [ WE CAN DO IT JUST THINK ]
// +----------------------------------------------------------------------
// | Copyright (c) 2006-2016 http://thinkphp.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 流年 <liu21st@gmail.com>
// +----------------------------------------------------------------------

// 应用公共文件
error_reporting(E_ERROR|E_PARSE);

/**
    * 产生随机字串，可用来自动生成密码
    * 默认长度6位 字母和数字混合 支持中文
    * @param integer $len 长度
    * @param string $type 字串类型
    * 0 字母 1 数字 其它 混合
    * @param string $addChars 额外字符
    * @return string
    */
function get_rand_string($len=6,$type='',$addChars='') {
    $str ='';
    switch($type) {
        case 0:
            $chars='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.$addChars;
            break;
        case 1:
            $chars= str_repeat('0123456789',3);
            break;
        case 2:
            $chars='ABCDEFGHIJKLMNOPQRSTUVWXYZ'.$addChars;
            break;
        case 3:
            $chars='abcdefghijklmnopqrstuvwxyz'.$addChars;
            break;
        case 4:
            $chars = "们以我到他会作时要动国产的一是工就年阶义发成部民可出能方进在了不和有大这主中人上为来分生对于学下级地个用同行面说种过命度革而多子后自社加小机也经力线本电高量长党得实家定深法表着水理化争现所二起政三好十战无农使性前等反体合斗路图把结第里正新开论之物从当两些还天资事队批点育重其思与间内去因件日利相由压员气业代全组数果期导平各基或月毛然如应形想制心样干都向变关问比展那它最及外没看治提五解系林者米群头意只明四道马认次文通但条较克又公孔领军流入接席位情运器并飞原油放立题质指建区验活众很教决特此常石强极土少已根共直团统式转别造切九你取西持总料连任志观调七么山程百报更见必真保热委手改管处己将修支识病象几先老光专什六型具示复安带每东增则完风回南广劳轮科北打积车计给节做务被整联步类集号列温装即毫知轴研单色坚据速防史拉世设达尔场织历花受求传口断况采精金界品判参层止边清至万确究书术状厂须离再目海交权且儿青才证低越际八试规斯近注办布门铁需走议县兵固除般引齿千胜细影济白格效置推空配刀叶率述今选养德话查差半敌始片施响收华觉备名红续均药标记难存测士身紧液派准斤角降维板许破述技消底床田势端感往神便贺村构照容非搞亚磨族火段算适讲按值美态黄易彪服早班麦削信排台声该击素张密害侯草何树肥继右属市严径螺检左页抗苏显苦英快称坏移约巴材省黑武培著河帝仅针怎植京助升王眼她抓含苗副杂普谈围食射源例致酸旧却充足短划剂宣环落首尺波承粉践府鱼随考刻靠够满夫失包住促枝局菌杆周护岩师举曲春元超负砂封换太模贫减阳扬江析亩木言球朝医校古呢稻宋听唯输滑站另卫字鼓刚写刘微略范供阿块某功套友限项余倒卷创律雨让骨远帮初皮播优占死毒圈伟季训控激找叫云互跟裂粮粒母练塞钢顶策双留误础吸阻故寸盾晚丝女散焊功株亲院冷彻弹错散商视艺灭版烈零室轻血倍缺厘泵察绝富城冲喷壤简否柱李望盘磁雄似困巩益洲脱投送奴侧润盖挥距触星松送获兴独官混纪依未突架宽冬章湿偏纹吃执阀矿寨责熟稳夺硬价努翻奇甲预职评读背协损棉侵灰虽矛厚罗泥辟告卵箱掌氧恩爱停曾溶营终纲孟钱待尽俄缩沙退陈讨奋械载胞幼哪剥迫旋征槽倒握担仍呀鲜吧卡粗介钻逐弱脚怕盐末阴丰雾冠丙街莱贝辐肠付吉渗瑞惊顿挤秒悬姆烂森糖圣凹陶词迟蚕亿矩康遵牧遭幅园腔订香肉弟屋敏恢忘编印蜂急拿扩伤飞露核缘游振操央伍域甚迅辉异序免纸夜乡久隶缸夹念兰映沟乙吗儒杀汽磷艰晶插埃燃欢铁补咱芽永瓦倾阵碳演威附牙芽永瓦斜灌欧献顺猪洋腐请透司危括脉宜笑若尾束壮暴企菜穗楚汉愈绿拖牛份染既秋遍锻玉夏疗尖殖井费州访吹荣铜沿替滚客召旱悟刺脑措贯藏敢令隙炉壳硫煤迎铸粘探临薄旬善福纵择礼愿伏残雷延烟句纯渐耕跑泽慢栽鲁赤繁境潮横掉锥希池败船假亮谓托伙哲怀割摆贡呈劲财仪沉炼麻罪祖息车穿货销齐鼠抽画饲龙库守筑房歌寒喜哥洗蚀废纳腹乎录镜妇恶脂庄擦险赞钟摇典柄辩竹谷卖乱虚桥奥伯赶垂途额壁网截野遗静谋弄挂课镇妄盛耐援扎虑键归符庆聚绕摩忙舞遇索顾胶羊湖钉仁音迹碎伸灯避泛亡答勇频皇柳哈揭甘诺概宪浓岛袭谁洪谢炮浇斑讯懂灵蛋闭孩释乳巨徒私银伊景坦累匀霉杜乐勒隔弯绩招绍胡呼痛峰零柴簧午跳居尚丁秦稍追梁折耗碱殊岗挖氏刃剧堆赫荷胸衡勤膜篇登驻案刊秧缓凸役剪川雪链渔啦脸户洛孢勃盟买杨宗焦赛旗滤硅炭股坐蒸凝竟陷枪黎救冒暗洞犯筒您宋弧爆谬涂味津臂障褐陆啊健尊豆拔莫抵桑坡缝警挑污冰柬嘴啥饭塑寄赵喊垫丹渡耳刨虎笔稀昆浪萨茶滴浅拥穴覆伦娘吨浸袖珠雌妈紫戏塔锤震岁貌洁剖牢锋疑霸闪埔猛诉刷狠忽灾闹乔唐漏闻沈熔氯荒茎男凡抢像浆旁玻亦忠唱蒙予纷捕锁尤乘乌智淡允叛畜俘摸锈扫毕璃宝芯爷鉴秘净蒋钙肩腾枯抛轨堂拌爸循诱祝励肯酒绳穷塘燥泡袋朗喂铝软渠颗惯贸粪综墙趋彼届墨碍启逆卸航衣孙龄岭骗休借".$addChars;
            break;
        default :
            // 默认去掉了容易混淆的字符oOLl和数字01，要添加请使用addChars参数
            $chars='ABCDEFGHIJKMNPQRSTUVWXYZabcdefghijkmnpqrstuvwxyz23456789'.$addChars;
            break;
    }
    if($len>10 ) {//位数过长重复字符串一定次数
        $chars= $type==1? str_repeat($chars,$len) : str_repeat($chars,5);
    }
    if($type!=4) {
        $chars   =   str_shuffle($chars);
        $str     =   substr($chars,0,$len);
    }else{
        // 中文随机字
        for($i=0;$i<$len;$i++){
          $str.= self::msubstr($chars, floor(mt_rand(0,mb_strlen($chars,'utf-8')-1)),1,'utf-8',false);
        }
    }
    return $str;
}
/**
 * http_request的重写，只返回response,如果需要返回http_code 以及request信息，请调用http_request
 * 
 * @param $url 请求url地址
 * @param $method 请求方法 get post
 * @param null $postfields post数据数组
 * @param array $headers 请求header信息
 * @param bool|false $debug  调试开启 默认false
 * @return mixed
 * @author songdemei<songdemei@suxuantech.cn>
 */
function httpRequest($url, $method="GET", $postfields = null, $headers = array(), $debug = false,$timeOut = 60) {
    $res = http_request($url, $method, $postfields, $headers, $debug,$timeOut);
    return $res['response'];
}

/**
 * 方法描述     检测一个用户的信息是否有缓存没有取
 * @param  array $d 必须单元：userid 或者 phone+brandid ;可选单元字段：fields 是要返回的字段用','分隔的字符串，如$data['fields'] ='userid,phone';
 * @param  return array;
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
function getUserInfo($d) {
    if(!$d){
        return false;
    }
    //判断当前登录是否为集团会员
    if($d['brandid']){
        $conf_brandid = db_config('sx_brand');
        if($d['brandid'] == $conf_brandid){
        	$d['brandid'] = 0;
        }
    }
    $cacheid = '';
    if($d['phoneid']){
        $cacheid = 'phoneid_'.$d['phone'];
    }else if($d['phone'] && $d['brandid']){
        $cacheid = $d['brandid'].'_'.$d['phone'];
    }else if($d['userid']){
        $cacheid = $d['userid'];
    }
    $phoneFields = 'p.id,p.money,p.growth_value,p.total_score,p.total_sign,p.username,p.phone,p.sex,p.brandid,p.userid,p.user_number,p.last_land_time,p.brandid,p.merryday,p.brithday,p.update_time,p.agent_status';
    $usersFields = 'u.id,u.phone,u.growth_value,u.total_sign,u.total_score,u.username,u.simg,u.openid,u.sex,u.create_time,u.last_land_time,u.brandid,u.merryday,u.brithday,u.update_time';
    $usersAliasFields = 'u.id as uid,u.level as ulevel,u.growth_value as ugrowth_value,u.total_sign as utotal_sign,u.sex as usex,u.total_score as utotal_score,u.username as uusername,u.simg,u.openid,u.create_time as ucreate_time,u.last_land_time as ulast_land_time,u.brandid as ubrandid,u.merryday as umerryday,u.brithday as ubrithday,u.update_time as uupdate_time,u.share_userid';
    //$userinfo = cache('userinfo_'.$cacheid);
    //if(!$userinfo){
    if(1){//？？？什么意思？？？
        
        $addFields = 'u.openid';
        // 
        if($d['fields']){
            $hasOpenid = 0;
            $findFieldsArr = explode(',',$d['fields']);
            for($i=0;$i<count($findFieldsArr);$i++){
               
                if($findFieldsArr[$i]!='money'){
                    if($findFieldsArr[$i]!='user_number'){
                        $usersFieldsArr[]      = 'u.'.$findFieldsArr[$i];
                        if($findFieldsArr[$i] != 'openid'){
                            $usersAliasFieldsArr[] = 'u.'.$findFieldsArr[$i].' as u'.$findFieldsArr[$i];
                        }else{
                            $usersAliasFieldsArr[] = 'u.'.$findFieldsArr[$i];
                            $hasOpenid = 1;
                        }
                    }
                }
                if($findFieldsArr[$i]=='openid'){
                    continue;
                }
                $phoneFieldsArr[]      = 'p.'.$findFieldsArr[$i];
            }
            $phoneFields = implode(',',$phoneFieldsArr);
            $usersFields = implode(',',$usersFieldsArr);
            $usersAliasFields = implode(',',$usersAliasFieldsArr);
            $addFields = '';
        }
        
        if($d['phoneid']){    
            $userinfo = db('m_users_phone')
                        ->alias('p')
                        ->join('m_users u','u.id=p.userid','left')
                        ->field($addFields)
                        ->field($phoneFields)
                        ->where(['p.id'=>$d['phoneid']])
                        ->find();
        }else if($d['phone'] && $d['brandid']){
             
            $w = ['p.phone'=>$d['phone'],'p.brandid'=>$d['brandid']];
            $userinfo = db('m_users_phone')
                        ->alias('p')
                        ->field($phoneFields)
                        ->field($addFields)
                        ->join('m_users u','u.id=p.userid','left')
                        ->where($w)
                        ->find();
            if($userinfo && !$d['fields']){
                //cache($cacheid.'_userinfo',$userinfo);
            }
        }else if($d['userid'] || $d['openid']){
            if($d['openid']){
                $w = ['u.openid'=>$d['openid']];
                if($d['brand_id']){
                    $w['u.brandid'] = $d['brand_id'];
                }
            }else{
                $w = ['u.id'=>$d['userid']];
            }
            $userinfo = db('m_users')
                        ->alias('u')
                        ->field($usersAliasFields)
                        ->field($phoneFields)
                        ->join('m_users_phone p','u.id=p.userid','left')
                        ->where($w)
                        ->find();
            if($userinfo && !$userinfo['phone'] && !$d['fields']){
                $fildsArr = explode(',',$usersFields);
                for($i=0;$i<count($fildsArr);$i++){
                    $fieldname = substr($fildsArr[$i],2);
                    if($fieldname=='openid'){
                        continue;
                    }
                    //echo substr($fildsArr[$i],2);die;
                    $userinfo[substr($fildsArr[$i],2)] = $userinfo['u'.substr($fildsArr[$i],2)];
                    unset($userinfo['u'.substr($fildsArr[$i],2)]);
                }
            }
            if($userinfo){
                $fildsArr = explode(',',$usersFields);
                for($i=0;$i<count($fildsArr);$i++){
                    $fieldname = substr($fildsArr[$i],2);
                    if($fieldname=='openid' || $fieldname=='money'){
                        continue;
                    }
                    //echo $userinfo['u'.substr($fildsArr[$i],2)];
                    unset($userinfo['u'.substr($fildsArr[$i],2)]);
                }
            }
            //print_r($userinfo);die;
            if($userinfo && !$d['fields']){
                //cache($d['userid'].'_userinfo',$userinfo);
            }

        }
        //echo db()->getLastSql();
        return $userinfo?$userinfo:false;
    }
    return $userinfo;
}

/**
 * 方法描述     获取当前用户登录级别数据-----------弃用
 * @param  array $data 必须单元：userid 或者 phone+brandid 可选字段：fields 是要返回的字段用','分隔的字符串，如$data['fields'] ='userid,phone';
 * @param  return array;
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
function getLevel ($d) {
    if(!$d){
        return false;
    }
    $cacheid = '';
    if($d['phone'] && $d['brandid']){
        $cacheid = $d['brandid'].'_'.$d['phone'];    
    }else if($d['userid']){
        $cacheid = $d['userid'];
    }
    // 获取用户缓存的级别信息
    $cachekey = 'levelInfo_'.$cacheid;
    $levelData = cache($cachekey);
    if($levelData){
       //return $levelData;
    }
    $findId = ['userid'=>$d['userid']];
    if($d['phoneid']){
        $findId = ['phoneid'=>$d['phoneid']];
    }else if($d['phone'] && $d['brandid']){
        $findId = ['phone'=>$d['phone'],'brandid'=>$d['brandid']];
    }
    $memData = getUserInfo($findId);
    if(!$memData){
        return false;
    }
    $memGrowValue = (int)$memData['growth_value'];
    $brandId = $memData['brandid'];
    
    $where = [
        'max_value' => ['<',$memGrowValue],
        /*'brandid'   => $brandId,//暂时勿略品牌找用户等级，后面要做一个多事业部共一个等级数据的处理方案-SDM*/
    ];
    if(!$memGrowValue){
        $where['max_value'] = 0;
    }
    if($d['biger']){
        $where['max_value'] = ['>',$memGrowValue];
    }
    $fields = $d['fields'];
    if(!$fields){
        $fields = 'id,name,max_value,img,discount';
    }
    $levelData = db('user_level')->where($where)->field($fields)->order('max_value DESC')->find();
    if($levelData && !$d['fields']){
        //cache($cachekey,$levelData);
    }
    return $levelData?$levelData:false;

}

/**
 * 方法描述     积分日志方法
 * @return mixed
 * $title 标题
 * $minute 积分值
 * $userid 执行人
 * $type 类型 0后台修改，1首次登录、每日登录，2完成任务，3绑定手机，8推荐用户，9修改资料，11分享活动，12分享任务，13分享助力活动，14线下订单积分，15经纪人佣金
 * $phoneid 手机表里的id
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
function minuteDetailed ($title,$minute,$userid,$type,$phoneid) {
    $datas = array(
        'm_title'=> $title,
        'm_num'  => (int)$minute,
        'm_time' => date('Y-m-d H:i:s'),
        'm_executor'=> (int)$userid,
        'm_type'=> (int)$type,
        'iswid' => (int)$phoneid?0:1,
        'users_phone_id'=>(int)$phoneid,
    );

    if(!$datas['m_executor']&&!$phoneid){
        return false;
    }

    if($datas['m_num']){
        $minuteDetailed = db('minute_log')->insert($datas);
        return $minuteDetailed?true:false;
    }
    return true;
}
/**
 * 方法描述     查询该用户当天有没有领取成长值方法
 * @return mixed $title 标题 $minute 积分值 $userid 执行人  $type 类型  $phoneid 当前用户绑定的手机表里的id
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
function growthMemRecord ($userid,$type,$taskid) {
    $userid  = (int)$userid;
    $type    = (int)$type;
    $taskid  = (int)$taskid;
    if(!$userid){
        return false;
    }
    $todayStart = date('Y-m-d',time());
    //$todayEnd   = date('Y-m-d H:i:s',(strtotime($todayStart)+86399));
    $data = db('growth_log')->where(['graowth_time'=>['>=',$todayStart],'graowth_type'=>$type,'graowth_tid'=>$taskid,'userid'=>$userid])->count();
    return $data?true:false;
}

/**
 *   记录成长值日志,并更新用户表成成长值
 * @return mixed
 * $userid 执行人;
 * $minute; 积分值
 * $type    成长值类型 1每天登录2每天签到3领取任务4做任务5推荐新人6报名活动7浏览活动8是分享9绑定手机号
 * $taskid  若类型是分享，记录活动id
 * $phoneid 当前用户绑定的手机表里的id
 * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月16日
 */
function growthDetailed ($userid,$minute,$type,$taskid=0,$phoneid=0) {

    $datas = array(
        'graowth_num'  => (int)$minute,
        'graowth_time' => date('Y-m-d H:i:s'),
        'userid' => (int)$userid,
        'graowth_type'=> (int)$type,
        'graowth_tid' => (int)$taskid,
        'iswid'       => (int)$phoneid?0:1
    );
    if(!$datas['userid']){
        return false;
    }

    if($datas['graowth_num']){

        db()->startTrans();
        try{

            db('growth_log')->insert($datas);
            if(!$datas['iswid']){
                db('m_users_phone')->where('userid','=',$userid)->setInc('growth_value',$datas['graowth_num']);
            }else{
                db('m_users')->where('id','=',$userid)->setInc('growth_value',$datas['graowth_num']);
            }
            db()->commit();
            return true;
        }catch (Exception $d){
            db()->rollback();
            return false;
        }

    }
    return true;

}

/**
 * 方法描述     获取当前用户成长值规则
 * @param  array $d 必须单元：userid 或者 phone+brandid 可选字段：fields 是要返回的字段用','分隔的字符串，如$data['fields'] ='userid,phone';
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
 */
function getGrowthRule ($d) {
    if(!$d){
        return false;
    }
    $cacheid = '';
    if($d['phoneid']){
        $cacheid = 'phoneid_'.$d['phoneid'];
    }else if($d['phone'] && $d['brandid']){
        $cacheid = 'brand_'.$d['brandid'].'_'.$d['phone'];
    }else if($d['userid']){
        $cacheid = 'userid_'.$d['userid'];
    }
    if($cacheid){
        $cachekey = 'growthRule_'.$cacheid;
        $growthRule = cache($cachekey);
        if($growthRule){
            return $growthRule;
        }
        $findId = ['userid'=>$d['userid']];
        if($d['phoneid']){
            $findId = ['phoneid'=>$d['phoneid']];
        }else if($d['phone'] && $d['brandid']){
            $findId = ['phone'=>$d['phone'],'brandid'=>$d['brandid']];
        }
        $levelInfo = getLevel($findId);
        if($levelInfo){
                $growthRule = db('growth_rule')->where('levelid','=',$levelInfo['id'])->find();
                if(!$growthRule){
                    $userinfo = getUserInfo($findId);
                    $levels   = getBrandidLevels($userinfo['brandid']);
                    
                    for($i=0;$i<count($levels);$i++){
                        if($levels[$i]['id']==$levelInfo['id']){
                            continue;
                        }
                        $w = ['levelid'=>$levels[$i]['id']];
                        $growthRule = db('growth_rule')->where($w)->find();

                        if($growthRule){
                            break;
                        }
                    }
                }
                $growthRule = json_decode($growthRule['detail'],true);
                if($growthRule){
                    cache($cachekey,$growthRule);
                    return $growthRule;
                }
                return false;
        }
        return false;
    }
    return false;
}

/**
 * 方法描述     获取成积分规则
 * @param  array $d 必须单元：userid 或者 phone+brandid
 * @return mixed 
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月19日 下午12:45:53
 */
function getScoreRule ($d) {
    if(!$d){
        return false;
    }
    $cacheid = '';
    if($d['phone'] && $d['brandid']){
        $cacheid = $d['brandid'].'_'.$d['phone'];
    }else if($d['userid']){
        $cacheid = $d['userid'];
    }
    if($cacheid){
        $cachekey  = 'scoreRule_'.$cacheid;
        $scoreRule = cache($cachekey);
        if($scoreRule){
            //return $scoreRule;
        }
        $findId = ['userid'=>$d['userid']];
        if($d['phoneid']){
            $findId = ['phoneid'=>$d['phoneid']];
        }else if($d['phone'] && $d['brandid']){
            $findId = ['phone'=>$d['phone'],'brandid'=>$d['brandid']];
        }

        $levelInfo = getLevel($findId);

        if($levelInfo){
            $scoreRule = db('s_score_rule')->where('levelid','=',$levelInfo['id'])->find();
            if(!$scoreRule){
                $userinfo = getUserInfo($findId);
                $levels   = getBrandidLevels($userinfo['brandid']);
                for($i=0;$i<count($levels);$i++){
                    if($levels[$i]['id']==$levelInfo['id']){
                        continue;
                    }
                    $w = ['levelid'=>$levels[$i]['id']];
                    $scoreRule = db('s_score_rule')->where('levelid','=',$levels[$i]['id'])->find();
                    if($scoreRule){
                        break;
                    }
                }
            }
            $scoreRule = json_decode($scoreRule['detail'],true);
            if($scoreRule){
                //cache($cachekey,$scoreRule);
            }
            return $scoreRule;
        }
        return false;
    }
    return false;
}

/**
 * 方法描述     一个品牌下的所有等级数据
 * @param  int $brandid 品牌id
 * @return mixed
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月19日 下午12:45:53
 */
function  getBrandidLevels ($brandid) {
    if($brandid){
        $cachekey = 'brandLevels_'.$brandid;
        $levels   = cache($cachekey);
        if(!$levels){
            $w = ['brandid'=>$brandid];
            $levels = db('user_level')->where($w)

            ->field('id,name,max_value')
            ->order('max_value desc')
            ->fetchSql()
            ->select();
        }
        return  $levels;
    }
    return false;
}



/**
 * 方法描述     拼接查询条件
 * @param  int $userid  
 * @param  int $phoneid  
 * @param  string $useridFieldName 数据表里代表userid的字段名称
 * @param  string $perfix 
 * @return string 返回拼接后的查询条件
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月19日 下午12:45:53
 */
function makeWhere($userid=0,$phoneid=0,$useridFieldName='',$perfix=''){
    if(!$userid && !$phoneid){
        return false;
    }
    $useridFieldName = $useridFieldName?$useridFieldName:'userid';
    $iswid = 'iswid';
    $where = '';
    if($perfix){
        $useridFieldName = $perfix.'.'.$useridFieldName;
        $iswid = $perfix.'.iswid';
    }
    if($userid && $phoneid){
        $where .= " (($useridFieldName=$userid and $iswid=1) or ($useridFieldName=$phoneid and $iswid=0))";
    }else if(!$userid && $phoneid){
        $where .= " ($useridFieldName=$phoneid and $iswid=0)";
    }else{
        $where .= " ($useridFieldName=$userid and $iswid=1)";
    }
    return $where;
}


/**
 * CURL请求
 * @param $url 请求url地址
 * @param $method 请求方法 get post
 * @param null $postfields post数据数组
 * @param array $headers 请求header信息
 * @param bool|false $debug  调试开启 默认false
 * @return array();<br/>
 * code:http状态码；
 * response：响应内容；
 * request:请求信息；
 * @author songdemei<songdemei@suxuantech.cn>
 */
function http_request($url, $method="GET", $postfields = null, $headers = array(), $debug = false,$timeOut = 60) {
    $method = strtoupper($method);
    $ci = curl_init();
    $contentLength = 0;
    /* Curl settings */
    curl_setopt($ci, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
    curl_setopt($ci, CURLOPT_USERAGENT, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/61.0.3163.100 Safari/537.36");
    curl_setopt($ci, CURLOPT_CONNECTTIMEOUT, $timeOut); /* 在发起连接前等待的时间，如果设置为0，则无限等待 */
    curl_setopt($ci, CURLOPT_TIMEOUT, $timeOut); /* 设置cURL允许执行的最长秒数 */
    curl_setopt($ci, CURLOPT_RETURNTRANSFER, true);
    switch ($method) {
        case "POST":
            curl_setopt($ci, CURLOPT_POST, true);
            if (!empty($postfields)) {
                $tmpdatastr = is_array($postfields) ? http_build_query($postfields) : $postfields;
                $contentLength = strlen($tmpdatastr);
                curl_setopt($ci, CURLOPT_POSTFIELDS, $tmpdatastr);
            }
            break;
        default:
            curl_setopt($ci, CURLOPT_CUSTOMREQUEST, $method); /* //设置请求方式 */
            break;
    }
    $ssl = preg_match('/^https:\/\//i',$url) ? TRUE : FALSE;
    curl_setopt($ci, CURLOPT_URL, $url);
    if($ssl){
        curl_setopt($ci, CURLOPT_SSL_VERIFYPEER, FALSE); // https请求 不验证证书和hosts
        curl_setopt($ci, CURLOPT_SSL_VERIFYHOST, FALSE); // 不从证书中检查SSL加密算法是否存在
    }
    //curl_setopt($ci, CURLOPT_HEADER, true); /*启用时会将头文件的信息作为数据流输出*/
    curl_setopt($ci, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ci, CURLOPT_MAXREDIRS, 2);/*指定最多的HTTP重定向的数量，这个选项是和CURLOPT_FOLLOWLOCATION一起使用的*/
    $headers[] = "Content-Length: ".$contentLength;
    curl_setopt($ci, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ci, CURLINFO_HEADER_OUT, true);
    /*curl_setopt($ci, CURLOPT_COOKIE, $Cookiestr); * *COOKIE带过去** */
    $response = curl_exec($ci);
    $requestinfo = curl_getinfo($ci);
    $http_code = curl_getinfo($ci, CURLINFO_HTTP_CODE);
    if ($debug) {
        echo "=====post data======\r\n";
        var_dump($postfields);
        echo "=====info===== \r\n";
        print_r($requestinfo);
        echo "=====response=====\r\n";
        print_r($response);
    }
    curl_close($ci);
    //return $response;
    return array('code'=>$http_code, 'response'=>$response,'request'=>$requestinfo);
}


function upload_http($url, $filedata) {
    $curl = curl_init ();
    if (class_exists ( '/CURLFile' )) {//php5.5跟php5.6中的CURLOPT_SAFE_UPLOAD的默认值不同
        curl_setopt ( $curl, CURLOPT_SAFE_UPLOAD, true );
    } else {
        if (defined ( 'CURLOPT_SAFE_UPLOAD' )) {
            curl_setopt ( $curl, CURLOPT_SAFE_UPLOAD, false );
        }
    }
    curl_setopt ( $curl, CURLOPT_URL, $url );
    curl_setopt ( $curl, CURLOPT_SSL_VERIFYPEER, FALSE );
    curl_setopt ( $curl, CURLOPT_SSL_VERIFYHOST, FALSE );
    if (! empty ( $filedata )) {
        curl_setopt ( $curl, CURLOPT_POST, 1 );
        curl_setopt ( $curl, CURLOPT_POSTFIELDS, $filedata );
    }
    curl_setopt ( $curl, CURLOPT_RETURNTRANSFER, 1 );
    $output = curl_exec ( $curl );
    curl_close ( $curl );
    return $output;
}


/**
 * 获取客户端IP地址
 * @param integer $type 返回类型 0 返回IP地址 1 返回IPV4地址数字
 * @param boolean $adv 是否进行高级模式获取（有可能被伪装） 
 * @return mixed
 */
function get_client_ip($type = 0,$adv=false) {
    $type       =  $type ? 1 : 0;
    static $ip  =   NULL;
    if ($ip !== NULL) return $ip[$type];
    if($adv){
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $arr    =   explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            $pos    =   array_search('unknown',$arr);
            if(false !== $pos) unset($arr[$pos]);
            $ip     =   trim($arr[0]);
        }elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ip     =   $_SERVER['HTTP_CLIENT_IP'];
        }elseif (isset($_SERVER['REMOTE_ADDR'])) {
            $ip     =   $_SERVER['REMOTE_ADDR'];
        }
    }elseif (isset($_SERVER['REMOTE_ADDR'])) {
        $ip     =   $_SERVER['REMOTE_ADDR'];
    }
    // IP地址合法验证
    $long = sprintf("%u",ip2long($ip));
    $ip   = $long ? array($ip, $long) : array('0.0.0.0', 0);
    return $ip[$type];
}

/**
 * 发送HTTP状态
 * @param integer $code 状态码
 * @return void
 */
function send_http_status($code) {
    static $_status = array(
            // Informational 1xx
            100 => 'Continue',
            101 => 'Switching Protocols',
            // Success 2xx
            200 => 'OK',
            201 => 'Created',
            202 => 'Accepted',
            203 => 'Non-Authoritative Information',
            204 => 'No Content',
            205 => 'Reset Content',
            206 => 'Partial Content',
            // Redirection 3xx
            300 => 'Multiple Choices',
            301 => 'Moved Permanently',
            302 => 'Moved Temporarily ',  // 1.1
            303 => 'See Other',
            304 => 'Not Modified',
            305 => 'Use Proxy',
            // 306 is deprecated but reserved
            307 => 'Temporary Redirect',
            // Client Error 4xx
            400 => 'Bad Request',
            401 => 'Unauthorized',
            402 => 'Payment Required',
            403 => 'Forbidden',
            404 => 'Not Found',
            405 => 'Method Not Allowed',
            406 => 'Not Acceptable',
            407 => 'Proxy Authentication Required',
            408 => 'Request Timeout',
            409 => 'Conflict',
            410 => 'Gone',
            411 => 'Length Required',
            412 => 'Precondition Failed',
            413 => 'Request Entity Too Large',
            414 => 'Request-URI Too Long',
            415 => 'Unsupported Media Type',
            416 => 'Requested Range Not Satisfiable',
            417 => 'Expectation Failed',
            // Server Error 5xx
            500 => 'Internal Server Error',
            501 => 'Not Implemented',
            502 => 'Bad Gateway',
            503 => 'Service Unavailable',
            504 => 'Gateway Timeout',
            505 => 'HTTP Version Not Supported',
            509 => 'Bandwidth Limit Exceeded'
    );
    if(isset($_status[$code])) {
        header('HTTP/1.1 '.$code.' '.$_status[$code]);
        // 确保FastCGI模式下正常
        header('Status:'.$code.' '.$_status[$code]);
    }
}

function api_check_login($sessionId='') {
    $sessionId = $sessionId?$sessionId:input('post.session_id');
    $loginInfo = db('s_session')->where('session_id', $sessionId)->find();
    if(!$loginInfo){
        return false;
    }
    if(time() > $loginInfo['expire_time']){
        //登录是否过期
        return false;
    }
    return $loginInfo;
    
}
/**
 * 正常业务访问时，判断用户是否登录使用。此处只判断是否登录，如何处理，由调用处进行处理。
 * 
 * @return boolean
 */
function check_login() {
    if(!empty(session('staff_id'))){
        
        return true;
    }else{
        return false;
    }

}
/**
 * 把数据按key=value方式，使用&连接起来。
 * 
 * @param type $array
 * @return type String
 */
function arrayToParams($array){
    $ret = '';
    foreach($array as $k=>$v){
        $ret .= $k.'='.$v.'&';
    }
    $ret = trim($ret,'&');
    return $ret;
}
/**
 * 验证POST数据的access token签名是否正确。
 * 
 * @param String $appSecret 当前请求接口的应用密钥
 * @param String $accessToken 当前请求头信息内的token
 * 
 * @return boolean  验证通过返回true,验证失败返回false
 */
function checkAccessToken($appSecret,$accessToken) {
    $params = input('post.');
    unset($params['action'],$params['method']);
    ksort($params);
    $tokenStr = arrayToParams($params).$appSecret;
    //var_dump($tokenStr);
    if($accessToken != md5($tokenStr)){
        return false;
    }
    return true;
}
/**
 * 记录API访问日志
 * 
 * @param type $logInfo
 */
function apiLog($logInfo) {
//    var_dump($logInfo);
//    exit();
    $logInfo['create_time'] = date('Y-m-d H:i:s');
    $logInfo['create_ip'] = get_client_ip();
    $res = db('api_logs','db_logs')->insert($logInfo);
    if(!$res){
        
    }
}
function api_log($logInfo){
    apiLog($logInfo);
}

/**
 * 操作日志记录，此日志需要在代码里手动记录。<br/>
 * 需要在application的common里面有model/actionLog.php的model类<br/>
 * 记录的module/controller/action如果不输入，为请求进来的，针对于API接口。因为做了单独调用，固需要手动指定一下<br/>
 * 
 * @param Mix $data        本次要记录的日志数据
 * @param Mix $oldData     修改前的数据
 * @param Int $customerId      当前操作的客户ID。
 * @param Int $staffId      当前登录员工ID，默认取session内的staff_id,针对API记录，需要手动传入。
 * @param Int $staffName      当前登录员工姓名
 * @param String $module      操作的模块，默认取当前请求的应用模块
 * @param String $controller  操作的控制器，默认取当前请求的控制器
 * @param String $action      操作的方法，默认取当前请求的方法
 */
function action_log($data,$oldData,$customerId = 0,$staffId = 0,$staffName='',$module='',$controller = '',$action=''){
    if(!$module){
        $module = \think\Request::instance()->module();
    }
    if(!$controller){
        $controller = \think\Request::instance()->controller();
    }
    if(!$action){
        $action = \think\Request::instance()->action();
    }
    if(!is_string($data)){
        $data = json_encode($data);
    }
    if(!is_string($oldData)){
        $oldData = json_encode($oldData);
    }
    $log = model('ActionLog');
    $log->old_data = $oldData;
    $log->data = $data;
    $log->action = $action;
    $log->controller = $controller;
    $log->module = $module;
    //$log->customer_id = $customerId;
    $log->staff_id = $staffId?$staffId:(int)session('staff_id');
    $log->staff_name = $staffName?$staffName:session('staffname');
    $log->startTrans();
    $res = $log->save();
    if($res === false){
        $log->rollBack();
        \think\Log::error('日志保存错误:module:'.$module.';controller:'.$controller.';action:'.$action.';data:'.$data.';olddata:'.$oldData.';customerid:'.$customerId);       
    }else{
        $log->commit();
    }
}
/**
 * 素玄内部接口调用
 * 
 * @param type $interfaceHash
 * @param type $data
 * @param type $system
 * @param type $sessionId
 * @return string
 */
function sx_call($interfaceHash,$data,$system='sx_mc',$sessionId='') {
    $param = '';
    $system = $system?$system:'sx_mc';
    $ret = array('errid'=>0,'data'=>[]);
    foreach ($data as $k=>$v){
        if(is_null($v)){
            unset($data[$k]);
        }
    }
    if(!empty($data)){
        ksort($data);
        $param = arrayToParams($data);
    }
    $appConfig = config('ext.app_config');
    $secret = config('ext.app_secret');     //$appConfig[strtolower($system)]['secret'];
    if(key_exists(strtolower($system), $appConfig)){
        $addr = $appConfig[strtolower($system)]['addr'];
        if(substr($addr,-1) != '/'){
            $addr .= '/';
        }
        $addr .= 'api/'.$interfaceHash;

    }else{
        $ret['error'] = '当前系统未安装应用：'.$system;
        return $ret;
    }
    $param .= $secret;
    $token = md5($param);
    $header = array('ACCESS-TOKEN: '.$token);
    if($sessionId){
        $header[] = 'SESSION-ID: '.$sessionId;
    }
    return json_decode(httpRequest($addr, 'POST', $data, $header),true);
    
}


/**
 * 系统加密方法
 * @param string $data 要加密的字符串
 * @param string $key  加密密钥
 * @param int $expire  过期时间 单位 秒
 * @return string
 */
function think_encrypt($data, $key = '', $expire = 0) {
    $key  = md5(empty($key) ? config('AUTH_KEY') : $key);
    $data = base64_encode($data);
    $x    = 0;
    $len  = strlen($data);
    $l    = strlen($key);
    $char = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    $str = sprintf('%010d', $expire ? $expire + time():0);

    for ($i = 0; $i < $len; $i++) {
        $str .= chr(ord(substr($data, $i, 1)) + (ord(substr($char, $i, 1)))%256);
    }
    return str_replace(array('+','/','='),array('-','_',''),base64_encode($str));
}

/**
 * 系统解密方法
 * @param  string $data 要解密的字符串 （必须是think_encrypt方法加密的字符串）
 * @param  string $key  加密密钥
 * @return string
 */
function think_decrypt($data, $key = ''){
    $key    = md5(empty($key) ? config('AUTH_KEY') : $key);
    $data   = str_replace(array('-','_'),array('+','/'),$data);
    $mod4   = strlen($data) % 4;
    if ($mod4) {
       $data .= substr('====', $mod4);
    }
    $data   = base64_decode($data);
    $expire = substr($data,0,10);
    $data   = substr($data,10);

    if($expire > 0 && $expire < time()) {
        return '';
    }
    $x      = 0;
    $len    = strlen($data);
    $l      = strlen($key);
    $char   = $str = '';

    for ($i = 0; $i < $len; $i++) {
        if ($x == $l) $x = 0;
        $char .= substr($key, $x, 1);
        $x++;
    }

    for ($i = 0; $i < $len; $i++) {
        if (ord(substr($data, $i, 1))<ord(substr($char, $i, 1))) {
            $str .= chr((ord(substr($data, $i, 1)) + 256) - ord(substr($char, $i, 1)));
        }else{
            $str .= chr(ord(substr($data, $i, 1)) - ord(substr($char, $i, 1)));
        }
    }
    return base64_decode($str);

}

/**
 * 发送通知消息
 * 
 * @param str $type      发送的消息类型，需要在message类里有对应的方法
 * @param mix $msg       发送的消息内容
 *
 * @return boolean  
 */
function send_msg($type, $msg){
    // $message = new app\crm\controller\Message;
    // $res = $message->$type($msg, $rid);
    // return $res;
    // $config = [
    //     'host'       => '192.168.0.12',
    //     'port'       => '',
    //     'password'   => '',
    //     'select'     => 0,
    //     'timeout'    => 0,
    //     'expire'     => 0,
    //     'persistent' => false,
    //     'prefix'     => '',
    // ];

    // $Redis=new \Redis($config);
    // $Redis->set("test","test reids");
    // echo  $Redis->get("test");

    $redis = new \Redis();
    $redis->connect('192.168.0.12',6379);
    // $redis->set('test','hello redis');
    // echo $redis->get('test');
    $res = $redis->publish('test','hello,world');
    // $redis->close();
    // $return = pop_msg();
    var_dump($res);
    // var_dump($return);
    exit;
}

/**
 * 接收队列里的值
 * 
 * @param str $type      发送的消息类型，需要在message类里有对应的方法
 * @param mix $msg       发送的消息内容
 *
 * @return boolean  
 */
function pop_msg(){
    // $message = new app\crm\controller\Message;
    echo '123';
    $redis=new Redis();
    $redis->connect('192.168.0.12', 6379);
    $test = $redis->subscribe(array('test'), 'callback');
    // $redis->set('test','hello redis');
    // $test = $redis->get('test');
    return $test;

}

// 回调函数,这里写处理逻辑
function callback($instance, $channelName, $message) {
    // echo $instance "==>" $channelName, "==>", $message;
    echo $instance.'==>'.$channelName.'==>'.$message;
}
/**
 * 方法描述 上传图片处理函数
 * @param string $file 是
 * 上传的文件
 * @param int $width 宽度
 * @param int $height 高度
 * @param string $subdir 子文件夹名称
 * @return mixed  图片名称
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月11日 下午7:00:05
 */
 function saveImg($imgfile,$width,$height,$subdir='',$imgname='',$istime=true){
     $image = \think\Image::open($imgfile);
     $time  = date('Ymd',time());
     if($subdir){
         $imgdir = ROOT_PATH . 'public' . DS . 'uploads'.DS.$subdir;
     }else{
         $imgdir = ROOT_PATH . 'public' . DS . 'uploads';
     }
     $truePath = $imgdir.DS.($istime?DS.$time:'');
     if(!is_dir($truePath)){
         mkdir(iconv("UTF-8","GBK",$truePath),0777,true);
     }
     if(!$imgname){
         $imgname = ($istime?$time:'').'/'.substr(str_shuffle('abcdefghigklmn'),0,4).time().'.png';
     }
     $width = $width?$width:400;
     $res = $image->thumb($width, $height)->save($imgdir.'/'.$imgname);
     return $imgname;
 }


/**
 * 方法描述 上传图片处理函数
 * @param string $file 是
 * 上传的文件
 * @param int $width 宽度
 * @param int $height 高度
 * @param string $subdir 子文件夹名称
 * @return mixed   图片路径
 */
function saveImgGetPath($imgfile,$width,$height,$subdir='',$imgname='',$istime=true){
    $image = \think\Image::open($imgfile);
    $time  = date('Ymd',time());
    if($subdir){
        $imgdir = 'public' . DS . 'uploads'.DS.$subdir;
    }else{
        $imgdir = 'public' . DS . 'uploads';
    }
    $truePath =  ROOT_PATH .$imgdir.DS.($istime?DS.$time:'');
    if(!is_dir($truePath)){
        mkdir(iconv("UTF-8","GBK",$truePath),0777,true);
    }
    if(!$imgname){
        $imgname = ($istime?$time:'').'/'.substr(str_shuffle('abcdefghigklmn'),0,4).time().'.png';
    }
    $width = $width?$width:400;
    $res = $image->thumb($width, $height)->save(ROOT_PATH .$imgdir.'/'.$imgname);

    return str_replace('\\','/','/'.$imgdir.'/'.$imgname);
}

/**
 * 通用图片上传接口
 * @return \think\response\Json
 */
function uploadImg($file,$size,$ext)
{
    $config = [
        'size' => $size,
        'ext'  => $ext
    ];

    $upload_path = str_replace('\\', '/', ROOT_PATH . 'public/uploads');
    //$save_path   = '/uploads/';
    $info        = $file->validate($config)->move($upload_path);
    if ($info) {
        $url = str_replace('\\', '/', $info->getSaveName());
    } else {
        $url =  $file->getError();
    }
    return $url;
}


/**
 * 方法描述 指定随机数
 * @param string $thisTime 开始时间
 * @param int $endTime 结束时间
 * @return mixed
 * @autho YanLipeng<YanLipeng@suxuantech.cn> 2017年12月11日 下午7:00:05
 */
function rand_chars($c, $l, $u = FALSE) {
    $a = 0;
    if (!$u) {

        for ($s = '', $i = 0, $z = strlen($c)-1; $i < $l; $x = rand(0,$z), $s .= $c{$x}, $i++);

    } else {

        for ($i = 0, $z = strlen($c)-1, $s = $c{rand(0,$z)}, $i = 1; $i != $l; $x = rand(0,$z), $s .= $c{$x}, $s = ($s{$i} == $s{$i-1} ? substr($s,0,-1) : $s), $i=strlen($s)){
            $a++;
            if($a > 200){

                $s=get_rand_string($l,1);
                break;
            }

        }
    }
    return $s;
}

/**
 * 方法描述 处理两个日期相差的天数
 * @param string $thisTime 开始时间
 * @param int $endTime 结束时间
 * @return mixed
 * @autho YanLipeng<YanLipeng@suxuantech.cn> 2017年12月11日 下午7:00:05
 */
function getBadDays ($thisTime, $endTime)
{
    $second1 = strtotime($thisTime);
    $second2 = strtotime($endTime);

    if ($second1 < $second2) {
        $tmp = $second2;
        $second2 = $second1;
        $second1 = $tmp;
        return ($second1 - $second2) / 86400;
    } else {
        return 0;
    }
}
/**
 * 方法描述 获取默认的预算消息模版
 * @param string $thisTime 开始时间
 * @param int $endTime 结束时间
 * @return mixed
 * @autho YanLipeng<YanLipeng@suxuantech.cn> 2017年12月11日 下午7:00:05
 */
function getWedPercent () {
    $percentage = db('wedding_money')->where('wed_user',0)->field('wed_name,wed_per')->select();
    $ret = '';
    foreach ($percentage as $v) {
        $ret[$v['wed_name']] = $v['wed_per'];
    }
    return $ret;
}

/**
 * 方法描述 婚期总值预算
 * @param string $wedMoney 总额度
 * @param int $wedList 选择的项目名称
 * @return mixed
 * @autho YanLipeng<YanLipeng@suxuantech.cn> 2017年12月11日 下午7:00:05
 */
function getWedRatio ($wedMoney,$wedList=null)
{
    $userId = \think\Session::get('memid');
    $wedData = db('wedding_money')->where('wed_user', '=', $userId)->field('wed_project,wed_name,wed_money,wed_status,wed_remark,wed_user,wed_per,wed_show,wed_consume')->select();
    $newData = [];

    if (!$wedData) {
        $wedData = db('wedding_money')->where('wed_user', '=', 0)->select();
    }
    $lockMoney = 0;
    $totalMoney = 0;
    $unLockData = [];
    $lockData = [];
    $unLockTalPer = 0;
    $defaultPercent = getWedPercent();  //调用默认的预算模版类型
    foreach ($wedData as $k => $v) {
        //当前已选数据拆分
        unset($v['w_id']);
        $totalMoney += (int)$v['wed_money'];

        if (!empty($wedList) && count($wedList) > 0) {

            if (!array_key_exists($v['wed_name'], $wedList)) {
//                unset($wedData[$k]);
                continue;
            } else {
                unset($wedList[$v['wed_name']]);
            }
        }
        if ($v['wed_status'] == 2) {
            $lockMoney += (int)$v['wed_money'];
            $lockData [] = $v;
        } else {
            $unLockTalPer += $defaultPercent[$v['wed_name']];
            $unLockData[] = $v;
        }
    }
    //处理新增选择
    if (!empty($wedList) && count($wedList) > 0) {
        foreach ($wedList as $v) {
            $unLockTalPer += $defaultPercent[$v['wed_name']];
            $unLockData[] = array(
                'wed_project' => $v['wed_project'],
                'wed_name' => $v['wed_name'],
                'wed_money' => 0,
                'wed_status' => 1,
                'wed_remark' => '',
                'wed_user' => $userId,
                'wed_per' => 0,
                'wed_show' => 1,
                'wed_consume' => 1,
            );
        }
    }
    $unLockMoney = $wedMoney ? $wedMoney - $lockMoney : $totalMoney - $lockMoney;
    if ($unLockMoney < 0) {
        //预算不足
        return false;
    }
    //重新分配未锁定数据
    if (count($unLockData) > 0) {
        $unlockSetMoney = 0;
        foreach ($unLockData as $k => $v) {
           // echo 'set money:'.$unlockSetMoney."\r\n";
          //  echo "key:$k ".(count($unLockData) - 1)." \r\n";
            if ($k == count($unLockData) - 1) {
                $v['wed_money'] = $unLockMoney - $unlockSetMoney;
                $v['wed_money'] = $v['wed_money']<0?0:$v['wed_money'];
            } else {
              //  echo $v['wed_name'].' percent:'.round($defaultPercent[$v['wed_name']] / $unLockTalPer, 4)."\r\n";
                $v['wed_per'] = round($defaultPercent[$v['wed_name']] / $unLockTalPer, 4);
                $v['wed_money'] = (int)round($unLockMoney * $v['wed_per']);

                if(($unlockSetMoney + $v['wed_money']) > $unLockMoney){
                    $v['wed_money'] = $unLockMoney - $unlockSetMoney;
                }
                $unlockSetMoney += $v['wed_money'];
            }
            $unLockData[$k] = $v;
        }
    }else{
        if($unLockMoney > 0){
            //预算 分配不完 无项目可分配。超出金额为：$unlockMoney;
            return false;
        }
    }
    $newData = array_merge($lockData, $unLockData);
    $returnData = [];
    $sort = db('wedding_money')->where('wed_user',0)->field('wed_name,sort')->order('sort')->select();
    $sortCount = 0;
    $percentTotal = 1;
    $lastValidMoneyKey = 0;
    foreach($sort as $vs){
        foreach($newData as $kn =>$kv){
            if($kv['wed_name'] == $vs['wed_name']){
                $sortCount++;
                if($sortCount == count($newData)) {
                    if ($kv['wed_money'] == 0) {
                        $kv['wed_per'] = 0;
                    } else {
                        $kv['wed_per'] = $percentTotal > 0 ? $percentTotal : 0;
                    }
                }else{
                    $kv['wed_per'] = round($kv['wed_money']/$totalMoney,4);
                    $percentTotal = bcsub($percentTotal , $kv['wed_per'],4);
                }
                $kv['wed_user'] = $userId;
                $kv['sort'] = $vs['sort'];
                if($kv['wed_money'] > 0){
                    $lastValidMoneyKey = $sortCount - 1;
                }
                $returnData[] = $kv;
            }
        }
    }
    if($percentTotal > 0){
        $returnData[$lastValidMoneyKey]['wed_per'] = bcadd($returnData[$lastValidMoneyKey]['wed_per'],$percentTotal,4);
    }
    return $returnData;
}

/**
 * 方法描述   下载微信的头像
 * @param  string
 * @return mixed
 * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月26日 下午12:55:23
 */
function downloadImage($url, $path='',$imgname="headimg.png")
{
    $truepath = ROOT_PATH . 'public' . DS . 'uploads'.DS.'headimg'.DS.''.($path?$path.''.DS:'');
    
    $ch = curl_init();
    curl_setopt($ch,CURLOPT_URL,$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,30);
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,FALSE);
    curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,FALSE);
    $file = curl_exec($ch);
    curl_close($ch);
    if(!$file){
        textlog('获取微信头像失败.');
        return false;
    }
    if(!is_dir($truepath)){
        @mkdir($truepath,0777,true);
    }
    if(!is_writable($truepath)){
        textlog('获取微信头像失败，这个目录文件：'.$truepath.'不可写');
    }else{
        $resource = fopen($truepath.$imgname, 'a');
        fwrite($resource, $file);
        fclose($resource);
        $filepath = $truepath.$imgname;
        if(file_exists($filepath)){
            $image = \think\Image::open($filepath);
            $image->thumb(150, 150)->save($filepath);
        }
    }
    
}
/**
 * 返回系统版本号，支持模块版本，和应用版本
 * 在application下的config.php配置的APP_VERSION版本号，为应用版本号
 * 在application/模块/config.php配置的MODULE_VERSION为模块版本号
 * 
 * @param type $type 版本类型，默认app
 * @return type
 */
function get_version($type ='') {
    $module = \think\Request::instance()->module();
    if(empty($type)){
        return strtolower($module) == 'index'?APP_VERSION:config('MODULE_VERSION');
    }else{
        if(strtolower($module) == 'index'){
            return APP_VERSION;
        }else{
            return strtolower($type) == 'app'?APP_VERSION:config('MODULE_VERSION');
        }
    }
}
/**
 * 判断表是否存在，分表
 * @param   String $tableName [要判断的表名]
 * @param   String $dbConfig [<数据库配置，非当前库时，指定>]
 * @return  boolen            true/false
 */
function checkTableExists($tableName,$dbConfig=''){
    if(!$tableName) return false;
    $cacheKey = 'table_all_list';
    $tableList = cache($cacheKey);
    if(!$tableList){
        $sql = "show tables;";
        if($dbConfig){
            $res = db('',$dbConfig)->master()->query($sql);
        }else{
             $res = db()->master()->query($sql);
        }
        $tableList = [];
        foreach($res as $value){
            $tableList = array_merge($tableList,array_values($value));
        }
        cache($cacheKey,json_encode($tableList));
    }
    if(empty($tableList)){
        return false;
    }
    if(in_array($tableName,$tableList)){
        return true;
    }else{
        return false;
    }
}

/**
 * 判断签到日期并生成下一张日期表
 * @param  String  $y/$m   传入年月
 * @return json
 * @author
 */
function getTable ($newTime) {

    $table_name = 'sign_detail_'."$newTime";
    $sql = "CREATE TABLE $table_name (
            id int NOT NULL AUTO_INCREMENT,
            PRIMARY KEY(id),
            userid int(11),
            sign_time datetime,
            sign_sum int(11),
            sign_create datetime
        )";
    $res = db()->query($sql);
    if ($res !== false) {
        $cacheKey = 'table_all_list';
        cache($cacheKey,null);
        return true;
    } else {
        return false;
    }
}

/**
 * 调取erp
 * @param   String $tableName [要判断的表名]
 * @param   String $dbConfig [<数据库配置，非当前库时，指定>]
 * @return  boolen            true/false
 */
function requestERP($url,$content){
    $time      = time();
    $nonce     = rand(99999,999999);
    $signature = md5($time.$nonce.'oUWKYeqCEojOvbmsynvWTctJSAVeoMZv');
    $header    = array('timestamp:'.$time,'nonce:'.$nonce,'signature:'.$signature);
    $header[] = 'Content-Type: application/json; charset=utf-8';
    $header[] = 'Content-Length: ' . strlen($content);
    $a = http_request($url,'POST', $content,$header);
    //print_r($a);die;
    $b = json_decode($a['response'], true);
    return $b;

}
/**
 * 验证参数方法
 * @param   String $tableName [要判断的表名]
 * @param   String $dbConfig [<数据库配置，非当前库时，指定>]
 * @return  boolen            true/false
 */
function check_parameter ($phone,$time) {
    $format = "Y-m-d";  //时间格式
    $time = strtotime($time);  //转换为时间戳
    $checkstr = date($format, $time); //在转换为时间格式
    if (!preg_match('/^1[34578]{1}\d{9}$/',$phone)) {
        return false;
    }
    if(strpos($time,$checkstr) === 0){
        return 1;
    } else {
        return false;
//        return array('code'=>202,'msg'=>'请输入正确的时间格式','error'=>1);
    }


}
/**
 * 检测代码运行时间
 * // 时间效率对比
 * // 记录开始时间  $time_start = getmicrotime();
 * // 记录结束时间 $time_end = getmicrotime();
 * // 计算运行时间 $time = $time_end - $time_start;
 * // 输出运行总时间 echo "执行时间 $time seconds"
 * @param   String $tableName [要判断的表名]
 * @param   String $dbConfig [<数据库配置，非当前库时，指定>]
 * @return  boolen            true/false
 */
function getmicrotime()
{
    list($usec, $sec) = explode(" ",microtime());
    return ((float)$usec + (float)$sec);
}

//替换特殊字符
function replaceSpecialChar($strParam){
    $regex = "/\/|\~|\!|\@|\#|\\$|\%|\^|\&|\*|\(|\)|\_|\+|\{|\}|\:|\<|\>|\?|\[|\]|\,|\.|\/|\;|\'|\`|\-|\=|\\\|\|/";
    return preg_replace($regex,"",$strParam);
}

// 判断是否手机号
function is_mobile($phone){
   if(preg_match("/^1[3|4|5|7|8][0-9]{9}$/",$phone)){
       return true;
   }
   return false;
}

function formatTree($list, $lv = 0, $title = 'menu_name'){
    $formatTree = array();
    foreach($list as $key => $val){
        $title_prefix = '';
        for( $i=0;$i<$lv;$i++ ){
            $title_prefix .= "|---";
        }
        $val['lv'] = $lv;
        $val['namePrefix'] = $lv == 0 ? '' : $title_prefix;
        
        $val['showName'] = $lv == 0 ?$val[$title]: $title_prefix.$val[$title];
        if(!array_key_exists('_child', $val)){
            array_push($formatTree, $val);
        }else{
            $child = $val['_child'];
            unset($val['_child']);
            array_push($formatTree, $val);
            $middle = formatTree($child, $lv+1, $title); //进行下一层递归
            $formatTree = array_merge($formatTree, $middle);
        }
    }
    return $formatTree;
}

/**
 * 把返回的数据集转换成Tree
 * @param $list
 * @param string $pk
 * @param string $pid
 * @param string $child
 * @param string $root
 * @return array
 */
function listToTree($list, $pk='id', $pid = 'fid', $child = '_child', $root = '0') {
    $tree = array();
    if(is_array($list)) {
        $refer = array();
        foreach ($list as $key => $data) {
            $refer[$data[$pk]] = &$list[$key];
        }
        foreach ($list as $key => $data) {
            $parentId =  $data[$pid];
            if ($root == $parentId) {
                $tree[] = &$list[$key];
            }else{
                if (isset($refer[$parentId])) {
                    $parent = &$refer[$parentId];
                    $parent[$child][] = &$list[$key];
                }
            }
        }
    }
    return $tree;
}

/*
 * 将数据递归处理
 *  @param array $list
 *  @param string $fid
 */
function treeData($list,$fid){
    $tree = array();
    foreach($list as $row) {
        if($row['fid'] == $fid) {
            $row['children'] = treeData($list, $row['id']);
            $tree[] = $row;
        }
    }
    return $tree;
}

/*
 * 获取某个模块下级菜单
 */
function getNextMenu($menu_code){
    $menuData=getAuth('menu');

    $menuList=treeData($menuData,$fid=0);

    //print_r($menuList);die;
    //获取下级菜单
    foreach($menuList as $k => $v){
        if($v['menu_code'] == $menu_code){
            $nextList = $v['children'];
        }
    }
    return $nextList;
}

/*
 * 获取某个菜单的顶级模块
 */
function getTopMenu($menu_url){

    $data = db('s_menu')->where('menu_url',$menu_url)->find();
    $f_id = $data['fid'];

    while($f_id>0){
        $menu = db('s_menu')->where('id',$f_id)->find();
        $f_id = $menu['fid'];
    }

    $menu_code = $menu ? $menu['menu_code'] : $data['menu_code'];

   return $menu_code;
}


//检测是否为管理员
function isAdministrator(){
    $main_work_type= (int)session('main_work_type');
    $work_type     = session('work_type');
    $brandid       = (int)session('brandid');

    $allWorkType = explode(',',trim($main_work_type.','.$work_type,','));
    if(in_array(SYSTEM_AUTH_ADMIN,$allWorkType) || !$brandid ){
        return true;
    }else{
        return false;
    }
}


/*
 * 获取登录人权限
 * type  menu显示菜单，auth权限
 * wangyining
 */
function getAuth($type){

    $type = $type ? $type : 'auth';
    $menuAllS = cache('VIP_child_menuAll');
    if (!$menuAllS) {
        $menuAllS = db('s_menu')->order('sort asc')->select();
        cache('VIP_child_menuAll', $menuAllS);
    }

    if ($type == 'menu') {//显示菜单
        $menuList = [];
        foreach ($menuAllS as $k => $v) {
            if ($v['status'] == 1) {
                $menuList[] = $v;
            }
        }
    } elseif ($type == 'auth') {//检测权限
        $menuList = $menuAllS;
    }

    $main_work_type= (int)session('main_work_type'); 
    $work_type     = session('work_type');
    $brandid       = (int)session('brandid');

    $allWorkType = explode(',',trim($main_work_type.','.$work_type,','));
    
    $isdebug  = (int)input('get.isdebug');
    if(in_array(SYSTEM_AUTH_ADMIN,$allWorkType) || !$brandid ||$brandid ==db_config('sx_brand')){

        //菜单url转换小写
        foreach ($menuList as $k=>$menuInfo){
            $menuList[$k]['menu_url'] = $menuInfo['menu_url']?strtolower($menuInfo['menu_url']):'';
        }

        return $menuList;
    }else{
        $position_code=array_unique(explode(',',trim(session('main_position_code').','.session('position_code'),',')));
        $menuAll=array();

        foreach($position_code as $k => $v){
            //取这个岗位的所有MENU 逗号分隔的menu code
            $menu=cache('VIP_child_menu_'.$position_code[$k]);
            if(!$menu){
                $data=db('s_position_menu')->where('position_code',$position_code[$k])->find();
                $menu=$data['menu_code'];
                cache('VIP_child_menu_'.$position_code[$k], $menu);
            }
            array_push($menuAll,$menu);
        }

        //去重
        $menuAll=array_unique(explode(',',implode(',',$menuAll)));

        //取所有menu的详细信息
        foreach ($menuList as $k=>$menuInfo){
            //菜单url转换小写
            $menuList[$k]['menu_url'] = $menuInfo['menu_url']?strtolower($menuInfo['menu_url']):'';
            if(!in_array($menuInfo['menu_code'], $menuAll)){
                unset($menuList[$k]);
            }
        }

        return $menuList;
    }
   
}

//获取menu信息
function getMenu(){

    $menu=getAuth('menu');
    return $menu;
}


// 判断用户是否有权限访问
function isPermission($menulist,$url){
    // 排除的管理的权限地址
    $permission = [
        '/vip/setting/getmenujson',
        '/vip/index/getmessage',
        '/vip/avtivity/upload',
        '/vip/index/nopermission'
    ];
    $aurl = strtolower(str_replace('\\', '/', $url));
    if(in_array($aurl, $permission)){
        return true;
    }
    $menulist = array_merge($permission,$menulist);

    if($menulist && $url){
        
        foreach ($menulist as $k=>$v){
            $code = strtolower(str_replace('/', '\\', $v['menu_url']));
            if(!$code){
                continue;
            }
            if($v['children']){
                foreach ($v['children'] as $kk=>$vv){
                    $subcode = strtolower(str_replace('/', '\\', $vv['menu_url']));
                    if($subcode==$url){
                        return true;
                    }else if($subcode == '\vip\setting\menuset' && $url == '\vip\setting\addmenuset'){
                        return true;
                    }
                }
            }
            // 当添加菜单时需要ajax请求的页面
            if($code == '\vip\setting\menuset' && $url == '\vip\setting\addmenuset'){
                return true;
            }
            if($code==$url){
               return true;  
            }
        }
    }
    return false;
}
 

//获取某个分类的所有子分类
function getSubs($arr,$pid=0,$level=1){

    $subs=array();
    foreach($arr as $item){
        if($item['parentid']==$pid){
            $item['level']=$level;
            $subs[]=$item;
            $subs=array_merge($subs,getSubs($arr,$item['id'],$level+1));
        }
    }
    return $subs;
}

function strLens($b){
    for($i=0;$i<ceil(strlen($b)/4);$i++){
        $a[] = substr($b,$i*4,4);
    }
    return implode(' ',$a);
}
/**
 * 发送模板消息--给会员
 * @param Integer  $data json格式模板消息内容,
 *                       touser:要发送给用户的OPENID
 *                       template_id模板消息ID
 *                       url点击跳转的地址
 *                       data参数
 *                       把以上几个数放在content为键值的数组内。
 *                       
 * @author {wangyining}<{wangyining@suxuantech.cn}> 2017-10-17 $
 */
function sendMemberWxMsg($data){
    $url="5a439c7e5b8e7";
    $res=sx_call($url,$data);
    return $res;
}
/**
 * 将截图粘贴到文本编辑器内的带BASE64的图片内容中的图片存为文件，返回可用于显示的内容。
 *
 * @param  String $string 提交的编辑器内容，带bese64图片内容的文本内容
 * @param  String $path   图片保存目录，相对于网站访问跟目录的图片路径，默认pic目录下
 * @param  String $prefix 服务端路径前缀，与path变量组成可访问文件的绝对路径，默认ROOT_PATH/public/下
 * @return String         返回替换完后的内容。
 */
function save_clips_to_file($string,$path='',$prefix=''){
    if(!$string){return '';}
    $prefix = $prefix?$prefix:ROOT_PATH;
    $prefix = substr($prefix,-1) != DS?$prefix.DS:$prefix;
    $path = $path?$path:'pic'.DS;
    $path = trim($path,DS).DS;//拼路径时，去掉前面的路径分隔符，后面替换时，再加上。

    preg_match_all('/<img.*?src=\"(.*?)\"/i', $string, $mat);
    foreach($mat[1] as $k=>$src){
        if(substr($src,0,4) == 'data'){
            //是data类型的图片地址
            $fileType = '.'.substr($src,strpos($src,'/')+1, strpos($src,';') - strpos($src,'/') - 1);
            $fileName = md5($src).$fileType;
            unset($fileType);
            $preDir = substr($fileName,0,2);
            //*//
            if(!file_exists($prefix.$path.$preDir)){
                $mkres = @mkdir($prefix.$path.$preDir,0777,true);
                if(!$mkres){
                    return false;
                }
            }//*/
            $fileName = $preDir.DS.$fileName;
            unset($preDir,$mkres);
            $content = base64_decode(substr($src, strpos($src,'base64,') +7 ));
            if($content){
                //解压成功，则存文件，否则不处理。
                $save = @file_put_contents($prefix.$path.$fileName,$content);
                if(!$save){
                    return false;
                }
                //将文件路径转为URL可显示路径，解决WINDOWS的路径分隔符问题
                $saveFile = '/'.str_replace('\\', '/', $path.$fileName);
                $string = str_replace($src, $saveFile, $string);
            }
            unset($src,$fileName,$content,$save);
        }
    }
    return $string;
}



function save_base64_to_file($string,$path='',$prefix=''){
    if(!$string){return '';}
    $prefix = $prefix?$prefix:ROOT_PATH.DS.'public'.DS;
    $prefix = substr($prefix,-1) != DS?$prefix.DS:$prefix;
    $path = $path?$path:'pic'.DS;
    $path = trim($path,DS).DS;//拼路径时，去掉前面的路径分隔符，后面替换时，再加上。

    //是data类型的图片地址
    $fileType = '.'.substr($string,strpos($string,'/')+1, strpos($string,';') - strpos($string,'/') - 1);

    $fileName = md5($string).$fileType;
    unset($fileType);
    $preDir = substr($fileName,0,2);
    //*//
    if(!file_exists($prefix.$path.$preDir)){
        $mkres = @mkdir($prefix.$path.$preDir,0777,true);
        if(!$mkres){
            return false;
        }
    }//*/
    $fileName = $preDir.DS.$fileName;
    unset($preDir,$mkres);
    $content = base64_decode(substr($string, strpos($string,'base64,') +7 ));

    if($content){
        //解压成功，则存文件，否则不处理。
        $save = @file_put_contents($prefix.$path.$fileName,$content);
        if(!$save){
            return false;
        }
        //将文件路径转为URL可显示路径，解决WINDOWS的路径分隔符问题
        $saveFile = '/'.str_replace('\\', '/', $path.$fileName);

    }
    unset($src,$fileName,$content,$save);

    return $saveFile;
}


function save_file($string,$path='',$prefix=''){
    if(!$string){return '';}
    $prefix = $prefix?$prefix:ROOT_PATH.DS.'public'.DS;
    $prefix = substr($prefix,-1) != DS?$prefix.DS:$prefix;
    $path = $path?$path:'pic'.DS;
    $path = trim($path,DS).DS;//拼路径时，去掉前面的路径分隔符，后面替换时，再加上。

    //是data类型的图片地址
    //$fileType = '.'.substr($string,strpos($string,'/')+1, strpos($string,';') - strpos($string,'/') - 1);

    $fileName = md5($string).'.jpg';
    //$fileName = md5($string).$fileType;
    //unset($fileType);
    $preDir = substr($fileName,0,2);
    //*//
    if(!file_exists($prefix.$path.$preDir)){
        $mkres = @mkdir($prefix.$path.$preDir,0777,true);
        if(!$mkres){
            return false;
        }
    }//*/
    $fileName = $preDir.DS.$fileName;
    unset($preDir,$mkres);


    $qrcodeurl = imagecreatefromjpeg($string);
    /** 保存下载到本地 50是画质*/
    $save=imagejpeg($qrcodeurl, $prefix.$path.$fileName, 50);
    if(!$save){
        return false;
    }
    //将文件路径转为URL可显示路径，解决WINDOWS的路径分隔符问题
    $saveFile = '/'.str_replace('\\', '/', $path.$fileName);

    unset($fileName,$qrcodeurl,$save);

    return $saveFile;
}




//返回某子集的所有父级
function getParents($categorys,$catId){
    $tree=array();
    while($catId != 0){
        foreach($categorys as $item){
            if($item['id']==$catId){
                array_push($tree,$item['id']);
                $catId=$item['pid'];
                break;
            }
        }
    }
    //array_shift($tree);
    return $tree;
}


/**
 * 获取当前应用的域名，配置于环境变量内。
 * @return domain 域名
 */
function getDomain(){

    $url = empty($url)?$_SERVER['HTTP_HOST']:$url;
    $matches = parse_url(trim($url));
    $scheme = empty($matches['scheme'])?'http://':'';
    return $scheme.$url;
}



/**
 * 获取当前配置内，上传文件的最大限制
 * 
 * @return type
 */
function getMaxUploadSize(){
    
    $scan['gb'] = 1073741824; //1024 * 1024 * 1024;
    $scan['g']  = 1073741824; //1024 * 1024 * 1024;
    $scan['mb'] = 1048576;
    $scan['m']  = 1048576;
    $scan['kb'] =    1024;
    $scan['k']  =    1024;
    $scan['b']  =       1;
    $upSize = strtolower(ini_get('upload_max_filesize'));
    $upSizeC = str_replace(intval($upSize) . '','',$upSize);
    $upSizeN = $scan[$upSizeC] * intval($upSize);
    $postSize = strtolower(ini_get('post_max_size'));
    $postSizeC = str_replace(intval($postSize) . '','',$postSize);
    $postSizeN = $scan[$postSizeC] * intval($postSize);
    
    $limit = $postSizeN>$upSizeN?$upSize:$postSize;
    
    return $limit;
    //$upSize = $scan[strtolower(ini_get('upload_max_filesize'))] ;
    
//    return ini_get('upload_max_filesize');    
    
}



/*
 * 给图片加水印，生成带头像、昵称、二维码的图片
 * $bg_img  背景图
 * $head_img  头像
 * $nickname  昵称
 * $qrcode    二维码
 * $site      坐标
 * $openid    openid
 * $brand_id  事业部id
 */
function watermark($bg_img,$head_img,$nickname,$qrcode,$site,$openid,$brand_id){

    $image = \think\Image::open($bg_img);
    $photo_scale=$site['photo_scale'] ? $site['photo_scale'] : 1;
    $photo_x = $site['photo_x'] ? $site['photo_x'] : 10;
    $photo_y = $site['photo_y'] ? $site['photo_y'] : 10;
    $name_x  = $site['name_x'] ? $site['name_x'] : 150;
    $name_y  = $site['name_y'] ? $site['name_y'] : 50;
    $name_color=$site['name_color'] ? $site['name_color'] : '#00000000';
    $ewm_scale=$site['ewm_scale'] ? $site['ewm_scale'] : 1;
    $ewm_x   = $site['ewm_x'] ? $site['ewm_x'] : 0;
    $ewm_y   = $site['ewm_y'] ? $site['ewm_y'] : $image->height()-480;

    $path=ROOT_PATH.'/public/upload/'.substr($openid,0,2);
    if (!is_dir($path)){
        mkdir($path);
    }

    // 给原图左上角添加水印并保存
    if($head_img){
        $img = $image->clipping($head_img,$path.'/');//裁剪成圆形
        $image->water($img,[$photo_x,$photo_y]);
        // 给原图左上角添加文字水印并保存
        $image->text($nickname,ROOT_PATH.'public/front/font-awesome/fonts/HYQingKongTiJ.ttf',30,$name_color,[$name_x,$name_y]);
        unlink($img);
    }

    //左下角加二维码水印
    $qrPath=$image->resize_img($qrcode,$path.'/',$ewm_scale);//压缩
    $image->water($qrPath,[$ewm_x,$ewm_y]);
    unlink($qrPath);
    $imgPath=$path.'/'.$brand_id.$openid.'.jpg';
    $image->save($imgPath);
    return $imgPath;

}

function textlog($str){
    if(config('app_debug')){
        $str = date('Y-m-d H:i:s').$str;
        if (strtoupper(substr(php_uname(),0,3)) == 'WIN') {
            $str = iconv("UTF-8","GB2312//IGNORE",$str);
        }
        file_put_contents(ROOT_PATH."/runtime/".date('Ymd')."textlogs.txt",$str."\r\n",FILE_APPEND);
    }
}


//后台通过brandid获取商城域名
function getShopUrl($brandid=''){
    //coding....MC interface
    //从MC接口获取 获取后存cache
    //获取 brandid request()->host()
    $brandClassList = cache('all_brand_class_list');
    if(!$brandClassList){
        $brandList = sx_call('5a38840b15ba9',array(),'sx_mc');
        if($brandList['code'] == 200){
            cache('all_brand_class_list',$brandList['data']);
            $brandClassList = $brandList['data'];
        }else{
            return [];
        }
    }
    foreach($brandClassList as $brandInfo){
        if($brandid == $brandInfo['id']){
            return $brandInfo;
        }
    }
    return $brandClassList[0];
}

/**
 * 获取或控制后端服务状态，需要有缓存支持
 * 
 * @param  string $serverName [要控制的服务名，如果只是获取，不需要传]
 * @param  [type] $status     [控制状态：start/restart]
 * @return [type]             [description]
 */
function service_status($serverName='',$status=null){
    $key = 'sxmonitor_serializelist';
    $service = cache($key);
    if(is_string($service)){
        $service = json_decode($service,true);
    }
    if(!$service){
        return false;
    }
    $serverArr = explode(',', $serverName);
    if(!is_null($status)){
        $sign = [];
        foreach ($serverArr as  $name) {
            # code...
            $serverInfo = $service['service_list'][$name];
            if(!$serverInfo){
                //无效的服务名
                continue;
            }
            switch ($status) {
                case 'restart':
                case 'stop':
                    $sign[$name] =['sign'=>$status,'status'=>0];
                    break;
                default:
                    # code...
                    break;
            }
        }
        if(!empty($sign)){
            cache('service_control_sign',json_encode($sign));
        }
        return true;
    }else{
        return $service;
    }
}
/**
 * 获取或更新数据库配置键对应的值。
 * 
 * @param type $key
 * @param type $value
 * @return boolean
 */
function db_config($key,$value) {
    $cacheKey = 'db_config_'.$key;
    if(is_null($value)){
        // if(cache('?'.$cacheKey)){
        //     return cache($cacheKey);
        // }else{
            $value = db('c_sysconfig')->where('ckey',$key)->value('cvalue');
            if(!is_null( $value ) ){
                cache($cacheKey,$value);
            }
            return $value;
        //}
    }else{
        db()->startTrans();
        $count = db('c_sysconfig')->where('ckey',$key)->count();
        if($count>0){
            $res = db('c_sysconfig')->where('ckey',$key)->update(array('cvalue'=>$value));
        }else{
            $res = db('c_sysconfig')->insert(array('ckey'=>$key,'cvalue'=>$value));
        }
        if($res === false){
            db()->rollback();
            return false;
        }else{
            db()->commit();
            cache($cacheKey,null);
            return true;
        }
        
    }
}

/*
 * 获取推荐人规则
 */
function getRecommendRule($brand_id,$key){
    $rule = db('recommend_rule')->where('brand_id',$brand_id)->find();
    $data = json_decode($rule['rule'],true);
    if($data[$key]){
        return $data[$key];
    }else{
        return '0';
    }
}

//导出excel模板表头
function export_header(){
    $title=array('客户ID','打款编号','会员卡号','提现人姓名','提现金额','银行卡号','提现时间', '提现状态','打款结果');
    return $title;
}

//导出excel模板表头
function import_header(){
    //$title=array('会员卡号','提现人姓名','提现金额','银行卡号','提现时间','打款结果');
    $title=array(
        'userid'        =>'客户ID',
        'get_number'  => '打款编号',
        'user_number' => '会员卡号',
        'user_true_name' => '提现人姓名',
        'get_money' => '提现金额',
        'bank_code' => '银行卡号',
        'get_time'  => '提现时间',
        'money_status'=>'提现状态',
        'is_ok'     => '打款结果'
    );
    return $title;
}

/*
 * excel导入模板
 */
function template_header(){
    $title=array('打款编号','会员卡号','提现人姓名','提现金额','银行卡号','提现时间', '是否打款');
    return $title;
}


/**
 * 存入redis消息队列
 *
 * @param str listName      消息队列的名称
 * @param mix $msg          消息队列的内容
 *
 * @return boolean
 */
function push_list($listName, $msg){
    $create_time = date('Y-m-d H:i:s');
    // $ip = \think\Request::instance()->ip();
    $ip = get_client_ip();
    $msg['ip'] = $ip;
    $msg['create_time'] = $create_time;
    switch ($listName) {
        // 数据统计队列
        case 'historyDataList':
            $msgIn = json_encode($msg);
            $data['message']    = $msgIn;
            $data['type']       = $msg['type'];
            $data['create_time']= $create_time;
            $res = db('c_history_data')->insertGetId($data);
            if (!$res) {
                return false;
            }

            $msg['hid'] = $res;
            $message = $msg;
            break;
        // 导入财务打款记录
        case 'vip_excelImportMoney':
            $message = $msg;
            break;
        // excel导入队列
        case 'excelImportRedisList':
            $message = $msg;
            break;
    }

    return \app\common\lib\redisQueue::init()->rPush($listName, $message);
}
//生成指定长度随机数
function generate_code($length = 4) {
    return rand(pow(10,($length-1)), pow(10,$length)-1);
}


//前端用来获取当前在哪个事业部，后续当前事业部的相关数据，都从这里获取。
function getSiteBrand($domain='',$brandid=0){
    //coding....MC interface
    //从MC接口获取 获取后存cache
    //获取 brandid request()->host()
    //cache("db_config_*",null);
    $_brandid = input('_brandid')?input('_brandid') : session("brand_id");
    $brandClassList = cache('all_brand_class_list');

    if(!$brandClassList){
        $brandList = sx_call('5a38840b15ba9',array(),'sx_mc');
        if($brandList['code'] == 200){
            cache('all_brand_class_list',$brandList['data'],3600);
            $brandClassList = $brandList['data'];
        }else{
            return [];
        }
    }
    if($brandid){
        foreach($brandClassList as $brandInfo){
            if($brandid == $brandInfo['id']){
                return $brandInfo;
            }
        }
    }

    if($_brandid){

        foreach($brandClassList as $brandInfo){
            if($_brandid == $brandInfo['id']){
                return $brandInfo;
            }
        }
    }else{
        $url =  $domain?$domain:request()->domain();

        $conf_brandid = db_config('sx_brand');
        $returnBrandInfo = "";
        //匹配域名
        foreach($brandClassList as $brandInfo){
            if($url == $brandInfo['vip_url']){
                $returnBrandInfo = $brandInfo;
            }

            if($brandInfo['id'] == $conf_brandid){
                $confBrandInfo = $brandInfo;
            }
        }

        if(!$returnBrandInfo){
            $returnBrandInfo = $confBrandInfo;
        }

        if($returnBrandInfo && $confBrandInfo['vip_url'] && $returnBrandInfo['id'] != $conf_brandid){

            $redUrl = "$confBrandInfo[vip_url]$_SERVER[REQUEST_URI]";
            if(strpos($redUrl, '?')){
                $redUrl .= '&_brandid='.$returnBrandInfo['id'];
            }else{
                $redUrl .= '?_brandid='.$returnBrandInfo['id'];
            }
            unset($confBrandInfo,$brandInfo);
            header('Location: '.$redUrl);die;
        }

        if(!$returnBrandInfo){
            $returnBrandInfo = $brandClassList[0];
        }
        unset($confBrandInfo,$brandInfo,$redUrl);
        return $returnBrandInfo;
    }
}

/**
 *  记录积分日志，并更改用户表积分
 * @param [type] $userid        用户id
 * @param [type] $user_phone_id 手机id
 * @param [type] $sore          积分值
 * @param [type] $type          积分类型： 1=>签到 2=>任务 3=>绑定手机号 11=>渠道 12=>活动 13=>助力 16=>订单评价 17=>关注公众号,18取消订单,19会员等级升级,20先睹为快里打赏礼物
 * @param string $memo          描述
 * @author  zhaojiepeng <[<Zhaojiepeng@suxuantech.cn>]>
 */
function AddScore($userid,$user_phone_id,$score,$type,$memo=''){
    if(!$userid){
        return false;
    }
    if($user_phone_id){
        $id = $user_phone_id;
        $db = "m_users_phone";
    }else if($userid){
        $id = $userid;
        $db = "m_users";
    }

    $res = db($db)->where("id",$id)->update(['total_score'=>['exp',"total_score + $score"],'growth_value'=>['exp',"growth_value + $score"],'last_land_time' => date('Y-m-d H:i:s')]);
    if($res === false){
        return false;
    }else{
        $memArr = db($db)->where('id',$id)->find();
        session('total_score',$memArr['total_score']);
        return minuteDetailed($memo,$score,$userid,$type,$user_phone_id);
    }
}

/**
 *   积分日志方法
 * @return mixed
 * $title 标题
 * $minute 积分值
 * $userid 执行人
 * $type 类型 0后台修改，1首次登录、每日登录，2完成任务，3绑定手机，8推荐用户，9修改资料，11分享活动，12分享任务，13分享助力活动，14线下订单积分，15经纪人佣金,18取消订单,19会员等级升级,20先睹为快里打赏礼物，21erp线下会员卡充值奖励
 * $phoneid 手机表里的id
 * $is_get  是否领取，1领取，2未领取
 * @author wangyining<wangyining@suxuantech.cn> 2019年04月17日
 */
function addScoreLog ($title,$minute,$userid,$type,$phoneid,$is_get,$create_id) {
    $datas = array(
        'm_title'    => $title,
        'm_num'      => (int)$minute,
        'm_time'     => date('Y-m-d H:i:s'),
        'm_executor' => (int)$userid,
        'm_type'     => (int)$type,
        'iswid'      => (int)$phoneid ? 0 : 1,
        'users_phone_id' => (int)$phoneid,
        'create_id'  => $create_id,
        'is_get'     => $is_get ? $is_get : 1
    );

    if(!$datas['m_executor']&&!$phoneid){
        return false;
    }

    if($datas['m_num']){
        $minuteDetailed = db('minute_log')->insert($datas);
        return $minuteDetailed ? true : false;
    }
    return true;
}


/*
 * 领取积分方法
 */
function receiveScore($log_id){

    $logData = db('minute_log')->where('id',$log_id)->find();
    $score = $logData['m_num'];

    db()->startTrans();
    try{

        db('minute_log')->where('id',$log_id)->update(['is_get'=>1]);

        if($logData['m_executor']){
            db('m_users')->where('id',$logData['m_executor'])->update([
                'total_score'=>['exp',"total_score + $score"],
                'growth_value'=>['exp',"growth_value + $score"],
                'last_land_time' => date('Y-m-d H:i:s')
            ]);
        }elseif($logData['users_phone_id']){
           db('m_users_phone')->where('id',$logData['users_phone_id'])->update([
                'total_score'=>['exp',"total_score + $score"],
                'growth_value'=>['exp',"growth_value + $score"],
                'last_land_time' => date('Y-m-d H:i:s')
            ]);
        }

        db()->commit();
        return true;

    }catch (Exception $e){

        db()->rollback();
        return false;
    }

}

//判断是否有权限
function check_right($code){
    $auth = getAuth($type='auth');
    if(in_array($code,array_column($auth,'menu_code'))){
        return true;
    }else{
        return false;
    }
}

/*
 * 判断今日登陆是否可领取
 */
function todayLogin($userid){

    $data = db("minute_log")->where("m_executor",$userid)->where("m_time",">",date("Y-m-d 0:0:0",time()))->where("m_title","like","%每日登陆%")->find();
    if($data['is_get']==1){
        return ['code'=>201,'msg'=>'已领取'];
    }else{
        return ['code'=>200,'msg'=>'可领取','data'=>$data];
    }

}

/*
 * 判断首次登陆是否可领取
 */
function firstLogin($userid){

    $data = db("minute_log")->where("m_executor",$userid)->where("m_title","like","%首次登陆%")->find();
    if($data['is_get']==1){
        return ['code'=>201,'msg'=>'已领取'];
    }else{
        return ['code'=>200,'msg'=>'可领取','data'=>$data];
    }

}



/**
 *   成长值日志（暂时未用）
 * @return mixed
 * $userid  操作人;
 * $minute  积分值
 * $type    成长值类型 1每天登录2每天签到3领取任务4做任务5推荐新人6报名活动7浏览活动8是分享9绑定手机号
 * $taskid  若类型是分享，记录活动id
 * $phoneid 当前用户绑定的手机表里的id
 * $is_get  是否领取，1领取，2未领取
 * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月16日
 */
function addGrowthLog($userid,$minute,$type,$taskid=0,$phoneid=0,$is_get) {

    $datas = array(
        'graowth_num'  => (int)$minute,
        'graowth_time' => date('Y-m-d H:i:s'),
        'userid' => (int)$userid,
        'graowth_type'=> (int)$type,
        'graowth_tid' => (int)$taskid,
        'iswid'       => (int)$phoneid ? 0 : 1,
        'users_phone_id'=>(int)$phoneid,
        'is_get' =>$is_get ? $is_get : 1
    );
    if(!$datas['userid'] || !$phoneid){
        return false;
    }

    if($datas['graowth_num']){
        $res = db('growth_log')->insert($datas);
        return $res ? true : false;
    }
    return true;

}


/**
 * 记录 购买套系 支付日志，同步ERP 开单日志
 * @param  [type] $action  [description] 动作标题
 * @param  [type] $olddata [description] 旧记录
 * @param  [type] $newdata [description] 新记录
 * @return [type]          [description]
 */
function payment_log($action,$newdata,$olddata){
    $data = [
            'action'=>$action,
            'olddata'=>$olddata,
            'newdata'=>$newdata,
            'create_time'=>date('Y-m-d H:i:s'),
            'userid'=>session('memid'),
            'phoneid'=>session('phoneid'),
        ];
    db("payment_log")->insert($data);
}

/**
 * 发送短信
 * @param [type] $phone   [description] 手机号
 * @param [type] $content [description] 短信内容
 * @param [type] $send    [description] 发送对象
 */
function set_send($phone,$content,$name,$send){
    if(!$phone){
        return false;
    }
    $data = array(
        'mobile' => $phone,
        'content' => $content,
        'brand_id' => session('brand_id'),
    );
    $datas = array(
            'name' => $name,
            'phone'=>$phone,
            'send'=>$send,
            'brandid'=>session('brand_id'),
            'userid'=>session('memid'),
        );
    $phoneCode = sx_call('5a17b86088f1a',$data,'sx_mc');
    if ($phoneCode['code'] !== 200) {
        $datas['status'] = 2;
    }else{
        $datas['status'] = 1;
    }
    db('s_note')->insert($datas);
    return true;

}


/*
 * 发送通知类短信
 * @param [type] $params   参数
 * @param [type] $send_type 短信类型，客服 客人
 */
function sms_send($params,$send_type){
    if(!$params['_mobile']){
        return false;
    }

    $datas = array(
        'name' => $params['name'],
        'phone'=> $params['_mobile'],
        'send' => $send_type,
        'brandid'=>session('brand_id'),
        'userid' =>session('userid'),
        'create_time' => date('Y-m-d'),
    );

    $phoneCode = sx_call('5d78e60eeb6a2',$params,'sx_mc');

    if ($phoneCode['code'] !== 200) {
        $datas['status'] = 2;
    }else{
        $datas['status'] = 1;
    }

    db('s_note')->insert($datas);

    return true;

}

function qrcode($content){
    $content = urldecode($content);
    $qrcode = new \Endroid\QrCode\QrCode();
    $qrcode->setText($content);
    $src = $qrcode->writeString();
    return $src;
}


//获取最低等级会员
function getLowestLevel(){

    $level = db('user_level')->where('delete_time is null')->order('min_once_pay asc')->find();

    return $level;
}


//获取最低等级会员消费积分规则
function getLevelRule($level_id){

    $level = db('s_score_rule')
        ->where('delete_time is null')
        ->where('levelid',$level_id)
        ->find();

    $detail = json_decode($level['detail'],true);

    return $detail;
}



//升级某人会员等级---根据一次性消费金额
function levelUpgrade($userid,$level_id,$money){

    $level = getLevelByOnce($level_id,$money);

    if($level['code'] != 200){
        return true;
    }

    //修改用户等级
    $res = db('m_users')->where('id',$userid)->update(['level'=>$level['data']['level_id']]);
    if($res !== false){
        session('level',$level['data']['level_id']);
        session('level_name',$level['data']['level_name']);
        return true;
    }else{
        return false;
    }

}

/*
 * 获取当前会员等级---根据一次性消费金额
 * level_id  当前等级id
 * money     一次性消费金额
 */

function getLevelByOnce($level_id,$money){
    //等级规则信息,倒叙 等级高的再前
    $level = db('user_level')->where('delete_time is null')->order('min_once_pay desc')->select();

    foreach($level as $key => $val){
        if($val['id'] == $level_id){
            $level_name = $val['name'];
            $sort = $key;
            break;
        }
    }

    foreach($level as $k => $v){
        if($money >= $v['min_once_pay']){
            $new_level_id = $v['id'];
            $new_level_name = $v['name'];
            $new_sort = $k;
            break;
        }
    }

    //排序越靠前  等级越高
    if($sort < $new_sort){
        $new_level_id = $level_id;
        $new_level_name = $level_name;
    }

    return $new_level_id?$new_level_id:$level_id;
}


//获取当前会员等级---根据总消费金额和积分
function getLevelByTotal($userid){

    $userData = db('m_users')->where('id',$userid)->find();
    $total_consumption = $userData['total_consumption'];
    $total_score = $userData['total_score'];
    $level_id = $userData['level'];
    //print_r($userData);die;
    //等级规则信息
    $up_level_id = [];

    //等级规则信息,倒叙 等级高的再前
    $level = db('user_level')->where('delete_time is null')->order('min_once_pay desc')->select();

    foreach($level as $key => $val){
        if($val['id'] == $level_id){
            $sort = $key;
            break;
        }
    }

    foreach($level as $k => $v){
        $new_sort = $k;
        if($total_consumption >= $v['total_pay']&&(int)$total_score>=$v['deduct_score']&&$new_sort<$sort){
            $up_level_id[] = $v['id'];
        }
    }

    return $up_level_id ? $up_level_id : [];

}

//获取客户端ip
function getClientIP()
{
    if (isset($_SERVER)) {
        if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            /* 取X-Forwarded-For中第一个非unknown的有效IP字符串 */
            foreach ($arr AS $ip) {
                $ip = trim($ip);
                if ($ip != 'unknown') {
                    $realip = $ip;
                    break;
                }
            }
            if(!isset($realip)){
                $realip = "0.0.0.0";
            }
        } elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $realip = $_SERVER['HTTP_CLIENT_IP'];
        } else {
            if (isset($_SERVER['REMOTE_ADDR'])) {
                $realip = $_SERVER['REMOTE_ADDR'];
            } else {
                $realip = '0.0.0.0';
            }
        }
    } else {
        if (getenv('HTTP_X_FORWARDED_FOR')) {
            $realip = getenv('HTTP_X_FORWARDED_FOR');
        } elseif (getenv('HTTP_CLIENT_IP')) {
            $realip = getenv('HTTP_CLIENT_IP');
        } else {
            $realip = getenv('REMOTE_ADDR');
        }
    }
    preg_match("/[\d\.]{7,15}/", $realip, $onlineip);
    $realip = !empty($onlineip[0]) ? $onlineip[0] : '0.0.0.0';
    return $realip;
}

//根据IP获取当前位置
function getCity() {
    $getIp = getClientIP();
    $content = file_get_contents("http://api.map.baidu.com/location/ip?ak=2TGbi6zzFm5rjYKqPPomh9GBwcgLW5sS&ip={$getIp}&coor=bd09ll");
    $arr = json_decode($content,true);
    return $arr;
}

/*
* 店面查询
*/
function getShop($data){
    $hash = '5a005e0038270';
    $res = sx_call($hash,$data,'sx_mc');

    if($res['code'] == 200){
        return $res['data'];
    }else{
        return [];
    }
}

/*
* 人员详情
*/
function getStaff($data){
    $hash = '5a01766b4a3dd';
    $res = sx_call($hash,$data,'sx_mc');

    if($res['code'] == 200){
        return $res['data'];
    }else{
        return [];
    }
}

//过滤掉emoji表情
function filter_emoji($str)
{
    $str = preg_replace_callback(    //执行一个正则表达式搜索并且使用一个回调进行替换
        '/./u',
        function (array $match) {
            return strlen($match[0]) >= 4 ? '' : $match[0];
        },
        $str);

    return $str;
}

function get_escape_str($str){
    if(strpos($str," ") !== false){
        $str = str_replace(" ","%20",$str);
    }
    if(strpos($str,"+") !== false){
        $str = str_replace(" ","%2B",$str);
    }
    if(strpos($str,"&") !== false){
        $str = str_replace(" ","%26",$str);
    }

    return $str;
}

/**
 * 定制功能通过此函数判断，
 * 使用时直接使用此函数，并传入定制企业标识，如判断是否非常六加一的：
 * if(customize('xmfc6j1'))
 * {
 *     是定制六加1的逻辑。。。
 * }
 * @param  [type] $name [定制企业的标识]
 *                      xmfc6j1     厦门非常六加一
 *                      whxaf       武汉小阿福
 *                      cdtsyx      成都天使印像
 *                      babypastel  郑州babypastel
 *                      
 * @return [type]       true/false 是的，返回true不是的为false
 */
function customize($name,$productId=''){
    $mcproductId = $productId?$productId:session('mc_productid');
    if(!$mcproductId){
        $mc = new \app\common\lib\mcInterface();
        $data = $mc->cacheData('5ef1a04c80175');
        if($data){
            $mcproductId = $data['product_id'];
        }
    }
    switch ($mcproductId) {
        case '5903679116':
            if($name == 'xmfc6j1') return true;
            break;
        case '9657743504':
            if($name == 'whxaf') return true;
            break;
        case '9128787616':
            if($name == 'cdtsyx') return true;
            break;
        case '7921308917':
        case '7957528370':
            if($name == 'babypastel') return true;
            break;
        case '1804415325':
            if($name == 'panduola') return true;
            break;
        //以下为开发或测试环境，的MC的授权码，方便测试和开发时使用
        //加入了这里的授权码相当于是定制功能
        case '0428082539':
            return true;
            break;
        default:
            return false;
            break;
    }
    return false;
}

/**
 * 会员按店区分
 */
function isShopMain(){
    $shop_main = config('shop_main');
    foreach ($shop_main as $key => $value) {
        if(request()->domain() == $value['url']){
            $shop_id = $value['shop_id'];
            $shop_code = $value['shop_code'];
            $mall_url = $value['mall_url'];
        }
    }
    return ['shop_id'=>$shop_id,'shop_code'=>$shop_code,'mall_url'=>$mall_url];
}