<?php
/**
 * 系统常量配置。系统默认加载
 * 
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: songdemei<songdemei@suxuantech.cn> 2018-03-02 $
 */
namespace app\common\lib;
class upload {
    protected $serverPath = ROOT_PATH;//存文件使用，返回时不返回。
    protected $options = array(
        'root'=>DS.'public'.DS.'uploads',//相对于网站根目录，返回时返回此路径。
        'module'=>'',//哪个模块，在uploads下会按模块建目录
        'sub_directory'=>'',//子目录，在module和root后面再创建目录。
        'file_name_rand'=>true,//文件名是否随机
    );
    var $errid = 0;
    var $error = '';
    function __construct($options=array()) {
        if (!empty($options)) {
            $this->options = array_merge($this->options, $options);
        }

    }


    public function upFile($files,$subMixDir = false/*,$makeTmpFile = false*/){
        $targetDir = $this->getUploadDir();
        if($targetDir === false){
            return false;
        }
        $maxFileAge = 10 * 3600;
        /*如果指定生成临时文件，可以做到将文件传到临时文件夹，待操作数据库后，再移到正式目录里，后面再优化
        $tempDir = $dir.DS.'temp';
        if($makeTmpFile && $this->checkDir($tempDir) === false){
            //无法创建临目录
            return false;
        }
        */
        
        if (isset($_REQUEST["name"])) {
                $fileName = $_REQUEST["name"];
        } elseif (!empty($_FILES)) {
                $fileName = $_FILES["file"]["name"];
        } else {
                $fileName = uniqid("file_");
        }
        
        if($this->options['file_name_rand']){
            if(strpos( $fileName,'.') !== false){
                $fileExtend = substr($fileName,strrpos( $fileName,'.'));
            }else{
                $fileExtend = '';
            }
            $fileName = get_rand_string(32);
            $fileName .= $fileExtend;
        }
        
        if($subMixDir){
            //细化子目录
            $tmp = md5($fileName);
            $targetDir = $targetDir.DS.substr($tmp, 0,3);
            if($this->checkDir($targetDir) === false ){
                return false;
            }

        }
        $filePath = $targetDir . DS . $fileName;
        // Chunking might be enabled
        $chunk = isset($_REQUEST["chunk"]) ? intval($_REQUEST["chunk"]) : 0;
        $chunks = isset($_REQUEST["chunks"]) ? intval($_REQUEST["chunks"]) : 0;
        //删除临时目录
        if (!is_dir($targetDir) || !$dir = opendir($targetDir)) {
            $this->errid = 1004;
            $this->error = '无法读取目标目录：'.$targetDir;
            return false;
        }

        while (($file = readdir($dir)) !== false) {
                $tmpfilePath = $targetDir . DS . $file;

                // If temp file is current file proceed to the next
                if ($tmpfilePath == "{$filePath}.part") {
                        continue;
                }

                // Remove temp file if it is older than the max age and is not the current file
                if (preg_match('/\.part$/', $file) && (filemtime($tmpfilePath) < time() - $maxFileAge)) {
                        @unlink($tmpfilePath);
                }
        }
        closedir($dir);
        if (!$out = @fopen("{$filePath}.part", $chunks ? "ab" : "wb")) {
            $this->errid = 1005;
            $this->error='无法读取临时文件：'.$filePath.".part";
            return false;
        }

        if(empty($files)){
            if (!$in = @fopen("php://input", "rb")) {
                $this->errid = 1002;
                $this->error='无法读取上传文件';
                return false;
            }
            
        }else{
            if ($files["file"]["error"] || !is_uploaded_file($files["file"]["tmp_name"])) {
                $this->errid = 1003;
                $this->error = '上传文件失败';
                return false;

            }
            if (!$in = @fopen($files["file"]["tmp_name"], "rb")) {
                $this->errid = 1003;
                $this->error = '加载文件失败';
                return false;
            }
        }

        while ($buff = fread($in, 4096)) {
            fwrite($out, $buff);
        }

        @fclose($out);
        @fclose($in);

        if (!$chunks || $chunk == $chunks - 1) {
                // Strip the temp .part suffix off 
                rename("{$filePath}.part", $filePath);
        }
        $filePath = str_replace($this->serverPath, '', $filePath);
        return $filePath;
    }

    function checkDir($dir){
        if(!file_exists($dir)){
            $res = @mkdir($dir);
            if(!$res){
                $this->errid = 1001;
                $this->error='创建目录失败：'.$dir;
                return false;
            }
        }
        if(!is_writable($dir)){
            $this->errid = 1001;
            $this->error='目录不可写：'.$dir;
            return false;
        }
        return true;
    }
    function getUploadDir(){
        //var_dump($this->options);
        $dir = $this->serverPath . $this->options['root'];
        if(!empty($this->options['module'])){
            $dir .= DS.trim($this->options['module'],DS);
            if($this->checkDir($dir) == false){
                return false;
            }
        }
        if(!empty($this->options['sub_directory'])){
            $dir .= DS.trim($this->options['sub_directory'],DS);
            if($this->checkDir($dir) == false){
                return false;
            }
        }
        return $dir;
    }

}