<?php
/**
 * 摄影师控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: YanLipeng <YanLipeng@suxuantech.cn>  2017年11月16日 下午3:48:53
 */
namespace app\front\controller;
use think\Controller;
use think\Session;
class Cameraman extends Controller{
    /**
     * 方法描述: 摄影师关注
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function follower () {
        $camid = input('post.camId');
        $userid = Session::get('memid');
        if (empty($camid)) {
            $arr = array('code'=>0,'msg'=>'摄影师不能为空');
            return json($arr);
        }

        $data = array('cam_id'=>(int)$camid,'userid'=>(int)$userid);
        $res = db('cam_attention')->insert($data);
        if ($res) {
            $arr = array('code'=>1,'msg'=>'关注成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'关注失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 用户立即付款页
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function payer () {

        //拍照日期待选择
        $camId = input('get.id');
        $camData = db('cameraman')
            ->alias('a')
            ->join('cam_type b','a.c_rank = b.typeid')
            ->where('id','=',$camId)
            ->find();
        $order = '101'.rand(11111,99999).rand(111,899);
        $orderName = $camData['type_name'].'---'.$camData['c_name'];
        $orderTime = date('Y-m-d');
        return view();
    }
//    /**
//     * 方法描述: 用户评论摄影师入库
//     * @return mixed
//     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
//     */
//    public function commentAdd () {
//
//    }

    /**
     * 方法描述: 摄影师用户评论列表
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function observer () {
        $id = input('get.id');
        $where = array('camid'=>$id);
        $result = db('cam_evaluate')->where($where)->find();
        $this->assign('obData',$result);
        return view();
    }
    /**
     * 方法描述: 用户评论摄影师
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function observerMan () {
        $img = input('post.img');
        $userid = Session::get('memid');
        $data = array(
            'userid' => $userid,
            'camid' => input('post.camId'),
            'counts' => input('post.contents'),
            'several_star' => input('post.'),
            'evaluate_title' => htmlspecialchars(input('post.evaluate_title')),
            'evaluate_time' =>date('Y-m-d'),
            'brandid' => Session::get('brand_id'),
        );
        if($img){
            $imgArr  = [];
            foreach($img as $v){
                $imgArr[] = saveImg($v,500,400);
            }
            $data['evaluate_img'] = $imgArr?implode(',',$imgArr):'';
        }
        $result = db('cam_evaluate')->insert($data);
        if ($result) {
            $arr = array('code'=>1,'msg'=>'恭喜您评价成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'系统延迟.请稍后再试');
            return json($arr);
        }
    }

    /**
     * 方法描述: 用户评论用户所评价内容
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function obReply () {
        $evaluateId = input('get.id');  //获取到哪条详情评论id
        $userid = Session::get('memid');  //获取到当前评论人id
        $replyContent = input('post.content');  //评论人内容
        $array = array(
            'e_id' => $evaluateId,
            'userid' => $userid,
            'r_count' =>$replyContent,
            'r_time' => date('Y-m-d'),
        );
        $result = db('cam_reply')->insert($array);  //信息入库
        if ($result) {
            $res = db('cam_evaluate')->where('e_id','=',$evaluateId)->setInc('evaluate_count',1);
            if (!$res) {
                $arr = array('code'=>2,'msg'=>'详情评论回复+1失败');
                return json($arr);
            }
            $arr = array('code'=>1,'msg'=>'恭喜你回复成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'抱歉,系统繁忙');
            return json($arr);
        }
    }
    /**
     * 方法描述: 用户点赞
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function like () {
        $evaluateId = input('post.id');  //获取到哪条详情评论id
        $camId = input('post.camid');
        $userid = Session::get('memid');  //获取到当前评论人id
        if ($evaluateId) {
            $data = array(
                'e_id' => $evaluateId,
                'userid' => $userid,
                'spot_time' => date('Y-m-d'),
                'spot_type' => 1,
            );
            $res = db('cam_spot')->insert($data);
            if ($res) {
                $arr = array('code'=>1,'msg'=>'点赞成功');
                return json($arr);
            } else {
                $arr = array('code'=>0,'msg'=>'点赞失败');
                return json($arr);
            }
        } else {
            $data = array(
                'e_id' => $evaluateId,
                'userid' => $userid,
                'spot_time' => date('Y-m-d'),
                'spot_type' => 2,
                'cam_id' => $camId
            );
            $res = db('cam_spot')->insert($data);
            if ($res) {
                $arr = array('code'=>1,'msg'=>'为该作品点赞成功');
                return json($arr);
            } else {
                $arr = array('code'=>0,'msg'=>'点赞失败');
                return json($arr);
            }
        }
    }
    /**
     * 方法描述: 微信支付
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function weChatPay () {

    }
    /**
     * 方法描述: 摄影师作品展示
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function camProduction () {
        $res = db('cam_production')->select();
        $id = input('get.id');

    }



}