<?php
/**
 * 会员中心首页
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Zhao Jie Peng <zhaojiepeng@suxuantech.cn>  2017年11月16日 下午3:48:53
 */
namespace app\front\controller;
use app\front\lib\Rili;
use think\Cache;
use app\vip\model\TTaskList;
use think\Controller;
use think\Db;
use think\db\Query;
use think\image\Exception;
use think\Session;
use app\front\controller\BaseFront;
use app\front\model\Mem;
class Index extends BaseFront
{
    /**
     * 方法描述: 会员中心首页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function indexOld(){
        $memData = [
            'username' => Session::get('username'),
            //'total_score' => Session::get('total_score'),
            'growth_value' => Session::get('growth_value'),
            'mem_phone' => Session::get('mem_phone'),
            'user_number' => Session::get('user_number'),
            'openid' => Session::get('openid')
        ];
        $wxId = Session::get('memid');
        $memData['total_score'] = \db('minute_log')->where('m_executor', $wxId)->sum('m_num');
        // 获取优惠券的总数 ，并放入cache
        $cachekey = 'couponTotal_status_0_userid_' . $this->userId;
        $couponTotal = cache($cachekey);
        if (!$couponTotal) {
            $couponTotal = controller('index', 'lib')->getUserCouponCount($this->userId, 0, $this->userPhoneId);
            if ($couponTotal) {
                cache($cachekey, $couponTotal);
            }
        }
        $memData['userCouponTotal'] = $couponTotal;
        // 获取用户级别信息
        $levelInfo = getLevel(['userid' => $this->userId]);
        $memData['levelName'] = $levelInfo ? $levelInfo['name'] : '';
        // 设置头部信息和分享信息
        $setInfo = [
            'title' => '尊享专区',
            'content' => '会员专享专区，任务，活动一览',
            'keywords' => '尊享'
        ];
        $shopUrl = Session::get('shop_url');
        $appConfig = config('ext.app_config');
        $addr = $appConfig[strtolower("sx_vipshop")]['addr'];    //从接口获取路径
        $this->assign([
            'setInfo' => $setInfo,
            'memData' => $memData,
            'shopUrl' => $shopUrl ? $shopUrl : $addr
        ]);
        return view('indexold');
    }
    /**
     * 方法描述: 签到页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function sign(){
        $userid = Session::get('memid');
        $y  = empty(input('get.y')) ? date('Y', time()) : input('get.y');
        $m  = empty(input('get.m')) ? date('m', time()) : input('get.m');
        $YM = date('Ym', strtotime($y . '-' . $m));
        $M  = substr($YM, 4, 2);
        $thisTableName = 'sign_detail_' . $YM;  //当前时间表名
        //$a = checkTableExists($thisTableName);

        $start = $y . "-" . $M . "-01";
        $time = date('t', strtotime($start));
        $end = $y . "-" . $M . "-$time" . ' 23:59:59';

        // 查询用户信息
        //$userinfo = getUserInfo(['userid' => $this->userId]);
        $userinfo = db('m_users')->where('id',$this->userId)->find();
        //$userinfo['total_score']=db('minute_log')->where('m_executor',$userid)->sum('m_num');//积分总和，查log表
        Session::set('total_sign', (int)$userinfo['total_sign']);
        // 当前要查看年月份
        $queryTime = $YM;
        // 用户注册的月份
        $regTime = date('Ym', strtotime($userinfo['create_time']));
        // 当前真实的年月份
        $currentTime = date('Ym');
        // 存储用户签到的日期
        $arr_day = array();
        // 判断当前的查询时间是不是超过了时间的年月和查询的时间大于注册的时间就去查询签到记录,否则不查询

        if ($queryTime <= $currentTime) {
            // 查询表是否存在不存在不查询
            /*
            $cachekey = $thisTableName.'_hasTable';
            $isHasTable = cache($cachekey);
            if(!$isHasTable){
                $sql ="show tables like '%$thisTableName%'";
                $isHasTable = Db::query($sql);
                $hastable = $isHasTable?1:0;
                cache($cachekey,$hastable,300);
            }*/
            $isHasTable = checkTableExists($thisTableName);
            //如果表存在，则取出表内的所有签到数据
            if ($isHasTable) {
                
                $cachekey = 'sign_days_' . $this->userId . '_' . $YM;
                $signDetails = cache($cachekey);
                if (!$signDetails) {
                    $signDetails = db($thisTableName)->where('userid', '=', $this->userId)->whereTime('sign_time', 'between', [$start, $end])->select();  //根据时间查询当月天数
                    if ($signDetails) {
                        cache($cachekey, $signDetails);
                    }
                }
                // 循环出一个月内签到的日子
                //print_r($signDetails);
                foreach ($signDetails as $v) {
                    $dayss = $v['sign_time'];
                    $day_day = substr($dayss, 8, 2);
                    $arr_day[] = (int)$day_day;
                }

            }
        }

        // 查询连续或累计的奖励积分是否领取
        $cachekey = 'sign_Awa_' . $this->userId;
        $resDa = cache($cachekey);
        if (!$resDa) {
            $resDa = db('sign_awa')->alias('a')->join('sign_get b', 'a.id=b.awa_id')->where(['a.userid' => $this->userId])->field('a.sign_day,a.type')->select(); //累计
            cache($cachekey, $resDa);
            //echo db()->getLastSql();
        }

        $new = $news = [];
        foreach ($resDa as $v) {
            if ($v['type'] == 1) {
                $new[] = $v['sign_day'];
            } else {
                $news[] = $v['sign_day'];
            }
        }
        $resDas = implode(',', $new);  //累计
        $resDasa = implode(',', $news); //连续
        // $resDass = db('sign_awa')->alias('a')->join('sign_get b','a.id=b.awa_id')->where('a.userid','=',$userid)->where('b.type','=',2)->field('sign_day')->select(); //累计
        // $news = [];
        // foreach ($resDass as $v) {
            // $news[] = $v['sign_day'];
        // }

        //$signAwaData = db('sign_awa')->where(array('userid'=>$userid))->select();  //连续签到领取奖励
        // var_dump($signAwaData);exit;
        // 查询签到积分规则
        // 当前真是的年月份 用来统计本月
        $trueTimeTable = 'sign_detail_' . $currentTime;
        $rule = getScoreRule(['userid' => $this->userId]);
        //$rule = db('s_score_rule')->where('levelid','=',$memSum['level'])->find();  //根据等级id查询签到规则
        //$ruleKe = json_decode($rule['detail'],true);  //将获取到的id规则json转换回来
        $succey = (int)$rule['supply_sign'];
        Session::set("supply_sign", $succey);

        // 用户当天签到信息
        $todayDate = date('Y-m-d', time());
        $cachekey = 'sign_' . $this->userId . '_' . $todayDate;

        $todaySign = cache($cachekey);
        if (!$todaySign && checkTableExists($trueTimeTable)) {
            $todaySign = db($trueTimeTable)->where(['userid' => $this->userId,])->where('sign_time','like', $todayDate.'%')->find();
            if ($todaySign) {
                cache($cachekey, $todaySign);
            }
        }

        // 用户昨天签到信息
        $yestodayDate = date('Y-m-d', strtotime('-1 day'));
        $cachekey = "sign_" . $this->userId . "_" . $yestodayDate;

        $yestodaySign = cache($cachekey);
        if (intval(date('d')) == 1) {
            $yestodayDb = 'sign_detail_' . date('Ym', strtotime('-1 day'));
        } else {
            $yestodayDb = $trueTimeTable;
        }
        if (!$yestodaySign && checkTableExists($yestodayDb)) {
            $yestodaySign = db($yestodayDb)->where(['userid' => $this->userId])->where('sign_time', '=', $yestodayDate)->find();
            if ($yestodaySign) {
                cache($cachekey, $yestodaySign);
            }
        }

        $cachekey = 'sign_total_' . $todayDate;
        $signTotal = cache($cachekey);

        if (!$signTotal) {
            $tomorrow = date("Y-m-d",strtotime("$todayDate +1 day"));
            $signTotal = db($trueTimeTable)->where('sign_time', 'between', [$todayDate,$tomorrow])->count();  //当天签到统计
            if ($signTotal) {
                cache($cachekey, $signTotal, 30);
            }
        }
        if ($todaySign) {
            $seriaSignNum = (int)$todaySign['sign_sum'];
        } else {
            $seriaSignNum = $yestodaySign ? (int)$yestodaySign['sign_sum'] : 0;
        }

        // 排名查询--改为当前第几个签到的
        $tableName = 'sign_detail_' . date('Ym');
        $signInfo = db($trueTimeTable)
            ->where('userid', $this->userId)
            ->where('sign_time', 'like', $todayDate.'%')
            ->find();
        if (!$signInfo) {
            $ranking = 0;
        } else {
            $ranking = db($trueTimeTable)
                ->where('sign_time', 'like', $todayDate.'%')
                ->where('id', '<=', $signInfo['id'])->count();
            $ranking = $ranking ? (int)$ranking : 1;
        }
        
      /*  $cachekey = 'sign_rowno_'.$userid;
        $rownoData = cache($cachekey);
        if(!$rownoData){
            $rownoData = db('m_users')->alias('u')
            ->field('p.id as pid,p.total_sign ptota l_sign,p.phone,u.id,u.total_sign')
            ->join('m_users_phone p','p.userid=u.id','left')
            ->select();
            cache($cachekey,$rownoData,30);
        }
        
        foreach ($rownoData as $k=>$v) {
               $data[$v['id']]= ($v['pid']?$v['ptotal_sign']:$v['total_sign']);
        }

        arsort($data);
        $ranking = array_search($this->userId,array_keys($data))+1;*/

        
        // 查询连续签到的奖励类型数据
        $signData = array('first_sign' => Cache::get('first_sign'), 'everyday_sign' => Cache::get('everyday_sign'));

        //日历控件数据
        $days = new Rili($arr_day);
        $day = $days->showCalendar();

        //当前登录者总积分
        //$memSums = Session::get('total_score');
        $memSums = \db('minute_log')->where('m_executor', $userid)->sum('m_num');
        //print_r($memSums);die;
        //$todayScore = cache::get('today_sign_score');
        //echo $todayScore;

        // 获取今日签到的获取的积分
        $cachekey = 'sign_totday_score_' . $this->userId . '_' . date('Ymd', time());
        $todayScore = cache($cachekey);

        // 累计规则
        $grandRule = $rule['grand_rule'];
        // 持续规则
        $keepRule = $rule['keep_rule'];
        if (($grandRule || $keepRule) && $userinfo['total_sign'] > 0) {
            $alreadyReceive = db('sign_awa')->where(array('userid' => $this->userId))->select();
            if ($alreadyReceive) {
                foreach ($alreadyReceive as $k => $v) {
                    if ($v['type'] == 1) {
                        $grandRecord[] = $v['sign_day'];
                    } else if ($v['type'] == 2) {
                        $keepRecord[] = $v['sign_day'];
                    }
                }
                if ($grandRecord) {
                    foreach ($grandRule as $k => $v) {
                        $grandRule[$k]['receive'] = in_array($v['days'], $grandRecord);
                    }
                }
                if ($keepRecord) {
                    foreach ($keepRule as $k => $v) {
                        $keepRule[$k]['receive'] = in_array($v['days'], $keepRecord);
                    }
                }
            }
        }

        if (!$todayScore) {
            // $todayScore = (int)$rule['everyday_sign'];
            $where['m_executor'] = $userid;
            //$where['m_type'] = 1;
            //$where['m_title'] = ['like', '%签到%'];
            $where['m_time'] = ['>', date('Y-m-d 0:0:0', time())];
            $where['m_type']   = 1; //签到积分
            $todayScore = \db('minute_log')->where($where)->value('m_num');
        }

        // 设置头部信息和分享信息
        $setInfo = [
            'title' => '签到中心',
            'content' => '会员签到中心',
            'keywords' => '',
        ];

        //筛选出可补签的日期
        $array_day = $arr_day;
        asort($array_day);
        $bu_day = [];
        for ($i=1; $i < end($array_day); $i++) { 
            if(!in_array($i,$array_day)){
                $bu_day[] = $i;    
            }
        }
        //签到
        $signdata = db('t_task_list')->where("typeid",1)->find();
        $EveryScores = json_decode($signdata['detail'],true)['everyday']['scores'];
        //判断当天是否已签到
        $is_everySign = db('t_task_user_list')
                       ->where('typeid','1_4')
                       ->where('userid',$this->userId)
                       ->whereTime('create_time','today')
                       ->find();
        $this->assign([
            'bu_day'        => json_encode($bu_day),//补签的日期
            'month'         => date('n'),
            'arr_day'       => json_encode($arr_day),//一个月内签到的日子
            'setInfo'       => $setInfo, // 设置头部信息和分享信息
            'a'             => $resDas, // 设置头部信息和分享信息
            'b'             => $resDasa, // 设置头部信息和分享信息
            'day'           => $day, // 日历
            'count'         => $signTotal, //当天总签到人数
            'signSum'       => $ranking, //排名
            'yestodaySign'  => $yestodaySign, //昨天簽到查詢
            'signData'      => $signData, //排名
            'todaySign'     => $todaySign,  // 当天签到信息
            'todayIsSign'   => $todaySign['id'],  // 当天是否签到
            'memsum'        => $userinfo,  // 用户信息数据
            'memsums'       => $memSums,  //总积分
            'scoreRule'     => $rule, //积分规则
            //'todayScore'    => (int)$todayScore ? $todayScore : 0, //当前签到应领取积分（原版）
            'todayScore'    => (int)$EveryScores ? $EveryScores : 0, //当前签到应领取积分（新版）
            'is_everySign'  => $is_everySign,
            'seriaSignNum'  => $seriaSignNum,
            'grandRule'     => $grandRule,  // 累计规则
            'keepRule'      => $keepRule    // 持续规则
        ]);
        return $this->fetch();
    }
    public function signDetail(){
        $userid = Session::get('memid');
        $y  = empty(input('get.y')) ? date('Y', time()) : input('get.y');
        $m  = empty(input('get.m')) ? date('m', time()) : input('get.m');
        $YM = date('Ym', strtotime($y . '-' . $m));
        $M  = substr($YM, 4, 2);
        $thisTableName = 'sign_detail_' . $YM;  //当前时间表名
        //$a = checkTableExists($thisTableName);

        $start = $y . "-" . $M . "-01";
        $time = date('t', strtotime($start));
        $end = $y . "-" . $M . "-$time" . ' 23:59:59';

        // 查询用户信息
        $userinfo = getUserInfo(['userid' => $this->userId]);
        //$userinfo['total_score']=db('minute_log')->where('m_executor',$userid)->sum('m_num');//积分总和，查log表
        Session::set('total_sign', (int)$userinfo['total_sign']);
        // 当前要查看年月份
        $queryTime = $YM;
        // 用户注册的月份
        $regTime = date('Ym', strtotime($userinfo['create_time']));
        // 当前真实的年月份
        $currentTime = date('Ym');
        // 存储用户签到的日期
        $arr_day = array();
        // 判断当前的查询时间是不是超过了时间的年月和查询的时间大于注册的时间就去查询签到记录,否则不查询

        if ($queryTime <= $currentTime) {
            // 查询表是否存在不存在不查询
            /*
            $cachekey = $thisTableName.'_hasTable';
            $isHasTable = cache($cachekey);
            if(!$isHasTable){
                $sql ="show tables like '%$thisTableName%'";
                $isHasTable = Db::query($sql);
                $hastable = $isHasTable?1:0;
                cache($cachekey,$hastable,300);
            }*/
            $isHasTable = checkTableExists($thisTableName);
            //如果表存在，则取出表内的所有签到数据
            if ($isHasTable) {

                $cachekey = 'sign_days_' . $this->userId . '_' . $YM;
                $signDetails = cache($cachekey);
                if ($signDetails) {
                    $signDetails = db($thisTableName)->where('userid', '=', $this->userId)->whereTime('sign_time', 'between', [$start, $end])->select();  //根据时间查询当月天数
                    if ($signDetails) {
                        cache($cachekey, $signDetails);
                    }
                }
                // 循环出一个月内签到的日子
                //print_r($signDetails);
                foreach ($signDetails as $v) {
                    $dayss = $v['sign_time'];
                    $day_day = substr($dayss, 8, 2);
                    $arr_day[] = (int)$day_day;
                }

            }
        }
        // 查询连续或累计的奖励积分是否领取
        $cachekey = 'sign_Awa_' . $this->userId;
        $resDa = cache($cachekey);
        if (!$resDa) {
            $resDa = db('sign_awa')->alias('a')->join('sign_get b', 'a.id=b.awa_id')->where(['a.userid' => $this->userId])->field('a.sign_day,a.type')->select(); //累计
            cache($cachekey, $resDa);
            //echo db()->getLastSql();
        }
        //print_r($resDa);die;

        $new = $news = [];
        foreach ($resDa as $v) {
            if ($v['type'] == 1) {
                $new[] = $v['sign_day'];
            } else {
                $news[] = $v['sign_day'];
            }

        }
        $resDas = implode(',', $new);  //累计
        $resDasa = implode(',', $news); //连续
//         $resDass = db('sign_awa')->alias('a')->join('sign_get b','a.id=b.awa_id')->where('a.userid','=',$userid)->where('b.type','=',2)->field('sign_day')->select(); //累计
//         $news = [];
//         foreach ($resDass as $v) {
//             $news[] = $v['sign_day'];
//         }


        //$signAwaData = db('sign_awa')->where(array('userid'=>$userid))->select();  //连续签到领取奖励
//        var_dump($signAwaData);exit;
        // 查询签到积分规则
        // 当前真是的年月份 用来统计本月
        $trueTimeTable = 'sign_detail_' . $currentTime;
        $rule = getScoreRule(['userid' => $this->userId]);
        //$rule = db('s_score_rule')->where('levelid','=',$memSum['level'])->find();  //根据等级id查询签到规则
        //$ruleKe = json_decode($rule['detail'],true);  //将获取到的id规则json转换回来
        $succey = (int)$rule['supply_sign'];
        Session::set("supply_sign", $succey);

        // 用户当天签到信息
        $todayDate = date('Y-m-d', time());
        $cachekey = 'sign_' . $this->userId . '_' . $todayDate;
        $todaySign = cache($cachekey);
        if (!$todaySign && checkTableExists($trueTimeTable)) {
            $todaySign = db($trueTimeTable)->where(['userid' => $this->userId, 'sign_time' => $todayDate])->find();
            //print_r($todaySign);
            if ($todaySign) {
                cache($cachekey, $todaySign);
            }
        }

        // 用户昨天签到信息
        $yestodayDate = date('Y-m-d', strtotime('-1 day'));
        $cachekey = "sign_" . $this->userId . "_" . $yestodayDate;
        $yestodaySign = cache($cachekey);
        if (intval(date('d')) == 1) {
            $yestodayDb = 'sign_detail_' . date('Ym', strtotime('-1 day'));
        } else {
            $yestodayDb = $trueTimeTable;
        }
        if (!$yestodaySign && checkTableExists($yestodayDb)) {
            $yestodaySign = db($yestodayDb)->where(['userid' => $this->userId])->where('sign_time', '=', $yestodayDate)->find();
            if ($yestodaySign) {
                cache($cachekey, $yestodaySign);
            }
        }
        $cachekey = 'sign_total_' . $todayDate;
        $signTotal = cache($cachekey);
        if (!$signTotal) {
            $signTotal = db($trueTimeTable)->where('sign_time', '=', $todayDate)->count();  //当天签到统计

            if ($signTotal) {
                cache($cachekey, $signTotal, 30);
            }
        }
        if ($todaySign) {
            $seriaSignNum = (int)$todaySign['sign_sum'];
        } else {
            $seriaSignNum = $yestodaySign ? (int)$yestodaySign['sign_sum'] : 0;
        }

        // 排名查询--改为当前第几个签到的
        $tableName = 'sign_detail_' . date('Ym');
        $signInfo = db($trueTimeTable)
            ->where('userid', $this->userId)
            ->where('sign_time', '=', $todayDate)
            ->find();
        if (!$signInfo) {
            $ranking = 0;
        } else {
            $ranking = db($trueTimeTable)
                ->where('sign_time', '=', $todayDate)
                ->where('id', '<', $signInfo['id'])->count();

            $ranking = $ranking ? (int)$ranking : 1;
        }
        /*
        $cachekey = 'sign_rowno_'.$userid;
        $rownoData = cache($cachekey);
        if(!$rownoData){
            $rownoData = db('m_users')  ->alias('u')
            ->field('p.id as pid,p.total_sign ptotal_sign,p.phone,u.id,u.total_sign')
            ->join('m_users_phone p','p.userid=u.id','left')
            ->select();
            cache($cachekey,$rownoData,30);
        }
        foreach ($rownoData as $k=>$v) {
               $data[$v['id']]= ($v['pid']?$v['ptotal_sign']:$v['total_sign']);
        }

        arsort($data);
        $ranking = array_search($this->userId,array_keys($data))+1;

        */
        // 查询连续签到的奖励类型数据
        $signData = array('first_sign' => Cache::get('first_sign'), 'everyday_sign' => Cache::get('everyday_sign'));
        //日历控件数据
        $days = new Rili($arr_day);
        $day = $days->showCalendar();
        //当前登录者总积分
        //$memSums = Session::get('total_score');
        $memSums = \db('minute_log')->where('m_executor', $userid)->sum('m_num');
        //$todayScore = cache::get('today_sign_score');
        //echo $todayScore;

        // 获取今日签到的获取的积分
        $cachekey = 'sign_totday_score_' . $this->userId . '_' . date('Ymd', time());
        $todayScore = cache($cachekey);


        // 累计规则
        $grandRule = $rule['grand_rule'];
        // 持续规则
        $keepRule = $rule['keep_rule'];
        if (($grandRule || $keepRule) && $userinfo['total_sign'] > 0) {
            $alreadyReceive = db('sign_awa')->where(array('userid' => $this->userId))->select();
            if ($alreadyReceive) {
                foreach ($alreadyReceive as $k => $v) {
                    if ($v['type'] == 1) {
                        $grandRecord[] = $v['sign_day'];
                    } else if ($v['type'] == 2) {
                        $keepRecord[] = $v['sign_day'];
                    }
                }
                if ($grandRecord) {
                    foreach ($grandRule as $k => $v) {
                        $grandRule[$k]['receive'] = in_array($v['days'], $grandRecord);
                    }
                }
                if ($keepRecord) {
                    foreach ($keepRule as $k => $v) {
                        $keepRule[$k]['receive'] = in_array($v['days'], $keepRecord);
                    }

                }
            }
        }

        if (!$todayScore) {
//            $todayScore = (int)$rule['everyday_sign'];
            $where['m_executor'] = $userid;
            //$where['m_type'] = 1;
            //$where['m_title'] = ['like', '%签到%'];
            $where['m_time'] = ['>', date('Y-m-d 0:0:0', time())];
            $todayScore = \db('minute_log')->where($where)->value('m_num');
        }
        // 设置头部信息和分享信息
        $setInfo = [
            'title' => '签到中心',
            'content' => '会员签到中心',
            'keywords' => ''
        ];
        $this->assign([
            'setInfo' => $setInfo, // 设置头部信息和分享信息
            'a' => $resDas, // 设置头部信息和分享信息
            'b' => $resDasa, // 设置头部信息和分享信息
            'day' => $day, // 日历
            'count' => $signTotal, //当天总签到人数
            'signSum' => $ranking, //排名
            'yestodaySign' => $yestodaySign, //昨天簽到查詢
            'signData' => $signData, //排名
            'todaySign' => $todaySign,  // 当天签到信息
            'todayIsSign' => $todaySign['id'],  // 当天是否签到
            'memsum' => $userinfo,  // 用户信息数据
            'memsums' => $memSums,  //总积分
            'scoreRule' => $rule, //积分规则
            'todayScore' => (int)$todayScore ? $todayScore : 0,
            'seriaSignNum' => $seriaSignNum,
            'grandRule' => $grandRule,  // 累计规则
            'keepRule' => $keepRule    // 持续规则
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 会员中心页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function personalCenter()
    {

        $userinfo = getUserInfo(['userid' => $this->userId]);
        $isUp = $userinfo['update_time'] ? 1 : 0;
        $isReg = $userinfo['phone'] ? 1 : 0;
        // 获取当前用户级别的级别信息
        $levelInfo = getLevel(['userid' => $this->userId]);
        $bigerLevelInfo = getLevel(['userid' => $this->userId, 'biger' => 1, 'fields' => 'max_value,name']);
        if ($levelInfo) {
            $vipMemData = db('membereq')->where('eq_card_type', '=', $levelInfo['id'])->select();  //查询处当前登录人会员下可以享受什么权益
        }
        $rule = getScoreRule(['userid' => $this->userId]);
        $perfectinfoScore = $rule && $rule['perfectinfo'] ? $rule['perfectinfo'] : 0;
        $regScore = $rule && $rule['reg_suc'] ? $rule['reg_suc'] : 0;
        if ($bigerLevelInfo) {
            $surplus = $bigerLevelInfo['max_value'] - $userinfo['growth_value'];
        } else {
            $surplus = -1;
        }
        $this->assign([
            'setInfo' => ['title' => '个人中心'],
            'perfectinfoScore' => $perfectinfoScore,
            'regScore' => $regScore,
            'surplus' => $surplus,
            'nextLevelName' => $bigerLevelInfo['name'],
            'vipMemData' => $vipMemData,
            'isUp' => $isUp,
            'isReg' => $isReg,
            'grandData' => $levelInfo,
            'memData' => $userinfo
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 推荐新人
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function recommend()
    {
        $adv = controller('index', 'lib')->getAdv(3);
        $this->assign('adv', $adv);
        return $this->fetch();
    }

    /**
     * 方法描述: 已推荐人列表
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function recommendList()
    {
        $where = makeWhere($this->userId, $this->userPhoneId);
        $memData = db('recommend')
            ->field('id,r_phone,r_sex,r_username,userid,status,recom_num')
            ->where($where)
            ->where('brandid', '=', $this->brandId)
            ->order('create_time desc')
            ->select();
        $personNum = 0;
        $scores = 0;
        for ($i = 0; $i < count($memData); $i++) {
            if ($memData[$i]['status'] == 2) {
                $personNum++;
                $scores += (int)$memData[$i]['recom_num'];
            }
        }
        $adv = controller('index', 'lib')->getAdv(4);
        $this->assign([
            'setInfo' => ['title' => '我的推荐列表'],
            'adv' => $adv,
            'memData' => $memData,
            'memSum' => $personNum,
            'scores' => $scores
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 优惠券列表
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function coupon()
    {
        $status = (int)input('post.status');
        $status = in_array($status, [0, 1, 2]) ? $status : 0;
        $c = [
            'userid' => $this->userId,
            'status' => $status,
            'limit' => 5,
            'page' => input('post.page'),
        ];
        $cachekey = 'coupon_total_status_' . $status . '_' . $this->userId;
        $total = cache($cachekey);

        if (!$total) {
            $total = controller('index','lib')->getUserCouponCount($this->userId, $status);
            cache($cachekey, $total);
        }
        if (request()->isAjax()) {
            $data = controller('index', 'lib')->getCoupon($c, $status);
            return json(['data' => $data, 'total' => $total, 'status' => 1]);
        } else {
            $cachekey = 'coupon_all_list_' . $this->userId;
            //$data = cache($cachekey);
            //if(!$data){
            $data = controller('index', 'lib')->getCoupon2($c);
            cache($cachekey, $data);
            //}
        }
        $this->assign([
            'data' => $data,
            'setInfo' => ['title' => '我的优惠券'],
        ]);
        return $this->fetch();
    }


    /**
     * 方法描述: 领取优惠券
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function receiveCoupon()
    {
        if (request()->isAjax()) {
            $c = [
                'userid'     => $this->userId,
                'coupon_num' => (int)input('request.couponid'),
                'phoneid'    => $this->userPhoneId,
                'activityid' => (int)input('request.activityid'),
            ];
            if($c['userid'] && $c['coupon_num']){ 
                $d = controller('index', 'lib')->getReceive($c);
                if($d){
                    $cachekey = 'coupon_total_' . $this->userId;
                    Cache::rm('coupon_*');
//                  $total = cache($cachekey);
//                  if(!isset($total)){
//                      $total = controller('index','lib')->getUserCouponCount($c['userid'],0,$this->userPhoneId);
//                      cache($cachekey,$total);
//                  }
//                  cache($cachekey,(int)$total+1);
                    $res = json_decode($d,true);
                    return json($res);
                }
                $this->error('领取失败，优惠券抢光了');
            }else{
                $this->error('信息有误,无法领取优惠券');
            }
        } else {
            return $this->coupon();
        }

    }

    /**
     * 方法描述: 会员秘书
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function sec()
    {
        return $this->fetch();
    }

    /**
     * 方法描述: 意见反馈
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function feedback()
    {
        if (request()->isAjax()) {
            $d = [
                'userid' => $this->userId,
                'content' => htmlspecialchars(input('post.content')),
                'typeid' => (int)input('post.typeid'),
                'create_time' => date('Y-m-d H:i:s', time()),
                'brandid' => $this->brandId,
                'iswid' => $this->userPhoneId ? 0 : 1,
            ];
            $imgs = input('file.img');
            if ($imgs) {
                $imgArr = [];
                foreach ($imgs as $v) {
                    $imgArr[] = saveImg($v, 500, 400);
                }
                $d['imgs'] = $imgArr ? implode(',', $imgArr) : '';
            }

            $res = controller('index', 'lib')->addFeedback($d);
            $data = array('mes_title' => $d['typeid'] == 1 ? '投诉' : '建议', 'mes_count' => $d['content'], 'mes_status' => 0, 'mes_type' => $d['typeid'], 'com_id' => $res);
            if ($res) {
                $messData = db('message')->insert($data);
            }
            $ajaxres = $res ? ['status' => 1] : ['status' => 0];
            return json($ajaxres);
        } else {
            $adv = controller('index', 'lib')->getAdv(5);
            $this->assign([
                'setInfo' => ['title' => '投诉建议'],
                'adv' => $adv,
            ]);
            return $this->fetch();
        }
    }

    /**
     * 方法描述: 在线预约
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function bespeak()
    {
        return $this->fetch();
    }

    /**
     * 方法描述: 在线预约,选择日期
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function bespeakDay()
    {
        return $this->fetch();
    }

    /**
     * 方法描述: 玩转积分
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function scoreExplain()
    {
        $scoreRule = getScoreRule(['userid' => $this->userId, 'phoneid' => $this->userPhoneId]);
        $html = '';
        if ($scoreRule) {
            if ($scoreRule['first_land']) {
                $html .= '<div class="jf_j2">登陆赚积分</div><ul class="jf_ul">';
                $html .= '<li>第一次登陆,可以获得' . $scoreRule['first_land'] . '个积分</li>';
                $html .= '</ul>';
            }
            if ($scoreRule['first_sign'] || $scoreRule['everday_sign'] || $scoreRule['keep_rule'] || $scoreRule['grand_rule']) {
                $html .= '<div class="jf_j2">签到赚积分</div><ul class="jf_ul">';
                if ($scoreRule['first_sign']) {
                    $html .= '<li>第一次签到,可以获得' . $scoreRule['first_sign'] . '个积分</li>';
                }
                if ($scoreRule['everyday_sign']) {
                    $html .= '<li>每日签到,可以获得' . $scoreRule['everyday_sign'] . '个积分</li>';
                }
                if ($scoreRule['brithday_sign']) {
                    $html .= '<li>生日当天签到,可以获得' . $scoreRule['brithday_sign'] . '个积分</li>';
                }
                if ($scoreRule['merryday_sign']) {
                    $html .= '<li>结婚纪念日当天签到,可以获得' . $scoreRule['merryday_sign'] . '个积分</li>';
                }
                if ($scoreRule['keep_rule']) {
                    foreach ($scoreRule['keep_rule'] as $v) {
                        $html .= '<li>持续签到' . $v['days'] . '天,可以获得' . $v['scores'] . '个积分</li>';
                    }
                }
                if ($scoreRule['grand_rule']) {
                    foreach ($scoreRule['grand_rule'] as $v) {
                        $html .= '<li>累计签到' . $v['days'] . '天,可以获得' . $v['num'] . '个积分</li>';
                    }
                }
                $html .= '</ul>';
            }

            if ($scoreRule['reg_suc'] || $scoreRule['perfectinfo']) {
                $html .= '<div class="jf_j2">完善个人信息</div><ul class="jf_ul">';
                if ($scoreRule['reg_suc']) {
                    $html .= '<li>第一次绑定手机,可以获得' . $scoreRule['reg_suc'] . '个积分</li>';
                }
                if ($scoreRule['perfectinfo']) {
                    $html .= '<li>第一次修改资料,可以获得' . $scoreRule['perfectinfo'] . '个积分</li>';
                }
                $html .= '</ul>';
            }

            if ($scoreRule['fristbuy'] && $scoreRule['fristbuy_score']) {
                $html .= '<div class="jf_j2">消费增积分</div><ul class="jf_ul">';
                $html .= '<li>每消费' . $scoreRule['fristbuy'] . '元,可以获得' . $scoreRule['fristbuy_score'] . '个积分</li>';
                $html .= '</ul>';
            }

            if ($scoreRule['recommend_rule']) {
                $html .= '<div class="jf_j2">推荐新人赚积分</div><ul class="jf_ul">';
                foreach ($scoreRule['recommend_rule'] as $v) {
                    $html .= '<li>每成功推荐' . $v['num'] . '人,可以获得' . $v['scores'] . '个积分</li>';
                }
                $html .= '</ul>';
            }
        }
        $this->assign([
            'setInfo' => ['title' => '积分规则'],
            'html' => $html,
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 获取报价
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function getMoney()
    {
        $data = ['brandclass_id' => $this->brandId];
        $shopData = sx_call('5a37a1503264d', $data, 'sx_mc');
        $shopData = $shopData['data'];
        $this->assign([
            'setInfo' => ['title' => '获取报价'],
            'shop' => $shopData,
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 会员diy
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function diy()
    {
        $userData = getUserInfo(['userid' => $this->userId]);
        $weddingDay = $userData['merryday'];
        $day = substr($weddingDay, 0, 4);
        $daya = substr($weddingDay, -2);
        $dayaa = substr($weddingDay, 4, 2);
        $thisa = $day . '-' . $dayaa . '-' . $daya;
        $time = date('Y-m-d', time());
        $thisDay = getBadDays($time, $thisa);
        $kf_url = controller('index', 'lib')->getKf('url');   //客服信息   
        $conf_ertong  = db_config('sx_ertong');         //儿童店
        if($conf_ertong == Session::get('brand_id')){
            $this->assign('is_ertong','is');
        }
        $this->assign([
            'setInfo' => ['title' => '婚礼助手'],
            'day' => $thisDay,
            'kf_url'=>$kf_url
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 任务大厅/带搜索
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function taskHall()
    {
        $taskType = input('request.type');
        $day = input('request.day');
        $taskNum = input('request.num');

        $c = [
            'limit' => 5,
            'page' => (int)input('request.page'),
            'brandid' => $this->brandId,
            'order' => (int)input('request.order'), // 判断当前是否热门 1是热门,没有就是普通
        ];

        if (!empty($taskType)) {
            $c['typeid'] = $taskType;
        }
        if ($day && $day != '全部') {
            $days = explode('-', $day);
            $dayStar = (int)$days[0];
            $dayEnd = (int)$days[1];
            $c['days'] = [['>=', $dayStar], ['<=', $dayEnd]];
        }
        if ($taskNum && $taskNum != '全部') {
            $taskNums = explode('-', $taskNum);
            $taskNumStart = (int)$taskNums[0];
            $taskNumEnd = (int)$taskNums[1];
            $c['reward_score'] = [['>=', $taskNumStart], ['<=', $taskNumEnd]];
        }
        // $taskData  = TTaskList::selectS($w);
        // $moodsData = TTaskList::selectMoods();

        // 查询任务列表
        //var_dump($c);

        $tasklist = controller('index', 'lib')->getTaskList($c);
        if (request()->isAjax()) {
            return json(['data' => $tasklist]);
        } else {
            $tasklist = controller('index', 'lib')->getTaskList($c);
            $c['order'] = 1;
            $hotlist = controller('index', 'lib')->getTaskList($c);
        }

        $tasktotal = controller('index', 'lib')->getTaskCount($c);
        $adv = controller('index', 'lib')->getAdv(15);
        $this->assign([
            'setInfo' => ['title' => '任务大厅'],
            'adv' => $adv,
            'taskData' => $tasklist,
            'moodsData' => $hotlist,
            'page' => ceil($tasktotal / $c['limit']),
        ]);

        return $this->fetch();
    }

    /**
     * 方法描述: 我的任务中心
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function myTask()
    {
        $status = input('get.status') == 1 ? 1 : 0;
        $memTask = db('t_task_user_list')
            ->alias('a')
            ->join('t_task_list b', 'a.taskid = b.id')
            ->where(['a.status' => $status, 'b.brandid' => $this->brandId, 'a.userid' => $this->userId])
            ->field('a.status,a.taskid,a.done_total,b.title,b.index_img,b.reward_score,b.share_score,b.task_url,b.days,b.typeid')
            ->select();
        //var_dump(db()->getLastSql());
        //var_dump($memTask);
        $adv = controller('index', 'lib')->getAdv(1);
        $cachekey = 'sign_' . $this->userId . '_' . date('Y-m-d', time());
        $isSign = cache($cachekey);
        $userinfo = getUserInfo(['userid' => $this->userId, 'phoneid' => $this->userId, 'fields' => 'total_sign']);
        $userPhoneId = Session::get('phoneid');
        if (!$userPhoneId) {
            $userId = Session::get('memid');
            $totalSign = \db('m_users')->where('id', $userId)->field('total_sign')->find();
        } else {
            $totalSign = \db('m_users_phone')->where('id', $userPhoneId)->field('total_sign')->find();
        }
        $this->assign([
            'setInfo' => ['title' => '我的任务中心'],
            'res' => $isSign,
            'adv' => $adv,
            'memData' => $userinfo,
            'memTasks' => $memTask,
            'totalSign' => $totalSign,
        ]);
        return $this->fetch();
    }

    /**
     * 方法描述: 做任务
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function doTask()
    {
        $thisTime = date('Y-m-d');
        $taskId = (int)input('get.id');
        $userId = Session::get('memid');
        if (!$taskId) {
            return $this->myTask();
        }
        //$where = makeWhere($this->userid,$this->userPhoneId);
        $where = ['create_time' => ['like', "%$thisTime%"], 'taskid' => $taskId, 'userid' => $this->userId];
        $check = db('t_task_detail')->where($where)->count('id'); //查询任务详情记录中有没有当天的记录
        $taskInfo = db('t_task_list')->where('id', '=', $taskId)->find(); //查询任务详情记录中有没有当天的记录
        if ($check) {
            $res = 1;
        } else {
            $res = 2;
        }
        $checkStatusRes = \db('t_task_user_list')->where('taskid', $taskId)->where('userid', $userId)->field('status')->find();
        if ($checkStatusRes['status'] == 1) {
            $stocksCheck = 1;  //该任务已完成
        } else {
            $stocksCheck = 2;  //该任务未完成
        }
        $this->assign('res', $res);
        $this->assign('taskImg', $taskInfo);
        $this->assign('stocksCheck', $stocksCheck);
        $this->assign('setInfo', ['title' => '执行-' . $taskInfo['title'] . '-任务']);
        $this->assign('taskid', $taskId);
        return $this->fetch();
    }

    /**
     * 方法描述: 任务详情介绍
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function taskDetail()
    {
        $taskId = (int)input('get.id');
        if ($taskId) {
            $taskData = db('t_task_list')
                ->where('id', '=', $taskId)
                ->find();
            $this->assign([
                'taskData' => $taskData,
                'setInfo' => ['title' => $taskData['title'] . '-详情'],
            ]);
            return $this->fetch();
        } else {
            return $this->taskHall();
        }

    }


    /**
     * 方法描述: 领取任务
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function receiveTask()
    {
        $id = (int)input('get.id');
        if (!$id) {
            return $this->taskHall();
        }
        $data = db('t_task_list')->where('id', '=', $id)->find();
        if (!$data) {
            return $this->taskHall();
        }
        $alreadyReceive = false;
        $memLately = db('t_task_user_list')
            ->alias('a')
            ->field('a.userid,b.openid')
            ->join('m_users b', 'a.userid = b.id')
            ->where('a.taskid', '=', $id)
            ->order('a.create_time desc')
            ->select();
        foreach ($memLately as $v) {
            if ($v['userid'] == $this->userId) {
                $alreadyReceive = true;
            }
        }


        $this->assign('memLately', $memLately);
        $this->assign('datas', $data);
        $this->assign('received', $alreadyReceive);
        $this->assign('setInfo', ['title' => '领取任务-' . $data['title']]);
        return $this->fetch();
    }

    /*
     * 新的活动列表
     */
    public function activityNew(){

        $activity = db('a_activity_list')->where(['status'=>1,'end_time'=>['>=',date('Y-m-d')]])->where('delete_time is null')->select();

        $brandList = controller('vip/Setting','lib')->get_brandlist();

        $activeList = [];

            foreach($brandList as $key => $val){
                foreach($activity as $k => $v){
                    if($v['brandid'] == $val['id']){
                        $activeList[$val['id']][] = $v;
                    }
                }
            }
        //print_r($activeList);die;
        $kf_url = controller('Udesk')->udeskIM($this->userId,'活动中心');
        $this->assign('kf_url',$kf_url);

        $this->assign(['brand_id'=>$this->brandId,'activeList'=>$activeList,'brandList'=>$brandList]);
        return $this->fetch();
    }

    /**
     * 方法描述: 活动列表
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function activityCenter()
    {
        //$levelid = getLevel(['userid' => $this->userId, 'phoneid' => $this->userPhoneId]);

        $levelid = db('m_users')->where('id',$this->userId)->value('level');
        $c = [
            'brandid' => $this->brandId,
            'isenjoy' => (int)input('get.enjoy'),
            'levelid' => (int)$levelid ? $levelid : 0,
        ];
        $data = controller('activity', 'lib')->getList($c);
//      $id =[];
//      $result = growthMemRecord($this->userId,7,'',$this->userPhoneId);
//      $result = growthMemRecord($this->userId,7,'',$this->userPhoneId);
//      var_dump($result);
//      var_dump(db()->getLastSql());
        $this->assign([
            'data' => $data,
            'setInfo' => [
                'title' => '最新活动',
            ],
        ]);
        return $this->fetch();
    }
    /**
     * 方法描述: 活动详情
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function activityDetail()
    {
        $id = (int)input('id');
        $_share_userid  = input('_share_userid');
        //如果有分享者，记录分享者打开日志
        if($_share_userid){
            $share_data = [
                'share_userid' => $_share_userid,
                'activityid'   => $id,
                'create_time'  => date('Y-m-d H:i:s',time()),
            ];
            db("a_activity_share_num")->insert($share_data);
        }
        $action = input('action');
        if ($id) {
            $data = controller('activity', 'lib')->getOne($id);
            $data['isSignUp'] = controller('activity', 'lib')->isSignUp($id, $this->userId, $this->userPhoneId);
            $c = [
                'limit' => 3,
                'page' => (int)input('request.page'),
                'id' => (int)input('request.id'),
            ];
            $msglist = controller('activity', 'lib')->getMsgList($c);

            // 获取留言
            if (request()->isAjax()) {
                return json(['status' => $msglist ? 1 : 0, 'data' => $msglist]);
            }
            $msgcount = controller('activity', 'lib')->getMsgCount(['id' => $id]);
            $totalpage = ceil($msgcount / $c['limit']);

            // 浏览的数据
            $d = [
                'activityid' => $id,
                'userid'     => $this->userId,
                'add_time'   => date('Y-m-d H:i:s', time()),
                'link_code'  => htmlspecialchars(input('get.codeid')),
                'iswid'      => $this->userPhoneId ? 0 : 1,
            ];
            // 添加浏览的数据
            controller('activity', 'lib')->addVisit($d);

            // 添加成长值
            $result = growthMemRecord($this->userId, 7, $id);
            if (!$result) {
                $gro = getGrowthRule(['userid' => $this->userId]);
                if ($gro && $gro['view_activity']) {
                    $gro['view_activity'] = $gro['view_activity'] ?: 0;
                    growthDetailed($this->userId, $gro['view_activity'], 7, $id, $this->userPhoneId);
                }
            }
            $where = [
                    'userid'     => $this->userId,
                    'activityid' => $id
            ];
            $shareqrdata = controller('activity','lib')->GetShareQrData($where);
/*

            //$qrcode = $this->qr_codes("aaaaaaaaaa");
            $qrcode = 'http://vip.sx.com:8080/index/index/qr_code?content=123';
            $ewm_x   = 0;
            $ewm_y   = 480;
            $ewm_scale = 1;
            $path=  "public/uploads";
            $w = "public/front/imgnew/fxd_bd_header.png";

            $image = \think\Image::open($w);

            // $w = \think\image::open($qrcode);

            // $qrPath=$image->resize_img($qrcode,$path.'/',$ewm_scale);//压缩


            $image->water($qrcode,[$ewm_x,$ewm_y]);
            unlink($qrPath);
           // $imgPath=$path.'/activity.'.$id.'.jpg';
            header("Content-type: image/jpeg");
            $image->save("php://output");
            //echo $imgPath;die;
            die;
*/


            //若通过此方式进入会员系统，清除先睹为快分享中的推荐人推荐店等信息（非常六加一）
            $users_recommend = db('m_users_recommend')->where('user_id',session('userid'))->find();
            if($users_recommend){
                $deleteRes = db('m_users_recommend')->where('user_id',session('userid'))->delete();
            }


            $this->assign([
                'id'=>$id,
                'shareqrdata'=>$shareqrdata,
                'action'=>$action,
                // 'action'=>'all',
                '_share_userid'=>$_share_userid,
                'data' => $data,
                'setInfo' => [
                    'title' => $data['title'],
                    'share_content'=>$data['share_content'],
                    'share_title' => $data['share_title'],
                    'share_img' => $data['share_img'] ?: $data['index_img'],
                ],
                'msglist' => $msglist,
                'totalpage' => $totalpage,
                'link_code' => $d['link_code'],
            ]);
            return $this->fetch();
        } else {
            return $this->error('非法访问');
        }

    }

    /**
     * 方法描述: 活动报名
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function activitySignUp(){
        if (request()->isAjax()) {
            $d = [];
            if(input('post._share_userid')){
                $d['parent_id'] = (int)input('post._share_userid');
            }
            if(input('post.site')){
                $shopArr = explode(',',input('post.site'));
                $d['shop_code'] = $shopArr[0];
                $d['shop_name'] = $shopArr[1];
            }
            $d['activityid']    = (int)input('post.id');
            $d['b_username']    = input('post.busername');
            $d['b_time']        = input('post.btime')?input('post.btime'):date("Y-m-d H:i:s",time());
            $d['activity_link'] = input('post.link_code');
            $d['b_content']     = htmlspecialchars(input('post.bcontent'));
            $d['userid']        = $this->userId;
            $d['b_type']        = 1;
            $d['brandid']       = $this->brandId;
            $d['create_time']   = date('Y-m-d H:i:s', time());
            $d['iswid']         = $this->userPhoneId ? 0 : 1;
            $d['ext_data']      = json_encode(input('ext/a'));
            $d['b_phone']       = input('post.bphone');
            if(input('post.baby_birthday')){
                $d['baby_birthday'] = input('post.baby_birthday');
            }

            $sessionCaptcha = Session::get('capt');   //正确的验证码
            if ($d['b_phone'] && input('code') && input('code') != $sessionCaptcha) {
                return json(['code'=>201,'msg'=>'手机验证码错误']);
            }

            if($d['b_phone']){
                $phoneArr = db("a_activity_sign_up")->where("b_phone",$d['b_phone'])->where("activityid",$d['activityid'])->find();
                if($phoneArr){
                    return json(['code'=>202,'msg'=>'该活动该手机号已报名！']);
                }
            }
            if(input('action') == 'jj'){    //识别聚焦的需要 验证验证码
                $code = input("code");
                if(!$code){
                    return json(['code'=>202,'msg'=>'请输入验证码']);
                }   
                $sessionCaptcha = Session::get('capt');   //正确的验证码
                if($code != $sessionCaptcha){
                   // return json(['code'=>202,'msg'=>'验证码错误']);
                }
            }
            $d = array_filter($d);
            $data = controller('activity', 'lib')->signUp($d);
            $result = growthMemRecord($this->userId, 6, $d['activityid']);
            if (!$result) {
                $gro = getGrowthRule(['userid' => $this->userId]);
                if ($gro && $gro['activity_sign']) {
                    growthDetailed($this->userId, $gro['activity_sign'], 6, $d['activityid'], $this->userPhoneId);
                }
            }
            return $data;
        } else {
            $id = (int)input('get.id');
            $_share_userid = input('_share_userid');
            if ($id) {
                $data = controller('activity', 'lib')->getOne($id);
                $data['isSignUp'] = controller('activity', 'lib')->isSignUp($id, $this->userid, $this->userPhoneId);
                $dataConfig = [
                    [
                        'name' => '姓名',
                        'title' => '请输入姓名',
                        'icon' => '/public/front/img/reg_in1.png',
                        'key' => 'name',
                    ],
                ];
                $dbConfig = db_config('acitivity_data_config');
                if ($dbConfig) {
                    $dataConfig = $dbConfig;
                }

                //意向店面
                $shopset = sx_call("5a005e0038270",array('is_marketing'=>2),'sx_mc');
                if($shopset['code'] == 200){
                    $shopArr = $shopset['data'];
                }
                $this->assign([
                    '_share_userid'  => $_share_userid,
                    'data' => $data,
                    'setInfo' => [
                        'title'         => $data['title'] . '-活动报名',
                        'share_title'   => $data['share_title'],
                        'share_img'     => $data['share_img'],
                        'share_content' => $data['share_content'],
                        'link_code'     => input('link_code'),
                    ],
                    'dataConfig' => $dataConfig,
                    'shoparr'    =>$shopArr,
                ]);
            }
            return $this->fetch();
        }

    }

    /**
     * 方法描述: 用户信息页面，修改设置头像
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function userInfo()
    {
        $openid = Session::get('openid');
        if (request()->isAjax()) {
            $data = [
                'id' => $this->userId,
                'sex' => (int)input('sex'),
                'username' => htmlspecialchars(input('username')),
                'brithday' => input('post.brithday'),
                'merryday' => input('post.merryday'),
                'update_time' => date('Y-m-d H:i:s', time()),
                'babysex'  => (int)input('babysex'),
            ];
            if (!$data['id']) {
                return json(['status' => 100, 'msg' => '没有获取到您的信息，请重试']);
            }
            $fileimg = request()->file("img");

            if ($fileimg) {
                $data['simg'] = saveImgGetPath($fileimg, 150, 150, 'headimg' . DS . $openid, 'headimg.png', false);
            }
            if ($data['brithday']) {
                $data['brithday'] = str_replace('-', '', $data['brithday']);
            }
            if ($data['merryday']) {
                $data['merryday'] = str_replace('-', '', $data['merryday']);
            }

            $oldData = db('m_users')->field('username,sex,brithday,merryday,babysex')->where('id', $this->userId)->find();
            $newData = array(
                'username' => $data['username'],
                'sex' => $data['sex'],
                'brithday' => $data['brithday'],
                'merryday' => $data['merryday'],
                'babysex'  => $data['babysex']
            );
            $changeData = array();
            foreach ($newData as $key => $value) {
                if ($value != $oldData[$key]) {
                    $changeData[$key] = $value;
                }
            }
            if (empty($fileimg) && empty($changeData)) {
                return json(['status' => 100, 'msg' => '您没有做任何修改']);
            } else {
                $res = controller('index', 'lib')->setUserInfo($data);
                if ($res) {
                    Session::set('username', $data['username']);
                }
                return json(['status' => $res ? 1 : 0]);
            }
        } else {
            //$memData = getUserInfo(['userid' => $this->userId, 'phoneid' => $this->userPhoneId]);
            $memData = db('m_users')->where('id',$this->userId)->find();
            $memData['phone'] = $memData['phone'] ? substr($memData['phone'], 0, 3) . '****' . substr($memData['phone'], 7) : '';
            $memData['brithday'] = $memData['brithday'] ? date('Y-m-d', strtotime($memData['brithday'])) : '';
            $memData['merryday'] = $memData['merryday'] ? date('Y-m-d', strtotime($memData['merryday'])) : '';

            $erp_vip_card = db('c_sysconfig')->where('ckey','erp_vip_card')->value('cvalue');//线上下单是否使用erp线下储值卡消费 1是，2不是

            $this->assign('memdata', $memData);
            $this->assign([
                'memdata' => $memData,
                'erp_vip_card' => $erp_vip_card,
                'nedYear' => date('Y'),
                'setInfo' => [
                    'title' => '我的资料',
                ],
            ]);
            return $this->fetch();
        }

    }

    /**
     * 方法描述     分享方法
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function share()
    {
        $d = [
            'userid' => $this->userId,
            'sourceid' => (int)input('post.typeid'),//'1表示活动，2表示任务，3表示助力活动
            'shareid' => (int)input('post.id'),
            'share_url' => input('post.url'),
            'ip' => get_client_ip(),
            'phoneid' => $this->userPhoneId,
        ];
        //print_r($d);
        $res = controller('index', 'lib')->addShare($d);
        return json($res !== false ? ['status' => 1, 'score' => $res] : ['status' => 0]);

    }

    /**
     * 方法描述     还没有开发的版块的默认页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function makeing()
    {
        return $this->fetch();
    }

    /**
     * 方法描述     绑定手机
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function bind()
    {
        //$phone = Session::get('mem_phone');
        //$userData = db('m_users_phone')->where('userid',$this->userId)->find();
        $userData = db('m_users')->where('id',$this->userId)->find();
        $phone = $userData['phone'];
        $phone = $phone ? substr($phone, 0, 3) . '****' . substr($phone, 7) : '';
        $this->assign([
            'setInfo' => ['title' => '绑定手机'],
            'phone' => $phone,
            'upaddress' => input('server.HTTP_REFERER'),
        ]);
        return view();
    }

    /**
     * 方法描述    權益詳情
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function equityDetails()
    {
        $equityId = (int)input('get.id');
        $levelInfo = getLevel(['userid' => $this->userId, 'phoneid' => $this->userPhoneId]);
        if ($levelInfo) {
            $eqData = db('membereq')->where('eq_card_type', '=', $levelInfo['id'])->where('id', '=', $equityId)->find();
        }
        $this->assign('eqData', $eqData);
        return view();
    }

    /**
     * 方法描述     積分詳情
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function numDetails()
    {
        //$where = makeWhere($this->userId,$this->userPhoneId,'m_executor');

        $res = \db('minute_log')->where(['m_executor' => $this->userId])->order('m_time desc')->select();
        //print_r($res);
        $setInfo = [
            'title' => '积分记录',
            'content' => '会员专享专区，任务，活动一览',
            'keywords' => '尊享'
        ];
        $this->assign('data', $res);
        $this->assign('setInfo', $setInfo);
        return view();
    }
    /**
     * 方法描述    摄影师
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    /*public function cameraman () {
         $address = input('get.c_address') ;
         $shop = input('get.c_shop');
         $type = input('get.c_type');
         $rack = input('get.c_rank');
         if (!empty($address)) {
             $w['c_address'] = $address;
         }
         if (!empty($shop)) {
             $w['c_shop'] = $shop;
         }
         if (!empty($type)) {
             $w['c_type'] = $type;
         }
         if (!empty($rack)) {
             $w['c_rank'] = $rack;
         }
         $brandid = Session::get('brandid');
         if (empty($w)) {
             $cameramanData = db('cameraman')->field('id,c_name,c_money,c_rank,c_img')->select();
         } else {
             $cameramanData = db('cameraman')->field('id,c_name,c_money,c_rank,c_img')->where($w)->select();
         }
//         $camData = db('cameraman')->field('id,c_name,c_money,c_rank,c_img')->order('c_money desc')->select();
         $this->assign('camData',$camer amanData);
//         $this->assign('camOrderData',$camData);
         return view();
     }*/
    /**
     * 方法描述    摄影师详情
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function cameramanDetail()
    {
        $id = input('get.id');
        $userid = Session::get('memid');
        $where = array('cam_id' => $id, 'userid' => $userid);
        $result = db('cam_attention')->where($where)->find();
        $camCount = db('cam_attention')->where('cam_id', '=', $id)->count('cam_id');
        $observer = db('cam_evaluate')
            ->alias('a')
            ->join('m_users b', 'a.userid=b.id')
            ->where('a.camid', '=', $id)
            ->select();
        if ($result) {
            $arr = 1;
        } else {
            $arr = 0;
        }
        $res = db('cameraman')
            ->alias('a')
            ->join('cam_type b', 'a.c_type = b.typeid')
            ->where('a.id', '=', $id)
            ->find();

        $camSuc = db('cam_reservation')->where('camid', '=', $id)->count('camid');
        $this->assign('camSuc', $camSuc);
        $this->assign('camData', $res);
        $this->assign('observer', $observer);
        $this->assign('camFlow', $camCount);
        $this->assign('res', $arr);
        return view();
    }

    /**
     * 方法描述    摄影师作品查看
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function camProduction()
    {
        return view();
    }

    /**
     * 方法描述    摄影师支付
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    public function camPay()
    {
        return view();
    }

    /**
     * 方法描述: 摄影师用户评论详情
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function observerDetails()
    {
        $detailId = input('get.id');  //当前哪条评论id
        $id = input('get.camid');  //
        $userid = Session::get('memid'); //当前登录用户id
        $where = array('camid' => $id, 'userid' => $userid, 'e_id' => $detailId);
        $result = db('cam_evaluate')
            ->alias('a')
            ->join('m_users b', 'a.userid = b.id')
            ->where($where)
            ->find();
        $this->assign('obDetailData', $result);
        return view();
    }

    /**
     * 方法描述: 婚宴坐席
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedSeating()
    {
        $userId = Session::get('memid');
        $man = input('get.mans');
        if (!empty($man)) {
            $w['desk_mans'] = array('like', "%$man%");
            $deskData = db('wedding_desk')->where('desk_user', '=', $userId)->where($w)->select();
        } else {
            $deskData = db('wedding_desk')->where('desk_user', '=', $userId)->select();
        }
        $this->assign('deskData', $deskData);
        return view();
    }

    /**
     * 方法描述: 婚宴流程
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedProcess()
    {
        $userId = Session::get('memid');
        $flowParentData = db("wedding_flowtype")->where('flow_user', $userId)->find();  //默认分类数组
        $flowItemData = db("wedding_flow")->where('this_user', $userId)->find();  //默认分类名称
        $flowParentData = db('wedding_flowtype')->where('flow_user', 0)->where('flow_status', 1)->select();
        $arrData = [];
        $flowParentsData = db('wedding_flow')->alias('a')->join('wedding_flowtype b', 'a.this_type = b.flow_id')->where('a.this_user', 0)->select();
        $flowData = db("wedding_flow")
            ->alias('a')
            ->join("wedding_flowtype b", 'a.this_type = b.flow_id')
            ->where('a.this_user', '=', $userId)
            ->where('b.flow_status', '=', 1)
            ->order('a.this_time asc')
            ->select();
        if (!$flowData) {
            //将生成的父名称放入新数组
            foreach ($flowParentData as $k => $v) {
                $arrs['flow_type'] = $v['flow_type'];
                $arrs['flow_user'] = $userId;
                $arrs['flow_status'] = 1;
                $result = db('wedding_flowtype')->insertGetId($arrs);
                if (!$result) {
                    return array('code' => 0, 'msg' => '入库未成功');
                }
                $arrData[$result][] = $v['flow_type'];
            }

            $flowUserData = [];
            $flowArrData = [];
            //组合新的数组入库
            foreach ($arrData as $k => $v) {
                foreach ($flowParentsData as $kk => $vv) {
                    if ($v[0] == $vv['flow_type']) {
                        $flowUserData['this_type'] = $k;
                        $flowUserData['this_man'] = $vv['this_man'];
                        $flowUserData['this_work'] = $vv['this_work'];
                        $flowUserData['this_time'] = $vv['this_time'];
                        $flowUserData['this_user'] = $userId;
                        $result = db('wedding_flow')->insertGetId($flowUserData);
                        $flowUserData['id'] = $result;
                        $flowArrData[] = $flowUserData;
                        $flowUserData = [];
                        if (!$result) {
                            return array('code' => 0, 'msg' => '入库未成功');
                        }
                    }
                }
            }
            $flowData = $flowArrData;
        }
        $flowParentDatas = db('wedding_flowtype')->where('flow_user', $userId)->where('flow_status', 1)->select();
        $this->assign('flowData', $flowData);  //查询出流程的数据
        $this->assign('flowParentData', $flowParentDatas); //查询出流程的分类
        return view();
    }

    /**
     * 方法描述: 结婚预算
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedBudget()
    {
        $userID = Session::get('memid');
        $money = db('wedding_money')->where('wed_user', $userID)->Sum('wed_money');
        $percent = self::calcPercent($money);
        $percent = substr($percent, 0, 5);
        $showPercent = $percent . '%';  //超出新人百分比
        $wedMoney = db('wedding_money')->where('wed_user', '=', $userID)->count('wed_money');
        $wedFront = db('wedding_money')->where('wed_user', '=', $userID)->where('wed_project', '=', '婚前消费')->Sum('wed_money');
        $wedEnt = db('wedding_money')->where('wed_user', '=', $userID)->where('wed_project', '=', '婚礼消费')->Sum('wed_money');
        $wedLat = db('wedding_money')->where('wed_user', '=', $userID)->where('wed_project', '=', '婚后消费')->Sum('wed_money');
        $wedData = db("wedding_money")
            ->where("wed_user", '=', $userID)
            ->where('wed_show', '=', 1)
            ->select();
        $arr = [];
        $status = [];
        foreach ($wedData as $k => $v) {
            $arr[] = $v['wed_name'];
            $status[] = $v['wed_status'];
        }
        $arr = implode('&', $arr);
        $status = implode('&', $status);
        if (!$wedData) {
            $res = 1;
            $wedData = db("wedding_money")
                ->where("wed_user", '=', 0)
                ->select();
            $wedMoney = db('wedding_money')->where('wed_user', '=', 0)->count('wed_money');
            $wedFront = db('wedding_money')->where('wed_user', '=', 0)->where('wed_project', '=', '婚前消费')->Sum('wed_money');
            $wedEnt = db('wedding_money')->where('wed_user', '=', 0)->where('wed_project', '=', '婚礼消费')->Sum('wed_money');
            $wedLat = db('wedding_money')->where('wed_user', '=', 0)->where('wed_project', '=', '婚后消费')->Sum('wed_money');
            $perSum = db('wedding_money')->where('wed_user', '=', 0)->where('wed_status', '=', 1)->Sum('wed_per');
            $perSum = substr($perSum, 0, 4);
        }
        $proData = db('wedding_money')->where('wed_user', 0)->field('wed_project,wed_name')->select();  //查询默认模版

        $newProData = [];
        $newProName = [];
        foreach ($proData as $k => $v) {
            $newProData[] = $v['wed_project'];  //取出名称放入新数组
            $newProName[$v['wed_project']][] = $v['wed_name'];  //组合数组
        }
        $newProData = array_unique($newProData);  //父级数组去重
        $newData = [];
        $i = 0;

        foreach ($newProData as $k => $v) {  //循环默认父级数组
            $newData[] = ['id' => $k + 1, 'pId' => 0, 'name' => $v];   //组合父级id放入新数组
            foreach ($newProName[$v] as $kk => $vv) {  //循环默认子级名称
                $i++;  //新数组id自增
                $newData[] = ['id' => ($k + 1) . $kk, 'pId' => $k + 1, 'name' => $vv];  //前台js遍历默认模版数组
            }
        }
        $name = array();
        $this->assign('name', $name);
        $this->assign('arrs', $arr);
        $this->assign('newData', $newData);
        $this->assign('status', $status);
        $this->assign('wedFront', $wedFront);
        $this->assign('wedEnt', $wedEnt);
        $this->assign('wedLat', $wedLat);
        $this->assign('wedSum', $money);
        $this->assign('percent', $showPercent);
        $this->assign('res', $res);
        $this->assign('wedData', $wedData);
        $this->assign('wedMoney', $wedMoney);
        return view();
    }

    /**
     * 方法描述: 结婚相册列表
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedPhotos()
    {
        $userId = Session::get('memid');
        $photoOne = db('wed_photos')->where('book_user', $userId)->find();   //当前登录人的数据
        $photoOnes = db('wed_photos')->where('book_user', $userId)->where('book_sta', 1)->find();  //当前登录人的模版删除后是否显示点击新建
        if (!$photoOnes) {
            $status = 2;
        }
        if ($photoOne) {
            $price = 1;
        } else {
            $price = 2;
        }
        $phoListData = db('wed_photos')->where("book_user", $userId)->where('book_sta', 1)->select();
        $this->assign('phoListData', $phoListData);
        $this->assign('price', $price);
        $this->assign('status', $status);
        return view();
    }

    /**
     * 方法描述: 结婚相册默认模版
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedDefaultTemplate()
    {
        return view();
    }

    /**
     * 方法描述: 结婚相册编辑标题页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedPhotoTitle()
    {
        $autoId = (int)input('get.autoId');  //自增Id
        $userId = Session::get('memid');
        $temId = (int)input('get.temId');
        $music = db("wed_photos")->where("id", $autoId)->find();
        if (!empty($temId) && !empty($autoId)) {
            $phoData = db('wed_photos')->where('id', $autoId)->where('book_user', $userId)->where('book_id', $temId)->find();
        }

        $link = url('front/index/wedphotopreview', '', '', true);
        $setInfo = [
            'title' => $music['book_title'],
            'img_path' => '/public/uploads/' . $music['book_img'],
            'content' => $music['book_coutent'],
            'share_link' => $link . '?autoId=' . $autoId . '&temId=' . $music['book_id'],
        ];
//        var_dump($phoData);exit;
        $id = input('get.id');
        $this->assign('id', $id);  //传递自增id
        $this->assign('setInfo', $setInfo);
        $this->assign('autoId', $autoId);  //传递自增id
        $this->assign('temid', $temId);  //传递模版id
        $this->assign('phoData', $phoData);  //传递相册数组
        $this->assign('music', db('wedding_music')->select());
        return view();
    }

    /**
     * 方法描述: 结婚相册编辑上传页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedPhotoSet()
    {
        $id = input('get.id');
        $temId = input('get.temId');
        $music = db("wed_photos")->where("id", $id)->find();
        $photos = db('wed_phos')->where('p_id', $id)->select();
        $link = url('front/index/wedphotopreview', '', '', true);
        $setInfo = [
            'title' => $music['book_title'],
            'content' => $music['book_coutent'],
            'img_path' => '/public/uploads/' . $music['book_img'],
            'share_link' => $link . '?autoId=' . $id . '&temId=' . $music['book_id'],
        ];
        $this->assign('id', $id);
        $this->assign('setInfo', $setInfo);
        $this->assign('temId', $temId);
        $this->assign('music', $music);
        $this->assign('photosData', $photos);
        return view();
    }

    /**
     * 方法描述: 结婚相册编辑结束并分享页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedPhotoEnd()
    {
        $id = (int)input('get.id');
        $res = db("wed_photos")->where('id', $id)->find();
        if (!$res) {
            return array('code' => 0, 'msg' => '相册信息获取不成功');
        }
        $link = url('front/index/wedphotopreview', '', '', true);
        $setInfo = [
            'title' => $res['book_title'],
            'content' => $res['book_coutent'],
            'img_path' => '/public/uploads/' . $res['book_img'],
            'share_link' => $link . '?autoId=' . $id . '&temId=' . $res['book_id'],
        ];
        $url = "{:url('Index/wedphotopreview')}?autoId=" . $id . "&temId=" . $res['book_id'];
        $this->assign('photoData', $res);
        $this->assign('setInfo', $setInfo);
        $this->assign('url', $url);
        return view();
    }

    /**
     * 方法描述: 结婚相册立即预览页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedPhotoPreview()
    {
        $userId = Session::get('memid');  //当前用户id
        $temId = (int)input('get.temId');  //模版id
        $autoId = (int)input('get.autoId');  //自增id
        $shareUserId = (int)input('get.userId'); //用户id
        $_share_userid = input('_share_userid');
        $link = url('front/index/wedphotopreview', '', '', true);
        if ($_share_userid) {
            $previewData = db('wed_photos')->where('book_user', $_share_userid)->where('book_id', $temId)->find();
            //$userName = db('m_users')->where('id', $userId)->field('username')->find();
            $setInfo = [
                //'title' => $userName['username'],
                'title'=>$previewData['book_title'],
                'content' => $previewData['book_coutent'],
                'img_path' => '/public/uploads/' . $previewData['book_img'],
                //'share_link' => $link . '?autoId=' . $autoId . '&temId=' . $temId,
            ];
        } else {
            $nameData = \db('wed_photos')->where('id', $autoId)->find();
            $setInfo = [
                'title' => $nameData['book_title'],
                'content' => $nameData['book_coutent'],
                'img_path' => '/public/uploads/' . $nameData['book_img'],
                //'share_link' => $link . '?autoId=' . $autoId . '&temId=' . $temId,
            ];
            $previewData = db('wed_photos')->where('book_user', $userId)->where('book_id', $temId)->find();
        }
        if (empty($autoId)) {
            return array('code' => 2, 'msg' => '相册自增id不存在');
        }
        $withSum = db("wed_photoman")->where('p_id', $autoId)->count('p_id');
        $withData = db("wed_photoman")
            ->alias('a')
            ->join('m_users b', 'a.p_user = b.id')
            ->where('p_id', $autoId)
            ->select();

        $previewPhotos = db('wed_phos')->where('p_id', '=', $autoId)->select();
        $this->assign('previewData', $previewData);
        $this->assign('setInfo', $setInfo);
        $this->assign('sum', $withSum);
        $this->assign('withData', $withData);
        $this->assign('previewPhotos', $previewPhotos);
        return view();
    }

    /**
     * 方法描述: 结婚相册祝福页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedBenediction()
    {
        $userId = Session::get('memid');
//        $temId = input('get.temid');
        $temId = 1;
        $wishData = db("wed_photos")
            ->alias('a')
            ->join('m_users b', "a.book_user = b.id")
            ->join('wed_photoman c', 'a.id = c.p_id')
            ->where('a.book_user', $userId)
            ->where('a.book_id', $temId)
            ->select();
        $this->assign('wishData', $wishData);
        return view();
    }

    /**
     * 方法描述: 结婚相册模版页
     * @return mixed
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedTemplate()
    {
        $temData = db("wed_ptem")->select();
        if (!$temData) {
            return array('code' => 0, 'msg' => '模版文件生成失败');
        }
        $this->assign('temData', $temData);
        return view();
    }

    /**
     * 方法描述: 模拟计算超越全国百分比
     * @param $money
     * @create by lizahnqi(forbidden change code if you need tell to me)
     * 禁止改动,如需改动联系我
     * 百元以内几十的跳动无效果
     */
    private static function calcPercent($money)
    {
        //防止负数
        if ($money < 0) {
            $money = 0;
        }
        $simpleMoney = $money / 10000;
        //达到多少
        //[2,5,35,65,85,90,97,98]
        $reachArray = [5, 15, 25, 35, 55, 75, 95, 100];
        //百分比当达到100万的时候需要达到98
        $percentArray = [2, 5, 35, 65, 85, 90, 97, 98];
        //    echo "<br/>".$simpleMoney."万";
        $grade = 0;
        foreach ($reachArray as &$value) {
            if ($value < $simpleMoney) {
                $grade++;
            }
        }
//        echo "<br/>等级:".$grade."<br/>";
        //下面的判断也可以根据等级判断
        if ($grade == 0) {//小于等于5万
            $weight = $percentArray[$grade] / $reachArray[$grade] / 100;//百万元的权重
            $temp = $money / 100 * $weight;
            return $temp;
        } elseif ($grade < sizeof($reachArray)) {//其他情况
            $residue = $simpleMoney - $reachArray[($grade - 1)];//超出上个等级的金额(万元)
            $percentDiff = $percentArray[$grade] - $percentArray[($grade - 1)];//比例差(万元的)
            $moneyDiff = $reachArray[$grade] - $reachArray[($grade - 1)];//等级的金额差(万元)
            $weight = $percentDiff / $moneyDiff / 100;//超出的权重,万元
            return $percentArray[($grade - 1)] + $residue * 100 * $weight;
        } else {//大于百万
            //基础的分数,这里是最好高分值
            $baseGrade = $percentArray[(sizeof($percentArray) - 1)];
            //超出的钱(万元)
            $moreMoney = $simpleMoney - $reachArray[(sizeof($reachArray) - 1)];
            //剩余百分比
            $residualFraction = 100 - $percentArray[(sizeof($percentArray))];
            //每万元所占剩余分数的权重
            $weight = $residualFraction / 1000000;

            $score = $moreMoney * $weight + $baseGrade;
            if ($score >= 100) {
                $score = 99.99;
            }
            return $score;
        }
    }

    /**
     * 方法描述: 生成随机串
     * @return str
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private static function rand_str($length, $chars)
    {
        // Length of character list
        $chars_length = (strlen($chars) - 1);

        // Start our string
        $string = $chars{rand(0, $chars_length)};

        // Generate random string
        for ($i = 1; $i < $length; $i = strlen($string)) {
            // Grab a random character from our list
            $r = $chars{rand(0, $chars_length)};

            // Make sure the same two characters don't appear next to each other
            if ($r != $string{$i - 1}) $string .= $r;
        }

        // Return the string
        return $string;
    }

    /**
     * 方法描述: 支付码生成
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function getPayQrCode()
    {
        $userId = Session::get('memid');
//        $userId = 217;
        $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $length = 64;
        $newChars = self::rand_str($length, $chars);
        $groupCode = base64_encode($newChars . '_' . $userId); //生成64位随机码
//        $string = base64_decode($groupCode);

//        var_dump($groupCode);
//        var_dump((int)$userId = substr(substr($string,strpos($string,'_')),1));
        $data = ['user_id' => $userId, 'code' => $groupCode, 'status' => 'init'];
//        var_dump(base64_decode($groupCode));
        Cache::set('user_pay_code_' . $userId, $data, 5000);
//        var_dump(Cache::get('user_pay_code_'.$userId));
        $qrcode = new \Endroid\QrCode\QrCode($groupCode);
        $str = $qrcode->writeDataUri();
        $arr = ['code' => 200, 'str' => $str];
        return json($arr);
    }

    /**
     * 方法描述: 支付码状态查看
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function thanPayQrCode()
    {
        $userId = Session::get('memid');
        $cacheCode = Cache::get('user_pay_code_' . $userId);  //从cache中获取支付码
//        var_dump($cacheCode);
        if (!$cacheCode) {
            return array('code' => 203, 'msg' => '该付款码已过期', 'error' => 1);
        }
        if ($cacheCode['status'] == 'success') {
            $arr = ['code' => 200, 'msg' => '扣款成功', 'money' => $cacheCode['deduct_money']];
            return json($arr);
        }
    }

    /**
     * 方法描述: 获取我的订单列表
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderList()
    {
        $phone = Session::get('mem_phone');
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $orderId = input('get.order_id');  //接取订单id
        //$phone   = '18810881529';
        //$phone   = "15487451415";
        //$orderId = 'SY18011800002';
        //$orderId = 'SYT18010300001';
        //$orderId = 'SY18011800002';
        $url = $addr . '/SX_VipApi/Vip_SelOrderInfo?Token=^******^&tel=' . $phone . '&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口

//        var_dump($response['Data']);exit;
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        $orderData = $response['Data'];
        foreach ($orderData as $k => $v) {
//           $orderData[$k]['weddingdate'] = date('Y-m-d',strtotime($v['paymentdate']));
        }
//      var_dump($orderData);exit;
        $setInfo = [
            'title' => '我的订单',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderData', $orderData);
        return view();
    }

    /**
     * 方法描述: 获取我的订单详情
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderDetail()
    {
        $phone = Session::get('mem_phone');
        $orderId = input('get.id');
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url

        // $phone = '13156987456';
        // $orderId = 'SY18011800001';
        $url = $addr . '/SX_VipApi/Vip_SelOrderInfo?Token=^******^&tel=' . $phone . '&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
//        var_dump($response['Data']);exit;
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        //单条数据待处理
        $orderOneData = $response['Data'][0];
//        var_dump($orderOneData);exit;
        $orderOneData['paymentdate'] = date('y-m-d', strtotime($response['Data'][0]));
        $setInfo = [
            'title' => '订单详情',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderOneData', $orderOneData);
        return view();
    }

    /**
     * 方法描述: 调取erp错误处理流程
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private static function errorLog($url, $data)
    {
        $errorLogData = [
            'url' => $url,
            'data' => $data,
            'create_time' => date('Y-m-d'),
            'error_count' => 1,
        ];
        $logRes = db("c_vip_save")->insert($errorLogData);   //写入错误记录日志表
        if (!$logRes) {
            return array('code' => 201, 'msg' => '数据写入失败');
        }
        return 1;
    }

    /**
     * 方法描述: 获取我的订单产品信息
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderProject()
    {
        $orderId = input('get.order_id');  //接取订单id
        $phone = Session::get('mem_phone');
        //        $phone = '18810881529';

//        $orderId = 'SYT18010300001';
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $url = $addr . '/SX_VipApi/Vip_SelOrderPackageInfo?Token=^******^&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        $orderProjectData = $response['Data'];
//        var_dump($orderProjectData);exit;
        $setInfo = [
            'title' => '产品信息',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderProjectData', $orderProjectData);
        return view();
    }

    /**
     * 方法描述: 获取我的订单礼服信息
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderFull()
    {
        $orderId = input('get.order_id');
        $phone = Session::get('mem_phone');
//        $phone = '18810881529';

//        $orderId = 'SYT18010800001';
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $url = $addr . '/SX_VipApi/Vip_SelOrderDressInfo?Token=^******^&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
        $orderFullData = $response['Data'];
        foreach ($orderFullData as $k => $v) {
            $orderFullData[$k]['choosedate'] = date('Y-m-d', strtotime($v['choosedate']));
            $orderFullData[$k]['getdate'] = date('Y-m-d', strtotime($v['getdate']));
            $orderFullData[$k]['gettime'] = date('Y-m-d', strtotime($v['gettime']));
            $orderFullData[$k]['returndate'] = date('Y-m-d', strtotime($v['returndate']));
            $orderFullData[$k]['returtime'] = date('Y-m-d', strtotime($v['returtime']));
        }
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        $setInfo = [
            'title' => '礼服信息',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderFullData', $orderFullData);
        return view();
    }

    /**
     * 方法描述: 获取我的订单拍照信息
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderPhoto()
    {
        $orderId = input('get.order_id');
        $phone = Session::get('mem_phone');
        //$phone = '18810881529';
        //$orderId = 'SY18011800002';
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $url = $addr . '/SX_VipApi/Vip_SelOrderPhotoInfo?Token=^******^&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
        $orderPhotoData = $response['Data'];
//        var_dump($orderPhotoData);exit;
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        $setInfo = [
            'title' => '拍照信息',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderPhotoData', $orderPhotoData);
        return view();
    }

    /**
     * 方法描述: 获取我的订单选片信息
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderSlice()
    {
        $orderId = input('get.order_id');
        $phone = Session::get('mem_phone');
        //        $phone = '18810881529';

        //$orderId = 'SY18011900003';
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $url = $addr . '/SX_VipApi/Vip_SelOrderSPInfo?Token=^******^&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
        $orderSliceData = $response['Data'];
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        $setInfo = [
            'title' => '选片信息',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderSliceData', $orderSliceData);
        return view();
    }

    /**
     * 方法描述: 获取我的订单付款信息
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrderPayment()
    {
        $orderId = input('get.order_id');
        $phone = Session::get('mem_phone');
        //        $phone = '18810881529';

//        $orderId = 'SYT18010300001';
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url
        $url = $addr . '/SX_VipApi/Vip_SelOrderPaymentInfo?Token=^******^&orderid=' . $orderId; //定义拼接url
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
        if ($response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($url, $dataN);
        }
        $orderPayData = $response['Data'];
        foreach ($orderPayData as $k => $v) {
            $orderPayData[$k]['paymentdate'] = date('Y-m-d', strtotime($v['paymentdate']));
        }
//        var_dump($orderPayData);exit;
        $setInfo = [
            'title' => '付款信息',
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('orderPayData', $orderPayData);
        return view();
    }

    /**
     * 方法描述：获取签名信息
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月20日    19:36:38
     */
    public function myordersign()
    {
        $order_id = input("order_id");
        //$order_id = "SY18011800001";
        $data['code'] = $order_id;
        $data['type'] = 1;
        $orderSignInfo = sx_call("5ab9a901ee228", $data);
        if ($orderSignInfo['code'] == 200) {
            $url = $orderSignInfo['data']['url'];
        }
        $this->assign(['url' => $url, 'title' => '签名信息']);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_列表页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvitationList()
    {
        $userId = Session::get('memid');
        $brandId = Session::get('brand_id');

        // $userId = 452;
        // $brandId = 1;
        $where = ['brand_id' => $brandId, 'user_phone_id' => $userId];
        $userPhotosData = \db('wedding_lovecard')->where($where)->field('id,invitation_title,invitation_img,template_name')->select();

        if ($userPhotosData) {
            $makeNum = 1;
        } else {
            $makeNum = 2;
        }
        $this->assign('makeNum', $makeNum);
        $this->assign('userPhotosData', $userPhotosData);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_模版页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvTemplateList()
    {
        // 判断当前事业部是婚纱还是儿童
        $brandId = $this->brandId;
        $child = db('c_sysconfig')->where('cvalue',$brandId)->where('ckey','sx_ertong')->count();
        if ($child) {
            $this->assign('b_type', 'child');
        }else{

            $this->assign('b_type', 'hunsha');
        }

        $template = db('wedding_lovecard')->where('brand_id', 0)->where('cate',2)->select();

        //        <div class="ph_bottom">
        //    <a href="{:url('Index/wedInvShareEnd')}?auto_id={$auto_id}" class="ph_b_btn ph_prew_a">上一步</a>
        //    <!--<a href="#" class="ph_b_btn ph_prew_b">上一步</a>-->
        //    <a href="{:url('Index/wedInvShareEnd')}?auto_id={$auto_id}" class="ph_b_btn ph_next_a">下一步</a>
        //    <!--<a href="#" class="ph_b_btn ph_next_b">下一步</a> -->
        //    <a href="#" class="ph_b_yl">立即预览</a>
        // </div>
        $this->assign('template', $template);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_标题添加页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvTitleAdd()
    {
        $autoId = input('get.auto_id');

        $userOneData = db('wedding_lovecard')->where('id', $autoId)->find();
        // if ($userOneData['template_name'] == 'template1') {
        //     $link = url('front/index/wedinvpreview','','',true);
        // } else {
        //     $link = url('front/index/wedinvtwopreview','','',true);
        // }
        $link = url('front/index/wedinvpreview', '', '', true);
        // var_dump($link);exit;
        $setInfo = [
            'title' => $userOneData['invitation_title'],
            'img_path' => '/' . $userOneData['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $userOneData['invitation_describe'],
        ];
        $this->assign('music', db('wedding_music')->select());
        $this->assign('setInfo', $setInfo);
        $this->assign('userOneData', $userOneData);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_标题添加页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myMap()
    {
        $autoId = input('get.auto_id');
        $this->assign('autoId', $autoId);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_wedding信息添加页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvMessageAdd()
    {
        $autoId = input('get.auto_id');
        $personageData = db('wedding_lovecard')->where('id', $autoId)->field('id,invitation_describe,invitation_title,template_name,invitation_img')->find();
        $userOneData = db('wedding_lovedata')->where('wedding_lovecard_id', $autoId)->find();
        $userWedData = json_decode($userOneData['wedding_data'], true);
        // if ($personageData['template_name'] == 'template1') {
        //     $link = url('front/index/wedinvpreview','','',true);
        // } else {
        //     $link = url('front/index/wedinvtwopreview','','',true);
        // }
        $link = url('front/index/wedinvpreview', '', '', true);
        $setInfo = [
            'title' => $personageData['invitation_title'],
            'img_path' => '/' . $personageData['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $personageData['invitation_describe'],
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('autoId', $personageData['id']);
        $this->assign('template_name', $personageData['template_name']);
        $this->assign('userWedData', $userWedData);

        // 判断当前事业部是婚纱还是儿童
        $brandId = $this->brandId;
        $child = db('c_sysconfig')->where('cvalue',$brandId)->where('ckey','sx_ertong')->count();
        if ($child) {
            $this->assign('b_type', 'child');
        }else{
            $this->assign('b_type', 'hunsha');
        }
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子模版第1套页面_照片集页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvPhotosAdd()
    {
        $autoId = input('get.auto_id');
        $personageData = \db('wedding_lovecard')->where('id', $autoId)->field('id,invitation_describe,invitation_title,template_name,invitation_img')->find();
        $userPhotosData = db('wedding_lovephotos')->where('wedding_lovecard_id', $autoId)->select();  //默认照片信息
        if (!$userPhotosData) {
            return array('code' => 201, 'msg' => '该用户数据没有查询到');
        }
        $photosData = [];
        foreach ($userPhotosData as $k => $v) {
            $photosData[$v['this_several'] . '_' . $v['this_seat']] = $v['card_img'];
        }
        $textData = \db('wedding_lovedata')->where('wedding_lovecard_id', $autoId)->find();  //默认文本信息
        $defaultData = json_decode($textData['wedding_data'], true);
        $wishData = \db('wedding_lovejoin')
            ->alias('a')
            ->join('m_users b', 'a.join_user_phone_id = b.id')
            ->where('wedding_lovecard_id', $autoId)
            ->select();
        // var_dump($wishData);exit;
        $wishCount = \db('wedding_lovejoin')->where('wedding_lovecard_id', $autoId)->where('join_wish_status', 1)->count('id');
        if ($personageData['template_name'] == 'template1') {
            $link = url('front/index/wedinvpreview', '', '', true);
        } else {
            $link = url('front/index/wedinvtwopreview', '', '', true);
        }
        $setInfo = [
            'title' => $personageData['invitation_title'],
            'img_path' => '/' . $personageData['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $personageData['invitation_describe'],
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('auto_id', $autoId);
        $this->assign('wishData', $wishData);
        $this->assign('wishCount', $wishCount);
        $this->assign('defaultData', $defaultData);
        $this->assign('userPhotosData', $photosData);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子模版第2套页面_照片集页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvPhotosTwoAdd()
    {
        $autoId = input('get.auto_id');
        $templateName = \db('wedding_lovecard')->where('id', $autoId)->field('id,invitation_describe,invitation_title,template_name,invitation_img')->find();

        if ($templateName['template_name'] == 'template1') {
            $link = url('front/index/wedinvpreview', '', '', true);
        } else {
            $link = url('front/index/wedinvtwopreview', '', '', true);
        }
        $userPhotosData = db('wedding_lovephotos')->where('wedding_lovecard_id', $autoId)->select();  //默认照片信息
        $photosData = [];
        foreach ($userPhotosData as $k => $v) {
            $photosData[$v['this_several'] . '_' . $v['this_seat']] = $v['card_img'];
        }
        // print_r($autoId);
        // print_r($photosData);die;

        if (!$userPhotosData) {
            return array('code' => 201, 'msg' => '该用户数据没有查询到');
        }
        $textData = \db('wedding_lovedata')->where('wedding_lovecard_id', $autoId)->find();  //默认文本信息
        $defaultData = json_decode($textData['wedding_data'], true);
        $wishData = \db('wedding_lovejoin')
            ->alias('a')
            ->join('m_users b', 'a.join_user_phone_id = b.id')
            ->where('wedding_lovecard_id', $autoId)
            ->select();
        // var_dump($wishData);exit;
        $wishCount = \db('wedding_lovejoin')->where('wedding_lovecard_id', $autoId)->where('join_wish_status', 1)->count('id');

        $setInfo = [
            'title' => $templateName['invitation_title'],
            'img_path' => '/' . $templateName['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $templateName['invitation_describe'],
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('auto_id', $autoId);
        $this->assign('wishData', $wishData);
        $this->assign('wishCount', $wishCount);
        $this->assign('defaultData', $defaultData);
        $this->assign('templateName', $templateName);
        $this->assign('userPhotosData', $photosData);

        return view();
    }


    /**
     * 婚礼助手-请柬模板编辑 第三步编辑展示图片
     */
    public function wedInvPhoto()
    {

        $autoId = input('get.auto_id');
        $template_name = input('get.template_name');

        $templateName = db('wedding_lovecard')->where('id', $autoId)->field('id,invitation_describe,invitation_title,template_name,invitation_img,invitation_site')->find();

        $userPhotosData = db('wedding_lovephotos')->where('wedding_lovecard_id', $autoId)->select();  //默认照片信息

        if ($userPhotosData) {
            $photosData = [];
            foreach ($userPhotosData as $k => $v) {
                $photosData[$v['this_several'] . '_' . $v['this_seat']] = $v['card_img'];
            }
        } else {
            return array('code' => 201, 'msg' => '该用户数据没有查询到');
        }

        $textData = \db('wedding_lovedata')->where('wedding_lovecard_id', $autoId)->find();  //默认文本信息
        $defaultData = json_decode($textData['wedding_data'], true);
        $wishData = \db('wedding_lovejoin')
            ->alias('a')
            ->join('m_users b', 'a.join_user_phone_id = b.id')
            ->where('wedding_lovecard_id', $autoId)
            ->select();
        $wishCount = \db('wedding_lovejoin')->where('wedding_lovecard_id', $autoId)->where('join_wish_status', 1)->count('id');

        $link = url('front/index/wedinvpreview', '', '', true);
        $setInfo = [
            'title' => $templateName['invitation_title'],
            'img_path' => '/' . $templateName['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $templateName['invitation_describe'],
        ];
        $photo = config('ext.app_config');  //读取云底片配置文件
        $addr = $photo['sx_photo']['addr'];  //调用url
        if ($addr) {
            $this->assign('photo_config', $addr);
        }
        $userData = db('m_users')->where('id', $this->userId)->find();
        $user_name = $userData['yun_user_name'];
        $password = $userData['yun_password'];

        // $user_name='A00000002';
        // $password='ptSrc9';
        $this->assign(['user_name' => $user_name, 'password' => $password]);
        $this->assign('setInfo', $setInfo);
        $this->assign('auto_id', $autoId);
        $this->assign('wishData', $wishData);
        $this->assign('wishCount', $wishCount);
        $this->assign('defaultData', $defaultData);
        $this->assign('templateName', $templateName);
        $this->assign('userPhotosData', $photosData);
        // var_dump($photosData);
        // exit;
        return view($template_name);
    }

    /*
    * 验证登录云底片
    */
    public function loginPhoto()
    {
        $user_name = input('post.user_name');
        $password = md5(input('post.password'));
        //print_r(input('post.'));die;
        $photo = config('ext.app_config');  //读取云底片配置文件
        $addr = $photo['sx_photo']['addr'];  //调用url
        $dataUrl = $addr . '/index/index/getFileListAjax?user_name=' . $user_name . '&password=' . $password;
        $result = http_request($dataUrl, 'GET');
        if ($result['code'] == 200) {
            $photoData = json_decode($result['response'], true);
            //print_r($photoData);die;
            if ($photoData['code'] == 200) {
                $userData = db('m_users')->where('id', $this->userId)->find();
                if ($userData['yun_user_name'] != $user_name || $userData['yun_password'] != $password) {
                    db('m_users')->where('id', $this->userId)->update(['yun_user_name' => $user_name, 'yun_password' => input('post.password')]);
                }
                return array('code' => 1, 'data' => $photoData['data']);
            } else {
                return array('code' => 0, 'msg' => $photoData['msg']);
            }
        } else {
            return array('code' => 0, 'msg' => '云底片配置信息错误');
        }

    }

    /*
     * 检验是否登录过底片云
     */
    public function check_login()
    {
        $userData = db('m_users')->where('id', $this->userId)->find();
        if (!$userData['yun_user_name'] || !$userData['yun_password']) {
            return array('code' => 0, 'msg' => '需要登录');
        }
        $photo = config('ext.app_config');  //读取云底片配置文件
        $addr = $photo['sx_photo']['addr'];  //调用url
        $dataUrl = $addr . '/index/index/getFileListAjax?user_name=' . $userData['yun_user_name'] . '&password=' . md5($userData['yun_password']);
        $result = http_request($dataUrl, 'GET');
        if ($result['code'] == 200) {
            $photoData = json_decode($result['response'], true);
            if ($photoData['code'] == 200) {
                return array('code' => 1, 'data' => $photoData['data']);
            } else {
                return array('code' => 0, 'msg' => $photoData['msg']);
            }
        } else {
            return array('code' => 0, 'msg' => '云底片配置信息错误');
        }

    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_分享页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvShareEnd()
    {
        $autoId = input('get.auto_id');
        $templateName = \db('wedding_lovecard')->where('id', $autoId)->field('invitation_describe,invitation_title,template_name,invitation_img')->find();
        $link = url('front/index/wedinvpreview', '', '', true);
        // if ($templateName['template_name'] == 'template1') {
        //     $link = url('front/index/wedinvpreview','','',true);
        // } else {
        //     $link = url('front/index/wedinvtwopreview','','',true);
        // }
        $setInfo = [
            'title' => $templateName['invitation_title'],
            'img_path' => '/' . $templateName['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $templateName['invitation_describe'],
        ];
        // var_dump($setInfo);exit;
        $this->assign('setInfo', $setInfo);
        $this->assign('auto_id', $autoId);
        $this->assign('template_name', $templateName);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子模版第1套页面_立即预览页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvPreview()
    {
        $autoId = input('auto_id');
        $userId = Session::get('memid');
        $openId = \db('m_users')->where('id', $userId)->field('openid')->find();
        $cardData = \db('wedding_lovecard')->where('id', $autoId)->find();
        //print_r($cardData['invitation_img']);die;
        //print_r($cardData);
        $textData = \db('wedding_lovedata')->where('wedding_lovecard_id', $autoId)->find();
        $textData = json_decode($textData['wedding_data'], true);
        //print_r($textData);die;
        $wishData = \db('wedding_lovejoin')
            ->alias('a')
            ->join('m_users b', 'a.join_user_phone_id = b.id')
            ->where('wedding_lovecard_id', $autoId)
            ->select();
        $photosData = \db('wedding_lovephotos')->where('wedding_lovecard_id', $autoId)->select();
        $userPhotosData = [];
        foreach ($photosData as $k => $v) {
            $userPhotosData[$v['this_several'] . '_' . $v['this_seat']] = $v['card_img'];
        }

        // if ($cardData['template_name'] == 'template1') {
        //     $link = url('front/index/wedinvpreview','','',true);
        // } else {
        //     $link = url('front/index/wedinvtwopreview','','',true);
        // }

        //分享url，BaseFront.php 已写
        //$link = url('front/index/wedinvpreview',  ['auto_id'=>$autoId],'', true);
        //$linkMc = config('ext.app_config')['sx_mc']['addr'].'/index/index/jump?url='.urlencode($link);
        //$link = url('front/index/wedinvpreview',  ['auto_id'=>$autoId],'', true);
        
        $setInfo = [
            'title' => $cardData['invitation_title'],
            'img_path' => '/' . $cardData['invitation_img'],
            //'share_link' => $link,
            'content' => $cardData['invitation_describe'],
        ];

        $withSum = \db('wedding_lovejoin')->where('wedding_lovecard_id', $autoId)->where('join_wish_status', 1)->count('id');
        $this->assign('setInfo', $setInfo);
        $this->assign('withSum', $withSum);
        $this->assign('auto_id', $autoId);
        $this->assign('cardData', $cardData);
        // print_r($cardData);die;
        $this->assign('openId', $openId);
        //$this->assign('textData',$textData);
        $this->assign('defaultData', $textData);
        $this->assign('wishData', $wishData);
        $this->assign('photosData', $userPhotosData);
        // var_dump($userPhotosData);exit;
        //$this->assign('signPackage',weShare($appId,$this->brandId,$link));
        return view('preview' . $cardData['template_name']);
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子模版第2套页面_立即预览页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvTwoPreview()
    {
        $autoId = input('get.auto_id');
        $userId = Session::get('memid');
        $cardData = \db('wedding_lovecard')->where('id', $autoId)->find();
        if ($cardData['template_name'] == 'template1') {
            $link = url('front/index/wedinvpreview', '', '', true);
        } else {
            $link = url('front/index/wedinvtwopreview', '', '', true);
        }
        $textData = \db('wedding_lovedata')->where('wedding_lovecard_id', $autoId)->find();
        $textData = json_decode($textData['wedding_data'], true);
        $wishData = \db('wedding_lovejoin')
            ->alias('a')
            ->join('m_users b', 'a.join_user_phone_id = b.id')
            ->where('wedding_lovecard_id', $autoId)
            ->select();
        $photosData = \db('wedding_lovephotos')->where('wedding_lovecard_id', $autoId)->select();
        // var_dump($textData);exit;
        $userPhotosData = [];
        foreach ($photosData as $k => $v) {
            $userPhotosData[$v['this_several'] . '_' . $v['this_seat']] = $v['card_img'];
        }
        $withSum = \db('wedding_lovejoin')->where('wedding_lovecard_id', $autoId)->where('join_wish_status', 1)->count('id');
        $setInfo = [
            'title' => $cardData['invitation_title'],
            'img_path' => '/' . $cardData['invitation_img'],
            'share_link' => $link . '?auto_id=' . $autoId,
            'content' => $cardData['invitation_describe'],
        ];
        $this->assign('setInfo', $setInfo);
        $this->assign('withSum', $withSum);
        $this->assign('auto_id', $autoId);
        $this->assign('cardData', $cardData);
        $this->assign('defaultData', $textData);
        $this->assign('wishData', $wishData);
        $this->assign('photosData', $userPhotosData);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子第一套默认页面_立即预览页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedDefaultPreview()
    {

    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_祝福数据页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvWish()
    {
        $autoId = input('get.auto_id');
        $wishData = \db('wedding_lovejoin')
            ->alias('a')
            ->join('m_users b', 'a.join_user_phone_id = b.id')
            ->where('a.wedding_lovecard_id', $autoId)
            ->select();
        $this->assign('wishData', $wishData);
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_弹幕礼金页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedInvBallMoney()
    {
        return view();
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_模版1
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function invitationView()
    {
        return view('public/cardtemplate/template1/invitation_view.html');
    }

    /**
     * 方法描述: 婚礼助手-结婚帖子页面_模版2
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function invitationViewTwo()
    {
        return view('public/cardtemplate/template2/invitation_viewtwo.html');
    }


    /*
     * 婚礼助手--请柬模板
     */
    public function invitationTemplate()
    {
        $name = input('name');
        return view('public/cardtemplate/template/' . $name . '.html');
    }


    /**
     * 方法描述: 婚礼助手-结婚帖子页面_模版编辑照片页2
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function invitationViewPhotoTwo()
    {
        return view();
    }

    /**
     * 方法描述: 换新首页0
     * @return payCode
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function index(){
        $controller = config('controller');
        if ($controller) {
            $this->Redirect($controller.'/index');
        }
        $brandId = Session::get('brand_id');

        //会员等级
        $userinfo = getUserInfo(['userid' => $this->userId]);

        //爆品商品
        $hotShopData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id,exchange_integral from tp_goods where is_burft=1 and is_on_sale = 1 and ( brand_data_id =0 or FIND_IN_SET(' . $brandId . ',brand_data_id)) limit 4');  //跨库查询

        //导航图标
        $indexArr = db('s_index')->where('brandid', $brandId)->select();

        //秒杀商品
        $miaoShopData = Db::connect('db_shop')
            ->query('select original_img,goods_name,shop_price,miao_price,goods_id,start_time,end_time,market_price from tp_goods where is_on_sale = 1 and seckill = 1 and (brand_data_id =0 or FIND_IN_SET(' . $brandId . ',brand_data_id)) order by sort desc limit 8');
        $time = time();

        //各分类下客片
        $photo_type_tip = db('c_sysconfig')->where('ckey','photo_type_tip')->value('cvalue');//客片分类下是否展示标签图

        $typePhoto = controller('Guestphoto')->getAllTypePhoto($photo_type_tip);

        //首页展示的客片(6+1用的)
        /*
        $guestPhoto = db('guest_photo')->where(['brand_id'=>$this->brandId,'status'=>4])->find();

        $this->assign([
            'title_img' => $guestPhoto['cover_img'],
            'content_img'=> json_decode($guestPhoto['content_img'],true),
        ]);
        */


        // 获取优惠券的总数 ，并放入cache
        $cachekey = 'couponTotal_status_0_userid_' . $this->userId;
        $couponTotal = cache($cachekey);
        cache::clear($cachekey);
        //echo $userCouponTotal;
        if (!$couponTotal) {
            $couponTotal = controller('index', 'lib')->getUserCouponCount($this->userId, 0, $this->userPhoneId);
            if ($couponTotal) {
                cache($cachekey, $couponTotal);
            }
        }
        $userinfo['userCouponTotal'] = $couponTotal;

        // 获取用户级别信息
        $levelInfo = getLevel(['userid' => $this->userId]);

        $userinfo['levelName'] = $levelInfo ? $levelInfo['name'] : '';
        // 设置头部信息和分享信息
        $setInfo = [
            'title' => '尊享专区',
            'content' => '会员专享专区，任务，活动一览',
            'keywords' => '尊享'
        ];
        $shopUrl = Session::get('shop_url');
        $appConfig = config('ext.app_config');
        $addr      = $appConfig[strtolower("sx_vipshop")]['addr'];    //从接口获取路径
        $adv       = controller('index', 'lib')->getAdv(1);   //首页广告位待处理


        //多个广告位素材
        $allAdvs = Db('advertising')
            ->where(['brandid'=>session('brand_id'),'adv_status'=>1])
            ->where('adv_seat','in',[17,18,19,21,22,23,24,25,26,27,28,29,30,31,32])
            ->select();
        $advInfo = [];
        foreach($allAdvs as $k => $v){
            $advInfo[$v['adv_seat']] = json_decode($v['adv_detail'],true);
        }
        $this->assign('advInfo',$advInfo);
        
        $conf_brandid = db_config('sx_brand');
        $conf_ertong  = db_config('sx_ertong');


        //口碑
        $praise_page = 1;
        $praise_limit = 2;
        $praisedata = controller("Praise","lib")->GetPraiseData($praise_page,$praise_limit);

        $kf_url = controller('index', 'lib')->getKf('url');   //客服信息
        $user_level = controller('index','lib')->GetUserLevel(); //设置的会员等级
        //$kfUrl = controller('Udesk')->udeskIM($this->userId,'会员首页');
        $this->assign([
            'praisedata'=>$praisedata,
            //'is_ertong'=>$is_ertong,
            'adv' => $adv,
            'user_level'=>$user_level,
            'advTwo' => $advTwo,
            'setInfo' => $setInfo,
            'memData' => $userinfo,
            //'gradeValue' => $gradeValue,
            //'gradeName' => $gradeName,
            //'newOneArr' => $newOneArr,    //爆品分页1
            //'newTwoArr' => $newTwoArr,    //爆品分页2
            //'badResult' => $badResult,
            'activeData' => $activeData,
            'hotShopData' => $hotShopData,
            //'oneActive' => $newBestOneActive,
            'shopUrl' => $shopUrl ? $shopUrl : $addr,
            'brandId' => $brandId,
            'adv_xc' => $adv_xc,
            'adv_jjr' => $adv_jjr,
            'adv_hd' => $adv_hd,
            'adv_yhq' => $adv_yhq,
            'kf_url' => $kf_url,
            'miaoshop' => $miaoShopData,
            'time' => $time,
            'indexarr' => $indexArr,
            //'marriedarr' => $marriedArr,
            'grouparr' => $groupArr,
            //'Platina_data'=>$Platina_data,
            //'Brand_data' =>$Brand_data,
            //'photos_data'=>$photos_data,
            //'video_data' =>$video_data,
            //'weiyingIs_show'=>$weiyingIs_show,
            'typePhoto' => $typePhoto,//客片大赏
            'photo_type_tip'=>$photo_type_tip,
            'setInfo' => [
                'title' => $data['title'],
                'share_content'=>$data['share_content'],
                'share_title' => $data['share_title'],
                'share_img' => $data['share_img'] ?: $data['index_img'],
            ],
        ]);
         if(customize('babypastel')){
             return $this->fetch('index_babypastel');
         }else{
            return view();
         }
        
    }
    /**
     * 方法描述: 我的优惠卷页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myCoupon()
    {
        $status = (int)input('post.status');
        $brandId = Session::get('brand_id');
        $status = in_array($status, [0, 1, 2]) ? $status : 0;
        $c = [
            'userid' => $this->userId,
            'status' => $status,
            'limit' => 5,
            'page' => input('post.page'),
            'phoneid' => $this->userPhoneId
        ];
        $cachekey = 'couponTotal_status_' . $status . '_' . $this->userId;
        $total = cache($cachekey);
        //var_dump($total);
        if (!$total) {
            $total = controller('index', 'lib')->getUserCouponCount($this->userId, $status, $this->userPhoneId);
            cache($cachekey, $total);
        }
        if (request()->isAjax()) {
            $data = controller('index', 'lib')->getCoupon($c, $status);
            return json(['data' => $data, 'total' => $total, 'status' => 1]);
        } else {
            $cachekey = 'couponAllList_' . $this->userId;
            $data = cache($cachekey);
            if (!$data) {
                $data = controller('index', 'lib')->getCoupon2($c);
                cache($cachekey, $data);
            }
        }
        $activityCouponData = \db('a_activity_list')
            ->alias('a')
            ->join('c_coupon_num b', 'a.couponid = b.id', 'left')
            ->where('a.brandid', $brandId)
            ->limit(4)
            ->select();
        $time = date('Y-m-d H:i:s', time());
        $hlCoupon = db('c_coupon_num')->where('brandid', $brandId)->where('delete_time', null)->where('is_show', 1)->where('end_time', ['>', $time])->where('start_time', ['<', $time])->select();

        //$couponAmountData = \db('c_coupon_num')->where('brandid',$brandId)->select();
        $adv = controller('index', 'lib')->getAdv(4);           //我的优惠卷广告位待处理
        $advCenter = controller('index', 'lib')->getAdv(3);   //我的优惠卷广告位待处理
        $advLast = controller('index', 'lib')->getAdv(9);   //我的优惠卷广告位待处理
        $activityData = \db('a_activity_list')->where('brandid', $brandId)->order('create_time desc')->field('id,index_img')->limit(3)->select();

        $kf = db('c_kf')->where('brandid', Session::get('brand_id'))->find();
        $this->assign([
            'advData' => $adv,
            'advLast' => $advLast,
            'advCenter' => $advCenter,
            'data' => $data,
            'hlCoupon' => $hlCoupon,
            'activityData' => $activityData,
            'couponAmountData' => $activityCouponData,
            'setInfo' => ['title' => '我的优惠券'],
            'kf' => $kf
        ]);

        return view();
    }

    /**
     * 方法描述: 最新活动页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function newActivity()
    {
        //$brandId = Session::get('brand_id');
        //$activityData = controller('index','lib')->getList();
        //$activityData = db("a_activity_list")->where(["brandid"$brandId])->order('create_time desc')->field('id,index_img')->select();
        $levelInfo = getLevel(['userid' => $this->userId]);
        $c = [
            'brandid' => $this->brandId,
            // 'brandid' => 3,
            'isenjoy' => (int)input('get.enjoy'),
            'levelid' => $levelInfo['id'] ? $levelInfo['id'] : 0,
            'limit' => 5,
            'page' => (int)input('request.page'),
        ];

        if (request()->isAjax()) {
            $data = controller('activity', 'lib')->getList($c);

            return json(['data' => $data ?: [], 'status' => 1]);
        }
        $data = controller('activity', 'lib')->getList($c);
        $cc = ['brandid' => $this->brandId];
        $total = controller('activity', 'lib')->getCount($cc);
        $adv = controller('index', 'lib')->getAdv(6);   //最新活动广告位待处理

        $kf = db('c_kf')->where('brandid', Session::get('brand_id'))->find();
        $this->assign([
            'activityData' => $data,
            'adv' => $adv,
            'page' => ceil($total / $c['limit']),
            'setInfo' => [
                'title' => '最新活动',
            ],
            'kf_url' => $kf['url'],
            'phone' => $kf['phone']
        ]);
        return view();
    }

    /**
     * 方法描述: 粉丝页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function brandFans()
    {
        $adv = controller('index', 'lib')->getAdv(5);   //粉丝日广告位待处理
        $this->assign('advData', $adv);
        return view();
    }

    /**
     * 方法描述: 订单页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myOrder()
    {
        return view();
    }


    /**
     * 方法描述: 积分商城页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function shopCity()
    {
        $shopData = Db::connect('db_shop')->query('select * from tp_goods limit 6');  //跨库查询
        $this->assign('shopData', $shopData);
        return view();
    }


    /**
     * 方法描述: 我的地址页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myAddress()
    {
        return view();
    }

    /**
     * 方法描述: 我的收藏页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myCollect()
    {

        return view();
    }

    /**
     * 方法描述: 我的经纪人说明页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myBroker()
    {
        return view();
    }

    /**
     * 方法描述: 我的提现说明页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myExtract()
    {
        return view();
    }

    /**
     * 方法描述: 我的个人中心
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myCenter()
    {

        $wxId = Session::get('memid');  //微信主键id
        $userInfo = db('m_users')
            ->where('user.id', $wxId)
            ->alias('user')
            ->join('user_level level','user.level = level.id','left')
            ->field('user.*,level.name as level_name,level.img')
            ->find();

        $phone = $userInfo['phone'];

        //非常六加一 个人中心余额展示erp会员卡余额
        $erpVip = controller('Order','lib')->getErpVipInfo(['phone'=>$phone]);
        $cardMoney = $erpVip['data']['ds'][0]['cardmoney'];

        $sumIntegralWx = $userInfo['total_score'];


        // 获取优惠券的总数 
        //$couponTotal = controller('index', 'lib')->getUserCouponCount($this->userId, 0);  //弃用
        $w['expire_time'] = ['>',date('Y-m-d H:i:s',time())];
        $w['userid'] = $wxId;
        $couponTotal = db("c_coupon_list")->where("status",'in',[0,4])->where($w)->count();
        
        $brandid = Session::get('brand_id');
        $hotShopData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id,exchange_integral from tp_goods WHERE is_burft=1 and  is_on_sale = 1 and (brand_data_id = 0 or FIND_IN_SET(' . $brandid . ',brand_data_id)) order by sales_sum desc limit 12');  //跨库查询

        $newOneArr = [];
        $newTwoArr = [];
        foreach ($hotShopData as $k => $v) {
            if ($k >= 0 && $k < 6) {
                $newOneArr[] = $v;
            }
            if ($k >= 6) {
                $newTwoArr[] = $v;
            }
        }


        //喜帖儿童模版
        $template = db('wedding_lovecard')->where(['brand_id'=>Session::get('brand_id'),'user_phone_id'=>$this->userId])->select();

        //系统设置中 是否允许会员自己上传客片
        $can_upload = db('c_sysconfig')->where('ckey','front_upload_photo')->value('cvalue');

        $user_level = controller('index','lib')->GetUserLevel();//会员等级
        $adv = controller('index', 'lib')->getAdv(8);   //订单优惠广告位待处理
        $center_adv = controller('index', 'lib')->getAdv(33);  //会员中心下方广告位

        $shopUrl = Session::get('shop_url');
        $appConfig = config('ext.app_config');
        $addr = $appConfig[strtolower("sx_vipshop")]['addr'];  //从接口获取路径

        $this->assign('center_adv',$center_adv);
        $this->assign('adv',$adv);
        $this->assign('user_level',$user_level);
        $this->assign('template', $template);

        $this->assign('shopUrl', $shopUrl ? $shopUrl : $addr);
        $this->assign('userInfo', $userInfo);
        $this->assign('newOneArr', $newOneArr);
        $this->assign('newTwoArr', $newTwoArr);
        //$this->assign('levelName', $levelName);
        $this->assign('couponNum', $couponTotal);     //优惠券数量
        $this->assign('sumIntegral', $sumIntegralWx);
        $this->assign('cardMoney', $cardMoney);//erp里会员卡余额
        $this->assign('can_upload', $can_upload);
        return view();
    }

    /**
     * 方法描述: 我的消费记录页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function consumeRecord()
    {
        $userId = Session::get('memid');
        $phoneId = Session::get('phoneid');
        $record = \db('money_log')->where('user_phone_id', $phoneId)->order('create_time desc')->select();
        $this->assign('record', $record);
//        $moneyRecordData = \db('m_mp_log')->where('m_id',$userId)->order('m_time desc')->select();
//        $topRecordData = \db('m_money_log')->where('phone_id',$phoneId)->order('u_time desc')->select();
//
//        $this->assign('setInfo',['title'=>'消费记录']);
//        $this->assign('consumeRecordData',$moneyRecordData);
//        $this->assign('topRecordData',$topRecordData);
        return view();
    }

    /**
     * 方法描述: 我的成长值记录页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myGrowValue()
    {
        $userId = Session::get('memid');

        // $growValueData = \db('growth_log')->where('userid', $userId)->order('graowth_time desc')->select();
        $growValueData = db('minute_log')->alias('m')
            ->join('m_users_phone p', 'm.users_phone_id=p.id','left')
            ->where('p.userid', $userId)
            ->field('m.m_title,m.m_num,m.m_time,m.m_type')
            ->order('m_time desc')
            ->select();
 
        $this->assign('growValueData', $growValueData);
        $this->assign('setInfo', ['title' => '成长值记录']);
        return view();
    }

    /**
     * 方法描述:全民经济人页
     * @return payCode
     * @author Wangyining<Wangyining@suxuantech.cn> 2019年04月18日
     */
    public function myProject()
    {
        $wxId = Session::get('memid');  //微信主键id
        //$userId = Session::get('phoneid');  //用户手机表主键id
        $brandId = Session::get('brand_id'); //品牌id

        $userInfo = db('m_users')->where('id', $wxId)->find();

        $rule = db('recommend_rule')->where('brand_id',$brandId)->find();
        $recommend_rule = json_decode($rule['rule'],true);

        //需要申请成为经纪人
        if($recommend_rule['is_apply'] == 1 && ($userInfo['agent_status'] == 1 || $userInfo['agent_status'] == 3)){
            $view = 'apply';
        }else{
            $view = 'myproject';
        }


//        if ($userInfo['agent_status'] == 1 || $userInfo['agent_status'] == 3) {
//            $view = 'apply';
//        } elseif ($userInfo['agent_status'] == 2) {
//            $view = 'myproject';
//        } else{
//            $view = 'recommend_rule';
//        }

        //$couponNum = db('c_card_list')->where('user_phone_id', $userId)->count('id');
        $parameter = ['userid' => $wxId, 'fileds' => 'name'];
        $levelName = getLevel($parameter);

        /*
        $where = [
            'status' => 1,
            'userid' => $wxId,
        ];

        $myServantMoney = \db('recommend')->where($where)->sum('award_money');
        */
        $myServantMoney = bcsub($userInfo['money'], $userInfo['freeze_money'], 2);

        $recommendNum = \db('recommend')->where(['userid' => $wxId, 'status' => 2, 'brandid' => $brandId])->count('id');
        $this->assign('userInfo', $userInfo);
        $this->assign('levelName', $levelName);
        //$this->assign('couponNum', $couponNum);
        $this->assign('recommendNum', $recommendNum);
        $this->assign('myServantMoney', $myServantMoney);
        $this->assign('rule', $recommend_rule);

        $this->assign(['setInfo' =>
            [
                'share_title' => '全民经纪人',
                'share_content' => '成为经纪人，享受快乐人生!!!',
                "img_path" => '__PUBLIC__front/shareimg/myproject.png',
            ]
        ]);
        return view($view);
    }

    /**
     * 方法描述:我的客户页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myClient()
    {
        $userId = Session::get('memid');
        $brandId = Session::get('brand_id');
        $page = input('page/d');
        //print_r($page);die;
        $page = $page ? $page : 1;
        $pageSize = 5;
        $offset = ($page - 1) * $pageSize;
        $where = [
            'userid' => $userId,
            'brandid' => $brandId
        ];
        $count = \db('recommend')->where($where)->field('r_username,price_type,r_phone,status')->count();
        $allPage = ceil($count / $pageSize);
        $clientData = db('recommend')
            ->where($where)
            ->alias('a')
            ->join('recommend_photo_type b','a.price_type = b.id','left')
            ->field('a.*,b.type_name')
            ->limit($offset, $pageSize)->select();

        if (request()->isAjax()){

            echo json_encode(array('data' => $clientData, 'allPage' => $allPage));
            exit();
        }

        if (empty($clientData)) {
            $checkNull = 1;
        } else {
            $checkNull = 2;
        }

        $this->assign('count', $count);
        $this->assign('allPage', $allPage);
        $this->assign('checkNull', $checkNull);
        $this->assign('clientData', $clientData);
        return view();
    }

    /*
     * 我推荐的客户订单
     */
    public function myClientOrders(){
        $recommend_id = input('id');
        $orders = db('recommend')
            ->where('a.id',$recommend_id)
            ->alias('a')
            ->join('m_order order','a.id = order.recommend_id','left')
            ->field('a.r_username,a.r_phone,a.create_time as recommend_time,order.*')
            ->select();
        if(config('recommend_money') ==1){
            $this->assign('get_type',1);
        }else{
            $this->assign('get_type',2);
        }
        $this->assign('orders',$orders);
        return $this->fetch();
    }

    /*
     * 获取领奖详情页
     */
    public function getAwardInfo()
    {

        $id = input('post.id');
        $data = db('m_order')->where('id', $id)->find();
        if ($data) {
            return array('code' => 1, 'data' => $data);
        }
    }

    /*
     * 领取奖励
     */
    public function receiveAward()
    {
        $id = input('post.id');
        $jiangli  = input('post.jiangli');
        $jifen  = input('post.jifen');

        $userid = session('userid');

        db()->startTrans();
        try {
            $edit['is_get'] = 1;
            $edit['get_type'] = input('post.get_type');

            if ($edit['get_type'] == 1) {
                $edit['get_award'] = $jiangli;

                $money['money'] = $jiangli;
                $money['m_type'] = 3;//佣金
                $money['m_type_name'] = '经纪人奖励佣金';
                $money['create_time'] = date('Y-m-d H:i:s', time());
                $money['user_id'] = $userid;
                $money['number'] = $id;

                db('m_users')->where('id', $userid)->update(['money' => ['exp', "money + $jiangli"]]);

                db('money_log')->insert($money);

            } elseif ($edit['get_type'] == 2) {

                $edit['get_award'] = $jifen;

                AddScore($userid,'',$jifen,3,'经纪人奖励积分');
                //db('m_users')->where('id', $userid)->update(['total_score' => ['exp', "total_score + $jifen"]]);
                //minuteDetailed('经纪人奖励积分', $edit['get_award'], $recommend['userid'], 15, '');
            }
            db('m_order')->where('id', $id)->update($edit);
            db()->commit();
            return array('code' => 1, 'msg' => '领取成功');
        } catch (Exception $e) {
            db()->rollback();
            return array('code' => 0, 'msg' => '领取失败，请稍后重试');
        }
    }

    /*
     * 领奖页面
     */
    public function awardInfo()
    {
        $id = input('get.id');
        //print_r($id);die;
        $data = db('recommend')->where('id', $id)->find();
        $this->assign('data', $data);
        return view('awardinfo');
    }

    /**
     * 方法描述:我的佣金页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myServantMoney()
    {
        //$phone_id = Session::get('phoneid');

        $userId = Session::get('memid');
        $brandId = Session::get('brand_id');
        $where = [
            'status' => 1,
            'userid' => $userId,
        ];
        $page = request()->post('page');
        $page = $page ? $page : 1;
        $pageSize = 5;
        $offset = ($page - 1) * $pageSize;

        $checkBankMessage = \db('m_withdraw')->where('userid', $userId)->where('brandid', $brandId)->find();
        if (empty($checkBankMessage)) {
            $bankMessage = 1;
        } else {
            $bankMessage = 2;
        }

        $getNowWhere = [
            'userid' => $userId,
        ];
        $db = \db('m_withdraw_log')->where($getNowWhere)->field('get_money,get_time,money_status');
        $count = $db->count();
        $allPage = ceil($count / $pageSize);
        $recordGetNowMoney = $db->where($getNowWhere)->limit($offset, $pageSize)->select();
        if (request()->isAjax()) {
            $jsonReturn = [
                'count' => $count,
                'allPage' => $allPage,
                'data' => $recordGetNowMoney,
            ];
            echo json_encode($jsonReturn);
            exit();
        }
        if (empty($recordGetNowMoney)) {
            $checkNull = 1;
        } else {
            $checkNull = 2;
        }

        //$phoneData = db('m_users_phone')->where('id', $phone_id)->find();
        $userInfo = db('m_users')->where('id', $userId)->find();
        $remainGetMoney = bcsub($phoneData['money'], $phoneData['freeze_money'], 2);
        //$myServantMoney = \db('recommend')->where($where)->sum('servant_money');  //计算有多少佣金
        //$moneyArrive = \db('m_withdraw_log')->where('user_phone_id',$userId)->sum('get_money'); //以提现额度
        $moneyArrive = db('money_log')->where('user_id', $userId)->where('m_type', 2)->sum('money');//已提现总金额
        //$remainGetMoney = bcsub($myServantMoney,$moneyArrive,2);
        $this->assign('count', $count);
        $this->assign('allPage', $allPage);
        $this->assign('checkNull', $checkNull);  //是否有数据
        $this->assign('moneyArrive', -1 * $moneyArrive);  //以提现额度
        $this->assign('recordGetMoney', $recordGetNowMoney);
        $this->assign('myServantMoney', $remainGetMoney);   //可提现额度
        $this->assign('checkBankMessage', $bankMessage); //是否已绑定银行卡
        $this->assign('userInfo', $userInfo);
        return view();
    }

    /**
     * 方法描述:我的佣金明细
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myServantMoneyRecord()
    {

        return view();
    }

    /**
     * 方法描述:我的客户推荐页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myRecommend()
    {
        //$secretarys = db('secretary')->field('name,id')->where(['brandid' => $this->brandId])->select();//会员秘书
        //套系类型
        $type = db('recommend_photo_type')->where('brand_id',$this->brandId)->select();
        $this->assign('type', $type);
        return view();
    }

    /**
     * 方法描述:经纪人制度规则说明
     * @return payCode
     * @author Wangyining<wangyining@suxuantech.cn> 2018年03月11日
     */
    public function  recommend_rule()
    {
        //$userPhoneId = Session::get('phoneid');  //用户手机表主键id
        //$userPhoneData = db('m_users_phone')->where('id', $userPhoneId)->find();
        $rule = db('recommend_rule')->where('brand_id',session('brand_id'))->find();
        $recommend_rule = json_decode($rule['rule'],true);
        $userInfo = db('m_users')->where('id',$this->userId)->find();
        $this->assign([
            'userInfo' => $userInfo,
            'recommend_rule' => $recommend_rule
        ]);
        //需要申请成为经纪人
        if($recommend_rule['is_apply'] == 1){
           
            return $this->fetch();
        }else{
            $userData = db('m_users')->where('id',$this->userId)->find();
            //先绑定手机号
            if(!$userData['phone']){
                $this->assign(['upaddress' => url('Index/recommend_rule')]);
                return $this->fetch('index/bind');
            }
            return view('myproject');
        }

    }


    /**
     * 方法描述:申请经纪人页
     * @return payCode
     * @author Wangyining<wangyining@suxuantech.cn> 2018年03月11日
     */
    public function apply()
    {

        $userInfo = db('m_users')->where('id',$this->userId)->find();
        //print_r($userInfo);die;
        $this->assign('userInfo', $userInfo);
        return view();
    }

    /*
     * 经纪人注册协议
     */
    public function agreement()
    {
        return $this->fetch();
    }

    /**
     * 方法描述:我的佣金获得说明页
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myMoneyState()
    {
        $kf = controller('index', 'lib')->getKf();
        $brandData = getSiteBrand();
        $brandId = $brandData['id'];
        $rule = db('recommend_rule')->where('brand_id',$brandId)->find();

        $this->assign('rule',json_decode($rule['rule'],true));


        $this->assign(['kf'=>$kf]);
        $this->assign('setInfo', ['title' => '钱包细则']);
        return view();
    }
    /**
     * 方法描述：会员卡及其权益列表
     * @return [type] [description]
     */
    public function card(){
        $kid = input('kid');
        //$userinfo = getUserInfo(['userid' => $this->userId]);
        $userinfo = db('m_users')->where('id', $this->userId)->find();

        $user_level = controller('index','lib')->GetUserLevel();
        $stateData  = controller('index','lib')->getBereq();    //获取权益数据值

        $canUp = getLevelByTotal($this->userId);

        foreach ($user_level as $k => $v) {
            foreach ($stateData as $k2 => $v2) {
                if ($v['id'] == $v2['eq_card_type']) {
                    $user_level[$k]['bereq'][] = $stateData[$k2];
                }
            }

            //是否可升级
            if(in_array($v['id'],$canUp)){
                $user_level[$k]['can_up'] = 1;
            }

            //当前会员名称
            if($v['id'] == $userinfo['level']){
                $userinfo['level_name'] = $v['name'];
                $userinfo['level'] = $k;
            }
        }
        $this->assign('kid',$kid);
        $this->assign("userinfo",$userinfo);
        $this->assign("user_level",$user_level);
        if(config('index_card_view')){
            return view(config('index_card_view'));
        }else{
            return view();
        }
        
    }

    /**
     * 方法描述:我的会员卡说明
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myCard()
    {
        $brandData = getSiteBrand();
        $brandId = $brandData['id'];

        $id = input("id");
        $cardid = input("cardid");
        $data = controller('index','lib')->getBereq($cardid); //获取权益数据值
        foreach ($data as $k => $v) {
            if($v['id'] == $id){
                $level = $k;
            }
        }
        $this->assign('level',$level);
        $this->assign('id',$id);
        $this->assign('data',$data);
        return view();
    }

    /*
     * 会员等级升级
     */
    public function levelUp(){

        $level_id = input('level_id');
        if(!$level_id){
            return ['code'=>201,'msg'=>'您还不能升级此等级'];
        }

        //登记规则
        $levelData = db('user_level')->where('id',$level_id)->find();

        //会员详情
        $userData = db('m_users')->where('id',$this->userId)->find();

        if($userData['total_consumption']>=$levelData['total_pay'] && $userData['total_score']>=$levelData['deduct_score']){
            db()->startTrans();
            try{
                db('m_users')->where('id',$this->userId)->update(['level'=>$level_id]);
                //减积分
                AddScore($this->userId,'',-$levelData['deduct_score'],19,'会员等级升级');

                db()->commit();
                return ['code'=>200,'msg'=>'升级成功！'];

            }catch (Exception $e){

                db()->rollback();
                return ['code'=>203,'msg'=>'升级失败，请稍后重试！'];
            }
        }else{
            return ['code'=>202,'msg'=>'您还不能升级此等级'];
        }

    }

    /**
     * 方法描述:我的银行卡列表
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myBankList()
    {
        $userId = Session::get('memid');
        $phoneId = Session::get('phoneid');
//        $userId = 108;
//        $brandId= 1;
        //$userBankData = \db('m_withdraw')->where('user_phone_id', $userId)->field('id,user_bank,bank_code,bank_time')->find();
        $userBankData = \db('m_withdraw')->where('user_phone_id', $phoneId)->field('id,user_bank,bank_code,bank_time')->find();
        $lengthBad = strlen($userBankData['bank_code']) - 4;
        $userBankData['bank_code'] = substr_replace($userBankData['bank_code'], str_repeat('*', $lengthBad), 0, $lengthBad);
        $userBankData['bank_code'] = strLens($userBankData['bank_code']);
        $userBankData['bank_time'] = str_replace('-', '/', substr($userBankData['bank_time'], 0, 10));        
        $this->assign('userBankData', $userBankData);
        return view();
    }

    /**
     * 方法描述:我的银行卡添加
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myBankAdd()
    {
        $auto_id = input('get.auto_id');
        $this->assign('auto_id', $auto_id);
        return view();
    }

    /**
     * 方法描述:金额提现页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myGetMoney()
    {
        $userId = Session::get('memid');
        //$phone_id = Session::get('phoneid');
        $userData = db('m_users')->where('id', $userId)->find();
        $sumMoney = bcsub($userData['money'], $userData['freeze_money'], 2); //可提现余额 = 余额 - 冻结余额

        //$sumMoney = \db('recommend')->where('userid',$userId)->where('status',2)->sum('servant_money');
        $laterCardData = \db('m_withdraw')->where('userid', $userId)->field('bank_code')->find();
        $laterCardNumber = substr($laterCardData['bank_code'], -4);
        $this->assign('sumMoney', $sumMoney);
        $this->assign('laterCardNumber', $laterCardNumber);
        return view();
    }

    /**
     * 方法描述:金额提现处理页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function myGetMoneyPlan()
    {
        $autoId = input('get.auto_id');
        $userId = Session::get('memid');

        $getOneMoney = \db('m_withdraw_log')
            ->alias('a')
            ->join('m_withdraw b', 'a.userid = b.userid')
            ->where('a.userid', $userId)
            ->where('a.id', $autoId)
            ->field('a.get_time,a.money_status,a.get_money,a.error_state,b.user_bank,b.bank_code')
            ->find();
        //print_r(db()->getLastSql());die;

        $thisTime = $getOneMoney['get_time'];
//        $getOneMoney['get_time'] = date('Y-m-d H:i',strtotime($getOneMoney['get_time']) + 7200);
        $getOneMoney['get_time'] = date('Y-m-d H:i', strtotime(" $thisTime +2 hour"));
//        var_dump($getOneMoney['get_time']);exit;
        $this->assign('getOneMoney', $getOneMoney);
        return view();
    }

    /**
     * 方法描述:轮播长图
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function longImg()
    {
        return view();
    }

    /**
     * 方法描述:预约团队列表
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function teamList()
    {
        return view();
    }

    /**
     * 方法描述:立即预约
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function promptlyMake()
    {
        return view();
    }


    /**
     * 方法描述:会员课堂
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function memberClass()
    {

        return view();
    }

    /**
     * 方法描述:课堂报名
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function memberClassReport()
    {
        $setInfo = [
            'title' => '预约报名',
        ];
        $this->assign('setInfo', $setInfo);
        return view();
    }

    /**
     * 方法描述:订单优惠页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function orderDiscounts()
    {
        $brandid = Session::get('brand_id');
        $reducedData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id,exchange_integral from tp_goods WHERE  is_coupon=1 and  is_on_sale = 1  and (brand_data_id = 0 or FIND_IN_SET(' . $brandid . ',brand_data_id)) ORDER by sort DESC limit 12');  //跨库查询
        $adv = controller('index', 'lib')->getAdv(8);   //订单优惠广告位待处理
        $shopUrl = Session::get('shop_url');
        $appConfig = config('ext.app_config');
        $addr = $appConfig[strtolower("sx_vipshop")]['addr'];    //从接口获取路径
        $kf_url = db('c_kf')->where('brandid', Session::get('brand_id'))->value('url');
        $this->assign([
            'advdData' => $adv,
            'reducedData' => $reducedData,
            'shopUrl' => $shopUrl ? $shopUrl : $addr,
            'kf_url' => $kf_url,
        ]);
        return view();
    }

    public function manProduction()
    {
        return view();
    }

    public function getsMoney()
    {
        $setInfo = ['title' => '提现'];
        $this->assign('setInfo', $setInfo);
        return view();
    }

    /**
     * 方法描述:优惠卷下方详情页面
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function pageCoupon()
    {
        $type = input('get.type');
        $this->assign('type', $type);
        return view();
    }

    /**
     * 方法描述:敬请期待
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wait()
    {
        $setInfo = ['title' => '敬请期待'];
        $this->assign('setInfo', $setInfo);
        return view();
    }

    /**
     * 方法描述  添加活动留言
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年02月02日 下午4:19:47
     */
    public function addActivityMsg()
    {
        if (request()->isAjax()) {
            $content = htmlspecialchars(input('post.content'));
            $d = [
                'userid' => $this->userId,
                'content' => $content,
                'create_time' => date('Y-m-d H:i:s', time()),
                'activity_id' => (int)input('post.activityid'),
            ];
            if ($d['activity_id']) {
                $res = controller('activity', 'lib')->addActivityMsg($d);
            }
            return json(['status' => $res ? 1 : 0, 'data' => ['time' => date('Y-m-d H:i:s', time()), 'id' => $res]]);
        }
    }

    /**
     * 方法描述  修改活动留言
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年02月02日 下午4:19:47
     */
    public function editActivityMsg()
    {
        if (request()->isAjax()) {
            $content = htmlspecialchars(input('post.content'));
            $d = [
                'id' => (int)input('post.msgid'),
                'userid' => $this->userId,
                'content' => $content,
                'status' => 0,
            ];
            if ($d['id']) {
                $res = controller('activity', 'lib')->editActivityMsg($d);
            }
            return json(['status' => $res ? 1 : 0]);
        }
    }


    /**
     * 方法描述 删除活动留言
     * @return payCode
     * @author zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年02月02日 下午4:19:47
     */
    public function delActivityMsg()
    {
        if (request()->isAjax()) {
            $id = (int)input('request.id');
            if ($id) {
                $res = controller('activity', 'lib')->delActivityMsg($id, $this->userId);
            }
            return json(['status' => $res ? 1 : 0]);
        }
    }

    public function watermark()
    {

        $help = db('wx_help')->where('id', 12)->find();
        $params = json_decode($help['params'], true);

        $site['photo_scale'] = $params['avatar']['scale'];
        $site['photo_x'] = $params['avatar']['x'];
        $site['photo_y'] = $params['avatar']['y'];
        $site['name_x'] = $params['avatar']['x'] + 100;
        $site['name_y'] = $params['avatar']['y'] + 30;
        $site['ewm_scale'] = $params['qrcode']['scale'];
        $site['ewm_x'] = $params['qrcode']['x'];
        $site['ewm_y'] = $params['qrcode']['y'];

        $bg_img = ROOT_PATH . '/public/img/modal4.jpg';
        $accessTokenApi = sx_call('5a60436d631a4', array(
            'brandclass_id' => 2
        ));
        if ($accessTokenApi['code'] == 200) {
            $accessTokenData = $accessTokenApi['data'];
        }
        $openid = 'o3mGr0paq4VWktKzPiBn-082a4Go';
        $urlInfo = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=" . $accessTokenData['access_token'] . "&openid=" . $openid . "&lang=zh_CN";
        $res = http_request($urlInfo, 'GET');
        $userInfo = json_decode($res['response'], true);
        //print_r($userInfo);die;
        //$head_img=$userInfo['head_img'];
        if ($params['is_show_avatar'] == 1) {
            $head_img = $userInfo['headimgurl'];
            $nickname = $userInfo['nickname'];
        }
//        $scene='ZL_'.'1'.'_'.$openid;
//        $url="5a73d4f13a9eb";
//        $res=sx_call($url,array('brandclass_id'=>2,'scene'=>$scene));
//        if($res['code']==200){
//            $ticket=$res['data'];
//        }

        $qrcode = 'https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=gQFx7zwAAAAAAAAAAS5odHRwOi8vd2VpeGluLnFxLmNvbS9xLzAyakZST3MydXhlSGkxR3lYb3hxY2wAAgRmu5haAwQ8AAAA';
//echo '<img src="'.$qrcode.'" width="100%" />';
//die;
        // $head_img=ROOT_PATH.'/public/upload/a.jpg';
        //$qrcode=ROOT_PATH.'public/img/ewm.jpg';
        $a = watermark($bg_img, $head_img, $nickname, $qrcode, $site, $openid, $help['brand_id']);
        //print_r($a);
        //die;
    }

    /**
     * 方法描述：团购活动列表
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月12日 10:30:38
     */
    public function groupActivityList()
    {
        //*****进行中的活动
        $w['starttime'] = ['<', date("Y-m-d H:i:s", time())];
        $w['endtime'] = ['>', date("Y-m-d H:i:s", time())];
        $w['status'] = 1;
        $w['brandid'] = $this->brandId;
        $activitylist = db('group_activity')
            ->where($w)
            ->field('id,activity_title,front_money,wedding_price,user_require,starttime,endtime,list_img,price')
            ->order('create_time desc')
            ->select();    //活动列表;
        $c['broker_id'] = Session::get("phoneid");
        $buyactivity = db('group_buy')->where($c)->field('activity_id')->select();
        $buyactivity = array_column($buyactivity, "activity_id");
        //*****我的团购
        $a['broker_id']   = Session::get("phoneid"); //经济人phoneid
        $a['a.starttime'] = ['<', date("Y-m-d H:i:s", time())];
        $a['a.endtime'] = ['>', date("Y-m-d H:i:s", time())];
        $a['a.brandid'] = $this->brandId;

        //团购列表
        $buylist = db('group_buy')
            ->alias("b")
            ->where($a)
            ->join("group_activity a", 'b.activity_id=a.id')
            ->select();

        $user = db('group_user')->select();        //参与团购人员
        foreach ($buylist as $k2 => $v2) {
            $num = 0;
            foreach ($user as $k => $v) {
                if ($v['groupbuy_id'] == $v2['id']) {
                    $num++;
                }
            }
            $buylist[$k2]['renshu'] = $num;//计算参团人数
        }

        //*****以往团购
        $b['broker_id'] = Session::get("phoneid");
        $b['a.endtime'] = ['<', date("Y-m-d H:i:s", time())];
        $b['a.brandid'] = $this->brandId;
        $oldbuylist = db('group_buy')
            ->alias("b")
            ->where($b)
            ->join("group_activity a", 'b.activity_id=a.id')
            ->select();      //团购列表
        $olduser = db('group_user')->select();      //参与团购人员
        foreach ($oldbuylist as $k2 => $v2) {
            $num = 0;
            foreach ($olduser as $k => $v) {
                if ($v['groupbuy_id'] == $v2['id']) {
                    $num++;
                }
            }
            $oldbuylist[$k2]['renshu'] = $num;//计算参团人数
        }
        $this->assign([
            'activitylist' => $activitylist,
            'buyactivity' => $buyactivity,
            'buylist' => $buylist,
            'oldbuylist' => $oldbuylist
        ]);
        return view();
    }
    /**
     * 方法描述：活动详情
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月12日 20:30:38
     */
    /* public function groupActivityInfo(){
    	$id = input("activity_id");  //活动id
    	$buyid = input("buyid");     //团购id
    	if($buyid){      //判断是否是用户进来
    		$userOne = db("group_buy")
                		->where('id',$buyid)
                		->find();
    		$where['groupbuy_id'] = $buyid;
    		$where['user_id'] = Session::get("memid");
    		$usertwo = db("group_user")->where($where)->find();
    		$id = $userOne['activity_id'];
    		$this->assign("usertwo",$usertwo);
    		$this->assign("userone",$userOne);
    	}
    	$a['id'] = $id;
    	$activityArr = db('group_activity')
    	               ->where($a)
    	               ->find();   //活动信息

    	$time = $activityArr['endtime'] < date("Y-m-d H:i:s")?1:0;  //判断活动是否已结束
        $b['b.activity_id'] = $id;
        //$b['b.broker_id'] = Session::get("phoneid");
        $b['a.starttime'] = ['<',date("Y-m-d H:i:s",time())];
        $b['a.endtime']   = ['>',date("Y-m-d H:i:s",time())];
        $buyArr = db('group_buy')
                    ->alias("b")
                    ->where($b)
                    ->join("group_activity a","a.id=b.activity_id")
                    ->field("b.id,b.broker_id")
                    ->find();

        //参团成员
        $userArr   = db('group_user')->where('groupbuy_id',$buyArr['id'])->limit(5)->select();
        $userCount = db('group_user')->where('groupbuy_id',$buyArr['id'])->count();

        //分享
        $link = url('front/index/groupActivityInfo','','',true);
        $setInfo = [
            'title'     => $activityArr['share_title'],
            'img_path'  => '/public/uploads/'.$activityArr['share_img'],
            'share_link'=> $link.'?buyid='.$buyArr['id'],
            'content'   => $activityArr['share_desc'],
        ];
        $url = "{:url('Index/groupActivityInfo')}?buyid=".$buyArr['id'];
        $this->assign('setInfo',$setInfo);
        $this->assign('url',$url);

        //立即参团时取 团购id
        if(empty($buyid)){
        	$this->assign("buyid",$buyArr['id']);
        }else{
        	$this->assign("buyid",$buyid);
        }
        //判断当前活动是否结束 （显示时间）
        if($activityArr['endtime']<date("Y-m-d H:i:s",time())){     //已结束
            $this->assign("endactivity","end");
        }else{                                                      //未结束
        	$this->assign("endactivity","notend");
        }
    	$this->assign([
    	       'time'=>$time,              //判断活动已结束
    	       'phoneid'=> Session::get("phoneid"),
    	       'buyarr'  =>$buyArr,
    	       'userarr'  =>$userArr,        //参团人员列表
    	       'usercount' =>$userCount,    //参团人数
        	   'activityarr'=>$activityArr,//活动详情
    	]);
    	return view();
    } */
    /**
     * 方法描述：团购活动详情（新会员）
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月12日 20:30:38
     */
    public function groupActivityInfo()
    {
        $id = input("activity_id");  //活动id
        $buyid = input("buyid");     //团购id
        if ($buyid) {      //判断是否是用户进来
            $userOne = db("group_buy")
                ->where('id', $buyid)
                ->find();
            $where['groupbuy_id'] = $buyid;
            $where['user_id'] = Session::get("memid");
            $usertwo = db("group_user")->where($where)->find();
            $id = $userOne['activity_id'];
            $this->assign("usertwo", $usertwo);
            $this->assign("userone", $userOne);
        }
        $a['id'] = $id;
        $activityArr = db('group_activity')
            ->where($a)
            ->find();   //活动信息

        $time = $activityArr['endtime'] < date("Y-m-d H:i:s") ? 1 : 0;  //判断活动是否已结束
        $b['b.activity_id'] = $id;
        //$b['b.broker_id'] = Session::get("phoneid");
        $b['a.starttime'] = ['<', date("Y-m-d H:i:s", time())];
        $b['a.endtime'] = ['>', date("Y-m-d H:i:s", time())];
        $buyArr = db('group_buy')
            ->alias("b")
            ->where($b)
            ->join("group_activity a", "a.id=b.activity_id")
            ->field("b.id,b.broker_id")
            ->find();

        //参团成员
        $userArr = db('group_user')->where('groupbuy_id', $buyArr['id'])->limit(5)->select();
        $userCount = db('group_user')->where('groupbuy_id', $buyArr['id'])->count();

        //分享
        $link = url('front/index/groupActivityInfo', '', '', true);
        $setInfo = [
            'title' => $activityArr['share_title'],
            'img_path' => '/public/uploads/' . $activityArr['share_img'],
            'share_link' => $link . '?buyid=' . $buyArr['id'],
            'content' => $activityArr['share_desc'],
        ];
        $url = "{:url('Index/groupActivityInfo')}?buyid=" . $buyArr['id'];
        $this->assign('setInfo', $setInfo);
        $this->assign('url', $url);

        //立即参团时取 团购id
        if (empty($buyid)) {
            $this->assign("buyid", $buyArr['id']);
        } else {
            $this->assign("buyid", $buyid);
        }
        //判断当前活动是否结束 （显示时间）
        if ($activityArr['endtime'] < date("Y-m-d H:i:s", time())) {     //已结束
            $this->assign("endactivity", "end");
        } else {                                                      //未结束
            $this->assign("endactivity", "notend");
        }
        $this->assign([
            'time' => $time,              //判断活动已结束
            'phoneid' => Session::get("phoneid"),
            'buyarr' => $buyArr,
            'userarr' => $userArr,        //参团人员列表
            'usercount' => $userCount,    //参团人数
            'activityarr' => $activityArr,//活动详情
        ]);
        return view();
    }

    /**
     * 方法描述：立即领取活动
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月13日
     */
    public function getActivity()
    {
        $id = input("id");     //活动id
        $activityArr = db("group_activity")->where("id", $id)->field("activity_title,share_img,share_desc")->find();
        $data['activity_id'] = $id;
        $data['activity_title'] = $activityArr['activity_title'];
        $data['broker_id'] = Session::get("phoneid");
        $data['broker_name'] = Session::get("username");
        $data['brandid'] = Session::get("brandid");
        $data['create_time'] = date("Y-m-d H:i:s");
        $res = db("group_buy")->insert($data);
        if ($res) {
            return json(array("code" => 1, 'msg' => "领取成功"));
        } else {
            return json(array("code" => -1, 'msg' => "领取失败"));
        }
    }

    /**
     * 方法描述：参团人员详情
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04年13日 13:50:38
     */
    public function groupUserInfo()
    {
        $groupbuy_id = input("groupbuy_id");   //团购id
        $userArr = db('group_user')
            ->where('groupbuy_id', $groupbuy_id)
            ->select();
        $this->assign([
            'userarr' => $userArr,
        ]);
        return view();

    }

    /**
     * 方法描述：获取参团客户信息
     * @return Ambigous <\think\response\Json, \think\Response, \think\response\View, \think\response\Xml, \think\response\Redirect, \think\response\Jsonp, unknown, \think\Response>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04年13日 14:00:38
     */
    public function getUserInfo()
    {
        $user_id = input("user_id");
        $userinfoArr = db("group_user")
            ->where("id", $user_id)
            ->find();
        if ($userinfoArr) {
            return json(array("code" => 1, "msg" => "查询成功", "data" => $userinfoArr));
        } else {
            return json(array("code" => -1, "msg" => "查询失败"));
        }
    }

    /**
     * 方法描述：立即参团
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月14日 12:42:38
     */
    public function grouptuxedo(){
        if (IS_POST && request()->isAjax()) {
            $user_id = Session::get("memid");
            $name = input("name");
            $phone = input("phone");
            $wedding_day = input("wedding_day");
            $front_money = input("front_money");
            $groupbuy_id = input("groupbuy_id");
            // sub:
            $order_no = $this->rands();       //获取订单号
            // $orderArr = db("group_user")->where("order_no",$order_no)->find();
            // if(!empty($orderArr)){
            // 	goto sub;
            // }

            $data['name'] = $name;
            $data['phone'] = $phone;
            $data['wedding_day'] = $wedding_day;
            $data['groupbuy_id'] = $groupbuy_id;
            $data['brandid'] = Session::get("brand_id");
            $data['order_no'] = $order_no;
            $data['status'] = 0;
            $data['front_money'] = $front_money;
            $data['user_id'] = $user_id;
            $data['user_name'] = Session::get("username");
            $data['img'] = Session::get("simg");
            $data['join_time'] = date("Y-m-d H:i:s", time());
            //是否需要付定金
            if ($front_money > 0) {
                $data['pay_status'] = 0;
            } elseif ($front_money == 0) {
                $data['pay_status'] = 1;
            }
            //是否已参加过该团购
            $a['groupbuy_id'] = $groupbuy_id;
            $a['user_id'] = $user_id;
            $arr = db("group_user")->where($a)->find();
            if ($arr) {
                return json(["code"=>202,"msg"=>"该团购您已报名",'status'=>0]);
            }

            //判断当前用户是否符合团购活动要求
            $groupbuyArr = db("group_buy")
                ->alias("b")
                ->where('b.id', $groupbuy_id)
                ->join("group_activity a", "a.id=b.activity_id")
                ->field("permit_level")
                ->find();
            $userinfo = getUserInfo(['userid' => $this->userId]);     //获取用户信息
            if ($groupbuyArr) {   //判断团购活动时候有 等级要求
                if (strpos($groupbuyArr['permit_level'], ",")) {
                    $level = explode(',', $groupbuyArr['permit_level']);
                    $dd['brandid'] = Session::get("brand_id");
                    foreach ($level as $k => $v) {
                        $dd['id'] = $v;
                        $levelArr[] = db("user_level")->where($dd)->find();
                    }
                    for ($a = 0; $a < count($levelArr); $a++) {
                        if ($a == 0) {
                            $max_value = $levelArr[$a]['max_value'];
                            $level_name = $levelArr[$a]['name'];
                        } else {
                            if ($max_value > $levelArr[$a]['max_value']) {
                                $max_value = $levelArr[$a]['max_value'];
                                $level_name = $levelArr[$a]['name'];
                            }
                        }
                    }
                    if ($userinfo['growth_value'] < $max_value) {
                        return json(array("code" => 202, "msg" => "该团购必须等级达到'" . $level_name . "'才能参与"));
                    }

                } else {
                    $level = $groupbuyArr['permit_level'];
                    $ff['brandid'] = Session::get("brand_id");
                    $ff['id'] = $level;
                    $levelArr2 = db("user_level")->where($ff)->find();
                    if ($userinfo['growth_value'] < $levelArr2['max_value']) {
                        return json(array("code" => 202, "msg" => "该团购必须等级达到'" . $levelArr2['name'] . "'才能参与"));
                    }
                }
            }


            $res = db("group_user")->insert($data);
            if ($res) {
                if ($front_money == 0) {  //不用支付定金，直接组团
                    $f = controller("Index", "lib")->groupbuy($groupbuy_id, $user_id);
                    $f = json_decode($f, true);
                    if ($f['status'] == 1) {
                        return json(array("code" => 200, "msg" => "成团成功", 'status' => 1));
                    } else {
                        return json(array("code" => 200, "msg" => "成团成功", 'status' => 2));
                    }
                }
                return json(array("code" => 200, "msg" => "添加成功", 'status' => 0, "data" => array('order_no' => $order_no, 'front_money' => $front_money)));
            } else {
                return json(array("code" => 400, "msg" => "添加失败"));
            }
        } else {
            $groupbuy_id = input("groupbuy_id");
            $activityArr = db("group_buy")
                ->alias("b")
                ->where("b.id", $groupbuy_id)
                ->join("group_activity a", "a.id=b.activity_id")
                ->field("front_money,b.id")
                ->find();
            $this->assign("activityarr", $activityArr);
            return view();
        }
    }

    /**
     * 方法描述：订单号生成
     * @return string
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年04月15日 11:18:38
     */
    public function rands()
    {
        $str = '1234567890';
        $randStr = str_shuffle($str);//打乱字符串
        $rands = substr($randStr, 0, 5);
        $rand = time() . Session::get("memid") . $rands;
        return $rand;
    }

    /**
     * 方法描述：支付
     * @param unknown $front_money 支付金额
     * @param unknown $order_no 单号
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月15日 15:38:38
     */
    public function payment()
    {
        $order_no = input("order_no");  //接收单号
        $action   = input("action");      //重复付款标识
        $userInfo = db("group_user")->where("order_no", $order_no)->find();
        if ($action == "payment") {
            //sub:
            $rands = $this->rands();
            //if($rands == $userInfo['order_no']){
            //goto sub;
            //}
            $a['order_no'] = $rands;
            $res = db("group_user")->where("id", $userInfo['id'])->update($a);
            if ($res) {
                $order_no = $rands;
            }
        }
        $data['body'] = Session::get("group_company_name") . "-在线订单支付";
        $data['total_fee'] = $userInfo['front_money'] * 100;
        $data['trade_type'] = "JSAPI";
        $data['order_no'] = $order_no;
        $data['brand_id'] = Session::get("brand_id");
        $data['open_id'] = Session::get("openid");
        $payOrder = sx_call('5a5c6626eef07', $data, 'sx_mc');
        if ($payOrder['code'] == 200) {
            $prepay_id = $payOrder['data']['prepay_id'];
            $arr['prepay_id'] = $prepay_id;
            $arr['brand_id'] = Session::get("brand_id");
            $payment = sx_call('5a5dbddc8fa64', $arr, 'sx_mc');
        }
        $this->assign('order_no', $order_no);
        $this->assign('payment', $payment);
        return view();

    }


    /**
     * 方法描述：支付结果判断
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月16日 11:28:38
     */
    public function paymentjudge()
    {
        $order_no = input("order_no");
        $userArr = db("group_user")->where("order_no", $order_no)->field("front_money,groupbuy_id,id")->find();
        $data['order_no'] = $order_no;                          //单号
        $payArr = sx_call('5a5ca00c81db4', $data, 'sx_mc');       //调接口
        if ($payArr['code'] == 200) {
            if ($payArr['data']['pay_status'] == "PAYED" && $payArr['data']['pay_fee'] == $userArr['front_money'] * 100) {   //判断支付成功
                //$this->assign("msg","200");
                $a['pay_status'] = 1;
                $a['pay_time'] = date("Y-m-d H:i:s", time());
                db("group_user")->where('order_no', $order_no)->update($a);
                $f = controller("Index", "lib")->groupbuy($userArr['groupbuy_id'], $userArr['id']); //成团算法
                $f = json_decode($f, true);
                $this->assign('status', $f['status']);
            } else {
                $this->assign("status", "202");
            }
        }
        return view();
    }

    /**
     * 方法描述：我的团购
     * @return Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月15日 15:34:38
     */
    public function mygroupbuy()
    {
        $a['a.user_id'] = session::get("memid");
        $a['a.status'] = ['<>', 3];
        $userArr = db("group_user")
            ->alias("a")
            ->where($a)
            ->join("group_buy b", "b.id=a.groupbuy_id")
            ->join("group_activity c", "b.activity_id=c.id")
            ->field("a.id,a.order_no,b.activity_title,b.id bid,a.pay_status,a.status,c.user_require,c.list_img,c.coupon_num")
            ->select();
        $this->assign('userarr', $userArr);
        return view();
    }

    /**
     * 方法描述：取消拼团
     * @return Ambigous <\think\response\Json, \think\Response, \think\response\View, \think\response\Xml, \think\response\Redirect, \think\response\Jsonp, unknown, \think\Response>|Ambigous <\think\response\View, \think\response\$this, \think\response\View>
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn> 2018年4月15日 17:50:38
     */
    public function groupbuycancel()
    {
        if (IS_POST && request()->isAjax()) {
            $data = input("");
            $a['name'] = $data['name'];
            $a['phone'] = $data['phone'];
            $a['groupuser_id'] = $data['groupuser_id'];
            $a['cause'] = $data['cancel'];
            $a['create_time'] = date("Y-m-d H:i:s", time());
            $res = db("group_cause")->insert($a);
            if ($res) {
                $b['status'] = 3;
                db("group_user")->where("id", $data['groupuser_id'])->update($b);
                return json(array('code' => 200, 'msg' => "取消成功"));
            } else {
                return json(array('code' => 202, 'msg' => '取消失败'));
            }

        } else {
            $id = input("groupuser_id");
            $this->assign('groupuser_id', $id);
            return view();
        }

    }

    /**
     * 方法描述： 拍摄流程
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function shoot()
    {
        return view();
    }

    /**
     * 方法描述：预约团队
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function cameraman()
    {
        $camerArr = db('cameraman')->where('brandid', $this->brandId)->select();

        $this->assign('camerarr', $camerArr);
        return view();
    }

    /**
     * 方法描述：摄影师详情
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function cameramaninfo()
    {
        $id = input('id');
        $camerArr = db('cameraman')->where('id', $id)->find();

        $this->assign('camerarr', $camerArr);
        return view();
    }

    /**
     * 方法描述：拍摄档期
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function auction()
    {
        $erp = config('ext.app_config');  //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];  //调用url

        /*  $url = $addr.'/SXWebErpAppStaff/SX_SPPaiChengDayinfo?Token=^******^&vPcday=2018-07-14&Code=ZX002';
        $dataN = '';
        $response = requestERP($url,$dataN);
        echo "<pre>";
        print_r($response);
        echo "</pre>";die;
        //獲取訂單信息
        $time = date('Ymd');
        $order_url = $addr.'/SXWebErpAppStaff/SX_CXXPPaiChengCusInfo?Token=^******^&StartDate=20100101&EndDate='.$time.'&orderid=&pageIndex=0&pageSize=20&Code=ZX002';
        $order_dataN = '';
        $order_response = requestERP($order_url,$order_dataN);
        echo "<pre>";
        print_r($order_response);
        echo "</pre>";die;
        if($order_response['Code'] != 200){
            //return json(['code'=>202,'msg'=>'添加失败']);
        }
        $url = $addr.'/SXWebErpAppStaff/SX_AddSPPaiCheng?Token=^******^&pcday=2018-07-14&Code=ZX002';
        $data = [
                'Pcid'             =>'1404',
                'Orderid'          =>'SY18011800001',
                'Customerid'       =>'df78a459-21a5-4435-89f9-681b46996321',
                'Spid'             =>'3',
                'Select_order_name'=>'三亚旅拍',
                'Selectday'        =>'20180714',
                'SelectTime'       =>'1100',
                'Shop_code'        =>'ZX002',
                'Shop_name'        =>'沈阳时尚经典婚纱店',
                'Spremarks'        =>''
            ];
        $dataN = json_encode($data);
        $response = requestERP($url,$dataN);  //调用erp接口
        echo "<pre>";
        print_r($response);
        echo "</pre>";die;
        */
        $orderId = input('orderid');
        $shop_code = input("shop_code");
        $shop_name = input("shop_name");

        //按月 拍照排程
        $year_vpcday = input("vpcday");
        $time = date("Y-m-d");

        //$year_url  = $addr.'SXWebErpAppStaff/SX_PhotoPaiChengMonthinfo?Token=^******^&vPcday='.$year_vpcday.'&Code='.$shop_code;
        $year_url = $addr . '/SXWebErpAppStaff/SX_PhotoPaiChengMonthinfo?Token=^******^&vPcday=' . $time . '&Code=ZX002';
        $year_dataN = '';
        $year_response = requestERP($year_url, $year_dataN);  //调用erp接口
        if ($year_response['Code'] != 200) {
            //调取不成功待处理
            self::errorLog($year_url, $year_dataN);
        }
        foreach ($year_response['Data'] as $k => $v) {
            if (str_replace('/', '', strstr($v['pccount'], "/")) > strstr($v['pccount'], "/", true)) {
                $keyue[] = $year_response['Data'][$k];
            } else {
                $yiman[] = $year_response['Data'][$k];
            }
        }
        //去除日期中间的零（例：2018-07-02 => 2018-7-2）
        foreach ($keyue as $k => $v) {
            $day = str_replace('0', '', strstr(date('Y-m-d', strtotime($v['riqi'])), '-'));
            $year = strstr(date('Y-m-d', strtotime($v['riqi'])), '-', true);
            $keyue[$k]['riqi'] = $year . $day;
        }
        foreach ($yiman as $k => $v) {
            $day = str_replace('0', '', strstr(date('Y-m-d', strtotime($v['riqi'])), '-'));
            $year = strstr(date('Y-m-d', strtotime($v['riqi'])), '-', true);
            $yiman[$k]['riqi'] = date('Y-m-d', strtotime($v['riqi']));
        }
        $keyue = json_encode($keyue);
        $yiman = json_encode($yiman);

        $this->assign([
            'keyue' => $keyue,
            'yiman' => $yiman,
            'shop_code' => $shop_code,
            'orderid' => $orderId,
            'shop_name' => $shop_name
        ]);
        return view();
    }

    /**
     * 方法描述：拍照排程（按天取数据）
     */
    public function gettime()
    {

        $erp = config('ext.app_config');        //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];         //调用url

        $time = input('time');                  //时间
        $shop_code = input('shop_code');        //店面code

        //按天取数据接口
        //$day_url    = $addr.'/SXWebErpAppStaff/SX_PhotoPaiChengDayinfo?Token=^******^&vPcday='.$time.'&Code='.$shop_code;
        $day_url = $addr . '/SXWebErpAppStaff/SX_PhotoPaiChengDayinfo?Token=^******^&vPcday=' . $time . '&Code=ZX002';
        $day_dataN = '';
        $day_response = requestERP($day_url, $day_dataN);  //调用erp接口
        if ($day_response['Code'] != 200) {
            return json(['code' => 202, 'msg' => '获取失败']);
        }
        $dayData = $day_response['Data'];
        $data = '';
        $arrayData = array();
        foreach ($dayData as $k => $v) {
            if ($v['pctime'] != $data) {
                $arrayData[$k]['pctime'] = substr_replace($v['pctime'], ':', 2, 0);
                $arrayData[$k]['pcid'] = $v['pcid'];
            }
            $data = $v['pctime'];
        }
        $i = 0;
        foreach ($arrayData as $k => $v) {
            $array_data[$i] = $arrayData[$k];
            $i++;
        }
        return json(['code' => '200', 'msg' => '获取成功', 'data' => $array_data]);
    }

    /**
     * 方法描述：新增拍照排程
     */
    public function setphoto()
    {

        $erp = config('ext.app_config');        //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];         //调用url

        $orderid = input("orderid");
        $Customerid = input("customerid");
        $photodate = input("year");
        $phototime = input("phototime");
        $shop_code = input("shop_code");
        $shop_name = input("shop_name");
        $pcid = input("pcid");

        //获取拍照类型设定
        //$photo_url    = $addr.'/SXWebErpAppStaff/SX_PhotoTypeSet?Token=^******^&Code=ZX002';
        $photo_url = $addr . '/SXWebErpAppStaff/SX_PhotoTypeSet?Token=^******^&Code=' . $shop_code;
        $photo_dataN = '';
        $photo_response = requestERP($photo_url, $photo_dataN);

        if ($photo_response['Code'] != 200) {
            return json(['code' => 202, 'msg' => '添加失败']);
        }
        foreach ($photo_response['Data'] as $k => $v) {
            if ($v['phototype'] == '拍照') {
                $photoid = $v['id'];
                $phototype = $v['phototype'];
            }
        }

        //獲取訂單信息
        $time = date('Ymd');
        $order_url = $addr . '/SXWebErpAppStaff/SX_CXPhotoPaiChengCusInfo?Token=^******^&StartDate=20100101&EndDate=' . $time . '&orderid=' . $orderid . '&pageIndex=0&pageSize=20&Code=' . $shop_code;
        //$order_url = $addr.'/SXWebErpAppStaff/SX_CXPhotoPaiChengCusInfo?Token=^******^&StartDate=20100101&EndDate='.$time.'&orderid=18335917124&pageIndex=0&pageSize=20&Code=ZX002';
        $order_dataN = '';
        $order_response = requestERP($order_url, $order_dataN);
        if ($order_response['Code'] != 200) {
            return json(['code' => 202, 'msg' => '添加失败']);
        }
        $customerid = $order_response['Data'][0]['customerid'];

        //新增排程接口
        //$url = $addr.'/SXWebErpAppStaff/SX_AddPhotoPaiCheng?Token=^******^&pcday=2018-07-14&Code=ZX002';
        $url = $addr . '/SXWebErpAppStaff/SX_AddPhotoPaiCheng?Token=^******^&pcday=' . $photodate . '&Code=' . $shop_code;

        $photodate = str_replace('-', '', $photodate);
        $phototime = str_replace(':', '', $phototime);

        $data = [
            'Orderid' => $orderid,
            'Customerid' => $customerid,
            'Phototype' => $phototype,
            'Photodate' => $photodate,
            'Phototime' => $phototime,
            'Shop_code' => $shop_code,
            'Shop_name' => $shop_name,
            'Ordernote' => '',
            'Photoid' => $photoid,
            'Pcid' => $pcid
        ];
        $dataN = json_encode($data);
        $response = requestERP($url, $dataN);  //调用erp接口
        if ($response['Code'] != 200) {
            return json(['code' => 202, 'msg' => '添加失败']);
        } else {
            return json(['code' => 200, 'msg' => '添加成功']);
        }
    }

    /**
     * 方法描述：选片排程
     */
    public function xuanpian()
    {
        $erp = config('ext.app_config');        //读取erp配置文件
        $addr = $erp['sx_erp']['addr'];         //调用url
        $action = input('action');              //动作标识
        $shop_code = input('shop_code');
        if ($action == 'moth') {                  //选片排程（按月取数据）
            $time = date('Y-m-d');
            $order_url = $addr . '/SXWebErpAppStaff/SX_SPPaiChengMonthinfo?Token=^******^&vPcday=' . $time . '&Code=' . $shop_code;
            //$order_url = $addr.'/SXWebErpAppStaff/SX_SPPaiChengMonthinfo?Token=^******^&vPcday='.$time.'&Code=ZX002';
            $order_dataN = '';
            $order_response = requestERP($order_url, $order_dataN);
            if ($order_response['Code'] != 200) {
                //调取不成功待处理
                return json(['code' => 202, 'msg' => '获取失败']);
            }
            foreach ($order_response['Data'] as $k => $v) {
                if (str_replace('/', '', strstr($v['pccount'], "/")) > strstr($v['pccount'], "/", true)) {
                    $keyue[] = $order_response['Data'][$k];
                } else {
                    $yiman[] = $order_response['Data'][$k];
                }
            }
            //去除日期中间的零（例：2018-07-02 => 2018-7-2）
            foreach ($keyue as $k => $v) {
                $day = str_replace('0', '', strstr(date('Y-m-d', strtotime($v['riqi'])), '-'));
                $year = strstr(date('Y-m-d', strtotime($v['riqi'])), '-', true);
                $keyue[$k]['riqi'] = $year . $day;
            }
            foreach ($yiman as $k => $v) {
                $day = str_replace('0', '', strstr(date('Y-m-d', strtotime($v['riqi'])), '-'));
                $year = strstr(date('Y-m-d', strtotime($v['riqi'])), '-', true);
                $yiman[$k]['riqi'] = date('Y-m-d', strtotime($v['riqi']));
            }
            return json(['code' => 200, 'msg' => '获取成功', 'keyuedata' => $keyue, 'yimandata' => $yiman]);
        } else if ($action == 'day') {     //选片排程（按天取数据）
            $time = input("time");
            $url = $addr . '/SXWebErpAppStaff/SX_PhotoPaiChengDayinfo?Token=^******^&vPcday=' . $time . '&Code=' . $shop_code;
            //$url = $addr.'/SXWebErpAppStaff/SX_SPPaiChengDayinfo?Token=^******^&vPcday='.$time.'&Code=ZX002';
            $dataN = '';
            $response = requestERP($url, $dataN);
            if ($response['Code'] != 200) {
                return json(['code' => 202, 'msg' => '获取失败']);
            }
            $dayData = $response['Data'];
            $data = '';
            $arrayData = array();
            foreach ($dayData as $k => $v) {
                if ($v['pctime'] != $data) {
                    $arrayData[$k]['pctime'] = substr_replace($v['pctime'], ':', 2, 0);
                    $arrayData[$k]['pcid'] = $v['pcid'];
                }
                $data = $v['pctime'];
            }
            $i = 0;
            foreach ($arrayData as $k => $v) {
                $array_data[$i] = $arrayData[$k];
                $i++;
            }
            return json(['code' => 200, 'msg' => '获取成功', 'data' => $array_data]);
        } else if ($action == 'add') {   //新增选片排程
            //获取拍照类型设定
            $photo_url = $addr . '/SXWebErpAppStaff/SX_SelectTypeSet?Token=^******^&Code=' . $shop_code;
            //$photo_url    = $addr.'/SXWebErpAppStaff/SX_SelectTypeSet?Token=^******^&Code=ZX002';
            $photo_dataN = '';
            $photo_response = requestERP($photo_url, $photo_dataN);

            if ($photo_response['Code'] != 200) {
                return json(['code' => 202, 'msg' => '添加失败']);
            }
            foreach ($photo_response['Data'] as $k => $v) {
                if ($v['phototype'] == '三亚旅拍') {
                    $photoid = $v['id'];
                    $phototype = $v['selectordername'];
                }
            }

            $orderid = input("orderid");
            $photodate = input("year");
            $phototime = input("phototime");
            $shop_code = input("shop_code");
            $shop_name = input("shop_name");
            $pcid = input("pcid");
            //獲取訂單信息
            $time = date('Ymd');
            $order_url = $addr . '/SXWebErpAppStaff/SX_CXXPPaiChengCusInfo?Token=^******^&StartDate=2010-01-01&EndDate=' . $time . '&orderid=' . $orderid . '&pageIndex=0&pageSize=20&Code=' . $shop_code;
            //$order_url   = $addr.'/SXWebErpAppStaff/SX_CXXPPaiChengCusInfo?Token=^******^&StartDate=2010-01-01&EndDate='.$time.'&orderid=&pageIndex=0&pageSize=20&Code=ZX002';
            $order_dataN = '';
            $order_response = requestERP($order_url, $order_dataN);
            if ($order_response['Code'] != 200) {
                return json(['code' => 202, 'msg' => '添加失败']);
            }
            $customerid = $order_response['Data'][0]['customerid'];
            $spid = $order_response['Data'][0]['id'];
            $select_order_name = $order_response['Data'][0]['select_order_name'];
            //新增选片排程接口
            //$url = $addr.'/SXWebErpAppStaff/SX_AddPhotoPaiCheng?Token=^******^&pcday=2018-07-14&Code=ZX002';
            $url = $addr . '/SXWebErpAppStaff/SX_AddPhotoPaiCheng?Token=^******^&pcday=$photodate&Code=' . $shop_code;

            $photodate = str_replace('-', '', $photodate);
            $phototime = str_replace(':', '', $phototime);
            return json(['code' => $photodate . '---' . $phototime]);
            $data = [
                'Pcid' => $pcid,
                'Orderid' => $orderid,
                'Customerid' => $customerid,
                'Spid' => $spid,
                'Select_order_name' => $select_order_name,
                'Selectday' => $photodate,
                'SelectTime' => $phototime,
                'Shop_code' => $shop_code,
                'Shop_name' => $shop_name,
                'Spremarks' => ''
            ];
            $dataN = json_encode($data);
            $response = requestERP($url, $dataN);  //调用erp接口
            if ($response['Code'] != 200) {
                return json(['code' => 202, 'msg' => '添加失败']);
            } else {
                return json(['code' => 200, 'msg' => '添加成功']);
            }
        }
    }

    /**
     * 方法描述：取件
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function qujian()
    {

        return view();
    }

    /**
     * 方法描述：问卷
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function wenjuan()
    {

        return view();
    }

    /**
     * 方法描述：资料
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    public function info()
    {

        return view();
    }

    /**
     * 方法描述:事业部商品列表
     */
    public function goods_brandlist()
    {
        $shopUrl = Session::get('shop_url');
        $appConfig = config('ext.app_config');
        $addr = $appConfig[strtolower("sx_vipshop")]['addr'];  //从接口获取路径
        $shop_url = $shopUrl ? $shopUrl : $addr;

        if (request()->isAjax()) {
            $cateid = input('cateid');
            $sql = 'select * from tp_goods where ( brand_data_id =0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id)) and cat_id = ' . $cateid .' order by sort desc';
            $goodsArr = Db::connect('db_shop')->query($sql);
            if ($goodsArr) {
                return json(['code' => 200, 'msg' => '查询成功', 'data' => $goodsArr, 'shopurl' => $shop_url]);
            }
            return json(['code' => 202, 'msg' => '没有数据']);
        }
        $conf_brandid = db_config('sx_brand');
        $id = input('id');      //分类主键id
        $indexArr = db('s_index')->where('id', $id)->find();
        //类别主键id
        $cate_id = $indexArr['cateid']; 

        //品牌分类(跨库查询)
        if (Session::get('brand_id') == $conf_brandid) {      //判断当前会员是否为集团会员
            $brandcateArr = Db::connect('db_shop')->query('select * from tp_goods_category where is_show=1 and is_brand = 1 and parent_id='.$cate_id);
        }
        //不是集团会员的情况
        $where = ' and is_on_sale = 1';
        if (empty($brandcateArr)) {
            $view = "goods_brandlist_s";
            if (!empty($cate_id)) {
                $where .= " and cat_id = " . $cate_id;
            }
            $goods_Arr = Db::connect('db_shop')->query('select * from tp_goods where ( brand_data_id =0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id))  ' . $where . ' order by sort desc');
        } else {   //是集团会员的情况
            $view = "goods_brandlist";
            $goods_Arr = Db::connect('db_shop')->query('select * from tp_goods where ( brand_data_id =0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id)) and cat_id = '.$brandcateArr[0]['id'] . $where.' order by sort desc'); //.$brandcateArr[0]['id'])
        }
        //广告位
        $adv = controller('index', 'lib')->getAdv(20);     //首页广告位待处理
        //客服url
        $kf_url = controller('index', 'lib')->getKf('url');   //客服信息
        $this->assign('title', $indexArr['name']);
        $this->assign('kf_url', $kf_url);
        $this->assign('adv', $adv);
        $this->assign('goodsarr', $goods_Arr);
        $this->assign('shopurl', $shop_url);
        $this->assign('brandcatearr', $brandcateArr);
        return view($view);
    }

    /**
     * 方法描述：首页搜索页
     * @return [type] [description]
     */
    public function sousuo()
    {
        $brandId = Session::get("brand_id");
        //热门城市
        $data = [
            'brand_id' => $brandId,
            'is_show' => 1,
        ];
        $hot_searchArr = db('mc_hot_search')
            ->where($data)
            ->order('sort DESC')
            ->limit(6)
            ->select();
        //历史搜索
        $where = [
            'userid' => Session::get('memid'),
            'brandid' => $brandId,
        ];

        $historyArr = db("s_history")->where($where)->order('create_time desc')->limit(10)->select();

        $this->assign('hot_searcharr', $hot_searchArr);
        $this->assign('historyarr', $historyArr);
        return view();
    }

    /**
     * 方法描述：搜索结果展示页
     * @return [type] [description]
     */
    public function sousuolist()
    {
        $shopUrl = Session::get('shop_url');
        $appConfig = config('ext.app_config');
        $addr = $appConfig[strtolower("sx_vipshop")]['addr'];  //从接口获取路径
        $shop_url = $shopUrl ? $shopUrl : $addr;
        if (request()->isAjax()) {
            $page = input('page'); //当前页
            $limit = input('limit');//分页数
            $limit = $limit ? $limit : 10;
            $page = $page ? $page * $limit : 0;
            $goods_name = input("goods_name");//关键字
            $top = input("top");//最高价
            $end = input("end");//最低价

            $where = "";
            if (!empty($top)) {
                $where = " and shop_price >= " . $top;
            }
            if (!empty($end)) {
                $where .= " and shop_price <= " . $end;
            }

            //查询数据
            $a = 'select * from tp_goods where ( brand_data_id = 0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id)) and goods_name like "%' . $goods_name . '%" ' . $where . ' limit ' . $page . ',' . $limit;
            $goods_Arr = Db::connect('db_shop')->query($a);
            //return json(['code'=>200,'data'=>$a]);
            //数据总数
            $goods_count = Db::connect('db_shop')->query('select count(*) from tp_goods where ( brand_data_id = 0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id)) and goods_name like "%' . $goods_name . '%" ' . $where);
            //总页数
            $pagecount = ceil($goods_count[0]['count(*)'] / $limit);
            if ($goods_Arr) {
                return json(['code' => 200, 'msg' => '查询成功', 'data' => $goods_Arr, 'pagecount' => $pagecount, 'shopurl' => $shop_url]);
            } else {
                return json(['code' => 202, 'msg' => '查询失败']);
            }
        }
        $goods_name = input('goods_name', 0, 'trim');
        $top = input('top', '', 'trim');
        $end = input('end', '', 'trim');
        //$goods_name = 's';
        $isgoods = db('s_history')->where('title', $goods_name)->find();
        if (empty($isgoods) && !empty($goods_name)) {
            //添加用户搜索记录
            $data = [
                'title' => $goods_name,
                'userid' => Session::get('memid'),
                'username' => Session::get('username'),
                'brandid' => Session::get('brand_id'),
                'create_time' => date('Y-m-d H:i:s', time())
            ];
            $historyUser = db('s_history')->insert($data);
        }

        $res = $this->getData($goods_name, $top , $end );
        $this->assign('pagecount', $res['data']['count']);
        $this->assign('goods_name', $goods_name);
        $this->assign('top', $top);
        $this->assign('end', $end);
        $this->assign('shopurl', $shop_url);
        $this->assign('goods_arr', $res['data']['data']);
        return view();
    }

    /**
     * 查询商品
     * @param $goods_name
     * @param int $top
     * @param int $end
     * @return array
     * @throws \Exception
     * @throws \think\exception\PDOException
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function getData($goods_name, $top = '', $end = '')
    {
        $resultData = [
            'code' => 0,
            'msg' => '',
            'data' => '',
        ];
        $top = is_numeric($top) ? $top : 0;
        $end = is_numeric($end) ? $end : 0;

        $sql = 'select * from tp_goods where ( brand_data_id = 0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id)) and goods_name like "%' . $goods_name . '%" ';
        $sqlCount = 'select count(*) from tp_goods where ( brand_data_id = 0 or FIND_IN_SET(' . Session::get('brand_id') . ',brand_data_id)) and goods_name like "%' . $goods_name . '%"';
        if ($top > 0 && $end == 0) {
            $sql .= ' AND shop_price > ' . $top;
            $sqlCount .= '';
        } elseif ($top == 0 && $end > 0) {
            $sql .= ' AND shop_price < ' . $end;
            $sqlCount .= '';
        } elseif ($top > 0 && $end > 0) {
            $sql .= ' AND shop_price BETWEEN ' . $top . ' AND ' . $end ;
            $sqlCount .= '';
        }
        $sql .= '  limit 0,10';

        $resultData['data']['data'] = Db::connect('db_shop')->query($sql);
        $goods_count = Db::connect('db_shop')->query($sqlCount);
        $resultData['data']['count'] = ceil($goods_count[0]['count(*)'] / 10);

        return $resultData;
    }

    public function share_ceshi(){

        echo "<pre>";
        print_r(input());
        echo "</pre>";die;

        return $this->fetch();
    }

    /**
     * 方法描述: 聚焦首页，结婚圈  轮播图 + 话题列表  from function index
     * @return view
     * @author lilong
     */
    public function jjIndex(){
        // 轮播图
        $adv = controller('index', 'lib')->getAdv(21);
        $this->assign('adv', $adv);
        // 话题列表
        $columnList = controller('vip/McColumn', 'model')->getLimit(session('brand_id'), 0, 50);
        $this->assign('columnList', $columnList);
        // var_dump($columnList);
        // exit;
        return $this->fetch('jj_index');
    }

    /**
     * 方法描述: 聚焦第二页，最新活动（帖子列表） 帖子列表  
     * @param  htid   话题id
     * @return view
     * @author lilong
     */
    public function jjNewAct(){
        // var_dump($param);
        $htid = (int)input('get.htid');
        if (!$htid) {
            $where = [
                'brand_id'=> Session::get('brand_id'),
                'is_del'  => 1,
            ];
            $htinfo = db('mc_column')->where($where)->order('mc_sort desc, id asc')->find();
            $htid = $htinfo['id'];
        }else{
            $htinfo = db('mc_column')->where('id', $htid)->find();
        }
        $this->assign('htinfo', $htinfo);
        $where = [
            'brand_id'=> Session::get('brand_id'),
            'is_del'  => 1,
            'cid'     => $htid,
        ];
        $temp = db('mc_topic')->where($where)->order('is_top desc, mc_sort desc, id desc')->select();
        $topicList = [];
        $match = [];
        foreach ($temp as $key => $value) {
        	$topicList[$key]['id']    = $value['id'];
            $topicList[$key]['title'] = base64_decode($value['title']);
            $topicList[$key]['time']  = date('Y-m-d', $value['create_time']);
            $topicList[$key]['is_top']= $value['is_top'];
            $content = base64_decode($value['content']);
            $pattern_src = '/<img[\s\S]*?src\s*=\s*[\"|\'](.*?)[\"|\'][\s\S]*?>/';
            preg_match_all($pattern_src,$content,$matchAll);

            if (count($matchAll[1])>=3) {
                $topicList[$key]['type'] = 3;
                $topicList[$key]['imgs'] = $matchAll[1];
            }else{
                $topicList[$key]['type']  = 1;
                $topicList[$key]['imgs'] = $matchAll[1][0];
            }
        }
        // var_dump($topicList);
        // exit;
        $this->assign('topicList', $topicList);
        return $this->fetch('jj_newact');
    }
    /**
     * 方法描述: 聚焦第二页 --- 内页， 帖子详情
     * @param  id   帖子id
     * @return view
     * @author lilong
     */
    public function jjNewActDetail(){
    	$id = (int)input('get.id');
    	if (!$id) {
            $return = [
                'code'=>100,
                'msg' =>'帖子id为空，操作失败',
            ];
        }
        $info = db('mc_topic')->where('id', $id)->where('is_del', 1)->find();
        if (!$info) {
            $return = [
                'code'=>101,
                'msg' =>'帖子不存在，操作失败',
            ];
        }
        $this->assign('info', $info);
        return $this->fetch('jj_newactdetail');
    }

    /**
     * 方法描述: 聚焦第三页，积分商城  
     * @return view
     * @author lilong
     */
    public function jjShop(){
        $brandId = Session::get('brand_id');
        // 会员信息
        $userInfo = getUserInfo(['userid' => $this->userId]);
        $percentageBig = db('user_level')->max('max_value');  //三个等级中最大的成长值
        $percentageSmall = db('user_level')->min('max_value');//三个等级中最小的成长值
        //会员等级
        $gradeName = db('user_level')->field('name,min_value,max_value')->select();  //查询等级表
        foreach ($gradeName as $v) {
            if ($v['max_value'] > $percentageSmall && $v['max_value'] < $percentageBig) $gradeValue = $v['max_value'];
        }
        //当前用户的成长值
        $percentageCenter = $userInfo['growth_value'];
        if ($percentageCenter >= $percentageBig) {
            $badResult = "zuanshi";
        } elseif ($percentageCenter >= $gradeValue) {
            $badResult = "baijin";
        } else {
            $badResult = "guibin";
        }
        $this->assign('userInfo', $userInfo);
        $this->assign('badResult', $badResult);

        // 爆品商品 ( 聚焦 种草好物 )
        $hotShopData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id,exchange_integral from tp_goods where is_burft=1 and is_on_sale = 1 and ( brand_data_id =0 or FIND_IN_SET(' . $brandId . ',brand_data_id)) limit 36');  //跨库查询
        if (empty($hotShopData)) {
            $hotShopData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id from tp_goods where brand_data_id =0 or FIND_IN_SET(' . $brandId . ',brand_data_id) order by sales_sum  limit 36');  //跨库查询
        }
        $this->assign('hotShopData', $hotShopData);

        // 广告信息
        $adv = controller('index', 'lib')->getAdv(11);
        $this->assign('jfadv',$adv);

        // 客服信息
        $kf = db('c_kf')->where('brandid', Session::get('brand_id'))->find();
        $this->assign('kf',$kf);

        // 商城地址
        $shopUrl = Session::get('shop_url');
        $this->assign('shopUrl', $shopUrl);

        return $this->fetch('jj_shop');
    }

    /**
     * 方法描述: 聚焦第四页，个人中心
     * @return view
     * @author lilong
     */
    public function jjPersonal(){
        $brandId = Session::get('brand_id');
        // 会员信息
        $userInfo = getUserInfo(['userid' => $this->userId]);

         // 爆品商品 ( 聚焦 种草好物 )
        $hotShopData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id,exchange_integral from tp_goods where is_burft=1 and is_on_sale = 1 and ( brand_data_id =0 or FIND_IN_SET(' . $brandId . ',brand_data_id)) limit 36');  //跨库查询
        if (empty($hotShopData)) {
            $hotShopData = Db::connect('db_shop')->query('select sales_sum,original_img,goods_name,shop_price,goods_id from tp_goods where brand_data_id =0 or FIND_IN_SET(' . $brandId . ',brand_data_id) order by sales_sum  limit 36');  //跨库查询
        }
        $this->assign('hotShopData', $hotShopData);

        // 客服信息
        $kf = db('c_kf')->where('brandid', Session::get('brand_id'))->find();
        $this->assign('kf',$kf);

        // 商城地址
        $shopUrl = Session::get('shop_url');
        $this->assign('shopUrl', $shopUrl);

        return $this->fetch('jj_personal');
    }

    //发送短信
    public function setdx(){
        $kr_phone = input('phone');
        $id = input('id');
        $kr_send = db('c_sysconfig')->where('ckey',KR_SEND)->value('cvalue');

        preg_match("/(?:\{)(.*)(?:\})/i",$kr_send,$name);
        preg_match("/(?:\[)(.*)(?:\])/i",$kr_send,$cancel);
        
        $data['userid'] = session('memid');
        $data['activityid'] = $id;
        $signData = controller('activity','lib')->GetActivitySignUp($data);

        $kr_send = str_replace($name[0],$signData['b_username'],$kr_send);
        $kr_send = str_replace($cancel[0],$signData['cancel'],$kr_send);

        //客人短信
        set_send($kr_phone,$kr_send,$signData['b_username'],"客人");

        $kf_send = db('c_sysconfig')->where('ckey',KF_SEND)->value('cvalue');
        $kf_phone = controller('index', 'lib')->getKf('phone');   //客服手机号

        preg_match("/(?:\{)(.*)(?:\})/i",$kf_send, $username);
        preg_match("/(?:\[)(.*)(?:\])/i",$kf_send, $phone);

        $kf_send = str_replace($username[0],$signData['b_username'],$kf_send);
        $kf_send = str_replace($phone[0],$signData['b_phone'],$kf_send);

        //客服短信
        set_send($kf_phone,$kf_send,$signData['b_username'],"客服");

        $this->Redirect("index/activitydetail",['id'=>$id,'_share_userid'=>session('memid')]);
    }

    //生成二维码
    public function qr_code(){
        $content = input('content');
        $qrcode  = qrcode($content);
        header("Content-type: image/jpeg");
        echo $qrcode;
    }
    public function qr_codes($content){
        // $content = input('content');
        qrcode($content);
    }

    /*
     * 活动分享生成初始码
     * @return [type] [description]
     */
    public function activity_setqr(){
        $staffname = input("name");
        $action    = input("action");
        $id        = input("id");
        if(!$id || !$staffname || !$action){
            return json(['code'=>202,'msg'=>'必传参不能为空']);
        }
        $sharedata = controller('activity','lib')->GetShareQrData(['activityid'=>$id,'userid'=>session('memid')]);
        if($sharedata){
            return json(['code'=>202,'msg'=>'该活动您已生成二维码']);
        }
        $sharedatastaff = controller('activity','lib')->GetShareQrData(['staff_name'=>$staffname,'activityid'=>$id]);
        if($sharedatastaff){
            return json(['code'=>202,'msg'=>'该员工已生成此活动二维码']);
        }
        if($action == 'staff'){
            $staffdata = [
                    'staffname'=>$staffname,
                ];
            $staffArr = sx_call('5a01766b4a3dd',$staffdata,'sx_mc');
            if($staffArr['code'] == 200){
                $data['staff_id']   = $staffArr['data'][0]['id'];
                $data['staff_name'] = $staffArr['data'][0]['staffname'];
            }else{
                payment_log('活动初始码 员工接口调用失败',"员工姓名:".$staffname);
                //$data['staff_id'] = 0;
                //$data['staff_name'] = $staffname;
                return json(['code'=>202,'msg'=>'该用户名不是员工']);
            }
            $data['is_staff'] = 1;
        }else{
            $data['staff_id'] = 0;
            $data['staff_name'] = $staffname;
            $data['is_staff'] = 2;
        }
        $data['activityid'] = $id;
        $data['userid']     = $this->userId;
        $data['create_time']= date("Y-m-d H:i:s",time());
        $data['brandid']    = $this->brandId; 
        $res = controller('activity','lib')->AddShareQrData($data);
        if($res){
            return json(['code'=>200,'msg'=>'添加成功','data'=>$res]);
        }else{
            return json(['code'=>202,'msg'=>'添加失败']);
        }
    }


    //客服页面
    public function kfView(){

        $kfUrl = controller('Udesk')->udeskIM($this->userId,'微信菜单');
        $this->assign('kf_url',$kfUrl);
        return $this->fetch();
    }

    //赠送优惠券
    public function givecoupon(){
        $phone = input('phone');
        $couponid = input('couponid'); //应是c_coupon_list表主键id
        $num_id = input('num_id');//优惠券批次c_coupon_num表主键id
        
        if(!$phone){
            return json(['code'=>202,'msg'=>'请输入手机号！']);
        }
        //$coupondata = db("c_coupon_list")->where('share_phone',$phone)->where('coupon_num_id',$couponid)->where('share_userid',session('memid'))->find();
        $coupondata = db("c_coupon_list")->where('share_phone',$phone)->where('id',$couponid)->where('share_userid',session('memid'))->find();
        if($coupondata){
            return json(['code'=>202,'msg'=>'您已赠送过该用户该优惠券！']);
        }
        $phoneData = db("m_users")->where('phone',$phone)->find();

        //被赠送 用户是否存在
        if($phoneData){
            $userid = $phoneData['id'];
            $status = 4;
            $share_phone = "";
            $msg = ['code'=>200,'msg'=>'赠送优惠券成功'];
        }else{
            $userid = "";
            $status = 5;
            $share_phone = $phone;
            $msg = ['code'=>205,'msg'=>'扫描二维码！'];
        }
        $c = [
            'userid'     => $userid,
            'coupon_num' => $num_id,
            'status'     => $status,//分享待领取优惠券
            'share_phone'=> $share_phone,
            'share_userid'=>session('memid'),
        ];
        db()->startTrans();
        try{
            if($c['coupon_num']){
                $d = controller('index', 'lib')->getReceive($c);
                if(!$d && json_decode($d,true)['status'] != 1){
                    db()->rollback();
                    return json(['code'=>202,'msg'=>json_decode($d,true)['msg']]);
                }
                $res = db('c_coupon_list')->where('userid',session('memid'))->where('id',$couponid)->update(['status'=>3]);
                if(!$res){
                    db()->rollback();
                    return json(['code'=>202,'msg'=>'赠送优惠券失败了！']);
                }
                db()->commit();
                return json($msg);
            }
        }
        catch(\Exception $e){
            db()->rollback();
            return json(['code'=>202,'msg'=>'赠送优惠券失败，请重试！']);
        }
    }
    /*
     * 拍摄需知
     * @return [type] [description]
     */
    public function photonotice(){
        $data = db('p_photo_notice')->where('brandid',$this->brandId)->limit(4)->order("sort DESC")->select();
        
        $this->assign('data',$data);

        return view();
    }

    /*
     * 绑定erp储值卡
     */
    public function erpVipCard(){

        if(request()->isAjax()){

            $erp_vipcard = input('erp_vipcard');
            $cardpwd = input('cardpwd');

            $erpCardInfo = db('c_vipcardinfo','db_erp')->where(['cardid'=>$erp_vipcard])->find();

            if(!$erpCardInfo){
                return ['code'=>204,'msg'=>'此卡号不存在！'];
            }

            if($erpCardInfo['cardpwd'] != $cardpwd){
                return ['code'=>204,'msg'=>'密码填写有误！'];
            }

            $userInfo = db('m_users')->where('id',$this->userId)->find();

            $upRes = db('m_users')->where('id',$this->userId)->update(['erp_vipcard'=>$erp_vipcard]);

            if($upRes !== false){

                $res = db('c_vipcardinfo','db_erp')->where(['cardid'=>$erp_vipcard])->update(['handset'=>$userInfo['phone']]);
                if($res !== false){
                    return ['code'=>200,'msg'=>'绑定成功！'];
                }else{
                    return ['code'=>204,'msg'=>'绑定失败！'];
                }
            }else{
                return ['code'=>204,'msg'=>'绑定失败！'];
            }

        }else{

            return $this->fetch();
        }
    }
    public function getMyAddress(){
        $lat = input('lat');
        $lang = input('lang');
        if($lat && $lang){
            $this->assign(['lat'=>$lat,'lang'=>$lang]);
        }
        return $this->fetch();
    }
}