<?php
/**
 * 用户控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Yanlipeng<yanlipeng@suxuantech.cn> 2017-11-14 $
 */
namespace app\front\controller;
use app\vip\controller\User;
use app\front\model\Mem;
use think\image\Exception;
use think\Session;
use think\Controller;
class Member extends  Controller {
    /**
     * 用户注册页面
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function regist () {
        $mobileCaptcha = input('post.mobileCaptcha');
        $brithday = trim(str_replace('-','',request()->post('brithday')));
        preg_match('/^[12]0[0-9]{2}[01][12][0-3][0-9]$/', $brithday, $brithday);
        if (!$brithday) {
            $arrar = array('code'=>5,'msg'=>'生日格式不正确');
            return json($arrar);
        }
        $sessionCaptcha = Session::get('capt');
        if ($mobileCaptcha != $sessionCaptcha) {
            $arrar = array('code'=>3,'msg'=>'手机验证码错误');
            return json($arrar);
        }
        $tel     = request()->post('phone');
        $brandid = Session::get('brand_id');
        $userid  = Session::get('memid');
        if (!$tel || strlen($tel) != 11 ) {
            $arrar = array('code'=>6,'msg'=>'手机号长度不足,请填写真确的手机号');
            return json($arrar);
        }
        $mydata = [
            'sex'       => (int)request()->post('sex'),
            'brithday'  => $brithday,
            'username'  => request()->post('username'),
        ];
        // 处理注册
        $res = $this->bindPhone($userid, $brandid, $tel, $mydata);
        if($res['code'] == 200) {
            Session::set('mem_phone',$tel);
            $arrar = array('code'=>1,'msg'=>'用户注册成功','score'=>$res['reg_score']);
            return json($arrar);
        }else {
            $arrar = array('code'=>0,'msg'=>'用户注册失败'.$res['msg']);
            return json($arrar);
        }
    }
    /**
     * 用户推荐人信息添加
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function recommenAdd () {
        $userid = Session::get('memid');
        $reconmenPhone = input('post.r_phone');
        $reconmenName = input('post.r_username');
        $reconmenSex = input('post.sex');
        $phoneid =  Session::get('phoneid');
        if (empty($reconmenName) && empty($reconmenPhone)) {
            return json(array('code'=>4,'msg'=>'用户名手机不能为空'));
        }
        $recomData = db('recommend')->where(array('r_username'=>$reconmenName,'r_phone'=>$reconmenPhone))->find();  //查询该用户是否已被推荐
        if ($recomData) {
            $arr = array('code'=>3,'msg'=>'该用户已被推荐');
            return json($arr);
        }
        $data = array(
            'r_username' => $reconmenName,
            'r_phone' => $reconmenPhone,
            'r_sex' => $reconmenSex,
            'create_time' => date('Y-m-d,H:i:s',time()),
            'userid' => $userid,
            'status' => 3,
            'brandid' => Session::get('brand_id'),
            'iswid'   => $phoneid?0:1,
        );
        $res = db('recommend')->insert($data);
        if ($res) {
            $result = growthMemRecord($userid,5,'');
            if ($result) {
                $gro = getGrowthRule(['userid'=>$userid]);
                if($gro && $gro['recommend']){
                    growthDetailed($userid,$gro['recommend'],5,'',$phoneid);
                }
            }
            $arr = array('code'=>1,'msg'=>'推荐成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'推荐成功');
            return json($arr);
        }
    }
    /**
     * 用户领取
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function taskDraw () {

        $taskId = input('post.taskId');
        $userId = Session::get('memid');
        $phoneid = Session::get('phoneid');
        $res = db('t_task_user_list')->where('userid','=',$userId)->where('taskid','=',$taskId)->find();
        if ($res) {
            $arr = array('code'=>2,'msg'=>'您已领取过此任务');
            return json($arr);
        }
        $taskUserData = array(
            'userid' => $userId,
            'taskid' => $taskId,
            'status' => 0,
            'create_time' => date('Y-m-d,H:i:s',time()),
            'done_total'=> 0,
            'iswid'   => $phoneid?0:1,
        );
        $result = db('t_task_user_list')->insert($taskUserData);
        if ($result) {
            $result = growthMemRecord($userId,3,$taskId);
            if (!$result) {
                $gro = getGrowthRule(['userid'=>$userId]);
                if($gro && $gro['receive_task']){
                    growthDetailed($userId,$gro['receive_task'],3,$taskId,$phoneid);
                }
            }
            $res = \db('t_task_list')->where('id','=',$taskId)->setInc('receive_total',1);
            $arr = array('code'=>1,'msg'=>'领取成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'领取失败');
            return json($arr);
        }
    }
    /**
     * 用户做任務
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function doTask () {
        $taskId = input('post.taskId');
        $userId = Session::get('memid');
        $phoneid = Session::get('phoneid');
        $taskData = db('t_task_list')->where('id','=',$taskId)->find(); //查询任务表
        Session::set('days',$taskData['days']);
        $thisTime = date('Y-m-d');
        $where['userid'] = array('eq',$userId);
        $where['taskid'] = array('eq',$taskId);
        $where['create_time'] = array('like',"%$thisTime%");
        $res = db('t_task_detail')->where($where)->find(); //查询任务详情记录中有没有当天的记录
        if ($res) {
            $arr = array('code'=>0,'msg'=>'您今天已经做过任务了');
            return json($arr);
        }
        $exeData =array(
            'userid' => $userId,
            'taskid' => (int)$taskId,
            'status' => 1,
            'create_time' => date('Y-m-d,H:i:s',time())
        );
        db()->startTrans();
        try{
            $data = db('t_task_detail')->insert($exeData);  //记录执行数据
            $taskNum = (int)$taskData['reward_score'];
            if ($data) {
                $taskExeRecord = db('t_task_user_list')->where('userid','=',$userId)->where('taskid','=',$taskId)->find();  //加完之后查询一次对比周期天数
                $exeNum = $taskExeRecord['done_total'] +1;
                $result = db('t_task_user_list')->where(array('userid'=>$userId,'taskid'=>$taskId))->setInc('done_total',1); //执行成功之后给参与表字段完成次数+1
                if (!$taskExeRecord) {
                    $arrs = array('code'=>3,'msg'=>'查询天数不成功');
                    return json($arrs);
                }
                if ($exeNum == $taskData['days']) {
                    $resData = db('t_task_user_list')->where(array('userid'=>$userId,'taskid'=>$taskId))->update(['status'=>1,'t_task_integral'=>$taskNum,'update_time'=>date('Y-m-d H:i:s',time())]); //给参与表积分数据更改
                    /*$sum = Session::get('total_score');
                    Session::set('total_score',$taskNum+$sum);*/
                    
                    if($phoneid){
                        $tablename = 'm_users_phone';
                        $fieldname = 'userid';
                    }else{
                        $tablename = 'm_users';
                        $fieldname = 'id';
                    }
                    //$res = db($tablename)->where([$fieldname=>$userId])->setInc('total_score',$taskNum);
                    /*$result = growthMemRecord($userId,4,$taskId);
                    if (!$result) {
                        $gro = getGrowthRule(['userid'=>$userId]);
                        if($gro && $gro['do_task']){
                            growthDetailed($userId,$gro['do_task'],4,$taskId,$phoneid);
                        }
                    }
                    minuteDetailed('完成任务：'.$taskData['title'],$taskNum,$userId,'2',$phoneid);*/
                    if ($resData) {
                        $AddScore = AddScore($userId,$phoneid,$taskNum,'2','任务奖励');
                        if($AddScore === false){
                             db()->rollback();
                            $arrs = array('code'=>0,'msg'=>'失败');
                            return json($arrs);
                        }
                        db()->commit();
                        $arrs = array('code'=>1,'msg'=>'成功');
                        return json($arrs);
                    } else {
                        db()->rollback();
                        $arrs = array('code'=>0,'msg'=>'失败');
                        return json($arrs);
                    }
                }
                db()->commit();
                $arr = array('code'=>1,'msg'=>'初次執行任務成功');
                return json($arr);


            } else {
                db()->rollback();
                $arr = array('code'=>0,'msg'=>'初次執行任務失敗');
                return json($arr);
            }
        }
        catch(\Exception $e){
                db()->rollback();
                $array = array('code'=>0,'msg'=>'初次執行任務失敗');
                return json($array);
            }
    }
    /**
     * 发送手机验证码前先验证图片验证码,防止刷数据
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function ajaxCaptcha () {
        $captchaMobile = input('post.capt');
        if(!captcha_check($captchaMobile)){
            $array = array(
                'status' => 0,
                'msg' => '图片验证码错误'
            );
            return  json($array);
        } else {
            $array = array(
                'status' => 1,
                'msg' => '图片验证码通过'
            );
            return  json($array);
        }
    }
    /**
     * 发送手机验证码
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function ajaxMobileCode () {
        $phone = input('post.phone');
        $captcaCode = rand(1111,9999);
        Session::set('capt',$captcaCode);

        $smsId = db_config(SMS_TEMPLATE)?db_config(SMS_TEMPLATE):config('yzm_template_id');

        $param = [
            '_mobile' => $phone,
            '_template_id' => $smsId,
            '_brand_id'    => Session::get('brand_id'),
            'code'         => $captcaCode
        ];

        $verifyData = array(
            'phone' => $phone,
            'code' => $captcaCode,
            'craete_time' => date('Y-m-d H:i:s'),
        );
        $res = \db('verify_code')->insert($verifyData);

        $smsRes = sx_call('5d78e60eeb6a2',$param,'sx_mc');


        if($smsRes['code'] == 200){

            if ($res) {
                $arr = array('code' => 1,'msg' => '短信发送成功');
                return json($arr);
            } else {
                $arr = array('code' => 0,'msg' => '短信发送异常');
                return json($arr);
            }
        }else{
            $arr = array('code' => 0,'msg' => '短信发送异常');
            return json($arr);
        }

        /*
        $data = array(
            'mobile'=> $phone,
            'content' => "您的验证码是：".$captcaCode."，5分钟有效。",
        	'brand_id' => Session::get('brand_id'),
        );
        $phoneCode = sx_call('5a17b86088f1a',$data,'sx_mc');
        if ($phoneCode['code'] == 200) {
            $verifyData = array(
                'phone' => $phone,
                'code' => $captcaCode,
                'craete_time' => date('Y-m-d H:i:s'),
            );
            $res = \db('verify_code')->insert($verifyData);
            if ($res) {
                $arr = array('code' => 1,'msg' => '短信发送成功');
                return json($arr);
            } else {
                $arr = array('code' => 0,'msg' => '短信发送异常');
                return json($arr);
            }
        }
        */

    }
    /**
     * 用户预约拍照
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memMake () {
        $memid = Session::get('memid');
        $id = request()->post('shine');
        $w  = ['userid'=>$memid,'photo_type'=>$id];
        $memMakeData = \db('a_activity_sign_up')->where($w)->find();
        if ($memMakeData) {
            $arr = array('code'=> 2,'msg'=>'您已预约类型');
            return json($arr);
        }
        $postData = request()->post();
        $data = array(
            'userid'     => $memid,
            'b_username' => $postData['mem_name'],
            'b_phone'    => $postData['mem_tel'],
            'brandid'    => Session::get('brandid'),
            'shopid'     => $postData['shop'],
            'wename'     => $postData['wx_name'],
            'shop_name'  => $postData['shopName'],
            'photo_type' => $id,
            'create_time'=> date('Y-m-d H:i:s',time()),
            'b_say'      => htmlspecialchars($postData['sayother']),
            'status'     => 0,
            'b_type'     => 2,
        );
        $res = \db('a_activity_sign_up')->insert($data);
        if ($res) {
            $arr = array('code'=> 1,'msg'=>'预约成功');
            return json($arr);
        } else {
            $arr = array('code'=> 0,'msg'=>'预约失败');
            return json($arr);
        }
    }

    /**
     * 用户手机号绑定
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function bindMobile () {
        $tel = input('post.tel');
        $memid = Session::get('memid');
        $brandid = Session::get('brand_id');
        
        // 获取手机表的数据
        $usersPhoneModel = db('m_users_phone');
        $phoneInfo = $usersPhoneModel
        ->where(['phone'=>$tel,'brandid'=>$brandid])
        ->field('id,userid')
        ->find();
        if ($phoneInfo && $phoneInfo['userid']) {
            $arr = array('code'=> 0,'msg'=>'该手机号已被绑定');
            return json($arr);
        }
        return json(['code'=>1,'msg'=>'该手机号可以绑定']);
    }
    /**
     * 用户手机号绑定
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function memBind () {
        $tel       = input('post.tel');
        $captcha   = input('post.captcha');        //用户填写的验证码
        $affirm    = input('post.affirm');         //确认标识
        $real_name = input('post.real_name');
        $agent_type= input('post.agent_type');
        $action    = input('post.action');         //判断是否是 申请经纪人
        $memid     = Session::get('memid');
        $brandid   = Session::get('brand_id');
        $sessionCaptcha = Session::get('capt');   //正确的验证码

        // 当前品牌商城域名缓存
        $brandInfo = getSiteBrand();
        $shopUrl  = $brandInfo['mall_url'];
        $openid   = Session::get('openid');
        $shopOauthUrl = $shopUrl."/mobile/oauth/index?authcode=".think_encrypt($openid);
        if ($tel && $captcha && $captcha != $sessionCaptcha) {
            return json(['code'=>3,'msg'=>'手机验证码错误','data'=>['shopOauthUrl'=>$shopOauthUrl]]);
        }

        $phoneid = $tel?$tel: Session::get('mem_phone');
        if(!$phoneid){
            return json(['code'=>202,'msg'=>'请输入要绑定的手机号']);
        }

        //申请经纪人
        if($action == 'apply'){

            //是否需要审核经纪人
            $is_check=getRecommendRule($brandid,'is_check');

            if($is_check==1){
                $agent_status = 1;//审核中
            }else{
                $agent_status = 2;//审核通过
            }
        }

        if(!$tel){

            db()->startTrans();
            try{
                $agent = db('m_users')->where('id',session('memid'))->update([
                    'agent_status'=>$agent_status,
                    'agent_type'=>$agent_type,
                    'real_name'=>$real_name,
                    'apply_time'=>date('Y-m-d H:i:s',time()),
                ]);

                if($agent === false){
                    db()->rollback();
                    return json(['code'=>202,'msg'=>'申请经纪人失败']);
                }


                db()->commit();
                return json(['code'=>1,'msg'=>'申请经纪人提交成功','data'=>['shopOauthUrl'=>$shopOauthUrl,'is_check'=>$agent_status]]); 
            }
            catch(\Exception $e){
                
                db()->rollback();
                return json(['code'=>202,'msg'=>'申请经纪人失败'.$e->getMessage()]);
            }
        }else{

            //该手机是否已被绑定
            if(empty($affirm)){
                $userArr = db("m_users")->where('phone',$tel)->find();
                if($userArr){
                    return json(['code'=>2,'msg'=>'该手机号已被“'.$userArr['username'].'”绑定，确认将当前账号强制绑定此手机号吗？']);
                }
            }

            //print_r($real_name);echo "|";print_r($agent_type);echo"|";print_r($brandid);die;
            $res = $this->bindPhone($memid,$brandid,$tel,'',$real_name,$agent_type,$agent_status);

            if($res['code'] == 200){

                //通知mc绑定openid和手机号关系
                $mcParams = [
                    'mobile'  => $tel,
                    'brand_id'=> session('brand_id'),
                    'openid'  => session('openid'),
                    'nickname'=> session('username') ? session('username') : "",
                    'unionid' => session('unionid') ? session('unionid') : "",
                    'sex'     => session('sex') ? session('sex') : "",
                    'headimgurl' => session('simg') ? session('simg') : "",
                ];
                //店配置
                $shopData = isShopMain();
                if(!empty($shopData)){
                    $mcParams['shop_code'] = $shopData['shop_code'];
                }
                sx_call('5d02eb39af707',$mcParams);

                //Session::set('mem_phone',$tel);
                //发送消息通知
                $wxMemberCenterUrl = url('front/index/mycard',['slide'=>0],'',true);
                $brandName = $brandInfo['nickname']?$brandInfo['nickname']:$brandInfo['brandclass'];
                unset($brandInfo);
                $userLevel = getLevel(['userid'=>$memid]);
                $content = [
                    'touser'       => $openid,
                    'template_id'  => MEMBERTM_BINDMOBILE,
                    'url'          => $wxMemberCenterUrl,
                    'data'         => [
                        'first'=>[
                            'value'=> '恭喜您成为'.$brandName.$userLevel['name'].'会员',
                            'color'=> '#173177'
                        ],
                        'keyword1'=>[
                            'value'=> session('username'),
                            'color'=> '#173177'
                        ],
                        'keyword2'=>[
                            'value'=> $tel,
                            'color'=> '#173177'
                        ],
                        'keyword3'=>[
                            'value'=> $res['reg_score'],//增送积分
                            'color'=> '#173177'
                        ],
                        'keyword4'=>[
                            'value'=> $userLevel['name'].'会员',//会员级别
                            'color'=> '#173177'
                        ],
                        'keyword5'=>[
                            'value'=> $res['mem_card_num'],
                            'color'=> '#173177'
                        ],
                        'remark'=>[
                            'value'=> '更多优惠，请点击查看。',
                            'color'=> '#173177'
                        ]
                    ]
                ];
                $send_data['content'] = json_encode($content);
                $send_data['brandclass_id'] = $brandid;
                sendMemberWxMsg($send_data);

                return json(['code'=>1,'msg'=>'绑定手机成功','data'=>['shopOauthUrl'=>$shopOauthUrl,'is_check'=>$is_check]]);
            }else{
                return json(['code'=>0,'msg'=>'绑定手机失败:'.$res['msg']]);
            }


        }

        return json(['code'=>0,'msg'=>'绑定手机失败']);
    }

    public function verify () {
        $statusVerify = \db('open_verify')->where('type','=',1)->where('status','=',1)->find();
        if ($statusVerify) {
            $arr = array('code'=>1,'msg'=>'显示');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'不显示');
            return json($arr);
        }
    }
    public function judgeTel () {
        $id = Session::get('memid');
        $res = db('m_users')->where('id','=',$id)->field('phone')->find();
        if ($res['phone'] == '') {
            $arr = array('code'=>0,'msg'=>'用户未注册');
            return json($arr);
        } else {
            $arr = array('code'=>1,'msg'=>'用户已注册');
            return json($arr);
        }
    }
    /**
     * 方法描述：验证 股东码是否有效
     * @param  [type]  $shareholder [description]
     * @return boolean              [description]
     */
    public function is_share($shareholder){
        if(!$shareholder){
            return false;
        }
        $w['code'] = $shareholder;
        $w['status'] = 1;
        $w['is_del'] = 1;
        $data = db("s_shareholder")->where($w)->find();
        if($data){
            return $data;
        }else{
            return false;
        }
    }

    /**
     * 方法描述    绑定手机处理数据
     * @param  int $userid 用户id,
     * @param  int $phone手机号 
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月9日 下午1:51:45
     */
    public function bindPhone($userid,$brandid,$phone,$mydata='',$real_name,$agent_type,$agent_status){
        // 获取微信表的数据
        //$userInfo = getUserInfo(['userid'=>$userid]);
        $userInfo = db('m_users')->where('id',$userid)->find();
        if(!$userInfo){
            return ['code'=>1002,'msg'=>'未找到当前用户信息:'.$userid];
        }
        if($userInfo['phone']){
            Session::set('mem_phone',$userInfo['phone']);
            Session::set('phoneid',$userInfo['id']);
            return ['code'=>1003,'msg'=>'当前用户已绑定过手机号'];
        }

        if($agent_type){
            $apply_time=date('Y-m-d H:i:s',time());
        }

        //判断手机号是否被导入过
        $is_phone=db('m_users_phone')->where(['phone'=>$phone,'brandid'=>$userInfo['brandid']])->find();

        //判断当前手机号是否已被绑定
        $is_bind = db('m_users')->where('phone',$phone)->find();
        db()->startTrans();
        try{

            if($is_phone && !$is_phone['userid']){
                //return ['code'=>1];
                //若存在粉丝手机号导入信息并没有绑定用户， 积分成长值取和，之前积分记录改为现在的
                $phoneData = [

                    'phone'          => $phone,
                    'reg_time'       => date('Y-m-d H:i:s',time()),
                    'user_number'    => $is_phone['user_number']?$is_phone['user_number']:User::memCardNum($userid,$phone,$brandid),

                    'total_score'    => (int)$userInfo['total_score'] + (int)$is_phone['total_score'],
                    'growth_value'   => (int)$userInfo['growth_value'] + (int)$is_phone['growth_value'],
                    'sex'             => $mydata?$mydata['sex']:(int)$userInfo['sex'],

                    'real_name'      => $real_name,
                    'agent_type'     => $agent_type,
                    'agent_status'   => $agent_status,
                    'apply_time'     => $apply_time,
                ];
                db('m_users')->where('id',$userid)->update($phoneData);
                db('m_users_phone')->where('phone',$phone)->update(['userid'=>$userid]);
                db('minute_log')->where('users_phone_id',$is_phone['id'])->update(['m_executor'=>$userid]);
            }else{
                //return ['code'=>2];
                // 当手机号导入信息不存在 直接绑定手机号
                $phoneData = [

                    'phone'          => $phone,
                    'reg_time'       => date('Y-m-d H:i:s',time()),
                    'user_number'    => User::memCardNum($userid,$phone,$brandid),

                    'real_name'      => $real_name,
                    'agent_type'     => $agent_type,
                    'agent_status'   => $agent_status,
                    'apply_time'     => $apply_time,
                ];

                db('m_users')->where('id',$userid)->update($phoneData);
            }

            //若此手机号被绑定过，给之前数据解绑
            if($is_bind){
                db('m_users')->where('id',$is_bind['id'])->update(['phone'=>'']);
            }

            // 获取积分规则
            $scoreRule = getScoreRule(['userid'=>$userid]);
            $regScore  = $scoreRule && $scoreRule['reg_suc']?$scoreRule['reg_suc']:0;

            //若没绑定过手机号，并设置了积分， 则加积分
            if(empty($userInfo['reg_time']) && $regScore){

                //$AddScore = AddScore($userid,'',$regScore,'3','绑定手机');
                //$AddScore = addScoreLog($userid,'',$regScore,'3','绑定手机',2);//新的积分日志
                //if($AddScore === false){
                //    db()->rollback();
                //    return false;
                //}
            }

            //判断赠送优惠券（是否有待领优惠券)
            $coupondata = db('c_coupon_list')->where('share_phone',$phone)->where('status',5)->find();
            if($coupondata){
                $ress = db('c_coupon_list')->where('id',$coupondata['id'])->update(['status'=>0,'userid'=>$userid]);
                if(!$ress){
                    db()->rollback();
                    return ['code'=>1004,'msg'=>'优惠券更新失败'];
                }
            }


            //更改推荐人关系
            $UpdateRecommendUser = $this->recommendUser($userid,$phone,$brandid);
            if($UpdateRecommendUser === false){
                db()->rollback();
                return ['code'=>1005,'msg'=>'人员关系信息更新失败'];
            }

            //修改绑定订单表phone和 m_users_phone表id
            $perfectOrder = $this->perfectOrderInfo($userid,$phone,$is_phone['id']);
            if($perfectOrder === false){
                db()->rollback();
                return ['code'=>1006,'msg'=>'修改订单信息失败'];
            }

            
            //读取配置文件erp接口地址
            $erp = config('ext.app_config');
            $apiUrl = $erp['sx_erp']['addr'];


            //通知erp手机号绑定微信接口，现在erp直接调vip接口查询某手机号是否绑定
            /*
            $url = $apiUrl . 'SX_ChildVipApi/SX_VIPSetTelBandWeChat?Token=^******^&tel='.$phone;
            $dataN = '';
            $response = requestERP($url, $dataN);  //调用erp接口
            if ($response['Code'] != 200) {
                $this->errorLog($url,$response['Msg']);
            }
            */
            db()->commit();
            Session::set('mem_phone',$phone);
            //Session::set('phoneid',$users_phone_id);
            return ['code'=>200,'reg_score'=>$regScore,'mem_card_num'=>$phoneData['user_number'],'growth_value'=>$phoneData['growth_value']];
        }catch(\Exception $e){
            //print_r($e->getMessage());die;
            db()->rollback();
            return ['code'=>1001,'msg'=>'数据库操作失败：'.$e->getMessage()];
        }
    }

    /*
     * 判断、更改 推荐关系
     */
    public function recommendUser($userid,$phone,$brandid){
        //处理谁推荐了我。
        $recommend = db('recommend')->where(['r_phone'=>$phone,'brandid'=>$brandid,'status'=>2,'userid'=>['>',0]])->find();

        //已记录推荐关系，修改users表
        if($recommend){
            $res = db('m_users')->where('id',$userid)->update(['share_userid'=>$recommend['userid']]);
            if($res === false){
                return false;
            }
        }else{
            //无记录推荐关系，但是users表有来源推荐人id,则新建推荐关系
            $userInfo = db('m_users')
                ->alias('a')
                ->where('a.id',$userid)
                ->join('m_users b','a.share_userid = b.id','left')
                ->field('a.id,a.username,a.sex,a.share_userid,b.id as share_id,b.username as share_username,b.sex as share_sex')
                ->find();

            if($userInfo['share_userid'] && (int)$userInfo['share_userid'] > 0){
                $recommendData = [
                    'status' => 2,
                    'userid' => $userInfo['share_userid'],
                    'r_phone' => $phone,
                    'brandid' => $brandid,

                    'r_username' => $userInfo['username'],
                    'r_sex' => $userInfo['sex'] == 1 ? 1 : 2,
                    'create_time' => date('Y-m-d H:i:s')
                ];

                $insertRes = db('recommend')->insert($recommendData);
                if($insertRes === false){
                    return false;
                }
            }
        }
        //处理我推荐了谁。
        $recommend = db('recommend')->where(['user_phone'=>$phone,'status'=>2,'userid'=>0])->update(['userid'=>$userid]);
        if($recommend === false){
            return false;
        }
        return true;

    }

    /*
     * 修改绑定订单表的  phone和 m_users_phone表id
     */
    public function perfectOrderInfo($user_id,$phone,$users_phone_id){
        $recommend = db('recommend')->where(['r_phone'=>$phone,'status'=>2])->find();
        if($recommend){
            $updateData['recommend_id'] = $recommend['id'];
        }

        //$updateData['phone'] = $phone;
        $updateData['order_userid'] = $users_phone_id;
        $updateData['user_id']      = $user_id;

        $res = db('m_order')->where('phone',$phone)->update($updateData);
        if($res === false){
            return false;
        }else{
            return true;
        }

    }


    /**
     * 方法描述    我推荐的客户信息处理
     * @param  int $userid 用户id,
     * @param  int $phone手机号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月9日 下午1:51:45
     */
    public function recommendDispose () {
        $rPhone = input('post.r_phone');
//        $userId = Session::get('phoneid');
        $userId = Session::get('memid');
        $remark = trim(input('post.remark'));
        $brandId = Session::get('brand_id');
        $rUserName = trim(input('post.r_username'));
        $rPriceType = (int)input('post.price_type');
        $rSex = (int)input('post.r_sex');
        //$sellCounselor = (int)trim(input('post.sell_counselor'));
        $checkTel = preg_match('/^1[3456789][0-9]{9}$/',$rPhone); //验证手机号

        if (!$checkTel) {
            return array('code'=>201,'msg'=>'请输入正确手机号');
        }
        if(db('m_users')->where('phone',$rPhone)->where('brandid',Session::get('brand_id'))->find()){
            return array('code'=>206,'msg'=>'此用户已存在，请推荐其他用户');
        }

        $checkPhone = db('recommend')->where('brandid',$brandId)->where('r_phone',$rPhone)->find();
        if ($checkPhone) {
            return array('code'=>205,'msg'=>'该用户已被推荐');
        }
        $where = [
            'r_phone' => $rPhone,
            'r_username' => $rUserName,
            'brandid' =>  $brandId,
            'userid' => $userId,
            'price_type' => $rPriceType
        ];
        $checkData = db('recommend')->where($where)->find();
        if ($checkData) {
            return array('code'=>203,'msg'=>'请勿提交同样的数据');
        }
        $recommendData = [
            'status' => 3,
            'remark' => $remark,
            'userid' => $userId,
            'r_phone' => $rPhone,
            'brandid' => $brandId,
            'r_username' => $rUserName,
            'price_type' => $rPriceType,
            'r_sex' => $rSex,
            //'secretary_id' => $sellCounselor,
            'create_time' => date('Y-m-d H:i:s')
        ];

        db()->startTrans();
        try{
            $recommendRes = db('recommend')->insert($recommendData);

            /*
            $r_rule = db('recommend_rule')->where('brand_id',session('brand_id'))->find();
            $rule = json_decode($r_rule['rule'],true);

            $userData = db('m_users')->where('id',session('userid'))->find();

            $new_order = db('m_order')->where('phone',$userData['phone'])->order('order_time desc')->find();
            $order_number = $new_order['order_number'];

            if($brandId){
                $brandRes = sx_call('5a38840b15ba9',['id'=>$brandId],'sx_mc');
                if($brandRes['code'] == 200){
                    $brandClass = $brandRes['data'][0]['brandclass'];
                }
            }

            $param = [
                'introducer_ordernum' => $order_number,
                'introducer_name' => $userData['username'],//介绍人名字
                'introducer_tel'  => $userData['phone'],//介绍人手机
                'dj_staff_id'   => -1,
                'dj_staff'      => '会员转介绍',
                'brandclass_id' => $brandId ? $brandId : null,
                'brandclass'    => $brandClass ? $brandClass : null,
                'shop_code'     => $rule['shop_code'],
                'shop_name'     => $rule['shop_name'],
                'info'          => $rUserName.'-'.$rPhone,
            ];

            $kzRes = sx_call('5b286c6bbf2980',$param,'sx_crm');

            //提报客资不通，并且有这个接口（-1001说明不存在此接口）
            if($kzRes['code'] != 200 && $kzRes['code'] != -1001){
                db()->rollback();
                return array('code'=>204,'msg'=>'客资推荐失败-'.$kzRes['msg']);
            }
            */

            db()->commit();
            return array('code'=>200,'msg'=>'推荐成功');
        }catch (Exception $e){

            db()->rollback();
            return array('code'=>202,'msg'=>'推荐客户失败');
        }

    }


    /**
     * 方法描述  处理我的绑定银行卡页面
     * @param  int $userid 用户id,
     * @param  int $phone手机号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月9日 下午1:51:45
     */
    public function myBankBound () {
        $userBank = input('post.bank');
        $autoId = input('post.auto_id');
        $userId = Session::get('memid');
        $bankCode = input('post.bank_code');
        $brandId = Session::get('brand_id');
        $userTrueName = input('post.user_name');
        $id_card = input('post.id_card');

        $userData = db('m_users')->where('id',$userId)->find();
        $user_number = $userData['user_number'];

//        $preg_card='/^(\d{15}$)|(^\d{17}([0-9]|X)$/isu';
        $preg_card='/^(\d{15}$|^\d{18}$|^\d{17}(\d|X|x))$/';
        $preg_bankcard='/^(\d{15}|\d{16}|\d{19})$/isu';
        if(!preg_match($preg_card,$id_card)){
           return array('code'=>201,'请输入正确的身份证号码');
        }
        if(!preg_match($preg_bankcard,$bankCode)){
            //return array('code'=>202,'请输入正确的银行卡号码');
        }
        $thisOneData = db('m_withdraw')->where('userid',$userId)->field('id_card,user_true_name')->find();
        if (!$autoId) {
            if (!empty($thisOneData)) {
                return array('code'=>205,'msg'=>'只能绑定一张银行卡');
            }
        } else {
            if ($id_card != $thisOneData['id_card'] || $userTrueName != $thisOneData['user_true_name']) {
                return array('code'=>206,'msg'=>'请输入自己的名字和身份证号码');
            }
        }
        if (empty($autoId)) {
            $bankData = [
                'bank_status' => 1,
                'brandid' => $brandId,
                'user_bank' => $userBank,
                'bank_code' => $bankCode,
                'userid' => $userId,
                'id_card' => $id_card,
                'user_true_name' => $userTrueName,
                'bank_time' => date('Y-m-d H:i:s'),
                //'user_phone_id'=>$phone_id,
                'user_number'=>$user_number
            ];
            $bankResult = db('m_withdraw')->insert($bankData);
        } else {
            $bankDataUp = [
                'user_bank' => $userBank,
                'bank_code' => $bankCode,
                'id_card' => $id_card,
                'user_true_name' => $userTrueName,
                'bank_time' => date('Y-m-d H:i:s'),
            ];
            $bankResult = db('m_withdraw')->where('id',$autoId)->update($bankDataUp);
        }
        if ($bankResult === false) {
            return array('code'=>203,'msg'=>'银行卡数据添加失败');
        }
        return array('code'=>200,'msg'=>'银行卡数据添加成功');
    }
    /**
     * 方法描述  处理我的提现金额方法
     * @param  int $userid 用户id,
     * @param  int $phone手机号
     * @return mixed
     */
    public function exeMoney () {
        $userId = Session::get('memid');
        //$phone_id = Session::get('phoneid');
        $money = (int)input('post.money');

        if (empty($money) || $money <= 0) {
            return array('code'=>201,'msg'=>'金额不允许为空');
        }
        if(intval(config('min_tixian_money')) > 0){
            if($money < intval(config('min_tixian_money'))){
                return array('code'=>204,'msg'=>'最小提现金额为：'.intval(config('min_tixian_money')).'元');
            }
        }
        $userId = Session::get('memid');
        //$phone_id = Session::get('phoneid');
        $userData = db('m_users')->field('money,freeze_money')->where('id', $userId)->find();
        $sumMoney = bcsub($userData['money'], $userData['freeze_money'], 2); //可提现余额 = 余额 - 冻结余额
        if($money > $sumMoney){
            return array('code'=>203,'msg'=>'可提现金额不足');
        }

        $exeData = [
            'get_number' =>'ts'.str_shuffle(substr(time(),5).generate_code()).$userId,
            'get_money' => $money,
            'get_time' => date('Y-m-d H:i:s'),
            //'user_phone_id' => $phone_id,
            'userid' =>$userId,
            'money_status' => 2,
            'brandid' => Session::get('brand_id')
        ];
        db()->startTrans();
        try{
            $withdraw_id=db('m_withdraw_log')->insertGetId($exeData);//提现
            db('m_users')->where('id',$userId)->update(['freeze_money'=>['exp',"freeze_money + $money"]]); //修改用户冻结金额
            db()->commit();
            return array('code'=>200,'msg'=>'申请提现成功,请等待财务操作。','data'=>$withdraw_id);
        }catch (Exception $e){
            db()->rollback();
            return array('code'=>202,'msg'=>'申请提现金额失败');
        }

    }
    /**
     * 方法描述  处理我的银行卡解除绑定
     * @param  int $userid 用户id,
     * @param  int $phone手机号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月9日 下午1:51:45
     */
    public function relieveBound () {
        $autoId = input('post.auto_id');
        if (empty($autoId)) {
            return array('code'=>201,'msg'=>'自增id不可为空');
        }
        $relieveResult = db('m_withdraw')->where('id',$autoId)->delete();
        if ($relieveResult === false) {
            return array('code'=>202,'msg'=>'解绑数据更改失败');
        }
        return array('code'=>200,'msg'=>'解绑成功');
    }
    /**
     * 方法描述  立即预约大师
     * @param  int $userid 用户id,
     * @param  int $phone手机号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月9日 下午1:51:45
     */
    /*
    public function nowMake () {
        $userId = Session::get('memid');
        $masterId = input('post.master_id');
        $makeTime = input('post.master_time');
        if (!$masterId) {
            return array('code'=>201,'msg'=>'id不可为空');
        }
        $check = db('master_make')->where('master_id',$masterId)->where('make_time',$makeTime)->find();
        if (!empty($check)) {
            return array('code'=>202,'msg'=>'请选择其他事件预约');
        }
        $makeData = [
            'user_id' => $userId,
            'master_id' => $masterId,
            'make_time' => $makeTime,
        ];
        $makeResult = db('master_make')->insert($makeData);
        if ($makeResult === false) {
            return array('code'=>203,'msg'=>'预约数据入库失败');
        }
        return array('code'=>200,'msg'=>'预约成功');
    }
    */


    /**
     * 方法描述: 调取erp错误处理流程
     * @return payCode
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    private static function errorLog($url, $data)
    {
        $errorLogData = [
            'url' => $url,
            'data' => $data,
            'create_time' => date('Y-m-d'),
            'error_count' => 1,
        ];
        $logRes = db("c_vip_save")->insert($errorLogData);   //写入错误记录日志表
        if (!$logRes) {
            return array('code' => 201, 'msg' => '数据写入失败');
        }
        return 1;
    }


    /*
     * 换绑手机号
     */
    public function bindChange(){

        if(request()->isAjax()){
            $tel       = input('post.tel');
            $captcha   = input('post.captcha');        //用户填写的验证码

            $memid     = Session::get('memid');
            $brandid   = Session::get('brand_id');
            $sessionCaptcha = Session::get('capt');   //正确的验证码


            // 当前品牌商城域名缓存
            $brandInfo = getSiteBrand();
            $shopUrl  = $brandInfo['mall_url'];
            $openid   = Session::get('openid');
            $shopOauthUrl = $shopUrl."/mobile/oauth/index?authcode=".think_encrypt($openid);

            if ($tel && $captcha && $captcha != $sessionCaptcha) {
                return json(['code'=>3,'msg'=>'验证码错误','data'=>['shopOauthUrl'=>$shopOauthUrl]]);
            }

            if(!$tel){
                return json(['code'=>4,'msg'=>'请填写手机号']);
            }

            $userArr = db("m_users")->where('phone',$tel)->find();
            if($userArr){
                return json(['code'=>2,'msg'=>'温馨提示：该手机号已被“'.$userArr['username'].'”绑定,不可重复绑定']);
            }


            $res = db('m_users')->where('id',session('userid'))->update(['phone'=>$tel]);

            if($res!==false){

                //通知erp手机号绑定微信接口，现在erp直接调vip接口查询某手机号是否绑定
                /*
                $erp = config('ext.app_config');
                $apiUrl = $erp['sx_erp']['addr'];

                $url = $apiUrl . 'SX_ChildVipApi/SX_VIPSetTelBandWeChat?Token=^******^&tel='.$tel;
                $dataN = '';
                $response = requestERP($url, $dataN);  //调用erp接口
                if ($response['Code'] != 200) {
                    $this->errorLog($url,$response['Msg']);
                }
                */


                //通知mc绑定openid和手机号关系
                $mcParams = [
                    'mobile'  => $tel,
                    'brand_id'=> session('brand_id'),
                    'openid'  => session('openid'),
                    'nickname'=> session('username') ? session('username') : "",
                    'unionid' => session('unionid') ? session('unionid') : "",
                    'sex'     => session('sex') ? session('sex') : "",
                    'headimgurl' => session('simg') ? session('simg') : "",
                ];
                sx_call('5d02eb39af707',$mcParams);

                return json(['code'=>1,'msg'=>'绑定手机成功','data'=>['shopOauthUrl'=>$shopOauthUrl]]);

            }else{
                return json(['code'=>5,'msg'=>'绑定手机号失败','data'=>['shopOauthUrl'=>$shopOauthUrl]]);
            }


        }


        $userid = session('userid');

        $userInfo = db('m_users')->where('id',$userid)->find();

        $this->assign('userInfo',$userInfo);

        return $this->fetch('index/bindchange');
    }



}
