<?php
/**
 * 订单流程
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author:
 */

namespace app\front\controller;

use app\front\lib\Rili;
use think\Cache;

use think\Controller;
use think\Db;
use think\db\Query;
use think\image\Exception;
use think\Session;
use app\front\controller\BaseFront;


class Membercard extends BaseFront
{

	//初始化
	public function _initialize(){

		$wxId = Session::get('memid');  //微信主键id
        $this->brandId = Session::get('brand_id');    	
    	//会员信息
        $this->userInfo = db('m_users')
        	    	->where('id', $wxId)
           			->find();
		
		//判断是否绑定手机号
        if (!$this->userInfo['phone']) {
        	$this->redirect('index/bind');
        }
        $this->assign('userinfo',$this->userInfo);
    }

    /**
     * 会员卡中心
     */
    public function index(){

        return view();
    }

    /**
     * 初始密码
     */
    public function initial_pass(){
        if(request()->isAjax()){
            $acdata = input();
            if(!$acdata['password']){
                return json(['code'=>202,'msg'=>'请输入密码！']);
            }
            if(!$acdata['password2']){
                return json(['code'=>202,'msg'=>'请输入确认密码！']);
            }
            if($acdata['password'] != $acdata['password2']){
                return json(['code'=>202,'msg'=>'新密码两次输入不正确！']);   
            }
            $acdata['id'] = $this->userInfo['id'];
            $res = controller('Membercard','lib')->set_password($acdata);
            if($res){
                return json(['code'=>200,'msg'=>'设置成功']);
            }else{
                return json(['code'=>202,'msg'=>'设置失败，请重新设置']);
            }
        }
        if($this->userInfo['password']){
            $this->redirect('membercard/edit_pass');
        }
    	return view();
    }

    /**
     * 修改密码
     */
    public function edit_pass(){
        if(request()->isAjax()){
            $acdata = input();
            if(!$acdata['password']){
                return json(['code'=>202,'msg'=>'请输入新密码！']);
            }
            if(!$acdata['password2']){
                return json(['code'=>202,'msg'=>'请输入确认密码！']);
            }
            if($acdata['password'] != $acdata['password2']){
                return json(['code'=>202,'msg'=>'新密码两次输入不正确！']);  
            }
            if(!$acdata['oldpassword']){
                return json(['code'=>202,'msg'=>'请输入原密码！']);
            }
            if(think_encrypt($acdata['oldpassword']) != $this->userInfo['password']){
                return json(['code'=>202,'msg'=>'请输入正确的原密码！']);   
            }
            $acdata['id'] = $this->userInfo['id'];
            $res = controller('Membercard','lib')->set_password($acdata);
            if($res){
                return json(['code'=>200,'msg'=>'修改成功']);
            }else{
                return json(['code'=>202,'msg'=>'设置失败，请重新设置']);
            }
        }
    	return view();
    }

    /**
     * 忘记密码
     */
    public function forget_pass(){
        if(request()->isAjax()){
            $acdata = input();
            $code = Session::get('capt');
            if(!$acdata['code']){
                return json(['code'=>202,'msg'=>'请输入验证码！']);
            }
            if($acdata['code'] != $code){
                return json(['code'=>202,'msg'=>'验证码不正确！']);
            }
            if(!$acdata['password']){
                return json(['code'=>202,'msg'=>'请输入新密码！']);
            }
            if(!$acdata['password2']){
                return json(['code'=>202,'msg'=>'请输入确认密码！']);
            }
            if($acdata['password'] != $acdata['password2']){
                return json(['code'=>202,'msg'=>'新密码两次输入不正确！']);   
            }
            $acdata['id'] = $this->userInfo['id'];
            $res = controller('Membercard','lib')->set_password($acdata);
            if($res){
                return json(['code'=>200,'msg'=>'设置成功']);
            }else{
                return json(['code'=>202,'msg'=>'设置失败，请重新设置']);
            }
        }
        $this->assign("userinfo",$this->userInfo);
    	return view();
    }

    /**
     * 余额转移
     */
    public function balance(){

        $this->assign('userinfo',$this->userInfo);
    	return view();
    }


}