<?php
/**
 * 订单流程
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author:
 */

namespace app\front\controller;

use think\image\Exception;
use think\Session;

//http://vip.sx.com:8080/front/order/orderDetails
class Order extends BaseFront
{
    private $titleUpperLimit;  // 题目上限
    private $answerUpperLimit; // 答案上限
    private $answerLowerLimit; // 答案下限
    public function __construct()
    {
        parent::__construct();
        $limit = evaluate_limit();
        $this->titleUpperLimit = $limit['titleUpperLimit'];
        $this->answerUpperLimit = $limit['answerUpperLimit'];
        $this->answerLowerLimit = $limit['answerLowerLimit'];
        $this->brandId = Session::get('brand_id');

    }

    /*
     * 门店信息
     */
    public function shopInfo(){
        //$province = '广西壮族自治区';

        $shop_code = input('shop_code');

        if($shop_code){
            //指定店
            $getShop = controller('Order','lib')->getShopInfo($shop_code);
            $province = $getShop['data']['province'];
        }else{
            //未指定店
            $province = session('province');

            if(!$province){
                $province = db('m_users')->where('id',$this->userId)->value('province');
            }
        }

        //省下所有店，指定店面详细信息
        $allInfo = controller('Order','lib')->getPShop($province,$shop_code);
        if($allInfo['code'] == 200){
            $p_shop = $allInfo['data']['p_shop'];
            $province = $allInfo['data']['province'];
            $shopList = $allInfo['data']['shop_list'];
            $shopInfo = $allInfo['data']['shop_info'];
            $shop_photo = $allInfo['data']['shop_info']['shop_photo'];
        }

        //print_r($allInfo);die;
        $this->assign(['p_shop'=>$p_shop,'shopList'=>$shopList,'shopInfo'=>$shopInfo,'shop_photo'=>$shop_photo,'province'=>$province]);
        return $this->fetch('Order/shopinfo');
    }

    /*
     * 获取某个省下店面
     */
    public function getPShop(){
        $province = input('province');
        //print_r($province);die;
        /*
        if(strpos($province,'省') !== false){
            $province = trim($province,'省');
        }
        if(strpos($province,'市') !== false){
            $province = trim($province,'市');
        }
        */

        $res = controller('Order','lib')->getPShop($province);

        return json($res);
    }

    /*
     * ajax请求 获取某个店面详情
     */
    public function getShopInfo(){
        $shop_code = input('shop_code');
        session('package_shop',$shop_code);

        if(!$shop_code){
            return json(['code'=>201,'data'=>[],'msg'=>'未获取到店面识别码']);
        }

        $res = controller('Order','lib')->getShopInfo($shop_code);

        return json($res);
    }

    /*
     * 门店下套系
     */
    public function shopPackage(){
        $shop_code = input('shop_code');
        $view_type = input('view_type')?input('view_type'):'list';//list 套系列表，cart购物清单

        $all = [['id'=>'','name'=>'全部']];
        $typeList = db('s_cat')->where(['brandclass_id'=>session('brand_id'),'is_delete'=>1])->order('sort asc')->select();
        $typeList = array_merge($all,$typeList);
        //print_r($typeList);die;

        $cat_id = $typeList[0]['id'];
        //默认展示第一分类套系
        $package = controller('Order','lib')->getShopTypePackage($shop_code,$cat_id);
        //print_r($package);die;
        //本店选购清单
        //$cartList = controller('Order','lib')->getShopCart($shop_code);

        //选购清单里 加入套系的付款类型 1全款 2定金
        //$cart_p_type = [];
        //foreach($cartList['data']['list'] as $k => $v){
        //    $cart_p_type[$v['package_id']] = $v['price_type'];
        //}

        //$cart_p_array = array_column($cartList['data']['list'],'package_id');
        //if($cart_p_array)  $cart_p_id = implode(',',$cart_p_array);

        //下单是强制查看协议
        $must_look_agreement = db('c_sysconfig')->where('ckey','must_look_agreement')->value('cvalue');

        //检测 是否需要预约到店时间环节，否则直接提交订单
        $reach_shop_date = db('c_sysconfig')->where('ckey','reach_shop_date')->value('cvalue');

        if($reach_shop_date == 1){
            $next_url = url('chooseShopDate');
        }else if($reach_shop_date != 1 && $must_look_agreement == 1){
            $next_url = url('Order/agreement');
        }else{
            $next_url = url('Payment/submitOrder');
        }

        $userInfo = db('m_users')->where('id',session('userid'))->find();

        $this->assign([
            'userInfo' => $userInfo,
            'shop_code'=> $shop_code,
            'typeList' => $typeList,
            'cat_id'   => $cat_id,
            'package'  => $package['data']['package'],
            'cart'     => $package['data']['cart_list'],
            'total_price' => $package['data']['cart_total_price'],
            //'cart_p_array'=> $cart_p_array,
            //'cart_p_type' => $cart_p_type,
            'cart_p_id'   => $package['data']['cart_p_id'],
            'view_type'   => $view_type,
            'reach_shop_date'=>$reach_shop_date,
            'next_url'   => $next_url,
        ]);
        return $this->fetch('Order/shoppackage');
    }

    /*
     * ajax请求 某个店面下 一个分类 的套系(标识是否加入购物清单，若已加入付款类型是什么)
     * shop_code
     * cat_id
     */
    public function getShopTypePackage(){
        $shop_code = input('shop_code');
        $cat_id = input('cat_id');

        /*
        if(!$cat_id){
            return json(['code'=>201,'msg'=>'未获取到分类信息']);
        }
        */

        if(!$shop_code){
            return json(['code'=>202,'msg'=>'未获取到店面信息']);
        }

        $packageData = controller('Order','lib')->getShopTypePackage($shop_code,$cat_id);

        if($packageData['code'] == 200){
            $package = $packageData['data']['package'];
            return json(['code'=>200,'data'=>$package]);
        }else{
            return json(['code'=>203,'msg'=>'未获取到套系数据']);
        }

    }

    /*
     * ajax请求 某个店面下 选购清单
     */
    public function getShopCart(){
        $shop_code = input('shop_code');

        if(!$shop_code){
            return json(['code'=>202,'msg'=>'未获取到店面信息']);
        }

        $res = controller('Order','lib')->getShopCart($shop_code);
        return json($res);
    }



    /*
     * 套系详情
     */
    public function packageInfo(){
        $p_id = input('id');

        $packageInfo = db('s_package_info')
            ->alias('a')
            ->join('s_cat cat','a.cat_id = cat.id','left')
            ->where('a.id',$p_id)
            ->field('a.*,cat.name as cat_name')
            ->find();

        $this->assign(['packageInfo'=>$packageInfo]);
        $this->assign('shop_code',input('shop_code'));
        return $this->fetch('Order/packageinfo');
    }


    /*
     *  加入购物车
     */
    public function addCart(){
        $p_id = input('id');

        if(!$p_id){
            return json(['code'=>201,'msg'=>'未获取到信息,请稍后重试']);
        }

        $price_type = input('price_type');
        $shop_code = input('shop_code');

        $res = controller('Order','lib')->addCart($p_id,$price_type,$shop_code);

        return json($res);

    }

    /*
     * 从选购清单移除
     */
    public function delCart(){
        $cart_id = input('cart_id');
        $p_id = input('p_id');
        $shop_code = input('shop_code');

        if(!$cart_id&&(!$p_id&&!$shop_code)){
            return json(['code'=>201,'msg'=>'未获取到信息,请稍后重试']);
        }
        if($cart_id){
            $where = ['id'=>$cart_id];
        }else{
            $where = ['package_id'=>$p_id,'user_id'=>session('userid'),'shop_code'=>$shop_code];
        }

        $res = db('s_package_cart')->where($where)->delete();

        if($res === false){
            return json(['code'=>203,'msg'=>'操作失败，请稍后重试']);
        }else{
            return json(['code'=>200,'msg'=>'success']);
        }
    }

    /*
     * 下单协议条款页面
     */
    public function agreement(){

        $package_ids = input('package_ids');
        $shop_code = input('shop_code');
        $reach_shop_date = input('reach_shop_date');

        $this->assign([
            'shop_code'  => $shop_code,
            'package_ids'=> $package_ids,
            'reach_shop_date'=> $reach_shop_date,
        ]);
        return $this->fetch('Order/agreement');

    }


    /*
     * 选择到店时间页面
     */
    public function chooseShopDate(){
        $package_ids = input('package_ids');
        $shop_code = input('shop_code');

        //下单是强制查看协议
        $must_look_agreement = db('c_sysconfig')->where('ckey','must_look_agreement')->value('cvalue');

        if($must_look_agreement == 1){
            $next_url = url('Order/agreement');
        }else{
            $next_url = url('Payment/submitOrder');
        }

        $shopInfo = db('s_shop_info')->where('shop_code',$shop_code)->find();

        $this->assign([
            'shop_code'  => $shop_code,
            'shopInfo'   => $shopInfo,
            'package_ids'=> $package_ids,
            'next_url'   => $next_url,
        ]);
        return $this->fetch('Order/chooseshopdate');
    }

    /*
     * 提交订单页面---------搬到payment控制器了
     */
    public function submitOrder(){
        $shop_code = input('shop_code');
        $package_ids = input('package_ids');//套系id
        $reach_shop_date = input('reach_shop_date');//到店时间

        $shopRes = controller('Order','lib')->getShopInfo($shop_code);
        $shopInfo = $shopRes['data'];

        //会员折扣是否可与优惠券同用  1可以，2不可以
        $is_with = db('c_sysconfig')->where('ckey','vip_coupon_with')->value('cvalue');
        //$is_with = 2;

        //用户信息 等级折扣
        $userInfo = db('m_users')
            ->alias('user')
            ->where('user.id',session('userid'))
            ->join('user_level level','user.level = level.id','left')
            ->field('user.*,level.name,level.discount')
            ->find();

        if($userInfo['brithday'])  $userInfo['brithday'] = date('Y-m-d',strtotime($userInfo['brithday']));

        //$userInfo['discount'] = 0;
        if($userInfo['discount'] > 0 && $userInfo['discount'] < 1){
            $discount = $userInfo['discount'];
        }


        //选购清单内套系详情
        $packageList = db('s_package_cart')
            ->where('cart.package_id','in',$package_ids)
            ->where('cart.shop_code',$shop_code)
            ->where('cart.user_id',session('userid'))
            ->alias('cart')
            ->join('s_package_info info','cart.package_id = info.id','left')
            ->field('cart.id,cart.package_id,cart.price_type,cart.price,info.package_name,info.erp_package_name,info.package_price,info.shop_code,info.shop_name,info.brand_id')
            ->order('add_time desc')
            ->select();

        //每个套系相应优惠券
        $couponList = [];
        foreach($packageList as $key => $val){

            //会员折扣后价格  差价
            if($discount){
                $packageList[$key]['new_package_price'] = $val['package_price'] * $discount;
                $packageList[$key]['vip_diff'] = $val['package_price'] - $packageList[$key]['new_package_price'];
                //全款 则应付折扣后
                if($val['price_type'] == 1){
                    $packageList[$key]['pay_price'] = $val['price'] * $discount;
                }else{
                    //定金则应付为定金
                    $packageList[$key]['pay_price'] = $val['price'];
                }
            }else{
                $packageList[$key]['new_package_price'] = $val['package_price'];
                $packageList[$key]['vip_diff'] = 0;

                $packageList[$key]['pay_price'] = $val['price'];
            }

            $coupon = controller('Order','lib')->getCoupon(session('userid'),$val['price'],$val['package_id']);
            $couponList = array_merge($couponList,$coupon['data']);
            //$packageList[$key]['coupon'] = $coupon['data'];
            //$packageList[$key]['coupon_count'] = $coupon['count'];
        }


        //套系折扣前总价 折扣后总价 总优惠
        $total =  array_sum(array_map(create_function('$val', 'return $val["package_price"];'), $packageList));
        $new_total =  array_sum(array_map(create_function('$val', 'return $val["new_package_price"];'), $packageList));
        $diff = $total - $new_total;


        //支付 折扣前总金额  折扣后总金额
        $pay_total =  array_sum(array_map(create_function('$val', 'return $val["price"];'), $packageList));
        $vip_pay_total =  array_sum(array_map(create_function('$val', 'return $val["pay_price"];'), $packageList));

        //优惠券 排重
        $coupon_ids = [];
        foreach($couponList as $k => $v){
            if(!in_array($v['id'],$coupon_ids)){
                $coupon_ids[] = $v['id'];
            }else{
                unset($couponList[$k]);
            }
        }

        $this->assign([
            'package_ids' => $package_ids,
            'shop_code'=> $shop_code,
            'shopInfo' => $shopInfo,
            'userInfo' => $userInfo,
            'packageList' => $packageList,
            'couponList'  => $couponList,
            'reach_shop_date' => $reach_shop_date,
            'discount'  => $discount,//折扣
            'total'     => $total,//折扣前总价
            'new_total' => $new_total,//折扣后总价
            'diff'      => $diff,//优惠价
            'pay_total' => $pay_total,//此次支付总价
            'vip_pay_total' => $vip_pay_total,
            'nowYear'   => date('Y'),
            'is_with'   => $is_with,
        ]);
        return $this->fetch('Order/submitorder');
    }

    /*
     * 根据优惠券得出最大优惠套系
     */
    public function couponCompute(){
        $id = input('coupon_id');
        $shop_code = input('shop_code');
        $package_ids = input('package_ids');

        if(!$id){
            return ['code'=>201,'msg'=>'未获取到优惠券信息'];
        }

        if(!$shop_code){
            return ['code'=>201,'msg'=>'未获取到店面信息'];
        }

        if(!$package_ids){
            return ['code'=>201,'msg'=>'未获取到订单套系信息'];
        }

        //优惠券信息
        $couponData = db('c_coupon_list')->where('id',$id)->find();

        $array_intersect = array_intersect(explode(',',$package_ids),explode(',',$couponData['package_ids']));

        $pData = db('s_package_cart')
            ->where('cart.package_id','in',$array_intersect)
            ->where('cart.shop_code',$shop_code)
            ->where('cart.user_id',session('userid'))
            ->where('info.use_coupon',1)
            ->alias('cart')
            ->join('s_package_info info','cart.package_id = info.id','left')
            ->field('cart.*,info.use_coupon')
            ->select();

        //价格最高套系
        $max = 0;

        foreach ($pData as $key => $val) {
            $max = max($max , $val['price']);
            if($max == $val['price']){
                $p_id = $val['package_id'];
            }
        }

        $p_id = $p_id?$p_id:$pData[0]['package_id'];

        if($p_id){
            return ['code'=>200,'data'=>$p_id];
        }else{
            return ['code'=>202,'msg'=>'没有适用套系'];
        }

    }
    /*
     * 儿童套系，修改vip订单状态，erp下单
     */
    public function setChildPackageOrder(){
        //此入口暂时封闭--sdm 安全性不够，支付成功后，MC会通知API进行订单状态更新。
        return array('error'=>1,'code'=>204,'msg'=>'验证错误，请从正确入口进入。');
        $params = input('');


        if(!$params["order_no"]){
            payment_log("0元支付或erp卡支付，未接收到单号",'','');
            return array('error'=>1,'code'=>204,'msg'=>'验证错误，未接收到单号');
        }

        if(!db('s_order_serial')->where('serial_number',$params["order_no"])->find()){
            return array('error'=>1,'code'=>204,'msg'=>'验证错误，系统内不存在此单号。');
        }

        $res = controller('index/Order','lib')->setChildPackageOrder($params);
        return $res;

    }

    /*
     * 检测是否有未同步到会员系统的订单
     */
    public function checkErpOrder($userData){

        $phone = $userData['phone'];

        //读取配置文件erp接口地址
        $erp = config('ext.app_config');
        $apiUrl = $erp['sx_erp']['addr'];

        $url = $apiUrl . '/SX_ChildVipApi/Sel_AllCustomerOrderInfo?Token=^******^&OrderId=&Phone='.$phone;
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口
        //print_r($response);die;
        if ($response['Code'] == 200) {
            //订单
            $orderList = [];
            foreach ($response['Data']['ET'] as $k => $v) {
                $v['zltype'] = 'ET';
                $v['order_date'] = date('Y-m-d',strtotime($v['targetdate']));
                $orderList[] = $v;
            }
            foreach ($response['Data']['HS'] as $k => $v) {
                $v['zltype'] = 'HS';
                $v['order_date'] = date('Y-m-d',strtotime($v['targetdate']));
                $orderList[] = $v;
            }

            //erp所有的订单id
            $erpOrders = array_column($orderList, 'orderId');

            //print_r($orderList);die;
            //已有订单
            $vipOrder = db("m_order")->where(['user_id'=>$this->userId])->where('delete_time is null')->select();
            $orders   = array_column($vipOrder,'order_number');

            //检测推荐人表里是否有人推荐此用户，推荐通过，未领取过奖励，推荐手机号为成单手机号
            $recommend = db('recommend')->where(['status'=>2,'r_phone'=>$phone,'is_get'=>2])->find();

            $insert = [];
            foreach($orderList as $k => $v){
                if($v['wphone'] == $phone && !in_array($v['orderId'],$orders)){
                    //新增订单数据
                    $insertData = [
                        'order_time'   => date('Y-m-d',strtotime($v['targetdate'])),
                        'order_number' => $v['orderId'],
                        'one_money'    => 0,
                        'two_money'    => 0,
                        'one_detail'   => 0,
                        'two_detail'   => 0,
                        'phone'        => $phone,
                        'brandid'      => $userData['brandid'],
                        'total_money'  => 0,
                        'package_name' => $v['package_name'],
                        'create_time'  => date('Y-m-d H:i:s'),
                        'user_id'      => $this->userId,
                        'recommend_id' => $recommend ? $recommend['id'] : null,
                        'zltype'       => $v['zltype'],
                    ];

                    //如果表中已有此订单，但是没有记录 user_id,则记上user_id
                    if(db("m_order")->where(['order_number'=>$v['orderId']])->where('delete_time is null')->find()){
                        db("m_order")->where(['order_number'=>$v['orderId']])->where('delete_time is null')->update(['user_id'=>$this->userId,'zltype'=>$v['zltype']]);
                    }else{
                        $insert[] = $insertData;
                    }
                }
            }

            if($insert) $res = db('m_order')->insertAll($insert);

            //查询当前用户在vip的所有订单
            $vipOrderData = db("m_order")->where(['user_id'=>$this->userId])->where('delete_time is null')->select();

            try{
                //vip里有的订单，erp却没有，则删除vip表的订单
                foreach ($vipOrderData as $key => $value) {
                    if($value['phone'] == $phone && !in_array($value['order_number'],$erpOrders)){
                        db("m_order")->where('id',$value['id'])->update(['delete_time'=>date('Y-m-d H:i:s')]);
                    }
                }    
            }catch (Exception $e){
                self::errorLog('','删除vip表内多余订单错误，原因：'.$e->getMessage());
            }

            //是否下载过云底片
            $orderIds = implode(',',array_column($orderList,'orderId'));
            if($orderIds){
                $ydpRes = sx_call('5d37d21b26547',['order_sn'=>$orderIds],'sx_photo');

                if($ydpRes['code']==200){
                    $downloadData = $ydpRes['data'];

                    $is_down = [];
                    foreach($downloadData as $key => $val){
                        $is_down[$val['order_sn'].'_'.$val['fc']] = $val['download_time'];
                    }

                }
            }

            //所有订单服次 服务中信息
            $orderFcNewList = [];
            foreach($orderList as $k => $v){

                if(!$v['allfinishfate']){//订单未总完成
                    foreach($v['dt_photo'] as $key => $val){
                        //本服次为完成，有拍照日期，没有下载过底片
                        if(!$val['fcstate'] && $val['photodate'] && !$is_down[$val['orderId'].'_'.$val['currentfc']]){
                            $orderFcNewList[] = [
                                'orderId'   => $val['orderId'],
                                'fc'        => $val['currentfc'],
                                'targetdate'=> $v['targetdate'],//订单日期
                                'photodate' => $val['photodate'],  //拍照日期
                                'zltype' => $v['zltype'],  //订单类型
                            ];
                        }

                    }
                }
            }

            $targetdates = array_column($orderFcNewList, 'targetdate');
            array_multisort($targetdates,SORT_ASC,$orderFcNewList);//根据时间正序排序

            //潘多拉定制需求 ， 2020-11-15日之前的订单不显示
            if(customize('panduola')){
                foreach ($orderFcNewList as $key => $value) {
                    if($value['order_date'] < '2020-11-15'){
                        unset($orderFcNewList[$key]);
                    }
                }
                foreach ($orderList as $key => $value) {
                    if($value['order_date'] < '2020-11-15'){
                        unset($orderList[$key]);
                    }
                }
            }

            return [
                'orderList'=>$orderList,
                'orderId'=>$orderFcNewList[0]['orderId'] ? $orderFcNewList[0]['orderId'] : $orderList[0]['orderId'],
                'fc'=>$orderFcNewList[0]['fc'] ? $orderFcNewList[0]['fc'] : $orderList[0]['fc'],
                'zltype'=>$orderFcNewList[0]['zltype'] ? $orderFcNewList[0]['zltype'] :$orderList[0]['zltype']
            ];

        }
        return [];
    }
/*    public function checkErpOrder($userData){

        $phone = $userData['phone'];

        //读取配置文件erp接口地址
        $erp = config('ext.app_config');
        $apiUrl = $erp['sx_erp']['addr'];

        $url = $apiUrl . '/SX_ChildVipApi/Sel_AllCustomerOrderInfo?Token=^******^&OrderId=&Phone='.$phone;
        $dataN = '';
        $response = requestERP($url, $dataN);  //调用erp接口

        if ($response['Code'] == 200) {
            $orderList = $response['Data'];

            //print_r($orderList);die;
            //已有订单
            $vipOrder = db("m_order")->where(['user_id'=>$this->userId])->where('delete_time is null')->select();
            $orders = array_column($vipOrder,'order_number');

            //检测推荐人表里是否有人推荐此用户，推荐通过，未领取过奖励，推荐手机号为成单手机号
            $recommend = db('recommend')->where(['status'=>2,'r_phone'=>$phone,'is_get'=>2])->find();

            $insert = [];
            foreach($orderList as $k => $v){
                if($v['wphone'] == $phone && !in_array($v['orderId'],$orders)){
                    //新增订单数据
                    $insert[] = [
                        'order_time'   => date('Y-m-d',strtotime($v['targetdate'])),
                        'order_number' => $v['orderId'],
                        'one_money'    => 0,
                        'two_money'    => 0,
                        'one_detail'   => 0,
                        'two_detail'   => 0,
                        'phone'        => $phone,
                        'brandid'      => $userData['brandid'],
                        'total_money'  => 0,
                        'package_name' => '',
                        'create_time'  => date('Y-m-d H:i:s'),
                        'user_id'      => $this->userId,
                        'recommend_id' => $recommend ? $recommend['id'] : null,
                    ];
                }
            }

            $res = db('m_order')->insertAll($insert);

            //是否下载过云底片
            $orderIds = implode(',',array_column($orderList,'orderId'));
            if($orderIds){
                $ydpRes = sx_call('5d37d21b26547',['order_sn'=>$orderIds],'sx_photo');

                if($ydpRes['code']==200){
                    $downloadData = $ydpRes['data'];

                    $is_down = [];
                    foreach($downloadData as $key => $val){
                        $is_down[$val['order_sn'].'_'.$val['fc']] = $val['download_time'];
                    }

                }
            }

            //所有订单服次 服务中信息
            $orderFcNewList = [];
            foreach($orderList as $k => $v){

                if(!$v['allfinishfate']){//订单未总完成
                    foreach($v['dt_photo'] as $key => $val){
                        //本服次为完成，有拍照日期，没有下载过底片
                        if(!$val['fcstate'] && $val['photodate'] && !$is_down[$val['orderId'].'_'.$val['currentfc']]){
                            $orderFcNewList[] = [
                                'orderId'   => $val['orderId'],
                                'fc'        => $val['currentfc'],
                                'targetdate'=> $v['targetdate'],//订单日期
                                'photodate' => $val['photodate'],  //拍照日期
                            ];
                        }

                    }
                }
            }

            $targetdates = array_column($orderFcNewList, 'targetdate');
            array_multisort($targetdates,SORT_ASC,$orderFcNewList);//根据时间正序排序


            return ['orderList'=>$orderList,'orderId'=>$orderFcNewList[0]['orderId'],'fc'=>$orderFcNewList[0]['fc']];

        }
        return [];
    }*/

    /*
     * 我的订单
     */
    public function orderInfo(){
        $orderId = input('order_id');  //接取订单id
        $zltype = input('zltype'); //婚纱、儿童判定
        $fc = input('fc');//服次

        $userData = db('m_users')->where('id',$this->userId)->find();

        if(!$userData['phone']){
            $param = [];
            if($orderId)  $param[] = 'order_id='.$orderId;
            if($fc)       $param[] = 'fc='.$fc;
            $paramStr = $param ? '?'.implode('&',$param) : '';
            $this->assign(['upaddress' => url('Order/orderInfo').$paramStr,]);
            return $this->fetch('index/bind');
        }else{
            //检测是否有未同步到会员系统的订单
            $orderCheckRes =  $this->checkErpOrder($userData);

            $orderList =  $orderCheckRes['orderList']; //订单列表
            $orderId = $orderId ? $orderId : $orderCheckRes['orderId']; //当前显示订单
            $fc = $fc ? $fc : $orderCheckRes['fc'];//当前显示服次
            $zltype = $zltype ? $zltype : $orderCheckRes['zltype']; //订单类型ET儿童，HS婚纱

        }

        //若erp没有查到订单数据，查询数据库绑定的订单
        if(!$orderList){
            //历史订单
            $orderList = db("m_order")->where(['user_id'=>$this->userId])->where('delete_time is null')->order("order_time desc,id desc")->select();
            foreach($orderList as $k => $v){
                $orderList[$k]['orderId'] = $v['order_number'];
            }
        }

        //潘多拉定制需求 ， 2020-11-15日之前的订单不显示
        if(customize('panduola')){
            foreach ($orderList as $key => $value) {
                if($value['order_date'] < '2020-11-15'){
                    unset($orderList[$key]);
                }
            }
        }

        //若没有传订单号，则 取最新一个订单的单号，查看详情
        if(!$orderId)  $orderId = $orderList[0]['orderId'];

        if($orderId){

            //订单详情
            $res = controller('Order','lib')->getErpOrderInfo(['order_id'=>$orderId,'zltype'=>$zltype]);

            if($res['code'] == 200){
                $orderInfo = $res['data'];

                //若传了单号，服次显示订单当前服次，若没有 则取checkErpOrder方法中规则得到的服次
                $currentfc = (input('order_id')&&!input('fc')) ? $orderInfo['currentfc'] : $fc;
                //总服次
                $servicenumber = $orderInfo['servicenumber'];
                $fc_array = [];
                for($i=1;$i<=$servicenumber;$i++){
                    $fc_array[] = $i;
                }
            }

            //产品详情
            $package_res = controller('Order','lib')->getErpPackageInfo(['order_id'=>$orderId,'shop_code'=>$orderInfo['shop_code'],'zltype'=>$zltype]);

            if($res['code'] == 200) {
                $packArr = $package_res['data'];
            }

            //进度
            $hj = $this->huanjie($orderId);
            if($hj){
                $this->assign('hj',$hj);
            }

        }

        //检测是否有先睹为快照片
        $sneakPeek = controller('Order','lib')->getSneakPeek(['order_id'=>$orderId,'fc'=>$currentfc]);
        //print_r($sneakPeek);die;

        //客服
        $kf = db('c_kf')->where('brandid', Session::get('brand_id'))->find();

        $this->assign('upaddress', $_SERVER['HTTP_REFERER']);
        $this->assign('order_money', $orderInfo['total_money']);
        $this->assign('order_id', $orderId);
        $this->assign('packArr', $packArr);      //产品详情
        $this->assign('orderArr', $orderList);   //历史订单
        $this->assign('orderInfo', $orderInfo);  //订单详情
        $this->assign('fc_array', $fc_array);    //所有服次
        $this->assign('currentfc', $currentfc);  //订单当前服次
        $this->assign('kf', $kf);                //客服信息
        $this->assign('sneakPeek',$sneakPeek);   //先睹为快图片
        $this->assign('zltype',$zltype);    //婚纱或儿童订单表示

        $this->assign('pftype',input('pftype'));
        $this->assign('mainid',input('mainid'));

        if(config('IS_CHILD') === true){
            $this->assign('is_child',1);
        }

        if(input('view_type') == 'evaluationset'){
            return $this->fetch('Order/evaluationset');    
        }else{
            return $this->fetch('Order/orderinfo');    
        }
        
    }

    public function huanjie($orderId){
        /**
             *调ERP接口 获取当前订单的服务进度
            */
            $erp = config('ext.app_config');  //读取erp配置文件
            $paiUrl = $erp['sx_erp']['addr'];  //调用url
            $huanjieUrl = $paiUrl.'/SX_ChildVipApi/SX_VIPGetHQServiceInfo?Token=^******^&orderid='.$orderId;    //接口地址
            $huanjieData = requestErp($huanjieUrl,'');

            //currentfc         服次
            //allfc             总服次次数
            //islastfc          当前服务次数
            //taobanstaff       套板师
            //smtbwancday       套板完成日
            //americaneditorman 美遍师
            //sm_meibianoverday 美编完成日
            //kanxiupianday     看修片效果日
            //kanxiupianstate   看修片状态 已完成 && 有
            //kanxiaoguostaff   看效果人
            //iswhethercantake  整件完成状态
            //whethercantakedate整件完成日
            //isalreadytake     取件完成状态
            //alreadytakedate   取件完成日
            //fcstate           服次完成状态
            //fcoverday         服次完成日
            if($huanjieData['Code'] != 200){
                return false;
            }
            $hj = [];
            foreach($huanjieData['Data'] as $key=>$value){
                // if($value['currentfc'] == $fc){
                //     $hj = $huanjieData['Data'][$key];
                // }

                if($value['fcoverday']){ //完成
                    $hj[$value['currentfc']] = "sd_wancheng";
                }elseif($value['whethercantakedate']){    //制作
                    $hj[$value['currentfc']] = "sd_zhizuo";
                }elseif($value['kanxiupianstate'] == '已看完'){ //看版
                    $hj[$value['currentfc']] = "sd_kanban";
                }elseif($value['sm_meibianoverday']){      //设计
                    $hj[$value['currentfc']] = "sd_sheji";
                }else{
                    $hj[$value['currentfc']] = "sd_none";
                }
            }
            return $hj;
    }

    /*
     * ajax获取此订单某服次是否有云底片和mv
     */
    public function getPhotoMv(){
        $orderId = input('orderId');
        //$orderId = 'DHC06281';//云底片测试单号
        //$orderId = 'AYHZL190724002';//mv测试单号
        $fc = input('fc');

        $param = [
            'order_sn' => $orderId,
        ];
        if($fc){
            $param['fc'] = $fc;
        }

        $res=sx_call('5d37d21b26547',$param,'sx_photo');
        if($res['code']==200){
            $photo = $res['data']['url'];
        }else{
            $errMsg[] = $res['msg'];
        }


        $mvRes=sx_call('5d37d21b26547',$param,'sx_mv');
        if($mvRes['code']==200){
            $mv = $mvRes['data']['url'];
        }else{
            $errMsg[] = $mvRes['msg'];
        }

        if($photo && $mv){
            return ['code'=>200,'data'=>['photo'=>$photo,'mv'=>$mv]];
        }else{
            return ['code'=>201,'data'=>['photo'=>$photo,'mv'=>$mv],'msg'=>array_filter($errMsg) ? implode(',',array_filter($errMsg)) :''];
        }

    }


    /*
     * ajax获取订单详情和套系产品详情
     */
    public function getErpOrderInfo(){
        $params = input('');
        $orderId = input('order_id');  //接取订单id
        $fc = input('fc'); //服次

        if(!$orderId){
            return ['code'=>201,'msg'=>'没有获取到订单号！'];
        }

        $orderRes = controller('Order','lib')->getErpOrderInfo($params);

        //进度
        $hj = [];
        $huanjie = $this->huanjie($orderId);
        if($huanjie){
            $hj = $huanjie;
        }

        $params['shop_code'] = $orderRes['data']['shop_code'];
        $packageRes = controller('Order','lib')->getErpPackageInfo($params);

        return json(['code'=>200,'data'=>['orderInfo'=>$orderRes['data'],'packageInfo'=>$packageRes['data'],'hj'=>$hj]]);

    }

    /*
     * ajax获取本服次拍照排程信息
     */
    public function getErpPhoto(){
        $params = input('');
        $orderId = input('order_id');  //接取订单id

        if(!$orderId){
            return ['code'=>201,'msg'=>'没有获取到订单号！'];
        }

        $res = controller('Order','lib')->getErpPhoto($params);
        return json($res);
    }

    /*
     * ajax获取本服次选片详情
     */
    public function getErpSelectInfo(){
        $params = input('');
        $orderId = input('order_id');  //接取订单id

        if(!$orderId){
            return ['code'=>201,'msg'=>'没有获取到订单号！'];
        }

        $res = controller('Order','lib')->getErpSelectInfo($params);
        return json($res);
    }

    /*
     * ajax获取本服次取件详情
     */
    public function getErpQjInfo(){
        $params = input('');
        $orderId = input('order_id');  //接取订单id

        if(!$orderId){
            return ['code'=>201,'msg'=>'没有获取到订单号！'];
        }

        $res = controller('Order','lib')->getErpQjInfo($params);
        return json($res);
    }

    /**
     * ajax获取评价题目
     */
    public function GetEvaluateTopic(){

        //判断婚纱/儿童版，婚纱版跳转评价列表
        if(config('IS_CHILD') === false){
            return json(['code'=>204,'msg'=>'婚纱版VIP，跳转待评价列表']);
        }

        $params  = input('');
        $orderId = input('order_id');  //接取订单id

        if(!$orderId){
            return json(['code'=>201,'msg'=>'没有获取到订单号！']);
        }

        //订单详情
        $orderInfo = controller('Order','lib')->getErpOrderInfo($params);
        $orderInfo = $orderInfo['data'];

        //当前用户应评价环节
        if($orderInfo['server7'] == 2){         //取件状态
            $server = 3;
        }elseif($orderInfo['server5'] == 2){    //选片状态
            $server = 2;
        }elseif($orderInfo['server4'] == 2){    //拍照状态
            $server = 1;
        }else{
            $server = 0;
        }

        //订单评价到哪个环节
        $usertype = controller('order','lib')->GetUserLink($orderId);
        if($server == 0){
            $typeId = 0;
        }elseif($server >= $usertype){
            $typeId = $usertype;
        }else{
            $typeId = $server;
        }

        if($typeId == 0){
           return json(['code'=>202,'msg'=>'您还未到评价环节，赶快预约拍照吧！']);
        }
        // $typeId= 1;
        //用户已评价过
        $res = model('vip/McEvaluationQuestionnaireUser')->isFillIn($orderId, $typeId);
        
        //题目
        $list = model('vip/McEvaluationQuestionnaire')->getBrandIdTypeIdData($this->brandId, $typeId);
        foreach ($list as $k => $v) {
            $list[$k]['answer'] = model('vip/McEvaluationQuestionnaireAnswer')->getEqIdData($v['id']);  //答案列表
            if($res){
                $answer = controller('order','lib')->GetUserAnswer($orderId,$v['id'],$typeId,$this->userId); //答题答案
                foreach ($list[$k]['answer'] as $k2 => $v2) {
                    if($v2['id'] == $answer['eqa_id']){
                        $list[$k]['answer'][$k2]['is_set'] =  1;    //用户选择的答案
                    }
                }
            }
        }

        //用户当前环节是否已经评价过
        if($res){
            $is_set = 1;
        }else{
            $is_set = 2;
        }

        //当前环节名称
        switch ($typeId) {
            case 1:
                $title = '拍照评价';
                break;
            case 2:
                $title = '选片评价';
                break;
            case 3:
                $title = '取件评价';
                break;
        }
        if($list){
            return json(['code'=>200,'msg'=>'success','data'=>$list,'title'=>$title,'typeid'=>$typeId,'is_set'=>$is_set]);
        }else{
            return json(['code'=>202,'msg'=>'该环节无题目，请联系客服设置！']);
        }
    }

    /**
     *  获取订单评价列表
     */
    public function reloadEvaluateList(){
        $params = input('');

        $orderId = input('order_id');  //接取订单id

        if(!$orderId){
            return json(['code'=>201,'msg'=>'没有获取到订单号！']);
        }

        $data = controller('order','lib')->reloadEvaluateList($orderId);

        return json($data);
    }

    /**
     *  获取评价题目列表
     */
    public function getEvaluationSet(){

        $pftype = input('pftype');  //评价环节type
        $mainid = input('mainid');  //评价环节id
        $order_id = input('order_id');  //评价环节id

        if(!$pftype){
            return json(['code'=>201,'msg'=>'没有获取到所评环节！']);
        }

        if(!$mainid){
            return json(['code'=>201,'msg'=>'没有获取到所评环节ID！']);
        }

        //获取评价列表判断 当前环节是否已评
        $data = controller('order','lib')->reloadEvaluateList($order_id);
        $dataKey = '';
        switch ($pftype) {
            case '拍摄完成':
                $dataKey = 'paizhao';
                break;
            case '选片完成':
                $dataKey = 'xuanpian';
                break;
            case '订单完成':
                $dataKey = 'dingdanover';
                break;
            default:
                $dataKey = '';
                break;
        }

        foreach ($data['data'][$dataKey] as $key => $value) {
            if($value['zid'] == $mainid){
                $pjid = $value['pjid'];
            }
        }
        if($pjid){
            $data = controller('order','lib')->getYiEvaluationInfo(['orderid'=>$order_id,'mainid'=>$mainid,'scoretype'=>$pftype]);
        }else{
            $data = controller('order','lib')->getEvaluationSet($pftype,$mainid,$order_id);
        }

        return json($data);
    }

    /**
     * 评论提交
     */
    public function addEvaluationInfo(){

        $params = request()->post();

        if(!$params['count']){
            return json(['code'=>202,'msg'=>'暂无题目可评价！']);
        }
        $data = [];
        $scoreinfo = [];    //评分项目
        $scoreindex = [];    //评分项目id
        $scorecount = [];    //评分数
        $scorename = [];    //评分选项名称
        for ($key=0; $key < $params['count']; $key++) { 
            if(!$params['scorecount_'.$key]){
                return json(['code'=>201,'msg'=>'第'.($key+1).'道题目请选择!']);
            }
            $scoreinfo[$key] = $params['scoreinfo_'.$key];
            $scoreindex[$key] = $params['scoreindex_'.$key];
            $scorecount[$key] = $params['scorecount_'.$key]==1?'0':$params['scorecount_'.$key];
            if($params['scorecount_'.$key]==10){
                $scorename[$key] = '非常满意';
            }else if($params['scorecount_'.$key]==5){
                $scorename[$key] = '满意';
            }else if($params['scorecount_'.$key]==1){
                $scorename[$key] = '一般';
            }else if($params['scorecount_'.$key]=='-10'){
                $scorename[$key] = '不满意';
            }
        }
        $data['mainid'] = $params['mainid'];
        $data['scoretype'] = $params['scoretype'];
        $data['scoretypeid'] = $params['scoretypeid'];
        $data['orderid'] = $params['order_id'];
        $data['scoreinfo'] = implode(';',$scoreinfo);
        $data['scoreindex'] = implode(';',$scoreindex);
        $data['scorecount'] = implode(';',$scorecount);
        $data['scorename'] = implode(';',$scorename);
        $data['scoreremarks'] = $params['scoreremarks'];

        $res = controller('order','lib')->addEvaluationInfo($data);

        return json($res);
    }

    /**
     * 客户评价
     */
    public function SetEvaluateSnawer(){
        $data = request()->post();
        $res = $this->saveData($data['orderid'],$data['typeid']);
        return json($res);
    }

    /*
     * 拍照排程 选择拍照店
     * 标准版有拍照排程功能 ，六加一版没有
     */
    public function choosePhotoShop(){

        $p_id   = input('p_id');//排程id
        $orderId = input('orderId');
        $fc = input('fc');//服次
        $area = input('area');//客户分区
        $customerid = input('customerid');//客资id
        $package_name = input('package_name');
        $zltype = input('zltype');
        $photo_shop_code = input('photo_shop_code');
        $photo_shop_name = input('photo_shop_name');

        $param = ['package_name' => $package_name];

        $res = controller('Order','lib')->getPackageSetInfo($param);

        if($res['code'] == 200){
            $resInfo = $res['data'];
            $shops = $resInfo[0]['xspshop_code'];

            $shopCodes = $shops ? trim($shops,',') : '';
            $shopCodeArr = $shops ? explode(',',$shops) : '';
            if($shopCodes){
                $shopList = controller('Order','lib')->get_shop(['shop_code'=>$shopCodes]);
                //$shopList = db('s_shop_info')->where('shop_code','in',$shopCodeArr)->select();

                $vipShop = db('s_shop_info')->where('shop_code','in',$shopCodeArr)->select();

                $vipShopList = [];
                foreach($vipShop as $k => $v){
                    $vipShopList[$v['shop_code']]['shop_tel'] = $v['shop_tel'];//店面电话
                    $vipShopList[$v['shop_code']]['photo_notice'] = $v['photo_notice'];//拍摄须知
                    $vipShopList[$v['shop_code']]['shop_info_img'] = $v['shop_info_img'];//服务详情
                }
            }

        }

        $this->assign([
            'p_id'  => $p_id,
            'orderId' => $orderId,
            'fc'    => $fc,
            'area'  => $area,
            'customerid' => $customerid,
            'shopList'   => $shopList,
            'vipShopList' => $vipShopList,
            'zltype' => $zltype,
            'photo_shop_name'=>$photo_shop_name,
            'photo_shop_code'=>$photo_shop_code
        ]);

        return view('Order/choosephotoshop');

    }

    /*
     * 拍照排程 选择时间页面
     */
    public function choosePhotoDate(){

        $p_id   = input('p_id');//排程id
        $orderId = input('orderId');
        $fc = input('fc');//服次
        $area = input('area');//客户分区
        $customerid = input('customerid');//客资id
        $shop_code = input('photo_shop_code');//拍照店
        $shop_name = input('photo_shop_name');//拍照店名称
        $zltype = input('zltype');//区分婚纱儿童

        $erp = config('ext.app_config');  //读取erp配置文件
        $paiUrl = $erp['sx_erp']['addr'];  //调用url

        $nowDate = date('Y-m-d');

        //本月排程情况
        $pcRes = controller('Order','lib')->getMonthPc($shop_code,$area,$nowDate);
        if($pcRes['code'] == 200){
            $monthPC = $pcRes['data'];
        }

        //需提前几天预约排程
        $canUrl = $paiUrl.'SX_ChildErpAppNew/VIP_ET_PC_Advanceday?Token=^******^';
        $canRes = requestErp($canUrl,'');
        $canDay = $canRes['Data'][0]['onlinephotoday'] ? $canRes['Data'][0]['onlinephotoday'] : 0;

        $endDate = date("Y-m-d",strtotime("$nowDate +".$canDay." day"));
        $year = date('Y', strtotime($endDate));
        $month = date('m', strtotime($endDate));
        $day = date('d', strtotime($endDate));

        $this->assign('zltype',$zltype);
        $this->assign(['monthPC'=>json_encode($monthPC),'canDay'=>$canDay]);
        $this->assign(['year'=>$year,'month'=>$month,'day'=>$day]);
        $this->assign(['p_id'=>$p_id,'orderId'=>$orderId,'fc'=>$fc,'area'=>$area,'customerid'=>$customerid,'shop_code'=>$shop_code,'shop_name'=>$shop_name]);

        return $this->fetch('Order/choosephotodate');
    }


    /*
     * ajax获取某月排程信息
     */
    public function getMonthPc(){
        $year = input('year');
        $month = input('month');
        $shop_code = trim(input('shop_code'));
        $area = trim(input('area'));
        $canDay = input('canDay');
        $zltype = input('zltype');

        if(!$shop_code){
            return ['code'=>201,'msg'=>'未获取到店面code'];
        }

        if(!$area){
            return ['code'=>201,'msg'=>'未获取到客户分区'];
        }

        $month = strlen($month)==1?'0'.$month : $month;
        $date = $year.'-'. $month .'-01';

        //$erp = config('ext.app_config');  //读取erp配置文件
        //$paiUrl = $erp['sx_erp']['addr'];  //调用url

        //本月排程情况
        $pcRes = controller('Order','lib')->getMonthPc($shop_code,$area,$date,$zltype);
        //print_r($pcRes);die;
        if($pcRes['code'] !== 200){
            return $pcRes;
        }

        $monthPC = $pcRes['data'];
        //去除日期中间的零（例：2019-05-02 => 2019-5-2）
        foreach ($monthPC as $k => $v) {
            $monthPC[$k]['riqi'] = date('Y-n-j', strtotime($v['riqi']));
        }

        //最早可排日期
        $canDay = $canDay ? $canDay : 0;
        $nowDate = date('Y-m-d');
        $endDate=date("Y-m-d",strtotime("$nowDate +".$canDay." day"));
        $year = date('Y', strtotime($endDate));
        $month = date('m', strtotime($endDate));
        $day = date('d', strtotime($endDate));

        return ['code'=>200,'data'=>['monthPC'=>$monthPC,'year'=>$year,'month'=>$month,'day'=>$day]];

    }

    /*
     * ajax获取某天可排程时间点
     */
    public function getTimePc(){
        $riqi = trim(input('riqi'));
        $shop_code = trim(input('shop_code'));
        $area = trim(input('area'));

        if(!$shop_code){
            return ['code'=>201,'msg'=>'未获取到店面code'];
        }

        if(!$area){
            return ['code'=>201,'msg'=>'未获取到客户分区'];
        }

        //某天可排程时间点
        $pcRes = controller('Order','lib')->getTimePc($shop_code,$area,$riqi);
        //print_r($pcRes);die;
        if($pcRes['code'] !== 200){
            return $pcRes;
        }

        $timeArr = $pcRes['data'];

        return ['code'=>200,'data'=>$timeArr];

    }

    /*
     * erp拍照排程
     */
    public function setErpPhotoPC(){
        $data = input('');
        //print_r($data);die;
        if(!$data['p_id']){
            return ['code'=>201,'msg'=>'未获取到此拍照信息'];
        }

        if(!$data['orderId']){
            return ['code'=>202,'msg'=>'未获取到此订单信息'];
        }

        if(!$data['fc']){
            return ['code'=>203,'msg'=>'未获取到此服次信息'];
        }

        if(!$data['customerid']){
            return ['code'=>205,'msg'=>'未获取到此客资编号'];
        }

        $res = controller('Order','lib')->setErpPhotoPC($data);
        return $res;
    }


    /*
     * 选片排程 选择时间页面
     * 标准版有选片排程功能 ，六加一版没有
     */
    public function chooseXpDate(){

        $x_id   = input('x_id');//排程id
        $orderId = input('orderId');
        $fc = input('fc');//服次
        $area = input('area');//客户分区
        $customerid = input('customerid');//客资id
        $shop_code = input('xp_shop_code');//拍照店
        $shop_name = input('xp_shop_name');//拍照店名称

        $erp = config('ext.app_config');  //读取erp配置文件
        $paiUrl = $erp['sx_erp']['addr'];  //调用url

        $nowDate = date('Y-m-d');


        //本月排程情况(改为页面js获取)
        /*
        $pcRes = controller('Order','lib')->getMonthXpPc($shop_code,$area,$nowDate);
        if($pcRes['code'] == 200){
            $monthPC = $pcRes['data'];
        }
        */

        //需提前几天预约排程
        /*
        $canUrl = $paiUrl.'SX_ChildErpAppNew/VIP_ET_PC_Advanceday?Token=^******^';
        $canRes = requestErp($canUrl,'');
        $canDay = $canRes['Data'][0]['onlinephotoday'] ? $canRes['Data'][0]['onlinephotoday'] : 0;
        */

        //$endDate = date("Y-m-d",strtotime("$nowDate +".$canDay." day"));
        $endDate = $nowDate;
        $year = date('Y', strtotime($endDate));
        $month = date('m', strtotime($endDate));
        $day = date('d', strtotime($endDate));

        //$this->assign(['monthPC'=>json_encode($monthPC),'canDay'=>$canDay]);
        $this->assign(['year'=>$year,'month'=>$month,'day'=>$day]);
        $this->assign([
            'x_id' => $x_id,
            'orderId'=> $orderId,
            'fc'     => $fc,
            'area'   => $area,
            'customerid' => $customerid,
            'shop_code'  => $shop_code,
            'shop_name'  => $shop_name]);

        return $this->fetch('Order/choosexpdate');
    }

    /*
     * ajax获取某月排程信息
     */
    public function getMonthXpPc(){
        $year = input('year');
        $month = input('month');
        $shop_code = trim(input('shop_code'));
        $area = trim(input('area'));
        $canDay = input('canDay');

        if(!$shop_code){
            return ['code'=>201,'msg'=>'未获取到店面code'];
        }

        if(!$area){
            return ['code'=>201,'msg'=>'未获取到客户分区'];
        }

        $month = strlen($month)==1?'0'.$month : $month;
        $date = $year.'-'. $month .'-01';

        //$erp = config('ext.app_config');  //读取erp配置文件
        //$paiUrl = $erp['sx_erp']['addr'];  //调用url

        //本月排程情况
        $pcRes = controller('Order','lib')->getMonthXpPc($shop_code,$area,$date);
        //print_r($pcRes);die;
        if($pcRes['code'] !== 200){
            return $pcRes;
        }

        $monthPC = $pcRes['data'];
        //去除日期中间的零（例：2019-05-02 => 2019-5-2）
        foreach ($monthPC as $k => $v) {
            $monthPC[$k]['riqi'] = date('Y-n-j', strtotime($v['riqi']));
        }

        //最早可排日期
        $canDay = $canDay ? $canDay : 0;
        $nowDate = date('Y-m-d');
        $endDate=date("Y-m-d",strtotime("$nowDate +".$canDay." day"));
        $year = date('Y', strtotime($endDate));
        $month = date('m', strtotime($endDate));
        $day = date('d', strtotime($endDate));

        return ['code'=>200,'data'=>['monthPC'=>$monthPC,'year'=>$year,'month'=>$month,'day'=>$day]];

    }

    /*
     * erp选片排程
     */
    public function setErpXpPC(){
        $data = input('');
        //print_r($data);die;
        if(!$data['x_id']){
            return ['code'=>201,'msg'=>'未获取到此选片信息'];
        }

        if(!$data['orderId']){
            return ['code'=>202,'msg'=>'未获取到此订单信息'];
        }

        if(!$data['fc']){
            //return ['code'=>203,'msg'=>'未获取到此服次信息'];
        }

        if(!$data['customerid']){
            return ['code'=>205,'msg'=>'未获取到此客资编号'];
        }

        $res = controller('Order','lib')->setErpXpPC($data);
        return $res;
    }




    /*
     * 解绑订单
     */
    public function delOrder(){
        $order_numner = input('order_number');
        if(!$order_numner){
            return ['code'=>201,'msg'=>'未获取到订单信息，请稍后重试'];
        }

        $res = db('m_order')
            ->where('order_number',$order_numner)
            ->update(['delete_time'=>date('Y-m-d H:i:s')]);
        if($res === false){
            return ['code'=>204,'msg'=>'删除订单失败'];
        }else{
            return ['code'=>200,'msg'=>'success'];
        }
    }

    /*
     * 获取erpVIP卡信息
     */
    public function getErpVipInfo(){
        $orderId = input('order_id');
        $orderData = db('m_order')->where('order_number',$orderId)->find();
        $phone = $orderData['phone'];
        //$phone = '17736249294';

        $load_type = input('load_type');

        if(!$phone){
            return ['code'=>201,'msg'=>'未获取卡号（妈妈手机号）'];
        }

        $res = controller('order','lib')->getErpVipInfo(['phone'=>$phone,'load_type'=>$load_type]);

        return $res;

    }

    /*
     * 检测是否有先睹为快照片
     */
    public function checkSneakPeek(){
        $orderId = input('order_id');
        $fc = input('fc');
        //检测是否有先睹为快照片
        $sneakPeek = controller('Order','lib')->getSneakPeek(['order_id'=>$orderId,'fc'=>$fc]);

        if(!empty($sneakPeek)){
            return ['code'=>200,'msg'=>'有先睹为快照片','data'=>$sneakPeek];
        }else{
            return ['code'=>201,'msg'=>'没有上传先睹为快照片！'];
        }
    }


    /*
     * 先睹为快
     */
    public function sneakPeek(){

        if(request()->isAjax()){
            $orderId = input('orderId');
            $fc = input('fc');

            if(!$orderId||!$fc){
                return ['code'=>201,'msg'=>'未获取到订单信息！'];
            }

            $text = trim(input('text'));
            $content = filter_emoji($text);
            //preg_match_all('/[\w\x{4e00}-\x{9fa5}]+/u',$text,$newText);
            //$content = $newText && $newText[0] ? implode('',$newText[0]) : '';

            $addData = [
                'orderId' => $orderId,
                'fc' => $fc,
                'cameraman' => trim(input('cameraman')),
                'score'   => (int)input('score'),
                'text'    => $content
            ];

            $check = db('m_order_cameraman_score')->where(['orderId'=>$orderId,'fc'=>$fc])->find();
            if($check){
                $addData['update_time'] = date('Y-m-d H:i:s');
                $res = db('m_order_cameraman_score')->where(['orderId'=>$orderId,'fc'=>$fc])->update($addData);
            }else{
                $addData['add_time'] = date('Y-m-d H:i:s');
                $res = db('m_order_cameraman_score')->insert($addData);
            }

            if($res){
                return ['code'=>200,'msg'=>'评价成功！'];
            }else{
                return ['code'=>201,'msg'=>'评价失败'];
            }
        }

        //页面
        $orderId = input('orderId');
        $fc = input('fc');
        $shop_code = input('shop_code');//订单店

        $orderUserId = db('m_order')->where('order_number',$orderId)->value('user_id');//订单主人userid
        $scoreInfo = db('m_order_cameraman_score')->where(['orderId'=>$orderId,'fc'=>$fc])->find();//摄影师评分

        //先睹为快照片
        $photoData = controller('order','lib')->getSneakPeek(['order_id'=>$orderId,'fc'=>$fc]);
        $photoArr = $photoData['photo'];     //照片
        //展示完照片后，多展示一页 仅此页可评论送礼物，以最后一张照片做背景
        //$photoArr[] = end($photoArr);
        $cameraman = $photoData['cameraman'];//摄影师
        $photo_shop_code = $photoData['photo_shop_code'];//拍摄店

        $this->assign([
            'orderId'  => $orderId,
            'fc'       => $fc,
            'shop_code'=> $shop_code,//订单店
            'photo_shop_code' => $photo_shop_code,//拍照店
            'photoArr' => $photoArr,
            'cameraman'=> $cameraman,
            'scoreInfo'=> $scoreInfo,
            'orderUserId' => $orderUserId,
        ]);
        return $this->fetch('Order/sneakpeek');
    }

    //获取弹幕祝福语
    public function getDanMu(){
        $orderId = input('orderId');
        $fc = input('fc');
        //已发弹幕
        $getWish = db('m_order_wish')
            ->where(['wish.orderId'=>$orderId,'fc'=>$fc])
            ->alias('wish')
            ->join('m_users user','wish.user_id = user.id','left')
            ->field('wish.*,user.username,user.simg')
            ->order('wish.add_time asc')
            ->select();
        $wishStr = [];
        foreach($getWish as $k => $v){
            if($k%2==0){
                $state = 0;
            }else{
                $state = 1;
            }
            $wishStr[] = [
                'headimg' => $v['simg'],
                'message' => $v['wish'],
                'vote'    => '',
                'id'      => $v['id'],
                'state'   => $state,
            ];

        }

        return ['code'=>200,'data'=>$wishStr];

    }


    /*
     * 先睹为快相册 添加祝福
     */
    public function addWish(){

        $orderId = input('orderId');
        $fc = input('fc');
        $text = input('text');
        $data = [
            'orderId' => $orderId,
            'fc'      => $fc,
            'wish'    => $text,
            'user_id' => session('userid'),
            'add_time'=> date('Y-m-d H:i:s'),
        ];
        $res = db('m_order_wish')->insert($data);
        if($res){
            return ['code'=>200,'msg'=>'发送祝福成功！'];
        }else{
            return ['code'=>201,'msg'=>'发送祝福失败'];
        }
    }

    /*
     * 赠送免费礼物
     */
    public function giveFreeGift(){
        $orderId = input('orderId');
        $fc = input('fc');
        $gift_id = input('gift_id');

        //免费礼物没人只可送一次
        $exist = db('m_order_gift')->where(['gift_id'=>$gift_id,'give_userid'=>session('userid'),'orderId'=>$orderId,'fc'=>$fc])->find();
        if($exist){
            return ['code'=>202,'msg'=>'您已赠送过免费礼物了！'];
        }

        $order = db('m_order')->where('order_number',$orderId)->find();

        if($order['user_id'] == session('userid')){
            return ['code'=>203,'msg'=>'免费礼物不可以赠送自己哦！'];
        }

        $gift = db('m_gift')->where('id',$gift_id)->order('sort asc')->find();

        $addData = [
            'orderId'    => $orderId,
            'fc'         => $fc,
            'gift_id'    => $gift_id,
            'gift_name'  => $gift['name'],
            'gift_img'   => $gift['img'],
            'gift_money' => $gift['money'],
            'gift_score' => $gift['score'],
            'give_userid'=> session('userid'),//操作赠送的人
            'get_userid' => $order['user_id'],
            'add_time'   => date('Y-m-d H:i:s'),
            'pay_time'   => date('Y-m-d H:i:s'),  //有pay_time 代表赠送成功
        ];
        $res = db('m_order_gift')->insert($addData);

        //操作赠送的人获得积分
        AddScore($addData['give_userid'],'',$addData['gift_score'],20,'打赏礼物积分');

        if($res){
            return ['code'=>200,'msg'=>'赠送成功！'];
        }else{
            return ['code'=>201,'msg'=>'赠送失败'];
        }
    }


    /*
     * 检测礼物是否支付成功
     */
    public function checkGiftBuy(){
        $pay_number = input('pay_number');

        $orderId = input('orderId');
        $fc = input('fc');

        //防止单号中有空格等
        $orderId = get_escape_str($orderId);

        $payStatus = sx_call('5a5ca00c81db4',['order_no'=>$pay_number]);
        if($payStatus['code'] == 200){

            if($payStatus['data']['pay_status'] == 'PAYED'){

                db()->startTrans();
                try{

                    $gift_status = db('m_order_gift')->where('pay_number',$pay_number)->find();

                    //若状态未支付，则修改支付状态，充值会员卡
                    if(!$gift_status['pay_time']){

                        $gift = db('m_order_gift')->where('pay_number',$pay_number)->update(['pay_time'=>date('Y-m-d H:i:s')]);

                        //操作赠送的人获得积分
                        AddScore($gift['give_userid'],'',$gift['gift_score'],20,'打赏礼物积分');

                        $gift_money = db('m_order_gift')->where('pay_number',$pay_number)->value('gift_money');

                        //礼物支付金额直接进到erp会员卡
                        $erp = config('ext.app_config');
                        $apiUrl = $erp['sx_erp']['addr'];
                        $url = $apiUrl . '/SX_ChildVipApi/SX_VIPDaShang?Token=^******^&OrderId='.$orderId.'&Money='.$gift_money.'&currentfc='.$fc;

                        $response = requestERP($url, '');  //调用erp接口

                        //调取不成功待处理
                        if ($response['Code'] != 200) {
                            payment_log('送礼物到会员卡余额','orderId-'.$orderId.'&fc-'.$fc.'&money-'.$gift_money,json_encode($response));
                            //self::errorLog($url, json_encode($response));
                        }
                    }

                    db()->commit();
                    return ['code'=>200,'msg'=>'支付成功！'];

                }catch (Exception $e){
                    db()->rollback();
                    return ['code'=>201,'msg'=>'修改礼物支付状态失败！'];
                }

            }else{
                return ['code'=>201,'msg'=>'支付失败！'];
            }

        }else{
            return $payStatus;
        }
    }

    /*
     * 先睹为快里转客资
     */
    public function infoToCrm(){
        $name = trim(input('name'));
        $phone = input('phone');
        $consultation_type_id = input('consultation_type_id');//消费类型
        $consultation_type = input('consultation_type');

        //推荐设置
        $r_rule = db('recommend_rule')->where('brand_id',session('brand_id'))->find();
        $rule = json_decode($r_rule['rule'],true);


//        if($consultation_type == '孕妈照'){
//            $consultation_type_id = 4;
//        }

        $id = db('m_order_sign_up')->insertGetId([
            'orderId'   => input('orderId'),
            'name'      => $name,
            'user_id'   => session('userid'),
            'phone'     => $phone,
            'consultation_type_id' => $consultation_type_id,
            'consultation_type' => $consultation_type,
            'create_time' => date('Y-m-d H:i:s'),
        ]);

        if($id){

            $param = [
                'dj_staff_id'   => $rule['staff_id'],
                'dj_staff'      => $rule['staff_name'],
                'shop_code'     => $rule['shop_code'] ? $rule['shop_code'] : '',
                'shop_name'     => $rule['shop_name'] ? $rule['shop_name'] : '',
                'info'          => $name.'-'.$phone,
                'customer_channel'    => $rule['xdwk_channel_name'] ? $rule['xdwk_channel_name'] :'',
                'customer_channel_id' => $rule['xdwk_channel_id'] ? $rule['xdwk_channel_id'] :'',
                'consultation_type'   => $consultation_type ? $consultation_type :'',
                'consultation_type_id'=> $consultation_type_id ? $consultation_type_id :'',
            ];

            $crmRes = sx_call('5b286c6bbf298',$param,'sx_crm');
            if($crmRes['code'] != 200){
                db('m_order_sign_up')->where('id',$id)->update(['error_msg'=>$crmRes['msg']]);
            }
            return ['code'=>200,'msg'=>'提交成功！'];
        }else{
            return ['code'=>200,'msg'=>'提交失败，请稍后重试！'];
        }

    }

    /*
     * 先睹为快-下载底片
     */
    public function photoDetail(){
        $orderId = input('orderId');
        $fc = input('fc');
        $sneak = controller('Order','lib')->getSneakPeek(['order_id'=>$orderId,'fc'=>$fc]);
        $photoArr = $sneak['photo'];

        $this->assign([
            'photoArr' => $photoArr,
        ]);
        return $this->fetch('Order/photodetail');
    }


    /** http://vip.sx.com:8080/front/order/serviceEvaluation?order_id=37&type_id=1
     * 服务评价
     * @return mixed
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function serviceEvaluation()
    {
        //判断当前用户是否答过题
        $orderId = input('order_id');
        //$orderId = 'SY18011800002';
        
        //订单详情
        $OrderData = controller('order','lib')->getErpOrderInfo(['order_id'=>$orderId]);

        //当前用户应评价环节
        if($OrderData['code'] == 200){
            $OrderInfo = $OrderData['data'];
        }
        if ($OrderInfo['server7'] == 2) {
            $server = 3;
        }elseif ($OrderInfo['server5'] == 2) {
            $server = 2;
        }elseif ($OrderInfo['server4'] == 2){
            $server = 1;
        }

        //订单评价到哪个环节
        $usertype = controller('order','lib')->GetUserLink($orderId);
        if($server >= $usertype){
            $typeId = $usertype;
        }else{
            $typeId = $server;
        }

        // $typeId = intval(input('type_id'));
        $order_money = input('order_money');
        /*if ($orderId < 1) {
            $this->error('参数错误——1');
        }*/
        if ($typeId < 1) {
            $this->error('参数错误——2');
        }
        $res = model('vip/McEvaluationQuestionnaireUser')->isFillIn($orderId, $typeId);
        if ($res) {
            $url = url('Order/serviceEvaluation2') . '?order_id=' . $orderId . '&type_id=' . $typeId . '&order_money=' . $order_money;
            $this->redirect($url);
            return;
        }
        if (request()->isGet()) {
            $list = model('vip/McEvaluationQuestionnaire')->getBrandIdTypeIdData($this->brandId, $typeId);
            foreach ($list as $k => $v) {
                $list[$k]['answer'] = model('vip/McEvaluationQuestionnaireAnswer')->getEqIdData($v['id']);
            }
            $data = model('vip/McPromptText')->getWhereData($this->brandId, $stats);
            switch ($typeId) {
                case 1:
                    $stats = 9;
                    $title = '服务评价';
                    break;
                case 2:
                    $stats = 2;
                    $title = '选片评价';
                    break;
                case 3:
                    $stats = 1;
                    $title = '取件评价';
                    break;
            }
            $this->assign('order_id', $orderId);
            $this->assign('order_money', $order_money);
            $this->assign('title', $title);
            $this->assign('data', $data);
            $this->assign('list', $list);
            $this->assign('type_id', $typeId);
            $this->assign('style', $typeId);
            return $this->fetch('Order/serviceEvaluation');
        }
        if (request()->isAjax()) {
            $res = $this->saveData($orderId, $typeId);
            return json($res);
        }
    }

    /**
     * 已经答过题
     * @return mixed
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function serviceEvaluation2()
    {
        //判断当前用户是否答过题
        $orderId = input('order_id', 0, 'trim');
        $typeId = input('type_id', '', 'intval');
        $order_money = input('order_money');
        if (empty($orderId)) {
            $this->error('参数错误——1');
        }
        if ($typeId < 1) {
            $this->error('参数错误——2');
        }
        //$this->assign('title','服务评价');
        $this->assign('style', 5);
        $res = model('vip/McEvaluationQuestionnaireUser')->isFillIn($orderId, $typeId);
        if (empty($res)) {
            $url = url('Order/serviceEvaluation2') . '?order_id=' . $orderId . '&type_id=' . $typeId . '&order_money=' . $order_money;
            $this->redirect($url);
            return;
        }
        switch ($typeId) {
            case 1:
                // $stats = 9;
                $title = '服务评价';
                break;
            case 2:
                // $stats = 2;
                $title = '选片评价';
                break;
            case 3:
                // $stats = 1;
                $title = '取件评价';
                break;
        }
        $this->assign('order_money', $order_money);
        $this->assign('title', $title);
        $this->assign('order_id', $orderId);
        $this->assign('style', $typeId);
        return $this->fetch('Order/serviceEvaluation2');
    }

    /**
     * 保存数据
     * @return array
     * User: zhaibaoming
     * Date: ${DATE}
     */
    private function saveData($orderId,$typeId)
    {
        $resultData = ['code' => 0, 'msg' => '',];
        // $type_id    = intval(input('post.type_id', 0));
        // $name       = trim(input('post.name', 0));
        // $phone      = trim(input('post.phone', 0));
        if ($typeId < 1) {
            $resultData['msg'] = '参数错误';
            return $resultData;
        }
        // if (empty($name)) {
        //     $resultData['msg'] = '姓名不能为空';
        //     return $resultData;
        // }
        // if (mb_strlen($name, 'utf-8') > 10) {
        //     $resultData['msg'] = '名字不能大于10个字';
        //     return $resultData;
        // }
        // $regex = "/^1[34578]\d{9}$/";
        // preg_match($regex, $phone, $res);
        // if (!$res[0]) {
        //     $resultData['msg'] = '手机错误';
        //     return $resultData;
        // }
        $userid = Session::get("memid");
        $data = request()->post();
        $userList = $answerList = [];
        $userList['order_id'] = $data['orderid'];
        /*$userList['name'] = $name;
        $userList['phone'] = $phone;*/
        $userList['type_id'] = $data['typeid'];
        $userList['userid'] = $userid;
        $Db = model('vip/McEvaluationQuestionnaireUser');
        $Db->startTrans();
        $id = model('vip/McEvaluationQuestionnaireUser')->addData($userList);
        if ($id < 1) {
            $Db->rollback();
            $resultData['msg'] = '数据错误_1';
            return $resultData;
        }
        for ($i = 0; $i < $this->titleUpperLimit; $i++) {
            $answerList['eq_id'] = intval($data['eq_id_' . $i]);
            if (empty($answerList['eq_id'])) {
                continue;
            }

            //事物 保存
            $answerList['equ_id'] = $id;
            $answerList['eqa_id'] = intval($data['eqa_id_' . $i]);
            if ($answerList['eqa_id'] < 1) {
                $j = ++$i;
                $Db->rollback();
                $resultData['msg'] = '第' . $j . '题没有选择答案';
                return $resultData;
            }
            $res = model('vip/McEvaluationQuestionnaireUserAnswer')->addData($answerList);
            if ($res < 1) {
                $Db->rollback();
                $resultData['msg'] = '数据错误_2';
                return $resultData;
            }
        }
       /* $userid = Session::get("memid");
        $total_score = getScoreRule(['userid'=>$userid]);
        $total_score = $total_score?$total_score:0;
        switch ($typeId) {
            case 1:
                // $stats = 9;
                $title = '服务评价';
                break;
            case 2:
                // $stats = 2;
                $title = '选片评价';
                break;
            case 3:
                // $stats = 1;
                $title = '取件评价';
                break;
        }
        AddScore($userid,Session::get("phoneid"),$total_score,'16',$title);
        if($AddScore === false){
            db()->rollback();
            $resultData['msg'] = '积分奖励增加失败';
            return $resultData;
        }*/
        $Db->commit();
        $resultData['code'] = 200;
        return $resultData;
    }



    /**
     * 方法描述: 调取erp错误处理流程
     * @return payCode
     * @author Zhaojiepeng<zhaojiepeng@suxuantech.cn>
     */
    private static function errorLog($url, $data)
    {
        $errorLogData = [
            'url' => $url,
            'data' => $data,
            'create_time' => date('Y-m-d H:i:s'),
            'error_count' => 1,
        ];
        $logRes = db("c_vip_save")->insert($errorLogData);   //写入错误记录日志表
        if (!$logRes) {
            return array('code' => 201, 'msg' => '数据写入失败');
        }
        return 1;
    }


    /**
     * 方法描述：订单号生成
     */
     public function rands()
    {
        $str = '1234567890';
        $randStr = str_shuffle($str);//打乱字符串
        $rands = substr($randStr, 0, 5);
        $rand = time() . Session::get("memid") . $rands;
        return $rand;
    }

}