<?php
/**
 * 用户签到控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Yan lipeng <leishaoju@suxuantech.cn>  2017年11月21日 下午3:48:53
 */
namespace app\front\controller;
use think\Db;
use think\Exception;
use think\mongo\Query;
use \think\Session;
use \think\Cache;
use app\front\controller\BaseFront;
class Signs extends \app\front\controller\BaseFront{
    /**
     * 用户签到请求
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function sign () {
        $userid = Session::get('memid');
        $phoneid = Session::get('phoneid');
        $thisTableName = 'sign_detail_' . date('Ym',time());  //当前时间表名
        $time = date('Y-m-d',strtotime("-1 day"));      //签到前一天日期
        $preTImeMouth = date('Ym',(strtotime($time)));  
        $preTableTime = "sign_detail_$preTImeMouth";  //前一天时间表名
        if(checkTableExists($preTableTime)){
            $sign_yesterday = db($preTableTime)->where('userid','=',$userid)->where('sign_time','=',$time)->find();  //查询昨天是否签到
        }else{
            $sign_yesterday = false;
        }
        
        $putTable = "sign_detail_".date('Ym',time()); //表明
        $newTime = date('Ym',strtotime(" +1 month")); //下个月表名日期
        // $nextYear = date('Y',strtotime($newTime));   //获取到下月的年份
        // $nextMouite  = date('m',strtotime($newTime)); //获取到下月的月
        //$tableName = Db::query("show tables like '%sign_detail_$newTime%'");
        // if (date('Y-m-1',time())) {   //如果签到时间为第一天，那么去进行建表
        if (!checkTableExists("sign_detail_$newTime")){
            self::getTable($newTime);  //调用建表方法
        }
        if(!checkTableExists($putTable)){
            self::getTable(date('Ym',time()));
        }
        // }
        // 签到的要写入的数据
        $signData = array(
            'userid' => $userid,
            'sign_sum' => 1,
            'sign_time' => date('Y-m-d H:i:s'),
            'sign_create' => date('Y-m-d H:i:s'),
        );
        if ($sign_yesterday) { //昨天是否签到
            $signData['sign_sum']     = $sign_yesterday['sign_sum']+1;
            $signData['sign_create']  = $sign_yesterday['sign_create'];
        }
        db()->startTrans();
        try{
            // 插入签到数据
            $res = db("$putTable")->insert($signData);
            if ($res) {
                // 获取规则积分信息
                $rule = getScoreRule(['userid'=>$userid]);
                // 获取用户信息
                $userinfo = getUserInfo(['userid'=>$userid]);
                // 判断当前日期是否是结婚日期或生日或者是首次登陆
                if($userinfo){
                    $todayDate = date('md',time());
                    $year=date("Y-01-01 0:0:0",time());
                    $rule_minute = "";
                    if($userinfo['brithday'] && substr($userinfo['brithday'],4) == $todayDate && $phoneid){ //新增 绑定手机号才可享用该积分优惠
                        $brithsign = db("minute_log")->where("m_executor",$userid)->where("m_type",1314)->where("m_time",">",$year)->find(); //生日
                        if(!$brithsign){
                            $rule_minute = $rule['brithday_sign'];
                            $ruleName = 1314;
                            $trueName = '生日';    
                        }
                    }else if($userinfo['merryday'] && substr($userinfo['merryday'],4) == $todayDate && !$regsign && $phoneid){//新增 绑定手机号才可享用该积分优惠
                        $regsign = db("minute_log")->where("m_executor",$userid)->where("m_type",520)->where("m_time",">",$year)->find(); //结婚纪念日
                        if(!$regsign){
                            $rule_minute = $rule['merryday_sign'];
                            $ruleName = 520;
                            $trueName = '结婚纪念日';    
                        }
                    }else if(!$userinfo['total_sign']){
                        $rule_minute =  $rule['first_sign'];
                        $trueName = '首次登陆';
                        $ruleName = 4;
                    }else{
                        $rule_minute = $rule['everyday_sign'];  //每日签到
                        $trueName = '每日签到';
                        $ruleName = 1;
                    }
                    if(!$rule_minute){
                        $rule_minute = $rule['everyday_sign'];  //每日签到
                        $trueName = '每日签到';
                        $ruleName = 1;  
                    }
                }
                //签到信息成功将数据存到m_users表中
                $newUserinfo = ['score'=>(int)$rule_minute,'total_sign'=>1,'userid'=>$userid,'today'=>true,'phoneid'=>$phoneid,'rulename'=>$ruleName,'truename'=>$trueName];
                $data = self::upUserinfo($newUserinfo);
                //$data = db('m_users')->where('id','=',$userid)->setInc('total_sign',1);
                if ($data) {
                    $sign_sum = Session::get('sign_sum');
                    Session::set('sign_sums',$sign_sum+1);
                    $total_sign = Session::get('total_sign');
                    Session::set('total_sign',$total_sign+1);
                    // 成长值计算 ====
                    /*$result = growthMemRecord($userid,2,'');
                    if (!$result) {
                        $gro = getGrowthRule(['userid'=>$userid]);
                        if($gro && $gro['erveryday_sign']){
                            growthDetailed($userid,$gro['erveryday_sign'],2,'',$phoneid);
                        }
                    }*/

                    //清除今日签到总人数缓存
                    $todayDate = date('Y-m-d', time());
                    cache('sign_total_' . $todayDate,null);

                    $array = array('code'=>1,'msg'=>'签到添加信息成功','status'=>$rule_minute);
                    db()->commit();
                    return json($array);
                }else{
                    db()->rollback();
                    $array = array('code'=>0,'msg'=>'签到添加信息失败');
                    return json($array);    
                }
            } else {
                db()->rollback();
                $array = array('code'=>0,'msg'=>'签到添加信息失败');
                return json($array);
            }
        }
        catch(\Exception $e){
                db()->rollback();
                $array = array('code'=>0,'msg'=>'签到添加信息失败');
                return json($array);
            }
    }

    /**
     * 用户补签
     * @param  String  $data   添加的数据
     * @return json   返回影响行数，成功或者失败
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function signRepair () {
        $userid = Session::get('memid');  //全局获取用户id
        $supplyScore = (int)input('post.scores');
        $phoneid = Session::get('phoneid');
        $userinfo    = getUserInfo(['userid'=>$userid]);
        if ($userinfo['total_score'] < $supplyScore) {
            $array = array('code'=>2,'msg'=>'用户积分不足');
            return json($array);
        }
        $day = input('post.day');

        $findDay = $day;
        $day = str_replace('-','',$day);
        if(strlen($day) != 8){
            $array = array('code'=>0,'msg'=>'日期非法。');
            return json($array);
        }
        
        $proTime = date('Ymd',strtotime("$day -1 day"));
        $nexTime = date('Ymd',strtotime("$day +1 day"));
        $proTableName = "sign_detail_".substr($proTime,0,6);
        $nextTableName = "sign_detail_".substr($nexTime,0,6);
        $thisTableName = "sign_detail_".substr($day,0,6);
        $daySign = db("$thisTableName")->where('userid','=',$userid)->where('sign_time','=',$findDay)->find();

        if($daySign){
            $array = array('code'=>3,'msg'=>'您已签到。');
            return json($array);
        }
        
        $signPro = db($proTableName)->where('userid','=',$userid)->where('sign_time','=',$proTime)->find();  //查询补签前一天是否签到
        //前一天没有签到的
        $signDayData = array(
            'userid' => $userid,
            'sign_sum' => 1,
            'sign_time' => $day,
            'sign_create' => $day,
        );
        if ($signPro) {
            //前一天有签到的
            $signDayData['sign_sum']    = $signPro['sign_sum']+1;
            $signDayData['sign_create'] = $signPro['sign_create'];
        } 
        Db::startTrans();
        try{
            $res = db($thisTableName)->insert($signDayData); //补签信息入库
            $sign_sum  = Session::get('sign_sums');
            Session::set('sign_sums',$sign_sum+1);
            //minuteDetailed('补签-'.$findDay,"-$supplyScore",$userid,'1',$phoneid);
            //$upData = ['total_score'=>['exp',"total_score-$supplyScore"],'total_sign'=>['exp',"total_sign+1"]];
            //$signMinute = db('m_users')->where('id','=',$userid)->update($upData);  //扣除m_users表中的数据
            
            //签到信息成功将数据存到m_users表中
            $newUserinfo = ['score'=>-$supplyScore,'total_sign'=>1,'userid'=>$userid,'phoneid'=>$phoneid,'day'=>$day,'rulename'=>'17','truename'=>"补签扣减积分"];
            $signMinute = self::upUserinfo($newUserinfo);
            if ($signMinute) {
                $sum = Session::get('total_score');
                Session::set('total_score',$sum-$supplyScore);
            }
            Db::commit();

            //清除日历缓存
            $y  = date('Y', time());
            $m  = date('m', time());
            cache('sign_days_' . $this->userId . '_' . date('Ym', strtotime($y . '-' . $m)),null);
        }catch (\Exception $e){
            Db::rollback();
        }
        if ($res) {
            $array = array('code'=>1,'msg'=>'补签成功');
            //return json($array);
        } else {
            $array = array('code'=>0,'msg'=>'补签失败');
            //return json($array);
        }
        
        
        
        $daySignSum = db("$thisTableName")->where('userid','=',$userid)->where('sign_time','=',$findDay)->find();
        $signNext = db($nextTableName)->where('userid','=',$userid)->where('sign_time','=',$nexTime)->find();  //查询补签后一天是否签到
    
        $signCreate = $signNext['sign_create'];   //赋值给签到的初始时间
        //$signCreate = substr($signCreate,0,10);
        if ($signNext) {
            //取出后一天的签到起始时间A和签到这一天的连续签到天数
            //从后一天的签到起始时间的月开始，到当前月，所有月份的当前用户的，起始签到日期是 A的。所有数据的sign_sum+签到这一天的sign_sum
            //sign_create 跟新成签到这一天的sign_create
            // $signRepairMouth = str_replace('-','',substr($signNext['sign_create'],0,7));
            $dataDayMouth = date('Y-m',strtotime($signNext['sign_create']));
            $dataNowMouth = date('Y-m',time());
            $ToStartMonth = strtotime( $dataDayMouth ); //初始月份
            $ToEndMonth   = strtotime( $dataNowMouth ); //当前月份
            while($ToStartMonth <= $ToEndMonth) {
                $tableName = 'sign_detail_' . date('Ym',$ToStartMonth);

                try{
                    $mstarttime = date('Y-m-d',strtotime($signCreate));
                    $mendtime   = date('Y-m-d',strtotime($signCreate)+86400);
                    $mw = ['userid'=>$userid,'sign_create'=>[['>=',$mstarttime],['<',$mendtime]]];
                    $res = db($tableName)->where($mw)->count();
                    if ($res == 0) {
                        break;
                    }
                    $sign_sum = Session::get('sign_sums');
                    Session::set('sign_sums',$sign_sum+1);
                    $w = ['userid'=>$userid,'sign_create'=>$signCreate];
                    if ($daySignSum) {
                        $d = ['sign_create'=>$daySignSum['sign_create'],'sign_sum'=>['exp',"sign_sum+$daySignSum[sign_sum]"]];
                    } else {
                        $d = ['sign_create'=>$findDay,'sign_sum'=>['exp',"sign_sum+$daySign[sign_sum]"]];
                    }
                    $signUpData =Db::table($tableName)
                        ->where($w)
                        ->fetchSql(false)
                        ->update($d);
                    Db::commit();
                }catch (\Exception $e){
                    Db::rollback();
                    return array('code'=>0,'msg'=>'补签失败');
                }
                $ToStartMonth =strtotime('+1 Month',$ToStartMonth);
            }
        }
        $array = array('code'=>1,'msg'=>'补签成功');
        return json($array);

    }
    /**
     * 判断累计签到奖励
     * @param  String
     * @return json
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function signGrand () {
        $userid = Session::get('memid');
        $signDay = input('post.signDay');
        $signAwaMinute = input('post.signNum');
        $res = db('sign_awa')->where(array('userid'=>$userid,'sign_day'=>$signDay,'type'=>1))->find();
        if ($res) {
            $arrs = 1;
            $this->assign('arrs',$arrs);
            $arr = array('code'=>0,'msg'=>'你已领取过此任务');
            return json($arr);
        }
        $signGrandData = array(
            'userid' => $userid,
            'sign_day' => $signDay,
            'sign_num' => $signAwaMinute,
            'create_time' => date('Y-m-d H:i:s',time()),
            'sign_type' => 3,
            'type' => 1,
        );
        //开启事务 wangyining 20180127
        db()->startTrans();
        try {
            db('sign_awa')->insert($signGrandData);
            $signDa = db()->getLastInsID();
            $data = array('awa_id'=>$signDa,'userid'=>$userid,'type'=>1);
            db('sign_get')->insert($data);
            $sum = Session::get('total_score');
            Session::set('total_score',$sum+$signAwaMinute);
            $phoneid = db('m_users_phone')->where('userid',$userid)->value('id');
            $AddScore = AddScore($userid,$phoneid,$signAwaMinute,'1','累计签到'.$signDay.'天的奖励');
            if($AddScore === false){
                db()->rollback();
                $arr = array('code'=>0,'msg'=>'领取异常');
                return json($arr);
            }
            /*if(db('m_users_phone')->where('userid',$userid)->find()){
                db('m_users_phone')->where('userid',$userid)->setInc('total_score',$signAwaMinute);
            }else{
                db('m_users')->where('id','=',$userid)->setInc('total_score',$signAwaMinute);
            }
            minuteDetailed('累计签到'.$signDay.'天的奖励',$signAwaMinute,$userid,'1');
            */
            db()->commit();
            $arr = array('code'=>1,'msg'=>'领取成功');
            return json($arr);
        }catch (Exception $e) {
            db()->rollback();
            $arr = array('code'=>0,'msg'=>'领取异常');
            return json($arr);
        }
        //wangyining 20180127 end

        /*    $result = db('sign_awa')->insert($signGrandData);
        $signDa = db()->getLastInsID();
        $data = array('awa_id'=>$signDa,'userid'=>$userid,'type'=>1);
        $signGet = db('sign_get')->insert($data);
        if ($result) {
            $sum = Session::get('total_score');
            Session::set('total_score',$sum+$signAwaMinute);
            $memberMinute = db('m_users')->where('id','=',$userid)->setInc('total_score',$signAwaMinute);
            minuteDetailed('连续签到',$signAwaMinute,$userid,'1');
            if ($memberMinute) {
                $arr = array('code'=>1,'msg'=>'领取成功');
                return json($arr);
            } else {
                $arr = array('code'=>0,'msg'=>'领取异常');
                return json($arr);
            }
        }
        */
    }
    /**
     * 判断连续签到领取
     * @param  String
     * @return json
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function signJoinData () {

        $userid  = Session::get('memid');
        $phoneid = Session::get('phoneid');
        $signJoinDay = input('post.signJoinDay');
        $signJoinMiun = input('post.signJoinMiun');
        $signJoinType = input('post.signJoinType');
        // 当前真实的年月份
        $currentTime = date('Ym');
        $trueTimeTable = 'sign_detail_'.$currentTime;
        $res   = db($trueTimeTable)->where('userid','=',$userid)->where('sign_time','=',date('Y-m-d'))->find();  //查询当天用户签到信息
        $resData   = db($trueTimeTable)->where('userid','=',$userid)->where('sign_time','=',date('Y-m-d',strtotime('-1 day')))->find();  //查询当天用户签到信息

        if ($res) {
            if ($res['sign_sum'] < $signJoinDay) {
            $arr = array('code'=>5,'msg'=>'抱歉,领取条件不符');
            return json($arr);
             }
        } else {
            if ($resData['sign_sum'] < $signJoinDay) {
                $arr = array('code'=>5,'msg'=>'抱歉,领取条件不符');
                return json($arr);
            }
        }

        $signAwaData = db('sign_awa')->where(array('userid'=>$userid,'sign_day'=>$signJoinDay,'type'=>2))->find();
        if (empty($signAwaData)) {
            $data = array(
                'userid' => $userid,
                'sign_day' => intval($signJoinDay),
                'sign_num' => intval($signJoinMiun),
                'sign_type' => intval($signJoinType),
                'create_time' => date('Y-m-d,H:i:s'),
                'type' => 2,
            );
            db()->startTrans();
            try{
                $signAwa = db('sign_awa')->insert($data);
                $signDa = db()->getLastInsID();
                $data = array('awa_id'=>$signDa,'userid'=>$userid,'type'=>2);
                $signGet = db('sign_get')->insert($data);
                if ($signAwa) {
                    
                    if($phoneid){
                        $tabalename = 'm_users_phone';
                        $fieldname  = 'userid';
                    }else{
                        $tabalename = 'm_users';
                        $fieldname  = 'id';
                    }
                    /*$memMinute = db($tabalename)->where([$fieldname=>$userid])->setInc('total_score',$signJoinMiun);
                    minuteDetailed('连续签到'.$data['sign_day'].'天奖励',$signJoinMiun,$userid,'1',$phoneid);
                    if ($memMinute) {
                        $sum = Session::get('total_score');
                        Session::set('total_score',$sum+$signJoinMiun);
                    }*/
                    $score = AddScore($userid,$phoneid,$signJoinMiun,'1','连续签到'.$data['sign_day'].'天奖励');
                    if($score === false){
                        db()->rollback();
                        $arr = array('code'=>0,'msg'=>'领取异常');
                        return json($arr);
                    }
                    // 清除用户数据
                    cache::rm('userinfo_'.$data['userid']);
                    db()->commit();
                    $arr = array('code'=>1,'msg'=>'领取成功');
                    return json($arr);
                } else {
                    db()->rollback();
                    $arr = array('code'=>0,'msg'=>'领取异常');
                    return json($arr);
                }
            }
            catch(\Exception $e){
                db()->rollback();
                $arr = array('code'=>0,'msg'=>'领取异常');
                return json($arr);
            }
        } else {
            $arr = array('code'=>3,'msg'=>'已领取');
            return json($arr);
        }

    }
    /**
     * 判断签到日期并生成下一张日期表
     * @param  String  $y/$m   传入年月
     * @return json
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    protected function getTable ($newTime) {

        $table_name = 'sign_detail_'."$newTime";
        $sql = "CREATE TABLE $table_name (
            id int NOT NULL AUTO_INCREMENT,
            PRIMARY KEY(id),
            userid int(11),
            sign_time datetime,
            sign_sum int(11),
            sign_create datetime
        )";
        $res = Db::execute($sql);
        if ($res !== false) {
            $cacheKey = 'table_all_list';
            cache($cacheKey,null);
            return true;
        } else {
            return false;
        }
    }
    /**
     * 修改会员资料,主要修改积分和签到总数
     * @param  String  $y/$m    传入年月
     * @return json
     * @author {Yanlipeng}<{Yanlipeng@suxuantech.cn}> 2017-11-14 $
     */
    public function upUserinfo($data){
        $score = (int)$data['score'];
        if($data['phoneid']){
            $tabalename = 'm_users_phone';
            $fieldname  = 'userid';
        }else{
            $tabalename = 'm_users';
            $fieldname  = 'id';
        }
        try{    
            db()->startTrans();
            if($score){
                $AddScore = AddScore($data['userid'],$data['phoneid'],$score,$data['rulename'],$data['truename']);
                if($AddScore === false){
                    db()->rollback();
                    return false;
                }
            }
            $data = db('m_users')->where('id',$data['userid'])->setInc('total_sign',1);
            if(!$data){
                db()->rollback();
                return false;
            }else{
                db()->commit();
            }
        }
        catch(\Exception $e){
            db()->rollback();
            return false;
        }

        // 缓存今天签到获取到积分设置到午夜0点过期
        if($data['today']){
            $cachetime = strtotime(date('Ymd',strtotime("+1 day")))-time();
            $cachekey = 'sign_totday_score_'.$data['userid'].'_'.date('Ymd',time());
            cache($cachekey,$score,$cachetime);
        }

        // 清除当天的签到缓存
        $todayDate = date('Y-m-d',time());
        $cachekey  = 'sign_'.$data['userid'].'_'.$todayDate;
        cache::rm($cachekey);

        // 删除已签到的日期缓存
        $YM = $data['day']?substr($data['day'],0,6):'';
        if($YM){
            $cachekey = 'sign_days_'.$data['userid'].'_'.$YM;
            cache::rm($cachekey);
        }
        cache('signTotal',null);
        // 清除用户数据
        cache::rm('userinfo_'.$data['userid']);
        return true;
    }
}