<?php
/**
 * 任何控制器
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: 
 */
namespace app\front\controller;

use think\Cache;
use app\vip\model\TTaskList;
use think\Controller;
use think\Db;
use think\db\Query;
use think\image\Exception;
use think\Session;
use app\front\controller\BaseFront;
use app\front\model\Mem;
class Task extends BaseFront { 

    /**
     * 任务列表
     * @return [type] [description]
     */
    public function index(){

        //用户信息
        $userid = Session::get("memid");
        $userinfo = db("m_users")->where("id",$userid)->find();

        //用户签到信息
        $trueTimeTable = 'sign_detail_' . $currentTime;
        $rule = getScoreRule(['userid' => $this->userId]);

        $succey = (int)$rule['supply_sign'];
        Session::set("supply_sign", $succey);
        // 用户当天签到信息
        $todayDate = date('Y-m-d', time());
        $cachekey = 'sign_' . $this->userId . '_' . $todayDate;

        $todaySign = cache($cachekey);
        if (!$todaySign && checkTableExists($trueTimeTable)) {
            $todaySign = db($trueTimeTable)->where(['userid' => $this->userId, 'sign_time' => $todayDate])->find();
            if ($todaySign) {
                cache($cachekey, $todaySign);
            }
        }
        // 用户昨天签到信息
        $yestodayDate = date('Y-m-d', strtotime('-1 day'));
        $cachekey = "sign_" . $this->userId . "_" . $yestodayDate;
        $yestodaySign = cache($cachekey);
        if (intval(date('d')) == 1) {
            $yestodayDb = 'sign_detail_' . date('Ym', strtotime('-1 day'));
        } else {
            $yestodayDb = $trueTimeTable;
        }
        if (!$yestodaySign && checkTableExists($yestodayDb)) {
            $yestodaySign = db($yestodayDb)->where(['userid' => $this->userId])->where('sign_time', '=', $yestodayDate)->find();
            if ($yestodaySign) {
                cache($cachekey, $yestodaySign);
            }
        }
        if ($todaySign) {
            $seriaSignNum = (int)$todaySign['sign_sum'];
        } else {
            $seriaSignNum = $yestodaySign ? (int)$yestodaySign['sign_sum'] : 0;
        }

        //任务信息
        $data = controller("Task","lib")->GetData();
        $c = [
            'brandid' => $this->brandId,
        ];

        //查看积分是否已领取
        $userdata = controller('task','lib')->GetUserTaskData();//查询用户领取任务奖励记录
        $detail = [];
        $details = [];
        /*foreach ($data as $k => $v) {
            foreach ($userdata as $k2 => $v2) {
                if($v['typeid'] == 1){
                    $detail['sign'] = $data[$k]['detail'];
                    $detail['sign']['id']   = $v['id'];
                }
                if($v['typeid'] == 2){
                    $detail['message'] = $data[$k]['detail'];
                    $detail['message']['id']   = $v['id'];
                }    
            }
        }*/
        foreach ($data as $k => $v) {
            if($v['typeid'] == 1){
                $detail = $data[$k]['detail'];
                $detail['sign_id'] = $v['id'];  //签到类别的主键id
            }
            if($v['typeid'] == 2){
                $details = $data[$k]['detail'];
                $details['message_id'] = $v['id'];   //完善信息的主键id
            }
        }
        $arr = array_merge($detail,$details);
        $arr2 = [];
        foreach ($arr as $k => $v) {
            if($k == 'keep_rule'){
                $arr2['1_2'] = $v;
            }
            if($k == 'grand_rule'){
                $arr2['1_3'] = $v;
            }
            if($k == 'firstsign'){
                $arr2['1_1'] = $v;
            }
            if($k == 'everyday'){
                $arr2['1_4'] = $v;
            }
            if($k == 'message'){
                $arr2['2_1']['scores'] = $v['babyname'];
                $arr2['2_2']['scores'] = $v['phone'];
                $arr2['2_3']['scores'] = $v['babybrithday'];
                $arr2['2_4']['scores'] = $v['babysex'];
            }
            $arr2['sign_id'] = $arr['sign_id'];
            $arr2['message_id'] = $arr['message_id'];
        }
        //判断是否已经领取
        foreach ($arr2 as $k => $v) {
            foreach ($v as $k3 => $v3) {
                foreach ($userdata as $k2 => $v2) {
                    if($k == $v2['typeid']){
                        if(strstr($v2['typeid'],'_',true) == 1){    //签到类别
                            if($k3 == $v2['t_days']){
                                $arr2[$k][$k3]['is_get'] = 1;
                            }elseif($k == '1_1' && $v3 == $v2['t_task_integral']){
                                $arr2[$k]['is_get'] = 1;
                            }elseif($k == '1_4' && strstr($v2['create_time'],' ',true) == date('Y-m-d',time())){
                                $arr2[$k]['is_get'] = 1;
                            }
                        }elseif(strstr($v2['typeid'],'_',true) == 2){ //完善信息类别
                            if($k == $v2['typeid']){
                                $arr2[$k]['is_get'] = 1;
                            }
                        }
                    }
                }
            }
        }
        //分享任务，已完成数量
        $shareData = db('a_activity_share_num')->where("share_userid",$this->userId)->field('activityid')->select();
        $shareData2 = [];
        foreach ($shareData as $k => $v) {
            $shareData2[] = $shareData[$k]['activityid'];
        }
        $share_num = array_count_values($shareData2);
        foreach ($data as $k => $v) {
            if($v['typeid'] == 3){
                foreach ($share_num as $k2 => $v2) {
                    if($v['activityid'] == $k2 && $v2 >= $v['share_num']){
                        $data[$k]['is_can'] = 1;
                    }
                }
                foreach ($userdata as $k3 => $v3) {
                    if($v3['taskid'] == $v['id']){
                        $data[$k]['is_get'] = 1;
                    }
                }
            }
        }
        $this->assign('detail',$arr2);
        $this->assign('seriaSignNum',$seriaSignNum);//连续签到天数
        $this->assign('userinfo',$userinfo);        //用户信息
        $this->assign('data',$data);                //任务数据
        return view();
    }

    /**
     * 完成某项任务，领取奖励
     * DB:t_task_user_list  
     * typeid:1 签到（1_1首次签到，1_2连续签到，1_3累计签到，1_4每天签到），2完善信息（2_1宝宝姓名，2_2手机号，2_3宝宝生日，2_4宝宝性别），3分享任务
     */
    public function GetAward(){
        $userid   = Session::get('memid');
        $brand_id = Session::get('brand_id');
        $acdata   = request()->post();

        $task = [
            'userid'  => $userid,
            'taskid'  => $acdata['id'],
            'status'  => 1,
            'create_time' => date('Y-m-d H:i:s',time()),
            'brandid' => $brand_id,
            't_title' => $acdata['title'],
            't_days'  => $acdata['days'],
            'typeid'  => $acdata['taskusertypeid'],
        ];

        //有typeid并且等于2  奖励是优惠卷
        if($acdata['typeid'] && $acdata['typeid'] == 2){
            $task['couponid'] = $acdata['score'];
            $c['coupon_num'] = $acdata['score'];
            $c['userid']     = $userid;
            $d = controller('index','lib')->getReceive($c);
            if(json_decode($d,true)['status'] != 1){
                return json(['code'=>202,'msg'=>json_decode($d,true)['msg']]);
            }
            controller('task','lib')->AddUserTask($task);   //添加领取记录
            return json(['code'=>200,'msg'=>'领取成功']);
        }
        $task['t_task_integral'] = $acdata['score'];
        //无typeid 或者 typeid=1 奖励是积分
        $res = AddScore($userid,'',$acdata['score'],'2',$acdata['title']);
        if($res){
            controller('task','lib')->AddUserTask($task);  //添加领取记录
            return json(['code'=>200,'msg'=>'领取成功']);
        }else{
            return json(['code'=>202,'msg'=>'领取失败']);
        }

    }
 /*   public function taskList(){
        $type = input('get.type');
        $this->assign('type', $type);
        // 客户信息
        $userinfo = getUserInfo(['userid' => $this->userId]);
        $this->assign('memsum', $userinfo);
        // 日常任务  会员积分规则
        $rule = getScoreRule(['userid' => $this->userId]);
        // 累计规则
        $grandRule = $rule['grand_rule'];
        // 持续规则
        // $keepRule = $rule['keep_rule'];
        if (($grandRule || $keepRule) && $userinfo['total_sign'] > 0) {
            $alreadyReceive = db('sign_awa')->where(array('userid' => $this->userId))->select();
            if ($alreadyReceive) {
                foreach ($alreadyReceive as $k => $v) {
                    if ($v['type'] == 1) {
                        $grandRecord[] = $v['sign_day'];
                    } else if ($v['type'] == 2) {
                        $keepRecord[] = $v['sign_day'];
                    }
                }
                if ($grandRecord) {
                    foreach ($grandRule as $k => $v) {
                        $grandRule[$k]['receive'] = in_array($v['days'], $grandRecord);
                    }
                }
                // if ($keepRecord) {
                //     foreach ($keepRule as $k => $v) {
                //         $keepRule[$k]['receive'] = in_array($v['days'], $keepRecord);
                //     }
                // }
            }
        }
        $this->assign('grandRule',$grandRule);
        // 限时任务 （原vip任务大厅）
        $resX = $this->sxTask();
        // 推广任务 （有套系优惠券的任务）
        $resT = $this->tgTask();
        
        return $this->fetch();
    }*/
    // 获取日常任务列表
 /*   public function dayTask() {
        # code...
    }*/
    // 限时任务 （原vip任务大厅）
/*    public function sxTask() {
        $taskType = input('request.type');
        $day = input('request.day');
        $taskNum = input('request.num');

        $c = [
            'limit' => 5,
            'page' => (int)input('request.page'),
            'brandid' => $this->brandId,
            'order' => (int)input('request.order'), // 判断当前是否热门 1是热门,没有就是普通
        ];

        if (!empty($taskType)) {
            $c['typeid'] = $taskType;
        }
        if ($day && $day != '全部') {
            $days = explode('-', $day);
            $dayStar = (int)$days[0];
            $dayEnd = (int)$days[1];
            $c['days'] = [['>=', $dayStar], ['<=', $dayEnd]];
        }
        if ($taskNum && $taskNum != '全部') {
            $taskNums = explode('-', $taskNum);
            $taskNumStart = (int)$taskNums[0];
            $taskNumEnd = (int)$taskNums[1];
            $c['reward_score'] = [['>=', $taskNumStart], ['<=', $taskNumEnd]];
        }
        // $taskData  = TTaskList::selectS($w);
        // $moodsData = TTaskList::selectMoods();

        // 查询任务列表
        //var_dump($c);

        $tasklist = controller('index', 'lib')->getTaskList($c);
        if (request()->isAjax()) {
            return json(['data' => $tasklist]);
        } else {
            $tasklist = controller('index', 'lib')->getTaskList($c);
            $c['order'] = 1;
            $hotlist = controller('index', 'lib')->getTaskList($c);
        }

        $tasktotal = controller('index', 'lib')->getTaskCount($c);
        $adv = controller('index', 'lib')->getAdv(15);
        $this->assign([
            'setInfo' => ['title' => '任务大厅'],
            'adv' => $adv,
            'taskData' => $tasklist,
            'moodsData' => $hotlist,
            'page' => ceil($tasktotal / $c['limit']),
        ]);
        return view();
    }*/

    // 推广任务
  /*  public function tgTask() {
        # code...
    }
*/
    /**
     * 方法描述: 我的任务中心
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
   /* public function myTask()
    {
        $status = input('get.status') == 1 ? 1 : 0;
        $memTask = db('t_task_user_list')
            ->alias('a')
            ->join('t_task_list b', 'a.taskid = b.id')
            ->where(['a.status' => $status, 'b.brandid' => $this->brandId, 'a.userid' => $this->userId])
            ->field('a.status,a.taskid,a.done_total,b.title,b.index_img,b.reward_score,b.share_score,b.task_url,b.days,b.typeid')
            ->select();
        //var_dump(db()->getLastSql());
        //var_dump($memTask);
        $adv = controller('index', 'lib')->getAdv(1);
        $cachekey = 'sign_' . $this->userId . '_' . date('Y-m-d', time());
        $isSign = cache($cachekey);
        $userinfo = getUserInfo(['userid' => $this->userId, 'phoneid' => $this->userId, 'fields' => 'total_sign']);
        $userPhoneId = Session::get('phoneid');
        if (!$userPhoneId) {
            $userId = Session::get('memid');
            $totalSign = \db('m_users')->where('id', $userId)->field('total_sign')->find();
        } else {
            $totalSign = \db('m_users_phone')->where('id', $userPhoneId)->field('total_sign')->find();
        }
        $this->assign([
            'setInfo' => ['title' => '我的任务中心'],
            'res' => $isSign,
            'adv' => $adv,
            'memData' => $userinfo,
            'memTasks' => $memTask,
            'totalSign' => $totalSign,
        ]);
        return $this->fetch();
    }*/

    /**
     * 方法描述: 做任务
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
/*    public function doTask()
    {
        $thisTime = date('Y-m-d');
        $taskId = (int)input('get.id');
        $userId = Session::get('memid');
        if (!$taskId) {
            return $this->myTask();
        }
        //$where = makeWhere($this->userid,$this->userPhoneId);
        $where = ['create_time' => ['like', "%$thisTime%"], 'taskid' => $taskId, 'userid' => $this->userId];
        $check = db('t_task_detail')->where($where)->count('id'); //查询任务详情记录中有没有当天的记录
        $taskInfo = db('t_task_list')->where('id', '=', $taskId)->find(); //查询任务详情记录中有没有当天的记录
        if ($check) {
            $res = 1;
        } else {
            $res = 2;
        }
        $checkStatusRes = \db('t_task_user_list')->where('taskid', $taskId)->where('userid', $userId)->field('status')->find();
        if ($checkStatusRes['status'] == 1) {
            $stocksCheck = 1;  //该任务已完成
        } else {
            $stocksCheck = 2;  //该任务未完成
        }
        $this->assign('res', $res);
        $this->assign('taskImg', $taskInfo);
        $this->assign('stocksCheck', $stocksCheck);
        $this->assign('setInfo', ['title' => '执行-' . $taskInfo['title'] . '-任务']);
        $this->assign('taskid', $taskId);
        return $this->fetch();
    }*/

    /**
     * 方法描述: 任务详情介绍
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    /*public function taskDetail() {
        $taskId = (int)input('param.id');
        if ($taskId) {
            $taskData = db('t_task_list')
                ->where('id', '=', $taskId)
                ->find();
            $taskData['step'] = date('Ymd')-date('Ymd',strtotime($taskData['start_time']));
            if($taskData['step']>$taskData['days']){
                $taskData['step'] = $taskData['days'];
            }
            $taskData['rate'] = sprintf('%.2f',$taskData['step']/$taskData['days']*100);
            $this->assign([
                'taskData' => $taskData,
                'setInfo' => ['title' => $taskData['title'] . '-详情'],
            ]);
            return $this->fetch();
        } else {
            return $this->sxTask();
        }
    }*/


    /**
     * 方法描述: 领取任务
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    /*public function receiveTask()
    {
        $id = (int)input('get.id');
        if (!$id) {
            return $this->taskHall();
        }
        $data = db('t_task_list')->where('id', '=', $id)->find();
        if (!$data) {
            return $this->taskHall();
        }
        $alreadyReceive = false;
        $memLately = db('t_task_user_list')
            ->alias('a')
            ->field('a.userid,b.openid')
            ->join('m_users b', 'a.userid = b.id')
            ->where('a.taskid', '=', $id)
            ->order('a.create_time desc')
            ->select();
        foreach ($memLately as $v) {
            if ($v['userid'] == $this->userId) {
                $alreadyReceive = true;
            }
        }


        $this->assign('memLately', $memLately);
        $this->assign('datas', $data);
        $this->assign('received', $alreadyReceive);
        $this->assign('setInfo', ['title' => '领取任务-' . $data['title']]);
        return $this->fetch();
    }*/

    /**
     * 方法描述: 活动列表
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    /*public function activityCenter()
    {
        $levelid = getLevel(['userid' => $this->userId, 'phoneid' => $this->userPhoneId]);
        $c = [
            'brandid' => $this->brandId,
            'isenjoy' => (int)input('get.enjoy'),
            'levelid' => (int)$levelid ? $levelid : 0,
        ];
        $data = controller('activity', 'lib')->getList($c);

        $this->assign([
            'data' => $data,
            'setInfo' => [
                'title' => '最新活动',
            ],
        ]);
        return $this->fetch();
    }*/
    /**
     * 方法描述: 活动详情
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
   /* public function activityDetail()
    {
        $id = (int)input('id');
        $_share_userid  = input('_share_userid');
        $action = input('action');
        if ($id) {
            $data = controller('activity', 'lib')->getOne($id);
            $data['isSignUp'] = controller('activity', 'lib')->isSignUp($id, $this->userId, $this->userPhoneId);
            $c = [
                'limit' => 3,
                'page' => (int)input('request.page'),
                'id' => (int)input('request.id'),
            ];
            $msglist = controller('activity', 'lib')->getMsgList($c);

            // 获取留言
            if (request()->isAjax()) {
                return json(['status' => $msglist ? 1 : 0, 'data' => $msglist]);
            }

            $msgcount = controller('activity', 'lib')->getMsgCount(['id' => $id]);
            $totalpage = ceil($msgcount / $c['limit']);

            // 浏览的数据
            $d = [
                'activityid' => $id,
                'userid'     => $this->userId,
                'add_time'   => date('Y-m-d H:i:s', time()),
                'link_code'  => htmlspecialchars(input('get.codeid')),
                'iswid'      => $this->userPhoneId ? 0 : 1,
            ];
            // 添加浏览的数据
            controller('activity', 'lib')->addVisit($d);

            // 添加成长值
            $result = growthMemRecord($this->userId, 7, $id);
            if (!$result) {
                $gro = getGrowthRule(['userid' => $this->userId]);
                if ($gro && $gro['view_activity']) {
                    $gro['view_activity'] = $gro['view_activity'] ?: 0;
                    growthDetailed($this->userId, $gro['view_activity'], 7, $id, $this->userPhoneId);
                }
            }
            $where = [
                    'userid'     => $this->userId,
                    'activityid' => $id
            ];
            $shareqrdata = controller('activity','lib')->GetShareQrData($where);
            $this->assign([
                'id'=>$id,
                'shareqrdata'=>$shareqrdata,
                'action'=>$action,
                '_share_userid'=>$_share_userid,
                'data' => $data,
                'setInfo' => [
                    'title' => $data['title'],
                    'share_content'=>$data['share_content'],
                    'share_title' => $data['share_title'],
                    'share_img' => $data['share_img'] ?: $data['index_img'],
                ],
                'msglist' => $msglist,
                'totalpage' => $totalpage,
                'link_code' => $d['link_code'],
            ]);
            return $this->fetch();
        } else {
            return $this->error('非法访问');
        }
    }*/

    /**
     * 方法描述: 活动报名
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    /*public function activitySignUp(){
        if (request()->isAjax()) {
            $d = [];
            if(input('post._share_userid')){
                $d['parent_id'] = (int)input('post._share_userid');
            }
            if(input('post.site')){
                $shopArr = explode(',',input('post.site'));
                $d['shop_code'] = $shopArr[0];
                $d['shop_name'] = $shopArr[1];
            }
            $d['activityid']    = (int)input('post.id');
            $d['b_username']    = input('post.busername');
            $d['b_time']        = input('post.btime')?input('post.btime'):date("Y-m-d H:i:s",time());
            $d['activity_link'] = input('post.link_code');
            $d['b_content']     = htmlspecialchars(input('post.bcontent'));
            $d['userid']        = $this->userId;
            $d['b_type']        = 1;
            $d['brandid']       = $this->brandId;
            $d['create_time']   = date('Y-m-d H:i:s', time());
            $d['iswid']         = $this->userPhoneId ? 0 : 1;
            $d['ext_data']      = json_encode(input('ext/a'));
            $d['b_phone']       = input('post.bphone');
            if($d['b_phone']){
                $phoneArr = db("a_activity_sign_up")->where("b_phone",$d['b_phone'])->where("activityid",$d['activityid'])->find();
                if($phoneArr){
                    return json(['code'=>202,'msg'=>'该活动该手机号已报名！']);
                }
            }
            if(input('action') == 'jj'){    //识别聚焦的需要 验证验证码
                $code = input("code");
                if(!$code){
                    return json(['code'=>202,'msg'=>'请输入验证码']);
                }   
                $sessionCaptcha = Session::get('capt');   //正确的验证码
                if($code != $sessionCaptcha){
                    return json(['code'=>202,'msg'=>'验证码错误']);
                }
            }
            $d = array_filter($d);
            $data = controller('activity', 'lib')->signUp($d);
            $result = growthMemRecord($this->userId, 6, $d['activityid']);
            if (!$result) {
                $gro = getGrowthRule(['userid' => $this->userId]);
                if ($gro && $gro['activity_sign']) {
                    growthDetailed($this->userId, $gro['activity_sign'], 6, $d['activityid'], $this->userPhoneId);
                }
            }
            return $data;
        } else {
            $id = (int)input('get.id');
            $_share_userid = input('_share_userid');
            if ($id) {
                $data = controller('activity', 'lib')->getOne($id);
                $data['isSignUp'] = controller('activity', 'lib')->isSignUp($id, $this->userid, $this->userPhoneId);
                $dataConfig = [
                    [
                        'name' => '姓名',
                        'title' => '请输入姓名',
                        'icon' => '/public/front/img/reg_in1.png',
                        'key' => 'name',
                    ],
                ];
                $dbConfig = db_config('acitivity_data_config');
                if ($dbConfig) {
                    $dataConfig = $dbConfig;
                }

                //意向店面
                $shopset = sx_call("5a005e0038270",array('is_marketing'=>2),'sx_mc');
                if($shopset['code'] == 200){
                    $shopArr = $shopset['data'];
                }
                $this->assign([
                    '_share_userid'  => $_share_userid,
                    'data' => $data,
                    'setInfo' => [
                        'title'         => $data['title'] . '-活动报名',
                        'share_title'   => $data['share_title'],
                        'share_img'     => $data['share_img'],
                        'share_content' => $data['share_content'],
                        'link_code'     => input('link_code'),
                    ],
                    'dataConfig' => $dataConfig,
                    'shoparr'    =>$shopArr,
                ]);
            }
            return $this->fetch();
        }
    }*/
    /**
     * 方法描述     分享方法
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月26日 下午12:45:53
     */
    /*public function share(){
        $d = [
            'userid' => $this->userId,
            'sourceid' => (int)input('post.typeid'),//'1表示活动，2表示任务，3表示助力活动
            'shareid' => (int)input('post.id'),
            'share_url' => input('post.url'),
            'ip' => get_client_ip(),
            'phoneid' => $this->userPhoneId,
        ];
        //print_r($d);
        $res = controller('index', 'lib')->addShare($d);
        return json($res !== false ? ['status' => 1, 'score' => $res] : ['status' => 0]);
    }*/

    /**
     * 方法描述: 我的优惠卷页面
     * @return payCode
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
   /* public function myCoupon()
    {
        $status = (int)input('post.status');
        $brandId = Session::get('brand_id');
        $status = in_array($status, [0, 1, 2]) ? $status : 0;
        $c = [
            'userid' => $this->userId,
            'status' => $status,
            'limit' => 5,
            'page' => input('post.page'),
            'phoneid' => $this->userPhoneId
        ];
        $cachekey = 'couponTotal_status_' . $status . '_' . $this->userId;
        $total = cache($cachekey);
        //var_dump($total);
        if (!$total) {
            $total = controller('index', 'lib')->getUserCouponCount($this->userId, $status, $this->userPhoneId);
            cache($cachekey, $total);
        }
        if (request()->isAjax()) {
            $data = controller('index', 'lib')->getCoupon($c, $status);
            return json(['data' => $data, 'total' => $total, 'status' => 1]);
        } else {
            $cachekey = 'couponAllList_' . $this->userId;
            $data = cache($cachekey);
            if (!$data) {
                $data = controller('index', 'lib')->getCoupon2($c);
                cache($cachekey, $data);
            }
        }
        $activityCouponData = \db('a_activity_list')
            ->alias('a')
            ->join('c_coupon_num b', 'a.couponid = b.id', 'left')
            ->where('a.brandid', $brandId)
            ->limit(4)
            ->select();
        $time = date('Y-m-d H:i:s', time());
        $hlCoupon = db('c_coupon_num')->where('brandid', $brandId)->where('delete_time', null)->where('is_show', 1)->where('end_time', ['>', $time])->where('start_time', ['<', $time])->select();

        //$couponAmountData = \db('c_coupon_num')->where('brandid',$brandId)->select();
        $adv = controller('index', 'lib')->getAdv(4);           //我的优惠卷广告位待处理
        $advCenter = controller('index', 'lib')->getAdv(3);   //我的优惠卷广告位待处理
        $advLast = controller('index', 'lib')->getAdv(9);   //我的优惠卷广告位待处理
        $activityData = \db('a_activity_list')->where('brandid', $brandId)->order('create_time desc')->field('id,index_img')->limit(3)->select();

        $kf_url = db('c_kf')->where('brandid', Session::get('brand_id'))->value('url');
        $this->assign([
            'advData' => $adv,
            'advLast' => $advLast,
            'advCenter' => $advCenter,
            'data' => $data,
            'hlCoupon' => $hlCoupon,
            'activityData' => $activityData,
            'couponAmountData' => $activityCouponData,
            'setInfo' => ['title' => '我的优惠券'],
            'kf_url' => $kf_url
        ]);

        return view();
    }*/
}   