<?php
/**
 * Created by PhpStorm.
 * User: zhaibaoming
 * Date: 2018/8/8 0008
 * Time: 14:28
 */

namespace app\front\controller;

use app\front\controller\BaseFront;
use think\Session;

class Userphotos extends BaseFront
{
    private $brand_id;
    private $limit;

    public function __construct()
    {
        parent::__construct();
        $this->brand_id = Session::get('brand_id');
        $this->limit = 50;
    }

    public function index()
    {
        $type = input("type");
        $data = controller('vip/McUserPhotos', 'model')->getLimitFront(0, $this->limit, $this->brand_id, $type);
        //广告位
        $adv = controller('index','lib')->getAdv(22);   //首页广告位待处理
        //客服url
        $kf_url    = controller('index','lib')->getKf('url');   //客服信息

        $this->assign('kf_url',$kf_url);
        $this->assign('adv',$adv);
        $this->assign('data', $data);
        $this->assign('imagePath', get_user_photos_image_path());
        return $this->fetch('Userphotos/index');
    }

    /**
     * ajax 读取帖子
     * @return \think\response\Json
     * User: zhaibaoming
     * Date: ${DATE}
     */
    public function ajaxTopicData()
    {
        $data = [
            'code' => 1,
            'data' => '',
        ];
        $page = intval(request()->post('page', 0)) * $this->limit;
        $data['data'] = controller('vip/McUserPhotos', 'model')->getLimitFront($page, $this->limit, $this->brand_id);
        if (empty($data['data'])) {
            $data['code'] = 0;
        }
        return json($data);
    }
}