<?php
/**
 * 婚礼相关项目开发
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: YanLipeng <YanLipeng@suxuantech.cn>  2017年11月16日 下午3:48:53
 */
namespace app\front\controller;
use think\Controller;
use think\Db;
use think\Image;
use think\Session;

class Wedding extends BaseFront {
    /**
     * 方法描述: 婚礼坐席添加
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function deskAdd () {
        $userId = Session::get('memid');
        $desk_mans = input('post.desk_mans');
        $desk_name = input('post.desk_name');
        if (is_numeric($desk_name)) {
            $desk_name = '第'.$desk_name.'桌';
        }
//        $desk_name = preg_replace('/\D/s', '', $desk_name);
        $desk_content =  input('post.desk_content');
        if ($desk_mans == '') {
            return array('code'=>3,'msg'=>'请选择宾客');
        }
        $deskOneData = db('wedding_desk')->where('desk_user',$userId)->find();
        if ($deskOneData['desk_name'] == $desk_name && $deskOneData['desk_content'] == $desk_content && $deskOneData['desk_mans'] == $desk_mans) {
            return array('code'=>201,'msg'=>'请勿添加重复数据');
        }
        $data = [
            'desk_name'=> $desk_name,
            'desk_content' => $desk_content,
            'desk_mans' => $desk_mans,
            'desk_user' => $userId,
        ];
        $res = db('wedding_desk')->insert($data);
        if ($res) {
            $arr = array('code'=>1,'msg'=>'添加坐席成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'添加坐席失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚礼坐席删除
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function del () {
        $userId = Session::get('memid');
        $deskId = (int)input('post.id');
        $res = db('wedding_desk')->where('id','=',$deskId)->where('desk_user','=',$userId)->delete();
        if ($res) {
            $arr = array('code'=>1,'msg'=>'坐席删除成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'坐席删除失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚礼坐席单条修改
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function up () {
        $userId = Session::get('memid');
        $deskId = (int)input('post.id');
        $desk_mans = input('post.desk_mans');
        $desk_content = input('post.desk_content');
        $desk_name = input('post.desk_name');
        if (is_numeric($desk_name)) {
            $desk_name = '第'.$desk_name.'桌';
        }
        $deskData = db('wedding_desk')->where('id',$deskId)->find();
        if ($deskData['desk_name'] == $desk_name && $deskData['desk_content'] == $desk_content && $deskData['desk_mans'] == $desk_mans) {
            return array('code'=>2,'msg'=>'本次内容没有修改');
        }
        if ($desk_mans == '') {
            return array('code'=>3,'msg'=>'请选择宾客');
        }
        $data = [
            'desk_name'=> $desk_name,
            'desk_content' => $desk_content,
            'desk_mans' => $desk_mans,
            ];
        $res = db('wedding_desk')->where('id','=',$deskId)->where('desk_user','=',$userId)->update($data);
        if ($res) {
            $arr = array('code'=>1,'msg'=>'坐席修改成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'坐席修改失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚宴流程分类添加
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function flowTypeAdd () {
        $typeName = input('post.type_name');
        $userId = Session::get('memid');
        $data = ['flow_type'=>$typeName,'flow_user'=>$userId];
        $flowTypeData = db('wedding_flowtype')->insert($data);
        if ($flowTypeData) {
            $arr = array('code'=>1,'msg'=>'流程分类添加成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'流程分类添加失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚宴流程分类删除
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function flowTypeDel () {
        $userId = Session::get('memid');
        $flowTypeId = (int)input('post.id');
        if (empty($flowTypeId)) {
            return array('code'=>2,'msg'=>'分类流程id不存在');
        }
        $data = ['flow_status'=>2];
        $flowTypeData = db('wedding_flowtype')->where('flow_id','=',$flowTypeId)->where('flow_user','=',$userId)->update($data);
        if ($flowTypeData) {
            $arr = array('code'=>1,'msg'=>'流程分类添加成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'流程分类添加失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚宴流程分类修改
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function flowTypeUp () {
        $userId = Session::get('memid');
        $typeId = (int)input('post.id');
        $typeName = input('post.type_name');
        if ($typeId == '') {
            return array('code'=>2,'msg'=>'分类id不存在');
        }
        $typeData = db('wedding_flowtype')->where('flow_id',$typeId)->find();

        if ($typeData['flow_type'] == $typeName) {
            return array('code'=>2,'msg'=>'请修改分类名称后保存');
        }
        $data = ['flow_type'=>$typeName];
        $typeUp = db('wedding_flowtype')->where('flow_id','=',$typeId)->where('flow_user','=',$userId)->update($data);
        if ($typeUp) {
            $arr = array('code'=>1,'msg'=>'流程分类修改成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'流程分类修改失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚宴流程单条添加
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function flowAdd () {
        $userId = Session::get('memid');
        $typeId = (int)input('post.types_id');
        if (empty($typeId)) {
            return array('code'=>2,'msg'=>'当日流程添加id不存在');
        }
        $data = array(
            'this_time' => input('post.this_time'),
            'this_work' => input('post.this_work'),
            'this_man' => input('post.this_man'),
            'this_user' => $userId,
            'this_type' => $typeId,
        );
        $result = db('wedding_flow')->insert($data);
        if ($result) {
            $arr = array('code'=>1,'msg'=>'当日流程添加成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'当日流程添加失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚宴流程单条修改
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function flowUp () {
        $userId = Session::get('memid');
        $flowId = (int)input('post.flow_id');
        $flowTime = input('post.this_time');
        $flowWork = input('post.this_work');
        $flowMan = input('post.this_man');
        $flowOneData = db("wedding_flow")->where("id",$flowId)->find();

        if (substr($flowOneData['this_time'],0,5)==$flowTime && $flowOneData['this_work']==$flowWork && $flowOneData['this_man']==$flowMan) {
            return array('code'=>2,'msg'=>'请修改内容后保存');
        }

        $data = array(
            'this_time' => $flowTime,
            'this_work' => $flowWork,
            'this_man' => $flowMan,
            'this_user' => $userId,
            'this_type' => input('post.type_id'),
        );
        $result = db('wedding_flow')->where('id','=',$flowId)->where('this_user','=',$userId)->update($data);
        if ($result) {
            $arr = array('code'=>1,'msg'=>'当日流程编辑成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'当日流程编辑失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 婚宴流程单条删除
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function flowDel () {
        $userId = Session::get('memid');
        $flowId = (int)input('post.id');
        if (empty($flowId)) {
            return array('code'=>2,'msg'=>'单条流程事项id不存在');
        }
        $result = db('wedding_flow')->where('id','=',$flowId)->where('this_user','=',$userId)->delete();
        if ($result) {
            $arr = array('code'=>1,'msg'=>'单条事项删除成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'单条事项删除失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 相册前期信息处理
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function photoAdd () {
        $img = request()->file('img');
        $id = input('post.id');
        if (empty($id)) {
            $id = input('post.id');
        }
        $autoId = input('post.autoId');
        $bookTitle = input('post.title');
        $bookCount = input('post.content');
        if (empty($id)) {
            return array('code'=>3,'msg'=>'库自增id不存在,请选择模板');
        }
        $userId = Session::get('memid');
        $imgOne = db('wed_photos')->where('id',$id)->field('book_img,book_title,book_coutent,book_muise')->find();
        if ($bookTitle == $imgOne['book_title'] && $bookCount == $imgOne['book_coutent'] && empty($img)) {
            return array('code'=>5,'msg'=>'本次内容没有修改');
        }
        if (!empty($img)) {
            $info = saveImg($img,'','','','',true);
            $imgPath = $info;
//            if ($info) {
//                $imgPath =  $info->getSaveName();
//            } else {
//                echo $img->getError();
//            }
        }

        $data = array(
            'book_title' => input('post.title'),
            'book_coutent' => input('post.content'),
            'book_muise' => input('post.sel'),
            'book_img' => $imgPath,
            'book_user' => $userId,
        );
//        var_dump($data);exit;
        $result = db('wed_photos')->where('id',$id)->update($data);

        $temId = db('wed_photos')->where('id',$id)->field('book_id')->find();
        $temId  = $temId['book_id'];
        if ($result) {
            $arr = array('code'=>1,'msg'=>'标题添加成功','data'=>$id,'temId'=>$temId);
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'标题添加失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 相册多图处理
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function photos () {
        $img = request()->file('file');
        $id = input('post.id');
        $info = $img->move(ROOT_PATH . 'public' . DS . 'uploads');
        if ($info) {
            $imgPath = $info->getSaveName();
        } else {
            $img->getError();
        }
        $data = array('p_id'=>$id,'p_name'=>$imgPath);
        $result = db('wed_phos')->insert($data);
        $imgId = db()->getLastInsID();
        if ($result) {
            $arr = array('code'=>1,'msg'=>'照片群添加成功','data'=>$imgId);
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'照片群添加失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 相册模版显示/删除
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function showStats () {
        $autoId = (int)input('post.autoId');
        if (!$autoId) {
            return array('code'=>2,'msg'=>'自增ID不存在');
        }
        $delPhotosRes = db('wed_phos')->where('p_id',$autoId)->delete();
//        var_dump($delPhotosRes);exit;
        if ($delPhotosRes == 0) {
            return array('code'=>201,'msg'=>'相册集删除失败');
        }
        $delOneRes = db('wed_photos')->where('id',$autoId)->delete();
        if (!$delOneRes) {
            return array('code'=>202,'msg'=>'当前模版信息删除失败');
        }
        return array('code'=>1,'msg'=>'模版删除成功');
    }

    /**
     * 方法描述: 相册多图删除处理
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function photosDel () {
        $id = input('post.datas/a');   //input接收数组需要/a 来接收
        $ids = implode(',',$id);  //将一纬数组用逗号分割开显示为字符串形式
        $result = db("wed_phos")->where("id in ($ids)")->delete();  //执行批量删除事件
        if ($result) {
            $arr = array('code'=>1,'msg'=>'图片批量删除成功');
            return json($arr);
        } else {
            $arr = array('code'=>0,'msg'=>'图片批量删除失败');
            return json($arr);
        }
    }
    /**
     * 方法描述: 相册/选择模版处理
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function selExe  () {
        $id = (int)input('post.temId');
        $userId = Session::get('memid');
        $result = db("wed_photos")->where("book_user",$userId)->where('book_id',$id)->find();
        if ($result) {
            return array('code'=>3,'msg'=>'您已使用该模版');
        }
        if (!is_numeric($id)) {
            return array('code'=>0,'msg'=>'模版id为空');
        }
        /**
         *调用扣除积分方法
         * self::deductIntegral($userId);
         */
        $data = array('book_id'=>$id,'book_user'=>$userId);
        $temData = db('wed_photos')->insert($data);
        $autoId = db()->getLastInsID();
        if ($temData) {
            return array('code'=>1,'msg'=>'模版信息入库成功','dataid'=>$autoId,'temId'=>$id);
        } else {
            return array('code'=>0,'msg'=>'模版选择失败');
        }
    }
    /**
     * 方法描述: 相册/每个相册扣除的积分
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private  function deductIntegral ($userId) {
        $photoRule = scoreRule($userId);   //当前模板需要扣除多少积分
       /* $res = db('m_users')->where('id',$userId)->setDec($photoRule);  //进行用户数据扣减
        if (!$res) {
            return array('code'=>2,'msg'=>'当前用户扣减积分失败');
        }
        $sessionIntegral = Session::get('total_score'); //取出session当前登陆人的金额
        $thisIntegral = $sessionIntegral - $photoRule; //扣除后的当前人积分
        Session::set('total_score',$thisIntegral);  //session总积分赋值
        minuteDetailed('模版扣除积分',$photoRule,$userId,3); //调用积分日志规则
        $phoneid = db("m_users_phone")->where('user_id',$userId)->value("id");*/
        $score = AddScore($userId,$phoneid,$photoRule,'3','模板扣除积分'); 
        if($score === false){
            return array('code'=>2,'msg'=>'当前用户扣减积分失败');
        }
        return true;
    }
    /**
     * 方法描述: 相册/相册点赞数
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedWishSum () {
        $userId = Session::get('memid');
        $autoId = (int)input('post.autoId');
        if (empty($autoId)) {
            $autoId = (int)input('get.autoId');
        }
        $result = db('wed_photoman')->where('p_id',$autoId)->where('p_user',$userId)->find();
        if ($result) {
            return array('code'=>2,'msg'=>'您已位本条相册点赞');
        }
        $data = ['p_id'=>$autoId,'p_user'=>$userId,'p_time'=>date('Y-m-d H:i:s')];
        $res = db('wed_photoman')->insert($data);
        if (!$res) {
            return array('code'=>0,'msg'=>'点赞信息入库失败');
        }
        return array('code'=>1,'msg'=>'点赞成功');
    }

    /**
     * 方法描述: 计算婚期的值
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedRemain () {
        $days = input('post.days');
        $day  = str_replace('-','',$days);
        $userId  = Session::get('memid');
        $phoneid = Session::get('phoneid');
        if($phoneid){
            $tablename = 'm_users_phone';
            $fieldname = 'userid';
        }else{
            $tablename = 'm_users';
            $fieldname = 'id';
        }
        $res = db($tablename)->where($fieldname,'=',$userId)->update(['merryday'=>$day]);
        if ($res) {
            $time = date('Y-m-d');
            $badDays = getBadDays($time,$days);
 
            $arr = array('code'=>1,'day'=>$badDays);
            return json($arr);
        } else {
            return array('code'=>0,'msg'=>'失败');
        }
    }

    /**
     * 方法描述: 婚期预算计算值/修改预算
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedNum () {
        $userId = Session::get('memid');
        $userOne = db('wedding_money')->where('wed_user',$userId)->find();
        if ($userOne) {
            $res = db('wedding_money')->where('wed_user',$userId)->where('wed_status',1)->find();
            if (!$res) {
                return array('code'=>6,'msg'=>'状态已被全部锁定');
            }
        }
        $money = (int)input('post.wedMoney');
        $arr = getWedRatio($money);
        $res = self::wedUp($arr);
        return json_decode($res);
    }
    /**
     * 方法描述: 婚期预算计算值/修改单条预算
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedOneMatter () {
        $userId = Session::get('memid');
        $id = (int)input('post.wed_id');
        $code = (int)input('post.codes');   //code为1时是已消费
        $money = db('wedding_money')->where('wed_user','=',$userId)->sum('wed_money');
        if ($code == 1) {
            $data = [
                'wed_money' => input('wed_mon'),
                'wed_remark' => input('wed_content'),
                'wed_status' => 2,   //将当前的价格状态锁定
                'wed_consume' => 2,  //将是否消费状态改为2
            ];
        } else {
            $data = [
                'wed_money' => input('wed_mon'),
                'wed_remark' => input('wed_content'),
                'wed_status' => 2,
                'wed_consume' => 1,  //将是否消费状态改为1
            ];
        }
        db()->startTrans();
        $res = db('wedding_money')->where('w_id','=',$id)->update($data);
        $monerOneStatus = db('wedding_money')->where('w_id',$id)->field('w_id,wed_consume')->find();

        if ($res === false) {
            db()->rollback();
            if ($monerOneStatus['wed_consume'] == 2) {
                return array('code'=>3,'msg'=>'该项目金额已被设为消费');
            }
            ///error
            return array('code'=>'0','msg'=>'修改当前用户的单条预算失败');
        }
        $arr = getWedRatio($money);
        $result = json_decode(self::wedUp($arr),true);
        if($result['code']!= 1){
            db()->rollback();
            return array('code'=>'0','msg'=>$result['msg']);
        }
        db()->commit();

        return $result;
    }
    /**
     * 方法描述: 婚期预算计算值/修改完单预算之后修改的东西
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private static function wedUp ($arr) {
        $userId = (int)Session::get('memid');
        if(!$userId){
            return array('code'=>0,'msg'=>'当前用户的id不存在');
        }
        $rs = db('wedding_money')->where('wed_user','=',$userId)->find(); //修改金额后看库中有没有数据
        db()->startTrans();
//        try{
//            db()->commit();
//            return true;
//        } cache(Exception $e) {
//            db()->rollback();
//            return false;
//        }
        if ($rs) {
            $res = db('wedding_money')->where('wed_user','=',$userId)->delete();  //执行删除操作
            if($res === false){
                db()->rollback();
                return array('code'=>0,'msg'=>'当前操作人的数据删除失败');
            }
        }
        $result = db('wedding_money')->insertAll($arr); //执行批量添加操作
        if (!$result) {
            db()->rollback();
            $arr = array('code' => 0, 'msg' => '当前操作人的数据入库失败');
            return json_encode($arr);
        }
        db()->commit();
        $arr = array('code'=>1,'msg'=>'数据更新成功');
        return json_encode($arr);
    }
    /**
     * 方法描述: 婚期预算计算值/判断选择是已消费还是未消费
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedConsume () {
        $id = (int)input('post.wed_id');
        $data = ['wed_consume'=>2];
        $result = db('wedding_money')->where('w_id',$id)->update($data);  //更改当前的消费状态
        if (!$result) {
            return array('code'=>0,'msg'=>'消费状态更改失败');
        }
        return array('code'=>1,'msg'=>'状态更改成功');
    }
    /**
     * 方法描述: 婚期预算计算值/单条预算点击锁价格
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedOneLock () {
        $wedId = (int)input('post.wed_id');
        if (empty($wedId)) {
            return array('code'=>0,'msg'=>'自增id不能为空');
        }
        $res = db('wedding_money')->where('w_id',$wedId)->update(['wed_status'=>2]);
        if (!$res) {
            return array('code'=>0,'msg'=>'单条记录修改不成功');
        }
        return array('code'=>1,'msg'=>'状态已更改');
    }
    /**
     * 方法描述: 婚期预算计算值/单条预算点击锁价格
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedOneUnlock () {
        $wedId = (int)input('post.wed_id');
        if (empty($wedId)) {
            return array('code'=>0,'msg'=>'自增id不能为空');
        }
        $res = db('wedding_money')->where('w_id',$wedId)->update(['wed_status'=>1]);
        if (!$res) {
            return array('code'=>0,'msg'=>'单条记录修改不成功');
        }
        return array('code'=>1,'msg'=>'状态已更改');
    }
    /**
     * 方法描述: 婚期预算计算值/判断选择项目
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function wedPitchOn () {
        $userId = Session::get('memid');   //获取当前登录人
        $res = db('wedding_money')->where('wed_user',$userId)->where('wed_status',1)->find();
        if (!$res) {
            return array('code'=>6,'msg'=>'状态已被全部锁定');
        }
        $consumeStatus = db('wedding_money')->where('wed_user',$userId)->where('wed_consume',1)->find();
        if (!$consumeStatus) {
            return array('code'=>5,'msg'=>'剩余项目已被消费,请添加选项');
        }
        $selNames = input('post.selNames');  //前台选择项目时列表
        $selNames = str_replace(['婚前消费,','婚礼消费,','婚后消费,'],'',$selNames);  //去掉父级列表
        $arrPitch = explode(',',$selNames);  //将传来的选择列表字符串改为数组
        $arrPitch = array_unique($arrPitch); //去掉重复的
        $proData = db('wedding_money')->where("wed_user",0)->select();   //查询默认的百分比模版
        $endConsume = db('wedding_money')->where('wed_user',$userId)->where('wed_consume',2)->select();  //已经消费的
        $userData = db('wedding_money')->where('wed_user',$userId)->select();
        $creteManConsume = [];//已锁定的数组
        $unLockData = [];
        foreach ($userData as $k=>$v) {
            $creteManConsume[$v['wed_name']] = $v; //将已锁定项目名称做为新数组的key值
            if (in_array($v['wed_name'],$arrPitch)) {  //判断已选择的项目取出来
                $unLockData[$v['wed_name']] = $v; //将项目名称做为新数组的key值
            }
        }
        $statusData = array_column($unLockData,'wed_consume');  //查询出二维数组中当前字段的值(结果是一维数组)
        $statusData = implode(',',$statusData);  //将数组分割成字符串
        if (in_array('1',$statusData)) {
            return array('code'=>8,'msg'=>'请选择未消费的项目');
        }
        $creteConsume = [];//定义新数组
        foreach ($proData as $k=>$v) {
            if (in_array($v['wed_name'],$arrPitch)) {  //判断已选择的项目取出来
                $newData[$v['wed_name']] = $v; //将项目名称做为新数组的key值
            }
        }

//        $newData = array_merge($creteManConsume,$creteConsume);  //已消费项目不可更改(合并已消费和已选择的项目)
        $money = db('wedding_money')->where('wed_user',$userId)->Sum('wed_money');  //统计出当前用户下的总金额
        if ($money) {
            $moneySum = $money;
        } else {
            $moneySum = 0;
        }
        $disposeData = getWedRatio($moneySum,$newData);  //调用重新分配比列
        $result = json_decode(self::wedUp($disposeData),true); //转换为提醒
        if($result['code']!= 1){
            return array('code'=>'0','msg'=>$result['msg']);
        } else {
            return array('code'=>1,'msg'=>'选择项目成功');
        }
    }
    /**
     * 方法描述: 婚期微喜帖/默认数据循环添加当前用户数据(在点击确定选择该模版请求方法)
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public static function addDefaultData () {
        $userId = Session::get('memid');
        $brandId = Session::get('brand_id');
//        $brandId = 3;
//        $userId = 452;
        $templateName = input('post.template_name');  //接取当前模版名称
        $where = ['brand_id'=>$brandId,'template_name'=>$templateName,'user_phone_id'=>$userId];
        $templateResult = \db('wedding_lovecard')->where($where)->find();
        if ($templateResult) {
            return array('code'=>206,'msg'=>'您已拥有此模版');
        }
        if (!isset($templateName{1})) {
            return self::errorMessage(201,'模版名称不能为为空');
        }
        $defaultCardData = db('wedding_lovecard')->where('user_phone_id',0)->where('template_name',$templateName)->find();  //默认card数据
        if (empty($defaultCardData)) {
            return self::errorMessage(202,'not data');
        }
        $defaultTextData = db('wedding_lovedata')->where('wedding_lovecard_id',$defaultCardData['id'])->find();     //默认文本页数据
        $userCardData = [
            'brand_id' => $brandId,
            'user_phone_id' => $userId,
            'template_name' => $templateName,
            'invitation_img' => $defaultCardData['invitation_img'],
            'invitation_site' => $defaultCardData['invitation_site'],
            'invitation_music' => $defaultCardData['invitation_music'],
            'invitation_title' => $defaultCardData['invitation_title'],
            'invitation_describe' => $defaultCardData['invitation_describe'],
        ];
        $userCardResult = db('wedding_lovecard')->insert($userCardData);  //添加
        if ($userCardResult === false) {
            return self::errorMessage(203,'card数据添加失败');
        }
        $userCardId = db()->getLastInsID();
        $userTextData = ['wedding_lovecard_id'=>(int)$userCardId,'wedding_data'=>$defaultTextData['wedding_data']];
        $userTextResult = db('wedding_lovedata')->insert($userTextData);
        if ($userTextResult === false) {
            return self::errorMessage(204,'文本数据添加失败');
        }
        $defaultPhotosData = db('wedding_lovephotos')->where('wedding_lovecard_id',$defaultCardData['id'])->select();
        $userPhotosData = [];
        foreach ($defaultPhotosData as $k=>$v) {
            $userPhotosData['card_img'] = $v['card_img'];  //图片
            $userPhotosData['this_seat'] = $v['this_seat']; //显示位置
            $userPhotosData['this_several'] = $v['this_several']; //第几页
            $userPhotosData['wedding_lovecard_id'] = (int)$userCardId; //当前所属id
            $userPhotosResult = db('wedding_lovephotos')->insert($userPhotosData);
            if ($userPhotosResult === false) {
                return self::errorMessage(205,'照片数据添加失败');
            }
        }

        return array('code'=>200,'msg'=>'当前用户模版选择成功','data'=>$userCardId);
    }

    /**
     * 方法描述: 婚期微喜帖/删除当前模版信息
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public function delTemplate () {
        $autoId = input('post.autoId');
        $userId = Session::get('memid');
        $brandId = Session::get('brand_id');
        if (empty($autoId)) {
            return array('code'=>201,'msg'=>'未获取到自增id');
        }
        $where = ['brand_id'=>$brandId,'user_phone_id'=>$userId,'id'=>$autoId];
        $cardRes = \db('wedding_lovecard')->where($where)->delete();
        $delRes = \db('wedding_lovephotos')->where('wedding_lovecard_id',$autoId)->delete();
        if ($delRes === false) {
            return array('code'=>202,'msg'=>'照片删除失败');
        }
        $textRes = \db('wedding_lovedata')->where('wedding_lovecard_id',$autoId)->delete();
        if ($textRes === false) {
            return array('code'=>203,'msg'=>'文本信息删除失败');
        }
        if ($cardRes === false) {
            return array('code'=>204,'msg'=>'当前模版标题信息删除失败');
        }
        return array('code'=>200,'msg'=>'模版删除成功');
    }
    /**
     * 方法描述: 婚期微喜帖/标题内容部分添加
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public static function addWedInvTitle () {

        $userId = Session::get('memid');
        $autoId = (int)input('post.auto_id');  //当前单条记录id
        $invitationSiteLat = input('post.add_lat'); //经度
        $invitationSiteLng = input('post.add_lng'); //经度
        $img = request()->file('invitation_img');  //处理相册封面
        //$img = input("invitation_img");
        $invitationSite = input('post.invitation_site');    //坐标地点
        $invitationMusic = input('post.invitation_music');  //背景音乐
        $invitationTitle = trim(input('post.invitation_title'));  //相册标题
        $invitationDescribe = trim(input('post.invitation_describe'));  //相册描述
        if (empty($autoId)) {
            return self::errorMessage(201,'没有获取到单条记录id');
        }
        $titleOneData = db('wedding_lovecard')->where('id',$autoId)->field('user_phone_id,invitation_title,invitation_describe,invitation_img,invitation_music')->find();
        if ($userId != $titleOneData['user_phone_id']) {
            return array('code'=>205,'msg'=>'当前该用户不可更改本条位置信息内容');
        }
        
        if (!empty($img)) {
      
            // 移动到 目录下
            $info = $img->move(ROOT_PATH.'public'.DS.'uploads'.DS.'template'.$autoId);
            if($info){
                $imgPath =str_replace('\\',"/",$info->getSaveName());
                $imgPath = 'public/uploads/template'.$autoId.DS.$imgPath;
            }
            //$imgPath = saveImg($img,200,200,'template'.$autoId,'',false); /**** saveImg 方法 获取图片路径时 图片较大 使服务器反应太慢了
            //$imgPath = 'public/uploads/template'.$autoId.$imgPath;
//            $info = $img->move(ROOT_PATH . 'public' . DS . 'uploads');
//            if ($info) {
//                $imgPath =  $info->getSaveName();
//            } else {
//                echo $img->getError();
//            }
        } else {
            $imgPath = $titleOneData['invitation_img'];
        }
        //print_r($invitationMusic);echo'||';print_r($titleOneData['invitation_music']);echo"||";


        //判断数据是否修改过
        if (empty($img) &&
            $invitationTitle == $titleOneData['invitation_title'] &&
            $invitationMusic == $titleOneData['invitation_music'] &&
            $invitationDescribe == $titleOneData['invitation_describe'] &&
            $invitationSite == $titleOneData['invitation_site']
           ) {

            return array('code'=>200,'msg'=>'当前用户标题数据添加成功','data'=>$autoId);
//            return self::errorMessage(202,'本次内容没有修改');
        }
        //end

        if (empty($invitationSiteLat)&&empty($invitationSiteLng)) {
            $titleData = [
                'invitation_img' => $imgPath,
                'invitation_site' => $invitationSite,
                'invitation_music' => $invitationMusic,
                'invitation_title' => $invitationTitle,
                'invitation_describe' => $invitationDescribe,
            ];
        } else {
            $titleData = [
                'invitation_site' => $invitationSite,
                'invitation_site_lat' => $invitationSiteLat,
                'invitation_site_lng' => $invitationSiteLng,
            ];
        }

//        if (empty($invitationSite)) {
//            $titleData = [
//                'invitation_img' => $imgPath,
//                'invitation_site' => $invitationSite,
//                'invitation_music' => $invitationMusic,
//                'invitation_title' => $invitationTitle,
//                'invitation_describe' => $invitationDescribe,
//            ];
//        } else {
//            $titleData = [
//                'invitation_site' => $invitationSite,
//                'invitation_site_lat' => $invitationSiteLat,
//                'invitation_site_lng' => $invitationSiteLng,
//            ];
//        }
        //print_r($titleData);die;

        $upTitleResult = db('wedding_lovecard')->where('id',$autoId)->update($titleData);
        //模版问题待处理
        if ($upTitleResult === false) {
            return self::errorMessage(203,'标题数据添加失败');
        }
        return array('code'=>200,'msg'=>'当前用户标题数据添加成功','data'=>$autoId);

    }
    /**
     * 方法描述: 婚期微喜帖/文本内容部分添加
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public static function addWedInvText () {
        $autoId = (int)input('post.auto_id');  //自增id
        $onePageOne = input('post.one_page_one_line');
        $onePageTwo = input('post.one_page_two_line');
        $twoPageOne = input('post.two_page_one_line');
        $threePageOne = input('post.three_page_one_line');
        if (empty($autoId)) {
            return self::errorMessage(201,'没有获取到自增id');
        }
        // $userTextData = db('wedding_lovedata')->where('wedding_lovecard_id',$autoId)->find();
        // $data = $userTextData['wedding_data'];  //文本数据
        // $textData = json_decode($data,true);  //数据json转换
        // $newTextData = [];
        // foreach ($textData as $k=>$v) {
        //     $newTextData[$k] = $data[$k];
        // }
        $newTextData = [
            'one_page_one_line' => $onePageOne,
            'one_page_two_line' => $onePageTwo,
            'two_page_one_line' => $twoPageOne,
            'three_page_one_line' => $threePageOne,
        ];
        $newTextData = json_encode($newTextData);
        $templateName = db('wedding_lovecard')->where('id',$autoId)->field('template_name')->find();
        $userTextResult = db('wedding_lovedata')->where('wedding_lovecard_id',$autoId)->update(['wedding_data'=>$newTextData]);

        if ($userTextResult === false) {
            return self::errorMessage(202,'文本信息修改失败');
        }
        return array('code'=>200,'msg'=>'当前用户文本信息修改成功','data'=>$autoId,'template_name'=>$templateName['template_name']);
    }

    /**
     * 方法描述: 婚期微喜帖/照片集内容添加
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public static function addWedInvPhotos () {
        //照片集数据待处理
        $img = input('post.img_data');
        $autoId = input('post.auto_id');
        $nowPage = (int)input('post.place_page');
        $nowPhotoSeat = (int)input('post.place_place');
       // $photo_type = (int)input('post.photo_type');

        $imgPathOld = 'uploads/template'.$autoId;
//        if($photo_type==1){
            $imgPathNew = save_base64_to_file($img,$imgPathOld);
//        }else{
//            $imgPathNew = save_file($img,$imgPathOld);
//        }

        //print_r($imgPathNew);die;
        if(!$imgPathNew){
            return array('code'=>202,'msg'=>'上传失败，请稍后重试');
        }
        $imgPath='public'.$imgPathNew;
        $userImgData = [
            'card_img' => $imgPath,
        ];
        $where = [
            'this_several' => $nowPage,
            'this_seat' => $nowPhotoSeat,
            'wedding_lovecard_id' => $autoId,
        ];
        $userImgResult = db('wedding_lovephotos')->where($where)->update($userImgData);
        if ($userImgResult === false) {
            return array('code'=>202,'msg'=>'当前页图片修改失败');
        }
        return array('code'=>200,'msg'=>'当前页图片修改成功');

    }
    /**
     * 方法描述: 婚期微喜帖/祝福处理7
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public static function sendWish () {
        $userId = Session::get('memid');
        $autoId = (int)input('post.auto_id');

        if (empty($autoId)) {
            return self::errorMessage(201,'没有获取到自增id');
        }
        $where = ['wedding_lovecard_id'=>$autoId,'join_user_phone_id'=>$userId,'join_wish_status'=>1];
        $wishRes = \db('wedding_lovejoin')->where($where)->find();
        if ($wishRes) {
            return array('code'=>203,'msg'=>'您已送过祝福');
        }
        $userWishData = [
            'join_wish_status' => 1,
            'join_user_phone_id' => $userId,
            'wedding_lovecard_id' => $autoId,
            'join_wish_time' => date('Y-m-d H:i:s'),
        ];
        $where = ['wedding_lovecard_id'=>$autoId,'join_user_phone_id'=>$userId];
        $noWishData = \db('wedding_lovejoin')->where($where)->find();
        if (!$noWishData) {
            $userWishResult = db('wedding_lovejoin')->insert($userWishData);
        } else {
            $userWishResult = \db('wedding_lovejoin')->where('wedding_lovecard_id',$autoId)->where('join_user_phone_id',$userId)->update($userWishData);
        }

        if ($userWishResult === false) {
            return self::errorMessage(202,'送祝福失败');
        }
        return array('code'=>200,'msg'=>'祝福成功');
    }
    /**
     * 方法描述: 婚期微喜帖/报名处理
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    public static function weddingJoin () {
        $userId = Session::get('memid');
        $autoId = (int)input('post.auto_id');
        $joinNum = (int)input('post.join_num');
        $joinName = trim(input('post.join_name'));
        $joinTel = trim(input('post.join_phone'));
        $joinMessage = trim(input('post.join_message'));
        $joinNum == 0 ? $joinNum =1 : $joinNum;
        if (empty($autoId)) {
            return self::errorMessage(201,'没有获取到自增id');
        }
//        if (!preg_match('/^1[34578]{1}\d{9}$/',$joinTel)) {
//            return self::errorMessage(202,'请输入正确的手机号码');
//        }
        $joinData = [
            'join_num' => $joinNum,
            'join_name' => $joinName,
            'join_phone' => $joinTel,
            'join_message' => $joinMessage,
            'join_message_time' => date('Y-m-d H:i:s'),
        ];
        $joinDataAll = [
            'join_num' => $joinNum,
            'join_name' => $joinName,
            'join_phone' => $joinTel,
            'join_message' => $joinMessage,
            'join_user_phone_id' => $userId,
            'wedding_lovecard_id' => $autoId,
            'join_message_time' => date('Y-m-d H:i:s'),
        ];
        $userJoinData = db('wedding_lovejoin')->where('wedding_lovecard_id',$autoId)->where('join_user_phone_id',$userId)->find();
        if ($userJoinData) {
            $userJoinResult = db('wedding_lovejoin')->where('wedding_lovecard_id',$autoId)->where('join_user_phone_id',$userId)->update($joinData);
            if ($userJoinResult === false) {
                return self::errorMessage(203,'报名数据入库失败');
            }
        } else {
            $userJoinRes = db('wedding_lovejoin')->insert($joinDataAll);
            if ($userJoinRes === false) {
                return self::errorMessage(204,'报名入库失败');
            }
        }

        return array('code'=>200,'msg'=>'报名成功');
    }

    /**
     * 方法描述: 处理错误信息并反回数据
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private function errorMessage ($code,$messsg) {
        $errorData = ['code'=>(int)$code,'msg'=>$messsg];
        return $errorData;
    }
    /**
     * 方法描述: 处理成功信息并反回数据
     * @return mixed
     * @author YanLipeng<YanLipeng@suxuantech.cn> 2017年11月16日 下午4:19:47
     */
    private function successMessage ($data) {
        $successData = ['code'=>200,'msg'=>'成功','data'=>$data];
        return $successData;
    }


    /*
     * 保存云底片图片到本地
     */
    public function uploadYun(){
        $img_url='http://p72d66nsc.bkt.clouddn.com/A00000002%5Cbrowse%5CV6180146DG%20%20%20223.JPG?e=1524828419&token=gq7m8Aa0-bpstmr1p2PmHsvxpaPYZuI0zXgSxvQ4:c90y9oLOiQgtlsW1v5nVjM3MYbU=';
        //$img_url=input('post.img_path');
        $autoId = input('post.auto_id');
        $nowPage = (int)input('post.place_page');
        $nowPhotoSeat = (int)input('post.place_place');

        /** 图片保存到本地图片路径 */
        $imgPathOld = 'uploads/template'.$autoId;
        $imgPathNew = save_file($img_url,$imgPathOld);

        if(!$imgPathNew){
            return array('code'=>202,'msg'=>'上传失败，请稍后重试');
        }
        $imgPath='public'.$imgPathNew;
        $userImgData = [
            'card_img' => $imgPath,
        ];
        $where = [
            'this_several' => $nowPage,
            'this_seat' => $nowPhotoSeat,
            'wedding_lovecard_id' => $autoId,
        ];

        $userImgResult = db('wedding_lovephotos')->where($where)->update($userImgData);
        if ($userImgResult === false) {
            return array('code'=>202,'msg'=>'当前页图片修改失败');
        }
        return array('code'=>200,'msg'=>'当前页图片修改成功');

//        $img_url='public/uploads/wyn1.png';
//        $saveurl = 'public/uploads/wyn2.png';
//        $qrcodeurl = imagecreatefromjpeg($img_url);
//        imagejpeg($qrcodeurl, $saveurl);

    }

}