<?php
/**
 * 用户控制器。
 *
 *  * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * $Author: Wangyining<wangyining@suxuantech.cn> 2018-03-02 $
 */
namespace app\front\controller;
use app\vip\controller\User;
use app\front\model\Mem;
use think\image\Exception;
use think\Session;
use think\Db;
use think\Controller;
class Wxhelp extends  BaseFront {


    public  function index(){

        $help_id=input('help_id');

        $openid=Session::get('openid');
        $helpActivity=db('wx_help')->where('id',$help_id)->find();

        $ranking = Db::name('wx_help_user')->alias('a')
            ->field('a.*,b.rank')
            ->join('(SELECT id, @rank := @rank + (@prev <> (@prev := help_num)) Rank FROM wx_help_user, (SELECT @rank := 0, @prev := -1) init where help_id ='.$help_id.' order by help_num desc) b ','b.id = a.id','left')
            ->where(array('openid'=>$openid,'help_id'=>$help_id))
            ->find();
        Session::set('help_'.$help_id.'_'.$openid.'_parent_ids',$ranking['parent_ids']);

        $rowNum=$ranking['rank'];
        $id=$ranking['id'];

        $invitation_list=db('wx_help_user')->field('head_img,nick_name')->where('help_id',$help_id)->where('parent_id',$id)->select();
        $first=db('wx_help_user')->field('head_img,nick_name,help_num')->where('help_id',$help_id)->order('help_num desc')->limit(1)->find();

//        $rule='rule_type = :rule_type and rule_value >= :rule_value or ( rule_type = :rule_type2 and rule_value <= :rule_value2)';
//        $ruleArray=array('rule_type'=>1,'rule_value'=>$rowNum,'rule_type2'=>2,'rule_value2'=>count($invitation_list));
        $award=db('wx_help_award')->where('help_id',$help_id)->select();
        $can_receive=[];
        foreach($award as $k => $v){
            if(($v['rule_type']==1&&$rowNum&&$v['rule_value']>=$rowNum&&date('Y-m-d H:i:s',time())>=$helpActivity['end_time'])||($v['rule_type']==2&&$v['rule_value']<=count($invitation_list))){
                $can_receive[]=$v;
            }
        }

        $already_receive=db('wx_help_user_award')->field('award_id')->where('help_id',$help_id)->where('openid',$openid)->select();
        $receive_id=array_column($already_receive,'award_id');

        $this->assign([
            'helpActivity'=>$helpActivity,
            'invitation_list'=>$invitation_list,//邀请人列表
            'invitation_count'=>count($invitation_list)?count($invitation_list):0,//邀请人数
            'rowNum'=>$rowNum?$rowNum:0,//当前人排名
            'award'=>$award,//奖励
            'first'=>$first,//排名第一
            'help_user_id'=>$id,
            'help_id'=>$help_id,
            'receive_id'=>$receive_id,//已经领取的奖品id
            'can_receive_id'=>array_column($can_receive,'id'),//可领取奖品id
            'setInfo' => [
                'title' => $helpActivity['help_name'],
                'share_title' => $helpActivity['share_content'],
                'wxhelp_img'   => $helpActivity['help_img'],
            ],
        ]);

        return view($helpActivity['template_code']);
    }

    public function receive(){
        $data=input('post.');
        $phone=$data['phone'];
        $award_id=$data['award_id'];
        $help_user_id=$data['help_user_id'];
        $openid=Session::get('openid');

        if($phone&&$help_user_id&&$award_id){

            $awardData=db('wx_help_award')->where('id',$award_id)->find();
            if($awardData['award_type']==1){
                $getQuan=$this->receiveAward(array('coupon_num'=>$awardData['coupon_id'],'userid'=>$this->userId));
            }
            db()->startTrans();
            try{
                db('wx_help_user')->where('id',$help_user_id)->update(array('phone'=>$phone));
                db('wx_help_user_award')->insert(array('openid'=>$openid,'help_id'=>$awardData['help_id'],'award_id'=>$award_id,'award_title'=>$awardData['award_value'],'award_image'=>$awardData['image'],'status'=>1,'get_time'=>date('Y-m-d H:i:s',time())));
                db('wx_help_user')->where('id','in',Session::get('help_'.$awardData['help_id'].'_'.$openid.'_parent_ids'))->update(['award_num'=>['exp','award_num + 1']]);
                db()->commit();
                return $returnArray=array('code'=>1,'msg'=>'恭喜您领取成功！');
            }catch (Exception $e){
                db()->rollback();
                return $returnArray=array('code'=>201,'msg'=>'领取失败,请稍后重试');
            }

        }else{
            return  $returnArray=array('code'=>201,'msg'=>'未获取到您的信息，请稍后重试');
        }

    }


    /**
     * 方法描述： 领取优惠券，并生成优惠码入库
     * @param  array $param 数据userid和coupounum优惠券批次号
     * @return mixed
     */
    public function receiveAward($param){
        // 查询优惠券批次信息
        $data  = db('c_coupon_num')->where(['id'=>$param['coupon_num'],'status'=>1])->find();

        if($data && ($data['total_num'] - $data['receive_total'])>0){

            // 生成优惠券码,随机取8位+时间戳后几位,去掉4和7的数据
            $str = 'ABCDEFGHJKMNPQRSTUVWXYZ0125689';
            $couponid = substr(str_shuffle($str),0,8).''.substr(time(),5);
            $couponid = preg_replace('/4|7/',8, $couponid);
            $newdata  = [
                'userid'     => $param['userid'],
                'name'     => $data['title'],
                'coupon_num_id' => $param['coupon_num'],
                'coupon_code'   => $couponid,
                'create_time'=> date('Y-m-d H:i:s',time()),
                'iswid'      => $param['phoneid']?0:1,
                'discount_type'  => $data['discount_type'],
                'discount_value' => $data['money'],
                'condition_value'=> $data['min_consume'],
                'expire_time'    => date('Y-m-d H:i:s',(time()+$data['expire_time']*86400)),
                'product_info'    => $data['product_info'],
            ];
            // 插入数据库，更新coupon_list表和coupon_num表
            $res = db('c_coupon_list')->insert($newdata);
            if($res){
                $upcouponnum = db('c_coupon_num')->where('id',$data['id'])->update(['receive_total'=> $data['receive_total']+1]);
            }
            return $upcouponnum!==false && $res?true:false;
        }
        return false;
    }


    public function receiveSuccess(){
        $help_id=input('help_id');
        $helpData=db('wx_help')->where('id',$help_id)->find();
        $this->assign('img',$helpData['award_foot_image']);
        $this->assign('css',$helpData['template_code']);
        return view('suc');
    }
}