<?php
namespace app\front\controller;
use think\Cache;
use think\Controller;
use think\Session;
use app\front\model\Mem;
class Wxlogin extends Controller {
    /**
     * 方法描述: 获取用户信息
     * @return mixed
     * @author Yanlipeng<leishaoju@suxuantech.cn> 2017年11月16日 下午4:20:17
     */
    public function get () {
        $data = array('code'=>input('get.code'));
        session('wx_code',input('get.code'));
        $userInfo = sx_call('5a125fdfc4f6b',$data,'sx_mc');
        $share_userid = Session::get('share_userid');

        if ($userInfo['code'] == 200 && !empty($userInfo['data']['openid'])){

            $openId = $userInfo['data']['openid'];
            Session::set('openid',$openId);
            $wename = $userInfo['data']['nickname'];
            /*
            preg_match_all('/[\w\x{4e00}-\x{9fa5}]+/u',$wename,$newwename);
            $trueName = $newwename && $newwename[0] ? implode('',$newwename[0]) : '';
            */
            $trueName = filter_emoji($wename);
            //读取配置集团事业部
            $conf_brandid = db_config('sx_brand');
            if($conf_brandid == Session::get('brand_id')){
                $brandid = 0;
            }else{
                $brandid = Session::get('brand_id');
            }

            //加密
            $code    = think_encrypt($openId);        //加密
            $shopUrl = Session::get('shop_url');
            $addr    = rtrim($shopUrl,'/')."/mobile/oauth/index?authcode=".$code;
            Session::set('addr',$addr);

            //用户信息
            $memData = db('m_users')->where(['openid'=>$openId])->find();

            //新用户注册信息
            $userData = array(
                'openid'        => $userInfo['data']['openid'],
                'username'      => $trueName,
                'sex'           => $userInfo['data']['sex'],
                'simg'          => $userInfo['data']['headimgurl'],
                'brandid'       => $brandid,
                'create_time'   => date('Y-m-d H:i:s',time()),
                'share_userid'  => $share_userid,
                'last_land_time'=>date('Y-m-d H:i:s',time()),
            );

            // 用户日志信息
            $logdata = [
                'ip'          => get_client_ip(),
                'create_time' => date('Y-m-d H:i:s',time())
            ];
            //当用微信用户绑定的手机，手机表里的id
            $phoneid = 0;
            if (!$memData) {
                $userid = Mem::memPut($userData);
                //downloadImage($userData['simg'],$userData['openid']);
                Session::set('memid',$userid);
                Session::set('userid',$userid);
                Session::set('username',$trueName);
                Session::set('simg',$userInfo['data']['headimgurl']);
                Session::set('sex',$userInfo['data']['sex']);
                Session::set('unionid',$userInfo['data']['unionid']);

                Session::set('total_score',0);
                Session::set('growth_value',$userInfo['data']['growth_value']);
                Session::set('create_time',date('Y-m-d',time()));

                // 记录用户日志数据
                $logdata ['userid'] = $userid;
                $logdata ['typeid'] = 1;
                if($_GET['isdebug']){
                    echo '走的是：没有数据里：';
                    print_r($memData);
                    die;
                }
            }else{
                $userid = $memData['id'];

                //更新用户信息
            	$arr = array(
                    'username' => $trueName,
                    //'simg' => $userInfo['data']['headimgurl'],//因为会员系统可以自己上传头像，如果自己已经设置过系统头像了，微信更新头像则修改系统头像不太合理，暂时不更新
                    'last_land_time'=>date('Y-m-d H:i:s',time()),
            		);

                if(!$memData['simg'])  $arr['simg'] = $userInfo['data']['headimgurl'];//若之前没有获取到头像也没在系统内上传，则更新头像

                //若存在推荐人id,并且没有绑定手机号,并且表里没有记录推荐人  则更新推荐人id
                if($share_userid&&!$memData['phone']&&(!$memData['share_userid']||$memData['share_userid']==0)){
                    $arr['share_userid'] = $share_userid;
                }

            	db('m_users')->where('openid',$openId)->update($arr);

            	//判断用户事业部归属(集团会员可以进事业部，事业部不可以进集团自动转回所属事业部)
            	$brandid = Session::get('brand_id');
            	if($brandid == 0){ //当前为集团会员
            		if($memData['brandid'] != 0){
            			Session::set('brand_id',$memData['brandid']);
            		}
            	}


                Session::set('user_number',$memData['user_number']);
                Session::set('userid',$memData['id']);
                Session::set('memid',$memData['id']);
                //Session::set('phoneid',$phoneid);
                Session::set('money',$memData['money']);

                Session::set('mem_phone',$memData['phone']);
                Session::set('total_score',(int)$memData['total_score']);

                Session::set('username',$memData['username']);
                Session::set('simg',$memData['simg']);
                Session::set('create_time',$memData['create_time']);
                Session::set('sex',$memData['usex']);

                // 记录用户日志数据
                $logdata['userid'] = $memData['id'];
                $logdata['typeid'] = 0;
                $logdata['iswid']  = $phoneid?0:1;
                if($_GET['isdebug']){
                     echo '走的是：有数据里：';
                     print_r($memData);
                     die;
                }
            }

            // create@leishaoju 用于记录用户登录的时间
            Session::set('logintime',time());

            // 获取积分规则
            $rules  = getScoreRule(['userid'=>$userid]);
            $addscore = $logdata['typeid']==1?(int)$rules['first_land']:(int)$rules['everyday_land'];

            if($addscore){
                $up = Mem::addMemScore($userid,$addscore,$logdata['typeid'],$phoneid);
                if($up!==false && $addscore){
                    $sum      = Session::get('total_score');
                    Session::set('total_score',$sum+$addscore);
                }
            }

            // 写入日志
            writeLoginLog($logdata);
            $url = Session::get('reurl');
            $this->redirect($url?$url:'index/index');
        }else{
            die('信息获取失败，请重新打开。');
        }
    }


    /*
     * 更改当前登录人的地理位置
     */
    public function getAddress(){
        $lat = input('lat');
        $lng = input('lng');
        if(!$lat || !$lng ){
            return ['code'=>201,'data'=>'未获取到经纬度'];
        }
//        $lat = '39.72684';
//        $lng = '116.34159';
//        $realAddress = session('realAddress');
        if(!$realAddress){
            $address = getRealAddress($lat,$lng);

            $province = $address['province'];//省
            $city = $address['city'];//市
            $district = $address['district'];//区
            $street = $address['street'];//街道
            $realAddress = $address['address'];

            $res = db('m_users')->where('id',session('memid'))->update(['province'=>$province,'real_address'=>$realAddress]);

            if($res === false){
                return ['code'=>204,'data'=>'获取地理位置失败'];
            }

            session('province',$province);
            session('city',$city);
            session('realAddress',$realAddress);
            session('lat',$lat);
            session('lng',$lng);

        }
        return ['code'=>200,'data'=>$address];

    }

    //手动清除session cache
    public function clearSession(){
        session('brand_id',null);
        session('brandclass',null);
        session('appid',null);
        session('openid',null);
        session('shop_url',null);
        session('memid',null);
        session('userid',null);
        session('unionid',null);
        session('username',null);
        session('simg',null);
        session('sex',null);

        cache('all_brand_class_list',null);

        echo "清除缓存成功";die;
    }
}