<?php
/**
 * 客片大赏
 *
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 *
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Wangyining <Wangyining@suxuantech.cn>  2019年04月22日
 */
namespace app\front\lib;
use think\Controller;
use think\Session;
class Guestphoto extends Controller{

    /*
     * 根据分类id获取客片
     */
    public function getTypeList($type_id){

        $data = db('guest_photo')
            ->where('type_id',$type_id)
            ->where('status',1)
            ->order('sort asc')
            ->select();

        return $data;
    }

    /*
     * 根据分类获取客片分页数据
     */
    public function getTypePhotoData($type_id,$page,$limit,$tip_name){

        if($type_id){
            $where['type_id'] = $type_id;
        }

        if($tip_name){
            $where['content_text'] = $tip_name;
        }
        $data = db('guest_photo')
            ->where($where)
            ->where('status',1)
            ->where('brand_id',session('brand_id'))
            ->field('id,title,content_text,cover_img')
            ->order('sort asc')
            ->page($page,$limit)
            ->select();

        return $data;
    }

    /*
     * 新增客片
     */
    public function addGuestPhoto($params){
        $data = [
            'title' => $params['title'],
            'type_id'     => $params['type_id'],
            'cover_img'   => $params['cover_img'],
            'content_img' => json_encode($params['content_img']),
            'brand_id'    => session('brand_id'),
            'user_id'     => session('userid'),
            'create_time' => date('Y-m-d H:i:s'),
            'status' => 3,//未审核
        ];

        $res = db('guest_photo')->insert($data);
        if($res === false){
            return ['code'=>201,'msg'=>'上传客片失败，请稍后重试'];
        }else{
            return ['code'=>200,'msg'=>'success'];
        }


    }

}