<?php
/**
 * 前台相关读取数据处理类
 * 
 * ============================================================================
 * 版权所有 2017北京素玄科技，并保留所有权利。
 * 
 * 网站地址: http://www.suxuantech.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！未经允许的情况下，您不能对本系统代码做任何修改 .
 * 不允许对程序代码以任何形式任何目的的再发布。
 * 如有修改需求，请联系素玄科技有限公司：contact@suxuantech.cn
 * ============================================================================
 * Author: Lei Shao Ju <leishaoju@suxuantech.cn>  2017年11月27日 下午12:36:20
 */
namespace app\front\lib;
use think\Controller;
use app\vip\model\CCouponList;
use app\vip\model\CCouponNum;
use app\vip\model\UserLevel;
use think\Model;
use think\Session;
use think\cache;
use app\vip\model\MUsers;
//use app\index\controller\Base;

class Index extends Controller{

    /**
     * 方法描述: 获取一个用户的可用优惠券数据的总数
     * @param  array $c 查询条件 ，必须填写用户id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getUserCouponCount($userid,$status=false){
        if(!$userid){
            return false;
        }
        $w =['c.userid'=>$userid];
        if(false !== $status){
            $w['c.status'] = ['in',[0,4]];  //0和4 状态都为未消费
            if($status==0){ 
                $w['n.end_time'] = ['>',date('Y-m-d H:i:s',time())];
            }elseif($status==2){
                $w['n.end_time'] = ['<',date('Y-m-d H:i:s',time())];
            }else{
                $w['c.status']   = 1;
            }
        }
        //$addwhere = makeWhere($userid,$phoneid,'','c');
  
        $data = CCouponList::alias('c')
        ->where($w)
        ->join('__C_COUPON_NUM__ n','c.coupon_num_id=n.id','left')
        ->count('c.id');
                //->where('c.status',"in",[0,4])
        //echo db()->getLastSql();die;
        //echo $data;
        return $data;
    }
 
    /**
     * 方法描述     修改用户信息的方法
     * @param  array $d 用户数据，用户id必须
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function  setUserInfo($d){
        if(!$d || !$d['id']){
            return false;   
        }
        $memId = $d['id'];
        $phoneId = $d['phoneid'];
//        if($d['phoneid']){
//            $olddata = db('m_users_phone')->find($d['phoneid']);
//            $w = ['id'=>$d['phoneid']];
//        }else{
            $olddata = db('m_users')->find($d['id']);
            $w = ['id'=>$d['id']];
//        }
        if(!$olddata){
            return false;
        }
        $imgScore = $infoScore = $addscore = 0 ;
        // 判断是不是第一次修改头像 
        // $isFristSetImg = $d['simg'] && $olddata['simg'] && substr($olddata['simg'],0,4)=='http'?true:false;
 
        if(!$olddata['update_time']){
            $scoreRule = getScoreRule(['userid'=>$olddata['id'],'phoneid'=>$d['phoneid']]);
            $infoScore = $scoreRule && $scoreRule['perfectinfo']?$scoreRule['perfectinfo']:0;
            $ndata = [];
            
            // 判断是不是第一次设置头像
//             $imgScore  = $scoreNum && $scoreNum['headimg']?$scoreNum['headimg']:0;
//             if($isFristSetImg){
//                 $ndata[]  = ['m_title'=>'设置头像','m_num'=>$imgScore,'m_time'=>date('Y-m-d H:i:s',time()),'m_executor'=>$d['id'],'m_type'=>9];
//                 $addscore = $imgScore;
//             }
            // 判断是不是第一次修改资料
            if(!$olddata['update_time']){
                if($infoScore){
                    /*$ndata[] = [
                                'm_title'=>'修改资料',
                                'm_num'=>$infoScore,
                                'm_time'=>date('Y-m-d H:i:s',time()),
                                'm_executor'=>$d['id'],
                                'm_type'=>9,
                                'iswid'=>$d['phoneid']?0:1
                            ];*/
                    $addscore += $infoScore;
                }
                $d['update_time']  = date('Y-m-d',time());
            }
            //print_r($scorerule);
            //$addres = db("s_score_detail")->insertAll($ndata);
            
            // 获取总积分
            
            /*$sum = Session::get('total_score');
            Session::set('total_score',$sum+$addscore);
            // 记录积分日志
            if($ndata){
                $minuteDetailed = db('minute_log')->insertAll($ndata);
            }
            $d['total_score'] = ['exp',"total_score+".$addscore];*/
        }
        
        $tablename = $d['phoneid']?'m_users_phone':'m_users';
        unset($d['phoneid']);
        $cachekeyId = $d['id'];
        unset($d['id']);
        db()->startTrans();
        try{
            $res = db($tablename)->where($w)->update($d);
            if($res === false){
                db()->rollback();
                return false;
            }
            $score = AddScore($memId,$phoneId,$addscore,'9','修改资料');
            if($score === false){
                db()->rollback();
                return false;
            }
            db()->commit();
            self::clearUserinfoCache($cachekeyId);
            return true;
        }
        catch(\Exception $e){
                db()->rollback();    
                return false;
            }
    } 
    
    /**
     * 方法描述: 获取一个用户的所有优惠券
     * @param  array $c 查询条件,必须提供userid,status
     * @param  bool $istype 是否需要分类，分成已使用和未使用，已过期
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function  getCoupon($c){
        if(!$c && !$c['userid']){
            return false;
        }
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;
        
        $w =['c.userid'=>$c['userid']];
        if($c['status']==0){
            $w['c.status'] = 0;
            $w['c.expire_time'] = ['>',date('Y-m-d H:i:s',time())];
        }elseif($c['status']==2){
            $w['c.status'] = 0;
            $w['c.expire_time'] = ['<',date('Y-m-d H:i:s',time())];
        }else{
            $w['c.status'] = 1;
        }
        
        //$where = makeWhere($c['userid'],$c['phoneid'],'','c');
        $data = CCouponList::alias('c')
        ->field('c.id,c.coupon_code,n.money,c.condition_value,c.discount_type,c.discount_value,c.status,t.name as typename,c.expire_time,n.title,n.start_time,n.end_time,c.update_time,c.use_time,c.create_time')
        ->where($w)
        ->join('__C_COUPON_NUM__ n','c.coupon_num_id=n.id','left')
        ->join('__C_COUPON_TYPE__ t','n.coupon_typeid=t.id','left')
        ->limit($pagenum,$limit)
        ->select();
        //echo CCouponList::getLastSql();die;

        
        //echo CCouponList::getLastSql();
        // 如果status不存在,分解出所有类别，使用，未使用，已过期
//         if(false === $status){
//             foreach ($data as $k=>$v){
//                 if($v['status']==1){
//                     $d['use'][] = $v;
//                 }else if($v['status']==0 && $v['end_time']>=date('Y-m-d H:i:s',time())) {
//                     $d['noUse'][] = $v;
//                 }else{
//                     $d['expire'][] = $v;
//                 }
//             }
//             return $d;
//         }
//         print_r($data);
        return $data;
    }
    
    

    /**
     * 方法描述: 获取一个用户的所有优惠券
     * @param  array $c 查询条件,必须提供userid,status
     * @param  bool $istype 是否需要分类，分成已使用和未使用，已过期
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function  getCoupon2($c){
        if(!$c && !$c['userid']){
            return false;
        }
        $limit    = isset($c['limit'])?$c['limit']:5;
        $pagenum  = isset($c['page'])?($c['page']-1)*$limit:0;

        // $where =['c.userid' => $c['userid']];
        $fields = 'c.id,c.coupon_code,n.id as num_id,n.money,n.can_share,c.status,c.condition_value,c.discount_type,c.discount_value,t.name as typename,c.expire_time,c.use_time,n.title,n.start_time,n.end_time,c.update_time,c.create_time,c.name';
        $model = new CCouponList();
        // 读取使用的优惠券
//        $where = makeWhere($c['userid'],$c['phoneid'],'','c');
        $where = ['c.userid'=>$c['userid']];
        $d['use'] = $model->alias('c')
        ->field($fields)
        ->where('c.status=1')
        ->where($where)
        ->join('__C_COUPON_NUM__ n','c.coupon_num_id=n.id','left')
        ->join('__C_COUPON_TYPE__ t','n.coupon_typeid=t.id','left')
        ->limit($pagenum,$limit)
        ->select();
        // foreach($d['use'] as $k=>$v){
        //     if(strpos($v['convert_money'],',') !== false){
        //         $moneydata1 = explode(',',$v['convert_money']);
        //         $d['use'][$k]['convert_money'] = $moneydata1;
        //         $d['use'][$k]['convert_num'] = count($moneydata1);
        //     }
        // }
        //echo db()->getLastSql();
        // 计算页数
        $usetotal = $this->getUserCouponCount($c['userid'],1);
        $d['pagetotal']['use'] = $usetotal?ceil($usetotal/$limit):1;
       
        // 读取未使用的优惠券
        $w = ['c.expire_time' => ['>',date('Y-m-d H:i:s',time())]];
        $d['noUse'] = $model->alias('c')
        ->field($fields)        
        ->where($w)
        ->where('c.status',"in",[0,4])
        ->where($where)
        ->join('__C_COUPON_NUM__ n','c.coupon_num_id=n.id','left')
        ->join('__C_COUPON_TYPE__ t','n.coupon_typeid=t.id','left')
        ->limit($pagenum,$limit)
        ->select();
        // foreach($d['noUse'] as $k=>$v){
        //     if(strpos($v['convert_money'],',') !== false){
        //         $moneydata2 = explode(',',$v['convert_money']);
        //         $d['noUse'][$k]['convert_money'] = $moneydata2;  
        //         $d['noUse'][$k]['convert_num'] = count($moneydata2);
        //     }
        // }
        //echo db()->getLastSql();
        // 计算页数
        $nousetotal = $this->getUserCouponCount($c['userid'],0);
        $d['pagetotal']['noUse'] = $nousetotal?ceil($nousetotal/$limit):1;

        // 读取已过期的优惠券
        $w = ['c.status'=>0 ,'c.expire_time' => ['<',date('Y-m-d H:i:s',time())]];
        $d['expire'] =$model->alias('c')
        ->field($fields)
        ->where($w)
        ->where($where)
        ->join('__C_COUPON_NUM__ n','c.coupon_num_id=n.id','left')
        ->join('__C_COUPON_TYPE__ t','n.coupon_typeid=t.id','left')
        ->limit($pagenum,$limit)
        ->select();
        // foreach($d['expire'] as $k=>$v){
        //     if(strpos($v['convert_money'],',') !== false){
        //         $moneydata3 = explode(',',$v['convert_money']);
        //         $d['expire'][$k]['convert_money'] = $moneydata3;
        //         $d['expire'][$k]['convert_num'] = count($moneydata3);
        //     }
        // }

        // 读取已分享的优惠券
        $w = ['c.status'=>3];
        $d['share'] =$model->alias('c')
        ->field($fields)
        ->where($w)
        ->where($where)
        ->join('__C_COUPON_NUM__ n','c.coupon_num_id=n.id','left')
        ->join('__C_COUPON_TYPE__ t','n.coupon_typeid=t.id','left')
        ->limit($pagenum,$limit)
        ->select();
        // foreach($d['expire'] as $k=>$v){
        //     if(strpos($v['convert_money'],',') !== false){
        //         $moneydata3 = explode(',',$v['convert_money']);
        //         $d['expire'][$k]['convert_money'] = $moneydata3;
        //         $d['expire'][$k]['convert_num'] = count($moneydata3);
        //     }
        // }
        //echo db()->getLastSql();
        // 计算页数
        $expiretotal = $this->getUserCouponCount($c['userid'],2);
        $d['pagetotal']['expire'] = $expiretotal?ceil($expiretotal/$limit):1;
        
        return $d;
    }
    
    /**
     * 方法描述     查询投诉建议页面头部的广告
     * @param  string 名称
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月29日 下午2:23:16
     */
    public function getAdv($id){
        $brandid = Session::get('brand_id');
        $w = ['brandid'=>$brandid,'adv_seat'=>$id,'adv_status'=>1];
        $res = Db('advertising')->where($w)->find();
        return $res?json_decode($res['adv_detail'],true):'';
    }
    /**
     * 方法描述： 获取客服信息
     * @param  type 获取数据类型
     * @return [type] [description]
     */
    public function getKf($type){

        if(!empty($type)){
            if($type == 'url'){
                $kf_url=db('c_kf')->where('brandid',Session::get('brand_id'))->value('url');    
            }else if($type == 'phone'){
                $kf_url=db('c_kf')->where('brandid',Session::get('brand_id'))->value('phone');    
            }
        }else{
            $kf_url = db('c_kf')->where('brandid',Session::get('brand_id'))->find();
        }

        return $kf_url?$kf_url:'#'; 
    }

    /**
     * 方法描述     添加投诉建议
     * @param  array $d 要添加的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月29日 下午2:23:16
     */
    public function addFeedback($d){
        if(!$d || !$d['userid'] || (!$d['content'] && !$d['imgs'])){
            return false;
        }
        $res = Db('user_commend')->insert($d);
        $data = db('user_commend')->getLastInsID();
        return $data;
    }

    /**
     * 方法描述     添加分享的数据
     * @param  array $d 要添加的数据
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月29日 下午2:23:16
     */
    public function addShare($d){
        $phoneid = $d['phoneid'];
        if(!$d || !$d['userid'] || (!$d['shareid'] && !$d['share_url'])){
            return false;
        }
       
        if(!$d['create_time']){
            $d['create_time'] = date('Y-m-d H:i:s',time());
        }
    
        // 判断当前的活动或者任务的是否有分享积分
        $score = 0;
 
        if(isset($d['sourceid'])){
            $info  = $this->getShareScore($d['shareid'],$d['sourceid']);
            $score = (int)$info['share_score'];
//            if($score){
//                $addscore = $this->addShareScore($d['userid'], $score,$d['phoneid']);
//                if(!$addscore){
//                    return false;
//                }
//            }
            $d['score'] = $score;
        }

        // 获取总积分
 
        // 记录积分日志
        if($d['sourceid']==1){
            $logName = '分享"'.$info['title'].'"活动';
            $logtypeid = 11;
        }elseif($d['sourceid']==2){
            $logName  =  '分享"'.$info['title'].'"任务';
            $logtypeid = 12;
        }elseif($d['sourceid']==3){
            $logName  =  '分享"'.$info['help_name'].'"助力活动';
            $logtypeid = 13;
        }
         
        // 判断是否已经领取过了今天
        $time     = date('Y-m-d',time());
        $where = ['sourceid'=>$d['sourceid'],'shareid'=>$d['shareid'],'userid'=>$d['userid'],'create_time'=>['>=',$time]];
        $has = db('share_detail')->where($where)->find();

        if($score && !$has){


            $sum = Session::get('total_score');
            Session::set('total_score',$sum+$score);
             // 添加积分记录
             $ndata[] = [
                            'm_title'=> $logName,
                            'm_num'  => $score,
                            'm_time' => date('Y-m-d H:i:s',time()),
                            'm_executor'=> $d['userid'],
                            'm_type' => $logtypeid,
                            'iswid'  => $d['phoneid']?0:1
                        ];
            $minuteDetailed = db('minute_log')->insertAll($ndata);
            $addscore = $this->addShareScore($d['userid'], $score,$d['phoneid']);

        }
        // 插入分享记录
        $d['iswid'] = $d['phoneid']?0:1;
        unset($d['phoneid']);


        // 11 代表分享活动 12 代表分享任务
        // 处理是否给加成长值
    
        if(!$has){
            $gro    = getGrowthRule(['userid'=>$d['userid']]);
            //var_dump($gro);die;
            if($gro && $gro['share']){
                
                growthDetailed($d['userid'],$gro['share'],$logtypeid,$d['shareid'],$phoneid);
            }
        }
        $res   = db('share_detail')->insert($d);
        $score = $has?'':$score;
        return $res?$score:false;
        
    }
    
    /**
     * 方法描述    获取一个活动或者任务是否有分享积分，并返回积分数据
     * @param  int $id 活动的id
     * @param  int $ourceid 来源id,1表示活动2表示任务
     * @param  int $phoneid 手机表里id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月29日 下午2:23:16
     */
    public function getShareScore($id,$sourceid){
      
        if(!$id){
            return false;
        }
        // 判断当前的活动或者任务的是否有分享积分
        if($sourceid!==null){
            if($sourceid==1)  $tbname='a_activity_list';
            if($sourceid==2)  $tbname='t_task_list';
            if($sourceid==3)  $tbname='wx_help';
            //$tbname = $sourceid==1?'a_activity_list':'t_task_list';
            $data = db($tbname)->find($id);
            return $data;
        }

        return false;
    }
    
    /**
     * 方法描述     分享成功后给用户增加积分
     * @param  int $userid 用户的id
     * @param  int $score  积分数量
     * @param  int $phoneid 手机表里的id
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月29日 下午2:23:16
     */
    public function addShareScore($userid,$score,$phoneid){
    
        if(!$userid || !$score){
            return false;
        }
        $w = ['id'=>$phoneid?$phoneid:$userid];
        $tablename = $phoneid?'m_users_phone':'m_users';
        $res = db($tablename)->where($w)->setInc('total_score',$score);
        return $res?true:false;
        
    }
   
    /**
     * 方法描述： 领取优惠券，并生成优惠码入库
     * @param  array $d 数据userid和coupounum优惠券批次号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月04日 下午12:47:22
     */
    public function getReceive($d){
        $model = new CCouponNum();
        // 查询优惠券批次信息
        $data  = $model->where(['id'=>$d['coupon_num'],'status'=>1])->find();
        if($data && ($data['total_num'] - $data['receive_total'])>0){
            // 判断每人可领取的数量
            if(($d['status'] != 5 && !$d['is_shareholder']) || ($d['is_shareholder']!=1 && !$d['status'])){
                if($data['each_max_total']!==0){
                    // 查询用户是否已经领取
                    //$where = makeWhere($d['userid'],$d['phoneid']);
                    //$alreadyReceive  = CCouponList::where(['coupon_num_id'=>$d['coupon_num']])->where(['userid'=>$d['userid'],'activityid'=>$d['activityid']])->count();
                    $alreadyReceive  = CCouponList::where(['coupon_num_id'=>$d['coupon_num']])->where(['userid'=>$d['userid']])->where('share_userid is null')->count();
                    if($alreadyReceive && $alreadyReceive >= $data['each_max_total']){
                        return json_encode(['status'=>0,'msg'=>'每人最多领取此优惠券【'.$data['title'].'】'.$data['each_max_total'].'张,不可以在领取了,去使用吧']);
                    }
                }
            }
            // 生成优惠券码,随机取8位+时间戳后几位,去掉4和7的数据
            $str = 'ABCDEFGHJKMNPQRSTUVWXYZ0125689';
            $couponid = substr(str_shuffle($str),0,8).''.substr(time(),5);
            $couponid = preg_replace('/4|7/',8, $couponid);
            $newdata  = [
                'userid'         => $d['userid'],
                'name'           => $data['title'],
                'coupon_num_id'  => $d['coupon_num'],
                'coupon_code'    => $couponid,
                'create_time'    => date('Y-m-d H:i:s',time()),
                'iswid'          => $d['phoneid']?0:1,
                'activityid'     => $d['activityid'],
                'discount_type'  => $data['discount_type'],
                'discount_value' => $data['money'],
                'condition_value'=> $data['min_consume'],
                'expire_time'    => $data['expire_time']==0?$data['end_time']:date('Y-m-d H:i:s',(time()+$data['expire_time']*86400)),
                'product_info'   => $data['product_info'],//erp产品信息
                'package_ids'    => $data['package_ids'], //适用套系
                'brandid'        => Session::get('brand_id'),
            ];
            if($d['status']){
                $newdata['status'] = $d['status'];
            }
            if($d['share_phone']){
                $newdata['share_phone'] = $d['share_phone'];
            }
            if($d['share_userid']){
                $newdata['share_userid'] = $d['share_userid'];
            }
            // 插入数据库，更新list表和couponnum表
            //$res = CCouponList::insert($newdata);
            $res = db('c_coupon_list')->insert($newdata);
            if($res === false){
                return json_encode(['status'=>0,'msg'=>'添加数据库失败']);
            }
            if($d['status'] != 5){

                $upcouponnum = $model->where('id='.$data['id'])->update(['receive_total'=> $data['receive_total']+1]);
                if($upcouponnum === false){
                    return json_encode(['status'=>0,'msg'=>'更改优惠券领取数量失败']);
                }
            }
            return json_encode(['status'=>1,'msg'=>'成功','id'=>$couponid]);
        }else{
            return json_encode(['status'=>0,'msg'=>'优惠券总数量不足，不能再领取']);

        }

    }

    /**
     * 生日优惠券领取
     * @param  [type] $d [description]
     * @return [type]    [description]
     */
    public function getBrithdayReceive($d){
        $model = new CCouponNum();
        // 查询优惠券批次信息
        $data = $model->where(['id'=>$d['coupon_num'],'status'=>1])->find();
        if($data && ($data['total_num'] - $data['receive_total'])>0){
            // 生成优惠券码,随机取8位+时间戳后几位,去掉4和7的数据
            $str = 'ABCDEFGHJKMNPQRSTUVWXYZ0125689';
            $couponid = substr(str_shuffle($str),0,8).''.substr(time(),5);
            $couponid = preg_replace('/4|7/',8, $couponid);
            $newdata  = [
                'userid'         => $d['userid'],
                'name'           => $data['title'],
                'coupon_num_id'  => $d['coupon_num'],
                'coupon_code'    => $couponid,
                'create_time'    => date('Y-m-d H:i:s',time()),
                'iswid'          => $d['phoneid']?0:1,
                'activityid'     => $d['activityid'],
                'discount_type'  => $data['discount_type'],
                'discount_value' => $data['money'],
                'condition_value'=> $data['min_consume'],
                'expire_time'    => $data['expire_time']==0?$data['end_time']:date('Y-m-d H:i:s',(time()+$data['expire_time']*86400)),
                'product_info'   => $data['product_info'],//erp产品信息
                'package_ids'    => $data['package_ids'],//适用套系
            ];
            if($d['status']){
                $newdata['status'] = $d['status'];
            }
            if($d['share_phone']){
                $newdata['share_phone'] = $d['share_phone'];
            }
            if($d['share_userid']){
                $newdata['share_userid'] = $d['share_userid'];
            }
            // 插入数据库，更新list表和couponnum表
            //$res = CCouponList::insert($newdata);
            $res = db('c_coupon_list')->insert($newdata);
            if($res === false){
                return json_encode(['status'=>0,'msg'=>'添加数据库失败']);
            }
            if($d['status'] != 5){
                $upcouponnum = $model->where('id='.$data['id'])->update(['receive_total'=> $data['receive_total']+1]);
                if($upcouponnum === false){
                    return json_encode(['status'=>0,'msg'=>'更改优惠券领取数量失败']);
                }
            }
            return json_encode(['status'=>1,'msg'=>'成功','id'=>$couponid]);
        }else{
            return json_encode(['status'=>0,'msg'=>'优惠券总数量不足，不能再领取']);
        }

    }
    /**
     * 方法描述   获取一条优惠券的详细信息
     * @param  array $c userid和coupouid优惠券批次号
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年12月04日 下午12:47:22
     */
    public function getOneCoupon($c){
        if(!$c || !$c['userid'] || !$c['coupon_num']){
            return false;
        }

        // 查询优惠券批次信息
        $data  = CCouponNum::where(['id'=>$c['coupon_num'],['status']=>1])->find();
        return $data?$data:false;
    }
    
    
    /**
     * 方法描述     获取一个用户的信息
     * @param  array $d 必须单元：userid 或者 phone+brandid ;可选单元字段：fields 是要返回的字段用','分隔的字符串，如$data['fields'] ='userid,phone';
     * @param  return array;
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年01月02日 下午12:47:22
     */
    public function getUserInfo($d){
        if(!$d){
            return false;
        }
        $cacheid = '';
        if($d['phone'] && $d['brandid']){
            $cacheid = $d['brandid'].'_'.$d['phone'];
        }else if($d['userid']){
            $cacheid = $d['userid'];
        }
        $phoneFields = 'id,growth_value,total_score,phone,brandid,userid';
        $usersFields = 'id,money,growth_value,total_sign,total_score,username,simg,openid,create_time,phone,last_land_time,brandid,merryday,brithday';
        $userinfo = cache($cacheid.'_userinfo');
        if(!$userinfo){
            if($d['phone'] && $d['brandid']){
                $w = ['phone'=>$d['phone']];
                $files = $d['fields']?$d['fields']:$phoneFields;
                $userinfo = db('m_users_phone')->field($files)->where($w)->find();
                if($userinfo){
                    if($userinfo['userid']){
                        $files = $d['fields']?$d['fields']:$usersFields;
                        $userinfo = db('m_users')->field($files)->where(['id'=>$userinfo['userid'],'brandid'=>$d['brandid']])->find();
                    }else{
                        $userinfo = $userinfo['brandid']==$d['brandid']?$userinfo:false;
                    }
                    if(!$d['fields']){
                        cache($cacheid.'_userinfo',$userinfo);
                    }
                    return $userinfo;
                }
                return false;
            }elseif($d['userid']){
                $files = $d['fields']?$d['fields']:$usersFields;
                $userinfo = db('m_users')->field($files)->where(['id'=>$d['userid']])->find();
                if($userinfo && !$d['fields']){
                    cache($d['userid'].'_userinfo',$userinfo);
                }
                return $userinfo?$userinfo:false;
            }
            return false;
        }
        return $userinfo;
    }
    
    
    /**
     * 方法描述    清空用户信息的cache
     * @param  int $userid
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2018年1月4日 上午11:52:09
     */
    public function clearUserinfoCache($userid){
        cache::rm('userinfo_'.$userid);
    }
    
    
    
    /**
     * 方法描述: 获取任务所有数据
     * @param  string $c 是查询条件
     * 必须：brandid品牌id,isenjoy存在表示查询尊享活动，如果isenjoy存在 levelid是必须,
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTaskList($c){
        if(!$c && !$c['brandid']){
            return false;
        }
        $limit    = $c['limit']?$c['limit']:10;
        $pagenum  = $c['page']?($c['page']-1)*$limit:0;
        $w = ['status'=> 1, 'brandid' => $c['brandid']];
        // 判断当前查看是不是尊享的活动
        $w2 = [];
        $order = 'create_time desc';
        if($c['reward_score']){
            $w['reward_score'] = $c['reward_score'];
          
        }
        if($c['days']){
            $w['days']   = $c['days'];
        }
        if(isset($c['typeid'])){
            $w['typeid'] = (int)($c['typeid'] == 3?0:$c['typeid']);
        }
        
        if($c['order']){
            $order = 'receive_total desc';
        }
        $d = db('t_task_list')->where($w)
                ->field('title,id,days,typeid,index_img,reward_score,share_score,start_time,end_time')
                ->order($order)
                ->limit($pagenum,$limit)
                ->select();
        //echo db()->getLastSql();die;
                return $d;
      
    }
    
    /**
     * 方法描述: 获取任务数据的总数
     * @param  string $c 是查询条件
     * @return mixed
     * @author Leishaoju<leishaoju@suxuantech.cn> 2017年11月14日 下午3:04:46
     */
    public function getTaskCount($c){

        if(!$c && !$c['brandid']){
            return false;
        }
  
        $w = ['status'=> 1, 'brandid' => $c['brandid']];
        // 判断当前查看是不是尊享的活动
        $w2 = [];
        $order = 'create_time desc';
        if($c['reward_score']){
            $w['reward_score'] = $c['reward_score'];
            $order = 'receive_total desc';
        }
        if($c['days']){
            $w['days']   = $c['days'];
        }
        if(isset($c['typeid'])){
            $w['typeid'] = (int)($c['typeid'] == 3?0:$c['typeid']);
        }
        $d = db('t_task_list')->where($w)->count('id');
        return $d;

    }
    /**
     * 方法描述: 会员权益获取默认事业部值
     * @param unknown $brandId
     * @return Ambigous <Ambigous <PDOStatement, multitype:>>|mixed
     */
    public function getBereq($id){
    /****************************************************************************
     * 废弃
     ****************************************************************************/
        // $key = "brand_bereq";
        // $data = cache($key);
        // if(empty($data)){
        //     $dbdata = db("membereq")->select();
        //     foreach($dbdata as $k=>$v){
        //         $data[$v['brandid']][] = $v;
        //     }
        //     if(!empty($data)){
        //         cache($key,$data);
        //     }
        // }
        // if($data[$brandId]){
        //     return $data[$brandId];
        // }else{
        //     return array_shift($data);
        // }
    /**************************************************************************/
        $w = [];
        if($id){
            $w['eq_card_type'] = $id;    
        }
        $dbdata = db("membereq")->where($w)->select();
        if($dbdata){
            return $dbdata;
        }else{
            return false;
        }
    }
    /**
     * 方法描述：团购拼团算法
     * @return Ambigous <Ambigous <PDOStatement, multitype:>>|mixed
     * @author Zhaojiepeng<Zhaojiepeng@suxuantech.cn> 2018年4月16日 13:19:38
     */
    public function groupbuy($groupbuy_id,$user_id){
    	$a['groupbuy_id'] = $groupbuy_id;
    	$a['pay_status']  = 1;
    	$groupuserCount = db("group_user")
    	                   ->where($a)
    	                   ->count();
    	$groupbuyArr = db("group_buy")
    	               ->alias("b")
    	               ->where("b.id",$groupbuy_id)
    	               ->join("group_activity a","a.id=b.activity_id")
    	               ->find();
        if($groupuserCount > $groupbuyArr['user_require']){//当前拼团人数大于最低要求
    	    $b2['status'] = 1;
    	    $d['groupbuy_id'] = $groupbuy_id;
    	    $d['user_id'] = $user_id;
    	    $res = db("group_user")->where($d)->update($b2);
    	    if($res){
        		$userArr = db("group_user")
        		              ->alias("u")
        		              ->where($d)
        		              ->join("group_buy b","b.id=u.groupbuy_id")
        		              ->join("group_activity a","b.activity_id=a.id")
        		              ->field("u.user_id,a.couponid,b.activity_id")
        		              ->find();
        		$phoneArr2 = db("m_users_phone")->where("userid",$user_id)->field('id')->find();
        		$data2 = [
        	            'userid'     => $user_id,
        	            'coupon_num' => $userArr['couponid'],
        	            'phoneid'    => $phoneArr2['id'],
        	            'activityid' => $userArr['activity_id'],
    	            ];
                $f = $this->getReceive($data2); //调用优惠券领取
                return $f;
    	    }
    	}elseif($groupuserCount = $groupbuyArr['user_require']){//当前拼团人数等于最低要求
    		$b['status'] = 1;
    	    $res = db("group_user")->where($a)->update($b);
    	    if($res || $res === 0){
    	        $c['u.groupbuy_id'] = $groupbuy_id;
    	        $c['u.pay_status']  = 1;
    	        $groupuserArr = db("group_user")
    	                           ->alias("u")
    	                           ->where($c)
    	                           ->join("group_buy b","b.id=u.groupbuy_id")
    	                           ->join("group_activity a","b.activity_id=a.id")
    	                           ->field("u.user_id,a.couponid,b.activity_id")
    	                           ->select();
    	   
    	        foreach($groupuserArr as $k=>$v){
    	            $phoneArr = db("m_users_phone")->where("userid",$v['user_id'])->find();
    	            $data = [
        	            'userid'    => $v['user_id'],
        	            'coupon_num'=> $v['couponid'],
        	            'phoneid'   => $phoneArr['id'],
        	            'activityid'=> $v['activity_id'],
    	            ];
    	            $d = $this->getReceive($data); //调用优惠券领取
    	        }	
    	        return $d;
    	    }
    	}elseif($groupuserCount < $groupbuyArr['user_require']){//当前拼团人数小于最低要求
            return json_encode(['status'=>2,'msg'=>"待成团"]);
    	}   	
    }
    /*
     * 获取产品分类
     * */
    public function getCat($bid){
        $where['is_delete'] = 1;
        $where['status'] = 1;
        if($bid) $where['brandclass_id'] = $bid;
        $info = db('s_cat')->where($where)->order('sort')->select();
        return $info;
    }
    /**
     * 方法描述：获取会员等级数据
     */
    public function GetUserLevel(){
        $res = db('user_level')->select();
        if($res){
            return $res;
        }else{
            return false;
        }
    }
}