<?php 
namespace app\front\lib;
 
class Rili{ 
    protected $_table;//table表格 
    protected $_currentDate;//当前日期 
    protected $_year; //年 
    protected $_month; //月 
    protected $next_mon;  //下一月
    protected $pre_mon;   //上一月
    protected $pre_year;  //上一年
    protected $next_year; //下一年
    protected $_days; //给定的月份应有的天数 
    protected $_dayofweek;//给定月份的 1号 是星期几
    public $_data;
    /** 
    * 构造函数 
    */ 
    public function __construct($data)
    { 
        $this->_table=""; 
        $this->_year = isset($_GET["y"])?$_GET["y"]:date("Y"); 
        $this->_month = isset($_GET["m"])?$_GET["m"]:date("m"); 
        // 计算下个月
        $this->next_mon = $this->_month+1;
        $this->pre_mon  = $this->_month-1;
        if($this->next_mon==13){
            $this->next_mon  = 1;
            $this->next_year = $this->_year+1;
        }else{
            $this->next_year = $this->_year;
        }
        if($this->pre_mon==0){
            $this->pre_mon  = 12;
            $this->pre_year = $this->_year-1;
        }else{
            $this->pre_year = $this->_year;
        }
        $this->_currentDate = $this->_year.'年'.$this->_month.'月份';//当前得到的日期信息 
        $this->_days = date("t",mktime(0,0,0,$this->_month,1,$this->_year));//得到给定的月份应有的天数 
        $this->_dayofweek = date("w",mktime(0,0,0,$this->_month,1,$this->_year));//得到给定的月份的 1号 是星期几
        $this->_data = $data;
    } 
    /** 
    * 输出标题和表头信息 
    */ 
    protected function _showTitle() 
    {    

        $this->_table.="<div class=\"luck_top\">
					<a href='?y=".$this->pre_year."&m=".$this->pre_mon."'><span class=\"mui-icon mui-icon-arrowleft\"></span></a>
					<span class=\"luck_title\">".$this->_year."年".$this->_month."月</span>
					<a href='?y=".$this->next_year."&m=".$this->next_mon."'><span class=\"mui-icon mui-icon-arrowright\"></span></a>
				</div>
					<div class=\"thead_con\">
						<table cellspacing=\"0\" cellpadding=\"0\" class=\"luck_table\">
							<tbody>
								<tr>
									<th>日</th>
									<th>一</th>
									<th>二</th>
									<th>三</th>
									<th>四</th>
									<th>五</th>
									<th>六</th>
								</tr>
							</tbody>
						</table>
					</div>";

    }

    protected function _showDate() {
  
        $startDateTime = strtotime($this->_year.'-'.$this->_month.'-01') - 86400;
        $startWeek = $this->_dayofweek == 0?$startWeek = 7:$this->_dayofweek;
        $startWeek--;
        $preStart = date('d',$startDateTime) - $startWeek;
        $startDate = date('Y-m-',$startDateTime).sprintf("%'.02d",$preStart);
        //echo $startDate;die;
        $nextMonthStart = strtotime('+1 month',strtotime($this->_year.'-'.$this->_month.'-01'));
        $nw = date('w',$nextMonthStart);
        $endDay = 7 - $nw;
        $endDate = date('Y-m-',$nextMonthStart).sprintf("%'.02d",$endDay);
        $doDate = $startDate;
        $this->_table.= "<table cellspacing=\"0\" cellpadding=\"0\" class=\"luck_table\"><tbody><tr>";
        $html = '';
        do{
            $html .= $this->_getDayHtml($doDate);
            $doDate = date('Y-m-d',strtotime('+1 day',strtotime($doDate)));
        }while(strtotime($doDate) <= strtotime($endDate));

        $this->_table .= $html;
        if(strpos($this->_table,-4) == '<tr>'){
            $this->_table = trim($this->_table,'<tr>');
        }
        $this->_table.="</tbody></table></div></div>";

    }
    protected function _getDayHtml($date){
        $html   = ''; 
        $dateTime = strtotime($date);
        $nums = date("w",strtotime($date))+1;
        $datestr =$this->_year.'-'.date('m-d',$dateTime);
        //当天当天日期样式
        if(date('Y-m-d') == $date){
            $thisClass = 'day-signed';  
        }
        // 计算这天的月份
        $thisdayYearMonth = substr($datestr,0,7);
        $thisMonth = (int)$this->_month;
        $zeroMonth = $thisMonth<10?'0'.$thisMonth:$thisMonth;
        if(strtotime($date) < strtotime(date('Y-m-d'))){
            $thisClass = 'repair';
            if(in_array((int)date('d',$dateTime),$this->_data)){
                 if($thisdayYearMonth!=($this->_year.'-'.$zeroMonth)){
                     $thisClass   = '';
                     $inClass = 'gray-date';
                 }else{
                     $thisClass = 'day-signed';//今天之前已签到的
                     $inClass = 'current-day';
                 }
            }else{
                if($thisdayYearMonth!=($this->_year.'-'.$zeroMonth)){
                    $thisClass   = '';
                    $inClass = 'gray-date';
                }
            }
        }else{
            if($thisdayYearMonth!=($this->_year.'-'.$zeroMonth)){
                $inClass = 'gray-date';
            }
        }

        $inHtml =  '<div class="solar'.$inClass.'" data-data="'.$datestr.'">'.date('d',$dateTime).'</div>';
        if($thisClass == 'repair'){
            $str = '<div class="repair-sign">补</div>';
        }
        if (7 == $nums){
            $html='<td><div class="day '.$thisClass.'">'.$inHtml.$str.'</div></td></tr><tr>';
        }else{
            $html='<td><div class="day '.$thisClass.'">'.$inHtml.$str.'</div></td>';
        }
        return $html;
    }
    /** 
    * 输出日期信息 
    * 根据当前日期输出日期信息 
    */ 
//     protected function _showDate_old()
//     {   
//         $nums=$this->_dayofweek+1;
//         $this->_table.= "<table cellspacing=\"0\" cellpadding=\"0\" class=\"luck_table\"><tbody><tr>";
//         $preEnd = date('d',strtotime($this->_year.'-'.$this->_month.'-01') - 86400);
//         $preStart = $preEnd - ($this->_dayofweek - 1);
//         for ($i=1;$i<=$this->_dayofweek;$i++){//输出1号之前的空白日期 
//             $this->_table.="<td > {$preStart}</td>";
//             $preStart++;
//         }
//         for ($i=1;$i<=$this->_days;$i++){//输出天数信息
//             $thisClass = "";
//             $ii = sprintf("%'.02d",$i);
//             if(date('Y-m-d') == $this->_year.'-'.$this->_month.'-'.$ii){
//                 //当天
//                 $strShow = '<div class="solar current-day" >'.$i.'</div>';
//             }else{
//                 $strShow = '<div class="solar" >'.$i.'</div>';
//             }

//             $nums = date("w",strtotime(($this->_year.'-'.$this->_month.'-'.$ii)))+1;

//             if(strtotime($this->_year.'-'.$this->_month.'-'.$ii) < strtotime(date('Y-m-d'))){
//                 //没过当天
//                 if(in_array($i,$this->_data)){
//                     $thisClass = 'day-signed';
//                 }else {
//                     $thisClass = 'repair';
//                     $strShow .=  '<div class="repair-sign">补</div>';
//                 }
//             }

//             if (7 == $nums){//换行处理：7个一行
//                 $this->_table.='<td><div class="day '.$thisClass.'">'.$strShow.'</div></td></tr><tr>';
//             }else{
//                 $this->_table.='<td><div class="day '.$thisClass.'">'.$strShow.'</div></td>';
//             }
//         }

//         $nextI = 1;
//         for($x=$nums;$x<7;$x++){
//             $this->_table .= '<td> '.$nextI.' </td>';
//             if(6 == $x){
//                 $this->_table .= '</tr>';
//             }
//             $nextI++;
//         }
//         if(strpos($this->_table,-4) == '<tr>'){
//             $this->_table = trim($this->_table,'<tr>');
//         }
//         $this->_table.="</tbody></table></div></div>";
//     } 
    
    /** 
    * 输出日历 
    */ 
    public function showCalendar() 
    { 
        $this->_showTitle(); 
        $this->_showDate(); 
        return  $this->_table; 
    } 
} 
 
 
?>